prsm_data =
{
    "prsm": {
        "prsm_id": "16",
        "p_value": "1.06e-05",
        "e_value": "1.06e-05",
        "fdr": "0",
        "matched_fragment_number": "10",
        "matched_peak_number": "11",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                "ms1_ids": "513",
                "ms1_scans": "560",
                "ids": "46",
                "scans": "561",
                "precursor_mono_mass": "8772.6535",
                "precursor_charge": "9",
                "precursor_mz": "975.7466",
                "feature_inte": "1.6404e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "46",
                        "peak_id": "0",
                        "monoisotopic_mass": "1019.4750",
                        "monoisotopic_mz": "1020.4822",
                        "intensity": "1883.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "1",
                        "monoisotopic_mass": "1776.8603",
                        "monoisotopic_mz": "1777.8676",
                        "intensity": "1718.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "2",
                        "monoisotopic_mass": "1499.7785",
                        "monoisotopic_mz": "1500.7858",
                        "intensity": "1053.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "3",
                        "monoisotopic_mass": "2031.9714",
                        "monoisotopic_mz": "2032.9787",
                        "intensity": "4878.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "4",
                        "monoisotopic_mass": "1730.7730",
                        "monoisotopic_mz": "1731.7803",
                        "intensity": "1938.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "5",
                        "monoisotopic_mass": "1562.7437",
                        "monoisotopic_mz": "1563.7510",
                        "intensity": "4760.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "6",
                        "monoisotopic_mass": "1424.5275",
                        "monoisotopic_mz": "1425.5348",
                        "intensity": "2263.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "7",
                        "monoisotopic_mass": "950.5115",
                        "monoisotopic_mz": "951.5188",
                        "intensity": "7613.14",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "950.5073",
                                "ion_position": "75",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "75",
                                "mass_error": "0.0042",
                                "ppm": "4.44"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "8",
                        "monoisotopic_mass": "1407.6429",
                        "monoisotopic_mz": "1408.6501",
                        "intensity": "1679.64",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "9",
                        "monoisotopic_mass": "1006.6330",
                        "monoisotopic_mz": "1007.6403",
                        "intensity": "10216.80",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1006.6287",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "0.0043",
                                "ppm": "4.26"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "10",
                        "monoisotopic_mass": "1079.5861",
                        "monoisotopic_mz": "1080.5934",
                        "intensity": "1292.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "11",
                        "monoisotopic_mass": "1325.8198",
                        "monoisotopic_mz": "1326.8270",
                        "intensity": "3179.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "12",
                        "monoisotopic_mass": "896.5384",
                        "monoisotopic_mz": "897.5457",
                        "intensity": "10768.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "13",
                        "monoisotopic_mass": "2550.2975",
                        "monoisotopic_mz": "851.1064",
                        "intensity": "6079.06",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "14",
                        "monoisotopic_mass": "2522.3032",
                        "monoisotopic_mz": "841.7750",
                        "intensity": "9357.77",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "15",
                        "monoisotopic_mass": "1684.8917",
                        "monoisotopic_mz": "843.4531",
                        "intensity": "2758.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "16",
                        "monoisotopic_mass": "1298.6628",
                        "monoisotopic_mz": "1299.6700",
                        "intensity": "2564.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "17",
                        "monoisotopic_mass": "837.4268",
                        "monoisotopic_mz": "838.4341",
                        "intensity": "13576.37",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "837.4232",
                                "ion_position": "76",
                                "ion_display_position": "8",
                                "ion_sort_name": "Y00008",
                                "ion_left_position": "76",
                                "mass_error": "0.0036",
                                "ppm": "4.27"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "18",
                        "monoisotopic_mass": "2663.3825",
                        "monoisotopic_mz": "888.8014",
                        "intensity": "4788.12",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "19",
                        "monoisotopic_mass": "2298.2140",
                        "monoisotopic_mz": "1150.1143",
                        "intensity": "6525.42",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "20",
                        "monoisotopic_mass": "2326.2081",
                        "monoisotopic_mz": "1164.1113",
                        "intensity": "11426.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "21",
                        "monoisotopic_mass": "2413.2391",
                        "monoisotopic_mz": "1207.6268",
                        "intensity": "17932.59",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "22",
                        "monoisotopic_mass": "1636.8498",
                        "monoisotopic_mz": "819.4322",
                        "intensity": "4649.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "23",
                        "monoisotopic_mass": "1049.5816",
                        "monoisotopic_mz": "1050.5889",
                        "intensity": "2163.27",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1049.5757",
                                "ion_position": "74",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "74",
                                "mass_error": "0.0059",
                                "ppm": "5.60"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "24",
                        "monoisotopic_mass": "2922.5778",
                        "monoisotopic_mz": "975.1999",
                        "intensity": "31955.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "25",
                        "monoisotopic_mass": "711.4423",
                        "monoisotopic_mz": "712.4496",
                        "intensity": "6821.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "26",
                        "monoisotopic_mass": "681.3364",
                        "monoisotopic_mz": "682.3436",
                        "intensity": "6911.98",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "681.3334",
                                "ion_position": "78",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "78",
                                "mass_error": "0.0030",
                                "ppm": "4.40"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "27",
                        "monoisotopic_mass": "810.5116",
                        "monoisotopic_mz": "811.5189",
                        "intensity": "2142.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "28",
                        "monoisotopic_mass": "1597.8184",
                        "monoisotopic_mz": "1598.8257",
                        "intensity": "1761.47",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "29",
                        "monoisotopic_mass": "2904.5599",
                        "monoisotopic_mz": "969.1939",
                        "intensity": "4875.25",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "30",
                        "monoisotopic_mass": "1445.8413",
                        "monoisotopic_mz": "723.9279",
                        "intensity": "1648.23",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1445.8354",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "ion_sort_name": "B00015",
                                "ion_left_position": "15",
                                "mass_error": "0.0058",
                                "ppm": "4.03"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "31",
                        "monoisotopic_mass": "1452.7110",
                        "monoisotopic_mz": "1453.7183",
                        "intensity": "1622.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "32",
                        "monoisotopic_mass": "2550.3016",
                        "monoisotopic_mz": "1276.1581",
                        "intensity": "3819.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "33",
                        "monoisotopic_mass": "2395.2277",
                        "monoisotopic_mz": "1198.6211",
                        "intensity": "11445.60",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "34",
                        "monoisotopic_mass": "1593.8903",
                        "monoisotopic_mz": "797.9525",
                        "intensity": "1517.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "35",
                        "monoisotopic_mass": "2367.2160",
                        "monoisotopic_mz": "1184.6153",
                        "intensity": "1902.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "36",
                        "monoisotopic_mass": "978.6376",
                        "monoisotopic_mz": "490.3261",
                        "intensity": "4169.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "37",
                        "monoisotopic_mass": "1373.7727",
                        "monoisotopic_mz": "687.8936",
                        "intensity": "1242.63",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "38",
                        "monoisotopic_mass": "1006.6332",
                        "monoisotopic_mz": "504.3239",
                        "intensity": "2573.87",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1006.6287",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "0.0045",
                                "ppm": "4.43"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "39",
                        "monoisotopic_mass": "612.3732",
                        "monoisotopic_mz": "613.3805",
                        "intensity": "6112.50",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "612.3707",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "0.0025",
                                "ppm": "4.04"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "40",
                        "monoisotopic_mass": "862.5415",
                        "monoisotopic_mz": "432.2780",
                        "intensity": "3572.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "41",
                        "monoisotopic_mass": "757.4097",
                        "monoisotopic_mz": "758.4170",
                        "intensity": "505.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "42",
                        "monoisotopic_mass": "808.4945",
                        "monoisotopic_mz": "405.2545",
                        "intensity": "5196.65",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "808.4919",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0026",
                                "ppm": "3.24"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "43",
                        "monoisotopic_mass": "896.5376",
                        "monoisotopic_mz": "449.2761",
                        "intensity": "26249.62",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "44",
                        "monoisotopic_mass": "1608.7865",
                        "monoisotopic_mz": "805.4005",
                        "intensity": "1171.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "45",
                        "monoisotopic_mass": "2577.3505",
                        "monoisotopic_mz": "1289.6825",
                        "intensity": "2000.65",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2577.3373",
                                "ion_position": "59",
                                "ion_display_position": "25",
                                "ion_sort_name": "Y00025",
                                "ion_left_position": "59",
                                "mass_error": "0.0131",
                                "ppm": "5.10"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "46",
                        "monoisotopic_mass": "2776.4666",
                        "monoisotopic_mz": "926.4961",
                        "intensity": "3801.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "47",
                        "monoisotopic_mass": "2459.2798",
                        "monoisotopic_mz": "820.7672",
                        "intensity": "2672.72",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "48",
                        "monoisotopic_mass": "2504.2866",
                        "monoisotopic_mz": "835.7695",
                        "intensity": "2425.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "49",
                        "monoisotopic_mass": "1851.0363",
                        "monoisotopic_mz": "926.5254",
                        "intensity": "1199.03",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "50",
                        "monoisotopic_mass": "4827.4818",
                        "monoisotopic_mz": "805.5876",
                        "intensity": "459.67",
                        "charge": "6"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "51",
                        "monoisotopic_mass": "2857.4750",
                        "monoisotopic_mz": "953.4990",
                        "intensity": "1220.05",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "52",
                        "monoisotopic_mass": "2486.2670",
                        "monoisotopic_mz": "829.7629",
                        "intensity": "1225.61",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "53",
                        "monoisotopic_mass": "1733.9712",
                        "monoisotopic_mz": "867.9929",
                        "intensity": "971.19",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "54",
                        "monoisotopic_mass": "2831.5277",
                        "monoisotopic_mz": "944.8498",
                        "intensity": "991.70",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "55",
                        "monoisotopic_mass": "2902.4235",
                        "monoisotopic_mz": "1452.2190",
                        "intensity": "872.87",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "56",
                        "monoisotopic_mass": "4101.0344",
                        "monoisotopic_mz": "1368.0187",
                        "intensity": "665.70",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "57",
                        "monoisotopic_mass": "6784.9227",
                        "monoisotopic_mz": "970.2819",
                        "intensity": "1123.05",
                        "charge": "7"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "58",
                        "monoisotopic_mass": "3900.1021",
                        "monoisotopic_mz": "976.0328",
                        "intensity": "12447.74",
                        "charge": "4"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "59",
                        "monoisotopic_mass": "3984.9979",
                        "monoisotopic_mz": "1329.3399",
                        "intensity": "581.85",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3984.9792",
                                "ion_position": "46",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "46",
                                "mass_error": "0.0186",
                                "ppm": "4.68"
                            }
                        }
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "60",
                        "monoisotopic_mass": "2634.3835",
                        "monoisotopic_mz": "879.1351",
                        "intensity": "3253.00",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "61",
                        "monoisotopic_mass": "2477.4459",
                        "monoisotopic_mz": "1239.7302",
                        "intensity": "553.68",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "62",
                        "monoisotopic_mass": "2522.3107",
                        "monoisotopic_mz": "1262.1626",
                        "intensity": "2982.14",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "63",
                        "monoisotopic_mass": "1823.9791",
                        "monoisotopic_mz": "1824.9863",
                        "intensity": "1332.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "64",
                        "monoisotopic_mass": "2041.0897",
                        "monoisotopic_mz": "1021.5521",
                        "intensity": "5850.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "65",
                        "monoisotopic_mass": "5244.7457",
                        "monoisotopic_mz": "1312.1937",
                        "intensity": "878.54",
                        "charge": "4"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "66",
                        "monoisotopic_mass": "2197.1474",
                        "monoisotopic_mz": "1099.5810",
                        "intensity": "11190.42",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "67",
                        "monoisotopic_mass": "2169.1504",
                        "monoisotopic_mz": "1085.5825",
                        "intensity": "3366.67",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "68",
                        "monoisotopic_mass": "2069.0840",
                        "monoisotopic_mz": "1035.5493",
                        "intensity": "8175.30",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "69",
                        "monoisotopic_mass": "2458.2790",
                        "monoisotopic_mz": "1230.1468",
                        "intensity": "4123.35",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "70",
                        "monoisotopic_mass": "2790.5632",
                        "monoisotopic_mz": "1396.2889",
                        "intensity": "862.26",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "71",
                        "monoisotopic_mass": "3093.4843",
                        "monoisotopic_mz": "1547.7494",
                        "intensity": "866.57",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "72",
                        "monoisotopic_mass": "2233.1306",
                        "monoisotopic_mz": "1117.5726",
                        "intensity": "3785.61",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "73",
                        "monoisotopic_mass": "4875.9051",
                        "monoisotopic_mz": "976.1883",
                        "intensity": "24184.04",
                        "charge": "5"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "74",
                        "monoisotopic_mass": "2794.4880",
                        "monoisotopic_mz": "932.5033",
                        "intensity": "1311.20",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "75",
                        "monoisotopic_mass": "2425.2580",
                        "monoisotopic_mz": "1213.6363",
                        "intensity": "544.94",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "76",
                        "monoisotopic_mass": "1915.0192",
                        "monoisotopic_mz": "958.5169",
                        "intensity": "2110.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "77",
                        "monoisotopic_mass": "1932.0358",
                        "monoisotopic_mz": "967.0252",
                        "intensity": "3718.01",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "78",
                        "monoisotopic_mass": "2325.2068",
                        "monoisotopic_mz": "776.0762",
                        "intensity": "1581.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "79",
                        "monoisotopic_mass": "1803.9844",
                        "monoisotopic_mz": "902.9995",
                        "intensity": "1766.52",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "80",
                        "monoisotopic_mass": "1956.0010",
                        "monoisotopic_mz": "979.0078",
                        "intensity": "11121.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "81",
                        "monoisotopic_mass": "2743.4331",
                        "monoisotopic_mz": "915.4850",
                        "intensity": "1389.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "82",
                        "monoisotopic_mass": "1758.9104",
                        "monoisotopic_mz": "880.4625",
                        "intensity": "1254.95",
                        "charge": "2"
                    },
                    {
                        "spec_id": "46",
                        "peak_id": "83",
                        "monoisotopic_mass": "1827.9409",
                        "monoisotopic_mz": "914.9777",
                        "intensity": "1901.20",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P0AG55|RL6_ECOLI",
            "sequence_description": "50S ribosomal protein L6 OS=Escherichia coli (strain K12) OX=83333 GN=rplF PE=1 SV=2",
            "proteoform_mass": "8772.6566",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "177",
                "first_residue_position": "1",
                "last_residue_position": "84",
                "annotated_seq": "M.SRVAKAPVVVPAGVDVKINGQVITIKGKNGELTRTLNDAVEVKHADNTLTFGPRDGYADGWAQAGTARALLNSMVIGVTEGFTK.K",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "S"
                    },
                    {
                        "position": "2",
                        "acid": "R"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "A"
                    },
                    {
                        "position": "5",
                        "acid": "K"
                    },
                    {
                        "position": "6",
                        "acid": "A"
                    },
                    {
                        "position": "7",
                        "acid": "P"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "V"
                    },
                    {
                        "position": "10",
                        "acid": "V"
                    },
                    {
                        "position": "11",
                        "acid": "P"
                    },
                    {
                        "position": "12",
                        "acid": "A"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "V"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "I"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "G"
                    },
                    {
                        "position": "21",
                        "acid": "Q"
                    },
                    {
                        "position": "22",
                        "acid": "V"
                    },
                    {
                        "position": "23",
                        "acid": "I"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "I"
                    },
                    {
                        "position": "26",
                        "acid": "K"
                    },
                    {
                        "position": "27",
                        "acid": "G"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "G"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "L"
                    },
                    {
                        "position": "33",
                        "acid": "T"
                    },
                    {
                        "position": "34",
                        "acid": "R"
                    },
                    {
                        "position": "35",
                        "acid": "T"
                    },
                    {
                        "position": "36",
                        "acid": "L"
                    },
                    {
                        "position": "37",
                        "acid": "N"
                    },
                    {
                        "position": "38",
                        "acid": "D"
                    },
                    {
                        "position": "39",
                        "acid": "A"
                    },
                    {
                        "position": "40",
                        "acid": "V"
                    },
                    {
                        "position": "41",
                        "acid": "E"
                    },
                    {
                        "position": "42",
                        "acid": "V"
                    },
                    {
                        "position": "43",
                        "acid": "K"
                    },
                    {
                        "position": "44",
                        "acid": "H"
                    },
                    {
                        "position": "45",
                        "acid": "A"
                    },
                    {
                        "position": "46",
                        "acid": "D"
                    },
                    {
                        "position": "47",
                        "acid": "N"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "L"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "F"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "P"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "D"
                    },
                    {
                        "position": "56",
                        "acid": "G"
                    },
                    {
                        "position": "57",
                        "acid": "Y"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "W"
                    },
                    {
                        "position": "62",
                        "acid": "A"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "A"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "T"
                    },
                    {
                        "position": "67",
                        "acid": "A"
                    },
                    {
                        "position": "68",
                        "acid": "R"
                    },
                    {
                        "position": "69",
                        "acid": "A"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "S"
                    },
                    {
                        "position": "74",
                        "acid": "M"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "G"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "E"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "F"
                    },
                    {
                        "position": "83",
                        "acid": "T"
                    },
                    {
                        "position": "84",
                        "acid": "K"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "L"
                    },
                    {
                        "position": "87",
                        "acid": "Q"
                    },
                    {
                        "position": "88",
                        "acid": "L"
                    },
                    {
                        "position": "89",
                        "acid": "V"
                    },
                    {
                        "position": "90",
                        "acid": "G"
                    },
                    {
                        "position": "91",
                        "acid": "V"
                    },
                    {
                        "position": "92",
                        "acid": "G"
                    },
                    {
                        "position": "93",
                        "acid": "Y"
                    },
                    {
                        "position": "94",
                        "acid": "R"
                    },
                    {
                        "position": "95",
                        "acid": "A"
                    },
                    {
                        "position": "96",
                        "acid": "A"
                    },
                    {
                        "position": "97",
                        "acid": "V"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "G"
                    },
                    {
                        "position": "100",
                        "acid": "N"
                    },
                    {
                        "position": "101",
                        "acid": "V"
                    },
                    {
                        "position": "102",
                        "acid": "I"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "L"
                    },
                    {
                        "position": "105",
                        "acid": "S"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "G"
                    },
                    {
                        "position": "108",
                        "acid": "F"
                    },
                    {
                        "position": "109",
                        "acid": "S"
                    },
                    {
                        "position": "110",
                        "acid": "H"
                    },
                    {
                        "position": "111",
                        "acid": "P"
                    },
                    {
                        "position": "112",
                        "acid": "V"
                    },
                    {
                        "position": "113",
                        "acid": "D"
                    },
                    {
                        "position": "114",
                        "acid": "H"
                    },
                    {
                        "position": "115",
                        "acid": "Q"
                    },
                    {
                        "position": "116",
                        "acid": "L"
                    },
                    {
                        "position": "117",
                        "acid": "P"
                    },
                    {
                        "position": "118",
                        "acid": "A"
                    },
                    {
                        "position": "119",
                        "acid": "G"
                    },
                    {
                        "position": "120",
                        "acid": "I"
                    },
                    {
                        "position": "121",
                        "acid": "T"
                    },
                    {
                        "position": "122",
                        "acid": "A"
                    },
                    {
                        "position": "123",
                        "acid": "E"
                    },
                    {
                        "position": "124",
                        "acid": "C"
                    },
                    {
                        "position": "125",
                        "acid": "P"
                    },
                    {
                        "position": "126",
                        "acid": "T"
                    },
                    {
                        "position": "127",
                        "acid": "Q"
                    },
                    {
                        "position": "128",
                        "acid": "T"
                    },
                    {
                        "position": "129",
                        "acid": "E"
                    },
                    {
                        "position": "130",
                        "acid": "I"
                    },
                    {
                        "position": "131",
                        "acid": "V"
                    },
                    {
                        "position": "132",
                        "acid": "L"
                    },
                    {
                        "position": "133",
                        "acid": "K"
                    },
                    {
                        "position": "134",
                        "acid": "G"
                    },
                    {
                        "position": "135",
                        "acid": "A"
                    },
                    {
                        "position": "136",
                        "acid": "D"
                    },
                    {
                        "position": "137",
                        "acid": "K"
                    },
                    {
                        "position": "138",
                        "acid": "Q"
                    },
                    {
                        "position": "139",
                        "acid": "V"
                    },
                    {
                        "position": "140",
                        "acid": "I"
                    },
                    {
                        "position": "141",
                        "acid": "G"
                    },
                    {
                        "position": "142",
                        "acid": "Q"
                    },
                    {
                        "position": "143",
                        "acid": "V"
                    },
                    {
                        "position": "144",
                        "acid": "A"
                    },
                    {
                        "position": "145",
                        "acid": "A"
                    },
                    {
                        "position": "146",
                        "acid": "D"
                    },
                    {
                        "position": "147",
                        "acid": "L"
                    },
                    {
                        "position": "148",
                        "acid": "R"
                    },
                    {
                        "position": "149",
                        "acid": "A"
                    },
                    {
                        "position": "150",
                        "acid": "Y"
                    },
                    {
                        "position": "151",
                        "acid": "R"
                    },
                    {
                        "position": "152",
                        "acid": "R"
                    },
                    {
                        "position": "153",
                        "acid": "P"
                    },
                    {
                        "position": "154",
                        "acid": "E"
                    },
                    {
                        "position": "155",
                        "acid": "P"
                    },
                    {
                        "position": "156",
                        "acid": "Y"
                    },
                    {
                        "position": "157",
                        "acid": "K"
                    },
                    {
                        "position": "158",
                        "acid": "G"
                    },
                    {
                        "position": "159",
                        "acid": "K"
                    },
                    {
                        "position": "160",
                        "acid": "G"
                    },
                    {
                        "position": "161",
                        "acid": "V"
                    },
                    {
                        "position": "162",
                        "acid": "R"
                    },
                    {
                        "position": "163",
                        "acid": "Y"
                    },
                    {
                        "position": "164",
                        "acid": "A"
                    },
                    {
                        "position": "165",
                        "acid": "D"
                    },
                    {
                        "position": "166",
                        "acid": "E"
                    },
                    {
                        "position": "167",
                        "acid": "V"
                    },
                    {
                        "position": "168",
                        "acid": "V"
                    },
                    {
                        "position": "169",
                        "acid": "R"
                    },
                    {
                        "position": "170",
                        "acid": "T"
                    },
                    {
                        "position": "171",
                        "acid": "K"
                    },
                    {
                        "position": "172",
                        "acid": "E"
                    },
                    {
                        "position": "173",
                        "acid": "A"
                    },
                    {
                        "position": "174",
                        "acid": "K"
                    },
                    {
                        "position": "175",
                        "acid": "K"
                    },
                    {
                        "position": "176",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "46",
                                "peak_id": "39",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "46",
                                "peak_id": "42",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "spec_id": "46",
                                    "peak_id": "9",
                                    "peak_charge": "1"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "spec_id": "46",
                                    "peak_id": "38",
                                    "peak_charge": "2"
                                }
                            ]
                        }
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "spec_id": "46",
                                "peak_id": "30",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "46",
                                "ion_display_position": "38",
                                "spec_id": "46",
                                "peak_id": "59",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "59",
                                "ion_display_position": "25",
                                "spec_id": "46",
                                "peak_id": "45",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "10",
                                "spec_id": "46",
                                "peak_id": "23",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "75",
                                "ion_display_position": "9",
                                "spec_id": "46",
                                "peak_id": "7",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "76",
                                "ion_display_position": "8",
                                "spec_id": "46",
                                "peak_id": "17",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "78",
                                "ion_display_position": "6",
                                "spec_id": "46",
                                "peak_id": "26",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "150",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "151",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "152",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "153",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "154",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "155",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "156",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "157",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "158",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "159",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "160",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "161",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "162",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "163",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "164",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "165",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "166",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "167",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "168",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "169",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "170",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "171",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "172",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "173",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "174",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "175",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "176",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "177",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
