prsm_data =
{
    "prsm": {
        "prsm_id": "112",
        "p_value": "1.02e-15",
        "e_value": "1.02e-15",
        "fdr": "0",
        "matched_fragment_number": "21",
        "matched_peak_number": "20",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                "ms1_ids": "598",
                "ms1_scans": "895",
                "ids": "296",
                "scans": "896",
                "precursor_mono_mass": "5453.8053",
                "precursor_charge": "5",
                "precursor_mz": "1091.7683",
                "feature_inte": "7.9691e+07"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "296",
                        "peak_id": "0",
                        "monoisotopic_mass": "1715.9263",
                        "monoisotopic_mz": "1716.9336",
                        "intensity": "2733.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "1",
                        "monoisotopic_mass": "1670.9119",
                        "monoisotopic_mz": "1671.9192",
                        "intensity": "2641.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "2",
                        "monoisotopic_mass": "1602.8432",
                        "monoisotopic_mz": "1603.8505",
                        "intensity": "8318.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "3",
                        "monoisotopic_mass": "1557.8188",
                        "monoisotopic_mz": "1558.8260",
                        "intensity": "2419.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "4",
                        "monoisotopic_mass": "1698.9040",
                        "monoisotopic_mz": "1699.9113",
                        "intensity": "2015.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "5",
                        "monoisotopic_mass": "1471.7753",
                        "monoisotopic_mz": "1472.7826",
                        "intensity": "4513.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "6",
                        "monoisotopic_mass": "1780.8221",
                        "monoisotopic_mz": "1781.8294",
                        "intensity": "2628.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "7",
                        "monoisotopic_mass": "1370.7250",
                        "monoisotopic_mz": "1371.7323",
                        "intensity": "3543.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "8",
                        "monoisotopic_mass": "4691.3721",
                        "monoisotopic_mz": "1173.8503",
                        "intensity": "6782.62",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4691.3514",
                                "ion_position": "42",
                                "ion_display_position": "42",
                                "ion_sort_name": "B00042",
                                "ion_left_position": "42",
                                "mass_error": "0.0207",
                                "ppm": "4.41"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "9",
                        "monoisotopic_mass": "1241.6829",
                        "monoisotopic_mz": "1242.6902",
                        "intensity": "4886.71",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "10",
                        "monoisotopic_mass": "1387.7509",
                        "monoisotopic_mz": "1388.7582",
                        "intensity": "7488.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "11",
                        "monoisotopic_mass": "1634.8169",
                        "monoisotopic_mz": "1635.8242",
                        "intensity": "1329.54",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1634.8152",
                                "ion_position": "34",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "34",
                                "mass_error": "0.0018",
                                "ppm": "1.09"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "12",
                        "monoisotopic_mass": "1428.7842",
                        "monoisotopic_mz": "1429.7915",
                        "intensity": "3005.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "13",
                        "monoisotopic_mass": "1258.7087",
                        "monoisotopic_mz": "1259.7159",
                        "intensity": "11039.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "14",
                        "monoisotopic_mass": "1145.6251",
                        "monoisotopic_mz": "1146.6323",
                        "intensity": "15100.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "15",
                        "monoisotopic_mass": "2015.0454",
                        "monoisotopic_mz": "1008.5300",
                        "intensity": "13491.35",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "16",
                        "monoisotopic_mass": "1585.8165",
                        "monoisotopic_mz": "1586.8237",
                        "intensity": "5870.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "17",
                        "monoisotopic_mass": "805.4122",
                        "monoisotopic_mz": "806.4195",
                        "intensity": "7936.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "18",
                        "monoisotopic_mass": "1128.5975",
                        "monoisotopic_mz": "1129.6047",
                        "intensity": "5975.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "19",
                        "monoisotopic_mass": "1863.8954",
                        "monoisotopic_mz": "932.9550",
                        "intensity": "9573.85",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1863.8864",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "ion_sort_name": "B00016",
                                "ion_left_position": "16",
                                "mass_error": "0.0090",
                                "ppm": "4.85"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "20",
                        "monoisotopic_mass": "1032.5400",
                        "monoisotopic_mz": "1033.5472",
                        "intensity": "16478.39",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "21",
                        "monoisotopic_mass": "3598.8982",
                        "monoisotopic_mz": "900.7318",
                        "intensity": "2838.16",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "22",
                        "monoisotopic_mass": "2241.2159",
                        "monoisotopic_mz": "1121.6153",
                        "intensity": "4778.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "23",
                        "monoisotopic_mass": "1557.8258",
                        "monoisotopic_mz": "779.9202",
                        "intensity": "8641.69",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "24",
                        "monoisotopic_mass": "2128.1325",
                        "monoisotopic_mz": "1065.0735",
                        "intensity": "10375.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "25",
                        "monoisotopic_mass": "1488.8013",
                        "monoisotopic_mz": "1489.8086",
                        "intensity": "9477.60",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "26",
                        "monoisotopic_mass": "1411.7712",
                        "monoisotopic_mz": "1412.7784",
                        "intensity": "2418.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "27",
                        "monoisotopic_mass": "1434.7434",
                        "monoisotopic_mz": "718.3790",
                        "intensity": "33877.04",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1434.7368",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "ion_sort_name": "B00012",
                                "ion_left_position": "12",
                                "mass_error": "0.0066",
                                "ppm": "4.59"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "28",
                        "monoisotopic_mass": "1886.0015",
                        "monoisotopic_mz": "944.0080",
                        "intensity": "3477.58",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "29",
                        "monoisotopic_mass": "4248.1358",
                        "monoisotopic_mz": "1417.0525",
                        "intensity": "3325.03",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4248.1134",
                                "ion_position": "38",
                                "ion_display_position": "38",
                                "ion_sort_name": "B00038",
                                "ion_left_position": "38",
                                "mass_error": "0.0224",
                                "ppm": "5.27"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "30",
                        "monoisotopic_mass": "3488.8140",
                        "monoisotopic_mz": "1163.9453",
                        "intensity": "15024.06",
                        "charge": "3",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3488.7913",
                                    "ion_position": "31",
                                    "ion_display_position": "31",
                                    "ion_sort_name": "B00031",
                                    "ion_left_position": "31",
                                    "mass_error": "0.0227",
                                    "ppm": "6.50"
                                },
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3488.8450",
                                    "ion_position": "17",
                                    "ion_display_position": "31",
                                    "ion_sort_name": "Y00031",
                                    "ion_left_position": "17",
                                    "mass_error": "-0.0310",
                                    "ppm": "-8.88"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "31",
                        "monoisotopic_mass": "1113.6380",
                        "monoisotopic_mz": "1114.6453",
                        "intensity": "2768.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "32",
                        "monoisotopic_mass": "1670.9096",
                        "monoisotopic_mz": "836.4621",
                        "intensity": "8789.28",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "33",
                        "monoisotopic_mass": "2866.5751",
                        "monoisotopic_mz": "1434.2948",
                        "intensity": "3488.33",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "34",
                        "monoisotopic_mass": "918.4971",
                        "monoisotopic_mz": "919.5043",
                        "intensity": "5182.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "35",
                        "monoisotopic_mass": "692.3274",
                        "monoisotopic_mz": "693.3347",
                        "intensity": "6457.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "36",
                        "monoisotopic_mass": "1319.7152",
                        "monoisotopic_mz": "660.8649",
                        "intensity": "2983.70",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1319.7099",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "0.0053",
                                "ppm": "4.04"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "37",
                        "monoisotopic_mass": "3332.7159",
                        "monoisotopic_mz": "1111.9126",
                        "intensity": "8001.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "38",
                        "monoisotopic_mass": "3219.6327",
                        "monoisotopic_mz": "1074.2182",
                        "intensity": "9144.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "39",
                        "monoisotopic_mass": "1997.0278",
                        "monoisotopic_mz": "999.5212",
                        "intensity": "6555.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "40",
                        "monoisotopic_mass": "1600.9895",
                        "monoisotopic_mz": "801.5020",
                        "intensity": "1282.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "41",
                        "monoisotopic_mass": "2110.1156",
                        "monoisotopic_mz": "1056.0651",
                        "intensity": "2811.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "42",
                        "monoisotopic_mass": "4376.2280",
                        "monoisotopic_mz": "1095.0643",
                        "intensity": "5867.80",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4376.2084",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "0.0196",
                                "ppm": "4.48"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "43",
                        "monoisotopic_mass": "5066.5552",
                        "monoisotopic_mz": "1267.6461",
                        "intensity": "16341.61",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5066.5309",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "B00045",
                                "ion_left_position": "45",
                                "mass_error": "0.0244",
                                "ppm": "4.81"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "44",
                        "monoisotopic_mass": "4427.2247",
                        "monoisotopic_mz": "1107.8135",
                        "intensity": "3469.65",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "45",
                        "monoisotopic_mass": "1343.7212",
                        "monoisotopic_mz": "1344.7285",
                        "intensity": "1322.03",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "46",
                        "monoisotopic_mass": "1642.9143",
                        "monoisotopic_mz": "822.4644",
                        "intensity": "3300.81",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "47",
                        "monoisotopic_mass": "2798.4701",
                        "monoisotopic_mz": "1400.2423",
                        "intensity": "1984.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "48",
                        "monoisotopic_mass": "4907.4586",
                        "monoisotopic_mz": "1227.8719",
                        "intensity": "1714.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "49",
                        "monoisotopic_mass": "3360.7116",
                        "monoisotopic_mz": "1121.2445",
                        "intensity": "14337.54",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3360.6963",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "0.0152",
                                "ppm": "4.54"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "50",
                        "monoisotopic_mass": "3916.9907",
                        "monoisotopic_mz": "1306.6708",
                        "intensity": "4031.78",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "51",
                        "monoisotopic_mass": "3247.6314",
                        "monoisotopic_mz": "1083.5511",
                        "intensity": "13248.30",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3247.6123",
                                "ion_position": "29",
                                "ion_display_position": "29",
                                "ion_sort_name": "B00029",
                                "ion_left_position": "29",
                                "mass_error": "0.0191",
                                "ppm": "5.89"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "52",
                        "monoisotopic_mass": "3935.0134",
                        "monoisotopic_mz": "1312.6784",
                        "intensity": "7028.36",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "53",
                        "monoisotopic_mass": "4576.3355",
                        "monoisotopic_mz": "1145.0912",
                        "intensity": "4282.85",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4576.3245",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "0.0111",
                                "ppm": "2.42"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "54",
                        "monoisotopic_mass": "3132.5420",
                        "monoisotopic_mz": "1045.1879",
                        "intensity": "1972.19",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "55",
                        "monoisotopic_mass": "2994.6264",
                        "monoisotopic_mz": "1498.3205",
                        "intensity": "6117.04",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "56",
                        "monoisotopic_mass": "1459.7466",
                        "monoisotopic_mz": "1460.7539",
                        "intensity": "1260.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "57",
                        "monoisotopic_mass": "3615.8968",
                        "monoisotopic_mz": "904.9815",
                        "intensity": "2467.96",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "58",
                        "monoisotopic_mass": "2737.5350",
                        "monoisotopic_mz": "1369.7748",
                        "intensity": "2820.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "59",
                        "monoisotopic_mass": "3014.6278",
                        "monoisotopic_mz": "1508.3212",
                        "intensity": "3505.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "60",
                        "monoisotopic_mass": "2194.0872",
                        "monoisotopic_mz": "732.3697",
                        "intensity": "2241.53",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2194.0767",
                                "ion_position": "19",
                                "ion_display_position": "19",
                                "ion_sort_name": "B00019",
                                "ion_left_position": "19",
                                "mass_error": "0.0105",
                                "ppm": "4.80"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "61",
                        "monoisotopic_mass": "3315.6968",
                        "monoisotopic_mz": "1106.2396",
                        "intensity": "1680.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "62",
                        "monoisotopic_mass": "4953.4708",
                        "monoisotopic_mz": "1239.3750",
                        "intensity": "10710.63",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4953.4468",
                                "ion_position": "44",
                                "ion_display_position": "44",
                                "ion_sort_name": "B00044",
                                "ion_left_position": "44",
                                "mass_error": "0.0240",
                                "ppm": "4.84"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "63",
                        "monoisotopic_mass": "788.3852",
                        "monoisotopic_mz": "789.3925",
                        "intensity": "2415.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "64",
                        "monoisotopic_mass": "2883.6002",
                        "monoisotopic_mz": "1442.8074",
                        "intensity": "1778.79",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "65",
                        "monoisotopic_mass": "1380.6511",
                        "monoisotopic_mz": "691.3328",
                        "intensity": "816.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "66",
                        "monoisotopic_mass": "3616.9057",
                        "monoisotopic_mz": "1206.6425",
                        "intensity": "8002.89",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3616.8863",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "ion_sort_name": "B00032",
                                "ion_left_position": "32",
                                "mass_error": "0.0195",
                                "ppm": "5.39"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "67",
                        "monoisotopic_mass": "2879.4074",
                        "monoisotopic_mz": "960.8097",
                        "intensity": "2988.51",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2879.4063",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0011",
                                "ppm": "0.38"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "68",
                        "monoisotopic_mass": "3687.9373",
                        "monoisotopic_mz": "922.9916",
                        "intensity": "6663.70",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3687.9234",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "ion_sort_name": "B00033",
                                "ion_left_position": "33",
                                "mass_error": "0.0139",
                                "ppm": "3.77"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "69",
                        "monoisotopic_mass": "377.1236",
                        "monoisotopic_mz": "378.1308",
                        "intensity": "1350.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "70",
                        "monoisotopic_mass": "675.3002",
                        "monoisotopic_mz": "676.3075",
                        "intensity": "1584.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "71",
                        "monoisotopic_mass": "490.2084",
                        "monoisotopic_mz": "491.2157",
                        "intensity": "1016.36",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "72",
                        "monoisotopic_mass": "858.3823",
                        "monoisotopic_mz": "859.3896",
                        "intensity": "1713.82",
                        "charge": "1"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "73",
                        "monoisotopic_mass": "4806.4029",
                        "monoisotopic_mz": "1202.6080",
                        "intensity": "7319.56",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4806.3784",
                                "ion_position": "43",
                                "ion_display_position": "43",
                                "ion_sort_name": "B00043",
                                "ion_left_position": "43",
                                "mass_error": "0.0245",
                                "ppm": "5.10"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "74",
                        "monoisotopic_mass": "2132.0496",
                        "monoisotopic_mz": "711.6905",
                        "intensity": "2056.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "75",
                        "monoisotopic_mass": "4247.1328",
                        "monoisotopic_mz": "1062.7905",
                        "intensity": "4801.72",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "76",
                        "monoisotopic_mass": "1529.8313",
                        "monoisotopic_mz": "765.9229",
                        "intensity": "1624.27",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "77",
                        "monoisotopic_mass": "3377.7385",
                        "monoisotopic_mz": "1126.9201",
                        "intensity": "3772.50",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "78",
                        "monoisotopic_mass": "5048.5347",
                        "monoisotopic_mz": "1263.1410",
                        "intensity": "7082.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "79",
                        "monoisotopic_mass": "5002.5336",
                        "monoisotopic_mz": "1251.6407",
                        "intensity": "2132.95",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "80",
                        "monoisotopic_mass": "3470.7869",
                        "monoisotopic_mz": "1157.9362",
                        "intensity": "2952.29",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "81",
                        "monoisotopic_mass": "4891.4865",
                        "monoisotopic_mz": "979.3046",
                        "intensity": "2173.96",
                        "charge": "5"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "82",
                        "monoisotopic_mass": "3148.5618",
                        "monoisotopic_mz": "1050.5279",
                        "intensity": "4870.56",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3148.5439",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "0.0180",
                                "ppm": "5.71"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "83",
                        "monoisotopic_mass": "4192.1137",
                        "monoisotopic_mz": "1049.0357",
                        "intensity": "4745.38",
                        "charge": "4"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "84",
                        "monoisotopic_mass": "4063.0553",
                        "monoisotopic_mz": "1016.7711",
                        "intensity": "4456.49",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4063.0334",
                                "ion_position": "36",
                                "ion_display_position": "36",
                                "ion_sort_name": "B00036",
                                "ion_left_position": "36",
                                "mass_error": "0.0219",
                                "ppm": "5.38"
                            }
                        }
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "85",
                        "monoisotopic_mass": "4402.2633",
                        "monoisotopic_mz": "881.4599",
                        "intensity": "1798.75",
                        "charge": "5"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "86",
                        "monoisotopic_mass": "1849.1426",
                        "monoisotopic_mz": "925.5786",
                        "intensity": "1725.18",
                        "charge": "2"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "87",
                        "monoisotopic_mass": "2176.0779",
                        "monoisotopic_mz": "726.3666",
                        "intensity": "2492.76",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "88",
                        "monoisotopic_mass": "2681.6806",
                        "monoisotopic_mz": "894.9008",
                        "intensity": "1895.29",
                        "charge": "3"
                    },
                    {
                        "spec_id": "296",
                        "peak_id": "89",
                        "monoisotopic_mass": "2903.5287",
                        "monoisotopic_mz": "968.8502",
                        "intensity": "1368.23",
                        "charge": "3"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "10",
            "proteoform_id": "10",
            "sequence_name": "sp|P0ACF8|HNS_ECOLI",
            "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
            "proteoform_mass": "5453.7790",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "137",
                "first_residue_position": "89",
                "last_residue_position": "136",
                "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "S"
                    },
                    {
                        "position": "2",
                        "acid": "E"
                    },
                    {
                        "position": "3",
                        "acid": "A"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "K"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "L"
                    },
                    {
                        "position": "8",
                        "acid": "N"
                    },
                    {
                        "position": "9",
                        "acid": "N"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "R"
                    },
                    {
                        "position": "12",
                        "acid": "T"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "R"
                    },
                    {
                        "position": "15",
                        "acid": "A"
                    },
                    {
                        "position": "16",
                        "acid": "Q"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "R"
                    },
                    {
                        "position": "19",
                        "acid": "E"
                    },
                    {
                        "position": "20",
                        "acid": "C"
                    },
                    {
                        "position": "21",
                        "acid": "T"
                    },
                    {
                        "position": "22",
                        "acid": "L"
                    },
                    {
                        "position": "23",
                        "acid": "E"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "L"
                    },
                    {
                        "position": "26",
                        "acid": "E"
                    },
                    {
                        "position": "27",
                        "acid": "E"
                    },
                    {
                        "position": "28",
                        "acid": "M"
                    },
                    {
                        "position": "29",
                        "acid": "L"
                    },
                    {
                        "position": "30",
                        "acid": "E"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "L"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "V"
                    },
                    {
                        "position": "35",
                        "acid": "V"
                    },
                    {
                        "position": "36",
                        "acid": "V"
                    },
                    {
                        "position": "37",
                        "acid": "N"
                    },
                    {
                        "position": "38",
                        "acid": "E"
                    },
                    {
                        "position": "39",
                        "acid": "R"
                    },
                    {
                        "position": "40",
                        "acid": "R"
                    },
                    {
                        "position": "41",
                        "acid": "E"
                    },
                    {
                        "position": "42",
                        "acid": "E"
                    },
                    {
                        "position": "43",
                        "acid": "E"
                    },
                    {
                        "position": "44",
                        "acid": "S"
                    },
                    {
                        "position": "45",
                        "acid": "A"
                    },
                    {
                        "position": "46",
                        "acid": "A"
                    },
                    {
                        "position": "47",
                        "acid": "A"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "E"
                    },
                    {
                        "position": "50",
                        "acid": "V"
                    },
                    {
                        "position": "51",
                        "acid": "E"
                    },
                    {
                        "position": "52",
                        "acid": "E"
                    },
                    {
                        "position": "53",
                        "acid": "R"
                    },
                    {
                        "position": "54",
                        "acid": "T"
                    },
                    {
                        "position": "55",
                        "acid": "R"
                    },
                    {
                        "position": "56",
                        "acid": "K"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "Q"
                    },
                    {
                        "position": "59",
                        "acid": "Q"
                    },
                    {
                        "position": "60",
                        "acid": "Y"
                    },
                    {
                        "position": "61",
                        "acid": "R"
                    },
                    {
                        "position": "62",
                        "acid": "E"
                    },
                    {
                        "position": "63",
                        "acid": "M"
                    },
                    {
                        "position": "64",
                        "acid": "L"
                    },
                    {
                        "position": "65",
                        "acid": "I"
                    },
                    {
                        "position": "66",
                        "acid": "A"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "G"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "D"
                    },
                    {
                        "position": "71",
                        "acid": "P"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "L"
                    },
                    {
                        "position": "75",
                        "acid": "L"
                    },
                    {
                        "position": "76",
                        "acid": "N"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "L"
                    },
                    {
                        "position": "79",
                        "acid": "A"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "V"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "S"
                    },
                    {
                        "position": "84",
                        "acid": "G"
                    },
                    {
                        "position": "85",
                        "acid": "T"
                    },
                    {
                        "position": "86",
                        "acid": "K"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "R"
                    },
                    {
                        "position": "90",
                        "acid": "A"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "R"
                    },
                    {
                        "position": "93",
                        "acid": "P"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "Y"
                    },
                    {
                        "position": "97",
                        "acid": "S"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "V"
                    },
                    {
                        "position": "100",
                        "acid": "D"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "N"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "E"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "T"
                    },
                    {
                        "position": "108",
                        "acid": "W"
                    },
                    {
                        "position": "109",
                        "acid": "T"
                    },
                    {
                        "position": "110",
                        "acid": "G"
                    },
                    {
                        "position": "111",
                        "acid": "Q"
                    },
                    {
                        "position": "112",
                        "acid": "G"
                    },
                    {
                        "position": "113",
                        "acid": "R"
                    },
                    {
                        "position": "114",
                        "acid": "T"
                    },
                    {
                        "position": "115",
                        "acid": "P"
                    },
                    {
                        "position": "116",
                        "acid": "A"
                    },
                    {
                        "position": "117",
                        "acid": "V"
                    },
                    {
                        "position": "118",
                        "acid": "I"
                    },
                    {
                        "position": "119",
                        "acid": "K"
                    },
                    {
                        "position": "120",
                        "acid": "K"
                    },
                    {
                        "position": "121",
                        "acid": "A"
                    },
                    {
                        "position": "122",
                        "acid": "M"
                    },
                    {
                        "position": "123",
                        "acid": "D"
                    },
                    {
                        "position": "124",
                        "acid": "E"
                    },
                    {
                        "position": "125",
                        "acid": "Q"
                    },
                    {
                        "position": "126",
                        "acid": "G"
                    },
                    {
                        "position": "127",
                        "acid": "K"
                    },
                    {
                        "position": "128",
                        "acid": "S"
                    },
                    {
                        "position": "129",
                        "acid": "L"
                    },
                    {
                        "position": "130",
                        "acid": "D"
                    },
                    {
                        "position": "131",
                        "acid": "D"
                    },
                    {
                        "position": "132",
                        "acid": "F"
                    },
                    {
                        "position": "133",
                        "acid": "L"
                    },
                    {
                        "position": "134",
                        "acid": "I"
                    },
                    {
                        "position": "135",
                        "acid": "K"
                    },
                    {
                        "position": "136",
                        "acid": "Q"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "296",
                                "peak_id": "36",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "spec_id": "296",
                                "peak_id": "27",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "spec_id": "296",
                                "peak_id": "19",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "17",
                                "ion_display_position": "31",
                                "spec_id": "296",
                                "peak_id": "30",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "19",
                                "ion_display_position": "19",
                                "spec_id": "296",
                                "peak_id": "60",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "296",
                                "peak_id": "67",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "spec_id": "296",
                                "peak_id": "82",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "29",
                                "ion_display_position": "29",
                                "spec_id": "296",
                                "peak_id": "51",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "spec_id": "296",
                                "peak_id": "49",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "31",
                                "ion_display_position": "31",
                                "spec_id": "296",
                                "peak_id": "30",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "spec_id": "296",
                                "peak_id": "66",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "spec_id": "296",
                                "peak_id": "68",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "34",
                                "ion_display_position": "14",
                                "spec_id": "296",
                                "peak_id": "11",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "36",
                                "ion_display_position": "36",
                                "spec_id": "296",
                                "peak_id": "84",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "38",
                                "ion_display_position": "38",
                                "spec_id": "296",
                                "peak_id": "29",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "296",
                                "peak_id": "42",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "296",
                                "peak_id": "53",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "42",
                                "ion_display_position": "42",
                                "spec_id": "296",
                                "peak_id": "8",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "43",
                                "ion_display_position": "43",
                                "spec_id": "296",
                                "peak_id": "73",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "44",
                                "ion_display_position": "44",
                                "spec_id": "296",
                                "peak_id": "62",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "296",
                                "peak_id": "43",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
