prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "9",
        "sequence_name": "sp|P0A972|CSPE_ECOLI",
        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
        "proteoform_id": "9",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "52",
                "p_value": "1.88e-25",
                "e_value": "1.88e-25",
                "fdr": "0",
                "matched_fragment_number": "32",
                "matched_peak_number": "39",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "533",
                        "ms1_scans": "635",
                        "ids": "101",
                        "scans": "636",
                        "precursor_mono_mass": "7327.7964",
                        "precursor_charge": "5",
                        "precursor_mz": "1466.5666",
                        "feature_inte": "1.0712e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "101",
                                "peak_id": "0",
                                "monoisotopic_mass": "6562.5900",
                                "monoisotopic_mz": "1313.5253",
                                "intensity": "1118.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "1",
                                "monoisotopic_mass": "1123.5478",
                                "monoisotopic_mz": "1124.5551",
                                "intensity": "5220.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "2",
                                "monoisotopic_mass": "2391.1983",
                                "monoisotopic_mz": "2392.2056",
                                "intensity": "7085.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "3",
                                "monoisotopic_mass": "3173.6256",
                                "monoisotopic_mz": "1587.8201",
                                "intensity": "9016.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "4",
                                "monoisotopic_mass": "2430.2264",
                                "monoisotopic_mz": "2431.2337",
                                "intensity": "1335.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "5",
                                "monoisotopic_mass": "2415.2135",
                                "monoisotopic_mz": "2416.2207",
                                "intensity": "1383.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "6",
                                "monoisotopic_mass": "4232.2123",
                                "monoisotopic_mz": "2117.1134",
                                "intensity": "10608.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4232.2018",
                                        "ion_position": "28",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0104",
                                        "ppm": "2.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "7",
                                "monoisotopic_mass": "2575.2982",
                                "monoisotopic_mz": "2576.3055",
                                "intensity": "3997.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "8",
                                "monoisotopic_mass": "2448.2436",
                                "monoisotopic_mz": "2449.2509",
                                "intensity": "2817.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "9",
                                "monoisotopic_mass": "2304.1143",
                                "monoisotopic_mz": "2305.1216",
                                "intensity": "5480.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "10",
                                "monoisotopic_mass": "1742.8936",
                                "monoisotopic_mz": "1743.9009",
                                "intensity": "9300.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "11",
                                "monoisotopic_mass": "2054.0836",
                                "monoisotopic_mz": "2055.0909",
                                "intensity": "9111.15",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2054.0738",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0098",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "12",
                                "monoisotopic_mass": "827.3694",
                                "monoisotopic_mz": "828.3767",
                                "intensity": "15546.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "13",
                                "monoisotopic_mass": "1317.6890",
                                "monoisotopic_mz": "1318.6963",
                                "intensity": "8385.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "14",
                                "monoisotopic_mass": "2281.1180",
                                "monoisotopic_mz": "2282.1253",
                                "intensity": "4067.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "15",
                                "monoisotopic_mass": "3242.6449",
                                "monoisotopic_mz": "1622.3297",
                                "intensity": "17793.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3242.6400",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0049",
                                        "ppm": "1.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "16",
                                "monoisotopic_mass": "2227.1158",
                                "monoisotopic_mz": "2228.1231",
                                "intensity": "4962.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "17",
                                "monoisotopic_mass": "1726.8738",
                                "monoisotopic_mz": "1727.8811",
                                "intensity": "4924.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "18",
                                "monoisotopic_mass": "3302.7394",
                                "monoisotopic_mz": "1652.3770",
                                "intensity": "17930.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3302.7259",
                                        "ion_position": "36",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "Y00032",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0135",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "19",
                                "monoisotopic_mass": "2790.4322",
                                "monoisotopic_mz": "2791.4395",
                                "intensity": "3708.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "20",
                                "monoisotopic_mass": "2609.3265",
                                "monoisotopic_mz": "2610.3338",
                                "intensity": "8317.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2609.3278",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "21",
                                "monoisotopic_mass": "3358.7295",
                                "monoisotopic_mz": "1680.3720",
                                "intensity": "11617.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "22",
                                "monoisotopic_mass": "2504.2695",
                                "monoisotopic_mz": "2505.2768",
                                "intensity": "4381.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "23",
                                "monoisotopic_mass": "3341.7239",
                                "monoisotopic_mz": "1671.8692",
                                "intensity": "31252.45",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3341.7085",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0154",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "24",
                                "monoisotopic_mass": "2662.3229",
                                "monoisotopic_mz": "2663.3301",
                                "intensity": "4835.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "25",
                                "monoisotopic_mass": "2341.2459",
                                "monoisotopic_mz": "2342.2532",
                                "intensity": "10656.15",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2341.2390",
                                        "ion_position": "45",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0069",
                                        "ppm": "2.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "26",
                                "monoisotopic_mass": "2520.2916",
                                "monoisotopic_mz": "2521.2989",
                                "intensity": "6819.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "27",
                                "monoisotopic_mass": "4512.2370",
                                "monoisotopic_mz": "1505.0863",
                                "intensity": "5832.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "28",
                                "monoisotopic_mass": "974.4387",
                                "monoisotopic_mz": "975.4459",
                                "intensity": "21818.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "29",
                                "monoisotopic_mass": "2250.1920",
                                "monoisotopic_mz": "2251.1993",
                                "intensity": "9309.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "30",
                                "monoisotopic_mass": "2167.1637",
                                "monoisotopic_mz": "2168.1709",
                                "intensity": "15021.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.1578",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0058",
                                        "ppm": "2.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "31",
                                "monoisotopic_mass": "2031.0090",
                                "monoisotopic_mz": "2032.0163",
                                "intensity": "4467.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "32",
                                "monoisotopic_mass": "1517.8045",
                                "monoisotopic_mz": "1518.8118",
                                "intensity": "20809.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1517.7991",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0054",
                                        "ppm": "3.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "33",
                                "monoisotopic_mass": "3563.7294",
                                "monoisotopic_mz": "1782.8720",
                                "intensity": "7954.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "34",
                                "monoisotopic_mass": "1022.6069",
                                "monoisotopic_mz": "1023.6142",
                                "intensity": "17745.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "35",
                                "monoisotopic_mass": "1187.6867",
                                "monoisotopic_mz": "1188.6940",
                                "intensity": "34946.14",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1187.6815",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0052",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "36",
                                "monoisotopic_mass": "2755.4554",
                                "monoisotopic_mz": "2756.4627",
                                "intensity": "4938.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2755.4505",
                                        "ion_position": "41",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0050",
                                        "ppm": "1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "37",
                                "monoisotopic_mass": "2703.3878",
                                "monoisotopic_mz": "2704.3951",
                                "intensity": "2741.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "38",
                                "monoisotopic_mass": "3430.7942",
                                "monoisotopic_mz": "1716.4044",
                                "intensity": "16771.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3430.7845",
                                        "ion_position": "35",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "Y00033",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0097",
                                        "ppm": "2.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "39",
                                "monoisotopic_mass": "750.4101",
                                "monoisotopic_mz": "751.4174",
                                "intensity": "7266.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "40",
                                "monoisotopic_mass": "2192.0873",
                                "monoisotopic_mz": "2193.0945",
                                "intensity": "4899.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "41",
                                "monoisotopic_mass": "2009.0617",
                                "monoisotopic_mz": "1005.5381",
                                "intensity": "6948.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "42",
                                "monoisotopic_mass": "3543.8884",
                                "monoisotopic_mz": "1772.9515",
                                "intensity": "20707.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3543.8685",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "Y00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0199",
                                        "ppm": "5.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "43",
                                "monoisotopic_mass": "1210.5660",
                                "monoisotopic_mz": "1211.5732",
                                "intensity": "26308.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "44",
                                "monoisotopic_mass": "1073.5073",
                                "monoisotopic_mz": "1074.5145",
                                "intensity": "33084.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "45",
                                "monoisotopic_mass": "908.5119",
                                "monoisotopic_mz": "909.5192",
                                "intensity": "9456.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "46",
                                "monoisotopic_mass": "1430.7758",
                                "monoisotopic_mz": "1431.7831",
                                "intensity": "37816.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0088",
                                        "ppm": "6.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "47",
                                "monoisotopic_mass": "3628.8525",
                                "monoisotopic_mz": "1815.4335",
                                "intensity": "8369.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "48",
                                "monoisotopic_mass": "1849.9910",
                                "monoisotopic_mz": "926.0028",
                                "intensity": "30773.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1849.9839",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0071",
                                        "ppm": "3.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "49",
                                "monoisotopic_mass": "3986.0692",
                                "monoisotopic_mz": "1994.0419",
                                "intensity": "33258.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3986.0650",
                                        "ion_position": "30",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0042",
                                        "ppm": "1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "50",
                                "monoisotopic_mass": "2054.0831",
                                "monoisotopic_mz": "1028.0489",
                                "intensity": "64365.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2054.0738",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0094",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "51",
                                "monoisotopic_mass": "3129.6051",
                                "monoisotopic_mz": "1565.8098",
                                "intensity": "11628.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "52",
                                "monoisotopic_mass": "1357.6352",
                                "monoisotopic_mz": "1358.6425",
                                "intensity": "21241.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "53",
                                "monoisotopic_mass": "1702.9236",
                                "monoisotopic_mz": "852.4691",
                                "intensity": "19199.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1702.9155",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0081",
                                        "ppm": "4.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "54",
                                "monoisotopic_mass": "1940.0026",
                                "monoisotopic_mz": "971.0086",
                                "intensity": "7284.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "55",
                                "monoisotopic_mass": "1464.7244",
                                "monoisotopic_mz": "1465.7317",
                                "intensity": "21451.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "56",
                                "monoisotopic_mass": "3806.9465",
                                "monoisotopic_mz": "1904.4805",
                                "intensity": "14583.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "57",
                                "monoisotopic_mass": "3831.9958",
                                "monoisotopic_mz": "1917.0052",
                                "intensity": "11033.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "58",
                                "monoisotopic_mass": "1628.7906",
                                "monoisotopic_mz": "1629.7979",
                                "intensity": "14069.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "59",
                                "monoisotopic_mass": "3969.0546",
                                "monoisotopic_mz": "1985.5346",
                                "intensity": "15135.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "60",
                                "monoisotopic_mass": "1040.6164",
                                "monoisotopic_mz": "1041.6237",
                                "intensity": "40523.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1040.6131",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0033",
                                        "ppm": "3.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "61",
                                "monoisotopic_mass": "3156.6027",
                                "monoisotopic_mz": "1579.3086",
                                "intensity": "9331.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "62",
                                "monoisotopic_mass": "1907.0136",
                                "monoisotopic_mz": "954.5141",
                                "intensity": "20634.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1907.0054",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0082",
                                        "ppm": "4.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "63",
                                "monoisotopic_mass": "2139.1752",
                                "monoisotopic_mz": "1070.5949",
                                "intensity": "21489.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "64",
                                "monoisotopic_mass": "1281.7088",
                                "monoisotopic_mz": "1282.7161",
                                "intensity": "5571.30",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1281.7041",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0047",
                                        "ppm": "3.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "65",
                                "monoisotopic_mass": "3264.6552",
                                "monoisotopic_mz": "1633.3349",
                                "intensity": "8093.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "66",
                                "monoisotopic_mass": "3916.9906",
                                "monoisotopic_mz": "1959.5026",
                                "intensity": "8345.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "67",
                                "monoisotopic_mass": "3701.9599",
                                "monoisotopic_mz": "1851.9872",
                                "intensity": "37135.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3701.9377",
                                        "ion_position": "32",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0222",
                                        "ppm": "6.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "68",
                                "monoisotopic_mass": "1725.8668",
                                "monoisotopic_mz": "863.9407",
                                "intensity": "6102.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "69",
                                "monoisotopic_mass": "726.4415",
                                "monoisotopic_mz": "727.4488",
                                "intensity": "71939.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "726.4388",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0027",
                                        "ppm": "3.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "70",
                                "monoisotopic_mass": "1597.7716",
                                "monoisotopic_mz": "1598.7789",
                                "intensity": "5264.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "71",
                                "monoisotopic_mass": "2268.2103",
                                "monoisotopic_mz": "2269.2176",
                                "intensity": "14872.44",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0048",
                                        "ppm": "2.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "72",
                                "monoisotopic_mass": "869.4429",
                                "monoisotopic_mz": "870.4501",
                                "intensity": "11746.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "73",
                                "monoisotopic_mass": "1747.9479",
                                "monoisotopic_mz": "874.9812",
                                "intensity": "5786.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "74",
                                "monoisotopic_mass": "3450.7874",
                                "monoisotopic_mz": "1151.2697",
                                "intensity": "6131.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "75",
                                "monoisotopic_mass": "4019.9611",
                                "monoisotopic_mz": "2010.9878",
                                "intensity": "16211.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "76",
                                "monoisotopic_mass": "627.3726",
                                "monoisotopic_mz": "628.3798",
                                "intensity": "16605.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "627.3704",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0021",
                                        "ppm": "3.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "77",
                                "monoisotopic_mass": "1645.9004",
                                "monoisotopic_mz": "823.9575",
                                "intensity": "28227.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1645.8940",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0063",
                                        "ppm": "3.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "78",
                                "monoisotopic_mass": "1811.9073",
                                "monoisotopic_mz": "1812.9146",
                                "intensity": "14120.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "79",
                                "monoisotopic_mass": "3849.0121",
                                "monoisotopic_mz": "1925.5133",
                                "intensity": "31041.57",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3849.0061",
                                        "ion_position": "31",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0060",
                                        "ppm": "1.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "80",
                                "monoisotopic_mass": "3479.7756",
                                "monoisotopic_mz": "1740.8951",
                                "intensity": "13153.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "81",
                                "monoisotopic_mass": "596.2938",
                                "monoisotopic_mz": "597.3010",
                                "intensity": "17773.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "82",
                                "monoisotopic_mass": "1822.0115",
                                "monoisotopic_mz": "912.0130",
                                "intensity": "14782.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "83",
                                "monoisotopic_mass": "2268.2157",
                                "monoisotopic_mz": "1135.1151",
                                "intensity": "87096.50",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0102",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "84",
                                "monoisotopic_mass": "1684.9106",
                                "monoisotopic_mz": "843.4626",
                                "intensity": "13765.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "85",
                                "monoisotopic_mass": "1301.7295",
                                "monoisotopic_mz": "1302.7368",
                                "intensity": "18434.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1301.7244",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0051",
                                        "ppm": "3.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "86",
                                "monoisotopic_mass": "2026.0885",
                                "monoisotopic_mz": "1014.0515",
                                "intensity": "19140.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "87",
                                "monoisotopic_mass": "2122.1454",
                                "monoisotopic_mz": "1062.0800",
                                "intensity": "8293.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "88",
                                "monoisotopic_mass": "3211.6427",
                                "monoisotopic_mz": "1606.8286",
                                "intensity": "15171.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "89",
                                "monoisotopic_mass": "698.4465",
                                "monoisotopic_mz": "699.4538",
                                "intensity": "15469.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "90",
                                "monoisotopic_mass": "854.5367",
                                "monoisotopic_mz": "855.5440",
                                "intensity": "44949.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "854.5338",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0029",
                                        "ppm": "3.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "91",
                                "monoisotopic_mass": "2996.5222",
                                "monoisotopic_mz": "999.8480",
                                "intensity": "5310.94",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2996.5032",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0190",
                                        "ppm": "6.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "92",
                                "monoisotopic_mass": "1055.4958",
                                "monoisotopic_mz": "1056.5031",
                                "intensity": "4268.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "93",
                                "monoisotopic_mass": "3395.7505",
                                "monoisotopic_mz": "1698.8825",
                                "intensity": "10033.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "94",
                                "monoisotopic_mass": "2167.1671",
                                "monoisotopic_mz": "1084.5908",
                                "intensity": "69000.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.1578",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0093",
                                        "ppm": "4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "95",
                                "monoisotopic_mass": "1541.7706",
                                "monoisotopic_mz": "1542.7778",
                                "intensity": "13205.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "96",
                                "monoisotopic_mass": "3608.8168",
                                "monoisotopic_mz": "1805.4157",
                                "intensity": "7473.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "97",
                                "monoisotopic_mass": "893.5492",
                                "monoisotopic_mz": "894.5565",
                                "intensity": "4553.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "98",
                                "monoisotopic_mass": "3412.7732",
                                "monoisotopic_mz": "1707.3939",
                                "intensity": "24083.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "99",
                                "monoisotopic_mass": "3783.9269",
                                "monoisotopic_mz": "1262.3162",
                                "intensity": "16657.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3783.9049",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0219",
                                        "ppm": "5.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "100",
                                "monoisotopic_mass": "2609.3395",
                                "monoisotopic_mz": "1305.6770",
                                "intensity": "31784.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2609.3278",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0117",
                                        "ppm": "4.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "101",
                                "monoisotopic_mass": "1645.9007",
                                "monoisotopic_mz": "1646.9080",
                                "intensity": "21562.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1645.8940",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0067",
                                        "ppm": "4.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "102",
                                "monoisotopic_mass": "4206.0878",
                                "monoisotopic_mz": "2104.0512",
                                "intensity": "6894.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "103",
                                "monoisotopic_mass": "3114.5780",
                                "monoisotopic_mz": "1558.2963",
                                "intensity": "13079.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "104",
                                "monoisotopic_mass": "2250.2025",
                                "monoisotopic_mz": "1126.1085",
                                "intensity": "38645.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "105",
                                "monoisotopic_mass": "791.3642",
                                "monoisotopic_mz": "792.3715",
                                "intensity": "9754.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "106",
                                "monoisotopic_mass": "1568.7835",
                                "monoisotopic_mz": "785.3990",
                                "intensity": "3575.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "107",
                                "monoisotopic_mass": "3323.7124",
                                "monoisotopic_mz": "1662.8635",
                                "intensity": "13969.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "108",
                                "monoisotopic_mass": "1517.8048",
                                "monoisotopic_mz": "759.9097",
                                "intensity": "9943.65",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1517.7991",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0057",
                                        "ppm": "3.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "109",
                                "monoisotopic_mass": "3589.7912",
                                "monoisotopic_mz": "1795.9029",
                                "intensity": "7982.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "110",
                                "monoisotopic_mass": "4085.1488",
                                "monoisotopic_mz": "2043.5817",
                                "intensity": "9852.73",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4085.1334",
                                        "ion_position": "29",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "Y00039",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0154",
                                        "ppm": "3.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "111",
                                "monoisotopic_mass": "2794.4235",
                                "monoisotopic_mz": "1398.2190",
                                "intensity": "4939.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "112",
                                "monoisotopic_mass": "3713.8909",
                                "monoisotopic_mz": "1238.9709",
                                "intensity": "6669.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "113",
                                "monoisotopic_mass": "2494.3178",
                                "monoisotopic_mz": "1248.1662",
                                "intensity": "7739.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2494.3009",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0169",
                                        "ppm": "6.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "114",
                                "monoisotopic_mass": "2996.5143",
                                "monoisotopic_mz": "1499.2644",
                                "intensity": "20141.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2996.5032",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0111",
                                        "ppm": "3.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "115",
                                "monoisotopic_mass": "3684.9289",
                                "monoisotopic_mz": "1843.4717",
                                "intensity": "12565.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "116",
                                "monoisotopic_mass": "4001.9562",
                                "monoisotopic_mz": "2001.9854",
                                "intensity": "7237.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "117",
                                "monoisotopic_mass": "2155.1328",
                                "monoisotopic_mz": "1078.5737",
                                "intensity": "6496.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "118",
                                "monoisotopic_mass": "4644.2865",
                                "monoisotopic_mz": "2323.1505",
                                "intensity": "6960.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "119",
                                "monoisotopic_mass": "4459.2343",
                                "monoisotopic_mz": "2230.6244",
                                "intensity": "3759.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "120",
                                "monoisotopic_mass": "1888.9958",
                                "monoisotopic_mz": "945.5052",
                                "intensity": "5460.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "121",
                                "monoisotopic_mass": "2591.3166",
                                "monoisotopic_mz": "1296.6656",
                                "intensity": "10459.11",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "proteoform_mass": "7327.7735",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "N"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "E"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "N"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "S"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "I"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "101",
                                        "peak_id": "76",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "101",
                                        "peak_id": "69",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "101",
                                        "peak_id": "90",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "101",
                                        "peak_id": "60",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "101",
                                        "peak_id": "35",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "101",
                                        "peak_id": "85",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "101",
                                        "peak_id": "46",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "101",
                                            "peak_id": "32",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "101",
                                            "peak_id": "108",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "101",
                                            "peak_id": "77",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "101",
                                            "peak_id": "101",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "101",
                                        "peak_id": "53",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "101",
                                        "peak_id": "48",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "101",
                                        "peak_id": "62",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "101",
                                            "peak_id": "50",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "101",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "101",
                                            "peak_id": "30",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "101",
                                            "peak_id": "94",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "101",
                                            "peak_id": "71",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "101",
                                            "peak_id": "83",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "101",
                                        "peak_id": "113",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "101",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "101",
                                            "peak_id": "100",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "101",
                                            "peak_id": "114",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "101",
                                            "peak_id": "91",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "40",
                                        "spec_id": "101",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "101",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "29",
                                            "ion_display_position": "39",
                                            "spec_id": "101",
                                            "peak_id": "110",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "101",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "38",
                                            "spec_id": "101",
                                            "peak_id": "49",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "37",
                                        "spec_id": "101",
                                        "peak_id": "79",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "36",
                                        "spec_id": "101",
                                        "peak_id": "67",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "101",
                                            "peak_id": "42",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "101",
                                            "peak_id": "99",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "33",
                                        "spec_id": "101",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "32",
                                        "spec_id": "101",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "27",
                                        "spec_id": "101",
                                        "peak_id": "36",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "23",
                                        "spec_id": "101",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "spec_id": "101",
                                        "peak_id": "64",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "31",
                "p_value": "3.98e-21",
                "e_value": "3.98e-21",
                "fdr": "0",
                "matched_fragment_number": "27",
                "matched_peak_number": "34",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "522",
                        "ms1_scans": "591",
                        "ids": "68",
                        "scans": "592",
                        "precursor_mono_mass": "7327.7964",
                        "precursor_charge": "5",
                        "precursor_mz": "1466.5666",
                        "feature_inte": "1.0712e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "68",
                                "peak_id": "0",
                                "monoisotopic_mass": "1382.7575",
                                "monoisotopic_mz": "1383.7648",
                                "intensity": "1468.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1382.7518",
                                        "ion_position": "53",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "53",
                                        "mass_error": "0.0057",
                                        "ppm": "4.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "1",
                                "monoisotopic_mass": "1974.4812",
                                "monoisotopic_mz": "1975.4884",
                                "intensity": "1360.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "2",
                                "monoisotopic_mass": "2167.1681",
                                "monoisotopic_mz": "2168.1753",
                                "intensity": "2419.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.1578",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0102",
                                        "ppm": "4.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "3",
                                "monoisotopic_mass": "2391.2056",
                                "monoisotopic_mz": "2392.2129",
                                "intensity": "2069.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "4",
                                "monoisotopic_mass": "1702.9015",
                                "monoisotopic_mz": "1703.9088",
                                "intensity": "3248.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1702.9155",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0139",
                                        "ppm": "-8.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "5",
                                "monoisotopic_mass": "2268.2137",
                                "monoisotopic_mz": "2269.2210",
                                "intensity": "2577.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0082",
                                        "ppm": "3.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "6",
                                "monoisotopic_mass": "1742.8966",
                                "monoisotopic_mz": "1743.9039",
                                "intensity": "3100.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "7",
                                "monoisotopic_mass": "1551.7828",
                                "monoisotopic_mz": "1552.7900",
                                "intensity": "7237.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "8",
                                "monoisotopic_mass": "974.4391",
                                "monoisotopic_mz": "975.4464",
                                "intensity": "2912.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "9",
                                "monoisotopic_mass": "1167.6665",
                                "monoisotopic_mz": "1168.6738",
                                "intensity": "1894.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1167.6612",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0054",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "10",
                                "monoisotopic_mass": "2341.2508",
                                "monoisotopic_mz": "2342.2581",
                                "intensity": "2986.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2341.2390",
                                        "ion_position": "45",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0118",
                                        "ppm": "5.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "11",
                                "monoisotopic_mass": "1187.6879",
                                "monoisotopic_mz": "1188.6952",
                                "intensity": "6061.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1187.6815",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0064",
                                        "ppm": "5.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "12",
                                "monoisotopic_mass": "1529.8034",
                                "monoisotopic_mz": "1530.8107",
                                "intensity": "12343.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "13",
                                "monoisotopic_mass": "3678.8649",
                                "monoisotopic_mz": "1840.4397",
                                "intensity": "3415.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "14",
                                "monoisotopic_mass": "1430.7757",
                                "monoisotopic_mz": "1431.7830",
                                "intensity": "7565.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0086",
                                        "ppm": "6.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "15",
                                "monoisotopic_mass": "2250.2010",
                                "monoisotopic_mz": "2251.2083",
                                "intensity": "2504.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "16",
                                "monoisotopic_mass": "3533.7968",
                                "monoisotopic_mz": "1767.9057",
                                "intensity": "4196.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "17",
                                "monoisotopic_mass": "1979.0433",
                                "monoisotopic_mz": "990.5290",
                                "intensity": "11534.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "18",
                                "monoisotopic_mass": "1768.0798",
                                "monoisotopic_mz": "885.0472",
                                "intensity": "1451.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "19",
                                "monoisotopic_mass": "2054.0827",
                                "monoisotopic_mz": "1028.0486",
                                "intensity": "12257.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2054.0738",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0089",
                                        "ppm": "4.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "20",
                                "monoisotopic_mass": "1006.6334",
                                "monoisotopic_mz": "1007.6407",
                                "intensity": "5226.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "21",
                                "monoisotopic_mass": "3242.6549",
                                "monoisotopic_mz": "1622.3347",
                                "intensity": "3709.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3242.6400",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0149",
                                        "ppm": "4.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "22",
                                "monoisotopic_mass": "1849.9938",
                                "monoisotopic_mz": "926.0042",
                                "intensity": "6504.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1849.9839",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0099",
                                        "ppm": "5.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "23",
                                "monoisotopic_mass": "1073.5081",
                                "monoisotopic_mz": "1074.5154",
                                "intensity": "6633.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "24",
                                "monoisotopic_mass": "1567.7493",
                                "monoisotopic_mz": "1568.7566",
                                "intensity": "3241.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "25",
                                "monoisotopic_mass": "1645.9039",
                                "monoisotopic_mz": "1646.9111",
                                "intensity": "4965.00",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1645.8940",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0098",
                                        "ppm": "5.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "26",
                                "monoisotopic_mass": "2268.2186",
                                "monoisotopic_mz": "1135.1166",
                                "intensity": "14853.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0131",
                                        "ppm": "5.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "27",
                                "monoisotopic_mass": "2609.3320",
                                "monoisotopic_mz": "2610.3393",
                                "intensity": "2078.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2609.3278",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0042",
                                        "ppm": "1.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "28",
                                "monoisotopic_mass": "1684.9112",
                                "monoisotopic_mz": "843.4629",
                                "intensity": "1999.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "29",
                                "monoisotopic_mass": "1301.7308",
                                "monoisotopic_mz": "1302.7380",
                                "intensity": "4797.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1301.7244",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0063",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "30",
                                "monoisotopic_mass": "3849.0204",
                                "monoisotopic_mz": "1925.5175",
                                "intensity": "6081.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3849.0061",
                                        "ion_position": "31",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "Y00037",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0143",
                                        "ppm": "3.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "31",
                                "monoisotopic_mass": "1529.7988",
                                "monoisotopic_mz": "765.9067",
                                "intensity": "2198.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "32",
                                "monoisotopic_mass": "726.4421",
                                "monoisotopic_mz": "727.4493",
                                "intensity": "12475.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "726.4388",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0032",
                                        "ppm": "4.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "33",
                                "monoisotopic_mass": "1822.0181",
                                "monoisotopic_mz": "912.0163",
                                "intensity": "2873.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "34",
                                "monoisotopic_mass": "1702.8987",
                                "monoisotopic_mz": "852.4566",
                                "intensity": "8074.65",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1702.9155",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0168",
                                        "ppm": "-9.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "35",
                                "monoisotopic_mass": "1317.6890",
                                "monoisotopic_mz": "1318.6963",
                                "intensity": "1739.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "36",
                                "monoisotopic_mass": "847.4051",
                                "monoisotopic_mz": "848.4124",
                                "intensity": "11102.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "37",
                                "monoisotopic_mass": "3701.9650",
                                "monoisotopic_mz": "1851.9898",
                                "intensity": "7160.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3701.9377",
                                        "ion_position": "32",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "Y00036",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0273",
                                        "ppm": "7.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "38",
                                "monoisotopic_mass": "1210.5667",
                                "monoisotopic_mz": "1211.5740",
                                "intensity": "4867.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "39",
                                "monoisotopic_mass": "2167.1679",
                                "monoisotopic_mz": "1084.5912",
                                "intensity": "11755.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.1578",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0100",
                                        "ppm": "4.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "40",
                                "monoisotopic_mass": "2026.0918",
                                "monoisotopic_mz": "1014.0532",
                                "intensity": "2991.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "41",
                                "monoisotopic_mass": "1398.7740",
                                "monoisotopic_mz": "1399.7812",
                                "intensity": "2456.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "42",
                                "monoisotopic_mass": "1022.6087",
                                "monoisotopic_mz": "1023.6160",
                                "intensity": "3052.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "43",
                                "monoisotopic_mass": "1645.9021",
                                "monoisotopic_mz": "823.9583",
                                "intensity": "4508.16",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1645.8940",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0080",
                                        "ppm": "4.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "44",
                                "monoisotopic_mass": "3413.7959",
                                "monoisotopic_mz": "1707.9052",
                                "intensity": "3911.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "45",
                                "monoisotopic_mass": "1907.0107",
                                "monoisotopic_mz": "954.5127",
                                "intensity": "4709.02",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1907.0054",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0054",
                                        "ppm": "2.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "46",
                                "monoisotopic_mass": "1445.8434",
                                "monoisotopic_mz": "1446.8507",
                                "intensity": "3792.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "47",
                                "monoisotopic_mass": "1445.8440",
                                "monoisotopic_mz": "723.9293",
                                "intensity": "1829.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "48",
                                "monoisotopic_mass": "1357.6358",
                                "monoisotopic_mz": "1358.6431",
                                "intensity": "4347.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "49",
                                "monoisotopic_mass": "2139.1737",
                                "monoisotopic_mz": "1070.5941",
                                "intensity": "4574.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "50",
                                "monoisotopic_mass": "2832.5343",
                                "monoisotopic_mz": "1417.2744",
                                "intensity": "4196.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "51",
                                "monoisotopic_mass": "2250.2074",
                                "monoisotopic_mz": "1126.1110",
                                "intensity": "5735.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "52",
                                "monoisotopic_mass": "3341.7336",
                                "monoisotopic_mz": "1671.8741",
                                "intensity": "6387.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3341.7085",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0252",
                                        "ppm": "7.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "53",
                                "monoisotopic_mass": "3288.6597",
                                "monoisotopic_mz": "1645.3371",
                                "intensity": "3026.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "54",
                                "monoisotopic_mass": "2946.4974",
                                "monoisotopic_mz": "1474.2560",
                                "intensity": "2663.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "55",
                                "monoisotopic_mass": "579.2677",
                                "monoisotopic_mz": "580.2750",
                                "intensity": "5870.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "56",
                                "monoisotopic_mass": "3806.9672",
                                "monoisotopic_mz": "1904.4909",
                                "intensity": "3344.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "57",
                                "monoisotopic_mass": "1040.6172",
                                "monoisotopic_mz": "1041.6245",
                                "intensity": "7574.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1040.6131",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0041",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "58",
                                "monoisotopic_mass": "866.3961",
                                "monoisotopic_mz": "867.4034",
                                "intensity": "754.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "59",
                                "monoisotopic_mass": "1430.7750",
                                "monoisotopic_mz": "716.3948",
                                "intensity": "1499.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0080",
                                        "ppm": "5.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "60",
                                "monoisotopic_mass": "2047.0379",
                                "monoisotopic_mz": "2048.0452",
                                "intensity": "2635.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "61",
                                "monoisotopic_mass": "3368.7136",
                                "monoisotopic_mz": "1685.3641",
                                "intensity": "2856.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "62",
                                "monoisotopic_mass": "3114.5697",
                                "monoisotopic_mz": "1558.2921",
                                "intensity": "3217.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "63",
                                "monoisotopic_mass": "2886.4501",
                                "monoisotopic_mz": "1444.2323",
                                "intensity": "2490.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "64",
                                "monoisotopic_mass": "1724.8825",
                                "monoisotopic_mz": "863.4485",
                                "intensity": "2297.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "65",
                                "monoisotopic_mass": "596.2944",
                                "monoisotopic_mz": "597.3017",
                                "intensity": "3254.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "66",
                                "monoisotopic_mass": "698.4470",
                                "monoisotopic_mz": "699.4542",
                                "intensity": "2377.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "67",
                                "monoisotopic_mass": "4149.0897",
                                "monoisotopic_mz": "2075.5521",
                                "intensity": "2533.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "68",
                                "monoisotopic_mass": "2996.5197",
                                "monoisotopic_mz": "999.8472",
                                "intensity": "1865.36",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2996.5032",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0164",
                                        "ppm": "5.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "69",
                                "monoisotopic_mass": "4744.3887",
                                "monoisotopic_mz": "1582.4702",
                                "intensity": "3665.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "70",
                                "monoisotopic_mass": "2552.5071",
                                "monoisotopic_mz": "1277.2608",
                                "intensity": "2621.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "71",
                                "monoisotopic_mass": "627.3731",
                                "monoisotopic_mz": "628.3804",
                                "intensity": "3141.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "627.3704",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0027",
                                        "ppm": "4.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "72",
                                "monoisotopic_mass": "777.3949",
                                "monoisotopic_mz": "778.4022",
                                "intensity": "928.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "73",
                                "monoisotopic_mass": "3986.0961",
                                "monoisotopic_mz": "1994.0553",
                                "intensity": "7037.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3986.0650",
                                        "ion_position": "30",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0311",
                                        "ppm": "7.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "74",
                                "monoisotopic_mass": "3200.6766",
                                "monoisotopic_mz": "1601.3456",
                                "intensity": "3301.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "75",
                                "monoisotopic_mass": "2996.5145",
                                "monoisotopic_mz": "1499.2645",
                                "intensity": "4385.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2996.5032",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0113",
                                        "ppm": "3.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "76",
                                "monoisotopic_mass": "1606.8457",
                                "monoisotopic_mz": "804.4301",
                                "intensity": "1367.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "77",
                                "monoisotopic_mass": "2456.3331",
                                "monoisotopic_mz": "1229.1738",
                                "intensity": "1939.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "78",
                                "monoisotopic_mass": "2810.5546",
                                "monoisotopic_mz": "1406.2846",
                                "intensity": "3120.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "79",
                                "monoisotopic_mass": "2576.3414",
                                "monoisotopic_mz": "1289.1780",
                                "intensity": "3706.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "80",
                                "monoisotopic_mass": "5059.6028",
                                "monoisotopic_mz": "1687.5415",
                                "intensity": "4508.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5059.5680",
                                        "ion_position": "20",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0348",
                                        "ppm": "6.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "81",
                                "monoisotopic_mass": "1625.8273",
                                "monoisotopic_mz": "1626.8346",
                                "intensity": "1589.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "82",
                                "monoisotopic_mass": "3306.6937",
                                "monoisotopic_mz": "1654.3541",
                                "intensity": "2475.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "83",
                                "monoisotopic_mass": "1889.0045",
                                "monoisotopic_mz": "945.5095",
                                "intensity": "1074.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "84",
                                "monoisotopic_mass": "2722.3905",
                                "monoisotopic_mz": "1362.2025",
                                "intensity": "1545.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "85",
                                "monoisotopic_mass": "3131.5935",
                                "monoisotopic_mz": "1566.8040",
                                "intensity": "3536.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "86",
                                "monoisotopic_mass": "1717.8649",
                                "monoisotopic_mz": "1718.8722",
                                "intensity": "2022.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "87",
                                "monoisotopic_mass": "1777.8819",
                                "monoisotopic_mz": "1778.8892",
                                "intensity": "1568.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "88",
                                "monoisotopic_mass": "2979.5093",
                                "monoisotopic_mz": "1490.7619",
                                "intensity": "1501.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "89",
                                "monoisotopic_mass": "3478.7864",
                                "monoisotopic_mz": "1160.6027",
                                "intensity": "2791.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3478.7674",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0190",
                                        "ppm": "5.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "90",
                                "monoisotopic_mass": "3800.0856",
                                "monoisotopic_mz": "1267.7025",
                                "intensity": "1443.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "91",
                                "monoisotopic_mass": "3784.9376",
                                "monoisotopic_mz": "1262.6532",
                                "intensity": "2688.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "92",
                                "monoisotopic_mass": "2963.4906",
                                "monoisotopic_mz": "1482.7526",
                                "intensity": "2094.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "93",
                                "monoisotopic_mass": "3782.9299",
                                "monoisotopic_mz": "1892.4722",
                                "intensity": "2822.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "94",
                                "monoisotopic_mass": "3500.8055",
                                "monoisotopic_mz": "1751.4100",
                                "intensity": "2078.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "95",
                                "monoisotopic_mass": "2494.3187",
                                "monoisotopic_mz": "1248.1666",
                                "intensity": "1672.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2494.3009",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0179",
                                        "ppm": "7.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "96",
                                "monoisotopic_mass": "1949.4964",
                                "monoisotopic_mz": "1950.5037",
                                "intensity": "1725.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "97",
                                "monoisotopic_mass": "1661.8471",
                                "monoisotopic_mz": "1662.8544",
                                "intensity": "2150.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "98",
                                "monoisotopic_mass": "3073.5807",
                                "monoisotopic_mz": "1537.7976",
                                "intensity": "1830.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "99",
                                "monoisotopic_mass": "2769.4046",
                                "monoisotopic_mz": "1385.7096",
                                "intensity": "1497.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "100",
                                "monoisotopic_mass": "5041.5717",
                                "monoisotopic_mz": "1681.5312",
                                "intensity": "2607.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "101",
                                "monoisotopic_mass": "3897.0157",
                                "monoisotopic_mz": "1300.0125",
                                "intensity": "3579.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3896.9890",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0267",
                                        "ppm": "6.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "102",
                                "monoisotopic_mass": "5778.7951",
                                "monoisotopic_mz": "1156.7663",
                                "intensity": "664.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "103",
                                "monoisotopic_mass": "2928.4479",
                                "monoisotopic_mz": "1465.2312",
                                "intensity": "73407.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "104",
                                "monoisotopic_mass": "1811.8983",
                                "monoisotopic_mz": "1812.9056",
                                "intensity": "2057.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "105",
                                "monoisotopic_mass": "6456.2976",
                                "monoisotopic_mz": "1615.0817",
                                "intensity": "3217.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "106",
                                "monoisotopic_mass": "3449.7584",
                                "monoisotopic_mz": "1725.8865",
                                "intensity": "1293.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "107",
                                "monoisotopic_mass": "4121.0369",
                                "monoisotopic_mz": "2061.5257",
                                "intensity": "1961.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "108",
                                "monoisotopic_mass": "1892.9710",
                                "monoisotopic_mz": "1893.9783",
                                "intensity": "1530.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "109",
                                "monoisotopic_mass": "3223.6475",
                                "monoisotopic_mz": "1612.8310",
                                "intensity": "2298.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "110",
                                "monoisotopic_mass": "2520.2895",
                                "monoisotopic_mz": "2521.2968",
                                "intensity": "1281.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "111",
                                "monoisotopic_mass": "1825.9328",
                                "monoisotopic_mz": "1826.9401",
                                "intensity": "2170.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "112",
                                "monoisotopic_mass": "4726.3470",
                                "monoisotopic_mz": "1576.4563",
                                "intensity": "1341.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "113",
                                "monoisotopic_mass": "6134.1025",
                                "monoisotopic_mz": "1534.5329",
                                "intensity": "822.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "114",
                                "monoisotopic_mass": "5478.7343",
                                "monoisotopic_mz": "1370.6909",
                                "intensity": "607.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "115",
                                "monoisotopic_mass": "2609.3440",
                                "monoisotopic_mz": "1305.6793",
                                "intensity": "4774.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2609.3278",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0162",
                                        "ppm": "6.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "116",
                                "monoisotopic_mass": "4856.4447",
                                "monoisotopic_mz": "1619.8222",
                                "intensity": "2200.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "117",
                                "monoisotopic_mass": "1842.9411",
                                "monoisotopic_mz": "1843.9484",
                                "intensity": "2105.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "118",
                                "monoisotopic_mass": "2516.2589",
                                "monoisotopic_mz": "1259.1367",
                                "intensity": "678.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "119",
                                "monoisotopic_mass": "4380.8543",
                                "monoisotopic_mz": "1461.2920",
                                "intensity": "1244.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "120",
                                "monoisotopic_mass": "4646.3076",
                                "monoisotopic_mz": "1549.7765",
                                "intensity": "3903.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "68",
                                "peak_id": "121",
                                "monoisotopic_mass": "3429.8057",
                                "monoisotopic_mz": "1715.9101",
                                "intensity": "3718.18",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "proteoform_mass": "7327.7735",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "N"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "E"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "N"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "S"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "I"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "68",
                                        "peak_id": "71",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "68",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "68",
                                        "peak_id": "57",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "68",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "68",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "68",
                                            "peak_id": "59",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "68",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "68",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "68",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "68",
                                            "peak_id": "34",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "68",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "68",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "68",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "68",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "68",
                                            "peak_id": "39",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "68",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "68",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "68",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "20",
                                            "ion_display_position": "48",
                                            "spec_id": "68",
                                            "peak_id": "80",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "68",
                                        "peak_id": "95",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "68",
                                            "peak_id": "27",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "68",
                                            "peak_id": "115",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "68",
                                            "peak_id": "75",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "68",
                                            "peak_id": "68",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "68",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "68",
                                            "peak_id": "52",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "30",
                                            "ion_display_position": "38",
                                            "spec_id": "68",
                                            "peak_id": "73",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "68",
                                            "peak_id": "89",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "37",
                                            "spec_id": "68",
                                            "peak_id": "30",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "36",
                                        "spec_id": "68",
                                        "peak_id": "37",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "68",
                                        "peak_id": "101",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "23",
                                        "spec_id": "68",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "53",
                                        "ion_display_position": "15",
                                        "spec_id": "68",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "68",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "58",
                "p_value": "5.43e-08",
                "e_value": "5.43e-08",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "537",
                        "ms1_scans": "651",
                        "ids": "113",
                        "scans": "652",
                        "precursor_mono_mass": "7327.7964",
                        "precursor_charge": "6",
                        "precursor_mz": "1222.3067",
                        "feature_inte": "1.0712e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "113",
                                "peak_id": "0",
                                "monoisotopic_mass": "1430.7757",
                                "monoisotopic_mz": "1431.7830",
                                "intensity": "1848.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0086",
                                        "ppm": "6.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "1",
                                "monoisotopic_mass": "1073.5066",
                                "monoisotopic_mz": "1074.5139",
                                "intensity": "1880.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "2",
                                "monoisotopic_mass": "1210.5682",
                                "monoisotopic_mz": "1211.5754",
                                "intensity": "1783.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "3",
                                "monoisotopic_mass": "1645.9012",
                                "monoisotopic_mz": "823.9579",
                                "intensity": "1285.78",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1645.8940",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0072",
                                        "ppm": "4.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "4",
                                "monoisotopic_mass": "942.4933",
                                "monoisotopic_mz": "943.5006",
                                "intensity": "1986.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "5",
                                "monoisotopic_mass": "854.5380",
                                "monoisotopic_mz": "855.5453",
                                "intensity": "1700.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "854.5338",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0042",
                                        "ppm": "4.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "6",
                                "monoisotopic_mass": "1301.7309",
                                "monoisotopic_mz": "1302.7382",
                                "intensity": "1019.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1301.7244",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0064",
                                        "ppm": "4.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "7",
                                "monoisotopic_mass": "1040.6169",
                                "monoisotopic_mz": "1041.6241",
                                "intensity": "1801.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1040.6131",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0038",
                                        "ppm": "3.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "8",
                                "monoisotopic_mass": "1434.7417",
                                "monoisotopic_mz": "718.3781",
                                "intensity": "867.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "9",
                                "monoisotopic_mass": "4566.1929",
                                "monoisotopic_mz": "1142.5555",
                                "intensity": "1741.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "10",
                                "monoisotopic_mass": "1378.7773",
                                "monoisotopic_mz": "1379.7845",
                                "intensity": "755.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "11",
                                "monoisotopic_mass": "974.4381",
                                "monoisotopic_mz": "975.4454",
                                "intensity": "1163.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "12",
                                "monoisotopic_mass": "724.3905",
                                "monoisotopic_mz": "725.3978",
                                "intensity": "1214.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "13",
                                "monoisotopic_mass": "4548.1568",
                                "monoisotopic_mz": "1138.0465",
                                "intensity": "3377.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "14",
                                "monoisotopic_mass": "2268.2204",
                                "monoisotopic_mz": "1135.1175",
                                "intensity": "3293.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0148",
                                        "ppm": "6.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "15",
                                "monoisotopic_mass": "1187.6884",
                                "monoisotopic_mz": "1188.6957",
                                "intensity": "1801.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1187.6815",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0069",
                                        "ppm": "5.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "16",
                                "monoisotopic_mass": "4885.6993",
                                "monoisotopic_mz": "1222.4321",
                                "intensity": "7384.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "17",
                                "monoisotopic_mass": "925.4977",
                                "monoisotopic_mz": "926.5049",
                                "intensity": "597.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "18",
                                "monoisotopic_mass": "1481.7488",
                                "monoisotopic_mz": "1482.7561",
                                "intensity": "789.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "19",
                                "monoisotopic_mass": "2946.4828",
                                "monoisotopic_mz": "1474.2487",
                                "intensity": "1393.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "20",
                                "monoisotopic_mass": "1958.9785",
                                "monoisotopic_mz": "980.4965",
                                "intensity": "478.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "21",
                                "monoisotopic_mass": "1541.7928",
                                "monoisotopic_mz": "1542.8001",
                                "intensity": "907.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "22",
                                "monoisotopic_mass": "1278.6726",
                                "monoisotopic_mz": "640.3436",
                                "intensity": "283.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "23",
                                "monoisotopic_mass": "1467.7463",
                                "monoisotopic_mz": "1468.7535",
                                "intensity": "345.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "24",
                                "monoisotopic_mass": "579.2684",
                                "monoisotopic_mz": "580.2756",
                                "intensity": "850.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "25",
                                "monoisotopic_mass": "1262.6316",
                                "monoisotopic_mz": "1263.6389",
                                "intensity": "273.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "26",
                                "monoisotopic_mass": "675.3439",
                                "monoisotopic_mz": "676.3512",
                                "intensity": "396.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "27",
                                "monoisotopic_mass": "4868.6920",
                                "monoisotopic_mz": "1218.1803",
                                "intensity": "1239.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "28",
                                "monoisotopic_mass": "596.2941",
                                "monoisotopic_mz": "597.3014",
                                "intensity": "562.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "29",
                                "monoisotopic_mass": "511.2776",
                                "monoisotopic_mz": "512.2848",
                                "intensity": "908.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "30",
                                "monoisotopic_mass": "1174.5552",
                                "monoisotopic_mz": "1175.5625",
                                "intensity": "687.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "31",
                                "monoisotopic_mass": "4819.4406",
                                "monoisotopic_mz": "1205.8674",
                                "intensity": "539.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "32",
                                "monoisotopic_mass": "764.8999",
                                "monoisotopic_mz": "765.9072",
                                "intensity": "601.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "33",
                                "monoisotopic_mass": "624.3139",
                                "monoisotopic_mz": "625.3212",
                                "intensity": "931.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "34",
                                "monoisotopic_mass": "1146.1443",
                                "monoisotopic_mz": "1147.1516",
                                "intensity": "712.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "35",
                                "monoisotopic_mass": "2138.1706",
                                "monoisotopic_mz": "1070.0926",
                                "intensity": "1007.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "36",
                                "monoisotopic_mass": "3604.6655",
                                "monoisotopic_mz": "1202.5624",
                                "intensity": "655.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "37",
                                "monoisotopic_mass": "2249.1960",
                                "monoisotopic_mz": "1125.6053",
                                "intensity": "1425.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "38",
                                "monoisotopic_mass": "2609.3386",
                                "monoisotopic_mz": "1305.6766",
                                "intensity": "1666.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2609.3278",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0108",
                                        "ppm": "4.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "39",
                                "monoisotopic_mass": "2053.0823",
                                "monoisotopic_mz": "1027.5484",
                                "intensity": "3166.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "40",
                                "monoisotopic_mass": "1978.0392",
                                "monoisotopic_mz": "990.0269",
                                "intensity": "1515.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "41",
                                "monoisotopic_mass": "2166.1648",
                                "monoisotopic_mz": "1084.0897",
                                "intensity": "2699.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "113",
                                "peak_id": "42",
                                "monoisotopic_mass": "4298.3443",
                                "monoisotopic_mz": "1075.5934",
                                "intensity": "478.17",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "proteoform_mass": "7327.7735",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "N"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "E"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "N"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "S"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "I"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "113",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "113",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "113",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "113",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "113",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "113",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "113",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "113",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "41",
                "p_value": "1.05e-07",
                "e_value": "1.05e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "526",
                        "ms1_scans": "607",
                        "ids": "81",
                        "scans": "609",
                        "precursor_mono_mass": "7327.7964",
                        "precursor_charge": "6",
                        "precursor_mz": "1222.3067",
                        "feature_inte": "1.0712e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "81",
                                "peak_id": "0",
                                "monoisotopic_mass": "1589.7270",
                                "monoisotopic_mz": "1590.7343",
                                "intensity": "924.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "1",
                                "monoisotopic_mass": "1551.7811",
                                "monoisotopic_mz": "1552.7883",
                                "intensity": "2899.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "2",
                                "monoisotopic_mass": "1301.7299",
                                "monoisotopic_mz": "1302.7372",
                                "intensity": "1151.57",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1301.7244",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0055",
                                        "ppm": "4.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "3",
                                "monoisotopic_mass": "1979.0432",
                                "monoisotopic_mz": "990.5289",
                                "intensity": "5932.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "4",
                                "monoisotopic_mass": "4548.1730",
                                "monoisotopic_mz": "1138.0505",
                                "intensity": "4743.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "5",
                                "monoisotopic_mass": "2016.9917",
                                "monoisotopic_mz": "1009.5031",
                                "intensity": "2051.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "6",
                                "monoisotopic_mass": "2001.0303",
                                "monoisotopic_mz": "1001.5224",
                                "intensity": "1822.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "7",
                                "monoisotopic_mass": "1529.8050",
                                "monoisotopic_mz": "1530.8123",
                                "intensity": "3678.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "8",
                                "monoisotopic_mass": "726.4423",
                                "monoisotopic_mz": "727.4496",
                                "intensity": "2073.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "726.4388",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0035",
                                        "ppm": "4.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "9",
                                "monoisotopic_mass": "942.4933",
                                "monoisotopic_mz": "943.5005",
                                "intensity": "2805.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "10",
                                "monoisotopic_mass": "1357.6366",
                                "monoisotopic_mz": "1358.6439",
                                "intensity": "917.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "11",
                                "monoisotopic_mass": "1849.9882",
                                "monoisotopic_mz": "926.0014",
                                "intensity": "1097.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1849.9839",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0043",
                                        "ppm": "2.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "12",
                                "monoisotopic_mass": "1702.8974",
                                "monoisotopic_mz": "852.4560",
                                "intensity": "3782.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "13",
                                "monoisotopic_mass": "1567.7458",
                                "monoisotopic_mz": "784.8802",
                                "intensity": "1795.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "14",
                                "monoisotopic_mass": "1210.5648",
                                "monoisotopic_mz": "1211.5720",
                                "intensity": "1156.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "15",
                                "monoisotopic_mass": "1724.8818",
                                "monoisotopic_mz": "863.4482",
                                "intensity": "2357.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "16",
                                "monoisotopic_mass": "1589.7271",
                                "monoisotopic_mz": "795.8709",
                                "intensity": "2205.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "17",
                                "monoisotopic_mass": "1611.7075",
                                "monoisotopic_mz": "806.8610",
                                "intensity": "1177.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "18",
                                "monoisotopic_mass": "2268.2179",
                                "monoisotopic_mz": "1135.1162",
                                "intensity": "2757.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0124",
                                        "ppm": "5.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "19",
                                "monoisotopic_mass": "1430.7747",
                                "monoisotopic_mz": "1431.7820",
                                "intensity": "1402.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0077",
                                        "ppm": "5.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "20",
                                "monoisotopic_mass": "1132.5406",
                                "monoisotopic_mz": "1133.5479",
                                "intensity": "1060.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "21",
                                "monoisotopic_mass": "847.4051",
                                "monoisotopic_mz": "848.4124",
                                "intensity": "4454.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "22",
                                "monoisotopic_mass": "1430.7716",
                                "monoisotopic_mz": "716.3931",
                                "intensity": "1062.45",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0045",
                                        "ppm": "3.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "23",
                                "monoisotopic_mass": "1463.7264",
                                "monoisotopic_mz": "1464.7336",
                                "intensity": "927.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "24",
                                "monoisotopic_mass": "1529.7986",
                                "monoisotopic_mz": "765.9066",
                                "intensity": "2131.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "25",
                                "monoisotopic_mass": "1073.5060",
                                "monoisotopic_mz": "1074.5133",
                                "intensity": "1642.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "26",
                                "monoisotopic_mass": "3623.6982",
                                "monoisotopic_mz": "1208.9067",
                                "intensity": "1599.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "27",
                                "monoisotopic_mass": "1551.7792",
                                "monoisotopic_mz": "776.8969",
                                "intensity": "1838.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "28",
                                "monoisotopic_mass": "3062.5455",
                                "monoisotopic_mz": "1021.8558",
                                "intensity": "1182.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "29",
                                "monoisotopic_mass": "803.9233",
                                "monoisotopic_mz": "804.9305",
                                "intensity": "427.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "30",
                                "monoisotopic_mass": "974.4399",
                                "monoisotopic_mz": "975.4471",
                                "intensity": "457.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "31",
                                "monoisotopic_mass": "710.2894",
                                "monoisotopic_mz": "711.2966",
                                "intensity": "776.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "32",
                                "monoisotopic_mass": "1740.8476",
                                "monoisotopic_mz": "871.4311",
                                "intensity": "1419.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "33",
                                "monoisotopic_mass": "3605.6653",
                                "monoisotopic_mz": "1202.8957",
                                "intensity": "2106.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "34",
                                "monoisotopic_mass": "2054.0841",
                                "monoisotopic_mz": "1028.0493",
                                "intensity": "2045.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2054.0738",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0103",
                                        "ppm": "5.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "35",
                                "monoisotopic_mass": "2834.5387",
                                "monoisotopic_mz": "945.8535",
                                "intensity": "1013.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "36",
                                "monoisotopic_mass": "752.4039",
                                "monoisotopic_mz": "753.4112",
                                "intensity": "982.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "37",
                                "monoisotopic_mass": "3354.7464",
                                "monoisotopic_mz": "1119.2561",
                                "intensity": "645.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "38",
                                "monoisotopic_mass": "1187.6874",
                                "monoisotopic_mz": "1188.6947",
                                "intensity": "872.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1187.6815",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0059",
                                        "ppm": "4.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "39",
                                "monoisotopic_mass": "2167.1635",
                                "monoisotopic_mz": "1084.5890",
                                "intensity": "2441.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2167.1578",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0056",
                                        "ppm": "2.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "40",
                                "monoisotopic_mass": "497.2255",
                                "monoisotopic_mz": "498.2328",
                                "intensity": "759.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "41",
                                "monoisotopic_mass": "1908.0187",
                                "monoisotopic_mz": "955.0166",
                                "intensity": "1308.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "42",
                                "monoisotopic_mass": "1373.6685",
                                "monoisotopic_mz": "1374.6758",
                                "intensity": "617.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "43",
                                "monoisotopic_mass": "624.3153",
                                "monoisotopic_mz": "625.3226",
                                "intensity": "915.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "44",
                                "monoisotopic_mass": "2283.5944",
                                "monoisotopic_mz": "1142.8045",
                                "intensity": "2387.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "45",
                                "monoisotopic_mass": "1040.6170",
                                "monoisotopic_mz": "1041.6243",
                                "intensity": "1395.34",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1040.6131",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0039",
                                        "ppm": "3.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "46",
                                "monoisotopic_mass": "3342.7375",
                                "monoisotopic_mz": "1672.3760",
                                "intensity": "499.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "47",
                                "monoisotopic_mass": "957.4964",
                                "monoisotopic_mz": "958.5037",
                                "intensity": "533.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "48",
                                "monoisotopic_mass": "1174.5540",
                                "monoisotopic_mz": "1175.5613",
                                "intensity": "658.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "49",
                                "monoisotopic_mass": "1417.7200",
                                "monoisotopic_mz": "1418.7273",
                                "intensity": "282.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "50",
                                "monoisotopic_mass": "1244.6149",
                                "monoisotopic_mz": "1245.6222",
                                "intensity": "289.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "51",
                                "monoisotopic_mass": "1018.5383",
                                "monoisotopic_mz": "1019.5455",
                                "intensity": "542.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "52",
                                "monoisotopic_mass": "2446.2379",
                                "monoisotopic_mz": "1224.1262",
                                "intensity": "2379.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "53",
                                "monoisotopic_mass": "4187.0738",
                                "monoisotopic_mz": "1396.6985",
                                "intensity": "488.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "54",
                                "monoisotopic_mass": "2328.2278",
                                "monoisotopic_mz": "1165.1212",
                                "intensity": "597.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "55",
                                "monoisotopic_mass": "4884.6999",
                                "monoisotopic_mz": "1222.1823",
                                "intensity": "9809.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "56",
                                "monoisotopic_mass": "3667.9918",
                                "monoisotopic_mz": "1223.6712",
                                "intensity": "1585.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "57",
                                "monoisotopic_mass": "2945.4743",
                                "monoisotopic_mz": "1473.7444",
                                "intensity": "560.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "58",
                                "monoisotopic_mass": "2917.4822",
                                "monoisotopic_mz": "1459.7484",
                                "intensity": "459.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "59",
                                "monoisotopic_mass": "2608.3354",
                                "monoisotopic_mz": "1305.1750",
                                "intensity": "1724.80",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "proteoform_mass": "7327.7735",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "N"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "E"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "N"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "S"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "I"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "81",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "81",
                                        "peak_id": "45",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "81",
                                        "peak_id": "38",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "81",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "81",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "81",
                                            "peak_id": "19",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "81",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "81",
                                        "peak_id": "34",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "81",
                                        "peak_id": "39",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "81",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "130",
                "p_value": "4.73e-07",
                "e_value": "4.73e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "608",
                        "ms1_scans": "935",
                        "ids": "327",
                        "scans": "937",
                        "precursor_mono_mass": "7327.7903",
                        "precursor_charge": "5",
                        "precursor_mz": "1466.5653",
                        "feature_inte": "1.9162e+06"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "327",
                                "peak_id": "0",
                                "monoisotopic_mass": "1891.9668",
                                "monoisotopic_mz": "1892.9740",
                                "intensity": "1221.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "1",
                                "monoisotopic_mass": "1187.6890",
                                "monoisotopic_mz": "1188.6963",
                                "intensity": "1324.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1187.6815",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0075",
                                        "ppm": "6.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "2",
                                "monoisotopic_mass": "3745.3223",
                                "monoisotopic_mz": "1249.4481",
                                "intensity": "1877.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "3",
                                "monoisotopic_mass": "2268.2118",
                                "monoisotopic_mz": "1135.1132",
                                "intensity": "2963.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2268.2055",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0063",
                                        "ppm": "2.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "4",
                                "monoisotopic_mass": "1380.0331",
                                "monoisotopic_mz": "1381.0404",
                                "intensity": "1130.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "5",
                                "monoisotopic_mass": "2921.4181",
                                "monoisotopic_mz": "1461.7163",
                                "intensity": "1822.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "6",
                                "monoisotopic_mass": "726.4421",
                                "monoisotopic_mz": "727.4493",
                                "intensity": "2530.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "726.4388",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0032",
                                        "ppm": "4.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "7",
                                "monoisotopic_mass": "1540.8954",
                                "monoisotopic_mz": "771.4550",
                                "intensity": "2035.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "8",
                                "monoisotopic_mass": "1464.9113",
                                "monoisotopic_mz": "1465.9186",
                                "intensity": "2385.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "9",
                                "monoisotopic_mass": "2281.2113",
                                "monoisotopic_mz": "1141.6129",
                                "intensity": "3444.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "10",
                                "monoisotopic_mass": "1040.6161",
                                "monoisotopic_mz": "1041.6234",
                                "intensity": "1786.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1040.6131",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0030",
                                        "ppm": "2.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "11",
                                "monoisotopic_mass": "627.3733",
                                "monoisotopic_mz": "628.3806",
                                "intensity": "633.71",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "627.3704",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0029",
                                        "ppm": "4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "12",
                                "monoisotopic_mass": "579.2676",
                                "monoisotopic_mz": "580.2748",
                                "intensity": "1034.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "13",
                                "monoisotopic_mass": "1367.4026",
                                "monoisotopic_mz": "1368.4099",
                                "intensity": "938.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "14",
                                "monoisotopic_mass": "2297.1732",
                                "monoisotopic_mz": "1149.5939",
                                "intensity": "3018.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "15",
                                "monoisotopic_mass": "854.5380",
                                "monoisotopic_mz": "855.5453",
                                "intensity": "1509.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "854.5338",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0042",
                                        "ppm": "4.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "16",
                                "monoisotopic_mass": "910.9994",
                                "monoisotopic_mz": "912.0067",
                                "intensity": "625.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "17",
                                "monoisotopic_mass": "596.2940",
                                "monoisotopic_mz": "597.3013",
                                "intensity": "824.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "18",
                                "monoisotopic_mass": "1246.2189",
                                "monoisotopic_mz": "1247.2262",
                                "intensity": "1133.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "19",
                                "monoisotopic_mass": "1260.1127",
                                "monoisotopic_mz": "1261.1200",
                                "intensity": "1238.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "20",
                                "monoisotopic_mass": "6646.1118",
                                "monoisotopic_mz": "1330.2296",
                                "intensity": "671.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "21",
                                "monoisotopic_mass": "2317.1906",
                                "monoisotopic_mz": "1159.6026",
                                "intensity": "551.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "22",
                                "monoisotopic_mass": "2054.0814",
                                "monoisotopic_mz": "1028.0480",
                                "intensity": "2293.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2054.0738",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0077",
                                        "ppm": "3.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "23",
                                "monoisotopic_mass": "1434.7439",
                                "monoisotopic_mz": "718.3792",
                                "intensity": "723.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "24",
                                "monoisotopic_mass": "924.9952",
                                "monoisotopic_mz": "926.0024",
                                "intensity": "979.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "25",
                                "monoisotopic_mass": "4769.5495",
                                "monoisotopic_mz": "954.9172",
                                "intensity": "666.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "26",
                                "monoisotopic_mass": "827.3694",
                                "monoisotopic_mz": "828.3767",
                                "intensity": "592.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "27",
                                "monoisotopic_mass": "2387.2582",
                                "monoisotopic_mz": "1194.6364",
                                "intensity": "879.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "28",
                                "monoisotopic_mass": "6488.0252",
                                "monoisotopic_mz": "1298.6123",
                                "intensity": "678.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "29",
                                "monoisotopic_mass": "1167.5618",
                                "monoisotopic_mz": "1168.5691",
                                "intensity": "856.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "30",
                                "monoisotopic_mass": "1120.6943",
                                "monoisotopic_mz": "1121.7015",
                                "intensity": "1124.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "31",
                                "monoisotopic_mass": "1349.5174",
                                "monoisotopic_mz": "1350.5247",
                                "intensity": "1014.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "32",
                                "monoisotopic_mass": "6473.1796",
                                "monoisotopic_mz": "1295.6432",
                                "intensity": "505.02",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6473.2397",
                                        "ion_position": "8",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0601",
                                        "ppm": "-9.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "33",
                                "monoisotopic_mass": "5512.1753",
                                "monoisotopic_mz": "1379.0511",
                                "intensity": "1263.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "34",
                                "monoisotopic_mass": "4502.4147",
                                "monoisotopic_mz": "1126.6109",
                                "intensity": "1838.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "35",
                                "monoisotopic_mass": "512.3344",
                                "monoisotopic_mz": "513.3417",
                                "intensity": "756.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "36",
                                "monoisotopic_mass": "4833.9742",
                                "monoisotopic_mz": "1209.5008",
                                "intensity": "1506.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "37",
                                "monoisotopic_mass": "1492.7801",
                                "monoisotopic_mz": "1493.7874",
                                "intensity": "980.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "38",
                                "monoisotopic_mass": "2686.6627",
                                "monoisotopic_mz": "1344.3386",
                                "intensity": "1335.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "39",
                                "monoisotopic_mass": "6599.2795",
                                "monoisotopic_mz": "1320.8632",
                                "intensity": "1350.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "40",
                                "monoisotopic_mass": "1326.1313",
                                "monoisotopic_mz": "1327.1386",
                                "intensity": "545.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "41",
                                "monoisotopic_mass": "984.6097",
                                "monoisotopic_mz": "985.6169",
                                "intensity": "402.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "42",
                                "monoisotopic_mass": "2743.6774",
                                "monoisotopic_mz": "1372.8460",
                                "intensity": "1406.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "43",
                                "monoisotopic_mass": "2424.8789",
                                "monoisotopic_mz": "1213.4467",
                                "intensity": "1115.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "44",
                                "monoisotopic_mass": "1430.7718",
                                "monoisotopic_mz": "1431.7791",
                                "intensity": "1647.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1430.7670",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0047",
                                        "ppm": "3.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "45",
                                "monoisotopic_mass": "1026.9720",
                                "monoisotopic_mz": "1027.9792",
                                "intensity": "770.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "46",
                                "monoisotopic_mass": "5572.7191",
                                "monoisotopic_mz": "1394.1870",
                                "intensity": "1703.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "47",
                                "monoisotopic_mass": "4001.9147",
                                "monoisotopic_mz": "1334.9788",
                                "intensity": "2152.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "48",
                                "monoisotopic_mass": "4628.7907",
                                "monoisotopic_mz": "1158.2050",
                                "intensity": "555.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "49",
                                "monoisotopic_mass": "5658.4515",
                                "monoisotopic_mz": "1132.6976",
                                "intensity": "531.68",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "50",
                                "monoisotopic_mass": "4091.5125",
                                "monoisotopic_mz": "1364.8448",
                                "intensity": "548.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "51",
                                "monoisotopic_mass": "3980.9538",
                                "monoisotopic_mz": "1327.9919",
                                "intensity": "1196.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "52",
                                "monoisotopic_mass": "2861.1208",
                                "monoisotopic_mz": "1431.5677",
                                "intensity": "1654.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "53",
                                "monoisotopic_mass": "4367.7110",
                                "monoisotopic_mz": "1092.9350",
                                "intensity": "744.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "54",
                                "monoisotopic_mass": "2166.1680",
                                "monoisotopic_mz": "1084.0913",
                                "intensity": "2344.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "55",
                                "monoisotopic_mass": "3391.5788",
                                "monoisotopic_mz": "1131.5335",
                                "intensity": "532.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "56",
                                "monoisotopic_mass": "2848.7761",
                                "monoisotopic_mz": "1425.3953",
                                "intensity": "1571.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "57",
                                "monoisotopic_mass": "2718.4192",
                                "monoisotopic_mz": "1360.2169",
                                "intensity": "1760.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "58",
                                "monoisotopic_mass": "2816.4768",
                                "monoisotopic_mz": "1409.2457",
                                "intensity": "901.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "59",
                                "monoisotopic_mass": "6501.6803",
                                "monoisotopic_mz": "1301.3433",
                                "intensity": "1804.65",
                                "charge": "5"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "60",
                                "monoisotopic_mass": "5165.1935",
                                "monoisotopic_mz": "1292.3056",
                                "intensity": "1598.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "61",
                                "monoisotopic_mass": "4287.1472",
                                "monoisotopic_mz": "1430.0563",
                                "intensity": "1620.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "62",
                                "monoisotopic_mass": "3470.1391",
                                "monoisotopic_mz": "1157.7203",
                                "intensity": "471.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "63",
                                "monoisotopic_mass": "3513.1688",
                                "monoisotopic_mz": "1172.0635",
                                "intensity": "746.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "64",
                                "monoisotopic_mass": "3490.2022",
                                "monoisotopic_mz": "1164.4080",
                                "intensity": "774.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "65",
                                "monoisotopic_mass": "3598.8530",
                                "monoisotopic_mz": "1200.6249",
                                "intensity": "529.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "66",
                                "monoisotopic_mass": "2361.4506",
                                "monoisotopic_mz": "1181.7326",
                                "intensity": "510.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "327",
                                "peak_id": "67",
                                "monoisotopic_mass": "4130.7692",
                                "monoisotopic_mz": "1377.9303",
                                "intensity": "445.97",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "proteoform_mass": "7327.7735",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "N"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "E"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "R"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "N"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "S"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "I"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "327",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "327",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "327",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "8",
                                            "ion_display_position": "60",
                                            "spec_id": "327",
                                            "peak_id": "32",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "327",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "327",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "327",
                                        "peak_id": "44",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "327",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "327",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
