prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "34",
        "sequence_name": "sp|P68066|GRCA_ECOLI",
        "sequence_description": "Autonomous glycyl radical cofactor OS=Escherichia coli (strain K12) OX=83333 GN=grcA PE=1 SV=1",
        "proteoform_id": "43",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "147",
            "p_value": "2.06e-03",
            "e_value": "2.06e-03",
            "fdr": "0",
            "matched_fragment_number": "8",
            "matched_peak_number": "8",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                    "ms1_ids": "617",
                    "ms1_scans": "969",
                    "ids": "353",
                    "scans": "972",
                    "precursor_mono_mass": "14763.4700",
                    "precursor_charge": "7",
                    "precursor_mz": "2110.0744",
                    "feature_inte": "2.2746e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "353",
                            "peak_id": "0",
                            "monoisotopic_mass": "2573.3248",
                            "monoisotopic_mz": "2574.3321",
                            "intensity": "2843.91",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2573.3200",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "ion_sort_name": "B00023",
                                    "ion_left_position": "23",
                                    "mass_error": "0.0048",
                                    "ppm": "1.88"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "1",
                            "monoisotopic_mass": "1356.7124",
                            "monoisotopic_mz": "1357.7197",
                            "intensity": "1754.12",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1356.7071",
                                    "ion_position": "13",
                                    "ion_display_position": "13",
                                    "ion_sort_name": "B00013",
                                    "ion_left_position": "13",
                                    "mass_error": "0.0053",
                                    "ppm": "3.92"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "2",
                            "monoisotopic_mass": "1512.7746",
                            "monoisotopic_mz": "1513.7819",
                            "intensity": "1401.69",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "3",
                            "monoisotopic_mass": "2222.1423",
                            "monoisotopic_mz": "2223.1496",
                            "intensity": "1741.02",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "4",
                            "monoisotopic_mass": "1250.6578",
                            "monoisotopic_mz": "1251.6650",
                            "intensity": "1378.12",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1250.6507",
                                    "ion_position": "116",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "Y00011",
                                    "ion_left_position": "116",
                                    "mass_error": "0.0071",
                                    "ppm": "5.67"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "5",
                            "monoisotopic_mass": "1135.6291",
                            "monoisotopic_mz": "1136.6364",
                            "intensity": "2741.16",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1135.6237",
                                    "ion_position": "117",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "117",
                                    "mass_error": "0.0054",
                                    "ppm": "4.72"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "6",
                            "monoisotopic_mass": "1471.7406",
                            "monoisotopic_mz": "1472.7479",
                            "intensity": "1316.51",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1471.7341",
                                    "ion_position": "14",
                                    "ion_display_position": "14",
                                    "ion_sort_name": "B00014",
                                    "ion_left_position": "14",
                                    "mass_error": "0.0066",
                                    "ppm": "4.46"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "7",
                            "monoisotopic_mass": "2200.6278",
                            "monoisotopic_mz": "2201.6351",
                            "intensity": "779.53",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "8",
                            "monoisotopic_mass": "3554.8005",
                            "monoisotopic_mz": "1778.4075",
                            "intensity": "5392.74",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "9",
                            "monoisotopic_mass": "697.4153",
                            "monoisotopic_mz": "698.4225",
                            "intensity": "2664.04",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "10",
                            "monoisotopic_mass": "1056.6047",
                            "monoisotopic_mz": "1057.6119",
                            "intensity": "1736.52",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1056.6002",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "B00010",
                                    "ion_left_position": "10",
                                    "mass_error": "0.0045",
                                    "ppm": "4.27"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "11",
                            "monoisotopic_mass": "2030.0279",
                            "monoisotopic_mz": "2031.0352",
                            "intensity": "603.33",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "12",
                            "monoisotopic_mass": "1233.6285",
                            "monoisotopic_mz": "1234.6357",
                            "intensity": "944.44",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "13",
                            "monoisotopic_mass": "1038.5957",
                            "monoisotopic_mz": "1039.6030",
                            "intensity": "773.40",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "14",
                            "monoisotopic_mass": "897.4954",
                            "monoisotopic_mz": "898.5027",
                            "intensity": "1020.89",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "15",
                            "monoisotopic_mass": "3740.8658",
                            "monoisotopic_mz": "1871.4402",
                            "intensity": "3128.43",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "16",
                            "monoisotopic_mass": "1974.0261",
                            "monoisotopic_mz": "1975.0334",
                            "intensity": "1779.63",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "17",
                            "monoisotopic_mass": "2069.0866",
                            "monoisotopic_mz": "2070.0939",
                            "intensity": "855.70",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "18",
                            "monoisotopic_mass": "1153.6404",
                            "monoisotopic_mz": "1154.6477",
                            "intensity": "368.49",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "19",
                            "monoisotopic_mass": "1416.2336",
                            "monoisotopic_mz": "1417.2408",
                            "intensity": "304.52",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "20",
                            "monoisotopic_mass": "2986.5557",
                            "monoisotopic_mz": "1494.2851",
                            "intensity": "2192.86",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "21",
                            "monoisotopic_mass": "1080.6790",
                            "monoisotopic_mz": "1081.6863",
                            "intensity": "408.63",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "22",
                            "monoisotopic_mass": "1094.5743",
                            "monoisotopic_mz": "1095.5815",
                            "intensity": "429.43",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "23",
                            "monoisotopic_mass": "2000.0517",
                            "monoisotopic_mz": "2001.0590",
                            "intensity": "772.81",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "24",
                            "monoisotopic_mass": "3821.9422",
                            "monoisotopic_mz": "1911.9784",
                            "intensity": "1244.75",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "25",
                            "monoisotopic_mass": "2364.1989",
                            "monoisotopic_mz": "2365.2062",
                            "intensity": "1127.09",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "26",
                            "monoisotopic_mass": "1797.9460",
                            "monoisotopic_mz": "1798.9533",
                            "intensity": "730.87",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "27",
                            "monoisotopic_mass": "7827.9769",
                            "monoisotopic_mz": "1958.0015",
                            "intensity": "1054.41",
                            "charge": "4"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "28",
                            "monoisotopic_mass": "2957.5469",
                            "monoisotopic_mz": "1479.7807",
                            "intensity": "3263.27",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "29",
                            "monoisotopic_mass": "1317.2582",
                            "monoisotopic_mz": "1318.2655",
                            "intensity": "353.67",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "30",
                            "monoisotopic_mass": "4451.2768",
                            "monoisotopic_mz": "2226.6457",
                            "intensity": "1139.33",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "31",
                            "monoisotopic_mass": "2015.0333",
                            "monoisotopic_mz": "2016.0406",
                            "intensity": "461.83",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "32",
                            "monoisotopic_mass": "4081.1094",
                            "monoisotopic_mz": "2041.5620",
                            "intensity": "1394.56",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "33",
                            "monoisotopic_mass": "8414.6245",
                            "monoisotopic_mz": "1683.9322",
                            "intensity": "507.26",
                            "charge": "5"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "34",
                            "monoisotopic_mass": "7977.0309",
                            "monoisotopic_mz": "1995.2650",
                            "intensity": "595.09",
                            "charge": "4"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "35",
                            "monoisotopic_mass": "10018.2078",
                            "monoisotopic_mz": "1670.7086",
                            "intensity": "1471.46",
                            "charge": "6"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "36",
                            "monoisotopic_mass": "8358.3448",
                            "monoisotopic_mz": "2090.5935",
                            "intensity": "1767.89",
                            "charge": "4"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "37",
                            "monoisotopic_mass": "2089.4998",
                            "monoisotopic_mz": "2090.5071",
                            "intensity": "597.09",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "38",
                            "monoisotopic_mass": "8181.0514",
                            "monoisotopic_mz": "2046.2701",
                            "intensity": "583.54",
                            "charge": "4"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "39",
                            "monoisotopic_mass": "6557.3728",
                            "monoisotopic_mz": "2186.7982",
                            "intensity": "1052.70",
                            "charge": "3"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "40",
                            "monoisotopic_mass": "3865.6936",
                            "monoisotopic_mz": "1933.8541",
                            "intensity": "474.71",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "41",
                            "monoisotopic_mass": "5802.5154",
                            "monoisotopic_mz": "1935.1791",
                            "intensity": "408.33",
                            "charge": "3"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "42",
                            "monoisotopic_mass": "9807.2196",
                            "monoisotopic_mz": "1962.4512",
                            "intensity": "1063.61",
                            "charge": "5"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "43",
                            "monoisotopic_mass": "5915.5314",
                            "monoisotopic_mz": "1972.8511",
                            "intensity": "1978.75",
                            "charge": "3"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "44",
                            "monoisotopic_mass": "10164.1571",
                            "monoisotopic_mz": "2033.8387",
                            "intensity": "589.17",
                            "charge": "5"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "45",
                            "monoisotopic_mass": "10442.9373",
                            "monoisotopic_mz": "2089.5947",
                            "intensity": "1190.50",
                            "charge": "5"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "46",
                            "monoisotopic_mass": "3950.6967",
                            "monoisotopic_mz": "1976.3556",
                            "intensity": "507.98",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "47",
                            "monoisotopic_mass": "4032.0524",
                            "monoisotopic_mz": "2017.0335",
                            "intensity": "468.94",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "48",
                            "monoisotopic_mass": "13837.9921",
                            "monoisotopic_mz": "1977.8633",
                            "intensity": "962.51",
                            "charge": "7",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "430.0126061721",
                                    "theoretical_mass": "13838.9964",
                                    "ion_position": "119",
                                    "ion_display_position": "119",
                                    "ion_sort_name": "B00119",
                                    "ion_left_position": "119",
                                    "mass_error": "-0.0019",
                                    "ppm": "-0.14"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "49",
                            "monoisotopic_mass": "14301.1652",
                            "monoisotopic_mz": "2044.0309",
                            "intensity": "571.22",
                            "charge": "7"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "50",
                            "monoisotopic_mass": "4529.3242",
                            "monoisotopic_mz": "2265.6694",
                            "intensity": "1716.68",
                            "charge": "2"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "51",
                            "monoisotopic_mass": "7345.8261",
                            "monoisotopic_mz": "1837.4638",
                            "intensity": "661.08",
                            "charge": "4"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "52",
                            "monoisotopic_mass": "13975.1125",
                            "monoisotopic_mz": "1997.4519",
                            "intensity": "1031.31",
                            "charge": "7"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "53",
                            "monoisotopic_mass": "12312.1634",
                            "monoisotopic_mz": "2053.0345",
                            "intensity": "625.18",
                            "charge": "6",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "430.0126061721",
                                    "theoretical_mass": "12311.2282",
                                    "ion_position": "106",
                                    "ion_display_position": "106",
                                    "ion_sort_name": "B00106",
                                    "ion_left_position": "106",
                                    "mass_error": "-0.0672",
                                    "ppm": "-5.46"
                                }
                            }
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "54",
                            "monoisotopic_mass": "2057.7735",
                            "monoisotopic_mz": "2058.7808",
                            "intensity": "1518.58",
                            "charge": "1"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "55",
                            "monoisotopic_mass": "5941.5858",
                            "monoisotopic_mz": "1981.5359",
                            "intensity": "702.96",
                            "charge": "3"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "56",
                            "monoisotopic_mass": "14013.1723",
                            "monoisotopic_mz": "2002.8890",
                            "intensity": "587.30",
                            "charge": "7"
                        },
                        {
                            "spec_id": "353",
                            "peak_id": "57",
                            "monoisotopic_mass": "1931.9718",
                            "monoisotopic_mz": "1932.9791",
                            "intensity": "541.98",
                            "charge": "1"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "34",
                "proteoform_id": "43",
                "sequence_name": "sp|P68066|GRCA_ECOLI",
                "sequence_description": "Autonomous glycyl radical cofactor OS=Escherichia coli (strain K12) OX=83333 GN=grcA PE=1 SV=1",
                "proteoform_mass": "14762.4676",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "127",
                    "first_residue_position": "0",
                    "last_residue_position": "126",
                    "annotated_seq": ".MITGIQITKAANDDLLNSFWLLD(SEKGEAR(C)[Carbamidomethylation]IVAKAGYAEDEVVAVSKLGDIEYREVPVEVKPEVRVEGGQHLNVNVLRRETLEDAVKHPEKYPQLTIRVSGYAVR)[+430.0126]FNSLTPEQQRDVIARTFTESL.",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "I"
                        },
                        {
                            "position": "2",
                            "acid": "T"
                        },
                        {
                            "position": "3",
                            "acid": "G"
                        },
                        {
                            "position": "4",
                            "acid": "I"
                        },
                        {
                            "position": "5",
                            "acid": "Q"
                        },
                        {
                            "position": "6",
                            "acid": "I"
                        },
                        {
                            "position": "7",
                            "acid": "T"
                        },
                        {
                            "position": "8",
                            "acid": "K"
                        },
                        {
                            "position": "9",
                            "acid": "A"
                        },
                        {
                            "position": "10",
                            "acid": "A"
                        },
                        {
                            "position": "11",
                            "acid": "N"
                        },
                        {
                            "position": "12",
                            "acid": "D"
                        },
                        {
                            "position": "13",
                            "acid": "D"
                        },
                        {
                            "position": "14",
                            "acid": "L"
                        },
                        {
                            "position": "15",
                            "acid": "L"
                        },
                        {
                            "position": "16",
                            "acid": "N"
                        },
                        {
                            "position": "17",
                            "acid": "S"
                        },
                        {
                            "position": "18",
                            "acid": "F"
                        },
                        {
                            "position": "19",
                            "acid": "W"
                        },
                        {
                            "position": "20",
                            "acid": "L"
                        },
                        {
                            "position": "21",
                            "acid": "L"
                        },
                        {
                            "position": "22",
                            "acid": "D"
                        },
                        {
                            "position": "23",
                            "acid": "S"
                        },
                        {
                            "position": "24",
                            "acid": "E"
                        },
                        {
                            "position": "25",
                            "acid": "K"
                        },
                        {
                            "position": "26",
                            "acid": "G"
                        },
                        {
                            "position": "27",
                            "acid": "E"
                        },
                        {
                            "position": "28",
                            "acid": "A"
                        },
                        {
                            "position": "29",
                            "acid": "R"
                        },
                        {
                            "position": "30",
                            "acid": "C"
                        },
                        {
                            "position": "31",
                            "acid": "I"
                        },
                        {
                            "position": "32",
                            "acid": "V"
                        },
                        {
                            "position": "33",
                            "acid": "A"
                        },
                        {
                            "position": "34",
                            "acid": "K"
                        },
                        {
                            "position": "35",
                            "acid": "A"
                        },
                        {
                            "position": "36",
                            "acid": "G"
                        },
                        {
                            "position": "37",
                            "acid": "Y"
                        },
                        {
                            "position": "38",
                            "acid": "A"
                        },
                        {
                            "position": "39",
                            "acid": "E"
                        },
                        {
                            "position": "40",
                            "acid": "D"
                        },
                        {
                            "position": "41",
                            "acid": "E"
                        },
                        {
                            "position": "42",
                            "acid": "V"
                        },
                        {
                            "position": "43",
                            "acid": "V"
                        },
                        {
                            "position": "44",
                            "acid": "A"
                        },
                        {
                            "position": "45",
                            "acid": "V"
                        },
                        {
                            "position": "46",
                            "acid": "S"
                        },
                        {
                            "position": "47",
                            "acid": "K"
                        },
                        {
                            "position": "48",
                            "acid": "L"
                        },
                        {
                            "position": "49",
                            "acid": "G"
                        },
                        {
                            "position": "50",
                            "acid": "D"
                        },
                        {
                            "position": "51",
                            "acid": "I"
                        },
                        {
                            "position": "52",
                            "acid": "E"
                        },
                        {
                            "position": "53",
                            "acid": "Y"
                        },
                        {
                            "position": "54",
                            "acid": "R"
                        },
                        {
                            "position": "55",
                            "acid": "E"
                        },
                        {
                            "position": "56",
                            "acid": "V"
                        },
                        {
                            "position": "57",
                            "acid": "P"
                        },
                        {
                            "position": "58",
                            "acid": "V"
                        },
                        {
                            "position": "59",
                            "acid": "E"
                        },
                        {
                            "position": "60",
                            "acid": "V"
                        },
                        {
                            "position": "61",
                            "acid": "K"
                        },
                        {
                            "position": "62",
                            "acid": "P"
                        },
                        {
                            "position": "63",
                            "acid": "E"
                        },
                        {
                            "position": "64",
                            "acid": "V"
                        },
                        {
                            "position": "65",
                            "acid": "R"
                        },
                        {
                            "position": "66",
                            "acid": "V"
                        },
                        {
                            "position": "67",
                            "acid": "E"
                        },
                        {
                            "position": "68",
                            "acid": "G"
                        },
                        {
                            "position": "69",
                            "acid": "G"
                        },
                        {
                            "position": "70",
                            "acid": "Q"
                        },
                        {
                            "position": "71",
                            "acid": "H"
                        },
                        {
                            "position": "72",
                            "acid": "L"
                        },
                        {
                            "position": "73",
                            "acid": "N"
                        },
                        {
                            "position": "74",
                            "acid": "V"
                        },
                        {
                            "position": "75",
                            "acid": "N"
                        },
                        {
                            "position": "76",
                            "acid": "V"
                        },
                        {
                            "position": "77",
                            "acid": "L"
                        },
                        {
                            "position": "78",
                            "acid": "R"
                        },
                        {
                            "position": "79",
                            "acid": "R"
                        },
                        {
                            "position": "80",
                            "acid": "E"
                        },
                        {
                            "position": "81",
                            "acid": "T"
                        },
                        {
                            "position": "82",
                            "acid": "L"
                        },
                        {
                            "position": "83",
                            "acid": "E"
                        },
                        {
                            "position": "84",
                            "acid": "D"
                        },
                        {
                            "position": "85",
                            "acid": "A"
                        },
                        {
                            "position": "86",
                            "acid": "V"
                        },
                        {
                            "position": "87",
                            "acid": "K"
                        },
                        {
                            "position": "88",
                            "acid": "H"
                        },
                        {
                            "position": "89",
                            "acid": "P"
                        },
                        {
                            "position": "90",
                            "acid": "E"
                        },
                        {
                            "position": "91",
                            "acid": "K"
                        },
                        {
                            "position": "92",
                            "acid": "Y"
                        },
                        {
                            "position": "93",
                            "acid": "P"
                        },
                        {
                            "position": "94",
                            "acid": "Q"
                        },
                        {
                            "position": "95",
                            "acid": "L"
                        },
                        {
                            "position": "96",
                            "acid": "T"
                        },
                        {
                            "position": "97",
                            "acid": "I"
                        },
                        {
                            "position": "98",
                            "acid": "R"
                        },
                        {
                            "position": "99",
                            "acid": "V"
                        },
                        {
                            "position": "100",
                            "acid": "S"
                        },
                        {
                            "position": "101",
                            "acid": "G"
                        },
                        {
                            "position": "102",
                            "acid": "Y"
                        },
                        {
                            "position": "103",
                            "acid": "A"
                        },
                        {
                            "position": "104",
                            "acid": "V"
                        },
                        {
                            "position": "105",
                            "acid": "R"
                        },
                        {
                            "position": "106",
                            "acid": "F"
                        },
                        {
                            "position": "107",
                            "acid": "N"
                        },
                        {
                            "position": "108",
                            "acid": "S"
                        },
                        {
                            "position": "109",
                            "acid": "L"
                        },
                        {
                            "position": "110",
                            "acid": "T"
                        },
                        {
                            "position": "111",
                            "acid": "P"
                        },
                        {
                            "position": "112",
                            "acid": "E"
                        },
                        {
                            "position": "113",
                            "acid": "Q"
                        },
                        {
                            "position": "114",
                            "acid": "Q"
                        },
                        {
                            "position": "115",
                            "acid": "R"
                        },
                        {
                            "position": "116",
                            "acid": "D"
                        },
                        {
                            "position": "117",
                            "acid": "V"
                        },
                        {
                            "position": "118",
                            "acid": "I"
                        },
                        {
                            "position": "119",
                            "acid": "A"
                        },
                        {
                            "position": "120",
                            "acid": "R"
                        },
                        {
                            "position": "121",
                            "acid": "T"
                        },
                        {
                            "position": "122",
                            "acid": "F"
                        },
                        {
                            "position": "123",
                            "acid": "T"
                        },
                        {
                            "position": "124",
                            "acid": "E"
                        },
                        {
                            "position": "125",
                            "acid": "S"
                        },
                        {
                            "position": "126",
                            "acid": "L"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "spec_id": "353",
                                    "peak_id": "10",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "13",
                                    "ion_display_position": "13",
                                    "spec_id": "353",
                                    "peak_id": "1",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "14",
                                    "ion_display_position": "14",
                                    "spec_id": "353",
                                    "peak_id": "6",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "353",
                                    "peak_id": "0",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "106",
                                    "ion_display_position": "106",
                                    "spec_id": "353",
                                    "peak_id": "53",
                                    "peak_charge": "6"
                                }
                            }
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "116",
                                    "ion_display_position": "11",
                                    "spec_id": "353",
                                    "peak_id": "4",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "117",
                                    "ion_display_position": "10",
                                    "spec_id": "353",
                                    "peak_id": "5",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "119",
                                    "ion_display_position": "119",
                                    "spec_id": "353",
                                    "peak_id": "48",
                                    "peak_charge": "7"
                                }
                            }
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Fixed",
                        "ptm": {
                            "abbreviation": "Carbamidomethylation",
                            "unimod": "-1",
                            "mono_mass": "57.0214640000"
                        },
                        "occurence": {
                            "left_pos": "30",
                            "right_pos": "31",
                            "anno": "C"
                        }
                    },
                    "mass_shift": {
                        "id": "0",
                        "left_position": "23",
                        "right_position": "106",
                        "shift": "430.0126061721",
                        "anno": "+430.0126",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
