prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "26",
        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
        "proteoform_id": "37",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "151",
            "p_value": "8.46e-06",
            "e_value": "8.46e-06",
            "fdr": "0",
            "matched_fragment_number": "12",
            "matched_peak_number": "12",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                    "ms1_ids": "620",
                    "ms1_scans": "981",
                    "ids": "362",
                    "scans": "984",
                    "precursor_mono_mass": "10316.0127",
                    "precursor_charge": "6",
                    "precursor_mz": "1720.3427",
                    "feature_inte": "3.7648e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "362",
                            "peak_id": "0",
                            "monoisotopic_mass": "1603.8838",
                            "monoisotopic_mz": "1604.8911",
                            "intensity": "6148.93",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1603.8756",
                                    "ion_position": "76",
                                    "ion_display_position": "13",
                                    "ion_sort_name": "Y00013",
                                    "ion_left_position": "76",
                                    "mass_error": "0.0082",
                                    "ppm": "5.14"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "1",
                            "monoisotopic_mass": "2396.2369",
                            "monoisotopic_mz": "2397.2442",
                            "intensity": "1967.57",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "2",
                            "monoisotopic_mass": "1498.7073",
                            "monoisotopic_mz": "1499.7146",
                            "intensity": "3118.73",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "3",
                            "monoisotopic_mass": "2435.3101",
                            "monoisotopic_mz": "2436.3174",
                            "intensity": "5029.56",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2435.2995",
                                    "ion_position": "69",
                                    "ion_display_position": "20",
                                    "ion_sort_name": "Y00020",
                                    "ion_left_position": "69",
                                    "mass_error": "0.0106",
                                    "ppm": "4.37"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "4",
                            "monoisotopic_mass": "1376.7216",
                            "monoisotopic_mz": "1377.7289",
                            "intensity": "2182.22",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1376.7122",
                                    "ion_position": "78",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "Y00011",
                                    "ion_left_position": "78",
                                    "mass_error": "0.0094",
                                    "ppm": "6.82"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "5",
                            "monoisotopic_mass": "3354.5488",
                            "monoisotopic_mz": "1678.2817",
                            "intensity": "4676.32",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "6",
                            "monoisotopic_mass": "1248.6241",
                            "monoisotopic_mz": "1249.6313",
                            "intensity": "2965.56",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1248.6173",
                                    "ion_position": "79",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "79",
                                    "mass_error": "0.0068",
                                    "ppm": "5.46"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "7",
                            "monoisotopic_mass": "1140.5939",
                            "monoisotopic_mz": "1141.6012",
                            "intensity": "5524.26",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1140.5887",
                                    "ion_position": "11",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "B00011",
                                    "ion_left_position": "11",
                                    "mass_error": "0.0052",
                                    "ppm": "4.55"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "8",
                            "monoisotopic_mass": "770.3591",
                            "monoisotopic_mz": "771.3664",
                            "intensity": "6233.01",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "770.3559",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "B00008",
                                    "ion_left_position": "8",
                                    "mass_error": "0.0032",
                                    "ppm": "4.20"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "9",
                            "monoisotopic_mass": "1012.4987",
                            "monoisotopic_mz": "1013.5060",
                            "intensity": "2384.31",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1012.4938",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "B00010",
                                    "ion_left_position": "10",
                                    "mass_error": "0.0049",
                                    "ppm": "4.87"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "10",
                            "monoisotopic_mass": "1427.7109",
                            "monoisotopic_mz": "1428.7181",
                            "intensity": "1353.19",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "11",
                            "monoisotopic_mass": "1336.7127",
                            "monoisotopic_mz": "1337.7200",
                            "intensity": "1541.90",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1336.7099",
                                    "ion_position": "13",
                                    "ion_display_position": "13",
                                    "ion_sort_name": "B00013",
                                    "ion_left_position": "13",
                                    "mass_error": "0.0028",
                                    "ppm": "2.08"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "12",
                            "monoisotopic_mass": "1454.8312",
                            "monoisotopic_mz": "1455.8385",
                            "intensity": "1123.94",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "13",
                            "monoisotopic_mass": "2779.3092",
                            "monoisotopic_mz": "1390.6619",
                            "intensity": "2167.02",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "14",
                            "monoisotopic_mass": "3484.6028",
                            "monoisotopic_mz": "1743.3087",
                            "intensity": "2679.27",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "15",
                            "monoisotopic_mass": "669.4202",
                            "monoisotopic_mz": "670.4275",
                            "intensity": "8420.19",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "16",
                            "monoisotopic_mass": "584.2942",
                            "monoisotopic_mz": "585.3015",
                            "intensity": "4137.11",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "584.2918",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "ion_sort_name": "B00006",
                                    "ion_left_position": "6",
                                    "mass_error": "0.0024",
                                    "ppm": "4.03"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "17",
                            "monoisotopic_mass": "2613.4327",
                            "monoisotopic_mz": "1307.7237",
                            "intensity": "1846.15",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "18",
                            "monoisotopic_mass": "1296.7100",
                            "monoisotopic_mz": "1297.7173",
                            "intensity": "1812.45",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "19",
                            "monoisotopic_mass": "2247.2277",
                            "monoisotopic_mz": "1124.6211",
                            "intensity": "3603.22",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "20",
                            "monoisotopic_mass": "843.4158",
                            "monoisotopic_mz": "844.4230",
                            "intensity": "623.59",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "21",
                            "monoisotopic_mass": "728.3527",
                            "monoisotopic_mz": "729.3599",
                            "intensity": "974.56",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "22",
                            "monoisotopic_mass": "655.3314",
                            "monoisotopic_mz": "656.3387",
                            "intensity": "1743.76",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "655.3289",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "B00007",
                                    "ion_left_position": "7",
                                    "mass_error": "0.0025",
                                    "ppm": "3.77"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "23",
                            "monoisotopic_mass": "1062.5596",
                            "monoisotopic_mz": "1063.5669",
                            "intensity": "1292.74",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1062.5532",
                                    "ion_position": "81",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "Y00008",
                                    "ion_left_position": "81",
                                    "mass_error": "0.0064",
                                    "ppm": "6.04"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "24",
                            "monoisotopic_mass": "784.4490",
                            "monoisotopic_mz": "785.4562",
                            "intensity": "1417.34",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "25",
                            "monoisotopic_mass": "412.1608",
                            "monoisotopic_mz": "413.1681",
                            "intensity": "1392.13",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "26",
                            "monoisotopic_mass": "484.3028",
                            "monoisotopic_mz": "485.3101",
                            "intensity": "1798.04",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "27",
                            "monoisotopic_mass": "1115.6088",
                            "monoisotopic_mz": "1116.6161",
                            "intensity": "1115.05",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "28",
                            "monoisotopic_mass": "566.2830",
                            "monoisotopic_mz": "567.2902",
                            "intensity": "1298.88",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "29",
                            "monoisotopic_mass": "8514.5042",
                            "monoisotopic_mz": "1703.9081",
                            "intensity": "8462.62",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "30",
                            "monoisotopic_mass": "451.2443",
                            "monoisotopic_mz": "452.2516",
                            "intensity": "780.53",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "31",
                            "monoisotopic_mass": "2878.3790",
                            "monoisotopic_mz": "1440.1968",
                            "intensity": "2165.89",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "32",
                            "monoisotopic_mass": "3944.0429",
                            "monoisotopic_mz": "1973.0287",
                            "intensity": "2448.58",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "33",
                            "monoisotopic_mass": "7059.7956",
                            "monoisotopic_mz": "1765.9562",
                            "intensity": "5167.83",
                            "charge": "4"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "34",
                            "monoisotopic_mass": "7077.7966",
                            "monoisotopic_mz": "1770.4564",
                            "intensity": "4778.75",
                            "charge": "4"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "35",
                            "monoisotopic_mass": "3738.9071",
                            "monoisotopic_mz": "1870.4608",
                            "intensity": "2528.98",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "36",
                            "monoisotopic_mass": "8376.4111",
                            "monoisotopic_mz": "1676.2895",
                            "intensity": "3320.09",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "37",
                            "monoisotopic_mass": "8558.5093",
                            "monoisotopic_mz": "1712.7091",
                            "intensity": "13070.84",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "38",
                            "monoisotopic_mass": "2748.3031",
                            "monoisotopic_mz": "1375.1588",
                            "intensity": "1274.04",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "39",
                            "monoisotopic_mass": "8540.4777",
                            "monoisotopic_mz": "1709.1028",
                            "intensity": "7665.54",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "40",
                            "monoisotopic_mass": "513.2639",
                            "monoisotopic_mz": "514.2711",
                            "intensity": "833.27",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "513.2547",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "ion_sort_name": "B00005",
                                    "ion_left_position": "5",
                                    "mass_error": "0.0092",
                                    "ppm": "17.84"
                                }
                            }
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "41",
                            "monoisotopic_mass": "8575.5131",
                            "monoisotopic_mz": "1716.1099",
                            "intensity": "21197.93",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "42",
                            "monoisotopic_mass": "2505.4015",
                            "monoisotopic_mz": "1253.7080",
                            "intensity": "1398.59",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "43",
                            "monoisotopic_mass": "8473.4891",
                            "monoisotopic_mz": "1695.7051",
                            "intensity": "1555.10",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "44",
                            "monoisotopic_mass": "612.3982",
                            "monoisotopic_mz": "613.4055",
                            "intensity": "602.52",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "45",
                            "monoisotopic_mass": "4904.9282",
                            "monoisotopic_mz": "1635.9833",
                            "intensity": "1015.70",
                            "charge": "3"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "46",
                            "monoisotopic_mass": "3070.5878",
                            "monoisotopic_mz": "1536.3012",
                            "intensity": "1415.72",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "47",
                            "monoisotopic_mass": "8500.4065",
                            "monoisotopic_mz": "1701.0886",
                            "intensity": "4561.28",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "48",
                            "monoisotopic_mass": "3337.5363",
                            "monoisotopic_mz": "1669.7754",
                            "intensity": "2763.21",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "49",
                            "monoisotopic_mass": "2956.5574",
                            "monoisotopic_mz": "1479.2860",
                            "intensity": "1034.45",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "50",
                            "monoisotopic_mass": "1981.0240",
                            "monoisotopic_mz": "1982.0313",
                            "intensity": "1162.14",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "51",
                            "monoisotopic_mass": "3324.7746",
                            "monoisotopic_mz": "1663.3946",
                            "intensity": "1893.95",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "52",
                            "monoisotopic_mass": "4111.1194",
                            "monoisotopic_mz": "2056.5670",
                            "intensity": "1684.10",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "53",
                            "monoisotopic_mass": "871.4782",
                            "monoisotopic_mz": "872.4855",
                            "intensity": "717.83",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "54",
                            "monoisotopic_mass": "8073.1643",
                            "monoisotopic_mz": "2019.2984",
                            "intensity": "2780.16",
                            "charge": "4"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "55",
                            "monoisotopic_mass": "2761.3020",
                            "monoisotopic_mz": "1381.6583",
                            "intensity": "954.42",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "56",
                            "monoisotopic_mass": "8592.5382",
                            "monoisotopic_mz": "1719.5149",
                            "intensity": "13260.06",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "57",
                            "monoisotopic_mass": "6764.0864",
                            "monoisotopic_mz": "1353.8246",
                            "intensity": "562.33",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "58",
                            "monoisotopic_mass": "5019.2705",
                            "monoisotopic_mz": "1674.0975",
                            "intensity": "1642.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "59",
                            "monoisotopic_mass": "1710.9056",
                            "monoisotopic_mz": "1711.9128",
                            "intensity": "3958.18",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "60",
                            "monoisotopic_mass": "2447.1101",
                            "monoisotopic_mz": "1224.5623",
                            "intensity": "1181.61",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "61",
                            "monoisotopic_mass": "4010.0322",
                            "monoisotopic_mz": "2006.0234",
                            "intensity": "2492.63",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "62",
                            "monoisotopic_mass": "3765.8604",
                            "monoisotopic_mz": "1883.9375",
                            "intensity": "3827.99",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "63",
                            "monoisotopic_mass": "2631.4401",
                            "monoisotopic_mz": "878.1540",
                            "intensity": "1671.66",
                            "charge": "3"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "64",
                            "monoisotopic_mass": "2023.0500",
                            "monoisotopic_mz": "2024.0573",
                            "intensity": "1274.48",
                            "charge": "1"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "65",
                            "monoisotopic_mass": "2630.4370",
                            "monoisotopic_mz": "1316.2258",
                            "intensity": "1452.41",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "66",
                            "monoisotopic_mass": "7428.4431",
                            "monoisotopic_mz": "1486.6959",
                            "intensity": "534.89",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "67",
                            "monoisotopic_mass": "8401.3652",
                            "monoisotopic_mz": "1681.2803",
                            "intensity": "568.52",
                            "charge": "5"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "68",
                            "monoisotopic_mass": "7907.0911",
                            "monoisotopic_mz": "1977.7800",
                            "intensity": "3096.87",
                            "charge": "4"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "69",
                            "monoisotopic_mass": "4073.0945",
                            "monoisotopic_mz": "2037.5545",
                            "intensity": "1756.66",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "70",
                            "monoisotopic_mass": "3110.6233",
                            "monoisotopic_mz": "1556.3189",
                            "intensity": "1643.13",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "71",
                            "monoisotopic_mass": "4139.0498",
                            "monoisotopic_mz": "2070.5322",
                            "intensity": "1674.88",
                            "charge": "2"
                        },
                        {
                            "spec_id": "362",
                            "peak_id": "72",
                            "monoisotopic_mass": "3439.8352",
                            "monoisotopic_mz": "1720.9249",
                            "intensity": "1570.24",
                            "charge": "2"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "26",
                "proteoform_id": "37",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_mass": "10316.2177",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "110",
                    "first_residue_position": "21",
                    "last_residue_position": "109",
                    "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+467.3460]KQANFKDKVKGEWDKIKKDM.",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "K"
                        },
                        {
                            "position": "2",
                            "acid": "K"
                        },
                        {
                            "position": "3",
                            "acid": "V"
                        },
                        {
                            "position": "4",
                            "acid": "L"
                        },
                        {
                            "position": "5",
                            "acid": "G"
                        },
                        {
                            "position": "6",
                            "acid": "V"
                        },
                        {
                            "position": "7",
                            "acid": "I"
                        },
                        {
                            "position": "8",
                            "acid": "L"
                        },
                        {
                            "position": "9",
                            "acid": "G"
                        },
                        {
                            "position": "10",
                            "acid": "G"
                        },
                        {
                            "position": "11",
                            "acid": "L"
                        },
                        {
                            "position": "12",
                            "acid": "L"
                        },
                        {
                            "position": "13",
                            "acid": "L"
                        },
                        {
                            "position": "14",
                            "acid": "L"
                        },
                        {
                            "position": "15",
                            "acid": "P"
                        },
                        {
                            "position": "16",
                            "acid": "V"
                        },
                        {
                            "position": "17",
                            "acid": "V"
                        },
                        {
                            "position": "18",
                            "acid": "S"
                        },
                        {
                            "position": "19",
                            "acid": "N"
                        },
                        {
                            "position": "20",
                            "acid": "A"
                        },
                        {
                            "position": "21",
                            "acid": "A"
                        },
                        {
                            "position": "22",
                            "acid": "D"
                        },
                        {
                            "position": "23",
                            "acid": "A"
                        },
                        {
                            "position": "24",
                            "acid": "Q"
                        },
                        {
                            "position": "25",
                            "acid": "K"
                        },
                        {
                            "position": "26",
                            "acid": "A"
                        },
                        {
                            "position": "27",
                            "acid": "A"
                        },
                        {
                            "position": "28",
                            "acid": "D"
                        },
                        {
                            "position": "29",
                            "acid": "N"
                        },
                        {
                            "position": "30",
                            "acid": "K"
                        },
                        {
                            "position": "31",
                            "acid": "K"
                        },
                        {
                            "position": "32",
                            "acid": "P"
                        },
                        {
                            "position": "33",
                            "acid": "V"
                        },
                        {
                            "position": "34",
                            "acid": "N"
                        },
                        {
                            "position": "35",
                            "acid": "S"
                        },
                        {
                            "position": "36",
                            "acid": "W"
                        },
                        {
                            "position": "37",
                            "acid": "T"
                        },
                        {
                            "position": "38",
                            "acid": "C"
                        },
                        {
                            "position": "39",
                            "acid": "E"
                        },
                        {
                            "position": "40",
                            "acid": "D"
                        },
                        {
                            "position": "41",
                            "acid": "F"
                        },
                        {
                            "position": "42",
                            "acid": "L"
                        },
                        {
                            "position": "43",
                            "acid": "A"
                        },
                        {
                            "position": "44",
                            "acid": "V"
                        },
                        {
                            "position": "45",
                            "acid": "D"
                        },
                        {
                            "position": "46",
                            "acid": "E"
                        },
                        {
                            "position": "47",
                            "acid": "S"
                        },
                        {
                            "position": "48",
                            "acid": "F"
                        },
                        {
                            "position": "49",
                            "acid": "Q"
                        },
                        {
                            "position": "50",
                            "acid": "P"
                        },
                        {
                            "position": "51",
                            "acid": "T"
                        },
                        {
                            "position": "52",
                            "acid": "A"
                        },
                        {
                            "position": "53",
                            "acid": "V"
                        },
                        {
                            "position": "54",
                            "acid": "G"
                        },
                        {
                            "position": "55",
                            "acid": "F"
                        },
                        {
                            "position": "56",
                            "acid": "A"
                        },
                        {
                            "position": "57",
                            "acid": "E"
                        },
                        {
                            "position": "58",
                            "acid": "A"
                        },
                        {
                            "position": "59",
                            "acid": "L"
                        },
                        {
                            "position": "60",
                            "acid": "N"
                        },
                        {
                            "position": "61",
                            "acid": "N"
                        },
                        {
                            "position": "62",
                            "acid": "K"
                        },
                        {
                            "position": "63",
                            "acid": "D"
                        },
                        {
                            "position": "64",
                            "acid": "K"
                        },
                        {
                            "position": "65",
                            "acid": "P"
                        },
                        {
                            "position": "66",
                            "acid": "E"
                        },
                        {
                            "position": "67",
                            "acid": "D"
                        },
                        {
                            "position": "68",
                            "acid": "A"
                        },
                        {
                            "position": "69",
                            "acid": "V"
                        },
                        {
                            "position": "70",
                            "acid": "L"
                        },
                        {
                            "position": "71",
                            "acid": "D"
                        },
                        {
                            "position": "72",
                            "acid": "V"
                        },
                        {
                            "position": "73",
                            "acid": "Q"
                        },
                        {
                            "position": "74",
                            "acid": "G"
                        },
                        {
                            "position": "75",
                            "acid": "I"
                        },
                        {
                            "position": "76",
                            "acid": "A"
                        },
                        {
                            "position": "77",
                            "acid": "T"
                        },
                        {
                            "position": "78",
                            "acid": "V"
                        },
                        {
                            "position": "79",
                            "acid": "T"
                        },
                        {
                            "position": "80",
                            "acid": "P"
                        },
                        {
                            "position": "81",
                            "acid": "A"
                        },
                        {
                            "position": "82",
                            "acid": "I"
                        },
                        {
                            "position": "83",
                            "acid": "V"
                        },
                        {
                            "position": "84",
                            "acid": "Q"
                        },
                        {
                            "position": "85",
                            "acid": "A"
                        },
                        {
                            "position": "86",
                            "acid": "C"
                        },
                        {
                            "position": "87",
                            "acid": "T"
                        },
                        {
                            "position": "88",
                            "acid": "Q"
                        },
                        {
                            "position": "89",
                            "acid": "D"
                        },
                        {
                            "position": "90",
                            "acid": "K"
                        },
                        {
                            "position": "91",
                            "acid": "Q"
                        },
                        {
                            "position": "92",
                            "acid": "A"
                        },
                        {
                            "position": "93",
                            "acid": "N"
                        },
                        {
                            "position": "94",
                            "acid": "F"
                        },
                        {
                            "position": "95",
                            "acid": "K"
                        },
                        {
                            "position": "96",
                            "acid": "D"
                        },
                        {
                            "position": "97",
                            "acid": "K"
                        },
                        {
                            "position": "98",
                            "acid": "V"
                        },
                        {
                            "position": "99",
                            "acid": "K"
                        },
                        {
                            "position": "100",
                            "acid": "G"
                        },
                        {
                            "position": "101",
                            "acid": "E"
                        },
                        {
                            "position": "102",
                            "acid": "W"
                        },
                        {
                            "position": "103",
                            "acid": "D"
                        },
                        {
                            "position": "104",
                            "acid": "K"
                        },
                        {
                            "position": "105",
                            "acid": "I"
                        },
                        {
                            "position": "106",
                            "acid": "K"
                        },
                        {
                            "position": "107",
                            "acid": "K"
                        },
                        {
                            "position": "108",
                            "acid": "D"
                        },
                        {
                            "position": "109",
                            "acid": "M"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "spec_id": "362",
                                    "peak_id": "40",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "spec_id": "362",
                                    "peak_id": "16",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "spec_id": "362",
                                    "peak_id": "22",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "spec_id": "362",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "10",
                                    "ion_display_position": "10",
                                    "spec_id": "362",
                                    "peak_id": "9",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "11",
                                    "ion_display_position": "11",
                                    "spec_id": "362",
                                    "peak_id": "7",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "13",
                                    "ion_display_position": "13",
                                    "spec_id": "362",
                                    "peak_id": "11",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "69",
                                    "ion_display_position": "20",
                                    "spec_id": "362",
                                    "peak_id": "3",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "13",
                                    "spec_id": "362",
                                    "peak_id": "0",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "78",
                                    "ion_display_position": "11",
                                    "spec_id": "362",
                                    "peak_id": "4",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "79",
                                    "ion_display_position": "10",
                                    "spec_id": "362",
                                    "peak_id": "6",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "81",
                                    "ion_display_position": "8",
                                    "spec_id": "362",
                                    "peak_id": "23",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Fixed",
                        "ptm": {
                            "abbreviation": "Carbamidomethylation",
                            "unimod": "-1",
                            "mono_mass": "57.0214640000"
                        },
                        "occurence": [
                            {
                                "left_pos": "38",
                                "right_pos": "39",
                                "anno": "C"
                            },
                            {
                                "left_pos": "86",
                                "right_pos": "87",
                                "anno": "C"
                            }
                        ]
                    },
                    "mass_shift": {
                        "id": "0",
                        "left_position": "34",
                        "right_position": "90",
                        "shift": "467.3459635793",
                        "anno": "+467.3460",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
