prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "10",
        "sequence_name": "sp|P0ACF8|HNS_ECOLI",
        "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
        "proteoform_id": "10",
        "prsm_number": "9",
        "prsm": [
            {
                "prsm_id": "54",
                "p_value": "1.11e-24",
                "e_value": "1.11e-24",
                "fdr": "0",
                "matched_fragment_number": "34",
                "matched_peak_number": "42",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "535",
                        "ms1_scans": "643",
                        "ids": "107",
                        "scans": "644",
                        "precursor_mono_mass": "5453.8009",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7675",
                        "feature_inte": "4.5437e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "107",
                                "peak_id": "0",
                                "monoisotopic_mass": "1395.7685",
                                "monoisotopic_mz": "1396.7758",
                                "intensity": "1585.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "1",
                                "monoisotopic_mass": "1634.8220",
                                "monoisotopic_mz": "1635.8292",
                                "intensity": "2079.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1634.8152",
                                        "ion_position": "34",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0068",
                                        "ppm": "4.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "2",
                                "monoisotopic_mass": "1245.6282",
                                "monoisotopic_mz": "1246.6355",
                                "intensity": "1512.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "3",
                                "monoisotopic_mass": "1690.8283",
                                "monoisotopic_mz": "1691.8356",
                                "intensity": "1207.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "4",
                                "monoisotopic_mass": "1765.8638",
                                "monoisotopic_mz": "1766.8711",
                                "intensity": "1471.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1765.8557",
                                        "ion_position": "33",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0082",
                                        "ppm": "4.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "5",
                                "monoisotopic_mass": "5179.6381",
                                "monoisotopic_mz": "1295.9168",
                                "intensity": "11376.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0232",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "6",
                                "monoisotopic_mass": "875.4422",
                                "monoisotopic_mz": "876.4495",
                                "intensity": "2563.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "7",
                                "monoisotopic_mass": "4953.4678",
                                "monoisotopic_mz": "1239.3742",
                                "intensity": "20799.22",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0210",
                                        "ppm": "4.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "8",
                                "monoisotopic_mass": "2194.0847",
                                "monoisotopic_mz": "732.3688",
                                "intensity": "5747.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0080",
                                        "ppm": "3.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "9",
                                "monoisotopic_mass": "5004.5206",
                                "monoisotopic_mz": "1252.1374",
                                "intensity": "3359.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "10",
                                "monoisotopic_mass": "1434.7421",
                                "monoisotopic_mz": "1435.7494",
                                "intensity": "3182.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0053",
                                        "ppm": "3.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "11",
                                "monoisotopic_mass": "3148.5571",
                                "monoisotopic_mz": "1050.5263",
                                "intensity": "9839.07",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0132",
                                        "ppm": "4.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "12",
                                "monoisotopic_mass": "1863.8946",
                                "monoisotopic_mz": "932.9546",
                                "intensity": "15208.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0082",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "13",
                                "monoisotopic_mass": "3488.8056",
                                "monoisotopic_mz": "1163.9425",
                                "intensity": "27604.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0143",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "14",
                                "monoisotopic_mass": "2980.4670",
                                "monoisotopic_mz": "994.4963",
                                "intensity": "2270.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2980.4540",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0130",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "15",
                                "monoisotopic_mass": "1136.6237",
                                "monoisotopic_mz": "1137.6310",
                                "intensity": "3585.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "16",
                                "monoisotopic_mass": "1373.7250",
                                "monoisotopic_mz": "1374.7323",
                                "intensity": "1708.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "17",
                                "monoisotopic_mass": "4045.0286",
                                "monoisotopic_mz": "1349.3502",
                                "intensity": "2846.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "18",
                                "monoisotopic_mass": "3377.7389",
                                "monoisotopic_mz": "1126.9202",
                                "intensity": "6602.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "19",
                                "monoisotopic_mass": "1497.7872",
                                "monoisotopic_mz": "749.9009",
                                "intensity": "869.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "20",
                                "monoisotopic_mass": "1449.6517",
                                "monoisotopic_mz": "1450.6589",
                                "intensity": "1258.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "21",
                                "monoisotopic_mass": "2879.4206",
                                "monoisotopic_mz": "960.8141",
                                "intensity": "4970.61",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0143",
                                        "ppm": "4.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "22",
                                "monoisotopic_mass": "4691.3692",
                                "monoisotopic_mz": "1173.8496",
                                "intensity": "9292.14",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0178",
                                        "ppm": "3.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "23",
                                "monoisotopic_mass": "5066.5567",
                                "monoisotopic_mz": "1267.6464",
                                "intensity": "25436.61",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0258",
                                        "ppm": "5.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "24",
                                "monoisotopic_mass": "4427.2272",
                                "monoisotopic_mz": "1107.8141",
                                "intensity": "5871.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "25",
                                "monoisotopic_mass": "4806.3951",
                                "monoisotopic_mz": "1202.6060",
                                "intensity": "10975.17",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0167",
                                        "ppm": "3.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "26",
                                "monoisotopic_mass": "3687.9400",
                                "monoisotopic_mz": "922.9923",
                                "intensity": "11533.98",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0166",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "27",
                                "monoisotopic_mass": "3818.9810",
                                "monoisotopic_mz": "955.7525",
                                "intensity": "5740.76",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0171",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "28",
                                "monoisotopic_mass": "1434.7423",
                                "monoisotopic_mz": "718.3784",
                                "intensity": "51117.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0055",
                                        "ppm": "3.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "29",
                                "monoisotopic_mass": "3616.9002",
                                "monoisotopic_mz": "905.2323",
                                "intensity": "4930.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0139",
                                        "ppm": "3.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "30",
                                "monoisotopic_mass": "1319.7144",
                                "monoisotopic_mz": "660.8645",
                                "intensity": "4752.51",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0046",
                                        "ppm": "3.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "31",
                                "monoisotopic_mass": "1417.7141",
                                "monoisotopic_mz": "709.8643",
                                "intensity": "5106.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "32",
                                "monoisotopic_mass": "3818.9927",
                                "monoisotopic_mz": "1274.0048",
                                "intensity": "3154.43",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0288",
                                        "ppm": "7.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "33",
                                "monoisotopic_mass": "4788.3839",
                                "monoisotopic_mz": "1198.1032",
                                "intensity": "9555.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "34",
                                "monoisotopic_mass": "3247.6285",
                                "monoisotopic_mz": "1083.5501",
                                "intensity": "22646.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0162",
                                        "ppm": "4.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "35",
                                "monoisotopic_mass": "1734.8514",
                                "monoisotopic_mz": "868.4330",
                                "intensity": "3488.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0076",
                                        "ppm": "4.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "36",
                                "monoisotopic_mass": "1936.9446",
                                "monoisotopic_mz": "969.4796",
                                "intensity": "2973.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "37",
                                "monoisotopic_mass": "4376.2265",
                                "monoisotopic_mz": "1095.0639",
                                "intensity": "10470.37",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0181",
                                        "ppm": "4.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "38",
                                "monoisotopic_mass": "4771.3555",
                                "monoisotopic_mz": "1193.8462",
                                "intensity": "3532.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "39",
                                "monoisotopic_mass": "3332.7170",
                                "monoisotopic_mz": "1111.9129",
                                "intensity": "10033.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "40",
                                "monoisotopic_mass": "4063.0517",
                                "monoisotopic_mz": "1355.3578",
                                "intensity": "6228.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0183",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "41",
                                "monoisotopic_mass": "3360.7135",
                                "monoisotopic_mz": "841.1856",
                                "intensity": "3076.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0171",
                                        "ppm": "5.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "42",
                                "monoisotopic_mass": "1336.7431",
                                "monoisotopic_mz": "669.3788",
                                "intensity": "2190.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "43",
                                "monoisotopic_mass": "4908.4625",
                                "monoisotopic_mz": "1228.1229",
                                "intensity": "5390.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "44",
                                "monoisotopic_mass": "3360.7094",
                                "monoisotopic_mz": "1121.2437",
                                "intensity": "20762.11",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0130",
                                        "ppm": "3.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "45",
                                "monoisotopic_mass": "1488.7508",
                                "monoisotopic_mz": "1489.7581",
                                "intensity": "1534.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "46",
                                "monoisotopic_mass": "647.4031",
                                "monoisotopic_mz": "648.4104",
                                "intensity": "2632.65",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.4006",
                                        "ion_position": "43",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0025",
                                        "ppm": "3.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "47",
                                "monoisotopic_mass": "3599.8879",
                                "monoisotopic_mz": "1200.9699",
                                "intensity": "5596.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "48",
                                "monoisotopic_mass": "1291.7195",
                                "monoisotopic_mz": "646.8670",
                                "intensity": "3085.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "49",
                                "monoisotopic_mass": "3934.0056",
                                "monoisotopic_mz": "1312.3425",
                                "intensity": "17345.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0148",
                                        "ppm": "3.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "50",
                                "monoisotopic_mass": "4191.1021",
                                "monoisotopic_mz": "1398.0413",
                                "intensity": "5132.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0101",
                                        "ppm": "2.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "51",
                                "monoisotopic_mass": "1677.8290",
                                "monoisotopic_mz": "839.9218",
                                "intensity": "4593.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0066",
                                        "ppm": "3.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "52",
                                "monoisotopic_mass": "5021.5342",
                                "monoisotopic_mz": "1256.3908",
                                "intensity": "6776.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "53",
                                "monoisotopic_mass": "4935.4532",
                                "monoisotopic_mz": "1234.8706",
                                "intensity": "9519.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "54",
                                "monoisotopic_mass": "1563.7844",
                                "monoisotopic_mz": "782.8995",
                                "intensity": "7681.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0050",
                                        "ppm": "3.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "55",
                                "monoisotopic_mass": "795.3645",
                                "monoisotopic_mz": "796.3718",
                                "intensity": "1343.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "56",
                                "monoisotopic_mass": "1702.9016",
                                "monoisotopic_mz": "852.4581",
                                "intensity": "1214.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "57",
                                "monoisotopic_mass": "3598.8916",
                                "monoisotopic_mz": "900.7302",
                                "intensity": "6016.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "58",
                                "monoisotopic_mass": "624.3138",
                                "monoisotopic_mz": "625.3211",
                                "intensity": "1010.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "59",
                                "monoisotopic_mass": "2132.0476",
                                "monoisotopic_mz": "711.6898",
                                "intensity": "1654.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "60",
                                "monoisotopic_mass": "1192.6501",
                                "monoisotopic_mz": "597.3323",
                                "intensity": "2971.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "61",
                                "monoisotopic_mass": "1220.6460",
                                "monoisotopic_mz": "611.3303",
                                "intensity": "2159.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0045",
                                        "ppm": "3.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "62",
                                "monoisotopic_mass": "603.2929",
                                "monoisotopic_mz": "604.3002",
                                "intensity": "1269.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "63",
                                "monoisotopic_mass": "3470.7891",
                                "monoisotopic_mz": "1157.9370",
                                "intensity": "6481.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "64",
                                "monoisotopic_mass": "3669.9236",
                                "monoisotopic_mz": "918.4882",
                                "intensity": "6861.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "65",
                                "monoisotopic_mass": "2973.5165",
                                "monoisotopic_mz": "1487.7655",
                                "intensity": "2049.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "66",
                                "monoisotopic_mass": "4063.0518",
                                "monoisotopic_mz": "1016.7702",
                                "intensity": "6305.45",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0184",
                                        "ppm": "4.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "67",
                                "monoisotopic_mass": "4248.1284",
                                "monoisotopic_mz": "1063.0394",
                                "intensity": "6658.92",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0150",
                                        "ppm": "3.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "68",
                                "monoisotopic_mass": "3616.9028",
                                "monoisotopic_mz": "1206.6415",
                                "intensity": "11717.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0166",
                                        "ppm": "4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "69",
                                "monoisotopic_mass": "690.3246",
                                "monoisotopic_mz": "691.3318",
                                "intensity": "1362.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "70",
                                "monoisotopic_mass": "3915.9891",
                                "monoisotopic_mz": "1306.3370",
                                "intensity": "4949.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "71",
                                "monoisotopic_mass": "577.2409",
                                "monoisotopic_mz": "578.2482",
                                "intensity": "1057.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "72",
                                "monoisotopic_mass": "3020.7667",
                                "monoisotopic_mz": "1007.9295",
                                "intensity": "1390.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "73",
                                "monoisotopic_mass": "2481.2175",
                                "monoisotopic_mz": "828.0798",
                                "intensity": "1304.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2481.2037",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0138",
                                        "ppm": "5.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "74",
                                "monoisotopic_mass": "4576.3434",
                                "monoisotopic_mz": "1145.0931",
                                "intensity": "6346.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4576.3245",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0189",
                                        "ppm": "4.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "75",
                                "monoisotopic_mass": "5065.5403",
                                "monoisotopic_mz": "1014.1153",
                                "intensity": "4310.92",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0117",
                                        "ppm": "2.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "76",
                                "monoisotopic_mass": "1362.7561",
                                "monoisotopic_mz": "682.3853",
                                "intensity": "1419.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "77",
                                "monoisotopic_mass": "3120.5621",
                                "monoisotopic_mz": "1041.1946",
                                "intensity": "4674.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "78",
                                "monoisotopic_mass": "490.2082",
                                "monoisotopic_mz": "491.2155",
                                "intensity": "1720.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "79",
                                "monoisotopic_mass": "4045.0420",
                                "monoisotopic_mz": "1012.2678",
                                "intensity": "2579.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "80",
                                "monoisotopic_mass": "3147.5571",
                                "monoisotopic_mz": "787.8966",
                                "intensity": "3140.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "81",
                                "monoisotopic_mass": "4191.1059",
                                "monoisotopic_mz": "1048.7838",
                                "intensity": "7803.17",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0140",
                                        "ppm": "3.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "82",
                                "monoisotopic_mass": "469.2778",
                                "monoisotopic_mz": "470.2850",
                                "intensity": "2470.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "83",
                                "monoisotopic_mass": "2093.0377",
                                "monoisotopic_mz": "1047.5261",
                                "intensity": "9010.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0087",
                                        "ppm": "4.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "84",
                                "monoisotopic_mass": "4230.0977",
                                "monoisotopic_mz": "1411.0398",
                                "intensity": "2442.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "85",
                                "monoisotopic_mass": "3277.6310",
                                "monoisotopic_mz": "1093.5510",
                                "intensity": "5464.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "86",
                                "monoisotopic_mass": "2158.0669",
                                "monoisotopic_mz": "720.3629",
                                "intensity": "2394.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "87",
                                "monoisotopic_mass": "3934.0046",
                                "monoisotopic_mz": "984.5084",
                                "intensity": "8370.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0138",
                                        "ppm": "3.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "88",
                                "monoisotopic_mass": "4463.2652",
                                "monoisotopic_mz": "1116.8236",
                                "intensity": "3253.48",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4463.2404",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0248",
                                        "ppm": "5.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "107",
                                "peak_id": "89",
                                "monoisotopic_mass": "3670.9380",
                                "monoisotopic_mz": "1224.6533",
                                "intensity": "3776.81",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "107",
                                        "peak_id": "61",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "107",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "107",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "107",
                                            "peak_id": "28",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "107",
                                        "peak_id": "54",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "107",
                                        "peak_id": "51",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "107",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "107",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "107",
                                        "peak_id": "83",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "107",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "107",
                                        "peak_id": "73",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "107",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "107",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "107",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "107",
                                        "peak_id": "34",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "107",
                                            "peak_id": "44",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "107",
                                            "peak_id": "41",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "107",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "107",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "107",
                                            "peak_id": "68",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "33",
                                            "ion_display_position": "15",
                                            "spec_id": "107",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "107",
                                            "peak_id": "26",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "14",
                                            "spec_id": "107",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "107",
                                            "peak_id": "27",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "107",
                                            "peak_id": "32",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "107",
                                            "peak_id": "87",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "107",
                                            "peak_id": "49",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "107",
                                            "peak_id": "40",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "107",
                                            "peak_id": "66",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "107",
                                            "peak_id": "50",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "107",
                                            "peak_id": "81",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "107",
                                        "peak_id": "67",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "107",
                                        "peak_id": "37",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "107",
                                        "peak_id": "88",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "107",
                                        "peak_id": "74",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "107",
                                        "peak_id": "22",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "43",
                                            "ion_display_position": "5",
                                            "spec_id": "107",
                                            "peak_id": "46",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "43",
                                            "ion_display_position": "43",
                                            "spec_id": "107",
                                            "peak_id": "25",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "107",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "107",
                                            "peak_id": "75",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "107",
                                            "peak_id": "23",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "107",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "94",
                "p_value": "6.25e-23",
                "e_value": "6.25e-23",
                "fdr": "0",
                "matched_fragment_number": "27",
                "matched_peak_number": "31",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "587",
                        "ms1_scans": "851",
                        "ids": "264",
                        "scans": "853",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7683",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "264",
                                "peak_id": "0",
                                "monoisotopic_mass": "1780.8243",
                                "monoisotopic_mz": "1781.8316",
                                "intensity": "2520.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "1",
                                "monoisotopic_mass": "1417.7156",
                                "monoisotopic_mz": "1418.7229",
                                "intensity": "3302.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "2",
                                "monoisotopic_mass": "1248.6342",
                                "monoisotopic_mz": "1249.6415",
                                "intensity": "2046.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "3",
                                "monoisotopic_mass": "3471.7881",
                                "monoisotopic_mz": "1158.2700",
                                "intensity": "7586.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "4",
                                "monoisotopic_mass": "3360.7156",
                                "monoisotopic_mz": "1121.2458",
                                "intensity": "16930.80",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0193",
                                        "ppm": "5.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "5",
                                "monoisotopic_mass": "3488.8066",
                                "monoisotopic_mz": "1163.9428",
                                "intensity": "24694.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0154",
                                        "ppm": "4.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "6",
                                "monoisotopic_mass": "1863.8944",
                                "monoisotopic_mz": "932.9545",
                                "intensity": "18046.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0081",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "7",
                                "monoisotopic_mass": "1434.7450",
                                "monoisotopic_mz": "1435.7523",
                                "intensity": "4028.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0082",
                                        "ppm": "5.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "8",
                                "monoisotopic_mass": "1434.7441",
                                "monoisotopic_mz": "718.3793",
                                "intensity": "54267.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0073",
                                        "ppm": "5.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "9",
                                "monoisotopic_mass": "4953.4693",
                                "monoisotopic_mz": "1239.3746",
                                "intensity": "20255.95",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0225",
                                        "ppm": "4.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "10",
                                "monoisotopic_mass": "3377.7514",
                                "monoisotopic_mz": "1126.9244",
                                "intensity": "7220.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "11",
                                "monoisotopic_mass": "3616.9035",
                                "monoisotopic_mz": "1206.6418",
                                "intensity": "11162.16",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0173",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "12",
                                "monoisotopic_mass": "4063.0618",
                                "monoisotopic_mz": "1016.7727",
                                "intensity": "6667.16",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0284",
                                        "ppm": "6.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "13",
                                "monoisotopic_mass": "4063.0480",
                                "monoisotopic_mz": "1355.3566",
                                "intensity": "5782.39",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0147",
                                        "ppm": "3.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "14",
                                "monoisotopic_mass": "5066.5528",
                                "monoisotopic_mz": "1267.6455",
                                "intensity": "24280.68",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0219",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "15",
                                "monoisotopic_mass": "4691.3658",
                                "monoisotopic_mz": "1173.8487",
                                "intensity": "6908.58",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0144",
                                        "ppm": "3.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "16",
                                "monoisotopic_mass": "1946.9345",
                                "monoisotopic_mz": "974.4745",
                                "intensity": "5128.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "17",
                                "monoisotopic_mass": "1563.7866",
                                "monoisotopic_mz": "782.9006",
                                "intensity": "7421.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0072",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "18",
                                "monoisotopic_mass": "3219.6379",
                                "monoisotopic_mz": "1074.2199",
                                "intensity": "16524.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "19",
                                "monoisotopic_mass": "1487.7579",
                                "monoisotopic_mz": "1488.7651",
                                "intensity": "2037.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "20",
                                "monoisotopic_mass": "1192.6522",
                                "monoisotopic_mz": "597.3334",
                                "intensity": "2971.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "21",
                                "monoisotopic_mass": "3247.6285",
                                "monoisotopic_mz": "1083.5501",
                                "intensity": "21533.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0162",
                                        "ppm": "4.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "22",
                                "monoisotopic_mass": "2352.1801",
                                "monoisotopic_mz": "1177.0973",
                                "intensity": "2361.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "23",
                                "monoisotopic_mass": "1220.6474",
                                "monoisotopic_mz": "611.3310",
                                "intensity": "3245.23",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0060",
                                        "ppm": "4.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "24",
                                "monoisotopic_mass": "975.6034",
                                "monoisotopic_mz": "976.6107",
                                "intensity": "3518.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "25",
                                "monoisotopic_mass": "832.5098",
                                "monoisotopic_mz": "833.5171",
                                "intensity": "2118.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "26",
                                "monoisotopic_mass": "2093.0382",
                                "monoisotopic_mz": "1047.5264",
                                "intensity": "8856.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0092",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "27",
                                "monoisotopic_mass": "4935.4464",
                                "monoisotopic_mz": "1234.8689",
                                "intensity": "10825.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "28",
                                "monoisotopic_mass": "3934.0059",
                                "monoisotopic_mz": "1312.3426",
                                "intensity": "12410.01",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0151",
                                        "ppm": "3.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "29",
                                "monoisotopic_mass": "1373.7241",
                                "monoisotopic_mz": "1374.7313",
                                "intensity": "1590.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "30",
                                "monoisotopic_mass": "2795.7417",
                                "monoisotopic_mz": "699.9427",
                                "intensity": "749.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "31",
                                "monoisotopic_mass": "5180.6415",
                                "monoisotopic_mz": "1296.1677",
                                "intensity": "8592.89",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0242",
                                        "ppm": "4.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "32",
                                "monoisotopic_mass": "2503.7642",
                                "monoisotopic_mz": "1252.8894",
                                "intensity": "1770.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "33",
                                "monoisotopic_mass": "868.5373",
                                "monoisotopic_mz": "869.5446",
                                "intensity": "3093.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "34",
                                "monoisotopic_mass": "1278.6359",
                                "monoisotopic_mz": "1279.6432",
                                "intensity": "1519.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "35",
                                "monoisotopic_mass": "3598.8874",
                                "monoisotopic_mz": "1200.6364",
                                "intensity": "4722.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "36",
                                "monoisotopic_mass": "4788.3868",
                                "monoisotopic_mz": "1198.1040",
                                "intensity": "8210.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "37",
                                "monoisotopic_mass": "577.2414",
                                "monoisotopic_mz": "578.2487",
                                "intensity": "1305.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "38",
                                "monoisotopic_mass": "4805.4058",
                                "monoisotopic_mz": "1202.3587",
                                "intensity": "11344.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "39",
                                "monoisotopic_mass": "849.5248",
                                "monoisotopic_mz": "850.5321",
                                "intensity": "2949.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "40",
                                "monoisotopic_mass": "1677.8297",
                                "monoisotopic_mz": "839.9221",
                                "intensity": "5964.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0074",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "41",
                                "monoisotopic_mass": "469.2783",
                                "monoisotopic_mz": "470.2856",
                                "intensity": "2723.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "42",
                                "monoisotopic_mass": "796.4899",
                                "monoisotopic_mz": "797.4972",
                                "intensity": "1964.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "43",
                                "monoisotopic_mass": "4376.2255",
                                "monoisotopic_mz": "1095.0636",
                                "intensity": "10170.35",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0171",
                                        "ppm": "3.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "44",
                                "monoisotopic_mass": "4247.1214",
                                "monoisotopic_mz": "1416.7144",
                                "intensity": "3928.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "45",
                                "monoisotopic_mass": "1319.7158",
                                "monoisotopic_mz": "660.8652",
                                "intensity": "3344.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0059",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "46",
                                "monoisotopic_mass": "2259.1744",
                                "monoisotopic_mz": "1130.5945",
                                "intensity": "1965.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "47",
                                "monoisotopic_mass": "1576.9726",
                                "monoisotopic_mz": "789.4936",
                                "intensity": "2019.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "48",
                                "monoisotopic_mass": "2176.0810",
                                "monoisotopic_mz": "726.3676",
                                "intensity": "3193.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "49",
                                "monoisotopic_mass": "2194.0885",
                                "monoisotopic_mz": "732.3701",
                                "intensity": "3678.73",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0118",
                                        "ppm": "5.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "50",
                                "monoisotopic_mass": "3934.0112",
                                "monoisotopic_mz": "984.5101",
                                "intensity": "8116.58",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0204",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "51",
                                "monoisotopic_mass": "377.1237",
                                "monoisotopic_mz": "378.1310",
                                "intensity": "1741.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "52",
                                "monoisotopic_mass": "3315.6972",
                                "monoisotopic_mz": "1106.2397",
                                "intensity": "2690.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "53",
                                "monoisotopic_mass": "807.4852",
                                "monoisotopic_mz": "404.7499",
                                "intensity": "1255.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "807.4828",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0024",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "54",
                                "monoisotopic_mass": "2694.3063",
                                "monoisotopic_mz": "1348.1604",
                                "intensity": "2213.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "55",
                                "monoisotopic_mass": "1734.8537",
                                "monoisotopic_mz": "868.4341",
                                "intensity": "3683.00",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0099",
                                        "ppm": "5.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "56",
                                "monoisotopic_mass": "3686.9363",
                                "monoisotopic_mz": "922.7414",
                                "intensity": "9555.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "57",
                                "monoisotopic_mass": "1417.7137",
                                "monoisotopic_mz": "709.8641",
                                "intensity": "4013.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "58",
                                "monoisotopic_mass": "4248.1352",
                                "monoisotopic_mz": "1063.0411",
                                "intensity": "7534.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0218",
                                        "ppm": "5.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "59",
                                "monoisotopic_mass": "3120.5544",
                                "monoisotopic_mz": "1041.1921",
                                "intensity": "4500.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "60",
                                "monoisotopic_mass": "1175.6255",
                                "monoisotopic_mz": "588.8200",
                                "intensity": "477.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "61",
                                "monoisotopic_mass": "4191.1167",
                                "monoisotopic_mz": "1048.7864",
                                "intensity": "7943.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0247",
                                        "ppm": "5.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "62",
                                "monoisotopic_mass": "3332.7177",
                                "monoisotopic_mz": "1111.9132",
                                "intensity": "9925.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "63",
                                "monoisotopic_mass": "1986.2287",
                                "monoisotopic_mz": "994.1216",
                                "intensity": "3777.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "64",
                                "monoisotopic_mass": "511.3003",
                                "monoisotopic_mz": "512.3076",
                                "intensity": "2744.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "511.2979",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0024",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "65",
                                "monoisotopic_mass": "4265.1778",
                                "monoisotopic_mz": "1422.7332",
                                "intensity": "3151.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "66",
                                "monoisotopic_mass": "603.2936",
                                "monoisotopic_mz": "604.3008",
                                "intensity": "705.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "67",
                                "monoisotopic_mass": "2466.5268",
                                "monoisotopic_mz": "823.1829",
                                "intensity": "2215.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "68",
                                "monoisotopic_mass": "3148.5607",
                                "monoisotopic_mz": "1050.5275",
                                "intensity": "9513.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0169",
                                        "ppm": "5.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "69",
                                "monoisotopic_mass": "4190.1060",
                                "monoisotopic_mz": "1397.7093",
                                "intensity": "3641.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "70",
                                "monoisotopic_mass": "2059.7660",
                                "monoisotopic_mz": "687.5959",
                                "intensity": "803.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "71",
                                "monoisotopic_mass": "1878.1636",
                                "monoisotopic_mz": "940.0891",
                                "intensity": "2302.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "72",
                                "monoisotopic_mass": "1039.5726",
                                "monoisotopic_mz": "520.7936",
                                "intensity": "1339.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "73",
                                "monoisotopic_mass": "1717.0588",
                                "monoisotopic_mz": "859.5367",
                                "intensity": "2876.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "74",
                                "monoisotopic_mass": "2879.4177",
                                "monoisotopic_mz": "960.8132",
                                "intensity": "5062.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0114",
                                        "ppm": "3.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "75",
                                "monoisotopic_mass": "3460.1221",
                                "monoisotopic_mz": "693.0317",
                                "intensity": "3284.51",
                                "charge": "5"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "76",
                                "monoisotopic_mass": "970.5508",
                                "monoisotopic_mz": "486.2827",
                                "intensity": "906.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "970.5461",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0047",
                                        "ppm": "4.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "77",
                                "monoisotopic_mass": "1931.1969",
                                "monoisotopic_mz": "966.6057",
                                "intensity": "2108.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "78",
                                "monoisotopic_mass": "3247.6301",
                                "monoisotopic_mz": "812.9148",
                                "intensity": "3077.92",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0178",
                                        "ppm": "5.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "79",
                                "monoisotopic_mass": "3915.9843",
                                "monoisotopic_mz": "1306.3354",
                                "intensity": "4990.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "80",
                                "monoisotopic_mass": "4488.2993",
                                "monoisotopic_mz": "1123.0821",
                                "intensity": "2503.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "81",
                                "monoisotopic_mass": "1505.9305",
                                "monoisotopic_mz": "753.9725",
                                "intensity": "2024.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "82",
                                "monoisotopic_mass": "4046.0309",
                                "monoisotopic_mz": "1349.6843",
                                "intensity": "3429.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "83",
                                "monoisotopic_mass": "2763.0986",
                                "monoisotopic_mz": "691.7819",
                                "intensity": "1834.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "84",
                                "monoisotopic_mass": "2833.2061",
                                "monoisotopic_mz": "945.4093",
                                "intensity": "3105.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "85",
                                "monoisotopic_mass": "2727.6831",
                                "monoisotopic_mz": "910.2350",
                                "intensity": "2609.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "86",
                                "monoisotopic_mass": "3264.9984",
                                "monoisotopic_mz": "817.2569",
                                "intensity": "2985.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "87",
                                "monoisotopic_mass": "3298.0412",
                                "monoisotopic_mz": "825.5176",
                                "intensity": "3013.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "88",
                                "monoisotopic_mass": "3615.9002",
                                "monoisotopic_mz": "904.9823",
                                "intensity": "5256.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "264",
                                "peak_id": "89",
                                "monoisotopic_mass": "4359.2240",
                                "monoisotopic_mz": "1090.8133",
                                "intensity": "4036.99",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "264",
                                        "peak_id": "64",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "264",
                                        "peak_id": "53",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "264",
                                        "peak_id": "76",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "264",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "264",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "264",
                                            "peak_id": "8",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "264",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "264",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "264",
                                        "peak_id": "40",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "264",
                                        "peak_id": "55",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "264",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "264",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "264",
                                        "peak_id": "49",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "264",
                                        "peak_id": "74",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "264",
                                        "peak_id": "68",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "264",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "264",
                                            "peak_id": "78",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "264",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "264",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "264",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "264",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "264",
                                            "peak_id": "50",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "264",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "264",
                                            "peak_id": "12",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "264",
                                        "peak_id": "61",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "264",
                                        "peak_id": "58",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "264",
                                        "peak_id": "43",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "264",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "264",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "264",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "264",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "37",
                "p_value": "1.10e-17",
                "e_value": "1.10e-17",
                "fdr": "0",
                "matched_fragment_number": "26",
                "matched_peak_number": "32",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "524",
                        "ms1_scans": "599",
                        "ids": "76",
                        "scans": "602",
                        "precursor_mono_mass": "5453.8009",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7675",
                        "feature_inte": "4.5437e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "76",
                                "peak_id": "0",
                                "monoisotopic_mass": "1690.8292",
                                "monoisotopic_mz": "1691.8364",
                                "intensity": "817.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "1",
                                "monoisotopic_mass": "1090.5884",
                                "monoisotopic_mz": "1091.5957",
                                "intensity": "2233.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "2",
                                "monoisotopic_mass": "1979.0432",
                                "monoisotopic_mz": "990.5289",
                                "intensity": "3634.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "3",
                                "monoisotopic_mass": "1551.7824",
                                "monoisotopic_mz": "1552.7897",
                                "intensity": "2621.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "4",
                                "monoisotopic_mass": "1434.7432",
                                "monoisotopic_mz": "1435.7505",
                                "intensity": "1482.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0064",
                                        "ppm": "4.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "5",
                                "monoisotopic_mass": "5180.6464",
                                "monoisotopic_mz": "1296.1689",
                                "intensity": "5279.59",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0291",
                                        "ppm": "5.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "6",
                                "monoisotopic_mass": "1863.8948",
                                "monoisotopic_mz": "932.9547",
                                "intensity": "7784.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0084",
                                        "ppm": "4.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "7",
                                "monoisotopic_mass": "4806.4000",
                                "monoisotopic_mz": "1202.6073",
                                "intensity": "5936.45",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0216",
                                        "ppm": "4.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "8",
                                "monoisotopic_mass": "847.4051",
                                "monoisotopic_mz": "848.4124",
                                "intensity": "4048.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "9",
                                "monoisotopic_mass": "3219.6338",
                                "monoisotopic_mz": "1074.2186",
                                "intensity": "7724.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "10",
                                "monoisotopic_mass": "1529.8017",
                                "monoisotopic_mz": "1530.8090",
                                "intensity": "2607.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "11",
                                "monoisotopic_mass": "3687.9414",
                                "monoisotopic_mz": "922.9926",
                                "intensity": "4440.65",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0181",
                                        "ppm": "4.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "12",
                                "monoisotopic_mass": "1153.5792",
                                "monoisotopic_mz": "1154.5864",
                                "intensity": "1950.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "13",
                                "monoisotopic_mass": "1724.8836",
                                "monoisotopic_mz": "863.4491",
                                "intensity": "2149.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "14",
                                "monoisotopic_mass": "3598.8904",
                                "monoisotopic_mz": "900.7299",
                                "intensity": "1733.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "15",
                                "monoisotopic_mass": "4063.0564",
                                "monoisotopic_mz": "1016.7714",
                                "intensity": "3058.82",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0230",
                                        "ppm": "5.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "16",
                                "monoisotopic_mass": "1136.6252",
                                "monoisotopic_mz": "1137.6324",
                                "intensity": "2174.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "17",
                                "monoisotopic_mass": "1677.8299",
                                "monoisotopic_mz": "839.9222",
                                "intensity": "2793.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0076",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "18",
                                "monoisotopic_mass": "4191.1147",
                                "monoisotopic_mz": "1048.7860",
                                "intensity": "4145.42",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0227",
                                        "ppm": "5.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "19",
                                "monoisotopic_mass": "1702.8998",
                                "monoisotopic_mz": "852.4572",
                                "intensity": "6106.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "20",
                                "monoisotopic_mass": "1836.8967",
                                "monoisotopic_mz": "1837.9040",
                                "intensity": "839.42",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1836.8928",
                                        "ion_position": "32",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0039",
                                        "ppm": "2.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "21",
                                "monoisotopic_mass": "1529.7984",
                                "monoisotopic_mz": "765.9065",
                                "intensity": "3154.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "22",
                                "monoisotopic_mass": "4953.4674",
                                "monoisotopic_mz": "1239.3741",
                                "intensity": "8473.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0206",
                                        "ppm": "4.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "23",
                                "monoisotopic_mass": "3818.9780",
                                "monoisotopic_mz": "1273.9999",
                                "intensity": "1925.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0141",
                                        "ppm": "3.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "24",
                                "monoisotopic_mass": "1434.7429",
                                "monoisotopic_mz": "718.3787",
                                "intensity": "22258.03",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0061",
                                        "ppm": "4.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "25",
                                "monoisotopic_mass": "1551.7792",
                                "monoisotopic_mz": "776.8969",
                                "intensity": "3242.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "26",
                                "monoisotopic_mass": "2832.5440",
                                "monoisotopic_mz": "945.1886",
                                "intensity": "2634.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "27",
                                "monoisotopic_mass": "3488.8052",
                                "monoisotopic_mz": "1163.9423",
                                "intensity": "11612.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0139",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "28",
                                "monoisotopic_mass": "1417.7175",
                                "monoisotopic_mz": "709.8660",
                                "intensity": "1764.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "29",
                                "monoisotopic_mass": "5066.5577",
                                "monoisotopic_mz": "1267.6467",
                                "intensity": "11015.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0268",
                                        "ppm": "5.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "30",
                                "monoisotopic_mass": "2119.0761",
                                "monoisotopic_mz": "1060.5453",
                                "intensity": "7762.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "31",
                                "monoisotopic_mass": "2180.1139",
                                "monoisotopic_mz": "1091.0642",
                                "intensity": "20822.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "32",
                                "monoisotopic_mass": "1573.7613",
                                "monoisotopic_mz": "787.8879",
                                "intensity": "3325.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "33",
                                "monoisotopic_mass": "1497.7867",
                                "monoisotopic_mz": "1498.7939",
                                "intensity": "1043.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "34",
                                "monoisotopic_mass": "3488.7982",
                                "monoisotopic_mz": "873.2068",
                                "intensity": "1082.16",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0069",
                                        "ppm": "1.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "35",
                                "monoisotopic_mass": "1589.7273",
                                "monoisotopic_mz": "795.8709",
                                "intensity": "4590.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "36",
                                "monoisotopic_mass": "3616.9092",
                                "monoisotopic_mz": "905.2346",
                                "intensity": "3165.83",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0229",
                                        "ppm": "6.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "37",
                                "monoisotopic_mass": "1497.7857",
                                "monoisotopic_mz": "749.9001",
                                "intensity": "1441.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "38",
                                "monoisotopic_mass": "2016.9930",
                                "monoisotopic_mz": "1009.5038",
                                "intensity": "1712.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "39",
                                "monoisotopic_mass": "1075.5470",
                                "monoisotopic_mz": "1076.5543",
                                "intensity": "1789.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "40",
                                "monoisotopic_mass": "1319.7153",
                                "monoisotopic_mz": "660.8649",
                                "intensity": "1723.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0055",
                                        "ppm": "4.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "41",
                                "monoisotopic_mass": "3470.7803",
                                "monoisotopic_mz": "1157.9340",
                                "intensity": "4054.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "42",
                                "monoisotopic_mass": "4788.3878",
                                "monoisotopic_mz": "1198.1042",
                                "intensity": "4296.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "43",
                                "monoisotopic_mass": "3934.0092",
                                "monoisotopic_mz": "1312.3437",
                                "intensity": "6069.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0184",
                                        "ppm": "4.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "44",
                                "monoisotopic_mass": "1192.6515",
                                "monoisotopic_mz": "597.3330",
                                "intensity": "1659.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "45",
                                "monoisotopic_mass": "5021.5450",
                                "monoisotopic_mz": "1256.3935",
                                "intensity": "3848.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "46",
                                "monoisotopic_mass": "3616.9028",
                                "monoisotopic_mz": "1206.6415",
                                "intensity": "5530.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0166",
                                        "ppm": "4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "47",
                                "monoisotopic_mass": "4935.4566",
                                "monoisotopic_mz": "1234.8714",
                                "intensity": "5442.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "48",
                                "monoisotopic_mass": "1485.7055",
                                "monoisotopic_mz": "743.8600",
                                "intensity": "1229.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "49",
                                "monoisotopic_mass": "4248.1450",
                                "monoisotopic_mz": "1063.0435",
                                "intensity": "3051.20",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0316",
                                        "ppm": "7.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "50",
                                "monoisotopic_mass": "3360.7138",
                                "monoisotopic_mz": "1121.2452",
                                "intensity": "9289.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0175",
                                        "ppm": "5.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "51",
                                "monoisotopic_mass": "1417.7177",
                                "monoisotopic_mz": "1418.7250",
                                "intensity": "1203.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "52",
                                "monoisotopic_mass": "490.2083",
                                "monoisotopic_mz": "491.2156",
                                "intensity": "899.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "53",
                                "monoisotopic_mass": "690.3251",
                                "monoisotopic_mz": "691.3324",
                                "intensity": "578.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "54",
                                "monoisotopic_mass": "4046.0210",
                                "monoisotopic_mz": "1012.5125",
                                "intensity": "2342.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "55",
                                "monoisotopic_mass": "649.3573",
                                "monoisotopic_mz": "650.3646",
                                "intensity": "1190.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "56",
                                "monoisotopic_mass": "2878.4183",
                                "monoisotopic_mz": "960.4800",
                                "intensity": "3001.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "57",
                                "monoisotopic_mass": "3934.0061",
                                "monoisotopic_mz": "984.5088",
                                "intensity": "4647.61",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0153",
                                        "ppm": "3.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "58",
                                "monoisotopic_mass": "2075.0155",
                                "monoisotopic_mz": "1038.5150",
                                "intensity": "1611.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "59",
                                "monoisotopic_mass": "1220.6454",
                                "monoisotopic_mz": "611.3300",
                                "intensity": "681.65",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0039",
                                        "ppm": "3.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "60",
                                "monoisotopic_mass": "1758.9111",
                                "monoisotopic_mz": "880.4628",
                                "intensity": "1070.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "61",
                                "monoisotopic_mass": "3599.8847",
                                "monoisotopic_mz": "1200.9688",
                                "intensity": "2029.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "62",
                                "monoisotopic_mass": "511.3005",
                                "monoisotopic_mz": "512.3077",
                                "intensity": "886.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "511.2979",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0025",
                                        "ppm": "4.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "63",
                                "monoisotopic_mass": "3818.9811",
                                "monoisotopic_mz": "955.7526",
                                "intensity": "4522.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0173",
                                        "ppm": "4.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "64",
                                "monoisotopic_mass": "387.2493",
                                "monoisotopic_mz": "388.2566",
                                "intensity": "1663.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0011",
                                        "ppm": "2.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "65",
                                "monoisotopic_mass": "4691.3742",
                                "monoisotopic_mz": "1173.8508",
                                "intensity": "4797.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0228",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "66",
                                "monoisotopic_mass": "1964.9412",
                                "monoisotopic_mz": "983.4779",
                                "intensity": "2095.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0071",
                                        "ppm": "3.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "67",
                                "monoisotopic_mass": "577.2330",
                                "monoisotopic_mz": "578.2402",
                                "intensity": "1346.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "68",
                                "monoisotopic_mass": "1398.7027",
                                "monoisotopic_mz": "700.3586",
                                "intensity": "969.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "69",
                                "monoisotopic_mass": "5048.5469",
                                "monoisotopic_mz": "1263.1440",
                                "intensity": "6835.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "70",
                                "monoisotopic_mass": "1026.0096",
                                "monoisotopic_mz": "1027.0168",
                                "intensity": "1147.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "71",
                                "monoisotopic_mass": "4907.4410",
                                "monoisotopic_mz": "1227.8675",
                                "intensity": "2429.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "72",
                                "monoisotopic_mass": "1605.6924",
                                "monoisotopic_mz": "803.8535",
                                "intensity": "1494.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "73",
                                "monoisotopic_mass": "3147.5555",
                                "monoisotopic_mz": "1050.1924",
                                "intensity": "4571.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "74",
                                "monoisotopic_mass": "3247.6289",
                                "monoisotopic_mz": "1083.5502",
                                "intensity": "8934.87",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0166",
                                        "ppm": "5.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "75",
                                "monoisotopic_mass": "1262.6934",
                                "monoisotopic_mz": "1263.7007",
                                "intensity": "1388.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1262.6871",
                                        "ion_position": "37",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0064",
                                        "ppm": "5.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "76",
                                "monoisotopic_mass": "3202.6116",
                                "monoisotopic_mz": "1068.5445",
                                "intensity": "2240.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "77",
                                "monoisotopic_mass": "3332.7243",
                                "monoisotopic_mz": "1111.9154",
                                "intensity": "4201.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "78",
                                "monoisotopic_mass": "2158.0552",
                                "monoisotopic_mz": "720.3590",
                                "intensity": "598.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "79",
                                "monoisotopic_mass": "3343.6849",
                                "monoisotopic_mz": "1115.5689",
                                "intensity": "2153.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "80",
                                "monoisotopic_mass": "4231.1030",
                                "monoisotopic_mz": "1411.3749",
                                "intensity": "1593.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "81",
                                "monoisotopic_mass": "2952.4883",
                                "monoisotopic_mz": "985.1700",
                                "intensity": "2286.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "82",
                                "monoisotopic_mass": "3247.6301",
                                "monoisotopic_mz": "812.9148",
                                "intensity": "1438.75",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0178",
                                        "ppm": "5.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "83",
                                "monoisotopic_mass": "4190.1144",
                                "monoisotopic_mz": "1397.7121",
                                "intensity": "2203.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "84",
                                "monoisotopic_mass": "2936.4451",
                                "monoisotopic_mz": "979.8223",
                                "intensity": "1381.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "85",
                                "monoisotopic_mass": "2207.1168",
                                "monoisotopic_mz": "1104.5657",
                                "intensity": "562.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "86",
                                "monoisotopic_mass": "4463.2666",
                                "monoisotopic_mz": "1116.8239",
                                "intensity": "1805.67",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4463.2404",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0262",
                                        "ppm": "5.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "87",
                                "monoisotopic_mass": "1946.9346",
                                "monoisotopic_mz": "974.4746",
                                "intensity": "1907.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "88",
                                "monoisotopic_mass": "1373.7237",
                                "monoisotopic_mz": "1374.7310",
                                "intensity": "389.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "76",
                                "peak_id": "89",
                                "monoisotopic_mass": "4771.3608",
                                "monoisotopic_mz": "1193.8475",
                                "intensity": "1335.83",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "76",
                                        "peak_id": "62",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "76",
                                        "peak_id": "59",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "76",
                                        "peak_id": "40",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "76",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "76",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "76",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "76",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "76",
                                        "peak_id": "66",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "76",
                                            "peak_id": "74",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "76",
                                            "peak_id": "82",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "76",
                                        "peak_id": "50",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "76",
                                            "peak_id": "34",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "76",
                                            "peak_id": "27",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "16",
                                            "spec_id": "76",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "76",
                                            "peak_id": "46",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "76",
                                            "peak_id": "36",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "76",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "76",
                                            "peak_id": "23",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "76",
                                            "peak_id": "63",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "76",
                                            "peak_id": "57",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "76",
                                            "peak_id": "43",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "76",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "37",
                                            "ion_display_position": "11",
                                            "spec_id": "76",
                                            "peak_id": "75",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "76",
                                            "peak_id": "18",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "76",
                                        "peak_id": "49",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "76",
                                        "peak_id": "86",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "76",
                                        "peak_id": "65",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "76",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "76",
                                        "peak_id": "22",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "3",
                                            "spec_id": "76",
                                            "peak_id": "64",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "76",
                                            "peak_id": "29",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "76",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "71",
                "p_value": "1.23e-17",
                "e_value": "1.23e-17",
                "fdr": "0",
                "matched_fragment_number": "24",
                "matched_peak_number": "24",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "576",
                        "ms1_scans": "807",
                        "ids": "231",
                        "scans": "809",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7683",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "231",
                                "peak_id": "0",
                                "monoisotopic_mass": "1230.6106",
                                "monoisotopic_mz": "1231.6179",
                                "intensity": "2285.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "1",
                                "monoisotopic_mass": "3360.7171",
                                "monoisotopic_mz": "1121.2463",
                                "intensity": "19623.71",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.6963",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "B00030",
                                            "ion_left_position": "30",
                                            "mass_error": "0.0207",
                                            "ppm": "6.17"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.7500",
                                            "ion_position": "18",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "Y00030",
                                            "ion_left_position": "18",
                                            "mass_error": "-0.0329",
                                            "ppm": "-9.80"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "2",
                                "monoisotopic_mass": "5066.5547",
                                "monoisotopic_mz": "1267.6460",
                                "intensity": "18961.00",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0239",
                                        "ppm": "4.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "3",
                                "monoisotopic_mass": "5179.6303",
                                "monoisotopic_mz": "1295.9148",
                                "intensity": "9444.58",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0154",
                                        "ppm": "2.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "4",
                                "monoisotopic_mass": "1434.7419",
                                "monoisotopic_mz": "1435.7491",
                                "intensity": "3348.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0051",
                                        "ppm": "3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "5",
                                "monoisotopic_mass": "1434.7449",
                                "monoisotopic_mz": "718.3797",
                                "intensity": "57052.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0081",
                                        "ppm": "5.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "6",
                                "monoisotopic_mass": "1092.6784",
                                "monoisotopic_mz": "1093.6857",
                                "intensity": "2379.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "7",
                                "monoisotopic_mass": "3934.0085",
                                "monoisotopic_mz": "1312.3434",
                                "intensity": "12769.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0177",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "8",
                                "monoisotopic_mass": "3247.6274",
                                "monoisotopic_mz": "1083.5497",
                                "intensity": "24424.39",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0151",
                                        "ppm": "4.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "9",
                                "monoisotopic_mass": "2289.1764",
                                "monoisotopic_mz": "1145.5955",
                                "intensity": "3716.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "10",
                                "monoisotopic_mass": "4953.4581",
                                "monoisotopic_mz": "1239.3718",
                                "intensity": "15758.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0113",
                                        "ppm": "2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "11",
                                "monoisotopic_mass": "849.5269",
                                "monoisotopic_mz": "850.5342",
                                "intensity": "7013.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "12",
                                "monoisotopic_mass": "4936.4556",
                                "monoisotopic_mz": "1235.1212",
                                "intensity": "7445.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "13",
                                "monoisotopic_mass": "3377.7407",
                                "monoisotopic_mz": "1126.9209",
                                "intensity": "6308.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "14",
                                "monoisotopic_mass": "4376.2309",
                                "monoisotopic_mz": "1095.0650",
                                "intensity": "10603.36",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0225",
                                        "ppm": "5.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "15",
                                "monoisotopic_mass": "4806.4077",
                                "monoisotopic_mz": "1202.6092",
                                "intensity": "11881.37",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0293",
                                        "ppm": "6.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "16",
                                "monoisotopic_mass": "3488.8070",
                                "monoisotopic_mz": "1163.9429",
                                "intensity": "23029.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0157",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "17",
                                "monoisotopic_mass": "988.6107",
                                "monoisotopic_mz": "989.6180",
                                "intensity": "4717.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "18",
                                "monoisotopic_mass": "3219.6335",
                                "monoisotopic_mz": "1074.2184",
                                "intensity": "14351.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "19",
                                "monoisotopic_mass": "3508.1588",
                                "monoisotopic_mz": "878.0470",
                                "intensity": "7441.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "20",
                                "monoisotopic_mass": "2093.0421",
                                "monoisotopic_mz": "1047.5283",
                                "intensity": "10668.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0131",
                                        "ppm": "6.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "21",
                                "monoisotopic_mass": "3616.9032",
                                "monoisotopic_mz": "1206.6417",
                                "intensity": "11883.44",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0169",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "22",
                                "monoisotopic_mass": "1192.6524",
                                "monoisotopic_mz": "597.3335",
                                "intensity": "3004.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "23",
                                "monoisotopic_mass": "1319.7167",
                                "monoisotopic_mz": "660.8656",
                                "intensity": "4318.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0068",
                                        "ppm": "5.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "24",
                                "monoisotopic_mass": "1563.7896",
                                "monoisotopic_mz": "782.9021",
                                "intensity": "7015.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0103",
                                        "ppm": "6.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "25",
                                "monoisotopic_mass": "3916.9892",
                                "monoisotopic_mz": "1306.6703",
                                "intensity": "5364.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "26",
                                "monoisotopic_mass": "3591.2194",
                                "monoisotopic_mz": "719.2511",
                                "intensity": "2520.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "27",
                                "monoisotopic_mass": "1598.9894",
                                "monoisotopic_mz": "800.5020",
                                "intensity": "3914.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "28",
                                "monoisotopic_mass": "490.2089",
                                "monoisotopic_mz": "491.2162",
                                "intensity": "1949.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "29",
                                "monoisotopic_mass": "4191.1219",
                                "monoisotopic_mz": "1398.0479",
                                "intensity": "4476.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0299",
                                        "ppm": "7.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "30",
                                "monoisotopic_mass": "5049.5391",
                                "monoisotopic_mz": "1263.3921",
                                "intensity": "10944.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "31",
                                "monoisotopic_mass": "1677.8326",
                                "monoisotopic_mz": "839.9236",
                                "intensity": "4514.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0103",
                                        "ppm": "6.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "32",
                                "monoisotopic_mass": "1407.8334",
                                "monoisotopic_mz": "470.2851",
                                "intensity": "2733.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "33",
                                "monoisotopic_mass": "3148.5534",
                                "monoisotopic_mz": "1050.5251",
                                "intensity": "11444.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0095",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "34",
                                "monoisotopic_mass": "511.3005",
                                "monoisotopic_mz": "512.3077",
                                "intensity": "2435.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "511.2979",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0025",
                                        "ppm": "4.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "35",
                                "monoisotopic_mass": "2409.4925",
                                "monoisotopic_mz": "804.1714",
                                "intensity": "3681.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "36",
                                "monoisotopic_mass": "1339.6769",
                                "monoisotopic_mz": "1340.6842",
                                "intensity": "1874.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "37",
                                "monoisotopic_mass": "2266.3996",
                                "monoisotopic_mz": "756.4738",
                                "intensity": "2564.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "38",
                                "monoisotopic_mass": "4559.3384",
                                "monoisotopic_mz": "1140.8419",
                                "intensity": "4266.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "39",
                                "monoisotopic_mass": "377.1238",
                                "monoisotopic_mz": "378.1310",
                                "intensity": "2257.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "40",
                                "monoisotopic_mass": "1391.6977",
                                "monoisotopic_mz": "1392.7050",
                                "intensity": "1988.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "41",
                                "monoisotopic_mass": "630.3865",
                                "monoisotopic_mz": "631.3938",
                                "intensity": "1214.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "42",
                                "monoisotopic_mass": "1369.8417",
                                "monoisotopic_mz": "685.9281",
                                "intensity": "2634.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "43",
                                "monoisotopic_mass": "814.5058",
                                "monoisotopic_mz": "815.5131",
                                "intensity": "4355.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "44",
                                "monoisotopic_mass": "5020.5440",
                                "monoisotopic_mz": "1256.1433",
                                "intensity": "6233.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "45",
                                "monoisotopic_mass": "535.3304",
                                "monoisotopic_mz": "536.3376",
                                "intensity": "1077.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "46",
                                "monoisotopic_mass": "2748.7087",
                                "monoisotopic_mz": "917.2435",
                                "intensity": "4429.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "47",
                                "monoisotopic_mass": "2452.5067",
                                "monoisotopic_mz": "614.1340",
                                "intensity": "2439.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "48",
                                "monoisotopic_mass": "2839.4228",
                                "monoisotopic_mz": "710.8630",
                                "intensity": "1340.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "49",
                                "monoisotopic_mass": "1434.8731",
                                "monoisotopic_mz": "479.2983",
                                "intensity": "1160.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "50",
                                "monoisotopic_mass": "3063.8933",
                                "monoisotopic_mz": "1022.3050",
                                "intensity": "3341.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "51",
                                "monoisotopic_mass": "3687.9341",
                                "monoisotopic_mz": "922.9908",
                                "intensity": "9666.74",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0107",
                                        "ppm": "2.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "52",
                                "monoisotopic_mass": "2394.4641",
                                "monoisotopic_mz": "799.1620",
                                "intensity": "3798.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "53",
                                "monoisotopic_mass": "3202.5882",
                                "monoisotopic_mz": "1068.5367",
                                "intensity": "4851.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "54",
                                "monoisotopic_mass": "914.5673",
                                "monoisotopic_mz": "915.5746",
                                "intensity": "5499.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "55",
                                "monoisotopic_mass": "1480.9194",
                                "monoisotopic_mz": "741.4670",
                                "intensity": "2717.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "56",
                                "monoisotopic_mass": "1220.6482",
                                "monoisotopic_mz": "611.3314",
                                "intensity": "1984.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0067",
                                        "ppm": "5.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "57",
                                "monoisotopic_mass": "807.4850",
                                "monoisotopic_mz": "404.7498",
                                "intensity": "1106.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "807.4828",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0023",
                                        "ppm": "2.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "58",
                                "monoisotopic_mass": "3471.7969",
                                "monoisotopic_mz": "1158.2729",
                                "intensity": "6536.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "59",
                                "monoisotopic_mass": "1520.9433",
                                "monoisotopic_mz": "761.4789",
                                "intensity": "4187.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "60",
                                "monoisotopic_mass": "1039.5737",
                                "monoisotopic_mz": "520.7941",
                                "intensity": "1026.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "61",
                                "monoisotopic_mass": "1964.9419",
                                "monoisotopic_mz": "983.4782",
                                "intensity": "4199.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0079",
                                        "ppm": "4.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "62",
                                "monoisotopic_mass": "1175.0652",
                                "monoisotopic_mz": "1176.0725",
                                "intensity": "1345.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "63",
                                "monoisotopic_mass": "4064.0857",
                                "monoisotopic_mz": "1017.0287",
                                "intensity": "4379.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "64",
                                "monoisotopic_mass": "2794.7219",
                                "monoisotopic_mz": "699.6878",
                                "intensity": "2596.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "65",
                                "monoisotopic_mass": "2257.4017",
                                "monoisotopic_mz": "1129.7081",
                                "intensity": "3286.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "66",
                                "monoisotopic_mass": "2591.6028",
                                "monoisotopic_mz": "864.8749",
                                "intensity": "4737.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "67",
                                "monoisotopic_mass": "1653.0268",
                                "monoisotopic_mz": "827.5207",
                                "intensity": "3048.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "68",
                                "monoisotopic_mass": "2175.3437",
                                "monoisotopic_mz": "726.1218",
                                "intensity": "2318.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "69",
                                "monoisotopic_mass": "3599.9030",
                                "monoisotopic_mz": "1200.9749",
                                "intensity": "4518.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "70",
                                "monoisotopic_mass": "4264.1499",
                                "monoisotopic_mz": "1422.3906",
                                "intensity": "2670.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "71",
                                "monoisotopic_mass": "2605.4043",
                                "monoisotopic_mz": "652.3583",
                                "intensity": "920.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "72",
                                "monoisotopic_mass": "2492.5280",
                                "monoisotopic_mz": "624.1393",
                                "intensity": "2274.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "73",
                                "monoisotopic_mass": "2210.0866",
                                "monoisotopic_mz": "737.7028",
                                "intensity": "852.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "74",
                                "monoisotopic_mass": "2329.9398",
                                "monoisotopic_mz": "777.6539",
                                "intensity": "1995.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "75",
                                "monoisotopic_mass": "4192.1128",
                                "monoisotopic_mz": "1049.0355",
                                "intensity": "8090.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "76",
                                "monoisotopic_mass": "3311.4455",
                                "monoisotopic_mz": "828.8687",
                                "intensity": "3244.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "77",
                                "monoisotopic_mass": "3172.9490",
                                "monoisotopic_mz": "794.2445",
                                "intensity": "3664.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "78",
                                "monoisotopic_mass": "2112.3107",
                                "monoisotopic_mz": "1057.1626",
                                "intensity": "5080.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "79",
                                "monoisotopic_mass": "2879.4186",
                                "monoisotopic_mz": "960.8135",
                                "intensity": "7769.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0123",
                                        "ppm": "4.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "80",
                                "monoisotopic_mass": "1995.2316",
                                "monoisotopic_mz": "666.0845",
                                "intensity": "2760.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "81",
                                "monoisotopic_mass": "2213.6320",
                                "monoisotopic_mz": "1107.8233",
                                "intensity": "3798.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "82",
                                "monoisotopic_mass": "5110.5935",
                                "monoisotopic_mz": "1023.1260",
                                "intensity": "3532.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "83",
                                "monoisotopic_mass": "2955.8408",
                                "monoisotopic_mz": "739.9675",
                                "intensity": "2150.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "84",
                                "monoisotopic_mass": "2658.2341",
                                "monoisotopic_mz": "665.5658",
                                "intensity": "1893.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "85",
                                "monoisotopic_mass": "3819.0049",
                                "monoisotopic_mz": "955.7585",
                                "intensity": "5516.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "86",
                                "monoisotopic_mass": "2014.2410",
                                "monoisotopic_mz": "1008.1278",
                                "intensity": "4940.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "87",
                                "monoisotopic_mass": "3400.3719",
                                "monoisotopic_mz": "851.1003",
                                "intensity": "2907.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "88",
                                "monoisotopic_mass": "2080.7865",
                                "monoisotopic_mz": "694.6028",
                                "intensity": "1719.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "231",
                                "peak_id": "89",
                                "monoisotopic_mass": "3841.0116",
                                "monoisotopic_mz": "769.2096",
                                "intensity": "3203.62",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "231",
                                        "peak_id": "34",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "231",
                                        "peak_id": "57",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "231",
                                        "peak_id": "56",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "231",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "231",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "231",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "231",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "231",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "231",
                                        "peak_id": "61",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "231",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "18",
                                            "ion_display_position": "30",
                                            "spec_id": "231",
                                            "peak_id": "1",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "231",
                                        "peak_id": "79",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "231",
                                        "peak_id": "33",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "231",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "231",
                                        "peak_id": "1",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "231",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "231",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "231",
                                        "peak_id": "51",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "231",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "231",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "231",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "231",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "231",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "231",
                                        "peak_id": "2",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "231",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "112",
                "p_value": "1.02e-15",
                "e_value": "1.02e-15",
                "fdr": "0",
                "matched_fragment_number": "21",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "598",
                        "ms1_scans": "895",
                        "ids": "296",
                        "scans": "896",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7683",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "296",
                                "peak_id": "0",
                                "monoisotopic_mass": "1715.9263",
                                "monoisotopic_mz": "1716.9336",
                                "intensity": "2733.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "1",
                                "monoisotopic_mass": "1670.9119",
                                "monoisotopic_mz": "1671.9192",
                                "intensity": "2641.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "2",
                                "monoisotopic_mass": "1602.8432",
                                "monoisotopic_mz": "1603.8505",
                                "intensity": "8318.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "3",
                                "monoisotopic_mass": "1557.8188",
                                "monoisotopic_mz": "1558.8260",
                                "intensity": "2419.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "4",
                                "monoisotopic_mass": "1698.9040",
                                "monoisotopic_mz": "1699.9113",
                                "intensity": "2015.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "5",
                                "monoisotopic_mass": "1471.7753",
                                "monoisotopic_mz": "1472.7826",
                                "intensity": "4513.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "6",
                                "monoisotopic_mass": "1780.8221",
                                "monoisotopic_mz": "1781.8294",
                                "intensity": "2628.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "7",
                                "monoisotopic_mass": "1370.7250",
                                "monoisotopic_mz": "1371.7323",
                                "intensity": "3543.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "8",
                                "monoisotopic_mass": "4691.3721",
                                "monoisotopic_mz": "1173.8503",
                                "intensity": "6782.62",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0207",
                                        "ppm": "4.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "9",
                                "monoisotopic_mass": "1241.6829",
                                "monoisotopic_mz": "1242.6902",
                                "intensity": "4886.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "10",
                                "monoisotopic_mass": "1387.7509",
                                "monoisotopic_mz": "1388.7582",
                                "intensity": "7488.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "11",
                                "monoisotopic_mass": "1634.8169",
                                "monoisotopic_mz": "1635.8242",
                                "intensity": "1329.54",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1634.8152",
                                        "ion_position": "34",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0018",
                                        "ppm": "1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "12",
                                "monoisotopic_mass": "1428.7842",
                                "monoisotopic_mz": "1429.7915",
                                "intensity": "3005.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "13",
                                "monoisotopic_mass": "1258.7087",
                                "monoisotopic_mz": "1259.7159",
                                "intensity": "11039.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "14",
                                "monoisotopic_mass": "1145.6251",
                                "monoisotopic_mz": "1146.6323",
                                "intensity": "15100.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "15",
                                "monoisotopic_mass": "2015.0454",
                                "monoisotopic_mz": "1008.5300",
                                "intensity": "13491.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "16",
                                "monoisotopic_mass": "1585.8165",
                                "monoisotopic_mz": "1586.8237",
                                "intensity": "5870.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "17",
                                "monoisotopic_mass": "805.4122",
                                "monoisotopic_mz": "806.4195",
                                "intensity": "7936.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "18",
                                "monoisotopic_mass": "1128.5975",
                                "monoisotopic_mz": "1129.6047",
                                "intensity": "5975.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "19",
                                "monoisotopic_mass": "1863.8954",
                                "monoisotopic_mz": "932.9550",
                                "intensity": "9573.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0090",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "20",
                                "monoisotopic_mass": "1032.5400",
                                "monoisotopic_mz": "1033.5472",
                                "intensity": "16478.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "21",
                                "monoisotopic_mass": "3598.8982",
                                "monoisotopic_mz": "900.7318",
                                "intensity": "2838.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "22",
                                "monoisotopic_mass": "2241.2159",
                                "monoisotopic_mz": "1121.6153",
                                "intensity": "4778.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "23",
                                "monoisotopic_mass": "1557.8258",
                                "monoisotopic_mz": "779.9202",
                                "intensity": "8641.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "24",
                                "monoisotopic_mass": "2128.1325",
                                "monoisotopic_mz": "1065.0735",
                                "intensity": "10375.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "25",
                                "monoisotopic_mass": "1488.8013",
                                "monoisotopic_mz": "1489.8086",
                                "intensity": "9477.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "26",
                                "monoisotopic_mass": "1411.7712",
                                "monoisotopic_mz": "1412.7784",
                                "intensity": "2418.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "27",
                                "monoisotopic_mass": "1434.7434",
                                "monoisotopic_mz": "718.3790",
                                "intensity": "33877.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0066",
                                        "ppm": "4.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "28",
                                "monoisotopic_mass": "1886.0015",
                                "monoisotopic_mz": "944.0080",
                                "intensity": "3477.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "29",
                                "monoisotopic_mass": "4248.1358",
                                "monoisotopic_mz": "1417.0525",
                                "intensity": "3325.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0224",
                                        "ppm": "5.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "30",
                                "monoisotopic_mass": "3488.8140",
                                "monoisotopic_mz": "1163.9453",
                                "intensity": "15024.06",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0227",
                                            "ppm": "6.50"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0310",
                                            "ppm": "-8.88"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "31",
                                "monoisotopic_mass": "1113.6380",
                                "monoisotopic_mz": "1114.6453",
                                "intensity": "2768.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "32",
                                "monoisotopic_mass": "1670.9096",
                                "monoisotopic_mz": "836.4621",
                                "intensity": "8789.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "33",
                                "monoisotopic_mass": "2866.5751",
                                "monoisotopic_mz": "1434.2948",
                                "intensity": "3488.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "34",
                                "monoisotopic_mass": "918.4971",
                                "monoisotopic_mz": "919.5043",
                                "intensity": "5182.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "35",
                                "monoisotopic_mass": "692.3274",
                                "monoisotopic_mz": "693.3347",
                                "intensity": "6457.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "36",
                                "monoisotopic_mass": "1319.7152",
                                "monoisotopic_mz": "660.8649",
                                "intensity": "2983.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0053",
                                        "ppm": "4.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "37",
                                "monoisotopic_mass": "3332.7159",
                                "monoisotopic_mz": "1111.9126",
                                "intensity": "8001.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "38",
                                "monoisotopic_mass": "3219.6327",
                                "monoisotopic_mz": "1074.2182",
                                "intensity": "9144.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "39",
                                "monoisotopic_mass": "1997.0278",
                                "monoisotopic_mz": "999.5212",
                                "intensity": "6555.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "40",
                                "monoisotopic_mass": "1600.9895",
                                "monoisotopic_mz": "801.5020",
                                "intensity": "1282.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "41",
                                "monoisotopic_mass": "2110.1156",
                                "monoisotopic_mz": "1056.0651",
                                "intensity": "2811.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "42",
                                "monoisotopic_mass": "4376.2280",
                                "monoisotopic_mz": "1095.0643",
                                "intensity": "5867.80",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0196",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "43",
                                "monoisotopic_mass": "5066.5552",
                                "monoisotopic_mz": "1267.6461",
                                "intensity": "16341.61",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0244",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "44",
                                "monoisotopic_mass": "4427.2247",
                                "monoisotopic_mz": "1107.8135",
                                "intensity": "3469.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "45",
                                "monoisotopic_mass": "1343.7212",
                                "monoisotopic_mz": "1344.7285",
                                "intensity": "1322.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "46",
                                "monoisotopic_mass": "1642.9143",
                                "monoisotopic_mz": "822.4644",
                                "intensity": "3300.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "47",
                                "monoisotopic_mass": "2798.4701",
                                "monoisotopic_mz": "1400.2423",
                                "intensity": "1984.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "48",
                                "monoisotopic_mass": "4907.4586",
                                "monoisotopic_mz": "1227.8719",
                                "intensity": "1714.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "49",
                                "monoisotopic_mass": "3360.7116",
                                "monoisotopic_mz": "1121.2445",
                                "intensity": "14337.54",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0152",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "50",
                                "monoisotopic_mass": "3916.9907",
                                "monoisotopic_mz": "1306.6708",
                                "intensity": "4031.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "51",
                                "monoisotopic_mass": "3247.6314",
                                "monoisotopic_mz": "1083.5511",
                                "intensity": "13248.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0191",
                                        "ppm": "5.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "52",
                                "monoisotopic_mass": "3935.0134",
                                "monoisotopic_mz": "1312.6784",
                                "intensity": "7028.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "53",
                                "monoisotopic_mass": "4576.3355",
                                "monoisotopic_mz": "1145.0912",
                                "intensity": "4282.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4576.3245",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0111",
                                        "ppm": "2.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "54",
                                "monoisotopic_mass": "3132.5420",
                                "monoisotopic_mz": "1045.1879",
                                "intensity": "1972.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "55",
                                "monoisotopic_mass": "2994.6264",
                                "monoisotopic_mz": "1498.3205",
                                "intensity": "6117.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "56",
                                "monoisotopic_mass": "1459.7466",
                                "monoisotopic_mz": "1460.7539",
                                "intensity": "1260.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "57",
                                "monoisotopic_mass": "3615.8968",
                                "monoisotopic_mz": "904.9815",
                                "intensity": "2467.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "58",
                                "monoisotopic_mass": "2737.5350",
                                "monoisotopic_mz": "1369.7748",
                                "intensity": "2820.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "59",
                                "monoisotopic_mass": "3014.6278",
                                "monoisotopic_mz": "1508.3212",
                                "intensity": "3505.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "60",
                                "monoisotopic_mass": "2194.0872",
                                "monoisotopic_mz": "732.3697",
                                "intensity": "2241.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0105",
                                        "ppm": "4.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "61",
                                "monoisotopic_mass": "3315.6968",
                                "monoisotopic_mz": "1106.2396",
                                "intensity": "1680.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "62",
                                "monoisotopic_mass": "4953.4708",
                                "monoisotopic_mz": "1239.3750",
                                "intensity": "10710.63",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0240",
                                        "ppm": "4.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "63",
                                "monoisotopic_mass": "788.3852",
                                "monoisotopic_mz": "789.3925",
                                "intensity": "2415.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "64",
                                "monoisotopic_mass": "2883.6002",
                                "monoisotopic_mz": "1442.8074",
                                "intensity": "1778.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "65",
                                "monoisotopic_mass": "1380.6511",
                                "monoisotopic_mz": "691.3328",
                                "intensity": "816.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "66",
                                "monoisotopic_mass": "3616.9057",
                                "monoisotopic_mz": "1206.6425",
                                "intensity": "8002.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0195",
                                        "ppm": "5.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "67",
                                "monoisotopic_mass": "2879.4074",
                                "monoisotopic_mz": "960.8097",
                                "intensity": "2988.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0011",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "68",
                                "monoisotopic_mass": "3687.9373",
                                "monoisotopic_mz": "922.9916",
                                "intensity": "6663.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0139",
                                        "ppm": "3.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "69",
                                "monoisotopic_mass": "377.1236",
                                "monoisotopic_mz": "378.1308",
                                "intensity": "1350.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "70",
                                "monoisotopic_mass": "675.3002",
                                "monoisotopic_mz": "676.3075",
                                "intensity": "1584.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "71",
                                "monoisotopic_mass": "490.2084",
                                "monoisotopic_mz": "491.2157",
                                "intensity": "1016.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "72",
                                "monoisotopic_mass": "858.3823",
                                "monoisotopic_mz": "859.3896",
                                "intensity": "1713.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "73",
                                "monoisotopic_mass": "4806.4029",
                                "monoisotopic_mz": "1202.6080",
                                "intensity": "7319.56",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0245",
                                        "ppm": "5.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "74",
                                "monoisotopic_mass": "2132.0496",
                                "monoisotopic_mz": "711.6905",
                                "intensity": "2056.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "75",
                                "monoisotopic_mass": "4247.1328",
                                "monoisotopic_mz": "1062.7905",
                                "intensity": "4801.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "76",
                                "monoisotopic_mass": "1529.8313",
                                "monoisotopic_mz": "765.9229",
                                "intensity": "1624.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "77",
                                "monoisotopic_mass": "3377.7385",
                                "monoisotopic_mz": "1126.9201",
                                "intensity": "3772.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "78",
                                "monoisotopic_mass": "5048.5347",
                                "monoisotopic_mz": "1263.1410",
                                "intensity": "7082.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "79",
                                "monoisotopic_mass": "5002.5336",
                                "monoisotopic_mz": "1251.6407",
                                "intensity": "2132.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "80",
                                "monoisotopic_mass": "3470.7869",
                                "monoisotopic_mz": "1157.9362",
                                "intensity": "2952.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "81",
                                "monoisotopic_mass": "4891.4865",
                                "monoisotopic_mz": "979.3046",
                                "intensity": "2173.96",
                                "charge": "5"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "82",
                                "monoisotopic_mass": "3148.5618",
                                "monoisotopic_mz": "1050.5279",
                                "intensity": "4870.56",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0180",
                                        "ppm": "5.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "83",
                                "monoisotopic_mass": "4192.1137",
                                "monoisotopic_mz": "1049.0357",
                                "intensity": "4745.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "84",
                                "monoisotopic_mass": "4063.0553",
                                "monoisotopic_mz": "1016.7711",
                                "intensity": "4456.49",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0219",
                                        "ppm": "5.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "85",
                                "monoisotopic_mass": "4402.2633",
                                "monoisotopic_mz": "881.4599",
                                "intensity": "1798.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "86",
                                "monoisotopic_mass": "1849.1426",
                                "monoisotopic_mz": "925.5786",
                                "intensity": "1725.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "87",
                                "monoisotopic_mass": "2176.0779",
                                "monoisotopic_mz": "726.3666",
                                "intensity": "2492.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "88",
                                "monoisotopic_mass": "2681.6806",
                                "monoisotopic_mz": "894.9008",
                                "intensity": "1895.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "89",
                                "monoisotopic_mass": "2903.5287",
                                "monoisotopic_mz": "968.8502",
                                "intensity": "1368.23",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "296",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "296",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "296",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "31",
                                        "spec_id": "296",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "296",
                                        "peak_id": "60",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "296",
                                        "peak_id": "67",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "296",
                                        "peak_id": "82",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "296",
                                        "peak_id": "51",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "296",
                                        "peak_id": "49",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "296",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "296",
                                        "peak_id": "66",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "296",
                                        "peak_id": "68",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "14",
                                        "spec_id": "296",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "296",
                                        "peak_id": "84",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "296",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "296",
                                        "peak_id": "42",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "296",
                                        "peak_id": "53",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "296",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "296",
                                        "peak_id": "73",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "296",
                                        "peak_id": "62",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "296",
                                        "peak_id": "43",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "132",
                "p_value": "5.61e-13",
                "e_value": "5.61e-13",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "609",
                        "ms1_scans": "938",
                        "ids": "329",
                        "scans": "940",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7683",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "329",
                                "peak_id": "0",
                                "monoisotopic_mass": "1529.8313",
                                "monoisotopic_mz": "1530.8386",
                                "intensity": "1522.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "1",
                                "monoisotopic_mass": "1670.9098",
                                "monoisotopic_mz": "1671.9171",
                                "intensity": "2464.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "2",
                                "monoisotopic_mass": "1271.7432",
                                "monoisotopic_mz": "1272.7505",
                                "intensity": "1791.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "3",
                                "monoisotopic_mass": "1557.8257",
                                "monoisotopic_mz": "1558.8330",
                                "intensity": "3217.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "4",
                                "monoisotopic_mass": "1370.7260",
                                "monoisotopic_mz": "1371.7333",
                                "intensity": "4136.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "5",
                                "monoisotopic_mass": "1585.8183",
                                "monoisotopic_mz": "1586.8256",
                                "intensity": "6359.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "6",
                                "monoisotopic_mass": "1602.8451",
                                "monoisotopic_mz": "1603.8524",
                                "intensity": "8520.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "7",
                                "monoisotopic_mass": "2015.0448",
                                "monoisotopic_mz": "1008.5297",
                                "intensity": "12500.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "8",
                                "monoisotopic_mass": "3488.8132",
                                "monoisotopic_mz": "1163.9450",
                                "intensity": "11508.22",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0219",
                                            "ppm": "6.29"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0317",
                                            "ppm": "-9.10"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "9",
                                "monoisotopic_mass": "1241.6830",
                                "monoisotopic_mz": "1242.6903",
                                "intensity": "5056.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "10",
                                "monoisotopic_mass": "1642.9150",
                                "monoisotopic_mz": "1643.9222",
                                "intensity": "1680.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "11",
                                "monoisotopic_mass": "1145.6249",
                                "monoisotopic_mz": "1146.6322",
                                "intensity": "15692.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "12",
                                "monoisotopic_mass": "1670.9095",
                                "monoisotopic_mz": "836.4620",
                                "intensity": "9107.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "13",
                                "monoisotopic_mass": "1258.7094",
                                "monoisotopic_mz": "1259.7167",
                                "intensity": "12134.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "14",
                                "monoisotopic_mass": "1387.7525",
                                "monoisotopic_mz": "1388.7598",
                                "intensity": "7952.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "15",
                                "monoisotopic_mass": "1323.7188",
                                "monoisotopic_mz": "1324.7261",
                                "intensity": "1323.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "16",
                                "monoisotopic_mass": "805.4122",
                                "monoisotopic_mz": "806.4195",
                                "intensity": "7637.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "17",
                                "monoisotopic_mass": "1128.5980",
                                "monoisotopic_mz": "1129.6052",
                                "intensity": "6055.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "18",
                                "monoisotopic_mass": "1032.5400",
                                "monoisotopic_mz": "1033.5472",
                                "intensity": "17035.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "19",
                                "monoisotopic_mass": "1863.8968",
                                "monoisotopic_mz": "932.9557",
                                "intensity": "5506.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0104",
                                        "ppm": "5.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "20",
                                "monoisotopic_mass": "3934.0074",
                                "monoisotopic_mz": "1312.3431",
                                "intensity": "6267.46",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0166",
                                        "ppm": "4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "21",
                                "monoisotopic_mass": "2128.1317",
                                "monoisotopic_mz": "1065.0731",
                                "intensity": "10671.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "22",
                                "monoisotopic_mass": "918.4971",
                                "monoisotopic_mz": "919.5044",
                                "intensity": "6023.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "23",
                                "monoisotopic_mass": "1434.7431",
                                "monoisotopic_mz": "718.3788",
                                "intensity": "20543.09",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0063",
                                        "ppm": "4.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "24",
                                "monoisotopic_mass": "1557.8249",
                                "monoisotopic_mz": "779.9197",
                                "intensity": "7726.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "25",
                                "monoisotopic_mass": "1488.8019",
                                "monoisotopic_mz": "1489.8092",
                                "intensity": "11176.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "26",
                                "monoisotopic_mass": "1471.7792",
                                "monoisotopic_mz": "1472.7865",
                                "intensity": "3672.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "27",
                                "monoisotopic_mass": "1784.9527",
                                "monoisotopic_mz": "893.4836",
                                "intensity": "7850.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "28",
                                "monoisotopic_mass": "1411.7702",
                                "monoisotopic_mz": "1412.7775",
                                "intensity": "3403.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "29",
                                "monoisotopic_mass": "1428.7808",
                                "monoisotopic_mz": "1429.7881",
                                "intensity": "3488.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "30",
                                "monoisotopic_mass": "2355.2567",
                                "monoisotopic_mz": "1178.6356",
                                "intensity": "3756.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "31",
                                "monoisotopic_mass": "1642.9139",
                                "monoisotopic_mz": "822.4642",
                                "intensity": "4146.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "32",
                                "monoisotopic_mass": "692.3272",
                                "monoisotopic_mz": "693.3345",
                                "intensity": "7285.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "33",
                                "monoisotopic_mass": "4376.2256",
                                "monoisotopic_mz": "1095.0637",
                                "intensity": "4860.26",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0172",
                                        "ppm": "3.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "34",
                                "monoisotopic_mass": "1886.0051",
                                "monoisotopic_mz": "944.0099",
                                "intensity": "3764.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "35",
                                "monoisotopic_mass": "2110.1198",
                                "monoisotopic_mz": "1056.0672",
                                "intensity": "4886.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "36",
                                "monoisotopic_mass": "1997.0285",
                                "monoisotopic_mz": "999.5215",
                                "intensity": "5897.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "37",
                                "monoisotopic_mass": "2866.5717",
                                "monoisotopic_mz": "1434.2931",
                                "intensity": "4318.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "38",
                                "monoisotopic_mass": "1113.6382",
                                "monoisotopic_mz": "1114.6455",
                                "intensity": "3412.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "39",
                                "monoisotopic_mass": "2505.3964",
                                "monoisotopic_mz": "1253.7055",
                                "intensity": "2968.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "40",
                                "monoisotopic_mass": "714.8930",
                                "monoisotopic_mz": "715.9003",
                                "intensity": "2824.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "41",
                                "monoisotopic_mass": "1220.6474",
                                "monoisotopic_mz": "611.3310",
                                "intensity": "1380.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0060",
                                        "ppm": "4.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "42",
                                "monoisotopic_mass": "2996.6019",
                                "monoisotopic_mz": "1499.3082",
                                "intensity": "5034.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "43",
                                "monoisotopic_mass": "3247.6256",
                                "monoisotopic_mz": "1083.5491",
                                "intensity": "6373.27",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0133",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "44",
                                "monoisotopic_mass": "3014.6102",
                                "monoisotopic_mz": "1508.3124",
                                "intensity": "4075.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "45",
                                "monoisotopic_mass": "4691.3737",
                                "monoisotopic_mz": "1173.8507",
                                "intensity": "4180.11",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0223",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "46",
                                "monoisotopic_mass": "2798.4579",
                                "monoisotopic_mz": "1400.2362",
                                "intensity": "1914.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "47",
                                "monoisotopic_mass": "675.3010",
                                "monoisotopic_mz": "676.3083",
                                "intensity": "2691.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "48",
                                "monoisotopic_mass": "2883.5922",
                                "monoisotopic_mz": "1442.8034",
                                "intensity": "2028.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "49",
                                "monoisotopic_mass": "3377.7239",
                                "monoisotopic_mz": "1126.9152",
                                "intensity": "2571.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "50",
                                "monoisotopic_mass": "4953.4722",
                                "monoisotopic_mz": "1239.3753",
                                "intensity": "7772.23",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0255",
                                        "ppm": "5.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "51",
                                "monoisotopic_mass": "3687.9356",
                                "monoisotopic_mz": "922.9912",
                                "intensity": "4316.29",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0122",
                                        "ppm": "3.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "52",
                                "monoisotopic_mass": "856.4997",
                                "monoisotopic_mz": "857.5070",
                                "intensity": "1533.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "53",
                                "monoisotopic_mass": "1299.7398",
                                "monoisotopic_mz": "650.8772",
                                "intensity": "2341.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "54",
                                "monoisotopic_mass": "2737.5287",
                                "monoisotopic_mz": "1369.7716",
                                "intensity": "2812.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "55",
                                "monoisotopic_mass": "2194.0872",
                                "monoisotopic_mz": "732.3697",
                                "intensity": "1654.10",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0105",
                                        "ppm": "4.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "56",
                                "monoisotopic_mass": "2838.5774",
                                "monoisotopic_mz": "1420.2960",
                                "intensity": "2496.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "57",
                                "monoisotopic_mass": "550.2403",
                                "monoisotopic_mz": "551.2476",
                                "intensity": "637.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "58",
                                "monoisotopic_mass": "4191.1186",
                                "monoisotopic_mz": "1048.7869",
                                "intensity": "4834.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0267",
                                        "ppm": "6.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "59",
                                "monoisotopic_mass": "970.5129",
                                "monoisotopic_mz": "971.5202",
                                "intensity": "1774.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "60",
                                "monoisotopic_mass": "2604.4755",
                                "monoisotopic_mz": "1303.2450",
                                "intensity": "2325.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "61",
                                "monoisotopic_mass": "2454.2372",
                                "monoisotopic_mz": "1228.1259",
                                "intensity": "1987.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "62",
                                "monoisotopic_mass": "2719.4933",
                                "monoisotopic_mz": "1360.7539",
                                "intensity": "1652.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "63",
                                "monoisotopic_mass": "2576.4812",
                                "monoisotopic_mz": "1289.2479",
                                "intensity": "1125.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "64",
                                "monoisotopic_mass": "3360.7123",
                                "monoisotopic_mz": "1121.2447",
                                "intensity": "6490.93",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0160",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "65",
                                "monoisotopic_mass": "4806.3990",
                                "monoisotopic_mz": "1202.6070",
                                "intensity": "6500.82",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0206",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "66",
                                "monoisotopic_mass": "1766.9466",
                                "monoisotopic_mz": "884.4806",
                                "intensity": "1626.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "67",
                                "monoisotopic_mass": "5048.5346",
                                "monoisotopic_mz": "1263.1409",
                                "intensity": "5394.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "68",
                                "monoisotopic_mass": "2976.6080",
                                "monoisotopic_mz": "993.2100",
                                "intensity": "1776.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "69",
                                "monoisotopic_mass": "4430.2500",
                                "monoisotopic_mz": "1108.5698",
                                "intensity": "1536.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "70",
                                "monoisotopic_mass": "2468.3397",
                                "monoisotopic_mz": "1235.1771",
                                "intensity": "2567.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "71",
                                "monoisotopic_mass": "2644.6336",
                                "monoisotopic_mz": "882.5518",
                                "intensity": "1457.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "72",
                                "monoisotopic_mass": "2351.9886",
                                "monoisotopic_mz": "785.0035",
                                "intensity": "530.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "73",
                                "monoisotopic_mass": "4265.1381",
                                "monoisotopic_mz": "1067.2918",
                                "intensity": "1596.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "74",
                                "monoisotopic_mass": "3840.8953",
                                "monoisotopic_mz": "961.2311",
                                "intensity": "1506.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "75",
                                "monoisotopic_mass": "4728.4362",
                                "monoisotopic_mz": "946.6945",
                                "intensity": "1491.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "76",
                                "monoisotopic_mass": "3470.7869",
                                "monoisotopic_mz": "1157.9362",
                                "intensity": "3842.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "77",
                                "monoisotopic_mass": "3148.5589",
                                "monoisotopic_mz": "1050.5269",
                                "intensity": "3921.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0150",
                                        "ppm": "4.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "78",
                                "monoisotopic_mass": "3615.9112",
                                "monoisotopic_mz": "904.9851",
                                "intensity": "2963.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "79",
                                "monoisotopic_mass": "2927.5590",
                                "monoisotopic_mz": "1464.7868",
                                "intensity": "1467.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "80",
                                "monoisotopic_mass": "3800.9668",
                                "monoisotopic_mz": "951.2490",
                                "intensity": "713.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "81",
                                "monoisotopic_mass": "3615.9016",
                                "monoisotopic_mz": "1206.3078",
                                "intensity": "4300.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "82",
                                "monoisotopic_mass": "4936.4546",
                                "monoisotopic_mz": "1235.1209",
                                "intensity": "4932.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "83",
                                "monoisotopic_mass": "3128.5240",
                                "monoisotopic_mz": "783.1383",
                                "intensity": "3120.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "84",
                                "monoisotopic_mass": "2223.1959",
                                "monoisotopic_mz": "1112.6052",
                                "intensity": "2177.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "85",
                                "monoisotopic_mass": "4169.1986",
                                "monoisotopic_mz": "1043.3069",
                                "intensity": "2247.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "86",
                                "monoisotopic_mass": "1964.9398",
                                "monoisotopic_mz": "983.4772",
                                "intensity": "1420.86",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0058",
                                        "ppm": "2.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "87",
                                "monoisotopic_mass": "4462.2573",
                                "monoisotopic_mz": "1116.5716",
                                "intensity": "1894.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "88",
                                "monoisotopic_mass": "3025.7380",
                                "monoisotopic_mz": "1009.5866",
                                "intensity": "1162.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "329",
                                "peak_id": "89",
                                "monoisotopic_mass": "4248.1381",
                                "monoisotopic_mz": "1063.0418",
                                "intensity": "3372.41",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0247",
                                        "ppm": "5.82"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "329",
                                        "peak_id": "41",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "329",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "329",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "329",
                                            "peak_id": "86",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "spec_id": "329",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "329",
                                        "peak_id": "55",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "329",
                                        "peak_id": "77",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "329",
                                        "peak_id": "43",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "329",
                                        "peak_id": "64",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "329",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "329",
                                        "peak_id": "51",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "329",
                                        "peak_id": "20",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "329",
                                        "peak_id": "58",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "329",
                                        "peak_id": "89",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "329",
                                        "peak_id": "33",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "329",
                                        "peak_id": "45",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "329",
                                        "peak_id": "65",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "329",
                                        "peak_id": "50",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "73",
                "p_value": "8.53e-13",
                "e_value": "8.53e-13",
                "fdr": "0",
                "matched_fragment_number": "19",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "578",
                        "ms1_scans": "815",
                        "ids": "236",
                        "scans": "816",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "6",
                        "precursor_mz": "909.9748",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "236",
                                "peak_id": "0",
                                "monoisotopic_mass": "1339.8140",
                                "monoisotopic_mz": "1340.8213",
                                "intensity": "1153.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "1",
                                "monoisotopic_mass": "1267.6718",
                                "monoisotopic_mz": "1268.6791",
                                "intensity": "1269.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "2",
                                "monoisotopic_mass": "1074.5563",
                                "monoisotopic_mz": "1075.5636",
                                "intensity": "1626.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "3",
                                "monoisotopic_mass": "3148.5618",
                                "monoisotopic_mz": "1050.5279",
                                "intensity": "3382.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0180",
                                        "ppm": "5.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "4",
                                "monoisotopic_mass": "1946.9334",
                                "monoisotopic_mz": "974.4740",
                                "intensity": "4156.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "5",
                                "monoisotopic_mass": "2536.2925",
                                "monoisotopic_mz": "846.4381",
                                "intensity": "10350.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "6",
                                "monoisotopic_mass": "1863.8957",
                                "monoisotopic_mz": "932.9551",
                                "intensity": "14844.18",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0093",
                                        "ppm": "4.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "7",
                                "monoisotopic_mass": "2093.0372",
                                "monoisotopic_mz": "1047.5259",
                                "intensity": "3459.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0082",
                                        "ppm": "3.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "8",
                                "monoisotopic_mass": "3377.7649",
                                "monoisotopic_mz": "1126.9289",
                                "intensity": "2251.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "9",
                                "monoisotopic_mass": "1434.7439",
                                "monoisotopic_mz": "718.3792",
                                "intensity": "25638.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0071",
                                        "ppm": "4.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "10",
                                "monoisotopic_mass": "1563.7873",
                                "monoisotopic_mz": "782.9009",
                                "intensity": "5918.46",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0079",
                                        "ppm": "5.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "11",
                                "monoisotopic_mass": "2722.3569",
                                "monoisotopic_mz": "908.4596",
                                "intensity": "13456.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "12",
                                "monoisotopic_mass": "2191.1229",
                                "monoisotopic_mz": "1096.5688",
                                "intensity": "4158.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "13",
                                "monoisotopic_mass": "3219.6335",
                                "monoisotopic_mz": "1074.2184",
                                "intensity": "6167.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "14",
                                "monoisotopic_mass": "2705.3316",
                                "monoisotopic_mz": "902.7845",
                                "intensity": "2968.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "15",
                                "monoisotopic_mass": "1677.8313",
                                "monoisotopic_mz": "839.9229",
                                "intensity": "3532.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0090",
                                        "ppm": "5.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "16",
                                "monoisotopic_mass": "3247.6292",
                                "monoisotopic_mz": "1083.5503",
                                "intensity": "9914.44",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0169",
                                        "ppm": "5.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "17",
                                "monoisotopic_mass": "1294.7244",
                                "monoisotopic_mz": "1295.7317",
                                "intensity": "1761.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "18",
                                "monoisotopic_mass": "1319.7162",
                                "monoisotopic_mz": "660.8654",
                                "intensity": "2996.19",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0063",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "19",
                                "monoisotopic_mass": "1291.7225",
                                "monoisotopic_mz": "646.8685",
                                "intensity": "2962.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "20",
                                "monoisotopic_mass": "1920.9121",
                                "monoisotopic_mz": "961.4633",
                                "intensity": "1822.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "21",
                                "monoisotopic_mass": "4376.2347",
                                "monoisotopic_mz": "1095.0660",
                                "intensity": "3028.24",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0263",
                                        "ppm": "6.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "22",
                                "monoisotopic_mass": "3360.7142",
                                "monoisotopic_mz": "1121.2453",
                                "intensity": "6645.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0178",
                                        "ppm": "5.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "23",
                                "monoisotopic_mass": "3488.8158",
                                "monoisotopic_mz": "1163.9459",
                                "intensity": "6382.36",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0245",
                                            "ppm": "7.03"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0292",
                                            "ppm": "-8.36"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "24",
                                "monoisotopic_mass": "1964.9430",
                                "monoisotopic_mz": "983.4788",
                                "intensity": "2365.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0090",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "25",
                                "monoisotopic_mass": "1734.8520",
                                "monoisotopic_mz": "868.4333",
                                "intensity": "4076.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0082",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "26",
                                "monoisotopic_mass": "4062.0625",
                                "monoisotopic_mz": "1016.5229",
                                "intensity": "2087.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "27",
                                "monoisotopic_mass": "1220.6473",
                                "monoisotopic_mz": "611.3309",
                                "intensity": "1867.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0059",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "28",
                                "monoisotopic_mass": "1395.7693",
                                "monoisotopic_mz": "1396.7766",
                                "intensity": "1917.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "29",
                                "monoisotopic_mass": "1040.8569",
                                "monoisotopic_mz": "1041.8641",
                                "intensity": "733.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "30",
                                "monoisotopic_mass": "1154.5892",
                                "monoisotopic_mz": "1155.5964",
                                "intensity": "2006.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "31",
                                "monoisotopic_mass": "1204.6016",
                                "monoisotopic_mz": "1205.6089",
                                "intensity": "1471.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "32",
                                "monoisotopic_mass": "387.2498",
                                "monoisotopic_mz": "388.2570",
                                "intensity": "1380.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0016",
                                        "ppm": "4.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "33",
                                "monoisotopic_mass": "4248.1322",
                                "monoisotopic_mz": "1063.0403",
                                "intensity": "2957.40",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0188",
                                        "ppm": "4.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "34",
                                "monoisotopic_mass": "807.4857",
                                "monoisotopic_mz": "404.7501",
                                "intensity": "691.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "807.4828",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0029",
                                        "ppm": "3.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "35",
                                "monoisotopic_mass": "1192.6533",
                                "monoisotopic_mz": "597.3339",
                                "intensity": "2946.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "36",
                                "monoisotopic_mass": "1025.5456",
                                "monoisotopic_mz": "1026.5529",
                                "intensity": "1460.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "37",
                                "monoisotopic_mass": "2176.0777",
                                "monoisotopic_mz": "726.3665",
                                "intensity": "2330.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "38",
                                "monoisotopic_mass": "1421.7674",
                                "monoisotopic_mz": "711.8910",
                                "intensity": "1120.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "39",
                                "monoisotopic_mass": "3087.6258",
                                "monoisotopic_mz": "1030.2159",
                                "intensity": "1830.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "40",
                                "monoisotopic_mass": "2132.0528",
                                "monoisotopic_mz": "711.6915",
                                "intensity": "2737.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "41",
                                "monoisotopic_mass": "1496.9248",
                                "monoisotopic_mz": "749.4697",
                                "intensity": "922.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "42",
                                "monoisotopic_mass": "1716.8447",
                                "monoisotopic_mz": "859.4296",
                                "intensity": "1108.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "43",
                                "monoisotopic_mass": "3469.7919",
                                "monoisotopic_mz": "1157.6046",
                                "intensity": "1811.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "44",
                                "monoisotopic_mass": "540.2934",
                                "monoisotopic_mz": "541.3007",
                                "intensity": "652.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "45",
                                "monoisotopic_mass": "4191.0941",
                                "monoisotopic_mz": "1048.7808",
                                "intensity": "1901.19",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0021",
                                        "ppm": "0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "46",
                                "monoisotopic_mass": "1175.6255",
                                "monoisotopic_mz": "588.8200",
                                "intensity": "793.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "47",
                                "monoisotopic_mass": "2003.0993",
                                "monoisotopic_mz": "668.7070",
                                "intensity": "931.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "48",
                                "monoisotopic_mass": "750.4649",
                                "monoisotopic_mz": "751.4722",
                                "intensity": "547.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "49",
                                "monoisotopic_mass": "1240.6829",
                                "monoisotopic_mz": "1241.6902",
                                "intensity": "397.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "50",
                                "monoisotopic_mass": "1339.8136",
                                "monoisotopic_mz": "670.9141",
                                "intensity": "1154.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "51",
                                "monoisotopic_mass": "469.2779",
                                "monoisotopic_mz": "470.2851",
                                "intensity": "1036.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "52",
                                "monoisotopic_mass": "651.3457",
                                "monoisotopic_mz": "652.3530",
                                "intensity": "658.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "53",
                                "monoisotopic_mass": "2623.2881",
                                "monoisotopic_mz": "875.4366",
                                "intensity": "1195.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "54",
                                "monoisotopic_mass": "3201.6082",
                                "monoisotopic_mz": "1068.2100",
                                "intensity": "2527.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "55",
                                "monoisotopic_mass": "2947.4883",
                                "monoisotopic_mz": "737.8793",
                                "intensity": "1361.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "56",
                                "monoisotopic_mass": "2437.2192",
                                "monoisotopic_mz": "813.4137",
                                "intensity": "2151.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "57",
                                "monoisotopic_mass": "4823.4126",
                                "monoisotopic_mz": "1206.8604",
                                "intensity": "1611.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "58",
                                "monoisotopic_mass": "3331.7098",
                                "monoisotopic_mz": "1111.5772",
                                "intensity": "3687.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "59",
                                "monoisotopic_mass": "1535.7953",
                                "monoisotopic_mz": "768.9049",
                                "intensity": "1291.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "60",
                                "monoisotopic_mass": "2891.7817",
                                "monoisotopic_mz": "723.9527",
                                "intensity": "1307.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "61",
                                "monoisotopic_mass": "3246.6224",
                                "monoisotopic_mz": "812.6629",
                                "intensity": "2348.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "62",
                                "monoisotopic_mass": "3617.9205",
                                "monoisotopic_mz": "1206.9808",
                                "intensity": "572.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "63",
                                "monoisotopic_mass": "5036.5269",
                                "monoisotopic_mz": "840.4284",
                                "intensity": "2286.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "64",
                                "monoisotopic_mass": "3933.0103",
                                "monoisotopic_mz": "984.2599",
                                "intensity": "2457.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "65",
                                "monoisotopic_mass": "3670.9204",
                                "monoisotopic_mz": "918.7374",
                                "intensity": "686.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "66",
                                "monoisotopic_mass": "4697.9123",
                                "monoisotopic_mz": "783.9927",
                                "intensity": "1294.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "67",
                                "monoisotopic_mass": "4223.4635",
                                "monoisotopic_mz": "704.9179",
                                "intensity": "858.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "68",
                                "monoisotopic_mass": "4540.9097",
                                "monoisotopic_mz": "909.1892",
                                "intensity": "1941.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "69",
                                "monoisotopic_mass": "4335.0982",
                                "monoisotopic_mz": "723.5236",
                                "intensity": "665.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "70",
                                "monoisotopic_mass": "1834.8979",
                                "monoisotopic_mz": "918.4562",
                                "intensity": "4645.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "236",
                                "peak_id": "71",
                                "monoisotopic_mass": "4555.3515",
                                "monoisotopic_mz": "760.2325",
                                "intensity": "546.65",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "236",
                                        "peak_id": "34",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "236",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "236",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "236",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "236",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "236",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "236",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "236",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "236",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "spec_id": "236",
                                            "peak_id": "23",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "236",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "236",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "236",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "236",
                                        "peak_id": "22",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "236",
                                        "peak_id": "23",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "236",
                                        "peak_id": "45",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "236",
                                        "peak_id": "33",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "236",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "spec_id": "236",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "101",
                "p_value": "2.26e-10",
                "e_value": "2.26e-10",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "591",
                        "ms1_scans": "867",
                        "ids": "276",
                        "scans": "869",
                        "precursor_mono_mass": "5453.8053",
                        "precursor_charge": "6",
                        "precursor_mz": "909.9748",
                        "feature_inte": "7.9691e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "276",
                                "peak_id": "0",
                                "monoisotopic_mass": "1780.8207",
                                "monoisotopic_mz": "1781.8279",
                                "intensity": "1131.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "1",
                                "monoisotopic_mass": "1507.7387",
                                "monoisotopic_mz": "1508.7460",
                                "intensity": "1031.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "2",
                                "monoisotopic_mass": "3488.8059",
                                "monoisotopic_mz": "1163.9426",
                                "intensity": "4119.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0146",
                                        "ppm": "4.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "3",
                                "monoisotopic_mass": "1946.9352",
                                "monoisotopic_mz": "974.4749",
                                "intensity": "3235.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "4",
                                "monoisotopic_mass": "1001.4892",
                                "monoisotopic_mz": "1002.4965",
                                "intensity": "1500.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "5",
                                "monoisotopic_mass": "1863.8960",
                                "monoisotopic_mz": "932.9553",
                                "intensity": "10228.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0097",
                                        "ppm": "5.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "6",
                                "monoisotopic_mass": "1395.7676",
                                "monoisotopic_mz": "1396.7749",
                                "intensity": "979.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "7",
                                "monoisotopic_mass": "3247.6252",
                                "monoisotopic_mz": "1083.5490",
                                "intensity": "4760.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0129",
                                        "ppm": "3.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "8",
                                "monoisotopic_mass": "1460.7455",
                                "monoisotopic_mz": "1461.7528",
                                "intensity": "768.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "9",
                                "monoisotopic_mass": "907.4736",
                                "monoisotopic_mz": "908.4808",
                                "intensity": "3955.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "10",
                                "monoisotopic_mass": "1677.8297",
                                "monoisotopic_mz": "839.9221",
                                "intensity": "2698.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0074",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "11",
                                "monoisotopic_mass": "1563.7865",
                                "monoisotopic_mz": "782.9005",
                                "intensity": "4790.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0071",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "12",
                                "monoisotopic_mass": "1267.6795",
                                "monoisotopic_mz": "1268.6868",
                                "intensity": "1159.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "13",
                                "monoisotopic_mass": "3332.7122",
                                "monoisotopic_mz": "1111.9113",
                                "intensity": "2622.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "14",
                                "monoisotopic_mass": "2093.0414",
                                "monoisotopic_mz": "1047.5280",
                                "intensity": "2770.86",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0124",
                                        "ppm": "5.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "15",
                                "monoisotopic_mass": "1434.7435",
                                "monoisotopic_mz": "718.3790",
                                "intensity": "16144.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0067",
                                        "ppm": "4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "16",
                                "monoisotopic_mass": "1734.8523",
                                "monoisotopic_mz": "868.4334",
                                "intensity": "3836.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0085",
                                        "ppm": "4.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "17",
                                "monoisotopic_mass": "3360.7156",
                                "monoisotopic_mz": "1121.2458",
                                "intensity": "4367.42",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0193",
                                        "ppm": "5.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "18",
                                "monoisotopic_mass": "2194.0856",
                                "monoisotopic_mz": "732.3691",
                                "intensity": "2219.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0089",
                                        "ppm": "4.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "19",
                                "monoisotopic_mass": "3219.6280",
                                "monoisotopic_mz": "1074.2166",
                                "intensity": "4094.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "20",
                                "monoisotopic_mass": "1706.8557",
                                "monoisotopic_mz": "854.4351",
                                "intensity": "1570.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "21",
                                "monoisotopic_mass": "1220.6455",
                                "monoisotopic_mz": "611.3300",
                                "intensity": "1245.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0040",
                                        "ppm": "3.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "22",
                                "monoisotopic_mass": "1154.5871",
                                "monoisotopic_mz": "1155.5944",
                                "intensity": "1294.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "23",
                                "monoisotopic_mass": "1417.7158",
                                "monoisotopic_mz": "709.8652",
                                "intensity": "1972.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "24",
                                "monoisotopic_mass": "744.3689",
                                "monoisotopic_mz": "745.3762",
                                "intensity": "755.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "25",
                                "monoisotopic_mass": "1919.9099",
                                "monoisotopic_mz": "960.9622",
                                "intensity": "1972.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "26",
                                "monoisotopic_mass": "1291.7213",
                                "monoisotopic_mz": "646.8679",
                                "intensity": "1706.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "27",
                                "monoisotopic_mass": "1835.8992",
                                "monoisotopic_mz": "918.9569",
                                "intensity": "3320.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "28",
                                "monoisotopic_mass": "1210.6014",
                                "monoisotopic_mz": "1211.6086",
                                "intensity": "877.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "29",
                                "monoisotopic_mass": "3148.5516",
                                "monoisotopic_mz": "1050.5245",
                                "intensity": "2910.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0077",
                                        "ppm": "2.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "30",
                                "monoisotopic_mass": "1319.7155",
                                "monoisotopic_mz": "660.8651",
                                "intensity": "2354.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0057",
                                        "ppm": "4.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "31",
                                "monoisotopic_mass": "1192.6524",
                                "monoisotopic_mz": "597.3335",
                                "intensity": "1718.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "32",
                                "monoisotopic_mass": "1981.9681",
                                "monoisotopic_mz": "991.9913",
                                "intensity": "1874.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "33",
                                "monoisotopic_mass": "1780.8302",
                                "monoisotopic_mz": "891.4224",
                                "intensity": "1233.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "34",
                                "monoisotopic_mass": "3360.6995",
                                "monoisotopic_mz": "841.1821",
                                "intensity": "453.67",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0031",
                                        "ppm": "0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "35",
                                "monoisotopic_mass": "1580.8159",
                                "monoisotopic_mz": "791.4152",
                                "intensity": "1268.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "36",
                                "monoisotopic_mass": "3377.7477",
                                "monoisotopic_mz": "1126.9232",
                                "intensity": "1417.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "37",
                                "monoisotopic_mass": "1336.7413",
                                "monoisotopic_mz": "669.3779",
                                "intensity": "938.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "38",
                                "monoisotopic_mass": "1371.5079",
                                "monoisotopic_mz": "686.7612",
                                "intensity": "311.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "39",
                                "monoisotopic_mass": "1508.7349",
                                "monoisotopic_mz": "755.3747",
                                "intensity": "1134.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "40",
                                "monoisotopic_mass": "514.2768",
                                "monoisotopic_mz": "515.2841",
                                "intensity": "948.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "41",
                                "monoisotopic_mass": "2133.0483",
                                "monoisotopic_mz": "712.0234",
                                "intensity": "1433.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "42",
                                "monoisotopic_mass": "888.4049",
                                "monoisotopic_mz": "889.4122",
                                "intensity": "1547.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "43",
                                "monoisotopic_mass": "2176.0814",
                                "monoisotopic_mz": "726.3677",
                                "intensity": "459.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "44",
                                "monoisotopic_mass": "4063.0514",
                                "monoisotopic_mz": "1016.7701",
                                "intensity": "1205.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0180",
                                        "ppm": "4.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "45",
                                "monoisotopic_mass": "1064.5386",
                                "monoisotopic_mz": "1065.5459",
                                "intensity": "315.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "46",
                                "monoisotopic_mass": "454.2191",
                                "monoisotopic_mz": "455.2264",
                                "intensity": "564.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "47",
                                "monoisotopic_mass": "422.1928",
                                "monoisotopic_mz": "423.2001",
                                "intensity": "606.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "48",
                                "monoisotopic_mass": "3917.9885",
                                "monoisotopic_mz": "980.5044",
                                "intensity": "525.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "49",
                                "monoisotopic_mass": "1166.6241",
                                "monoisotopic_mz": "1167.6313",
                                "intensity": "351.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "50",
                                "monoisotopic_mass": "1491.7780",
                                "monoisotopic_mz": "746.8963",
                                "intensity": "254.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "51",
                                "monoisotopic_mass": "1434.7258",
                                "monoisotopic_mz": "1435.7330",
                                "intensity": "278.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0110",
                                        "ppm": "-7.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "52",
                                "monoisotopic_mass": "3131.5389",
                                "monoisotopic_mz": "1044.8536",
                                "intensity": "1475.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "53",
                                "monoisotopic_mass": "5244.9677",
                                "monoisotopic_mz": "1312.2492",
                                "intensity": "433.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "54",
                                "monoisotopic_mass": "1334.6510",
                                "monoisotopic_mz": "1335.6583",
                                "intensity": "279.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "55",
                                "monoisotopic_mass": "3916.9874",
                                "monoisotopic_mz": "1306.6697",
                                "intensity": "491.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "56",
                                "monoisotopic_mass": "4582.0278",
                                "monoisotopic_mz": "764.6786",
                                "intensity": "501.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "57",
                                "monoisotopic_mass": "3934.0129",
                                "monoisotopic_mz": "984.5105",
                                "intensity": "541.33",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0221",
                                        "ppm": "5.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "58",
                                "monoisotopic_mass": "1963.9418",
                                "monoisotopic_mz": "982.9782",
                                "intensity": "1836.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "59",
                                "monoisotopic_mass": "3414.1197",
                                "monoisotopic_mz": "854.5372",
                                "intensity": "469.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "60",
                                "monoisotopic_mass": "2158.0661",
                                "monoisotopic_mz": "720.3627",
                                "intensity": "1129.90",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "10",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "276",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "276",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "276",
                                            "peak_id": "51",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "276",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
               