prsm_data =
{
    "protein_list": {
        "proteins": {
            "protein": [
                {
                    "sequence_id": "0",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "0",
                        "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                        "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                        "proteoform_id": "0",
                        "prsm_number": "4",
                        "prsm": [
                            {
                                "prsm_id": "120",
                                "p_value": "1.74e-41",
                                "e_value": "1.74e-41",
                                "fdr": "0",
                                "matched_fragment_number": "49",
                                "matched_peak_number": "52"
                            },
                            {
                                "prsm_id": "103",
                                "p_value": "4.66e-37",
                                "e_value": "4.66e-37",
                                "fdr": "0",
                                "matched_fragment_number": "43",
                                "matched_peak_number": "46"
                            },
                            {
                                "prsm_id": "139",
                                "p_value": "5.32e-30",
                                "e_value": "5.32e-30",
                                "fdr": "0",
                                "matched_fragment_number": "40",
                                "matched_peak_number": "42"
                            },
                            {
                                "prsm_id": "80",
                                "p_value": "4.00e-13",
                                "e_value": "4.00e-13",
                                "fdr": "0",
                                "matched_fragment_number": "19",
                                "matched_peak_number": "19"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "1",
                    "sequence_name": "sp|P0AB61|YCIN_ECOLI",
                    "sequence_description": "Protein YciN OS=Escherichia coli (strain K12) OX=83333 GN=yciN PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "1",
                        "sequence_name": "sp|P0AB61|YCIN_ECOLI",
                        "sequence_description": "Protein YciN OS=Escherichia coli (strain K12) OX=83333 GN=yciN PE=1 SV=1",
                        "proteoform_id": "1",
                        "prsm_number": "11",
                        "prsm": [
                            {
                                "prsm_id": "131",
                                "p_value": "2.71e-41",
                                "e_value": "2.71e-41",
                                "fdr": "0",
                                "matched_fragment_number": "50",
                                "matched_peak_number": "61"
                            },
                            {
                                "prsm_id": "150",
                                "p_value": "7.25e-35",
                                "e_value": "7.25e-35",
                                "fdr": "0",
                                "matched_fragment_number": "43",
                                "matched_peak_number": "46"
                            },
                            {
                                "prsm_id": "133",
                                "p_value": "4.51e-34",
                                "e_value": "4.51e-34",
                                "fdr": "0",
                                "matched_fragment_number": "59",
                                "matched_peak_number": "66"
                            },
                            {
                                "prsm_id": "113",
                                "p_value": "3.40e-30",
                                "e_value": "3.40e-30",
                                "fdr": "0",
                                "matched_fragment_number": "38",
                                "matched_peak_number": "39"
                            },
                            {
                                "prsm_id": "117",
                                "p_value": "7.33e-28",
                                "e_value": "7.33e-28",
                                "fdr": "0",
                                "matched_fragment_number": "33",
                                "matched_peak_number": "35"
                            },
                            {
                                "prsm_id": "135",
                                "p_value": "4.48e-27",
                                "e_value": "4.48e-27",
                                "fdr": "0",
                                "matched_fragment_number": "36",
                                "matched_peak_number": "46"
                            },
                            {
                                "prsm_id": "152",
                                "p_value": "8.80e-26",
                                "e_value": "8.80e-26",
                                "fdr": "0",
                                "matched_fragment_number": "41",
                                "matched_peak_number": "42"
                            },
                            {
                                "prsm_id": "114",
                                "p_value": "3.97e-24",
                                "e_value": "3.97e-24",
                                "fdr": "0",
                                "matched_fragment_number": "39",
                                "matched_peak_number": "40"
                            },
                            {
                                "prsm_id": "119",
                                "p_value": "1.03e-17",
                                "e_value": "1.03e-17",
                                "fdr": "0",
                                "matched_fragment_number": "24",
                                "matched_peak_number": "30"
                            },
                            {
                                "prsm_id": "138",
                                "p_value": "4.47e-15",
                                "e_value": "4.47e-15",
                                "fdr": "0",
                                "matched_fragment_number": "23",
                                "matched_peak_number": "31"
                            },
                            {
                                "prsm_id": "137",
                                "p_value": "9.54e-14",
                                "e_value": "9.54e-14",
                                "fdr": "0",
                                "matched_fragment_number": "18",
                                "matched_peak_number": "21"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "2",
                    "sequence_name": "sp|P76402|YEGP_ECOLI",
                    "sequence_description": "UPF0339 protein YegP OS=Escherichia coli (strain K12) OX=83333 GN=yegP PE=1 SV=2",
                    "compatible_proteoform_number": "3",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "2",
                            "sequence_name": "sp|P76402|YEGP_ECOLI",
                            "sequence_description": "UPF0339 protein YegP OS=Escherichia coli (strain K12) OX=83333 GN=yegP PE=1 SV=2",
                            "proteoform_id": "2",
                            "prsm_number": "3",
                            "prsm": [
                                {
                                    "prsm_id": "2",
                                    "p_value": "9.52e-40",
                                    "e_value": "9.52e-40",
                                    "fdr": "0",
                                    "matched_fragment_number": "54",
                                    "matched_peak_number": "55"
                                },
                                {
                                    "prsm_id": "4",
                                    "p_value": "5.15e-15",
                                    "e_value": "5.16e-15",
                                    "fdr": "0",
                                    "matched_fragment_number": "20",
                                    "matched_peak_number": "20"
                                },
                                {
                                    "prsm_id": "0",
                                    "p_value": "7.81e-13",
                                    "e_value": "7.81e-13",
                                    "fdr": "0",
                                    "matched_fragment_number": "15",
                                    "matched_peak_number": "15"
                                }
                            ]
                        },
                        {
                            "sequence_id": "2",
                            "sequence_name": "sp|P76402|YEGP_ECOLI",
                            "sequence_description": "UPF0339 protein YegP OS=Escherichia coli (strain K12) OX=83333 GN=yegP PE=1 SV=2",
                            "proteoform_id": "28",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "1",
                                "p_value": "1.55e-11",
                                "e_value": "1.55e-11",
                                "fdr": "0",
                                "matched_fragment_number": "18",
                                "matched_peak_number": "19"
                            }
                        },
                        {
                            "sequence_id": "2",
                            "sequence_name": "sp|P76402|YEGP_ECOLI",
                            "sequence_description": "UPF0339 protein YegP OS=Escherichia coli (strain K12) OX=83333 GN=yegP PE=1 SV=2",
                            "proteoform_id": "46",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "3",
                                "p_value": "0.03",
                                "e_value": "0.03",
                                "fdr": "0",
                                "matched_fragment_number": "5",
                                "matched_peak_number": "5"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "3",
                    "sequence_name": "sp|P0AG55|RL6_ECOLI",
                    "sequence_description": "50S ribosomal protein L6 OS=Escherichia coli (strain K12) OX=83333 GN=rplF PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "3",
                        "sequence_name": "sp|P0AG55|RL6_ECOLI",
                        "sequence_description": "50S ribosomal protein L6 OS=Escherichia coli (strain K12) OX=83333 GN=rplF PE=1 SV=2",
                        "proteoform_id": "3",
                        "prsm_number": "19",
                        "prsm": [
                            {
                                "prsm_id": "28",
                                "p_value": "3.12e-33",
                                "e_value": "3.12e-33",
                                "fdr": "0",
                                "matched_fragment_number": "48",
                                "matched_peak_number": "60"
                            },
                            {
                                "prsm_id": "25",
                                "p_value": "1.17e-28",
                                "e_value": "1.17e-28",
                                "fdr": "0",
                                "matched_fragment_number": "46",
                                "matched_peak_number": "57"
                            },
                            {
                                "prsm_id": "50",
                                "p_value": "5.54e-27",
                                "e_value": "5.54e-27",
                                "fdr": "0",
                                "matched_fragment_number": "37",
                                "matched_peak_number": "48"
                            },
                            {
                                "prsm_id": "47",
                                "p_value": "1.01e-25",
                                "e_value": "1.01e-25",
                                "fdr": "0",
                                "matched_fragment_number": "47",
                                "matched_peak_number": "59"
                            },
                            {
                                "prsm_id": "8",
                                "p_value": "4.76e-22",
                                "e_value": "4.76e-22",
                                "fdr": "0",
                                "matched_fragment_number": "29",
                                "matched_peak_number": "35"
                            },
                            {
                                "prsm_id": "34",
                                "p_value": "1.31e-15",
                                "e_value": "1.31e-15",
                                "fdr": "0",
                                "matched_fragment_number": "20",
                                "matched_peak_number": "24"
                            },
                            {
                                "prsm_id": "55",
                                "p_value": "1.77e-12",
                                "e_value": "1.77e-12",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "17"
                            },
                            {
                                "prsm_id": "36",
                                "p_value": "7.69e-11",
                                "e_value": "7.69e-11",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "16"
                            },
                            {
                                "prsm_id": "15",
                                "p_value": "4.78e-10",
                                "e_value": "4.78e-10",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "13"
                            },
                            {
                                "prsm_id": "59",
                                "p_value": "3.24e-09",
                                "e_value": "3.24e-09",
                                "fdr": "0",
                                "matched_fragment_number": "11",
                                "matched_peak_number": "12"
                            },
                            {
                                "prsm_id": "56",
                                "p_value": "4.07e-09",
                                "e_value": "4.07e-09",
                                "fdr": "0",
                                "matched_fragment_number": "11",
                                "matched_peak_number": "12"
                            },
                            {
                                "prsm_id": "16",
                                "p_value": "1.06e-05",
                                "e_value": "1.06e-05",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "11"
                            },
                            {
                                "prsm_id": "24",
                                "p_value": "4.53e-05",
                                "e_value": "4.53e-05",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "10"
                            },
                            {
                                "prsm_id": "12",
                                "p_value": "4.77e-05",
                                "e_value": "4.77e-05",
                                "fdr": "0",
                                "matched_fragment_number": "8",
                                "matched_peak_number": "9"
                            },
                            {
                                "prsm_id": "38",
                                "p_value": "1.23e-04",
                                "e_value": "1.23e-04",
                                "fdr": "0",
                                "matched_fragment_number": "8",
                                "matched_peak_number": "8"
                            },
                            {
                                "prsm_id": "7",
                                "p_value": "1.50e-04",
                                "e_value": "1.50e-04",
                                "fdr": "0",
                                "matched_fragment_number": "7",
                                "matched_peak_number": "8"
                            },
                            {
                                "prsm_id": "17",
                                "p_value": "5.49e-04",
                                "e_value": "5.49e-04",
                                "fdr": "0",
                                "matched_fragment_number": "7",
                                "matched_peak_number": "8"
                            },
                            {
                                "prsm_id": "9",
                                "p_value": "2.32e-03",
                                "e_value": "2.33e-03",
                                "fdr": "0",
                                "matched_fragment_number": "5",
                                "matched_peak_number": "6"
                            },
                            {
                                "prsm_id": "42",
                                "p_value": "3.69e-03",
                                "e_value": "3.70e-03",
                                "fdr": "0",
                                "matched_fragment_number": "6",
                                "matched_peak_number": "6"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "4",
                    "sequence_name": "sp|P68206|YJBJ_ECOLI",
                    "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "4",
                        "sequence_name": "sp|P68206|YJBJ_ECOLI",
                        "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
                        "proteoform_id": "4",
                        "prsm_number": "3",
                        "prsm": [
                            {
                                "prsm_id": "93",
                                "p_value": "1.68e-30",
                                "e_value": "1.68e-30",
                                "fdr": "0",
                                "matched_fragment_number": "45",
                                "matched_peak_number": "47"
                            },
                            {
                                "prsm_id": "72",
                                "p_value": "8.44e-18",
                                "e_value": "8.44e-18",
                                "fdr": "0",
                                "matched_fragment_number": "21",
                                "matched_peak_number": "21"
                            },
                            {
                                "prsm_id": "99",
                                "p_value": "1.95e-12",
                                "e_value": "1.95e-12",
                                "fdr": "0",
                                "matched_fragment_number": "16",
                                "matched_peak_number": "17"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "5",
                    "sequence_name": "sp|P0A7L0|RL1_ECOLI",
                    "sequence_description": "50S ribosomal protein L1 OS=Escherichia coli (strain K12) OX=83333 GN=rplA PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "5",
                        "sequence_name": "sp|P0A7L0|RL1_ECOLI",
                        "sequence_description": "50S ribosomal protein L1 OS=Escherichia coli (strain K12) OX=83333 GN=rplA PE=1 SV=2",
                        "proteoform_id": "5",
                        "prsm_number": "5",
                        "prsm": [
                            {
                                "prsm_id": "32",
                                "p_value": "1.92e-30",
                                "e_value": "1.92e-30",
                                "fdr": "0",
                                "matched_fragment_number": "52",
                                "matched_peak_number": "61"
                            },
                            {
                                "prsm_id": "11",
                                "p_value": "3.03e-25",
                                "e_value": "3.03e-25",
                                "fdr": "0",
                                "matched_fragment_number": "46",
                                "matched_peak_number": "53"
                            },
                            {
                                "prsm_id": "6",
                                "p_value": "1.61e-12",
                                "e_value": "1.61e-12",
                                "fdr": "0",
                                "matched_fragment_number": "20",
                                "matched_peak_number": "22"
                            },
                            {
                                "prsm_id": "22",
                                "p_value": "3.84e-06",
                                "e_value": "3.84e-06",
                                "fdr": "0",
                                "matched_fragment_number": "13",
                                "matched_peak_number": "13"
                            },
                            {
                                "prsm_id": "14",
                                "p_value": "2.54e-05",
                                "e_value": "2.54e-05",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "10"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "6",
                    "sequence_name": "sp|P0ADU5|YGIW_ECOLI",
                    "sequence_description": "Protein YgiW OS=Escherichia coli (strain K12) OX=83333 GN=ygiW PE=1 SV=1",
                    "compatible_proteoform_number": "2",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "6",
                            "sequence_name": "sp|P0ADU5|YGIW_ECOLI",
                            "sequence_description": "Protein YgiW OS=Escherichia coli (strain K12) OX=83333 GN=ygiW PE=1 SV=1",
                            "proteoform_id": "6",
                            "prsm_number": "7",
                            "prsm": [
                                {
                                    "prsm_id": "105",
                                    "p_value": "4.65e-27",
                                    "e_value": "4.65e-27",
                                    "fdr": "0",
                                    "matched_fragment_number": "47",
                                    "matched_peak_number": "54"
                                },
                                {
                                    "prsm_id": "122",
                                    "p_value": "4.35e-24",
                                    "e_value": "4.35e-24",
                                    "fdr": "0",
                                    "matched_fragment_number": "39",
                                    "matched_peak_number": "48"
                                },
                                {
                                    "prsm_id": "141",
                                    "p_value": "4.53e-22",
                                    "e_value": "4.53e-22",
                                    "fdr": "0",
                                    "matched_fragment_number": "34",
                                    "matched_peak_number": "38"
                                },
                                {
                                    "prsm_id": "82",
                                    "p_value": "3.85e-21",
                                    "e_value": "3.85e-21",
                                    "fdr": "0",
                                    "matched_fragment_number": "39",
                                    "matched_peak_number": "47"
                                },
                                {
                                    "prsm_id": "62",
                                    "p_value": "5.11e-20",
                                    "e_value": "5.11e-20",
                                    "fdr": "0",
                                    "matched_fragment_number": "36",
                                    "matched_peak_number": "41"
                                },
                                {
                                    "prsm_id": "97",
                                    "p_value": "1.48e-12",
                                    "e_value": "1.48e-12",
                                    "fdr": "0",
                                    "matched_fragment_number": "23",
                                    "matched_peak_number": "23"
                                },
                                {
                                    "prsm_id": "74",
                                    "p_value": "1.70e-08",
                                    "e_value": "1.70e-08",
                                    "fdr": "0",
                                    "matched_fragment_number": "18",
                                    "matched_peak_number": "18"
                                }
                            ]
                        },
                        {
                            "sequence_id": "6",
                            "sequence_name": "sp|P0ADU5|YGIW_ECOLI",
                            "sequence_description": "Protein YgiW OS=Escherichia coli (strain K12) OX=83333 GN=ygiW PE=1 SV=1",
                            "proteoform_id": "20",
                            "prsm_number": "3",
                            "prsm": [
                                {
                                    "prsm_id": "121",
                                    "p_value": "5.43e-15",
                                    "e_value": "5.43e-15",
                                    "fdr": "0",
                                    "matched_fragment_number": "21",
                                    "matched_peak_number": "21"
                                },
                                {
                                    "prsm_id": "104",
                                    "p_value": "7.14e-12",
                                    "e_value": "7.14e-12",
                                    "fdr": "0",
                                    "matched_fragment_number": "20",
                                    "matched_peak_number": "20"
                                },
                                {
                                    "prsm_id": "79",
                                    "p_value": "5.46e-09",
                                    "e_value": "5.46e-09",
                                    "fdr": "0",
                                    "matched_fragment_number": "17",
                                    "matched_peak_number": "18"
                                }
                            ]
                        }
                    ]
                },
                {
                    "sequence_id": "7",
                    "sequence_name": "sp|P0AFX0|HPF_ECOLI",
                    "sequence_description": "Ribosome hibernation promoting factor OS=Escherichia coli (strain K12) OX=83333 GN=hpf PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "7",
                        "sequence_name": "sp|P0AFX0|HPF_ECOLI",
                        "sequence_description": "Ribosome hibernation promoting factor OS=Escherichia coli (strain K12) OX=83333 GN=hpf PE=1 SV=1",
                        "proteoform_id": "7",
                        "prsm_number": "3",
                        "prsm": [
                            {
                                "prsm_id": "53",
                                "p_value": "2.15e-26",
                                "e_value": "2.15e-26",
                                "fdr": "0",
                                "matched_fragment_number": "42",
                                "matched_peak_number": "48"
                            },
                            {
                                "prsm_id": "33",
                                "p_value": "6.04e-13",
                                "e_value": "6.04e-13",
                                "fdr": "0",
                                "matched_fragment_number": "15",
                                "matched_peak_number": "16"
                            },
                            {
                                "prsm_id": "39",
                                "p_value": "1.91e-10",
                                "e_value": "1.91e-10",
                                "fdr": "0",
                                "matched_fragment_number": "12",
                                "matched_peak_number": "12"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "8",
                        "sequence_name": "sp|P61175|RL22_ECOLI",
                        "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                        "proteoform_id": "8",
                        "prsm_number": "5",
                        "prsm": [
                            {
                                "prsm_id": "87",
                                "p_value": "1.07e-25",
                                "e_value": "1.07e-25",
                                "fdr": "0",
                                "matched_fragment_number": "27",
                                "matched_peak_number": "32"
                            },
                            {
                                "prsm_id": "65",
                                "p_value": "1.77e-24",
                                "e_value": "1.77e-24",
                                "fdr": "0",
                                "matched_fragment_number": "27",
                                "matched_peak_number": "29"
                            },
                            {
                                "prsm_id": "109",
                                "p_value": "7.46e-12",
                                "e_value": "7.46e-12",
                                "fdr": "0",
                                "matched_fragment_number": "15",
                                "matched_peak_number": "15"
                            },
                            {
                                "prsm_id": "81",
                                "p_value": "1.31e-11",
                                "e_value": "1.31e-11",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "15"
                            },
                            {
                                "prsm_id": "70",
                                "p_value": "9.35e-11",
                                "e_value": "9.35e-11",
                                "fdr": "0",
                                "matched_fragment_number": "12",
                                "matched_peak_number": "12"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "9",
                    "sequence_name": "sp|P0A972|CSPE_ECOLI",
                    "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_id": "9",
                        "prsm_number": "5",
                        "prsm": [
                            {
                                "prsm_id": "52",
                                "p_value": "1.88e-25",
                                "e_value": "1.88e-25",
                                "fdr": "0",
                                "matched_fragment_number": "32",
                                "matched_peak_number": "39"
                            },
                            {
                                "prsm_id": "31",
                                "p_value": "3.98e-21",
                                "e_value": "3.98e-21",
                                "fdr": "0",
                                "matched_fragment_number": "27",
                                "matched_peak_number": "34"
                            },
                            {
                                "prsm_id": "58",
                                "p_value": "5.43e-08",
                                "e_value": "5.43e-08",
                                "fdr": "0",
                                "matched_fragment_number": "8",
                                "matched_peak_number": "8"
                            },
                            {
                                "prsm_id": "41",
                                "p_value": "1.05e-07",
                                "e_value": "1.05e-07",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "10"
                            },
                            {
                                "prsm_id": "130",
                                "p_value": "4.73e-07",
                                "e_value": "4.73e-07",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "9"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "10",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "10",
                        "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                        "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                        "proteoform_id": "10",
                        "prsm_number": "9",
                        "prsm": [
                            {
                                "prsm_id": "54",
                                "p_value": "1.11e-24",
                                "e_value": "1.11e-24",
                                "fdr": "0",
                                "matched_fragment_number": "34",
                                "matched_peak_number": "42"
                            },
                            {
                                "prsm_id": "94",
                                "p_value": "6.25e-23",
                                "e_value": "6.25e-23",
                                "fdr": "0",
                                "matched_fragment_number": "27",
                                "matched_peak_number": "31"
                            },
                            {
                                "prsm_id": "37",
                                "p_value": "1.10e-17",
                                "e_value": "1.10e-17",
                                "fdr": "0",
                                "matched_fragment_number": "26",
                                "matched_peak_number": "32"
                            },
                            {
                                "prsm_id": "71",
                                "p_value": "1.23e-17",
                                "e_value": "1.23e-17",
                                "fdr": "0",
                                "matched_fragment_number": "24",
                                "matched_peak_number": "24"
                            },
                            {
                                "prsm_id": "112",
                                "p_value": "1.02e-15",
                                "e_value": "1.02e-15",
                                "fdr": "0",
                                "matched_fragment_number": "21",
                                "matched_peak_number": "20"
                            },
                            {
                                "prsm_id": "132",
                                "p_value": "5.61e-13",
                                "e_value": "5.61e-13",
                                "fdr": "0",
                                "matched_fragment_number": "18",
                                "matched_peak_number": "17"
                            },
                            {
                                "prsm_id": "73",
                                "p_value": "8.53e-13",
                                "e_value": "8.53e-13",
                                "fdr": "0",
                                "matched_fragment_number": "19",
                                "matched_peak_number": "18"
                            },
                            {
                                "prsm_id": "101",
                                "p_value": "2.26e-10",
                                "e_value": "2.26e-10",
                                "fdr": "0",
                                "matched_fragment_number": "15",
                                "matched_peak_number": "17"
                            },
                            {
                                "prsm_id": "51",
                                "p_value": "4.93e-07",
                                "e_value": "4.93e-07",
                                "fdr": "0",
                                "matched_fragment_number": "11",
                                "matched_peak_number": "11"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "11",
                    "sequence_name": "sp|P0A8P3|FETP_ECOLI",
                    "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "11",
                        "sequence_name": "sp|P0A8P3|FETP_ECOLI",
                        "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
                        "proteoform_id": "11",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "100",
                                "p_value": "3.86e-23",
                                "e_value": "3.86e-23",
                                "fdr": "0",
                                "matched_fragment_number": "52",
                                "matched_peak_number": "55"
                            },
                            {
                                "prsm_id": "78",
                                "p_value": "2.41e-16",
                                "e_value": "2.41e-16",
                                "fdr": "0",
                                "matched_fragment_number": "38",
                                "matched_peak_number": "37"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "12",
                        "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                        "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                        "proteoform_id": "12",
                        "prsm_number": "6",
                        "prsm": [
                            {
                                "prsm_id": "98",
                                "p_value": "6.12e-23",
                                "e_value": "6.12e-23",
                                "fdr": "0",
                                "matched_fragment_number": "23",
                                "matched_peak_number": "28"
                            },
                            {
                                "prsm_id": "136",
                                "p_value": "9.41e-19",
                                "e_value": "9.41e-19",
                                "fdr": "0",
                                "matched_fragment_number": "18",
                                "matched_peak_number": "20"
                            },
                            {
                                "prsm_id": "116",
                                "p_value": "2.34e-18",
                                "e_value": "2.34e-18",
                                "fdr": "0",
                                "matched_fragment_number": "21",
                                "matched_peak_number": "23"
                            },
                            {
                                "prsm_id": "75",
                                "p_value": "7.69e-18",
                                "e_value": "7.69e-18",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "21"
                            },
                            {
                                "prsm_id": "60",
                                "p_value": "4.85e-17",
                                "e_value": "4.85e-17",
                                "fdr": "0",
                                "matched_fragment_number": "18",
                                "matched_peak_number": "25"
                            },
                            {
                                "prsm_id": "155",
                                "p_value": "2.36e-06",
                                "e_value": "2.36e-06",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "9"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "13",
                    "sequence_name": "sp|P0AD49|YFIA_ECOLI",
                    "sequence_description": "Ribosome-associated inhibitor A OS=Escherichia coli (strain K12) OX=83333 GN=raiA PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "13",
                        "sequence_name": "sp|P0AD49|YFIA_ECOLI",
                        "sequence_description": "Ribosome-associated inhibitor A OS=Escherichia coli (strain K12) OX=83333 GN=raiA PE=1 SV=2",
                        "proteoform_id": "13",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "44",
                                "p_value": "1.31e-22",
                                "e_value": "1.31e-22",
                                "fdr": "0",
                                "matched_fragment_number": "27",
                                "matched_peak_number": "30"
                            },
                            {
                                "prsm_id": "45",
                                "p_value": "2.71e-21",
                                "e_value": "2.71e-21",
                                "fdr": "0",
                                "matched_fragment_number": "29",
                                "matched_peak_number": "32"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "14",
                    "sequence_name": "sp|P0C0L2|OSMC_ECOLI",
                    "sequence_description": "Peroxiredoxin OsmC OS=Escherichia coli (strain K12) OX=83333 GN=osmC PE=1 SV=2",
                    "compatible_proteoform_number": "3",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "14",
                            "sequence_name": "sp|P0C0L2|OSMC_ECOLI",
                            "sequence_description": "Peroxiredoxin OsmC OS=Escherichia coli (strain K12) OX=83333 GN=osmC PE=1 SV=2",
                            "proteoform_id": "14",
                            "prsm_number": "2",
                            "prsm": [
                                {
                                    "prsm_id": "90",
                                    "p_value": "2.46e-21",
                                    "e_value": "2.46e-21",
                                    "fdr": "0",
                                    "matched_fragment_number": "25",
                                    "matched_peak_number": "27"
                                },
                                {
                                    "prsm_id": "68",
                                    "p_value": "1.08e-18",
                                    "e_value": "1.08e-18",
                                    "fdr": "0",
                                    "matched_fragment_number": "23",
                                    "matched_peak_number": "25"
                                }
                            ]
                        },
                        {
                            "sequence_id": "14",
                            "sequence_name": "sp|P0C0L2|OSMC_ECOLI",
                            "sequence_description": "Peroxiredoxin OsmC OS=Escherichia coli (strain K12) OX=83333 GN=osmC PE=1 SV=2",
                            "proteoform_id": "29",
                            "prsm_number": "2",
                            "prsm": [
                                {
                                    "prsm_id": "148",
                                    "p_value": "3.83e-11",
                                    "e_value": "3.83e-11",
                                    "fdr": "0",
                                    "matched_fragment_number": "12",
                                    "matched_peak_number": "12"
                                },
                                {
                                    "prsm_id": "129",
                                    "p_value": "3.57e-09",
                                    "e_value": "3.57e-09",
                                    "fdr": "0",
                                    "matched_fragment_number": "9",
                                    "matched_peak_number": "9"
                                }
                            ]
                        },
                        {
                            "sequence_id": "14",
                            "sequence_name": "sp|P0C0L2|OSMC_ECOLI",
                            "sequence_description": "Peroxiredoxin OsmC OS=Escherichia coli (strain K12) OX=83333 GN=osmC PE=1 SV=2",
                            "proteoform_id": "40",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "146",
                                "p_value": "3.01e-04",
                                "e_value": "3.01e-04",
                                "fdr": "0",
                                "matched_fragment_number": "6",
                                "matched_peak_number": "6"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "15",
                    "sequence_name": "sp|P37903|USPF_ECOLI",
                    "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                    "compatible_proteoform_number": "2",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_id": "15",
                            "prsm_number": "4",
                            "prsm": [
                                {
                                    "prsm_id": "143",
                                    "p_value": "1.26e-20",
                                    "e_value": "1.26e-20",
                                    "fdr": "0",
                                    "matched_fragment_number": "34",
                                    "matched_peak_number": "38"
                                },
                                {
                                    "prsm_id": "124",
                                    "p_value": "2.70e-13",
                                    "e_value": "2.70e-13",
                                    "fdr": "0",
                                    "matched_fragment_number": "16",
                                    "matched_peak_number": "17"
                                },
                                {
                                    "prsm_id": "145",
                                    "p_value": "2.62e-11",
                                    "e_value": "2.62e-11",
                                    "fdr": "0",
                                    "matched_fragment_number": "15",
                                    "matched_peak_number": "16"
                                },
                                {
                                    "prsm_id": "127",
                                    "p_value": "3.32e-10",
                                    "e_value": "3.32e-10",
                                    "fdr": "0",
                                    "matched_fragment_number": "9",
                                    "matched_peak_number": "9"
                                }
                            ]
                        },
                        {
                            "sequence_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_id": "47",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "142",
                                "p_value": "0.25",
                                "e_value": "0.29",
                                "fdr": "0",
                                "matched_fragment_number": "7",
                                "matched_peak_number": "7"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "16",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "16",
                        "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                        "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                        "proteoform_id": "16",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "46",
                            "p_value": "8.66e-20",
                            "e_value": "8.66e-20",
                            "fdr": "0",
                            "matched_fragment_number": "22",
                            "matched_peak_number": "24"
                        }
                    }
                },
                {
                    "sequence_id": "17",
                    "sequence_name": "sp|P0A6E6|ATPE_ECOLI",
                    "sequence_description": "ATP synthase epsilon chain OS=Escherichia coli (strain K12) OX=83333 GN=atpC PE=1 SV=2",
                    "compatible_proteoform_number": "2",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "17",
                            "sequence_name": "sp|P0A6E6|ATPE_ECOLI",
                            "sequence_description": "ATP synthase epsilon chain OS=Escherichia coli (strain K12) OX=83333 GN=atpC PE=1 SV=2",
                            "proteoform_id": "17",
                            "prsm_number": "2",
                            "prsm": [
                                {
                                    "prsm_id": "108",
                                    "p_value": "2.88e-16",
                                    "e_value": "2.88e-16",
                                    "fdr": "0",
                                    "matched_fragment_number": "19",
                                    "matched_peak_number": "19"
                                },
                                {
                                    "prsm_id": "86",
                                    "p_value": "3.68e-16",
                                    "e_value": "3.68e-16",
                                    "fdr": "0",
                                    "matched_fragment_number": "21",
                                    "matched_peak_number": "23"
                                }
                            ]
                        },
                        {
                            "sequence_id": "17",
                            "sequence_name": "sp|P0A6E6|ATPE_ECOLI",
                            "sequence_description": "ATP synthase epsilon chain OS=Escherichia coli (strain K12) OX=83333 GN=atpC PE=1 SV=2",
                            "proteoform_id": "41",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "96",
                                "p_value": "7.07e-04",
                                "e_value": "7.07e-04",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "9"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "18",
                    "sequence_name": "sp|P0A6P9|ENO_ECOLI",
                    "sequence_description": "Enolase OS=Escherichia coli (strain K12) OX=83333 GN=eno PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "18",
                        "sequence_name": "sp|P0A6P9|ENO_ECOLI",
                        "sequence_description": "Enolase OS=Escherichia coli (strain K12) OX=83333 GN=eno PE=1 SV=2",
                        "proteoform_id": "18",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "23",
                            "p_value": "2.33e-15",
                            "e_value": "2.33e-15",
                            "fdr": "0",
                            "matched_fragment_number": "18",
                            "matched_peak_number": "19"
                        }
                    }
                },
                {
                    "sequence_id": "19",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "19",
                        "sequence_name": "sp|P60438|RL3_ECOLI",
                        "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                        "proteoform_id": "19",
                        "prsm_number": "4",
                        "prsm": [
                            {
                                "prsm_id": "21",
                                "p_value": "4.12e-15",
                                "e_value": "4.12e-15",
                                "fdr": "0",
                                "matched_fragment_number": "20",
                                "matched_peak_number": "24"
                            },
                            {
                                "prsm_id": "30",
                                "p_value": "4.23e-09",
                                "e_value": "4.23e-09",
                                "fdr": "0",
                                "matched_fragment_number": "13",
                                "matched_peak_number": "14"
                            },
                            {
                                "prsm_id": "43",
                                "p_value": "1.07e-07",
                                "e_value": "1.07e-07",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "11"
                            },
                            {
                                "prsm_id": "5",
                                "p_value": "5.06e-06",
                                "e_value": "5.06e-06",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "9"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "20",
                    "sequence_name": "sp|P0AGE9|SUCD_ECOLI",
                    "sequence_description": "Succinate--CoA ligase [ADP-forming] subunit alpha OS=Escherichia coli (strain K12) OX=83333 GN=sucD PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "20",
                        "sequence_name": "sp|P0AGE9|SUCD_ECOLI",
                        "sequence_description": "Succinate--CoA ligase [ADP-forming] subunit alpha OS=Escherichia coli (strain K12) OX=83333 GN=sucD PE=1 SV=2",
                        "proteoform_id": "21",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "49",
                                "p_value": "9.05e-15",
                                "e_value": "9.05e-15",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "20"
                            },
                            {
                                "prsm_id": "27",
                                "p_value": "2.50e-10",
                                "e_value": "2.50e-10",
                                "fdr": "0",
                                "matched_fragment_number": "13",
                                "matched_peak_number": "15"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "21",
                    "sequence_name": "sp|P0A6X7|IHFA_ECOLI",
                    "sequence_description": "Integration host factor subunit alpha OS=Escherichia coli (strain K12) OX=83333 GN=ihfA PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "21",
                        "sequence_name": "sp|P0A6X7|IHFA_ECOLI",
                        "sequence_description": "Integration host factor subunit alpha OS=Escherichia coli (strain K12) OX=83333 GN=ihfA PE=1 SV=1",
                        "proteoform_id": "22",
                        "prsm_number": "13",
                        "prsm": [
                            {
                                "prsm_id": "63",
                                "p_value": "1.52e-14",
                                "e_value": "1.52e-14",
                                "fdr": "0",
                                "matched_fragment_number": "23",
                                "matched_peak_number": "25"
                            },
                            {
                                "prsm_id": "107",
                                "p_value": "6.36e-13",
                                "e_value": "6.36e-13",
                                "fdr": "0",
                                "matched_fragment_number": "19",
                                "matched_peak_number": "21"
                            },
                            {
                                "prsm_id": "106",
                                "p_value": "1.59e-12",
                                "e_value": "1.59e-12",
                                "fdr": "0",
                                "matched_fragment_number": "23",
                                "matched_peak_number": "25"
                            },
                            {
                                "prsm_id": "85",
                                "p_value": "1.63e-12",
                                "e_value": "1.63e-12",
                                "fdr": "0",
                                "matched_fragment_number": "22",
                                "matched_peak_number": "31"
                            },
                            {
                                "prsm_id": "64",
                                "p_value": "4.55e-12",
                                "e_value": "4.55e-12",
                                "fdr": "0",
                                "matched_fragment_number": "22",
                                "matched_peak_number": "31"
                            },
                            {
                                "prsm_id": "84",
                                "p_value": "6.39e-12",
                                "e_value": "6.39e-12",
                                "fdr": "0",
                                "matched_fragment_number": "23",
                                "matched_peak_number": "26"
                            },
                            {
                                "prsm_id": "123",
                                "p_value": "1.74e-09",
                                "e_value": "1.74e-09",
                                "fdr": "0",
                                "matched_fragment_number": "16",
                                "matched_peak_number": "17"
                            },
                            {
                                "prsm_id": "88",
                                "p_value": "1.18e-07",
                                "e_value": "1.18e-07",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "15"
                            },
                            {
                                "prsm_id": "128",
                                "p_value": "3.83e-06",
                                "e_value": "3.83e-06",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "11"
                            },
                            {
                                "prsm_id": "110",
                                "p_value": "7.13e-06",
                                "e_value": "7.13e-06",
                                "fdr": "0",
                                "matched_fragment_number": "12",
                                "matched_peak_number": "12"
                            },
                            {
                                "prsm_id": "66",
                                "p_value": "3.23e-05",
                                "e_value": "3.23e-05",
                                "fdr": "0",
                                "matched_fragment_number": "11",
                                "matched_peak_number": "11"
                            },
                            {
                                "prsm_id": "126",
                                "p_value": "1.45e-04",
                                "e_value": "1.45e-04",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "10"
                            },
                            {
                                "prsm_id": "77",
                                "p_value": "1.25e-03",
                                "e_value": "1.25e-03",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "10"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "22",
                    "sequence_name": "sp|P0AFH8|OSMY_ECOLI",
                    "sequence_description": "Osmotically-inducible protein Y OS=Escherichia coli (strain K12) OX=83333 GN=osmY PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "22",
                        "sequence_name": "sp|P0AFH8|OSMY_ECOLI",
                        "sequence_description": "Osmotically-inducible protein Y OS=Escherichia coli (strain K12) OX=83333 GN=osmY PE=1 SV=1",
                        "proteoform_id": "23",
                        "prsm_number": "7",
                        "prsm": [
                            {
                                "prsm_id": "61",
                                "p_value": "1.57e-14",
                                "e_value": "1.57e-14",
                                "fdr": "0",
                                "matched_fragment_number": "24",
                                "matched_peak_number": "26"
                            },
                            {
                                "prsm_id": "102",
                                "p_value": "5.27e-13",
                                "e_value": "5.27e-13",
                                "fdr": "0",
                                "matched_fragment_number": "21",
                                "matched_peak_number": "22"
                            },
                            {
                                "prsm_id": "91",
                                "p_value": "1.01e-11",
                                "e_value": "1.01e-11",
                                "fdr": "0",
                                "matched_fragment_number": "20",
                                "matched_peak_number": "21"
                            },
                            {
                                "prsm_id": "118",
                                "p_value": "1.95e-10",
                                "e_value": "1.95e-10",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "10"
                            },
                            {
                                "prsm_id": "76",
                                "p_value": "5.34e-10",
                                "e_value": "5.34e-10",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "19"
                            },
                            {
                                "prsm_id": "67",
                                "p_value": "1.58e-07",
                                "e_value": "1.58e-07",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "18"
                            },
                            {
                                "prsm_id": "69",
                                "p_value": "2.56e-07",
                                "e_value": "2.56e-07",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "17"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "23",
                    "sequence_name": "sp|P62399|RL5_ECOLI",
                    "sequence_description": "50S ribosomal protein L5 OS=Escherichia coli (strain K12) OX=83333 GN=rplE PE=1 SV=2",
                    "compatible_proteoform_number": "2",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "23",
                            "sequence_name": "sp|P62399|RL5_ECOLI",
                            "sequence_description": "50S ribosomal protein L5 OS=Escherichia coli (strain K12) OX=83333 GN=rplE PE=1 SV=2",
                            "proteoform_id": "24",
                            "prsm_number": "4",
                            "prsm": [
                                {
                                    "prsm_id": "40",
                                    "p_value": "2.47e-13",
                                    "e_value": "2.47e-13",
                                    "fdr": "0",
                                    "matched_fragment_number": "17",
                                    "matched_peak_number": "21"
                                },
                                {
                                    "prsm_id": "20",
                                    "p_value": "6.52e-11",
                                    "e_value": "6.52e-11",
                                    "fdr": "0",
                                    "matched_fragment_number": "15",
                                    "matched_peak_number": "18"
                                },
                                {
                                    "prsm_id": "18",
                                    "p_value": "1.09e-08",
                                    "e_value": "1.09e-08",
                                    "fdr": "0",
                                    "matched_fragment_number": "12",
                                    "matched_peak_number": "12"
                                },
                                {
                                    "prsm_id": "19",
                                    "p_value": "8.61e-06",
                                    "e_value": "8.61e-06",
                                    "fdr": "0",
                                    "matched_fragment_number": "10",
                                    "matched_peak_number": "10"
                                }
                            ]
                        },
                        {
                            "sequence_id": "23",
                            "sequence_name": "sp|P62399|RL5_ECOLI",
                            "sequence_description": "50S ribosomal protein L5 OS=Escherichia coli (strain K12) OX=83333 GN=rplE PE=1 SV=2",
                            "proteoform_id": "30",
                            "prsm_number": "2",
                            "prsm": [
                                {
                                    "prsm_id": "48",
                                    "p_value": "8.40e-11",
                                    "e_value": "8.40e-11",
                                    "fdr": "0",
                                    "matched_fragment_number": "16",
                                    "matched_peak_number": "21"
                                },
                                {
                                    "prsm_id": "26",
                                    "p_value": "2.31e-05",
                                    "e_value": "2.31e-05",
                                    "fdr": "0",
                                    "matched_fragment_number": "10",
                                    "matched_peak_number": "14"
                                }
                            ]
                        }
                    ]
                },
                {
                    "sequence_id": "24",
                    "sequence_name": "sp|P75694|YAHO_ECOLI",
                    "sequence_description": "Uncharacterized protein YahO OS=Escherichia coli (strain K12) OX=83333 GN=yahO PE=3 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "24",
                        "sequence_name": "sp|P75694|YAHO_ECOLI",
                        "sequence_description": "Uncharacterized protein YahO OS=Escherichia coli (strain K12) OX=83333 GN=yahO PE=3 SV=1",
                        "proteoform_id": "25",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "149",
                            "p_value": "2.10e-12",
                            "e_value": "2.10e-12",
                            "fdr": "0",
                            "matched_fragment_number": "11",
                            "matched_peak_number": "11"
                        }
                    }
                },
                {
                    "sequence_id": "25",
                    "sequence_name": "sp|P0AEG4|DSBA_ECOLI",
                    "sequence_description": "Thiol:disulfide interchange protein DsbA OS=Escherichia coli (strain K12) OX=83333 GN=dsbA PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "25",
                        "sequence_name": "sp|P0AEG4|DSBA_ECOLI",
                        "sequence_description": "Thiol:disulfide interchange protein DsbA OS=Escherichia coli (strain K12) OX=83333 GN=dsbA PE=1 SV=1",
                        "proteoform_id": "26",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "95",
                            "p_value": "2.19e-12",
                            "e_value": "2.19e-12",
                            "fdr": "0",
                            "matched_fragment_number": "13",
                            "matched_peak_number": "13"
                        }
                    }
                },
                {
                    "sequence_id": "26",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "compatible_proteoform_number": "4",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "26",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_id": "27",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "153",
                                "p_value": "7.90e-12",
                                "e_value": "7.90e-12",
                                "fdr": "0",
                                "matched_fragment_number": "19",
                                "matched_peak_number": "20"
                            }
                        },
                        {
                            "sequence_id": "26",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_id": "31",
                            "prsm_number": "2",
                            "prsm": [
                                {
                                    "prsm_id": "140",
                                    "p_value": "4.08e-10",
                                    "e_value": "4.08e-10",
                                    "fdr": "0",
                                    "matched_fragment_number": "14",
                                    "matched_peak_number": "14"
                                },
                                {
                                    "prsm_id": "154",
                                    "p_value": "3.41e-06",
                                    "e_value": "3.41e-06",
                                    "fdr": "0",
                                    "matched_fragment_number": "13",
                                    "matched_peak_number": "14"
                                }
                            ]
                        },
                        {
                            "sequence_id": "26",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_id": "37",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "151",
                                "p_value": "8.46e-06",
                                "e_value": "8.46e-06",
                                "fdr": "0",
                                "matched_fragment_number": "12",
                                "matched_peak_number": "12"
                            }
                        },
                        {
                            "sequence_id": "26",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_id": "42",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "115",
                                "p_value": "1.33e-03",
                                "e_value": "1.33e-03",
                                "fdr": "0",
                                "matched_fragment_number": "10",
                                "matched_peak_number": "10"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "27",
                    "sequence_name": "sp|P64455|YDCY_ECOLI",
                    "sequence_description": "Uncharacterized protein YdcY OS=Escherichia coli (strain K12) OX=83333 GN=ydcY PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "27",
                        "sequence_name": "sp|P64455|YDCY_ECOLI",
                        "sequence_description": "Uncharacterized protein YdcY OS=Escherichia coli (strain K12) OX=83333 GN=ydcY PE=1 SV=1",
                        "proteoform_id": "32",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "83",
                            "p_value": "1.52e-09",
                            "e_value": "1.52e-09",
                            "fdr": "0",
                            "matched_fragment_number": "13",
                            "matched_peak_number": "16"
                        }
                    }
                },
                {
                    "sequence_id": "28",
                    "sequence_name": "sp|P0A6Y8|DNAK_ECOLI",
                    "sequence_description": "Chaperone protein DnaK OS=Escherichia coli (strain K12) OX=83333 GN=dnaK PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "28",
                        "sequence_name": "sp|P0A6Y8|DNAK_ECOLI",
                        "sequence_description": "Chaperone protein DnaK OS=Escherichia coli (strain K12) OX=83333 GN=dnaK PE=1 SV=2",
                        "proteoform_id": "33",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "111",
                                "p_value": "7.66e-09",
                                "e_value": "7.66e-09",
                                "fdr": "0",
                                "matched_fragment_number": "17",
                                "matched_peak_number": "19"
                            },
                            {
                                "prsm_id": "92",
                                "p_value": "0.02",
                                "e_value": "0.02",
                                "fdr": "0",
                                "matched_fragment_number": "9",
                                "matched_peak_number": "9"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "29",
                    "sequence_name": "sp|P0A8M6|YEEX_ECOLI",
                    "sequence_description": "UPF0265 protein YeeX OS=Escherichia coli (strain K12) OX=83333 GN=yeeX PE=1 SV=1",
                    "compatible_proteoform_number": "2",
                    "compatible_proteoform": [
                        {
                            "sequence_id": "29",
                            "sequence_name": "sp|P0A8M6|YEEX_ECOLI",
                            "sequence_description": "UPF0265 protein YeeX OS=Escherichia coli (strain K12) OX=83333 GN=yeeX PE=1 SV=1",
                            "proteoform_id": "34",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "134",
                                "p_value": "9.48e-09",
                                "e_value": "9.48e-09",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "14"
                            }
                        },
                        {
                            "sequence_id": "29",
                            "sequence_name": "sp|P0A8M6|YEEX_ECOLI",
                            "sequence_description": "UPF0265 protein YeeX OS=Escherichia coli (strain K12) OX=83333 GN=yeeX PE=1 SV=1",
                            "proteoform_id": "45",
                            "prsm_number": "1",
                            "prsm": {
                                "prsm_id": "125",
                                "p_value": "3.36e-03",
                                "e_value": "3.37e-03",
                                "fdr": "0",
                                "matched_fragment_number": "14",
                                "matched_peak_number": "16"
                            }
                        }
                    ]
                },
                {
                    "sequence_id": "30",
                    "sequence_name": "sp|P0A6F9|CH10_ECOLI",
                    "sequence_description": "10 kDa chaperonin OS=Escherichia coli (strain K12) OX=83333 GN=groS PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "30",
                        "sequence_name": "sp|P0A6F9|CH10_ECOLI",
                        "sequence_description": "10 kDa chaperonin OS=Escherichia coli (strain K12) OX=83333 GN=groS PE=1 SV=1",
                        "proteoform_id": "35",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "144",
                            "p_value": "1.93e-08",
                            "e_value": "1.93e-08",
                            "fdr": "0",
                            "matched_fragment_number": "14",
                            "matched_peak_number": "16"
                        }
                    }
                },
                {
                    "sequence_id": "31",
                    "sequence_name": "sp|P0A7Z0|RPIA_ECOLI",
                    "sequence_description": "Ribose-5-phosphate isomerase A OS=Escherichia coli (strain K12) OX=83333 GN=rpiA PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "31",
                        "sequence_name": "sp|P0A7Z0|RPIA_ECOLI",
                        "sequence_description": "Ribose-5-phosphate isomerase A OS=Escherichia coli (strain K12) OX=83333 GN=rpiA PE=1 SV=1",
                        "proteoform_id": "36",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "89",
                            "p_value": "7.37e-06",
                            "e_value": "7.37e-06",
                            "fdr": "0",
                            "matched_fragment_number": "10",
                            "matched_peak_number": "12"
                        }
                    }
                },
                {
                    "sequence_id": "32",
                    "sequence_name": "sp|P0AFL3|PPIA_ECOLI",
                    "sequence_description": "Peptidyl-prolyl cis-trans isomerase A OS=Escherichia coli (strain K12) OX=83333 GN=ppiA PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "32",
                        "sequence_name": "sp|P0AFL3|PPIA_ECOLI",
                        "sequence_description": "Peptidyl-prolyl cis-trans isomerase A OS=Escherichia coli (strain K12) OX=83333 GN=ppiA PE=1 SV=1",
                        "proteoform_id": "38",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "10",
                                "p_value": "2.59e-05",
                                "e_value": "2.59e-05",
                                "fdr": "0",
                                "matched_fragment_number": "7",
                                "matched_peak_number": "7"
                            },
                            {
                                "prsm_id": "29",
                                "p_value": "8.12e-04",
                                "e_value": "8.12e-04",
                                "fdr": "0",
                                "matched_fragment_number": "5",
                                "matched_peak_number": "5"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "33",
                    "sequence_name": "sp|P56614|YMDF_ECOLI",
                    "sequence_description": "Uncharacterized protein YmdF OS=Escherichia coli (strain K12) OX=83333 GN=ymdF PE=3 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "33",
                        "sequence_name": "sp|P56614|YMDF_ECOLI",
                        "sequence_description": "Uncharacterized protein YmdF OS=Escherichia coli (strain K12) OX=83333 GN=ymdF PE=3 SV=1",
                        "proteoform_id": "39",
                        "prsm_number": "2",
                        "prsm": [
                            {
                                "prsm_id": "13",
                                "p_value": "2.76e-05",
                                "e_value": "2.76e-05",
                                "fdr": "0",
                                "matched_fragment_number": "8",
                                "matched_peak_number": "10"
                            },
                            {
                                "prsm_id": "35",
                                "p_value": "4.04e-04",
                                "e_value": "4.04e-04",
                                "fdr": "0",
                                "matched_fragment_number": "7",
                                "matched_peak_number": "9"
                            }
                        ]
                    }
                },
                {
                    "sequence_id": "34",
                    "sequence_name": "sp|P68066|GRCA_ECOLI",
                    "sequence_description": "Autonomous glycyl radical cofactor OS=Escherichia coli (strain K12) OX=83333 GN=grcA PE=1 SV=1",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "34",
                        "sequence_name": "sp|P68066|GRCA_ECOLI",
                        "sequence_description": "Autonomous glycyl radical cofactor OS=Escherichia coli (strain K12) OX=83333 GN=grcA PE=1 SV=1",
                        "proteoform_id": "43",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "147",
                            "p_value": "2.06e-03",
                            "e_value": "2.06e-03",
                            "fdr": "0",
                            "matched_fragment_number": "8",
                            "matched_peak_number": "8"
                        }
                    }
                },
                {
                    "sequence_id": "35",
                    "sequence_name": "sp|P0A8E7|YAJQ_ECOLI",
                    "sequence_description": "UPF0234 protein YajQ OS=Escherichia coli (strain K12) OX=83333 GN=yajQ PE=1 SV=2",
                    "compatible_proteoform_number": "1",
                    "compatible_proteoform": {
                        "sequence_id": "35",
                        "sequence_name": "sp|P0A8E7|YAJQ_ECOLI",
                        "sequence_description": "UPF0234 protein YajQ OS=Escherichia coli (strain K12) OX=83333 GN=yajQ PE=1 SV=2",
                        "proteoform_id": "44",
                        "prsm_number": "1",
                        "prsm": {
                            "prsm_id": "57",
                            "p_value": "2.73e-03",
                            "e_value": "2.73e-03",
                            "fdr": "0",
                            "matched_fragment_number": "7",
                            "matched_peak_number": "8"
                        }
                    }
                }
            ]
        }
    }
}
