prsm_data =
{
    "prsm": {
        "prsm_id": "42",
        "p_value": "3.69e-03",
        "e_value": "3.70e-03",
        "fdr": "0",
        "matched_fragment_number": "6",
        "matched_peak_number": "6",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                "ms1_ids": "526",
                "ms1_scans": "607",
                "ids": "82",
                "scans": "610",
                "precursor_mono_mass": "8772.6535",
                "precursor_charge": "11",
                "precursor_mz": "798.5212",
                "feature_inte": "1.6404e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "82",
                        "peak_id": "0",
                        "monoisotopic_mass": "1696.8836",
                        "monoisotopic_mz": "1697.8909",
                        "intensity": "1156.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "1",
                        "monoisotopic_mass": "1730.7735",
                        "monoisotopic_mz": "1731.7808",
                        "intensity": "2310.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "2",
                        "monoisotopic_mass": "1298.6633",
                        "monoisotopic_mz": "1299.6705",
                        "intensity": "2663.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "3",
                        "monoisotopic_mass": "1522.6734",
                        "monoisotopic_mz": "1523.6807",
                        "intensity": "1644.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "4",
                        "monoisotopic_mass": "1347.7089",
                        "monoisotopic_mz": "1348.7162",
                        "intensity": "1147.14",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "5",
                        "monoisotopic_mass": "926.5353",
                        "monoisotopic_mz": "927.5425",
                        "intensity": "2104.69",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "6",
                        "monoisotopic_mass": "978.6382",
                        "monoisotopic_mz": "979.6454",
                        "intensity": "10291.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "7",
                        "monoisotopic_mass": "950.5112",
                        "monoisotopic_mz": "951.5185",
                        "intensity": "10052.97",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "950.5073",
                                "ion_position": "75",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "75",
                                "mass_error": "0.0039",
                                "ppm": "4.13"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "8",
                        "monoisotopic_mass": "2005.0227",
                        "monoisotopic_mz": "1003.5186",
                        "intensity": "6769.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "9",
                        "monoisotopic_mass": "879.5691",
                        "monoisotopic_mz": "880.5764",
                        "intensity": "4009.53",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "10",
                        "monoisotopic_mass": "1593.7126",
                        "monoisotopic_mz": "1594.7198",
                        "intensity": "2876.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "11",
                        "monoisotopic_mass": "907.5646",
                        "monoisotopic_mz": "908.5718",
                        "intensity": "5126.60",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "907.5603",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "0.0042",
                                "ppm": "4.65"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "12",
                        "monoisotopic_mass": "1150.6286",
                        "monoisotopic_mz": "1151.6359",
                        "intensity": "2768.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "13",
                        "monoisotopic_mass": "810.5114",
                        "monoisotopic_mz": "811.5187",
                        "intensity": "2347.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "14",
                        "monoisotopic_mass": "1650.7367",
                        "monoisotopic_mz": "1651.7440",
                        "intensity": "1385.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "15",
                        "monoisotopic_mass": "1177.6520",
                        "monoisotopic_mz": "1178.6593",
                        "intensity": "2315.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "16",
                        "monoisotopic_mass": "1553.7875",
                        "monoisotopic_mz": "1554.7948",
                        "intensity": "3600.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "17",
                        "monoisotopic_mass": "837.4267",
                        "monoisotopic_mz": "838.4340",
                        "intensity": "19597.51",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "837.4232",
                                "ion_position": "76",
                                "ion_display_position": "8",
                                "ion_sort_name": "Y00008",
                                "ion_left_position": "76",
                                "mass_error": "0.0035",
                                "ppm": "4.19"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "18",
                        "monoisotopic_mass": "1006.6329",
                        "monoisotopic_mz": "1007.6402",
                        "intensity": "9431.93",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1006.6287",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "0.0042",
                                "ppm": "4.14"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "19",
                        "monoisotopic_mass": "1905.9534",
                        "monoisotopic_mz": "953.9840",
                        "intensity": "6317.94",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "20",
                        "monoisotopic_mass": "1365.7198",
                        "monoisotopic_mz": "1366.7270",
                        "intensity": "6757.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "21",
                        "monoisotopic_mass": "855.4958",
                        "monoisotopic_mz": "856.5031",
                        "intensity": "3164.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "22",
                        "monoisotopic_mass": "779.4572",
                        "monoisotopic_mz": "780.4645",
                        "intensity": "2029.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "23",
                        "monoisotopic_mass": "1407.6468",
                        "monoisotopic_mz": "1408.6541",
                        "intensity": "2076.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "24",
                        "monoisotopic_mass": "1497.7962",
                        "monoisotopic_mz": "749.9054",
                        "intensity": "1107.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "25",
                        "monoisotopic_mass": "2931.6293",
                        "monoisotopic_mz": "978.2170",
                        "intensity": "1174.02",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "26",
                        "monoisotopic_mass": "681.3362",
                        "monoisotopic_mz": "682.3435",
                        "intensity": "8402.47",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "681.3334",
                                "ion_position": "78",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "78",
                                "mass_error": "0.0029",
                                "ppm": "4.22"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "27",
                        "monoisotopic_mass": "711.4423",
                        "monoisotopic_mz": "712.4496",
                        "intensity": "7330.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "28",
                        "monoisotopic_mass": "1662.7101",
                        "monoisotopic_mz": "832.3623",
                        "intensity": "3166.80",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "29",
                        "monoisotopic_mass": "2111.1811",
                        "monoisotopic_mz": "1056.5978",
                        "intensity": "1693.34",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "30",
                        "monoisotopic_mass": "1426.7582",
                        "monoisotopic_mz": "1427.7655",
                        "intensity": "1286.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "31",
                        "monoisotopic_mass": "625.3096",
                        "monoisotopic_mz": "626.3168",
                        "intensity": "3717.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "32",
                        "monoisotopic_mass": "580.2881",
                        "monoisotopic_mz": "581.2953",
                        "intensity": "3813.14",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "580.2857",
                                "ion_position": "79",
                                "ion_display_position": "5",
                                "ion_sort_name": "Y00005",
                                "ion_left_position": "79",
                                "mass_error": "0.0024",
                                "ppm": "4.12"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "33",
                        "monoisotopic_mass": "1079.5893",
                        "monoisotopic_mz": "1080.5966",
                        "intensity": "3785.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "34",
                        "monoisotopic_mass": "1733.9043",
                        "monoisotopic_mz": "867.9594",
                        "intensity": "4707.45",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "35",
                        "monoisotopic_mass": "1482.6588",
                        "monoisotopic_mz": "742.3367",
                        "intensity": "1226.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "36",
                        "monoisotopic_mass": "2335.3133",
                        "monoisotopic_mz": "1168.6639",
                        "intensity": "1460.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "37",
                        "monoisotopic_mass": "2143.1556",
                        "monoisotopic_mz": "1072.5851",
                        "intensity": "2134.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "38",
                        "monoisotopic_mass": "1149.6548",
                        "monoisotopic_mz": "575.8347",
                        "intensity": "987.17",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "39",
                        "monoisotopic_mass": "1944.0254",
                        "monoisotopic_mz": "973.0200",
                        "intensity": "2947.13",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "40",
                        "monoisotopic_mass": "3230.7817",
                        "monoisotopic_mz": "1077.9345",
                        "intensity": "1074.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "41",
                        "monoisotopic_mass": "1990.1142",
                        "monoisotopic_mz": "996.0644",
                        "intensity": "1356.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "42",
                        "monoisotopic_mass": "1593.8840",
                        "monoisotopic_mz": "797.9493",
                        "intensity": "5774.87",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "43",
                        "monoisotopic_mass": "1757.9205",
                        "monoisotopic_mz": "879.9675",
                        "intensity": "1002.17",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "44",
                        "monoisotopic_mass": "1577.7326",
                        "monoisotopic_mz": "789.8736",
                        "intensity": "1119.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "45",
                        "monoisotopic_mass": "2205.1386",
                        "monoisotopic_mz": "1103.5766",
                        "intensity": "3414.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "46",
                        "monoisotopic_mass": "2902.3871",
                        "monoisotopic_mz": "1452.2008",
                        "intensity": "1344.92",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "47",
                        "monoisotopic_mass": "4065.2117",
                        "monoisotopic_mz": "1017.3102",
                        "intensity": "473.89",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "48",
                        "monoisotopic_mass": "4818.1296",
                        "monoisotopic_mz": "964.6332",
                        "intensity": "1194.05",
                        "charge": "5"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "49",
                        "monoisotopic_mass": "1823.9767",
                        "monoisotopic_mz": "1824.9840",
                        "intensity": "1926.44",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "50",
                        "monoisotopic_mass": "2285.2539",
                        "monoisotopic_mz": "1143.6342",
                        "intensity": "1122.20",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "51",
                        "monoisotopic_mass": "2071.1228",
                        "monoisotopic_mz": "1036.5687",
                        "intensity": "1777.17",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "52",
                        "monoisotopic_mass": "2791.5657",
                        "monoisotopic_mz": "1396.7901",
                        "intensity": "497.80",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "53",
                        "monoisotopic_mass": "1967.9842",
                        "monoisotopic_mz": "984.9994",
                        "intensity": "2838.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "54",
                        "monoisotopic_mass": "2040.1124",
                        "monoisotopic_mz": "1021.0635",
                        "intensity": "446.83",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P0AG55|RL6_ECOLI",
            "sequence_description": "50S ribosomal protein L6 OS=Escherichia coli (strain K12) OX=83333 GN=rplF PE=1 SV=2",
            "proteoform_mass": "8772.6566",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "177",
                "first_residue_position": "1",
                "last_residue_position": "84",
                "annotated_seq": "M.SRVAKAPVVVPAGVDVKINGQVITIKGKNGELTRTLNDAVEVKHADNTLTFGPRDGYADGWAQAGTARALLNSMVIGVTEGFTK.K",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "S"
                    },
                    {
                        "position": "2",
                        "acid": "R"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "A"
                    },
                    {
                        "position": "5",
                        "acid": "K"
                    },
                    {
                        "position": "6",
                        "acid": "A"
                    },
                    {
                        "position": "7",
                        "acid": "P"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "V"
                    },
                    {
                        "position": "10",
                        "acid": "V"
                    },
                    {
                        "position": "11",
                        "acid": "P"
                    },
                    {
                        "position": "12",
                        "acid": "A"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "V"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "I"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "G"
                    },
                    {
                        "position": "21",
                        "acid": "Q"
                    },
                    {
                        "position": "22",
                        "acid": "V"
                    },
                    {
                        "position": "23",
                        "acid": "I"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "I"
                    },
                    {
                        "position": "26",
                        "acid": "K"
                    },
                    {
                        "position": "27",
                        "acid": "G"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "G"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "L"
                    },
                    {
                        "position": "33",
                        "acid": "T"
                    },
                    {
                        "position": "34",
                        "acid": "R"
                    },
                    {
                        "position": "35",
                        "acid": "T"
                    },
                    {
                        "position": "36",
                        "acid": "L"
                    },
                    {
                        "position": "37",
                        "acid": "N"
                    },
                    {
                        "position": "38",
                        "acid": "D"
                    },
                    {
                        "position": "39",
                        "acid": "A"
                    },
                    {
                        "position": "40",
                        "acid": "V"
                    },
                    {
                        "position": "41",
                        "acid": "E"
                    },
                    {
                        "position": "42",
                        "acid": "V"
                    },
                    {
                        "position": "43",
                        "acid": "K"
                    },
                    {
                        "position": "44",
                        "acid": "H"
                    },
                    {
                        "position": "45",
                        "acid": "A"
                    },
                    {
                        "position": "46",
                        "acid": "D"
                    },
                    {
                        "position": "47",
                        "acid": "N"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "L"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "F"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "P"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "D"
                    },
                    {
                        "position": "56",
                        "acid": "G"
                    },
                    {
                        "position": "57",
                        "acid": "Y"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "W"
                    },
                    {
                        "position": "62",
                        "acid": "A"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "A"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "T"
                    },
                    {
                        "position": "67",
                        "acid": "A"
                    },
                    {
                        "position": "68",
                        "acid": "R"
                    },
                    {
                        "position": "69",
                        "acid": "A"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "S"
                    },
                    {
                        "position": "74",
                        "acid": "M"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "G"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "E"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "F"
                    },
                    {
                        "position": "83",
                        "acid": "T"
                    },
                    {
                        "position": "84",
                        "acid": "K"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "L"
                    },
                    {
                        "position": "87",
                        "acid": "Q"
                    },
                    {
                        "position": "88",
                        "acid": "L"
                    },
                    {
                        "position": "89",
                        "acid": "V"
                    },
                    {
                        "position": "90",
                        "acid": "G"
                    },
                    {
                        "position": "91",
                        "acid": "V"
                    },
                    {
                        "position": "92",
                        "acid": "G"
                    },
                    {
                        "position": "93",
                        "acid": "Y"
                    },
                    {
                        "position": "94",
                        "acid": "R"
                    },
                    {
                        "position": "95",
                        "acid": "A"
                    },
                    {
                        "position": "96",
                        "acid": "A"
                    },
                    {
                        "position": "97",
                        "acid": "V"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "G"
                    },
                    {
                        "position": "100",
                        "acid": "N"
                    },
                    {
                        "position": "101",
                        "acid": "V"
                    },
                    {
                        "position": "102",
                        "acid": "I"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "L"
                    },
                    {
                        "position": "105",
                        "acid": "S"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "G"
                    },
                    {
                        "position": "108",
                        "acid": "F"
                    },
                    {
                        "position": "109",
                        "acid": "S"
                    },
                    {
                        "position": "110",
                        "acid": "H"
                    },
                    {
                        "position": "111",
                        "acid": "P"
                    },
                    {
                        "position": "112",
                        "acid": "V"
                    },
                    {
                        "position": "113",
                        "acid": "D"
                    },
                    {
                        "position": "114",
                        "acid": "H"
                    },
                    {
                        "position": "115",
                        "acid": "Q"
                    },
                    {
                        "position": "116",
                        "acid": "L"
                    },
                    {
                        "position": "117",
                        "acid": "P"
                    },
                    {
                        "position": "118",
                        "acid": "A"
                    },
                    {
                        "position": "119",
                        "acid": "G"
                    },
                    {
                        "position": "120",
                        "acid": "I"
                    },
                    {
                        "position": "121",
                        "acid": "T"
                    },
                    {
                        "position": "122",
                        "acid": "A"
                    },
                    {
                        "position": "123",
                        "acid": "E"
                    },
                    {
                        "position": "124",
                        "acid": "C"
                    },
                    {
                        "position": "125",
                        "acid": "P"
                    },
                    {
                        "position": "126",
                        "acid": "T"
                    },
                    {
                        "position": "127",
                        "acid": "Q"
                    },
                    {
                        "position": "128",
                        "acid": "T"
                    },
                    {
                        "position": "129",
                        "acid": "E"
                    },
                    {
                        "position": "130",
                        "acid": "I"
                    },
                    {
                        "position": "131",
                        "acid": "V"
                    },
                    {
                        "position": "132",
                        "acid": "L"
                    },
                    {
                        "position": "133",
                        "acid": "K"
                    },
                    {
                        "position": "134",
                        "acid": "G"
                    },
                    {
                        "position": "135",
                        "acid": "A"
                    },
                    {
                        "position": "136",
                        "acid": "D"
                    },
                    {
                        "position": "137",
                        "acid": "K"
                    },
                    {
                        "position": "138",
                        "acid": "Q"
                    },
                    {
                        "position": "139",
                        "acid": "V"
                    },
                    {
                        "position": "140",
                        "acid": "I"
                    },
                    {
                        "position": "141",
                        "acid": "G"
                    },
                    {
                        "position": "142",
                        "acid": "Q"
                    },
                    {
                        "position": "143",
                        "acid": "V"
                    },
                    {
                        "position": "144",
                        "acid": "A"
                    },
                    {
                        "position": "145",
                        "acid": "A"
                    },
                    {
                        "position": "146",
                        "acid": "D"
                    },
                    {
                        "position": "147",
                        "acid": "L"
                    },
                    {
                        "position": "148",
                        "acid": "R"
                    },
                    {
                        "position": "149",
                        "acid": "A"
                    },
                    {
                        "position": "150",
                        "acid": "Y"
                    },
                    {
                        "position": "151",
                        "acid": "R"
                    },
                    {
                        "position": "152",
                        "acid": "R"
                    },
                    {
                        "position": "153",
                        "acid": "P"
                    },
                    {
                        "position": "154",
                        "acid": "E"
                    },
                    {
                        "position": "155",
                        "acid": "P"
                    },
                    {
                        "position": "156",
                        "acid": "Y"
                    },
                    {
                        "position": "157",
                        "acid": "K"
                    },
                    {
                        "position": "158",
                        "acid": "G"
                    },
                    {
                        "position": "159",
                        "acid": "K"
                    },
                    {
                        "position": "160",
                        "acid": "G"
                    },
                    {
                        "position": "161",
                        "acid": "V"
                    },
                    {
                        "position": "162",
                        "acid": "R"
                    },
                    {
                        "position": "163",
                        "acid": "Y"
                    },
                    {
                        "position": "164",
                        "acid": "A"
                    },
                    {
                        "position": "165",
                        "acid": "D"
                    },
                    {
                        "position": "166",
                        "acid": "E"
                    },
                    {
                        "position": "167",
                        "acid": "V"
                    },
                    {
                        "position": "168",
                        "acid": "V"
                    },
                    {
                        "position": "169",
                        "acid": "R"
                    },
                    {
                        "position": "170",
                        "acid": "T"
                    },
                    {
                        "position": "171",
                        "acid": "K"
                    },
                    {
                        "position": "172",
                        "acid": "E"
                    },
                    {
                        "position": "173",
                        "acid": "A"
                    },
                    {
                        "position": "174",
                        "acid": "K"
                    },
                    {
                        "position": "175",
                        "acid": "K"
                    },
                    {
                        "position": "176",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "82",
                                "peak_id": "11",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "spec_id": "82",
                                "peak_id": "18",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "75",
                                "ion_display_position": "9",
                                "spec_id": "82",
                                "peak_id": "7",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "76",
                                "ion_display_position": "8",
                                "spec_id": "82",
                                "peak_id": "17",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "78",
                                "ion_display_position": "6",
                                "spec_id": "82",
                                "peak_id": "26",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "5",
                                "spec_id": "82",
                                "peak_id": "32",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "150",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "151",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "152",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "153",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "154",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "155",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "156",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "157",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "158",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "159",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "160",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "161",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "162",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "163",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "164",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "165",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "166",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "167",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "168",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "169",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "170",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "171",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "172",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "173",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "174",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "175",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "176",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "177",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
