prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "8",
        "sequence_name": "sp|P61175|RL22_ECOLI",
        "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
        "proteoform_id": "8",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "87",
                "p_value": "1.07e-25",
                "e_value": "1.07e-25",
                "fdr": "0",
                "matched_fragment_number": "27",
                "matched_peak_number": "32",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "584",
                        "ms1_scans": "839",
                        "ids": "254",
                        "scans": "840",
                        "precursor_mono_mass": "4478.3937",
                        "precursor_charge": "5",
                        "precursor_mz": "896.6860",
                        "feature_inte": "1.7789e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "254",
                                "peak_id": "0",
                                "monoisotopic_mass": "666.4819",
                                "monoisotopic_mz": "667.4891",
                                "intensity": "3502.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "1",
                                "monoisotopic_mass": "1963.8795",
                                "monoisotopic_mz": "1964.8868",
                                "intensity": "2664.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "2",
                                "monoisotopic_mass": "1949.8633",
                                "monoisotopic_mz": "1950.8705",
                                "intensity": "5415.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "3",
                                "monoisotopic_mass": "2061.9513",
                                "monoisotopic_mz": "2062.9585",
                                "intensity": "2296.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "4",
                                "monoisotopic_mass": "1805.9631",
                                "monoisotopic_mz": "1806.9704",
                                "intensity": "4451.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1805.9597",
                                        "ion_position": "26",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0034",
                                        "ppm": "1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "5",
                                "monoisotopic_mass": "1363.6388",
                                "monoisotopic_mz": "1364.6461",
                                "intensity": "2870.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "6",
                                "monoisotopic_mass": "2062.1593",
                                "monoisotopic_mz": "1032.0869",
                                "intensity": "2662.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "7",
                                "monoisotopic_mass": "1507.6589",
                                "monoisotopic_mz": "1508.6661",
                                "intensity": "8246.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "8",
                                "monoisotopic_mass": "1690.9371",
                                "monoisotopic_mz": "1691.9443",
                                "intensity": "8795.91",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0043",
                                        "ppm": "2.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "9",
                                "monoisotopic_mass": "1737.7121",
                                "monoisotopic_mz": "1738.7194",
                                "intensity": "6126.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "10",
                                "monoisotopic_mass": "1608.6718",
                                "monoisotopic_mz": "1609.6791",
                                "intensity": "8868.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "11",
                                "monoisotopic_mass": "2077.9520",
                                "monoisotopic_mz": "2078.9593",
                                "intensity": "3251.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "12",
                                "monoisotopic_mass": "1862.9194",
                                "monoisotopic_mz": "1863.9267",
                                "intensity": "1825.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "13",
                                "monoisotopic_mass": "1832.7821",
                                "monoisotopic_mz": "1833.7893",
                                "intensity": "3259.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "14",
                                "monoisotopic_mass": "2034.0738",
                                "monoisotopic_mz": "2035.0811",
                                "intensity": "5000.07",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2034.0707",
                                        "ion_position": "24",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0031",
                                        "ppm": "1.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "15",
                                "monoisotopic_mass": "994.3776",
                                "monoisotopic_mz": "995.3849",
                                "intensity": "15038.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "16",
                                "monoisotopic_mass": "921.6412",
                                "monoisotopic_mz": "922.6485",
                                "intensity": "6256.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "17",
                                "monoisotopic_mass": "1995.9996",
                                "monoisotopic_mz": "1997.0069",
                                "intensity": "2126.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "18",
                                "monoisotopic_mass": "1920.9899",
                                "monoisotopic_mz": "1921.9972",
                                "intensity": "5384.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1920.9867",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0033",
                                        "ppm": "1.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "19",
                                "monoisotopic_mass": "1008.4624",
                                "monoisotopic_mz": "1009.4697",
                                "intensity": "99480.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0038",
                                        "ppm": "3.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "20",
                                "monoisotopic_mass": "1350.6901",
                                "monoisotopic_mz": "1351.6974",
                                "intensity": "88983.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0048",
                                        "ppm": "3.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "21",
                                "monoisotopic_mass": "2034.0751",
                                "monoisotopic_mz": "1018.0448",
                                "intensity": "6999.03",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2034.0707",
                                        "ion_position": "24",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0044",
                                        "ppm": "2.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "22",
                                "monoisotopic_mass": "1577.8548",
                                "monoisotopic_mz": "1578.8621",
                                "intensity": "12908.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0061",
                                        "ppm": "3.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "23",
                                "monoisotopic_mass": "936.6515",
                                "monoisotopic_mz": "937.6588",
                                "intensity": "10125.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "936.6484",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0031",
                                        "ppm": "3.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "24",
                                "monoisotopic_mass": "967.6099",
                                "monoisotopic_mz": "968.6171",
                                "intensity": "8696.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "25",
                                "monoisotopic_mass": "1107.4622",
                                "monoisotopic_mz": "1108.4695",
                                "intensity": "9163.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "26",
                                "monoisotopic_mass": "1337.5168",
                                "monoisotopic_mz": "1338.5240",
                                "intensity": "18894.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "27",
                                "monoisotopic_mass": "952.3556",
                                "monoisotopic_mz": "953.3629",
                                "intensity": "13367.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "28",
                                "monoisotopic_mass": "2206.0506",
                                "monoisotopic_mz": "2207.0579",
                                "intensity": "1285.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "29",
                                "monoisotopic_mass": "1121.5466",
                                "monoisotopic_mz": "1122.5538",
                                "intensity": "81623.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0039",
                                        "ppm": "3.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "30",
                                "monoisotopic_mass": "1249.6423",
                                "monoisotopic_mz": "1250.6495",
                                "intensity": "37619.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0046",
                                        "ppm": "3.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "31",
                                "monoisotopic_mass": "861.3933",
                                "monoisotopic_mz": "862.4006",
                                "intensity": "39458.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0031",
                                        "ppm": "3.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "32",
                                "monoisotopic_mass": "1690.9392",
                                "monoisotopic_mz": "846.4769",
                                "intensity": "11381.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0064",
                                        "ppm": "3.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "33",
                                "monoisotopic_mass": "680.4972",
                                "monoisotopic_mz": "681.5045",
                                "intensity": "5928.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "34",
                                "monoisotopic_mass": "567.4128",
                                "monoisotopic_mz": "568.4200",
                                "intensity": "11345.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "35",
                                "monoisotopic_mass": "1577.8552",
                                "monoisotopic_mz": "789.9349",
                                "intensity": "7775.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0065",
                                        "ppm": "4.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "36",
                                "monoisotopic_mass": "1449.7584",
                                "monoisotopic_mz": "1450.7656",
                                "intensity": "54201.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0046",
                                        "ppm": "3.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "37",
                                "monoisotopic_mass": "1493.6447",
                                "monoisotopic_mz": "1494.6520",
                                "intensity": "3920.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "38",
                                "monoisotopic_mass": "1721.7555",
                                "monoisotopic_mz": "1722.7628",
                                "intensity": "4469.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "39",
                                "monoisotopic_mass": "762.3246",
                                "monoisotopic_mz": "763.3319",
                                "intensity": "52037.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0028",
                                        "ppm": "3.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "40",
                                "monoisotopic_mass": "1049.7369",
                                "monoisotopic_mz": "1050.7441",
                                "intensity": "5457.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1049.7325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0044",
                                        "ppm": "4.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "41",
                                "monoisotopic_mass": "1591.9595",
                                "monoisotopic_mz": "796.9870",
                                "intensity": "5453.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "42",
                                "monoisotopic_mass": "1520.9710",
                                "monoisotopic_mz": "761.4928",
                                "intensity": "5899.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1520.9654",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0056",
                                        "ppm": "3.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "43",
                                "monoisotopic_mass": "1590.6589",
                                "monoisotopic_mz": "1591.6661",
                                "intensity": "2934.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "44",
                                "monoisotopic_mass": "2392.1896",
                                "monoisotopic_mz": "1197.1021",
                                "intensity": "7711.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2392.1832",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0064",
                                        "ppm": "2.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "45",
                                "monoisotopic_mass": "1306.6639",
                                "monoisotopic_mz": "1307.6711",
                                "intensity": "1595.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "46",
                                "monoisotopic_mass": "1022.4450",
                                "monoisotopic_mz": "1023.4523",
                                "intensity": "4215.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "47",
                                "monoisotopic_mass": "1421.9380",
                                "monoisotopic_mz": "711.9763",
                                "intensity": "5235.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "48",
                                "monoisotopic_mass": "1308.8546",
                                "monoisotopic_mz": "655.4346",
                                "intensity": "4186.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "49",
                                "monoisotopic_mass": "1431.7482",
                                "monoisotopic_mz": "1432.7555",
                                "intensity": "6099.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "50",
                                "monoisotopic_mass": "2001.9820",
                                "monoisotopic_mz": "1001.9983",
                                "intensity": "2303.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "51",
                                "monoisotopic_mass": "2021.1442",
                                "monoisotopic_mz": "1011.5794",
                                "intensity": "6800.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "52",
                                "monoisotopic_mass": "2506.2335",
                                "monoisotopic_mz": "1254.1240",
                                "intensity": "12345.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2506.2261",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0074",
                                        "ppm": "2.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "53",
                                "monoisotopic_mass": "1521.6383",
                                "monoisotopic_mz": "1522.6456",
                                "intensity": "4403.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "54",
                                "monoisotopic_mass": "1635.0133",
                                "monoisotopic_mz": "818.5139",
                                "intensity": "5703.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1635.0083",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0050",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "55",
                                "monoisotopic_mass": "2297.2948",
                                "monoisotopic_mz": "1149.6547",
                                "intensity": "3549.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "56",
                                "monoisotopic_mass": "3543.7815",
                                "monoisotopic_mz": "1182.2678",
                                "intensity": "4898.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "57",
                                "monoisotopic_mass": "2277.1669",
                                "monoisotopic_mz": "1139.5907",
                                "intensity": "10720.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2277.1562",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0106",
                                        "ppm": "4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "58",
                                "monoisotopic_mass": "2418.2057",
                                "monoisotopic_mz": "1210.1101",
                                "intensity": "5627.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "59",
                                "monoisotopic_mass": "3028.4479",
                                "monoisotopic_mz": "1515.2312",
                                "intensity": "5746.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3028.4448",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0031",
                                        "ppm": "1.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "60",
                                "monoisotopic_mass": "1706.0516",
                                "monoisotopic_mz": "854.0331",
                                "intensity": "4512.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1706.0454",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0062",
                                        "ppm": "3.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "61",
                                "monoisotopic_mass": "1920.9954",
                                "monoisotopic_mz": "961.5050",
                                "intensity": "2744.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1920.9867",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0087",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "62",
                                "monoisotopic_mass": "2176.1835",
                                "monoisotopic_mz": "1089.0990",
                                "intensity": "2447.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "63",
                                "monoisotopic_mass": "3343.8029",
                                "monoisotopic_mz": "1115.6082",
                                "intensity": "2098.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "64",
                                "monoisotopic_mass": "1534.6960",
                                "monoisotopic_mz": "768.3553",
                                "intensity": "1481.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "65",
                                "monoisotopic_mass": "1835.0925",
                                "monoisotopic_mz": "918.5535",
                                "intensity": "4209.45",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1835.0880",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0045",
                                        "ppm": "2.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "66",
                                "monoisotopic_mass": "3366.0412",
                                "monoisotopic_mz": "674.2155",
                                "intensity": "772.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "67",
                                "monoisotopic_mass": "2787.4506",
                                "monoisotopic_mz": "1394.7326",
                                "intensity": "9359.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2787.4403",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0103",
                                        "ppm": "3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "68",
                                "monoisotopic_mass": "2787.4506",
                                "monoisotopic_mz": "930.1575",
                                "intensity": "3034.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2787.4403",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0103",
                                        "ppm": "3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "69",
                                "monoisotopic_mass": "2258.2466",
                                "monoisotopic_mz": "753.7562",
                                "intensity": "2419.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2258.2383",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0084",
                                        "ppm": "3.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "70",
                                "monoisotopic_mass": "2643.2970",
                                "monoisotopic_mz": "1322.6558",
                                "intensity": "10922.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2643.2850",
                                        "ion_position": "18",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0120",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "71",
                                "monoisotopic_mass": "1734.8236",
                                "monoisotopic_mz": "868.4191",
                                "intensity": "1761.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "72",
                                "monoisotopic_mass": "2843.3698",
                                "monoisotopic_mz": "1422.6922",
                                "intensity": "3963.12",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2843.3647",
                                        "ion_position": "16",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "Y00026",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0050",
                                        "ppm": "1.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "73",
                                "monoisotopic_mass": "3141.5423",
                                "monoisotopic_mz": "1048.1880",
                                "intensity": "2800.76",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3141.5288",
                                        "ion_position": "13",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0134",
                                        "ppm": "4.28"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "254",
                                        "peak_id": "23",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "254",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "29",
                                        "spec_id": "254",
                                        "peak_id": "73",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "spec_id": "254",
                                        "peak_id": "59",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "254",
                                        "peak_id": "42",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "254",
                                            "peak_id": "54",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "16",
                                            "ion_display_position": "26",
                                            "spec_id": "254",
                                            "peak_id": "72",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "254",
                                        "peak_id": "60",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "254",
                                            "peak_id": "65",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "18",
                                            "ion_display_position": "24",
                                            "spec_id": "254",
                                            "peak_id": "70",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "spec_id": "254",
                                        "peak_id": "52",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "spec_id": "254",
                                        "peak_id": "44",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "254",
                                        "peak_id": "57",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "254",
                                        "peak_id": "69",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "24",
                                            "ion_display_position": "18",
                                            "spec_id": "254",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "24",
                                            "ion_display_position": "18",
                                            "spec_id": "254",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "25",
                                            "ion_display_position": "17",
                                            "spec_id": "254",
                                            "peak_id": "18",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "25",
                                            "ion_display_position": "17",
                                            "spec_id": "254",
                                            "peak_id": "61",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "26",
                                        "ion_display_position": "16",
                                        "spec_id": "254",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "254",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "254",
                                            "peak_id": "32",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "254",
                                            "peak_id": "68",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "254",
                                            "peak_id": "67",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "254",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "254",
                                            "peak_id": "35",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "254",
                                        "peak_id": "36",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "254",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "254",
                                        "peak_id": "30",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "254",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "254",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "254",
                                        "peak_id": "31",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "254",
                                        "peak_id": "39",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "65",
                "p_value": "1.77e-24",
                "e_value": "1.77e-24",
                "fdr": "0",
                "matched_fragment_number": "27",
                "matched_peak_number": "29",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "573",
                        "ms1_scans": "795",
                        "ids": "222",
                        "scans": "797",
                        "precursor_mono_mass": "4478.3937",
                        "precursor_charge": "5",
                        "precursor_mz": "896.6860",
                        "feature_inte": "1.7789e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "222",
                                "peak_id": "0",
                                "monoisotopic_mass": "2592.8818",
                                "monoisotopic_mz": "649.2277",
                                "intensity": "1279.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "1",
                                "monoisotopic_mass": "1949.8661",
                                "monoisotopic_mz": "1950.8733",
                                "intensity": "2570.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "2",
                                "monoisotopic_mass": "1737.7134",
                                "monoisotopic_mz": "1738.7207",
                                "intensity": "2983.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "3",
                                "monoisotopic_mass": "1608.6720",
                                "monoisotopic_mz": "1609.6793",
                                "intensity": "3837.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "4",
                                "monoisotopic_mass": "1690.9383",
                                "monoisotopic_mz": "1691.9456",
                                "intensity": "3778.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0055",
                                        "ppm": "3.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "5",
                                "monoisotopic_mass": "1350.6913",
                                "monoisotopic_mz": "1351.6986",
                                "intensity": "38440.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0060",
                                        "ppm": "4.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "6",
                                "monoisotopic_mass": "994.3783",
                                "monoisotopic_mz": "995.3856",
                                "intensity": "5941.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "7",
                                "monoisotopic_mass": "1431.7469",
                                "monoisotopic_mz": "1432.7541",
                                "intensity": "5615.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "8",
                                "monoisotopic_mass": "1832.7739",
                                "monoisotopic_mz": "1833.7812",
                                "intensity": "1271.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "9",
                                "monoisotopic_mass": "1337.5181",
                                "monoisotopic_mz": "1338.5254",
                                "intensity": "7028.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "10",
                                "monoisotopic_mass": "1249.6434",
                                "monoisotopic_mz": "1250.6506",
                                "intensity": "15528.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0057",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "11",
                                "monoisotopic_mass": "787.4585",
                                "monoisotopic_mz": "788.4658",
                                "intensity": "7511.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "12",
                                "monoisotopic_mass": "1507.6603",
                                "monoisotopic_mz": "1508.6676",
                                "intensity": "3505.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "13",
                                "monoisotopic_mass": "1008.4631",
                                "monoisotopic_mz": "1009.4703",
                                "intensity": "40958.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0044",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "14",
                                "monoisotopic_mass": "1121.5478",
                                "monoisotopic_mz": "1122.5551",
                                "intensity": "33728.31",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0051",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "15",
                                "monoisotopic_mass": "967.6100",
                                "monoisotopic_mz": "968.6172",
                                "intensity": "3996.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "16",
                                "monoisotopic_mass": "1577.8560",
                                "monoisotopic_mz": "1578.8633",
                                "intensity": "6049.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0073",
                                        "ppm": "4.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "17",
                                "monoisotopic_mass": "1920.9952",
                                "monoisotopic_mz": "961.5049",
                                "intensity": "1551.54",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1920.9867",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0086",
                                        "ppm": "4.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "18",
                                "monoisotopic_mass": "861.3940",
                                "monoisotopic_mz": "862.4012",
                                "intensity": "15294.57",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0038",
                                        "ppm": "4.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "19",
                                "monoisotopic_mass": "952.3565",
                                "monoisotopic_mz": "953.3638",
                                "intensity": "5982.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "20",
                                "monoisotopic_mass": "1449.7596",
                                "monoisotopic_mz": "1450.7668",
                                "intensity": "22855.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0058",
                                        "ppm": "4.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "21",
                                "monoisotopic_mass": "936.6528",
                                "monoisotopic_mz": "937.6601",
                                "intensity": "3898.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "936.6484",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0044",
                                        "ppm": "4.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "22",
                                "monoisotopic_mass": "1706.0030",
                                "monoisotopic_mz": "854.0088",
                                "intensity": "4424.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "23",
                                "monoisotopic_mass": "762.3252",
                                "monoisotopic_mz": "763.3325",
                                "intensity": "23918.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0034",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "24",
                                "monoisotopic_mass": "1591.9593",
                                "monoisotopic_mz": "796.9869",
                                "intensity": "6947.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "25",
                                "monoisotopic_mass": "1379.5646",
                                "monoisotopic_mz": "1380.5719",
                                "intensity": "1564.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "26",
                                "monoisotopic_mass": "1204.5848",
                                "monoisotopic_mz": "1205.5920",
                                "intensity": "1307.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "27",
                                "monoisotopic_mass": "1577.8551",
                                "monoisotopic_mz": "789.9348",
                                "intensity": "3328.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0064",
                                        "ppm": "4.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "28",
                                "monoisotopic_mass": "709.4883",
                                "monoisotopic_mz": "710.4955",
                                "intensity": "7907.57",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "709.4850",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0032",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "29",
                                "monoisotopic_mass": "567.4130",
                                "monoisotopic_mz": "568.4203",
                                "intensity": "4389.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "30",
                                "monoisotopic_mass": "1152.4364",
                                "monoisotopic_mz": "1153.4437",
                                "intensity": "2269.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "31",
                                "monoisotopic_mass": "2191.0472",
                                "monoisotopic_mz": "1096.5309",
                                "intensity": "1681.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "32",
                                "monoisotopic_mass": "1690.9402",
                                "monoisotopic_mz": "846.4774",
                                "intensity": "5160.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0074",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "33",
                                "monoisotopic_mass": "647.2976",
                                "monoisotopic_mz": "648.3049",
                                "intensity": "28002.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.2949",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0027",
                                        "ppm": "4.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "34",
                                "monoisotopic_mass": "923.3421",
                                "monoisotopic_mz": "924.3494",
                                "intensity": "3305.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "35",
                                "monoisotopic_mass": "2277.1667",
                                "monoisotopic_mz": "1139.5906",
                                "intensity": "5394.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2277.1562",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0104",
                                        "ppm": "4.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "36",
                                "monoisotopic_mass": "1804.9660",
                                "monoisotopic_mz": "903.4903",
                                "intensity": "3005.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "37",
                                "monoisotopic_mass": "1336.8507",
                                "monoisotopic_mz": "669.4326",
                                "intensity": "7098.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.8442",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0065",
                                        "ppm": "4.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "38",
                                "monoisotopic_mass": "1049.7369",
                                "monoisotopic_mz": "525.8757",
                                "intensity": "4352.71",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1049.7325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0044",
                                        "ppm": "4.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "39",
                                "monoisotopic_mass": "1963.8867",
                                "monoisotopic_mz": "1964.8940",
                                "intensity": "1335.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "40",
                                "monoisotopic_mass": "1449.9345",
                                "monoisotopic_mz": "725.9745",
                                "intensity": "5258.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.9283",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0063",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "41",
                                "monoisotopic_mass": "581.3924",
                                "monoisotopic_mz": "582.3997",
                                "intensity": "13875.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "581.3901",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0023",
                                        "ppm": "3.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "42",
                                "monoisotopic_mass": "2506.2350",
                                "monoisotopic_mz": "1254.1248",
                                "intensity": "4108.52",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2506.2261",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0089",
                                        "ppm": "3.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "43",
                                "monoisotopic_mass": "2077.9649",
                                "monoisotopic_mz": "1039.9897",
                                "intensity": "2521.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "44",
                                "monoisotopic_mass": "3542.7667",
                                "monoisotopic_mz": "1181.9295",
                                "intensity": "3390.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "45",
                                "monoisotopic_mass": "2172.1698",
                                "monoisotopic_mz": "1087.0922",
                                "intensity": "1842.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "46",
                                "monoisotopic_mass": "1520.9729",
                                "monoisotopic_mz": "761.4937",
                                "intensity": "3063.74",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1520.9654",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0075",
                                        "ppm": "4.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "47",
                                "monoisotopic_mass": "1635.0155",
                                "monoisotopic_mz": "818.5150",
                                "intensity": "2582.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1635.0083",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0072",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "48",
                                "monoisotopic_mass": "2374.1849",
                                "monoisotopic_mz": "1188.0998",
                                "intensity": "729.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "49",
                                "monoisotopic_mass": "2043.1188",
                                "monoisotopic_mz": "1022.5667",
                                "intensity": "3400.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "50",
                                "monoisotopic_mass": "1825.0131",
                                "monoisotopic_mz": "913.5138",
                                "intensity": "1983.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "51",
                                "monoisotopic_mass": "2957.4113",
                                "monoisotopic_mz": "1479.7129",
                                "intensity": "1971.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2957.4077",
                                        "ion_position": "15",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0036",
                                        "ppm": "1.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "52",
                                "monoisotopic_mass": "3527.7635",
                                "monoisotopic_mz": "1176.9284",
                                "intensity": "2010.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "53",
                                "monoisotopic_mass": "3028.4579",
                                "monoisotopic_mz": "1515.2362",
                                "intensity": "2615.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3028.4448",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0131",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "54",
                                "monoisotopic_mass": "3126.5705",
                                "monoisotopic_mz": "1043.1974",
                                "intensity": "2374.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "55",
                                "monoisotopic_mass": "4014.8178",
                                "monoisotopic_mz": "803.9708",
                                "intensity": "872.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "56",
                                "monoisotopic_mass": "2626.2767",
                                "monoisotopic_mz": "1314.1457",
                                "intensity": "697.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "57",
                                "monoisotopic_mass": "1606.7293",
                                "monoisotopic_mz": "804.3719",
                                "intensity": "1281.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "58",
                                "monoisotopic_mass": "3341.8026",
                                "monoisotopic_mz": "1114.9415",
                                "intensity": "2535.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "59",
                                "monoisotopic_mass": "2322.4341",
                                "monoisotopic_mz": "775.1520",
                                "intensity": "942.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "60",
                                "monoisotopic_mass": "3164.1876",
                                "monoisotopic_mz": "792.0542",
                                "intensity": "1645.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "61",
                                "monoisotopic_mass": "2660.3573",
                                "monoisotopic_mz": "1331.1859",
                                "intensity": "1454.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "62",
                                "monoisotopic_mass": "2643.2960",
                                "monoisotopic_mz": "1322.6553",
                                "intensity": "3856.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2643.2850",
                                        "ion_position": "18",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0110",
                                        "ppm": "4.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "63",
                                "monoisotopic_mass": "1671.9125",
                                "monoisotopic_mz": "836.9635",
                                "intensity": "1039.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "64",
                                "monoisotopic_mass": "3470.3785",
                                "monoisotopic_mz": "695.0830",
                                "intensity": "683.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "65",
                                "monoisotopic_mass": "2005.1170",
                                "monoisotopic_mz": "1003.5658",
                                "intensity": "866.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "66",
                                "monoisotopic_mass": "2787.4461",
                                "monoisotopic_mz": "1394.7303",
                                "intensity": "3686.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2787.4403",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0058",
                                        "ppm": "2.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "67",
                                "monoisotopic_mass": "2544.5779",
                                "monoisotopic_mz": "637.1517",
                                "intensity": "662.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "68",
                                "monoisotopic_mass": "2443.3121",
                                "monoisotopic_mz": "815.4446",
                                "intensity": "3894.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "69",
                                "monoisotopic_mass": "1557.9586",
                                "monoisotopic_mz": "779.9866",
                                "intensity": "1128.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "70",
                                "monoisotopic_mass": "1827.6504",
                                "monoisotopic_mz": "610.2241",
                                "intensity": "6492.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "71",
                                "monoisotopic_mass": "3746.3222",
                                "monoisotopic_mz": "750.2717",
                                "intensity": "959.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "72",
                                "monoisotopic_mass": "2444.3129",
                                "monoisotopic_mz": "1223.1637",
                                "intensity": "6392.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0105",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "222",
                                "peak_id": "73",
                                "monoisotopic_mass": "2843.3850",
                                "monoisotopic_mz": "1422.6998",
                                "intensity": "1133.50",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2843.3647",
                                        "ion_position": "16",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "Y00026",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0203",
                                        "ppm": "7.12"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "222",
                                        "peak_id": "41",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "222",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "222",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "222",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "222",
                                        "peak_id": "37",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "222",
                                            "peak_id": "40",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "28",
                                            "spec_id": "222",
                                            "peak_id": "53",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "222",
                                            "peak_id": "46",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "27",
                                            "spec_id": "222",
                                            "peak_id": "51",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "222",
                                            "peak_id": "47",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "16",
                                            "ion_display_position": "26",
                                            "spec_id": "222",
                                            "peak_id": "73",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "18",
                                        "ion_display_position": "24",
                                        "spec_id": "222",
                                        "peak_id": "62",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "spec_id": "222",
                                        "peak_id": "42",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "222",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "222",
                                        "peak_id": "72",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "spec_id": "222",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "222",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "222",
                                            "peak_id": "32",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "222",
                                            "peak_id": "66",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "222",
                                            "peak_id": "27",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "222",
                                            "peak_id": "16",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "222",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "222",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "222",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "222",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "222",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "222",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "222",
                                        "peak_id": "23",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "spec_id": "222",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "109",
                "p_value": "7.46e-12",
                "e_value": "7.46e-12",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "595",
                        "ms1_scans": "883",
                        "ids": "287",
                        "scans": "884",
                        "precursor_mono_mass": "4478.3937",
                        "precursor_charge": "5",
                        "precursor_mz": "896.6860",
                        "feature_inte": "1.7789e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "287",
                                "peak_id": "0",
                                "monoisotopic_mass": "2039.1099",
                                "monoisotopic_mz": "1020.5622",
                                "intensity": "8563.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "1",
                                "monoisotopic_mass": "1577.8583",
                                "monoisotopic_mz": "1578.8656",
                                "intensity": "1542.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0096",
                                        "ppm": "6.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "2",
                                "monoisotopic_mass": "1350.6917",
                                "monoisotopic_mz": "1351.6990",
                                "intensity": "10498.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0064",
                                        "ppm": "4.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "3",
                                "monoisotopic_mass": "1249.6435",
                                "monoisotopic_mz": "1250.6508",
                                "intensity": "4869.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0058",
                                        "ppm": "4.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "4",
                                "monoisotopic_mass": "1008.4626",
                                "monoisotopic_mz": "1009.4698",
                                "intensity": "11318.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0039",
                                        "ppm": "3.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "5",
                                "monoisotopic_mass": "1449.7605",
                                "monoisotopic_mz": "1450.7678",
                                "intensity": "6148.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0068",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "6",
                                "monoisotopic_mass": "1690.9398",
                                "monoisotopic_mz": "1691.9470",
                                "intensity": "1314.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0070",
                                        "ppm": "4.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "7",
                                "monoisotopic_mass": "981.6014",
                                "monoisotopic_mz": "982.6087",
                                "intensity": "5768.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "8",
                                "monoisotopic_mass": "1121.5478",
                                "monoisotopic_mz": "1122.5551",
                                "intensity": "8826.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0051",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "9",
                                "monoisotopic_mass": "1850.7971",
                                "monoisotopic_mz": "1851.8044",
                                "intensity": "1315.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "10",
                                "monoisotopic_mass": "1337.5158",
                                "monoisotopic_mz": "1338.5231",
                                "intensity": "2159.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "11",
                                "monoisotopic_mass": "994.3792",
                                "monoisotopic_mz": "995.3865",
                                "intensity": "1725.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "12",
                                "monoisotopic_mass": "2954.5229",
                                "monoisotopic_mz": "985.8483",
                                "intensity": "1361.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "13",
                                "monoisotopic_mass": "861.3941",
                                "monoisotopic_mz": "862.4014",
                                "intensity": "5010.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0039",
                                        "ppm": "4.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "14",
                                "monoisotopic_mass": "1431.7485",
                                "monoisotopic_mz": "1432.7557",
                                "intensity": "990.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "15",
                                "monoisotopic_mass": "967.6110",
                                "monoisotopic_mz": "968.6182",
                                "intensity": "1470.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "16",
                                "monoisotopic_mass": "882.5326",
                                "monoisotopic_mz": "883.5399",
                                "intensity": "1831.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "17",
                                "monoisotopic_mass": "762.3249",
                                "monoisotopic_mz": "763.3322",
                                "intensity": "7339.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0031",
                                        "ppm": "4.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "18",
                                "monoisotopic_mass": "647.2975",
                                "monoisotopic_mz": "648.3048",
                                "intensity": "6889.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.2949",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0027",
                                        "ppm": "4.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "19",
                                "monoisotopic_mass": "936.6529",
                                "monoisotopic_mz": "937.6602",
                                "intensity": "862.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "936.6484",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0045",
                                        "ppm": "4.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "20",
                                "monoisotopic_mass": "3126.5691",
                                "monoisotopic_mz": "1043.1970",
                                "intensity": "1624.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "21",
                                "monoisotopic_mass": "809.5403",
                                "monoisotopic_mz": "810.5475",
                                "intensity": "593.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "22",
                                "monoisotopic_mass": "581.3924",
                                "monoisotopic_mz": "582.3997",
                                "intensity": "4320.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "581.3901",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0024",
                                        "ppm": "4.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "23",
                                "monoisotopic_mass": "629.2867",
                                "monoisotopic_mz": "630.2939",
                                "intensity": "2187.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "24",
                                "monoisotopic_mass": "1706.0029",
                                "monoisotopic_mz": "854.0087",
                                "intensity": "1885.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "25",
                                "monoisotopic_mass": "952.3560",
                                "monoisotopic_mz": "953.3633",
                                "intensity": "1732.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "26",
                                "monoisotopic_mass": "609.2167",
                                "monoisotopic_mz": "610.2239",
                                "intensity": "1403.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "27",
                                "monoisotopic_mass": "518.2542",
                                "monoisotopic_mz": "519.2615",
                                "intensity": "7743.59",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "518.2523",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0019",
                                        "ppm": "3.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "28",
                                "monoisotopic_mass": "2272.2413",
                                "monoisotopic_mz": "1137.1280",
                                "intensity": "1734.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "29",
                                "monoisotopic_mass": "1364.8473",
                                "monoisotopic_mz": "683.4309",
                                "intensity": "812.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "30",
                                "monoisotopic_mass": "3543.7716",
                                "monoisotopic_mz": "1182.2645",
                                "intensity": "2597.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "31",
                                "monoisotopic_mass": "461.2324",
                                "monoisotopic_mz": "462.2397",
                                "intensity": "3053.98",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "461.2308",
                                        "ion_position": "38",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0016",
                                        "ppm": "3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "32",
                                "monoisotopic_mass": "1266.4790",
                                "monoisotopic_mz": "1267.4863",
                                "intensity": "1212.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "33",
                                "monoisotopic_mass": "569.3921",
                                "monoisotopic_mz": "570.3994",
                                "intensity": "778.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "34",
                                "monoisotopic_mass": "2506.2381",
                                "monoisotopic_mz": "1254.1263",
                                "intensity": "1079.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2506.2261",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0120",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "35",
                                "monoisotopic_mass": "1691.9437",
                                "monoisotopic_mz": "846.9791",
                                "intensity": "937.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "36",
                                "monoisotopic_mass": "1998.0421",
                                "monoisotopic_mz": "1000.0283",
                                "intensity": "487.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "37",
                                "monoisotopic_mass": "3526.7648",
                                "monoisotopic_mz": "1176.5955",
                                "intensity": "742.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "38",
                                "monoisotopic_mass": "3655.8604",
                                "monoisotopic_mz": "1219.6274",
                                "intensity": "2540.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "39",
                                "monoisotopic_mass": "2296.2905",
                                "monoisotopic_mz": "1149.1525",
                                "intensity": "972.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "40",
                                "monoisotopic_mass": "2443.3082",
                                "monoisotopic_mz": "815.4433",
                                "intensity": "973.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "41",
                                "monoisotopic_mass": "3473.7353",
                                "monoisotopic_mz": "1158.9190",
                                "intensity": "479.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "42",
                                "monoisotopic_mass": "1809.9958",
                                "monoisotopic_mz": "906.0052",
                                "intensity": "3947.53",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "287",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "287",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "spec_id": "287",
                                        "peak_id": "34",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "spec_id": "287",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "spec_id": "287",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "287",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "287",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "287",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "287",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "287",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "287",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "287",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "spec_id": "287",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "spec_id": "287",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "38",
                                        "ion_display_position": "4",
                                        "spec_id": "287",
                                        "peak_id": "31",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "81",
                "p_value": "1.31e-11",
                "e_value": "1.31e-11",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "581",
                        "ms1_scans": "827",
                        "ids": "247",
                        "scans": "830",
                        "precursor_mono_mass": "4478.3937",
                        "precursor_charge": "6",
                        "precursor_mz": "747.4062",
                        "feature_inte": "1.7789e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "247",
                                "peak_id": "0",
                                "monoisotopic_mass": "1577.8543",
                                "monoisotopic_mz": "1578.8616",
                                "intensity": "1155.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0056",
                                        "ppm": "3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "1",
                                "monoisotopic_mass": "1337.5173",
                                "monoisotopic_mz": "1338.5245",
                                "intensity": "2710.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "2",
                                "monoisotopic_mass": "967.6100",
                                "monoisotopic_mz": "968.6173",
                                "intensity": "1694.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "3",
                                "monoisotopic_mass": "1008.4625",
                                "monoisotopic_mz": "1009.4698",
                                "intensity": "11510.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0039",
                                        "ppm": "3.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "4",
                                "monoisotopic_mass": "1265.5317",
                                "monoisotopic_mz": "1266.5389",
                                "intensity": "1387.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "5",
                                "monoisotopic_mass": "1350.6908",
                                "monoisotopic_mz": "1351.6981",
                                "intensity": "6034.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0055",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "6",
                                "monoisotopic_mass": "923.3408",
                                "monoisotopic_mz": "924.3481",
                                "intensity": "1582.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "7",
                                "monoisotopic_mass": "952.3555",
                                "monoisotopic_mz": "953.3627",
                                "intensity": "1629.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "8",
                                "monoisotopic_mass": "861.3934",
                                "monoisotopic_mz": "862.4006",
                                "intensity": "7025.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0031",
                                        "ppm": "3.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "9",
                                "monoisotopic_mass": "1121.5463",
                                "monoisotopic_mz": "1122.5536",
                                "intensity": "6417.91",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0036",
                                        "ppm": "3.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "10",
                                "monoisotopic_mass": "1249.6443",
                                "monoisotopic_mz": "1250.6516",
                                "intensity": "2451.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0067",
                                        "ppm": "5.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "11",
                                "monoisotopic_mass": "994.3781",
                                "monoisotopic_mz": "995.3854",
                                "intensity": "2968.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "12",
                                "monoisotopic_mass": "1494.9424",
                                "monoisotopic_mz": "748.4785",
                                "intensity": "4596.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "13",
                                "monoisotopic_mass": "762.3247",
                                "monoisotopic_mz": "763.3320",
                                "intensity": "11929.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0029",
                                        "ppm": "3.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "14",
                                "monoisotopic_mass": "1449.7587",
                                "monoisotopic_mz": "1450.7660",
                                "intensity": "3329.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0050",
                                        "ppm": "3.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "15",
                                "monoisotopic_mass": "1107.4627",
                                "monoisotopic_mz": "1108.4700",
                                "intensity": "1916.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "16",
                                "monoisotopic_mass": "709.4877",
                                "monoisotopic_mz": "710.4949",
                                "intensity": "2003.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "709.4850",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0026",
                                        "ppm": "3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "17",
                                "monoisotopic_mass": "1336.8500",
                                "monoisotopic_mz": "669.4323",
                                "intensity": "2087.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.8442",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0057",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "18",
                                "monoisotopic_mass": "647.2972",
                                "monoisotopic_mz": "648.3045",
                                "intensity": "7190.93",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.2949",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0024",
                                        "ppm": "3.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "19",
                                "monoisotopic_mass": "609.2167",
                                "monoisotopic_mz": "610.2239",
                                "intensity": "2010.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "20",
                                "monoisotopic_mass": "1577.8547",
                                "monoisotopic_mz": "789.9346",
                                "intensity": "1117.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0060",
                                        "ppm": "3.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "21",
                                "monoisotopic_mass": "581.3923",
                                "monoisotopic_mz": "582.3995",
                                "intensity": "3732.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "581.3901",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0022",
                                        "ppm": "3.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "22",
                                "monoisotopic_mass": "808.5562",
                                "monoisotopic_mz": "809.5635",
                                "intensity": "1526.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "23",
                                "monoisotopic_mass": "502.3005",
                                "monoisotopic_mz": "503.3078",
                                "intensity": "947.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "24",
                                "monoisotopic_mass": "518.2540",
                                "monoisotopic_mz": "519.2613",
                                "intensity": "8541.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "518.2523",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0018",
                                        "ppm": "3.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "25",
                                "monoisotopic_mass": "629.2868",
                                "monoisotopic_mz": "630.2941",
                                "intensity": "2302.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "26",
                                "monoisotopic_mass": "1059.6005",
                                "monoisotopic_mz": "1060.6078",
                                "intensity": "611.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "27",
                                "monoisotopic_mass": "2786.4480",
                                "monoisotopic_mz": "1394.2313",
                                "intensity": "574.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "247",
                                "peak_id": "28",
                                "monoisotopic_mass": "2444.3114",
                                "monoisotopic_mz": "1223.1630",
                                "intensity": "1436.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0091",
                                        "ppm": "3.72"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "247",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "247",
                                        "peak_id": "16",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "247",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "247",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "247",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "247",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "247",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "247",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "247",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "247",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "247",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "247",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "247",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "spec_id": "247",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "spec_id": "247",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "70",
                "p_value": "9.35e-11",
                "e_value": "9.35e-11",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "575",
                        "ms1_scans": "803",
                        "ids": "227",
                        "scans": "804",
                        "precursor_mono_mass": "4478.3937",
                        "precursor_charge": "6",
                        "precursor_mz": "747.4062",
                        "feature_inte": "1.7789e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "227",
                                "peak_id": "0",
                                "monoisotopic_mass": "1008.4629",
                                "monoisotopic_mz": "1009.4702",
                                "intensity": "5586.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0042",
                                        "ppm": "4.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "1",
                                "monoisotopic_mass": "994.3776",
                                "monoisotopic_mz": "995.3849",
                                "intensity": "1806.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "2",
                                "monoisotopic_mass": "861.3937",
                                "monoisotopic_mz": "862.4009",
                                "intensity": "4607.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0034",
                                        "ppm": "3.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "3",
                                "monoisotopic_mass": "1121.5478",
                                "monoisotopic_mz": "1122.5551",
                                "intensity": "3733.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0051",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "4",
                                "monoisotopic_mass": "1337.5190",
                                "monoisotopic_mz": "1338.5262",
                                "intensity": "1038.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "5",
                                "monoisotopic_mass": "762.3249",
                                "monoisotopic_mz": "763.3322",
                                "intensity": "5926.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0031",
                                        "ppm": "4.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "6",
                                "monoisotopic_mass": "744.4160",
                                "monoisotopic_mz": "745.4233",
                                "intensity": "11713.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "7",
                                "monoisotopic_mass": "1350.6904",
                                "monoisotopic_mz": "1351.6976",
                                "intensity": "2989.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0050",
                                        "ppm": "3.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "8",
                                "monoisotopic_mass": "1107.4632",
                                "monoisotopic_mz": "1108.4705",
                                "intensity": "1422.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "9",
                                "monoisotopic_mass": "647.2977",
                                "monoisotopic_mz": "648.3050",
                                "intensity": "4045.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.2949",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0029",
                                        "ppm": "4.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "10",
                                "monoisotopic_mass": "1249.6426",
                                "monoisotopic_mz": "1250.6499",
                                "intensity": "1596.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0050",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "11",
                                "monoisotopic_mass": "952.3554",
                                "monoisotopic_mz": "953.3627",
                                "intensity": "808.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "12",
                                "monoisotopic_mass": "923.3410",
                                "monoisotopic_mz": "924.3483",
                                "intensity": "997.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "13",
                                "monoisotopic_mass": "1336.8490",
                                "monoisotopic_mz": "669.4318",
                                "intensity": "1682.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.8442",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0047",
                                        "ppm": "3.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "14",
                                "monoisotopic_mass": "837.5832",
                                "monoisotopic_mz": "838.5905",
                                "intensity": "600.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "837.5800",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0032",
                                        "ppm": "3.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "15",
                                "monoisotopic_mass": "783.4867",
                                "monoisotopic_mz": "784.4940",
                                "intensity": "417.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "16",
                                "monoisotopic_mass": "722.4314",
                                "monoisotopic_mz": "723.4387",
                                "intensity": "459.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "17",
                                "monoisotopic_mass": "2098.4702",
                                "monoisotopic_mz": "525.6248",
                                "intensity": "370.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "18",
                                "monoisotopic_mass": "581.3926",
                                "monoisotopic_mz": "582.3999",
                                "intensity": "1774.29",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "581.3901",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0025",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "19",
                                "monoisotopic_mass": "629.2868",
                                "monoisotopic_mz": "630.2941",
                                "intensity": "1584.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "20",
                                "monoisotopic_mass": "518.2541",
                                "monoisotopic_mz": "519.2614",
                                "intensity": "5036.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "518.2523",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0019",
                                        "ppm": "3.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "21",
                                "monoisotopic_mass": "502.3007",
                                "monoisotopic_mz": "503.3080",
                                "intensity": "1090.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "22",
                                "monoisotopic_mass": "546.3275",
                                "monoisotopic_mz": "547.3348",
                                "intensity": "783.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "23",
                                "monoisotopic_mass": "458.2743",
                                "monoisotopic_mz": "459.2816",
                                "intensity": "1771.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "24",
                                "monoisotopic_mass": "1222.4911",
                                "monoisotopic_mz": "1223.4984",
                                "intensity": "452.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "25",
                                "monoisotopic_mass": "482.3237",
                                "monoisotopic_mz": "483.3309",
                                "intensity": "1280.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "482.3217",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0020",
                                        "ppm": "4.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "26",
                                "monoisotopic_mass": "1710.0441",
                                "monoisotopic_mz": "571.0220",
                                "intensity": "740.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "27",
                                "monoisotopic_mass": "5661.9926",
                                "monoisotopic_mz": "809.8634",
                                "intensity": "410.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "227",
                                "peak_id": "28",
                                "monoisotopic_mass": "5950.5138",
                                "monoisotopic_mz": "744.8215",
                                "intensity": "442.70",
                                "charge": "8"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "227",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "227",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "227",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "227",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "227",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "227",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "227",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "227",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "227",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "227",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "spec_id": "227",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "5",
                                        "spec_id": "227",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
