prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "29",
        "sequence_name": "sp|P0A8M6|YEEX_ECOLI",
        "sequence_description": "UPF0265 protein YeeX OS=Escherichia coli (strain K12) OX=83333 GN=yeeX PE=1 SV=1",
        "proteoform_id": "45",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "125",
            "p_value": "3.36e-03",
            "e_value": "3.37e-03",
            "fdr": "0",
            "matched_fragment_number": "14",
            "matched_peak_number": "16",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                    "ms1_ids": "606",
                    "ms1_scans": "927",
                    "ids": "320",
                    "scans": "928",
                    "precursor_mono_mass": "10472.1750",
                    "precursor_charge": "10",
                    "precursor_mz": "1048.2248",
                    "feature_inte": "1.1755e+07"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "320",
                            "peak_id": "0",
                            "monoisotopic_mass": "1196.6471",
                            "monoisotopic_mz": "1197.6544",
                            "intensity": "1192.95",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "1",
                            "monoisotopic_mass": "1542.8824",
                            "monoisotopic_mz": "1543.8896",
                            "intensity": "6491.57",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "2",
                            "monoisotopic_mass": "823.4955",
                            "monoisotopic_mz": "824.5027",
                            "intensity": "8198.49",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "3",
                            "monoisotopic_mass": "1301.7051",
                            "monoisotopic_mz": "1302.7124",
                            "intensity": "10085.72",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "4",
                            "monoisotopic_mass": "1121.6114",
                            "monoisotopic_mz": "1122.6187",
                            "intensity": "1256.58",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "5",
                            "monoisotopic_mass": "1386.7931",
                            "monoisotopic_mz": "1387.8004",
                            "intensity": "8656.31",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "6",
                            "monoisotopic_mass": "1414.7883",
                            "monoisotopic_mz": "1415.7955",
                            "intensity": "16460.87",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "7",
                            "monoisotopic_mass": "1431.8155",
                            "monoisotopic_mz": "1432.8228",
                            "intensity": "4735.00",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "8",
                            "monoisotopic_mass": "2062.1632",
                            "monoisotopic_mz": "1032.0889",
                            "intensity": "9598.41",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2062.1535",
                                    "ion_position": "72",
                                    "ion_display_position": "17",
                                    "ion_sort_name": "Y00017",
                                    "ion_left_position": "72",
                                    "mass_error": "0.0097",
                                    "ppm": "4.72"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "9",
                            "monoisotopic_mass": "2640.4581",
                            "monoisotopic_mz": "881.1600",
                            "intensity": "31048.56",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "10",
                            "monoisotopic_mass": "2177.1913",
                            "monoisotopic_mz": "1089.6029",
                            "intensity": "5809.39",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2177.1804",
                                    "ion_position": "71",
                                    "ion_display_position": "18",
                                    "ion_sort_name": "Y00018",
                                    "ion_left_position": "71",
                                    "mass_error": "0.0109",
                                    "ppm": "4.99"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "11",
                            "monoisotopic_mass": "2214.1825",
                            "monoisotopic_mz": "1108.0985",
                            "intensity": "6315.81",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "12",
                            "monoisotopic_mass": "1138.6402",
                            "monoisotopic_mz": "1139.6475",
                            "intensity": "20653.09",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "13",
                            "monoisotopic_mass": "3126.5804",
                            "monoisotopic_mz": "1043.2007",
                            "intensity": "6633.66",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3126.5582",
                                    "ion_position": "63",
                                    "ion_display_position": "26",
                                    "ion_sort_name": "Y00026",
                                    "ion_left_position": "63",
                                    "mass_error": "0.0222",
                                    "ppm": "7.10"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "14",
                            "monoisotopic_mass": "2547.3895",
                            "monoisotopic_mz": "1274.7020",
                            "intensity": "3145.63",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2547.3769",
                                    "ion_position": "68",
                                    "ion_display_position": "21",
                                    "ion_sort_name": "Y00021",
                                    "ion_left_position": "68",
                                    "mass_error": "0.0126",
                                    "ppm": "4.96"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "15",
                            "monoisotopic_mass": "3656.8641",
                            "monoisotopic_mz": "1219.9620",
                            "intensity": "15213.88",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3656.8468",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "ion_sort_name": "Y00031",
                                    "ion_left_position": "58",
                                    "mass_error": "0.0173",
                                    "ppm": "4.73"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "16",
                            "monoisotopic_mass": "936.5802",
                            "monoisotopic_mz": "937.5875",
                            "intensity": "3898.96",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "17",
                            "monoisotopic_mass": "2954.5231",
                            "monoisotopic_mz": "985.8483",
                            "intensity": "5890.27",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2954.5098",
                                    "ion_position": "65",
                                    "ion_display_position": "24",
                                    "ion_sort_name": "Y00024",
                                    "ion_left_position": "65",
                                    "mass_error": "0.0134",
                                    "ppm": "4.52"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "18",
                            "monoisotopic_mass": "1481.6142",
                            "monoisotopic_mz": "1482.6215",
                            "intensity": "1441.57",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "19",
                            "monoisotopic_mass": "3543.7800",
                            "monoisotopic_mz": "1182.2673",
                            "intensity": "16181.73",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3543.7628",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "ion_sort_name": "Y00030",
                                    "ion_left_position": "59",
                                    "mass_error": "0.0173",
                                    "ppm": "4.88"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "20",
                            "monoisotopic_mass": "671.2980",
                            "monoisotopic_mz": "672.3053",
                            "intensity": "3626.92",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "21",
                            "monoisotopic_mass": "1338.6930",
                            "monoisotopic_mz": "1339.7003",
                            "intensity": "1446.66",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "22",
                            "monoisotopic_mass": "1464.9074",
                            "monoisotopic_mz": "1465.9147",
                            "intensity": "1247.45",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "23",
                            "monoisotopic_mass": "3472.7362",
                            "monoisotopic_mz": "1158.5860",
                            "intensity": "10910.41",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3472.7256",
                                    "ion_position": "60",
                                    "ion_display_position": "29",
                                    "ion_sort_name": "Y00029",
                                    "ion_left_position": "60",
                                    "mass_error": "0.0106",
                                    "ppm": "3.05"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "24",
                            "monoisotopic_mass": "709.4521",
                            "monoisotopic_mz": "710.4593",
                            "intensity": "8587.22",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "25",
                            "monoisotopic_mass": "2493.4037",
                            "monoisotopic_mz": "832.1418",
                            "intensity": "5570.28",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "26",
                            "monoisotopic_mass": "3344.6488",
                            "monoisotopic_mz": "1115.8902",
                            "intensity": "3845.63",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "27",
                            "monoisotopic_mass": "2505.4110",
                            "monoisotopic_mz": "1253.7128",
                            "intensity": "3012.75",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "28",
                            "monoisotopic_mass": "799.3939",
                            "monoisotopic_mz": "800.4011",
                            "intensity": "2615.54",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "29",
                            "monoisotopic_mass": "1915.0381",
                            "monoisotopic_mz": "958.5263",
                            "intensity": "3356.17",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "30",
                            "monoisotopic_mass": "728.3554",
                            "monoisotopic_mz": "729.3627",
                            "intensity": "2650.92",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "31",
                            "monoisotopic_mass": "3454.7252",
                            "monoisotopic_mz": "1152.5824",
                            "intensity": "2630.55",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "32",
                            "monoisotopic_mass": "3197.5667",
                            "monoisotopic_mz": "1066.8628",
                            "intensity": "1119.46",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "33",
                            "monoisotopic_mass": "1248.6254",
                            "monoisotopic_mz": "1249.6327",
                            "intensity": "1256.00",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "34",
                            "monoisotopic_mass": "3527.7660",
                            "monoisotopic_mz": "1176.9293",
                            "intensity": "7038.72",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "35",
                            "monoisotopic_mass": "2143.1461",
                            "monoisotopic_mz": "1072.5803",
                            "intensity": "3919.68",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "36",
                            "monoisotopic_mass": "3955.0279",
                            "monoisotopic_mz": "1319.3499",
                            "intensity": "6363.18",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3955.0109",
                                    "ion_position": "55",
                                    "ion_display_position": "34",
                                    "ion_sort_name": "Y00034",
                                    "ion_left_position": "55",
                                    "mass_error": "0.0170",
                                    "ppm": "4.30"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "37",
                            "monoisotopic_mass": "3415.6839",
                            "monoisotopic_mz": "1139.5686",
                            "intensity": "5256.44",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "38",
                            "monoisotopic_mass": "2623.4315",
                            "monoisotopic_mz": "875.4844",
                            "intensity": "2847.35",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "39",
                            "monoisotopic_mass": "600.2610",
                            "monoisotopic_mz": "601.2683",
                            "intensity": "2470.80",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "40",
                            "monoisotopic_mass": "3938.0105",
                            "monoisotopic_mz": "1313.6774",
                            "intensity": "7413.79",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "41",
                            "monoisotopic_mass": "4069.1172",
                            "monoisotopic_mz": "1357.3797",
                            "intensity": "3384.61",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "42",
                            "monoisotopic_mass": "4138.1542",
                            "monoisotopic_mz": "1380.3920",
                            "intensity": "2447.26",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "43",
                            "monoisotopic_mass": "3698.8758",
                            "monoisotopic_mz": "1233.9659",
                            "intensity": "4905.32",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "44",
                            "monoisotopic_mass": "2098.0318",
                            "monoisotopic_mz": "1050.0232",
                            "intensity": "6245.82",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "45",
                            "monoisotopic_mass": "3826.9669",
                            "monoisotopic_mz": "1276.6629",
                            "intensity": "13261.90",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3826.9524",
                                    "ion_position": "56",
                                    "ion_display_position": "33",
                                    "ion_sort_name": "Y00033",
                                    "ion_left_position": "56",
                                    "mass_error": "0.0145",
                                    "ppm": "3.80"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "46",
                            "monoisotopic_mass": "3919.9900",
                            "monoisotopic_mz": "1307.6706",
                            "intensity": "3828.47",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "47",
                            "monoisotopic_mass": "936.5791",
                            "monoisotopic_mz": "469.2968",
                            "intensity": "1832.28",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "48",
                            "monoisotopic_mass": "1064.4098",
                            "monoisotopic_mz": "1065.4171",
                            "intensity": "742.34",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "49",
                            "monoisotopic_mass": "613.3097",
                            "monoisotopic_mz": "614.3170",
                            "intensity": "1634.13",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "50",
                            "monoisotopic_mass": "999.8280",
                            "monoisotopic_mz": "1000.8353",
                            "intensity": "1863.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "51",
                            "monoisotopic_mass": "761.4492",
                            "monoisotopic_mz": "762.4565",
                            "intensity": "982.18",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "52",
                            "monoisotopic_mass": "908.5845",
                            "monoisotopic_mz": "909.5918",
                            "intensity": "1022.18",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "53",
                            "monoisotopic_mass": "1706.0522",
                            "monoisotopic_mz": "854.0334",
                            "intensity": "630.98",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "54",
                            "monoisotopic_mass": "2280.1981",
                            "monoisotopic_mz": "1141.1063",
                            "intensity": "2722.03",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "55",
                            "monoisotopic_mass": "3254.6689",
                            "monoisotopic_mz": "1085.8969",
                            "intensity": "6119.83",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3254.6531",
                                    "ion_position": "62",
                                    "ion_display_position": "27",
                                    "ion_sort_name": "Y00027",
                                    "ion_left_position": "62",
                                    "mass_error": "0.0157",
                                    "ppm": "4.84"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "56",
                            "monoisotopic_mass": "1446.5644",
                            "monoisotopic_mz": "724.2895",
                            "intensity": "381.13",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "57",
                            "monoisotopic_mass": "3809.9498",
                            "monoisotopic_mz": "1270.9906",
                            "intensity": "5140.84",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "58",
                            "monoisotopic_mass": "3639.8489",
                            "monoisotopic_mz": "1214.2902",
                            "intensity": "5204.73",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "59",
                            "monoisotopic_mass": "4122.1380",
                            "monoisotopic_mz": "1375.0533",
                            "intensity": "1246.65",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "60",
                            "monoisotopic_mass": "2662.4154",
                            "monoisotopic_mz": "888.4791",
                            "intensity": "2147.94",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2662.4038",
                                    "ion_position": "67",
                                    "ion_display_position": "22",
                                    "ion_sort_name": "Y00022",
                                    "ion_left_position": "67",
                                    "mass_error": "0.0115",
                                    "ppm": "4.32"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "61",
                            "monoisotopic_mass": "3109.5523",
                            "monoisotopic_mz": "1037.5247",
                            "intensity": "2340.77",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "62",
                            "monoisotopic_mass": "2936.5033",
                            "monoisotopic_mz": "1469.2589",
                            "intensity": "2749.88",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "63",
                            "monoisotopic_mass": "4267.1923",
                            "monoisotopic_mz": "1423.4047",
                            "intensity": "2484.19",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "64",
                            "monoisotopic_mass": "3509.7452",
                            "monoisotopic_mz": "1170.9223",
                            "intensity": "2426.62",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "65",
                            "monoisotopic_mass": "2902.1057",
                            "monoisotopic_mz": "968.3758",
                            "intensity": "1440.68",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "66",
                            "monoisotopic_mass": "2547.3903",
                            "monoisotopic_mz": "850.1374",
                            "intensity": "1807.30",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2547.3769",
                                    "ion_position": "68",
                                    "ion_display_position": "21",
                                    "ion_sort_name": "Y00021",
                                    "ion_left_position": "68",
                                    "mass_error": "0.0134",
                                    "ppm": "5.27"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "67",
                            "monoisotopic_mass": "2737.3481",
                            "monoisotopic_mz": "913.4567",
                            "intensity": "1530.62",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "68",
                            "monoisotopic_mass": "2378.3767",
                            "monoisotopic_mz": "793.7995",
                            "intensity": "632.64",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "69",
                            "monoisotopic_mass": "1950.9395",
                            "monoisotopic_mz": "976.4770",
                            "intensity": "641.35",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "70",
                            "monoisotopic_mass": "5227.2588",
                            "monoisotopic_mz": "1046.4590",
                            "intensity": "1329.65",
                            "charge": "5"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "71",
                            "monoisotopic_mass": "8879.4793",
                            "monoisotopic_mz": "888.9552",
                            "intensity": "525.83",
                            "charge": "10"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "72",
                            "monoisotopic_mass": "9249.7049",
                            "monoisotopic_mz": "925.9778",
                            "intensity": "682.43",
                            "charge": "10"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "73",
                            "monoisotopic_mass": "9589.9244",
                            "monoisotopic_mz": "959.9997",
                            "intensity": "1467.50",
                            "charge": "10"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "74",
                            "monoisotopic_mass": "2825.4226",
                            "monoisotopic_mz": "942.8148",
                            "intensity": "2092.16",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "75",
                            "monoisotopic_mass": "3237.6448",
                            "monoisotopic_mz": "1080.2222",
                            "intensity": "1040.79",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "76",
                            "monoisotopic_mass": "2459.1615",
                            "monoisotopic_mz": "820.7278",
                            "intensity": "900.68",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "77",
                            "monoisotopic_mass": "6161.8026",
                            "monoisotopic_mz": "881.2648",
                            "intensity": "875.48",
                            "charge": "7"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "78",
                            "monoisotopic_mass": "6172.7618",
                            "monoisotopic_mz": "882.8304",
                            "intensity": "651.01",
                            "charge": "7"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "79",
                            "monoisotopic_mass": "6351.6690",
                            "monoisotopic_mz": "908.3886",
                            "intensity": "1473.14",
                            "charge": "7"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "80",
                            "monoisotopic_mass": "2954.5312",
                            "monoisotopic_mz": "1478.2729",
                            "intensity": "2095.03",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2954.5098",
                                    "ion_position": "65",
                                    "ion_display_position": "24",
                                    "ion_sort_name": "Y00024",
                                    "ion_left_position": "65",
                                    "mass_error": "0.0215",
                                    "ppm": "7.27"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "81",
                            "monoisotopic_mass": "4252.1762",
                            "monoisotopic_mz": "1418.3993",
                            "intensity": "1967.52",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "82",
                            "monoisotopic_mass": "7646.7105",
                            "monoisotopic_mz": "850.6418",
                            "intensity": "509.37",
                            "charge": "9"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "83",
                            "monoisotopic_mass": "3472.7700",
                            "monoisotopic_mz": "869.1998",
                            "intensity": "494.73",
                            "charge": "4"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "84",
                            "monoisotopic_mass": "3430.9464",
                            "monoisotopic_mz": "858.7439",
                            "intensity": "561.24",
                            "charge": "4"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "85",
                            "monoisotopic_mass": "2176.1852",
                            "monoisotopic_mz": "2177.1925",
                            "intensity": "951.89",
                            "charge": "1"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "86",
                            "monoisotopic_mass": "5208.2124",
                            "monoisotopic_mz": "869.0427",
                            "intensity": "424.87",
                            "charge": "6"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "87",
                            "monoisotopic_mass": "3384.7053",
                            "monoisotopic_mz": "1129.2424",
                            "intensity": "3584.23",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "88",
                            "monoisotopic_mass": "5963.6642",
                            "monoisotopic_mz": "852.9593",
                            "intensity": "1342.28",
                            "charge": "7"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "89",
                            "monoisotopic_mass": "2396.2787",
                            "monoisotopic_mz": "799.7668",
                            "intensity": "580.51",
                            "charge": "3"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "90",
                            "monoisotopic_mass": "1863.9617",
                            "monoisotopic_mz": "932.9881",
                            "intensity": "1009.71",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "91",
                            "monoisotopic_mass": "5487.3768",
                            "monoisotopic_mz": "915.5701",
                            "intensity": "510.06",
                            "charge": "6"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "92",
                            "monoisotopic_mass": "2529.3718",
                            "monoisotopic_mz": "1265.6932",
                            "intensity": "1942.50",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "93",
                            "monoisotopic_mass": "2013.0974",
                            "monoisotopic_mz": "1007.5560",
                            "intensity": "1449.20",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "94",
                            "monoisotopic_mass": "2159.1706",
                            "monoisotopic_mz": "1080.5926",
                            "intensity": "1666.94",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "95",
                            "monoisotopic_mass": "4837.5795",
                            "monoisotopic_mz": "807.2705",
                            "intensity": "573.10",
                            "charge": "6"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "96",
                            "monoisotopic_mass": "3525.2032",
                            "monoisotopic_mz": "882.3081",
                            "intensity": "680.72",
                            "charge": "4"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "97",
                            "monoisotopic_mass": "1933.0657",
                            "monoisotopic_mz": "967.5401",
                            "intensity": "2317.38",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "98",
                            "monoisotopic_mass": "8324.4943",
                            "monoisotopic_mz": "833.4567",
                            "intensity": "641.85",
                            "charge": "10"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "99",
                            "monoisotopic_mass": "2048.0910",
                            "monoisotopic_mz": "1025.0528",
                            "intensity": "1401.63",
                            "charge": "2"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "100",
                            "monoisotopic_mass": "7681.9736",
                            "monoisotopic_mz": "769.2046",
                            "intensity": "690.92",
                            "charge": "10",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "-94.2587685724",
                                    "theoretical_mass": "7680.9336",
                                    "ion_position": "66",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "B00066",
                                    "ion_left_position": "66",
                                    "mass_error": "0.0376",
                                    "ppm": "4.90"
                                }
                            }
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "101",
                            "monoisotopic_mass": "7505.6791",
                            "monoisotopic_mz": "939.2172",
                            "intensity": "457.89",
                            "charge": "8"
                        },
                        {
                            "spec_id": "320",
                            "peak_id": "102",
                            "monoisotopic_mass": "7540.6800",
                            "monoisotopic_mz": "838.8606",
                            "intensity": "775.15",
                            "charge": "9",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "-94.2587685724",
                                    "theoretical_mass": "7541.7445",
                                    "ion_position": "23",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "Y00066",
                                    "ion_left_position": "23",
                                    "mass_error": "-0.0622",
                                    "ppm": "-8.25"
                                }
                            }
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "29",
                "proteoform_id": "45",
                "sequence_name": "sp|P0A8M6|YEEX_ECOLI",
                "sequence_description": "UPF0265 protein YeeX OS=Escherichia coli (strain K12) OX=83333 GN=yeeX PE=1 SV=1",
                "proteoform_mass": "10472.3800",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "109",
                    "first_residue_position": "6",
                    "last_residue_position": "94",
                    "annotated_seq": "P.SFQDVLEFVRLFRRKNKLQREIQ(DVEKKIRDNQKRVLLLDNLSDYIKPGMSVEAI)[-94.2588]QGIIASMKGDYEDRVDDYIIKNAELSKERRDISK.K",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "E"
                        },
                        {
                            "position": "2",
                            "acid": "T"
                        },
                        {
                            "position": "3",
                            "acid": "T"
                        },
                        {
                            "position": "4",
                            "acid": "K"
                        },
                        {
                            "position": "5",
                            "acid": "P"
                        },
                        {
                            "position": "6",
                            "acid": "S"
                        },
                        {
                            "position": "7",
                            "acid": "F"
                        },
                        {
                            "position": "8",
                            "acid": "Q"
                        },
                        {
                            "position": "9",
                            "acid": "D"
                        },
                        {
                            "position": "10",
                            "acid": "V"
                        },
                        {
                            "position": "11",
                            "acid": "L"
                        },
                        {
                            "position": "12",
                            "acid": "E"
                        },
                        {
                            "position": "13",
                            "acid": "F"
                        },
                        {
                            "position": "14",
                            "acid": "V"
                        },
                        {
                            "position": "15",
                            "acid": "R"
                        },
                        {
                            "position": "16",
                            "acid": "L"
                        },
                        {
                            "position": "17",
                            "acid": "F"
                        },
                        {
                            "position": "18",
                            "acid": "R"
                        },
                        {
                            "position": "19",
                            "acid": "R"
                        },
                        {
                            "position": "20",
                            "acid": "K"
                        },
                        {
                            "position": "21",
                            "acid": "N"
                        },
                        {
                            "position": "22",
                            "acid": "K"
                        },
                        {
                            "position": "23",
                            "acid": "L"
                        },
                        {
                            "position": "24",
                            "acid": "Q"
                        },
                        {
                            "position": "25",
                            "acid": "R"
                        },
                        {
                            "position": "26",
                            "acid": "E"
                        },
                        {
                            "position": "27",
                            "acid": "I"
                        },
                        {
                            "position": "28",
                            "acid": "Q"
                        },
                        {
                            "position": "29",
                            "acid": "D"
                        },
                        {
                            "position": "30",
                            "acid": "V"
                        },
                        {
                            "position": "31",
                            "acid": "E"
                        },
                        {
                            "position": "32",
                            "acid": "K"
                        },
                        {
                            "position": "33",
                            "acid": "K"
                        },
                        {
                            "position": "34",
                            "acid": "I"
                        },
                        {
                            "position": "35",
                            "acid": "R"
                        },
                        {
                            "position": "36",
                            "acid": "D"
                        },
                        {
                            "position": "37",
                            "acid": "N"
                        },
                        {
                            "position": "38",
                            "acid": "Q"
                        },
                        {
                            "position": "39",
                            "acid": "K"
                        },
                        {
                            "position": "40",
                            "acid": "R"
                        },
                        {
                            "position": "41",
                            "acid": "V"
                        },
                        {
                            "position": "42",
                            "acid": "L"
                        },
                        {
                            "position": "43",
                            "acid": "L"
                        },
                        {
                            "position": "44",
                            "acid": "L"
                        },
                        {
                            "position": "45",
                            "acid": "D"
                        },
                        {
                            "position": "46",
                            "acid": "N"
                        },
                        {
                            "position": "47",
                            "acid": "L"
                        },
                        {
                            "position": "48",
                            "acid": "S"
                        },
                        {
                            "position": "49",
                            "acid": "D"
                        },
                        {
                            "position": "50",
                            "acid": "Y"
                        },
                        {
                            "position": "51",
                            "acid": "I"
                        },
                        {
                            "position": "52",
                            "acid": "K"
                        },
                        {
                            "position": "53",
                            "acid": "P"
                        },
                        {
                            "position": "54",
                            "acid": "G"
                        },
                        {
                            "position": "55",
                            "acid": "M"
                        },
                        {
                            "position": "56",
                            "acid": "S"
                        },
                        {
                            "position": "57",
                            "acid": "V"
                        },
                        {
                            "position": "58",
                            "acid": "E"
                        },
                        {
                            "position": "59",
                            "acid": "A"
                        },
                        {
                            "position": "60",
                            "acid": "I"
                        },
                        {
                            "position": "61",
                            "acid": "Q"
                        },
                        {
                            "position": "62",
                            "acid": "G"
                        },
                        {
                            "position": "63",
                            "acid": "I"
                        },
                        {
                            "position": "64",
                            "acid": "I"
                        },
                        {
                            "position": "65",
                            "acid": "A"
                        },
                        {
                            "position": "66",
                            "acid": "S"
                        },
                        {
                            "position": "67",
                            "acid": "M"
                        },
                        {
                            "position": "68",
                            "acid": "K"
                        },
                        {
                            "position": "69",
                            "acid": "G"
                        },
                        {
                            "position": "70",
                            "acid": "D"
                        },
                        {
                            "position": "71",
                            "acid": "Y"
                        },
                        {
                            "position": "72",
                            "acid": "E"
                        },
                        {
                            "position": "73",
                            "acid": "D"
                        },
                        {
                            "position": "74",
                            "acid": "R"
                        },
                        {
                            "position": "75",
                            "acid": "V"
                        },
                        {
                            "position": "76",
                            "acid": "D"
                        },
                        {
                            "position": "77",
                            "acid": "D"
                        },
                        {
                            "position": "78",
                            "acid": "Y"
                        },
                        {
                            "position": "79",
                            "acid": "I"
                        },
                        {
                            "position": "80",
                            "acid": "I"
                        },
                        {
                            "position": "81",
                            "acid": "K"
                        },
                        {
                            "position": "82",
                            "acid": "N"
                        },
                        {
                            "position": "83",
                            "acid": "A"
                        },
                        {
                            "position": "84",
                            "acid": "E"
                        },
                        {
                            "position": "85",
                            "acid": "L"
                        },
                        {
                            "position": "86",
                            "acid": "S"
                        },
                        {
                            "position": "87",
                            "acid": "K"
                        },
                        {
                            "position": "88",
                            "acid": "E"
                        },
                        {
                            "position": "89",
                            "acid": "R"
                        },
                        {
                            "position": "90",
                            "acid": "R"
                        },
                        {
                            "position": "91",
                            "acid": "D"
                        },
                        {
                            "position": "92",
                            "acid": "I"
                        },
                        {
                            "position": "93",
                            "acid": "S"
                        },
                        {
                            "position": "94",
                            "acid": "K"
                        },
                        {
                            "position": "95",
                            "acid": "K"
                        },
                        {
                            "position": "96",
                            "acid": "L"
                        },
                        {
                            "position": "97",
                            "acid": "K"
                        },
                        {
                            "position": "98",
                            "acid": "A"
                        },
                        {
                            "position": "99",
                            "acid": "M"
                        },
                        {
                            "position": "100",
                            "acid": "G"
                        },
                        {
                            "position": "101",
                            "acid": "E"
                        },
                        {
                            "position": "102",
                            "acid": "M"
                        },
                        {
                            "position": "103",
                            "acid": "K"
                        },
                        {
                            "position": "104",
                            "acid": "N"
                        },
                        {
                            "position": "105",
                            "acid": "G"
                        },
                        {
                            "position": "106",
                            "acid": "E"
                        },
                        {
                            "position": "107",
                            "acid": "A"
                        },
                        {
                            "position": "108",
                            "acid": "K"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "23",
                                    "ion_display_position": "66",
                                    "spec_id": "320",
                                    "peak_id": "102",
                                    "peak_charge": "9"
                                }
                            }
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "34",
                                    "spec_id": "320",
                                    "peak_id": "36",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "56",
                                    "ion_display_position": "33",
                                    "spec_id": "320",
                                    "peak_id": "45",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "320",
                                    "peak_id": "15",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "320",
                                    "peak_id": "19",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "60",
                                    "ion_display_position": "29",
                                    "spec_id": "320",
                                    "peak_id": "23",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "62",
                                    "ion_display_position": "27",
                                    "spec_id": "320",
                                    "peak_id": "55",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "63",
                                    "ion_display_position": "26",
                                    "spec_id": "320",
                                    "peak_id": "13",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "24",
                                        "spec_id": "320",
                                        "peak_id": "17",
                                        "peak_charge": "3"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "24",
                                        "spec_id": "320",
                                        "peak_id": "80",
                                        "peak_charge": "2"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "66",
                                    "ion_display_position": "66",
                                    "spec_id": "320",
                                    "peak_id": "100",
                                    "peak_charge": "10"
                                }
                            }
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "67",
                                    "ion_display_position": "22",
                                    "spec_id": "320",
                                    "peak_id": "60",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "21",
                                        "spec_id": "320",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "21",
                                        "spec_id": "320",
                                        "peak_id": "66",
                                        "peak_charge": "3"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "71",
                                    "ion_display_position": "18",
                                    "spec_id": "320",
                                    "peak_id": "10",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "72",
                                    "ion_display_position": "17",
                                    "spec_id": "320",
                                    "peak_id": "8",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "29",
                        "right_position": "61",
                        "shift": "-94.2587685724",
                        "anno": "-94.2588",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
