prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "17",
        "sequence_name": "sp|P0A6E6|ATPE_ECOLI",
        "sequence_description": "ATP synthase epsilon chain OS=Escherichia coli (strain K12) OX=83333 GN=atpC PE=1 SV=2",
        "proteoform_id": "41",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "96",
            "p_value": "7.07e-04",
            "e_value": "7.07e-04",
            "fdr": "0",
            "matched_fragment_number": "9",
            "matched_peak_number": "9",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                    "ms1_ids": "588",
                    "ms1_scans": "855",
                    "ids": "268",
                    "scans": "858",
                    "precursor_mono_mass": "7473.2879",
                    "precursor_charge": "4",
                    "precursor_mz": "1869.3292",
                    "feature_inte": "4.1144e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "268",
                            "peak_id": "0",
                            "monoisotopic_mass": "2717.5342",
                            "monoisotopic_mz": "2718.5414",
                            "intensity": "3344.85",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "1",
                            "monoisotopic_mass": "1316.6141",
                            "monoisotopic_mz": "1317.6213",
                            "intensity": "2084.58",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1316.6071",
                                    "ion_position": "12",
                                    "ion_display_position": "12",
                                    "ion_sort_name": "B00012",
                                    "ion_left_position": "12",
                                    "mass_error": "0.0070",
                                    "ppm": "5.30"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "2",
                            "monoisotopic_mass": "1338.6175",
                            "monoisotopic_mz": "1339.6248",
                            "intensity": "2299.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "3",
                            "monoisotopic_mass": "1569.1934",
                            "monoisotopic_mz": "1570.2007",
                            "intensity": "1891.78",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "4",
                            "monoisotopic_mass": "2069.7440",
                            "monoisotopic_mz": "2070.7513",
                            "intensity": "1350.50",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "5",
                            "monoisotopic_mass": "930.4309",
                            "monoisotopic_mz": "931.4382",
                            "intensity": "3785.15",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "930.4269",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "B00008",
                                    "ion_left_position": "8",
                                    "mass_error": "0.0040",
                                    "ppm": "4.25"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "6",
                            "monoisotopic_mass": "1029.4999",
                            "monoisotopic_mz": "1030.5072",
                            "intensity": "3480.82",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1029.4954",
                                    "ion_position": "9",
                                    "ion_display_position": "9",
                                    "ion_sort_name": "B00009",
                                    "ion_left_position": "9",
                                    "mass_error": "0.0046",
                                    "ppm": "4.45"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "7",
                            "monoisotopic_mass": "3660.2604",
                            "monoisotopic_mz": "1831.1375",
                            "intensity": "5366.32",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "8",
                            "monoisotopic_mass": "831.3620",
                            "monoisotopic_mz": "832.3693",
                            "intensity": "4308.94",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "831.3585",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "B00007",
                                    "ion_left_position": "7",
                                    "mass_error": "0.0035",
                                    "ppm": "4.17"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "9",
                            "monoisotopic_mass": "1648.0153",
                            "monoisotopic_mz": "1649.0226",
                            "intensity": "2233.49",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "10",
                            "monoisotopic_mass": "637.3464",
                            "monoisotopic_mz": "638.3537",
                            "intensity": "1432.95",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "11",
                            "monoisotopic_mass": "716.3346",
                            "monoisotopic_mz": "717.3419",
                            "intensity": "1861.45",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "716.3316",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "ion_sort_name": "B00006",
                                    "ion_left_position": "6",
                                    "mass_error": "0.0031",
                                    "ppm": "4.27"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "12",
                            "monoisotopic_mass": "1338.6161",
                            "monoisotopic_mz": "670.3153",
                            "intensity": "2731.92",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "13",
                            "monoisotopic_mass": "603.2497",
                            "monoisotopic_mz": "604.2570",
                            "intensity": "2375.26",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "603.2475",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "ion_sort_name": "B00005",
                                    "ion_left_position": "5",
                                    "mass_error": "0.0022",
                                    "ppm": "3.68"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "14",
                            "monoisotopic_mass": "575.2549",
                            "monoisotopic_mz": "576.2621",
                            "intensity": "1939.70",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "15",
                            "monoisotopic_mass": "3067.8926",
                            "monoisotopic_mz": "1534.9536",
                            "intensity": "1804.26",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "16",
                            "monoisotopic_mass": "2863.7614",
                            "monoisotopic_mz": "1432.8880",
                            "intensity": "1547.91",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "17",
                            "monoisotopic_mass": "3696.2543",
                            "monoisotopic_mz": "1849.1344",
                            "intensity": "3248.74",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "18",
                            "monoisotopic_mass": "969.4916",
                            "monoisotopic_mz": "970.4988",
                            "intensity": "775.57",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "19",
                            "monoisotopic_mass": "2930.6185",
                            "monoisotopic_mz": "2931.6258",
                            "intensity": "2161.51",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "20",
                            "monoisotopic_mass": "1985.7673",
                            "monoisotopic_mz": "1986.7746",
                            "intensity": "1465.28",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "21",
                            "monoisotopic_mass": "2936.5094",
                            "monoisotopic_mz": "1469.2620",
                            "intensity": "1276.31",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "22",
                            "monoisotopic_mass": "5529.4066",
                            "monoisotopic_mz": "1844.1428",
                            "intensity": "4675.24",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "23",
                            "monoisotopic_mass": "688.3397",
                            "monoisotopic_mz": "689.3469",
                            "intensity": "862.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "24",
                            "monoisotopic_mass": "2635.3463",
                            "monoisotopic_mz": "1318.6804",
                            "intensity": "665.00",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "25",
                            "monoisotopic_mass": "1728.8705",
                            "monoisotopic_mz": "1729.8778",
                            "intensity": "1293.01",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "26",
                            "monoisotopic_mass": "1685.0116",
                            "monoisotopic_mz": "1686.0189",
                            "intensity": "1301.52",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "27",
                            "monoisotopic_mass": "3047.8694",
                            "monoisotopic_mz": "1524.9420",
                            "intensity": "1878.63",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "28",
                            "monoisotopic_mass": "1787.9760",
                            "monoisotopic_mz": "1788.9833",
                            "intensity": "1396.34",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "29",
                            "monoisotopic_mass": "1497.9183",
                            "monoisotopic_mz": "1498.9255",
                            "intensity": "1612.28",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "30",
                            "monoisotopic_mass": "2887.5193",
                            "monoisotopic_mz": "963.5137",
                            "intensity": "1394.94",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "31",
                            "monoisotopic_mass": "1294.4354",
                            "monoisotopic_mz": "1295.4427",
                            "intensity": "658.55",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "32",
                            "monoisotopic_mass": "1600.9883",
                            "monoisotopic_mz": "1601.9956",
                            "intensity": "1401.54",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "33",
                            "monoisotopic_mass": "3557.6447",
                            "monoisotopic_mz": "1779.8296",
                            "intensity": "3073.09",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "34",
                            "monoisotopic_mass": "4993.6343",
                            "monoisotopic_mz": "1665.5520",
                            "intensity": "6503.83",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "4993.6528",
                                    "ion_position": "27",
                                    "ion_display_position": "46",
                                    "ion_sort_name": "Y00046",
                                    "ion_left_position": "27",
                                    "mass_error": "-0.0185",
                                    "ppm": "-3.70"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "35",
                            "monoisotopic_mass": "1216.3100",
                            "monoisotopic_mz": "1217.3173",
                            "intensity": "760.35",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "36",
                            "monoisotopic_mass": "5949.6156",
                            "monoisotopic_mz": "1488.4112",
                            "intensity": "646.91",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "37",
                            "monoisotopic_mass": "4878.9071",
                            "monoisotopic_mz": "1627.3096",
                            "intensity": "1018.13",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "38",
                            "monoisotopic_mass": "2237.0580",
                            "monoisotopic_mz": "1119.5363",
                            "intensity": "688.08",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "39",
                            "monoisotopic_mass": "6128.0725",
                            "monoisotopic_mz": "1533.0254",
                            "intensity": "1661.80",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "40",
                            "monoisotopic_mass": "5869.0496",
                            "monoisotopic_mz": "1468.2697",
                            "intensity": "1370.46",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "41",
                            "monoisotopic_mass": "5678.6764",
                            "monoisotopic_mz": "1893.8994",
                            "intensity": "1483.75",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "42",
                            "monoisotopic_mass": "3590.3470",
                            "monoisotopic_mz": "1796.1808",
                            "intensity": "1666.33",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "43",
                            "monoisotopic_mass": "1427.8860",
                            "monoisotopic_mz": "1428.8933",
                            "intensity": "473.10",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "44",
                            "monoisotopic_mass": "1809.5525",
                            "monoisotopic_mz": "1810.5597",
                            "intensity": "2009.49",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "45",
                            "monoisotopic_mass": "5251.7613",
                            "monoisotopic_mz": "1751.5944",
                            "intensity": "3199.52",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5250.7904",
                                    "ion_position": "24",
                                    "ion_display_position": "49",
                                    "ion_sort_name": "Y00049",
                                    "ion_left_position": "24",
                                    "mass_error": "-0.0314",
                                    "ppm": "-5.99"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "46",
                            "monoisotopic_mass": "1705.2382",
                            "monoisotopic_mz": "1706.2455",
                            "intensity": "2000.18",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "47",
                            "monoisotopic_mass": "1849.8520",
                            "monoisotopic_mz": "1850.8593",
                            "intensity": "2010.37",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "48",
                            "monoisotopic_mass": "1893.9882",
                            "monoisotopic_mz": "1894.9955",
                            "intensity": "1446.70",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "49",
                            "monoisotopic_mass": "2979.8295",
                            "monoisotopic_mz": "1490.9220",
                            "intensity": "1445.03",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "50",
                            "monoisotopic_mass": "3534.7025",
                            "monoisotopic_mz": "1768.3585",
                            "intensity": "2612.87",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "51",
                            "monoisotopic_mass": "4543.4685",
                            "monoisotopic_mz": "1515.4968",
                            "intensity": "1326.10",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "52",
                            "monoisotopic_mass": "3213.6339",
                            "monoisotopic_mz": "1607.8242",
                            "intensity": "1832.00",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "53",
                            "monoisotopic_mass": "5265.2855",
                            "monoisotopic_mz": "1756.1024",
                            "intensity": "714.09",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "54",
                            "monoisotopic_mass": "6716.0965",
                            "monoisotopic_mz": "1680.0314",
                            "intensity": "2352.21",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "55",
                            "monoisotopic_mass": "1441.9917",
                            "monoisotopic_mz": "1442.9990",
                            "intensity": "808.01",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "56",
                            "monoisotopic_mass": "1393.3626",
                            "monoisotopic_mz": "1394.3699",
                            "intensity": "474.40",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "57",
                            "monoisotopic_mass": "4082.3404",
                            "monoisotopic_mz": "1361.7874",
                            "intensity": "1806.50",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "58",
                            "monoisotopic_mass": "3310.2247",
                            "monoisotopic_mz": "1656.1197",
                            "intensity": "1790.69",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "59",
                            "monoisotopic_mass": "6634.8224",
                            "monoisotopic_mz": "1659.7129",
                            "intensity": "728.29",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "60",
                            "monoisotopic_mass": "6301.3647",
                            "monoisotopic_mz": "1576.3484",
                            "intensity": "951.46",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "61",
                            "monoisotopic_mass": "1672.6029",
                            "monoisotopic_mz": "1673.6102",
                            "intensity": "2206.85",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "62",
                            "monoisotopic_mass": "4973.5886",
                            "monoisotopic_mz": "1658.8702",
                            "intensity": "1282.10",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "63",
                            "monoisotopic_mass": "6354.9563",
                            "monoisotopic_mz": "1589.7463",
                            "intensity": "1379.69",
                            "charge": "4",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "-483.6791352403",
                                    "theoretical_mass": "6355.9032",
                                    "ion_position": "10",
                                    "ion_display_position": "63",
                                    "ion_sort_name": "Y00063",
                                    "ion_left_position": "10",
                                    "mass_error": "0.0555",
                                    "ppm": "8.73"
                                }
                            }
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "64",
                            "monoisotopic_mass": "5710.8169",
                            "monoisotopic_mz": "1904.6129",
                            "intensity": "1631.10",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "65",
                            "monoisotopic_mass": "5500.3610",
                            "monoisotopic_mz": "1834.4609",
                            "intensity": "1702.28",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "66",
                            "monoisotopic_mass": "6510.0667",
                            "monoisotopic_mz": "1628.5240",
                            "intensity": "2443.96",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "67",
                            "monoisotopic_mass": "3257.5670",
                            "monoisotopic_mz": "1629.7908",
                            "intensity": "1074.84",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "68",
                            "monoisotopic_mass": "5041.3889",
                            "monoisotopic_mz": "1681.4703",
                            "intensity": "622.13",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "69",
                            "monoisotopic_mass": "5661.0576",
                            "monoisotopic_mz": "1888.0265",
                            "intensity": "2047.33",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "70",
                            "monoisotopic_mass": "6423.9672",
                            "monoisotopic_mz": "1606.9991",
                            "intensity": "799.81",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "71",
                            "monoisotopic_mass": "3352.4067",
                            "monoisotopic_mz": "1677.2106",
                            "intensity": "754.57",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "72",
                            "monoisotopic_mass": "1837.1280",
                            "monoisotopic_mz": "1838.1353",
                            "intensity": "2275.80",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "73",
                            "monoisotopic_mass": "1465.0081",
                            "monoisotopic_mz": "1466.0154",
                            "intensity": "431.32",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "74",
                            "monoisotopic_mass": "6688.6407",
                            "monoisotopic_mz": "1673.1675",
                            "intensity": "1890.90",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "75",
                            "monoisotopic_mass": "3606.2104",
                            "monoisotopic_mz": "1804.1125",
                            "intensity": "749.66",
                            "charge": "2"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "76",
                            "monoisotopic_mass": "4934.5099",
                            "monoisotopic_mz": "1645.8439",
                            "intensity": "1238.82",
                            "charge": "3"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "77",
                            "monoisotopic_mass": "1371.5602",
                            "monoisotopic_mz": "1372.5675",
                            "intensity": "554.54",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "78",
                            "monoisotopic_mass": "6266.2605",
                            "monoisotopic_mz": "1567.5724",
                            "intensity": "1545.12",
                            "charge": "4"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "79",
                            "monoisotopic_mass": "1874.9689",
                            "monoisotopic_mz": "1875.9762",
                            "intensity": "2566.90",
                            "charge": "1"
                        },
                        {
                            "spec_id": "268",
                            "peak_id": "80",
                            "monoisotopic_mass": "3280.7905",
                            "monoisotopic_mz": "1641.4025",
                            "intensity": "2521.29",
                            "charge": "2"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "17",
                "proteoform_id": "41",
                "sequence_name": "sp|P0A6E6|ATPE_ECOLI",
                "sequence_description": "ATP synthase epsilon chain OS=Escherichia coli (strain K12) OX=83333 GN=atpC PE=1 SV=2",
                "proteoform_mass": "7472.4305",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "139",
                    "first_residue_position": "1",
                    "last_residue_position": "73",
                    "annotated_seq": "M.AMTYHLDVVSAE(QQMFSGLVEKIQ)[-483.6791]VTGSEGELGIYPGHAPLLTAIKPGMIRIVKQHGHEEFIYLSGGILEVQP.G",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "A"
                        },
                        {
                            "position": "2",
                            "acid": "M"
                        },
                        {
                            "position": "3",
                            "acid": "T"
                        },
                        {
                            "position": "4",
                            "acid": "Y"
                        },
                        {
                            "position": "5",
                            "acid": "H"
                        },
                        {
                            "position": "6",
                            "acid": "L"
                        },
                        {
                            "position": "7",
                            "acid": "D"
                        },
                        {
                            "position": "8",
                            "acid": "V"
                        },
                        {
                            "position": "9",
                            "acid": "V"
                        },
                        {
                            "position": "10",
                            "acid": "S"
                        },
                        {
                            "position": "11",
                            "acid": "A"
                        },
                        {
                            "position": "12",
                            "acid": "E"
                        },
                        {
                            "position": "13",
                            "acid": "Q"
                        },
                        {
                            "position": "14",
                            "acid": "Q"
                        },
                        {
                            "position": "15",
                            "acid": "M"
                        },
                        {
                            "position": "16",
                            "acid": "F"
                        },
                        {
                            "position": "17",
                            "acid": "S"
                        },
                        {
                            "position": "18",
                            "acid": "G"
                        },
                        {
                            "position": "19",
                            "acid": "L"
                        },
                        {
                            "position": "20",
                            "acid": "V"
                        },
                        {
                            "position": "21",
                            "acid": "E"
                        },
                        {
                            "position": "22",
                            "acid": "K"
                        },
                        {
                            "position": "23",
                            "acid": "I"
                        },
                        {
                            "position": "24",
                            "acid": "Q"
                        },
                        {
                            "position": "25",
                            "acid": "V"
                        },
                        {
                            "position": "26",
                            "acid": "T"
                        },
                        {
                            "position": "27",
                            "acid": "G"
                        },
                        {
                            "position": "28",
                            "acid": "S"
                        },
                        {
                            "position": "29",
                            "acid": "E"
                        },
                        {
                            "position": "30",
                            "acid": "G"
                        },
                        {
                            "position": "31",
                            "acid": "E"
                        },
                        {
                            "position": "32",
                            "acid": "L"
                        },
                        {
                            "position": "33",
                            "acid": "G"
                        },
                        {
                            "position": "34",
                            "acid": "I"
                        },
                        {
                            "position": "35",
                            "acid": "Y"
                        },
                        {
                            "position": "36",
                            "acid": "P"
                        },
                        {
                            "position": "37",
                            "acid": "G"
                        },
                        {
                            "position": "38",
                            "acid": "H"
                        },
                        {
                            "position": "39",
                            "acid": "A"
                        },
                        {
                            "position": "40",
                            "acid": "P"
                        },
                        {
                            "position": "41",
                            "acid": "L"
                        },
                        {
                            "position": "42",
                            "acid": "L"
                        },
                        {
                            "position": "43",
                            "acid": "T"
                        },
                        {
                            "position": "44",
                            "acid": "A"
                        },
                        {
                            "position": "45",
                            "acid": "I"
                        },
                        {
                            "position": "46",
                            "acid": "K"
                        },
                        {
                            "position": "47",
                            "acid": "P"
                        },
                        {
                            "position": "48",
                            "acid": "G"
                        },
                        {
                            "position": "49",
                            "acid": "M"
                        },
                        {
                            "position": "50",
                            "acid": "I"
                        },
                        {
                            "position": "51",
                            "acid": "R"
                        },
                        {
                            "position": "52",
                            "acid": "I"
                        },
                        {
                            "position": "53",
                            "acid": "V"
                        },
                        {
                            "position": "54",
                            "acid": "K"
                        },
                        {
                            "position": "55",
                            "acid": "Q"
                        },
                        {
                            "position": "56",
                            "acid": "H"
                        },
                        {
                            "position": "57",
                            "acid": "G"
                        },
                        {
                            "position": "58",
                            "acid": "H"
                        },
                        {
                            "position": "59",
                            "acid": "E"
                        },
                        {
                            "position": "60",
                            "acid": "E"
                        },
                        {
                            "position": "61",
                            "acid": "F"
                        },
                        {
                            "position": "62",
                            "acid": "I"
                        },
                        {
                            "position": "63",
                            "acid": "Y"
                        },
                        {
                            "position": "64",
                            "acid": "L"
                        },
                        {
                            "position": "65",
                            "acid": "S"
                        },
                        {
                            "position": "66",
                            "acid": "G"
                        },
                        {
                            "position": "67",
                            "acid": "G"
                        },
                        {
                            "position": "68",
                            "acid": "I"
                        },
                        {
                            "position": "69",
                            "acid": "L"
                        },
                        {
                            "position": "70",
                            "acid": "E"
                        },
                        {
                            "position": "71",
                            "acid": "V"
                        },
                        {
                            "position": "72",
                            "acid": "Q"
                        },
                        {
                            "position": "73",
                            "acid": "P"
                        },
                        {
                            "position": "74",
                            "acid": "G"
                        },
                        {
                            "position": "75",
                            "acid": "N"
                        },
                        {
                            "position": "76",
                            "acid": "V"
                        },
                        {
                            "position": "77",
                            "acid": "T"
                        },
                        {
                            "position": "78",
                            "acid": "V"
                        },
                        {
                            "position": "79",
                            "acid": "L"
                        },
                        {
                            "position": "80",
                            "acid": "A"
                        },
                        {
                            "position": "81",
                            "acid": "D"
                        },
                        {
                            "position": "82",
                            "acid": "T"
                        },
                        {
                            "position": "83",
                            "acid": "A"
                        },
                        {
                            "position": "84",
                            "acid": "I"
                        },
                        {
                            "position": "85",
                            "acid": "R"
                        },
                        {
                            "position": "86",
                            "acid": "G"
                        },
                        {
                            "position": "87",
                            "acid": "Q"
                        },
                        {
                            "position": "88",
                            "acid": "D"
                        },
                        {
                            "position": "89",
                            "acid": "L"
                        },
                        {
                            "position": "90",
                            "acid": "D"
                        },
                        {
                            "position": "91",
                            "acid": "E"
                        },
                        {
                            "position": "92",
                            "acid": "A"
                        },
                        {
                            "position": "93",
                            "acid": "R"
                        },
                        {
                            "position": "94",
                            "acid": "A"
                        },
                        {
                            "position": "95",
                            "acid": "M"
                        },
                        {
                            "position": "96",
                            "acid": "E"
                        },
                        {
                            "position": "97",
                            "acid": "A"
                        },
                        {
                            "position": "98",
                            "acid": "K"
                        },
                        {
                            "position": "99",
                            "acid": "R"
                        },
                        {
                            "position": "100",
                            "acid": "K"
                        },
                        {
                            "position": "101",
                            "acid": "A"
                        },
                        {
                            "position": "102",
                            "acid": "E"
                        },
                        {
                            "position": "103",
                            "acid": "E"
                        },
                        {
                            "position": "104",
                            "acid": "H"
                        },
                        {
                            "position": "105",
                            "acid": "I"
                        },
                        {
                            "position": "106",
                            "acid": "S"
                        },
                        {
                            "position": "107",
                            "acid": "S"
                        },
                        {
                            "position": "108",
                            "acid": "S"
                        },
                        {
                            "position": "109",
                            "acid": "H"
                        },
                        {
                            "position": "110",
                            "acid": "G"
                        },
                        {
                            "position": "111",
                            "acid": "D"
                        },
                        {
                            "position": "112",
                            "acid": "V"
                        },
                        {
                            "position": "113",
                            "acid": "D"
                        },
                        {
                            "position": "114",
                            "acid": "Y"
                        },
                        {
                            "position": "115",
                            "acid": "A"
                        },
                        {
                            "position": "116",
                            "acid": "Q"
                        },
                        {
                            "position": "117",
                            "acid": "A"
                        },
                        {
                            "position": "118",
                            "acid": "S"
                        },
                        {
                            "position": "119",
                            "acid": "A"
                        },
                        {
                            "position": "120",
                            "acid": "E"
                        },
                        {
                            "position": "121",
                            "acid": "L"
                        },
                        {
                            "position": "122",
                            "acid": "A"
                        },
                        {
                            "position": "123",
                            "acid": "K"
                        },
                        {
                            "position": "124",
                            "acid": "A"
                        },
                        {
                            "position": "125",
                            "acid": "I"
                        },
                        {
                            "position": "126",
                            "acid": "A"
                        },
                        {
                            "position": "127",
                            "acid": "Q"
                        },
                        {
                            "position": "128",
                            "acid": "L"
                        },
                        {
                            "position": "129",
                            "acid": "R"
                        },
                        {
                            "position": "130",
                            "acid": "V"
                        },
                        {
                            "position": "131",
                            "acid": "I"
                        },
                        {
                            "position": "132",
                            "acid": "E"
                        },
                        {
                            "position": "133",
                            "acid": "L"
                        },
                        {
                            "position": "134",
                            "acid": "T"
                        },
                        {
                            "position": "135",
                            "acid": "K"
                        },
                        {
                            "position": "136",
                            "acid": "K"
                        },
                        {
                            "position": "137",
                            "acid": "A"
                        },
                        {
                            "position": "138",
                            "acid": "M"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "spec_id": "268",
                                    "peak_id": "13",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "spec_id": "268",
                                    "peak_id": "11",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "spec_id": "268",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "spec_id": "268",
                                    "peak_id": "5",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "9",
                                    "ion_display_position": "9",
                                    "spec_id": "268",
                                    "peak_id": "6",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "10",
                                    "ion_display_position": "63",
                                    "spec_id": "268",
                                    "peak_id": "63",
                                    "peak_charge": "4"
                                }
                            }
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "12",
                                    "ion_display_position": "12",
                                    "spec_id": "268",
                                    "peak_id": "1",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "24",
                                    "ion_display_position": "49",
                                    "spec_id": "268",
                                    "peak_id": "45",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "27",
                                    "ion_display_position": "46",
                                    "spec_id": "268",
                                    "peak_id": "34",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "13",
                        "right_position": "25",
                        "shift": "-483.6791352403",
                        "anno": "-483.6791",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
