prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "33",
        "sequence_name": "sp|P56614|YMDF_ECOLI",
        "sequence_description": "Uncharacterized protein YmdF OS=Escherichia coli (strain K12) OX=83333 GN=ymdF PE=3 SV=1",
        "proteoform_id": "39",
        "prsm_number": "2",
        "prsm": [
            {
                "prsm_id": "13",
                "p_value": "2.76e-05",
                "e_value": "2.76e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "511",
                        "ms1_scans": "553",
                        "ids": "43",
                        "scans": "556",
                        "precursor_mono_mass": "4566.1773",
                        "precursor_charge": "5",
                        "precursor_mz": "914.2427",
                        "feature_inte": "6.2314e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "43",
                                "peak_id": "0",
                                "monoisotopic_mass": "1482.7251",
                                "monoisotopic_mz": "1483.7324",
                                "intensity": "680.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "1",
                                "monoisotopic_mass": "1171.5627",
                                "monoisotopic_mz": "1172.5699",
                                "intensity": "2211.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5582",
                                        "ion_position": "33",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0045",
                                        "ppm": "3.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "2",
                                "monoisotopic_mass": "4548.1565",
                                "monoisotopic_mz": "910.6386",
                                "intensity": "6449.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "3",
                                "monoisotopic_mass": "1312.5610",
                                "monoisotopic_mz": "1313.5682",
                                "intensity": "1466.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1312.5545",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0065",
                                        "ppm": "4.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "4",
                                "monoisotopic_mass": "942.4926",
                                "monoisotopic_mz": "943.4999",
                                "intensity": "8971.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "942.4883",
                                        "ion_position": "35",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0043",
                                        "ppm": "4.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "5",
                                "monoisotopic_mass": "1487.7068",
                                "monoisotopic_mz": "744.8607",
                                "intensity": "1695.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "6",
                                "monoisotopic_mass": "1620.8083",
                                "monoisotopic_mz": "811.4114",
                                "intensity": "3232.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "7",
                                "monoisotopic_mass": "1695.8396",
                                "monoisotopic_mz": "848.9271",
                                "intensity": "4419.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "8",
                                "monoisotopic_mass": "1299.6601",
                                "monoisotopic_mz": "1300.6674",
                                "intensity": "905.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1299.6531",
                                        "ion_position": "32",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0070",
                                        "ppm": "5.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "9",
                                "monoisotopic_mass": "1004.4977",
                                "monoisotopic_mz": "1005.5049",
                                "intensity": "999.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "10",
                                "monoisotopic_mass": "1103.5658",
                                "monoisotopic_mz": "1104.5731",
                                "intensity": "1275.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "11",
                                "monoisotopic_mass": "2667.2753",
                                "monoisotopic_mz": "890.0991",
                                "intensity": "1498.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2667.2610",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0143",
                                        "ppm": "5.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "12",
                                "monoisotopic_mass": "841.4330",
                                "monoisotopic_mz": "842.4403",
                                "intensity": "1804.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "13",
                                "monoisotopic_mass": "1136.6242",
                                "monoisotopic_mz": "1137.6315",
                                "intensity": "1996.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "14",
                                "monoisotopic_mass": "1378.7716",
                                "monoisotopic_mz": "1379.7789",
                                "intensity": "818.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "15",
                                "monoisotopic_mass": "1823.9352",
                                "monoisotopic_mz": "912.9749",
                                "intensity": "13112.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "16",
                                "monoisotopic_mass": "1301.7263",
                                "monoisotopic_mz": "651.8704",
                                "intensity": "1455.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "17",
                                "monoisotopic_mass": "1674.8539",
                                "monoisotopic_mz": "838.4342",
                                "intensity": "622.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "18",
                                "monoisotopic_mass": "2776.3333",
                                "monoisotopic_mz": "926.4517",
                                "intensity": "1257.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "19",
                                "monoisotopic_mass": "3605.6656",
                                "monoisotopic_mz": "1202.8958",
                                "intensity": "2999.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "20",
                                "monoisotopic_mass": "942.4918",
                                "monoisotopic_mz": "472.2532",
                                "intensity": "2693.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "942.4883",
                                        "ion_position": "35",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0035",
                                        "ppm": "3.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "21",
                                "monoisotopic_mass": "2473.2923",
                                "monoisotopic_mz": "825.4380",
                                "intensity": "1082.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "22",
                                "monoisotopic_mass": "1075.5723",
                                "monoisotopic_mz": "1076.5796",
                                "intensity": "1095.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "23",
                                "monoisotopic_mass": "1324.7102",
                                "monoisotopic_mz": "663.3624",
                                "intensity": "1287.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "24",
                                "monoisotopic_mass": "542.1405",
                                "monoisotopic_mz": "543.1478",
                                "intensity": "1184.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "25",
                                "monoisotopic_mass": "1429.7072",
                                "monoisotopic_mz": "715.8609",
                                "intensity": "977.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "26",
                                "monoisotopic_mass": "1228.6098",
                                "monoisotopic_mz": "615.3122",
                                "intensity": "502.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "27",
                                "monoisotopic_mass": "1468.6761",
                                "monoisotopic_mz": "735.3453",
                                "intensity": "246.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "28",
                                "monoisotopic_mass": "1339.6747",
                                "monoisotopic_mz": "670.8446",
                                "intensity": "263.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "29",
                                "monoisotopic_mass": "2229.1479",
                                "monoisotopic_mz": "744.0566",
                                "intensity": "693.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "30",
                                "monoisotopic_mass": "1805.8863",
                                "monoisotopic_mz": "903.9504",
                                "intensity": "4489.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "31",
                                "monoisotopic_mass": "3119.4511",
                                "monoisotopic_mz": "780.8701",
                                "intensity": "2316.02",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3119.4378",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0133",
                                        "ppm": "4.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "32",
                                "monoisotopic_mass": "2264.2138",
                                "monoisotopic_mz": "1133.1142",
                                "intensity": "1076.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "33",
                                "monoisotopic_mass": "1268.7349",
                                "monoisotopic_mz": "1269.7422",
                                "intensity": "279.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "34",
                                "monoisotopic_mass": "862.9429",
                                "monoisotopic_mz": "863.9502",
                                "intensity": "1255.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "35",
                                "monoisotopic_mass": "1196.5484",
                                "monoisotopic_mz": "1197.5557",
                                "intensity": "1014.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "36",
                                "monoisotopic_mass": "3623.6832",
                                "monoisotopic_mz": "1208.9017",
                                "intensity": "3916.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3623.6711",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0121",
                                        "ppm": "3.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "37",
                                "monoisotopic_mass": "3103.4231",
                                "monoisotopic_mz": "776.8630",
                                "intensity": "1164.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "38",
                                "monoisotopic_mass": "3606.6629",
                                "monoisotopic_mz": "902.6730",
                                "intensity": "3303.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "39",
                                "monoisotopic_mass": "4345.0248",
                                "monoisotopic_mz": "1087.2635",
                                "intensity": "1641.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "40",
                                "monoisotopic_mass": "1053.5986",
                                "monoisotopic_mz": "1054.6058",
                                "intensity": "916.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "41",
                                "monoisotopic_mass": "2890.3616",
                                "monoisotopic_mz": "723.5977",
                                "intensity": "1021.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "42",
                                "monoisotopic_mass": "1588.8582",
                                "monoisotopic_mz": "795.4364",
                                "intensity": "702.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "43",
                                "monoisotopic_mass": "1238.6872",
                                "monoisotopic_mz": "1239.6945",
                                "intensity": "1690.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "44",
                                "monoisotopic_mass": "1788.8345",
                                "monoisotopic_mz": "1789.8418",
                                "intensity": "779.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "45",
                                "monoisotopic_mass": "2804.3331",
                                "monoisotopic_mz": "702.0905",
                                "intensity": "1694.07",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2804.3199",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0131",
                                        "ppm": "4.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "46",
                                "monoisotopic_mass": "2775.3358",
                                "monoisotopic_mz": "694.8412",
                                "intensity": "427.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "47",
                                "monoisotopic_mass": "3473.6107",
                                "monoisotopic_mz": "869.4099",
                                "intensity": "376.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "48",
                                "monoisotopic_mass": "3004.4726",
                                "monoisotopic_mz": "752.1254",
                                "intensity": "959.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "49",
                                "monoisotopic_mass": "4254.9991",
                                "monoisotopic_mz": "1064.7570",
                                "intensity": "534.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "50",
                                "monoisotopic_mass": "2424.1640",
                                "monoisotopic_mz": "809.0619",
                                "intensity": "1875.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "51",
                                "monoisotopic_mass": "3623.6879",
                                "monoisotopic_mz": "906.9292",
                                "intensity": "3528.74",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3623.6711",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0168",
                                        "ppm": "4.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "52",
                                "monoisotopic_mass": "2803.3291",
                                "monoisotopic_mz": "935.4503",
                                "intensity": "1528.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "53",
                                "monoisotopic_mass": "2492.2910",
                                "monoisotopic_mz": "1247.1528",
                                "intensity": "1284.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "54",
                                "monoisotopic_mass": "2296.0703",
                                "monoisotopic_mz": "766.3641",
                                "intensity": "781.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "55",
                                "monoisotopic_mass": "2718.4842",
                                "monoisotopic_mz": "907.1687",
                                "intensity": "1282.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "43",
                                "peak_id": "56",
                                "monoisotopic_mass": "2736.7287",
                                "monoisotopic_mz": "913.2502",
                                "intensity": "5523.49",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "33",
                    "proteoform_id": "39",
                    "sequence_name": "sp|P56614|YMDF_ECOLI",
                    "sequence_description": "Uncharacterized protein YmdF OS=Escherichia coli (strain K12) OX=83333 GN=ymdF PE=3 SV=1",
                    "proteoform_mass": "4566.1594",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "57",
                        "first_residue_position": "1",
                        "last_residue_position": "44",
                        "annotated_seq": "M.ANHRGGSGNFAEDRERASEAGKKGGQHSGGNFKNDPQRASEAGK.K",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "N"
                            },
                            {
                                "position": "3",
                                "acid": "H"
                            },
                            {
                                "position": "4",
                                "acid": "R"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "S"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "D"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "E"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "H"
                            },
                            {
                                "position": "28",
                                "acid": "S"
                            },
                            {
                                "position": "29",
                                "acid": "G"
                            },
                            {
                                "position": "30",
                                "acid": "G"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "P"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "A"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "S"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "H"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "43",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "43",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "43",
                                        "peak_id": "45",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "43",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "12",
                                        "spec_id": "43",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "11",
                                        "spec_id": "43",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "35",
                                            "ion_display_position": "9",
                                            "spec_id": "43",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "35",
                                            "ion_display_position": "9",
                                            "spec_id": "43",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "43",
                                            "peak_id": "36",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "43",
                                            "peak_id": "51",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "35",
                "p_value": "4.04e-04",
                "e_value": "4.04e-04",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "523",
                        "ms1_scans": "595",
                        "ids": "72",
                        "scans": "597",
                        "precursor_mono_mass": "4566.1773",
                        "precursor_charge": "5",
                        "precursor_mz": "914.2427",
                        "feature_inte": "6.2314e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "72",
                                "peak_id": "0",
                                "monoisotopic_mass": "980.5550",
                                "monoisotopic_mz": "981.5623",
                                "intensity": "1210.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "1",
                                "monoisotopic_mass": "1171.5651",
                                "monoisotopic_mz": "1172.5724",
                                "intensity": "2238.38",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5582",
                                        "ion_position": "33",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0069",
                                        "ppm": "5.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "2",
                                "monoisotopic_mass": "777.3939",
                                "monoisotopic_mz": "778.4012",
                                "intensity": "2105.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "3",
                                "monoisotopic_mass": "1312.5602",
                                "monoisotopic_mz": "1313.5675",
                                "intensity": "1854.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1312.5545",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0058",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "4",
                                "monoisotopic_mass": "1136.6237",
                                "monoisotopic_mz": "1137.6310",
                                "intensity": "2530.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "5",
                                "monoisotopic_mass": "942.4924",
                                "monoisotopic_mz": "943.4997",
                                "intensity": "8239.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "942.4883",
                                        "ion_position": "35",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0041",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "6",
                                "monoisotopic_mass": "1483.7276",
                                "monoisotopic_mz": "1484.7349",
                                "intensity": "1076.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "7",
                                "monoisotopic_mass": "1378.7724",
                                "monoisotopic_mz": "1379.7797",
                                "intensity": "2605.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "8",
                                "monoisotopic_mass": "1725.8861",
                                "monoisotopic_mz": "863.9503",
                                "intensity": "14866.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "9",
                                "monoisotopic_mass": "2292.2899",
                                "monoisotopic_mz": "1147.1522",
                                "intensity": "3924.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "10",
                                "monoisotopic_mass": "1567.7455",
                                "monoisotopic_mz": "784.8800",
                                "intensity": "2488.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "11",
                                "monoisotopic_mass": "1589.7275",
                                "monoisotopic_mz": "795.8710",
                                "intensity": "1310.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "12",
                                "monoisotopic_mass": "2786.3214",
                                "monoisotopic_mz": "929.7811",
                                "intensity": "431.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "13",
                                "monoisotopic_mass": "1529.7992",
                                "monoisotopic_mz": "765.9069",
                                "intensity": "2218.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "14",
                                "monoisotopic_mass": "3623.6836",
                                "monoisotopic_mz": "1208.9018",
                                "intensity": "2056.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3623.6711",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0125",
                                        "ppm": "3.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "15",
                                "monoisotopic_mass": "1007.9817",
                                "monoisotopic_mz": "1008.9890",
                                "intensity": "695.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "16",
                                "monoisotopic_mass": "2427.2904",
                                "monoisotopic_mz": "810.1041",
                                "intensity": "5175.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "17",
                                "monoisotopic_mass": "752.4037",
                                "monoisotopic_mz": "753.4109",
                                "intensity": "1739.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "18",
                                "monoisotopic_mass": "3119.4529",
                                "monoisotopic_mz": "780.8705",
                                "intensity": "1653.11",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3119.4378",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0150",
                                        "ppm": "4.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "19",
                                "monoisotopic_mass": "2312.3573",
                                "monoisotopic_mz": "771.7930",
                                "intensity": "1193.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "20",
                                "monoisotopic_mass": "2526.3603",
                                "monoisotopic_mz": "843.1274",
                                "intensity": "1270.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "21",
                                "monoisotopic_mass": "1995.1556",
                                "monoisotopic_mz": "666.0591",
                                "intensity": "1274.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "22",
                                "monoisotopic_mass": "3265.5178",
                                "monoisotopic_mz": "817.3867",
                                "intensity": "1993.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "23",
                                "monoisotopic_mass": "651.3650",
                                "monoisotopic_mz": "652.3723",
                                "intensity": "423.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "24",
                                "monoisotopic_mass": "942.4919",
                                "monoisotopic_mz": "472.2532",
                                "intensity": "2151.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "942.4883",
                                        "ion_position": "35",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0036",
                                        "ppm": "3.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "25",
                                "monoisotopic_mass": "2639.4459",
                                "monoisotopic_mz": "880.8226",
                                "intensity": "2285.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "26",
                                "monoisotopic_mass": "1682.8699",
                                "monoisotopic_mz": "842.4422",
                                "intensity": "1118.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "27",
                                "monoisotopic_mass": "924.4808",
                                "monoisotopic_mz": "925.4881",
                                "intensity": "819.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "28",
                                "monoisotopic_mass": "1619.9556",
                                "monoisotopic_mz": "1620.9629",
                                "intensity": "1186.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "29",
                                "monoisotopic_mass": "2776.3368",
                                "monoisotopic_mz": "695.0915",
                                "intensity": "1069.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "30",
                                "monoisotopic_mass": "2804.3294",
                                "monoisotopic_mz": "935.7838",
                                "intensity": "1165.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2804.3199",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0095",
                                        "ppm": "3.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "31",
                                "monoisotopic_mass": "1703.9067",
                                "monoisotopic_mz": "852.9606",
                                "intensity": "6369.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "32",
                                "monoisotopic_mass": "1761.8469",
                                "monoisotopic_mz": "881.9307",
                                "intensity": "1464.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1761.8394",
                                        "ion_position": "27",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0075",
                                        "ppm": "4.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "33",
                                "monoisotopic_mass": "3623.6946",
                                "monoisotopic_mz": "906.9309",
                                "intensity": "3832.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3623.6711",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0235",
                                        "ppm": "6.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "34",
                                "monoisotopic_mass": "1269.6609",
                                "monoisotopic_mz": "635.8377",
                                "intensity": "487.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "35",
                                "monoisotopic_mass": "1828.9950",
                                "monoisotopic_mz": "915.5048",
                                "intensity": "13389.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "36",
                                "monoisotopic_mass": "1628.8265",
                                "monoisotopic_mz": "815.4205",
                                "intensity": "2087.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "37",
                                "monoisotopic_mass": "1079.6238",
                                "monoisotopic_mz": "1080.6311",
                                "intensity": "995.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "38",
                                "monoisotopic_mass": "3590.6411",
                                "monoisotopic_mz": "1197.8877",
                                "intensity": "1740.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "39",
                                "monoisotopic_mass": "624.3146",
                                "monoisotopic_mz": "625.3219",
                                "intensity": "1132.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "40",
                                "monoisotopic_mass": "1486.7069",
                                "monoisotopic_mz": "744.3607",
                                "intensity": "270.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "41",
                                "monoisotopic_mass": "2448.3803",
                                "monoisotopic_mz": "1225.1974",
                                "intensity": "1238.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "42",
                                "monoisotopic_mass": "1551.7445",
                                "monoisotopic_mz": "776.8795",
                                "intensity": "1096.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "43",
                                "monoisotopic_mass": "1507.8740",
                                "monoisotopic_mz": "1508.8813",
                                "intensity": "1197.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "44",
                                "monoisotopic_mass": "4547.1627",
                                "monoisotopic_mz": "910.4398",
                                "intensity": "4789.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "45",
                                "monoisotopic_mass": "1275.7122",
                                "monoisotopic_mz": "1276.7195",
                                "intensity": "279.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "46",
                                "monoisotopic_mass": "1802.8297",
                                "monoisotopic_mz": "902.4221",
                                "intensity": "2028.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "47",
                                "monoisotopic_mass": "2698.4787",
                                "monoisotopic_mz": "1350.2466",
                                "intensity": "976.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "48",
                                "monoisotopic_mass": "2890.3569",
                                "monoisotopic_mz": "723.5965",
                                "intensity": "1406.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "49",
                                "monoisotopic_mass": "1324.6927",
                                "monoisotopic_mz": "1325.6999",
                                "intensity": "353.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "50",
                                "monoisotopic_mass": "668.3230",
                                "monoisotopic_mz": "669.3303",
                                "intensity": "789.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "51",
                                "monoisotopic_mass": "3605.6616",
                                "monoisotopic_mz": "1202.8945",
                                "intensity": "2062.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "52",
                                "monoisotopic_mass": "1097.6199",
                                "monoisotopic_mz": "1098.6272",
                                "intensity": "394.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "53",
                                "monoisotopic_mass": "2607.3182",
                                "monoisotopic_mz": "870.1133",
                                "intensity": "1207.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "54",
                                "monoisotopic_mass": "3238.5289",
                                "monoisotopic_mz": "810.6395",
                                "intensity": "1723.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "55",
                                "monoisotopic_mass": "1790.1086",
                                "monoisotopic_mz": "1791.1159",
                                "intensity": "783.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "56",
                                "monoisotopic_mass": "4291.0103",
                                "monoisotopic_mz": "1073.7599",
                                "intensity": "1429.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "57",
                                "monoisotopic_mass": "3587.6671",
                                "monoisotopic_mz": "897.9240",
                                "intensity": "412.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "58",
                                "monoisotopic_mass": "2744.4971",
                                "monoisotopic_mz": "915.8396",
                                "intensity": "6693.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "59",
                                "monoisotopic_mass": "1039.5684",
                                "monoisotopic_mz": "1040.5757",
                                "intensity": "457.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "60",
                                "monoisotopic_mass": "2666.2748",
                                "monoisotopic_mz": "889.7655",
                                "intensity": "1944.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "61",
                                "monoisotopic_mass": "814.3946",
                                "monoisotopic_mz": "815.4019",
                                "intensity": "1191.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "62",
                                "monoisotopic_mass": "2229.1289",
                                "monoisotopic_mz": "1115.5717",
                                "intensity": "1161.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "63",
                                "monoisotopic_mass": "4419.0661",
                                "monoisotopic_mz": "1105.7738",
                                "intensity": "630.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "64",
                                "monoisotopic_mass": "2492.2937",
                                "monoisotopic_mz": "1247.1541",
                                "intensity": "1009.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "65",
                                "monoisotopic_mass": "3650.9579",
                                "monoisotopic_mz": "913.7468",
                                "intensity": "2080.84",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "33",
                    "proteoform_id": "39",
                    "sequence_name": "sp|P56614|YMDF_ECOLI",
                    "sequence_description": "Uncharacterized protein YmdF OS=Escherichia coli (strain K12) OX=83333 GN=ymdF PE=3 SV=1",
                    "proteoform_mass": "4566.1594",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "57",
                        "first_residue_position": "1",
                        "last_residue_position": "44",
                        "annotated_seq": "M.ANHRGGSGNFAEDRERASEAGKKGGQHSGGNFKNDPQRASEAGK.K",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "N"
                            },
                            {
                                "position": "3",
                                "acid": "H"
                            },
                            {
                                "position": "4",
                                "acid": "R"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "G"
                            },
                            {
                                "position": "7",
                                "acid": "S"
                            },
                            {
                                "position": "8",
                                "acid": "G"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "D"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "E"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "K"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "H"
                            },
                            {
                                "position": "28",
                                "acid": "S"
                            },
                            {
                                "position": "29",
                                "acid": "G"
                            },
                            {
                                "position": "30",
                                "acid": "G"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "K"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "P"
                            },
                            {
                                "position": "37",
                                "acid": "Q"
                            },
                            {
                                "position": "38",
                                "acid": "R"
                            },
                            {
                                "position": "39",
                                "acid": "A"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "K"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "S"
                            },
                            {
                                "position": "50",
                                "acid": "S"
                            },
                            {
                                "position": "51",
                                "acid": "H"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "72",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "17",
                                            "spec_id": "72",
                                            "peak_id": "32",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "72",
                                            "peak_id": "30",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "72",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "11",
                                        "spec_id": "72",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "35",
                                            "ion_display_position": "9",
                                            "spec_id": "72",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "35",
                                            "ion_display_position": "9",
                                            "spec_id": "72",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "72",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "72",
                                            "peak_id": "33",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
