prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "19",
        "sequence_name": "sp|P60438|RL3_ECOLI",
        "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
        "proteoform_id": "19",
        "prsm_number": "4",
        "prsm": [
            {
                "prsm_id": "21",
                "p_value": "4.12e-15",
                "e_value": "4.12e-15",
                "fdr": "0",
                "matched_fragment_number": "20",
                "matched_peak_number": "24",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "516",
                        "ms1_scans": "571",
                        "ids": "54",
                        "scans": "572",
                        "precursor_mono_mass": "5199.8721",
                        "precursor_charge": "5",
                        "precursor_mz": "1040.9817",
                        "feature_inte": "3.5935e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "54",
                                "peak_id": "0",
                                "monoisotopic_mass": "1844.8964",
                                "monoisotopic_mz": "1845.9037",
                                "intensity": "6150.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1844.8873",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0091",
                                        "ppm": "4.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "1",
                                "monoisotopic_mass": "1614.8630",
                                "monoisotopic_mz": "1615.8702",
                                "intensity": "1674.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "2",
                                "monoisotopic_mass": "1552.8278",
                                "monoisotopic_mz": "1553.8351",
                                "intensity": "1000.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "3",
                                "monoisotopic_mass": "1522.8799",
                                "monoisotopic_mz": "1523.8872",
                                "intensity": "6301.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0080",
                                        "ppm": "5.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "4",
                                "monoisotopic_mass": "811.4111",
                                "monoisotopic_mz": "812.4183",
                                "intensity": "3529.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "5",
                                "monoisotopic_mass": "1740.8534",
                                "monoisotopic_mz": "871.4340",
                                "intensity": "1595.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "6",
                                "monoisotopic_mass": "3389.8722",
                                "monoisotopic_mz": "1130.9647",
                                "intensity": "4004.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "7",
                                "monoisotopic_mass": "1979.0427",
                                "monoisotopic_mz": "990.5286",
                                "intensity": "7957.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "8",
                                "monoisotopic_mass": "1359.7334",
                                "monoisotopic_mz": "1360.7407",
                                "intensity": "1648.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "9",
                                "monoisotopic_mass": "1263.7726",
                                "monoisotopic_mz": "1264.7799",
                                "intensity": "1508.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "10",
                                "monoisotopic_mass": "3223.7061",
                                "monoisotopic_mz": "1075.5760",
                                "intensity": "3229.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "11",
                                "monoisotopic_mass": "3678.0069",
                                "monoisotopic_mz": "920.5090",
                                "intensity": "4508.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "12",
                                "monoisotopic_mass": "3577.9376",
                                "monoisotopic_mz": "1193.6532",
                                "intensity": "25421.33",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0191",
                                        "ppm": "5.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "13",
                                "monoisotopic_mass": "824.5521",
                                "monoisotopic_mz": "825.5593",
                                "intensity": "3207.98",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "824.5484",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0037",
                                        "ppm": "4.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "14",
                                "monoisotopic_mass": "3417.8694",
                                "monoisotopic_mz": "1140.2971",
                                "intensity": "10328.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "15",
                                "monoisotopic_mass": "1297.7667",
                                "monoisotopic_mz": "1298.7739",
                                "intensity": "2533.86",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1297.7606",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0061",
                                        "ppm": "4.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "16",
                                "monoisotopic_mass": "847.4054",
                                "monoisotopic_mz": "848.4127",
                                "intensity": "5934.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "17",
                                "monoisotopic_mass": "1652.3807",
                                "monoisotopic_mz": "1653.3879",
                                "intensity": "1091.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "18",
                                "monoisotopic_mass": "3649.0089",
                                "monoisotopic_mz": "1217.3436",
                                "intensity": "28150.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "19",
                                "monoisotopic_mass": "3449.8810",
                                "monoisotopic_mz": "1150.9676",
                                "intensity": "7238.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0211",
                                        "ppm": "6.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "20",
                                "monoisotopic_mass": "3677.0032",
                                "monoisotopic_mz": "1226.6750",
                                "intensity": "26098.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0163",
                                        "ppm": "4.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "21",
                                "monoisotopic_mass": "3346.8267",
                                "monoisotopic_mz": "1116.6162",
                                "intensity": "2524.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "22",
                                "monoisotopic_mass": "1425.8252",
                                "monoisotopic_mz": "1426.8325",
                                "intensity": "1835.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1425.8191",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0061",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "23",
                                "monoisotopic_mass": "1446.7380",
                                "monoisotopic_mz": "724.3763",
                                "intensity": "822.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "24",
                                "monoisotopic_mass": "1522.8797",
                                "monoisotopic_mz": "762.4471",
                                "intensity": "2738.74",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0078",
                                        "ppm": "5.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "25",
                                "monoisotopic_mass": "711.4675",
                                "monoisotopic_mz": "712.4748",
                                "intensity": "4808.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0032",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "26",
                                "monoisotopic_mass": "3549.9349",
                                "monoisotopic_mz": "1184.3189",
                                "intensity": "19042.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "27",
                                "monoisotopic_mass": "2413.2323",
                                "monoisotopic_mz": "1207.6234",
                                "intensity": "11602.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2413.2206",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0117",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "28",
                                "monoisotopic_mass": "1832.1107",
                                "monoisotopic_mz": "917.0626",
                                "intensity": "2246.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "29",
                                "monoisotopic_mass": "1702.9021",
                                "monoisotopic_mz": "852.4583",
                                "intensity": "3523.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "30",
                                "monoisotopic_mass": "1592.8831",
                                "monoisotopic_mz": "797.4489",
                                "intensity": "2200.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "31",
                                "monoisotopic_mass": "2866.4315",
                                "monoisotopic_mz": "956.4844",
                                "intensity": "2019.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "32",
                                "monoisotopic_mass": "2119.1464",
                                "monoisotopic_mz": "707.3894",
                                "intensity": "2897.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "33",
                                "monoisotopic_mass": "612.3986",
                                "monoisotopic_mz": "613.4058",
                                "intensity": "5582.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "612.3959",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0027",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "34",
                                "monoisotopic_mass": "3703.0005",
                                "monoisotopic_mz": "1235.3408",
                                "intensity": "1632.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "35",
                                "monoisotopic_mass": "1668.7801",
                                "monoisotopic_mz": "835.3973",
                                "intensity": "1115.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "36",
                                "monoisotopic_mass": "1992.0741",
                                "monoisotopic_mz": "997.0443",
                                "intensity": "511.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "37",
                                "monoisotopic_mass": "3291.7990",
                                "monoisotopic_mz": "1098.2736",
                                "intensity": "2443.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "38",
                                "monoisotopic_mass": "3321.7804",
                                "monoisotopic_mz": "1108.2674",
                                "intensity": "5806.63",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0155",
                                        "ppm": "4.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "39",
                                "monoisotopic_mass": "1251.6850",
                                "monoisotopic_mz": "1252.6923",
                                "intensity": "1093.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "40",
                                "monoisotopic_mass": "3506.8993",
                                "monoisotopic_mz": "1169.9737",
                                "intensity": "7697.13",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3506.8814",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0179",
                                        "ppm": "5.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "41",
                                "monoisotopic_mass": "910.4814",
                                "monoisotopic_mz": "911.4887",
                                "intensity": "3969.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "42",
                                "monoisotopic_mass": "585.2418",
                                "monoisotopic_mz": "586.2491",
                                "intensity": "4914.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "43",
                                "monoisotopic_mass": "2079.0390",
                                "monoisotopic_mz": "1040.5268",
                                "intensity": "14015.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "44",
                                "monoisotopic_mass": "3275.7634",
                                "monoisotopic_mz": "1092.9284",
                                "intensity": "1640.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "45",
                                "monoisotopic_mass": "725.4104",
                                "monoisotopic_mz": "726.4177",
                                "intensity": "513.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "46",
                                "monoisotopic_mass": "3194.7121",
                                "monoisotopic_mz": "1065.9113",
                                "intensity": "2727.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "47",
                                "monoisotopic_mass": "1301.7256",
                                "monoisotopic_mz": "651.8701",
                                "intensity": "1364.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "48",
                                "monoisotopic_mass": "2154.0978",
                                "monoisotopic_mz": "1078.0562",
                                "intensity": "2550.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "49",
                                "monoisotopic_mass": "3902.1156",
                                "monoisotopic_mz": "1301.7125",
                                "intensity": "4301.61",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3902.0982",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0173",
                                        "ppm": "4.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "50",
                                "monoisotopic_mass": "2018.9962",
                                "monoisotopic_mz": "1010.5054",
                                "intensity": "729.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "51",
                                "monoisotopic_mass": "542.1407",
                                "monoisotopic_mz": "543.1480",
                                "intensity": "3248.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "52",
                                "monoisotopic_mass": "3632.9842",
                                "monoisotopic_mz": "1212.0020",
                                "intensity": "5252.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "53",
                                "monoisotopic_mass": "523.3506",
                                "monoisotopic_mz": "524.3578",
                                "intensity": "1516.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "54",
                                "monoisotopic_mass": "646.2964",
                                "monoisotopic_mz": "647.3036",
                                "intensity": "1014.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "646.2931",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0033",
                                        "ppm": "5.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "55",
                                "monoisotopic_mass": "1561.8510",
                                "monoisotopic_mz": "781.9328",
                                "intensity": "2536.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "56",
                                "monoisotopic_mass": "484.3028",
                                "monoisotopic_mz": "485.3101",
                                "intensity": "10491.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3009",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0019",
                                        "ppm": "3.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "57",
                                "monoisotopic_mass": "1768.8442",
                                "monoisotopic_mz": "885.4294",
                                "intensity": "929.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "58",
                                "monoisotopic_mass": "3488.8795",
                                "monoisotopic_mz": "1163.9671",
                                "intensity": "4854.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "59",
                                "monoisotopic_mass": "452.2033",
                                "monoisotopic_mz": "453.2106",
                                "intensity": "850.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "60",
                                "monoisotopic_mass": "2285.1348",
                                "monoisotopic_mz": "1143.5747",
                                "intensity": "1593.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "61",
                                "monoisotopic_mass": "680.3164",
                                "monoisotopic_mz": "681.3237",
                                "intensity": "1354.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "62",
                                "monoisotopic_mass": "395.2546",
                                "monoisotopic_mz": "396.2619",
                                "intensity": "6053.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "63",
                                "monoisotopic_mass": "2199.1378",
                                "monoisotopic_mz": "1100.5762",
                                "intensity": "1470.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2199.1252",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0126",
                                        "ppm": "5.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "64",
                                "monoisotopic_mass": "2901.5863",
                                "monoisotopic_mz": "968.2027",
                                "intensity": "3506.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "65",
                                "monoisotopic_mass": "3775.0257",
                                "monoisotopic_mz": "1259.3492",
                                "intensity": "1608.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "66",
                                "monoisotopic_mass": "423.2494",
                                "monoisotopic_mz": "424.2567",
                                "intensity": "1830.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "67",
                                "monoisotopic_mass": "698.3271",
                                "monoisotopic_mz": "699.3343",
                                "intensity": "1570.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "68",
                                "monoisotopic_mass": "1052.6640",
                                "monoisotopic_mz": "1053.6713",
                                "intensity": "1649.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1052.6594",
                                        "ion_position": "40",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0046",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "69",
                                "monoisotopic_mass": "1609.7857",
                                "monoisotopic_mz": "805.9001",
                                "intensity": "1059.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "70",
                                "monoisotopic_mass": "3519.9100",
                                "monoisotopic_mz": "1174.3106",
                                "intensity": "4145.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "71",
                                "monoisotopic_mass": "2793.5345",
                                "monoisotopic_mz": "932.1854",
                                "intensity": "1177.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "72",
                                "monoisotopic_mass": "1804.1125",
                                "monoisotopic_mz": "903.0635",
                                "intensity": "1764.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "73",
                                "monoisotopic_mass": "1624.7521",
                                "monoisotopic_mz": "813.3833",
                                "intensity": "1183.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "74",
                                "monoisotopic_mass": "3902.1136",
                                "monoisotopic_mz": "976.5357",
                                "intensity": "2251.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3902.0982",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0154",
                                        "ppm": "3.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "75",
                                "monoisotopic_mass": "1652.8178",
                                "monoisotopic_mz": "827.4162",
                                "intensity": "1121.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "76",
                                "monoisotopic_mass": "3577.9346",
                                "monoisotopic_mz": "895.4909",
                                "intensity": "3493.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0161",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "77",
                                "monoisotopic_mass": "4262.2466",
                                "monoisotopic_mz": "1421.7562",
                                "intensity": "11001.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0203",
                                        "ppm": "4.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "78",
                                "monoisotopic_mass": "3561.9166",
                                "monoisotopic_mz": "1188.3128",
                                "intensity": "3579.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "79",
                                "monoisotopic_mass": "3660.9781",
                                "monoisotopic_mz": "1221.3333",
                                "intensity": "3961.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "80",
                                "monoisotopic_mass": "3874.1271",
                                "monoisotopic_mz": "1292.3830",
                                "intensity": "4483.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "81",
                                "monoisotopic_mass": "2119.1476",
                                "monoisotopic_mz": "1060.5811",
                                "intensity": "751.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "82",
                                "monoisotopic_mass": "4262.2514",
                                "monoisotopic_mz": "1066.5701",
                                "intensity": "3592.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0251",
                                        "ppm": "5.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "83",
                                "monoisotopic_mass": "3648.0021",
                                "monoisotopic_mz": "913.0078",
                                "intensity": "4017.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "84",
                                "monoisotopic_mass": "4460.4097",
                                "monoisotopic_mz": "1487.8105",
                                "intensity": "2576.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "54",
                                "peak_id": "85",
                                "monoisotopic_mass": "2613.3150",
                                "monoisotopic_mz": "1307.6648",
                                "intensity": "1654.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2613.3003",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0147",
                                        "ppm": "5.62"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "19",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "annotated_seq": "K.KMAGQMGNERVTVQSLDVVRVDAERNLLLVKGAVPGATGSDLIVKPAVKA.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "54",
                                        "peak_id": "54",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "54",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "54",
                                        "peak_id": "63",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "54",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "54",
                                        "peak_id": "85",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "54",
                                        "peak_id": "38",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "54",
                                        "peak_id": "19",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "54",
                                        "peak_id": "40",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "54",
                                            "peak_id": "76",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "54",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "54",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "54",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "54",
                                            "peak_id": "20",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "spec_id": "54",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "37",
                                            "ion_display_position": "13",
                                            "spec_id": "54",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "54",
                                            "peak_id": "74",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "54",
                                            "peak_id": "49",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "10",
                                        "spec_id": "54",
                                        "peak_id": "68",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "54",
                                            "peak_id": "77",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "54",
                                            "peak_id": "82",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "spec_id": "54",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "54",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "spec_id": "54",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "54",
                                        "peak_id": "56",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "30",
                "p_value": "4.23e-09",
                "e_value": "4.23e-09",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "521",
                        "ms1_scans": "587",
                        "ids": "67",
                        "scans": "590",
                        "precursor_mono_mass": "5199.8720",
                        "precursor_charge": "6",
                        "precursor_mz": "867.6526",
                        "feature_inte": "3.5935e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "67",
                                "peak_id": "0",
                                "monoisotopic_mass": "1716.7991",
                                "monoisotopic_mz": "1717.8064",
                                "intensity": "991.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "1",
                                "monoisotopic_mass": "1585.7568",
                                "monoisotopic_mz": "1586.7640",
                                "intensity": "1167.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "2",
                                "monoisotopic_mass": "3194.7073",
                                "monoisotopic_mz": "1065.9097",
                                "intensity": "1310.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "3",
                                "monoisotopic_mass": "3506.9077",
                                "monoisotopic_mz": "1169.9765",
                                "intensity": "1416.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3506.8814",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0264",
                                        "ppm": "7.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "4",
                                "monoisotopic_mass": "1731.9167",
                                "monoisotopic_mz": "866.9656",
                                "intensity": "39532.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "5",
                                "monoisotopic_mass": "1318.7039",
                                "monoisotopic_mz": "1319.7112",
                                "intensity": "1410.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "6",
                                "monoisotopic_mass": "1844.8954",
                                "monoisotopic_mz": "923.4550",
                                "intensity": "952.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1844.8873",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0081",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "7",
                                "monoisotopic_mass": "966.4605",
                                "monoisotopic_mz": "967.4678",
                                "intensity": "1796.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "8",
                                "monoisotopic_mass": "1000.5723",
                                "monoisotopic_mz": "1001.5796",
                                "intensity": "1576.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "9",
                                "monoisotopic_mass": "1346.7267",
                                "monoisotopic_mz": "1347.7340",
                                "intensity": "2135.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "10",
                                "monoisotopic_mass": "3247.7629",
                                "monoisotopic_mz": "1083.5949",
                                "intensity": "2996.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "11",
                                "monoisotopic_mass": "1600.8777",
                                "monoisotopic_mz": "801.4461",
                                "intensity": "2481.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "12",
                                "monoisotopic_mass": "1388.7134",
                                "monoisotopic_mz": "1389.7207",
                                "intensity": "886.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "13",
                                "monoisotopic_mass": "1253.7765",
                                "monoisotopic_mz": "1254.7838",
                                "intensity": "1640.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "14",
                                "monoisotopic_mass": "2123.1871",
                                "monoisotopic_mz": "708.7363",
                                "intensity": "2125.27",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "15",
                                "monoisotopic_mass": "1522.8774",
                                "monoisotopic_mz": "762.4460",
                                "intensity": "1214.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0055",
                                        "ppm": "3.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "16",
                                "monoisotopic_mass": "3677.0012",
                                "monoisotopic_mz": "920.2576",
                                "intensity": "2153.55",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0143",
                                        "ppm": "3.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "17",
                                "monoisotopic_mass": "1434.7701",
                                "monoisotopic_mz": "1435.7773",
                                "intensity": "2198.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "18",
                                "monoisotopic_mass": "1136.5672",
                                "monoisotopic_mz": "1137.5745",
                                "intensity": "4503.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "19",
                                "monoisotopic_mass": "1716.8952",
                                "monoisotopic_mz": "859.4549",
                                "intensity": "1479.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "20",
                                "monoisotopic_mass": "1207.6047",
                                "monoisotopic_mz": "1208.6119",
                                "intensity": "13694.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "21",
                                "monoisotopic_mass": "1702.9059",
                                "monoisotopic_mz": "852.4602",
                                "intensity": "2550.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "22",
                                "monoisotopic_mass": "948.6412",
                                "monoisotopic_mz": "949.6485",
                                "intensity": "1418.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "23",
                                "monoisotopic_mass": "3063.6525",
                                "monoisotopic_mz": "1022.2248",
                                "intensity": "1322.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "24",
                                "monoisotopic_mass": "1744.9475",
                                "monoisotopic_mz": "873.4810",
                                "intensity": "3450.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "25",
                                "monoisotopic_mass": "1297.7658",
                                "monoisotopic_mz": "1298.7731",
                                "intensity": "1055.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1297.7606",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0052",
                                        "ppm": "4.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "26",
                                "monoisotopic_mass": "824.5523",
                                "monoisotopic_mz": "825.5596",
                                "intensity": "1995.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "824.5484",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0039",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "27",
                                "monoisotopic_mass": "1616.8893",
                                "monoisotopic_mz": "809.4519",
                                "intensity": "6354.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "28",
                                "monoisotopic_mass": "3548.9191",
                                "monoisotopic_mz": "1183.9803",
                                "intensity": "6936.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "29",
                                "monoisotopic_mass": "1547.8528",
                                "monoisotopic_mz": "774.9337",
                                "intensity": "6310.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "30",
                                "monoisotopic_mass": "3290.8040",
                                "monoisotopic_mz": "1097.9419",
                                "intensity": "2897.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "31",
                                "monoisotopic_mass": "1023.4820",
                                "monoisotopic_mz": "1024.4893",
                                "intensity": "10420.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "32",
                                "monoisotopic_mass": "1695.9234",
                                "monoisotopic_mz": "1696.9307",
                                "intensity": "2427.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "33",
                                "monoisotopic_mass": "2242.1286",
                                "monoisotopic_mz": "748.3835",
                                "intensity": "1071.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "34",
                                "monoisotopic_mass": "711.4675",
                                "monoisotopic_mz": "712.4748",
                                "intensity": "2603.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0032",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "35",
                                "monoisotopic_mass": "1508.7538",
                                "monoisotopic_mz": "755.3842",
                                "intensity": "1322.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "36",
                                "monoisotopic_mass": "1435.7966",
                                "monoisotopic_mz": "718.9056",
                                "intensity": "1757.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "37",
                                "monoisotopic_mass": "1917.0709",
                                "monoisotopic_mz": "959.5427",
                                "intensity": "1950.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "38",
                                "monoisotopic_mass": "1207.6039",
                                "monoisotopic_mz": "604.8092",
                                "intensity": "1783.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "39",
                                "monoisotopic_mass": "612.3986",
                                "monoisotopic_mz": "613.4059",
                                "intensity": "2900.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "612.3959",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0027",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "40",
                                "monoisotopic_mass": "653.4504",
                                "monoisotopic_mz": "654.4576",
                                "intensity": "2786.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "41",
                                "monoisotopic_mass": "3094.6131",
                                "monoisotopic_mz": "1032.5450",
                                "intensity": "1703.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "42",
                                "monoisotopic_mass": "3388.8659",
                                "monoisotopic_mz": "1130.6292",
                                "intensity": "4153.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "43",
                                "monoisotopic_mass": "3576.9282",
                                "monoisotopic_mz": "895.2393",
                                "intensity": "1306.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "44",
                                "monoisotopic_mass": "585.2420",
                                "monoisotopic_mz": "586.2493",
                                "intensity": "2827.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "45",
                                "monoisotopic_mass": "698.3264",
                                "monoisotopic_mz": "699.3337",
                                "intensity": "1065.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "46",
                                "monoisotopic_mass": "3417.8716",
                                "monoisotopic_mz": "1140.2978",
                                "intensity": "5965.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "47",
                                "monoisotopic_mass": "1420.7545",
                                "monoisotopic_mz": "711.3845",
                                "intensity": "1866.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "48",
                                "monoisotopic_mass": "1023.4817",
                                "monoisotopic_mz": "512.7481",
                                "intensity": "2410.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "49",
                                "monoisotopic_mass": "2963.5744",
                                "monoisotopic_mz": "988.8654",
                                "intensity": "1464.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "50",
                                "monoisotopic_mass": "3577.9351",
                                "monoisotopic_mz": "1193.6523",
                                "intensity": "3065.65",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0166",
                                        "ppm": "4.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "51",
                                "monoisotopic_mass": "3318.8050",
                                "monoisotopic_mz": "1107.2756",
                                "intensity": "5163.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "52",
                                "monoisotopic_mass": "3229.7479",
                                "monoisotopic_mz": "1077.5899",
                                "intensity": "1497.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "53",
                                "monoisotopic_mass": "1419.7544",
                                "monoisotopic_mz": "1420.7617",
                                "intensity": "2051.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "54",
                                "monoisotopic_mass": "1052.6635",
                                "monoisotopic_mz": "1053.6708",
                                "intensity": "656.30",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1052.6594",
                                        "ion_position": "40",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0041",
                                        "ppm": "3.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "55",
                                "monoisotopic_mass": "484.3029",
                                "monoisotopic_mz": "485.3101",
                                "intensity": "4715.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3009",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0019",
                                        "ppm": "4.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "56",
                                "monoisotopic_mass": "2001.0201",
                                "monoisotopic_mz": "668.0140",
                                "intensity": "1336.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "57",
                                "monoisotopic_mass": "1804.1120",
                                "monoisotopic_mz": "903.0633",
                                "intensity": "1113.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "58",
                                "monoisotopic_mass": "3520.9040",
                                "monoisotopic_mz": "1174.6419",
                                "intensity": "3086.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "59",
                                "monoisotopic_mass": "1918.0675",
                                "monoisotopic_mz": "640.3631",
                                "intensity": "878.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "60",
                                "monoisotopic_mass": "3676.9904",
                                "monoisotopic_mz": "1226.6707",
                                "intensity": "2188.98",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0035",
                                        "ppm": "0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "61",
                                "monoisotopic_mass": "2210.2472",
                                "monoisotopic_mz": "1106.1309",
                                "intensity": "525.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "62",
                                "monoisotopic_mass": "3449.8389",
                                "monoisotopic_mz": "1150.9536",
                                "intensity": "3824.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0211",
                                        "ppm": "-6.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "63",
                                "monoisotopic_mass": "1632.8712",
                                "monoisotopic_mz": "817.4429",
                                "intensity": "1555.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "64",
                                "monoisotopic_mass": "2578.2724",
                                "monoisotopic_mz": "860.4314",
                                "intensity": "2272.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "65",
                                "monoisotopic_mass": "3160.7453",
                                "monoisotopic_mz": "1054.5890",
                                "intensity": "728.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "66",
                                "monoisotopic_mass": "2396.1989",
                                "monoisotopic_mz": "1199.1067",
                                "intensity": "398.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "67",
                                "monoisotopic_mass": "3648.9957",
                                "monoisotopic_mz": "1217.3392",
                                "intensity": "2489.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "68",
                                "monoisotopic_mass": "3223.7146",
                                "monoisotopic_mz": "806.9359",
                                "intensity": "893.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "69",
                                "monoisotopic_mass": "3427.7794",
                                "monoisotopic_mz": "857.9521",
                                "intensity": "8018.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "70",
                                "monoisotopic_mass": "2594.2902",
                                "monoisotopic_mz": "865.7707",
                                "intensity": "17415.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "71",
                                "monoisotopic_mass": "3468.8501",
                                "monoisotopic_mz": "868.2198",
                                "intensity": "11603.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "72",
                                "monoisotopic_mass": "2479.2613",
                                "monoisotopic_mz": "827.4277",
                                "intensity": "2110.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "73",
                                "monoisotopic_mass": "3347.8308",
                                "monoisotopic_mz": "1116.9509",
                                "intensity": "1063.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "74",
                                "monoisotopic_mass": "3472.8622",
                                "monoisotopic_mz": "1158.6280",
                                "intensity": "440.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "75",
                                "monoisotopic_mass": "3078.6613",
                                "monoisotopic_mz": "1027.2277",
                                "intensity": "1542.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "76",
                                "monoisotopic_mass": "2013.1171",
                                "monoisotopic_mz": "672.0463",
                                "intensity": "1091.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "77",
                                "monoisotopic_mass": "2979.5155",
                                "monoisotopic_mz": "994.1791",
                                "intensity": "1472.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "78",
                                "monoisotopic_mass": "5189.9366",
                                "monoisotopic_mz": "865.9967",
                                "intensity": "12162.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "79",
                                "monoisotopic_mass": "2020.1427",
                                "monoisotopic_mz": "1011.0786",
                                "intensity": "912.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "80",
                                "monoisotopic_mass": "2153.0889",
                                "monoisotopic_mz": "1077.5517",
                                "intensity": "2853.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "67",
                                "peak_id": "81",
                                "monoisotopic_mass": "2413.2351",
                                "monoisotopic_mz": "1207.6249",
                                "intensity": "1534.71",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2413.2206",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0146",
                                        "ppm": "6.03"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "19",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "annotated_seq": "K.KMAGQMGNERVTVQSLDVVRVDAERNLLLVKGAVPGATGSDLIVKPAVKA.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "67",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "67",
                                        "peak_id": "81",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "67",
                                        "peak_id": "62",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "67",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "67",
                                        "peak_id": "50",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "67",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "67",
                                            "peak_id": "60",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "67",
                                            "peak_id": "16",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "spec_id": "67",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "10",
                                        "spec_id": "67",
                                        "peak_id": "54",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "spec_id": "67",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "67",
                                        "peak_id": "34",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "spec_id": "67",
                                        "peak_id": "39",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "67",
                                        "peak_id": "55",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "43",
                "p_value": "1.07e-07",
                "e_value": "1.07e-07",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "527",
                        "ms1_scans": "611",
                        "ids": "83",
                        "scans": "612",
                        "precursor_mono_mass": "5199.8721",
                        "precursor_charge": "5",
                        "precursor_mz": "1040.9817",
                        "feature_inte": "3.5935e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "83",
                                "peak_id": "0",
                                "monoisotopic_mass": "1615.7659",
                                "monoisotopic_mz": "1616.7732",
                                "intensity": "699.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "1",
                                "monoisotopic_mass": "1729.8114",
                                "monoisotopic_mz": "1730.8187",
                                "intensity": "2280.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "2",
                                "monoisotopic_mass": "1529.8011",
                                "monoisotopic_mz": "1530.8083",
                                "intensity": "1698.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "3",
                                "monoisotopic_mass": "1551.7801",
                                "monoisotopic_mz": "1552.7874",
                                "intensity": "1577.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "4",
                                "monoisotopic_mass": "1430.7682",
                                "monoisotopic_mz": "1431.7755",
                                "intensity": "928.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "5",
                                "monoisotopic_mass": "1288.7470",
                                "monoisotopic_mz": "1289.7543",
                                "intensity": "2244.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "6",
                                "monoisotopic_mass": "3902.1108",
                                "monoisotopic_mz": "1301.7109",
                                "intensity": "1572.60",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3902.0982",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0126",
                                        "ppm": "3.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "7",
                                "monoisotopic_mass": "1740.8502",
                                "monoisotopic_mz": "871.4324",
                                "intensity": "1891.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "8",
                                "monoisotopic_mass": "1724.8841",
                                "monoisotopic_mz": "863.4493",
                                "intensity": "2173.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "9",
                                "monoisotopic_mass": "3649.0144",
                                "monoisotopic_mz": "1217.3454",
                                "intensity": "7316.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "10",
                                "monoisotopic_mass": "1702.9019",
                                "monoisotopic_mz": "852.4583",
                                "intensity": "3341.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "11",
                                "monoisotopic_mass": "1980.0457",
                                "monoisotopic_mz": "991.0301",
                                "intensity": "28799.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "12",
                                "monoisotopic_mass": "3677.0046",
                                "monoisotopic_mz": "1226.6755",
                                "intensity": "7819.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0177",
                                        "ppm": "4.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "13",
                                "monoisotopic_mass": "2810.5537",
                                "monoisotopic_mz": "937.8585",
                                "intensity": "5114.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "14",
                                "monoisotopic_mass": "1251.6888",
                                "monoisotopic_mz": "1252.6960",
                                "intensity": "1260.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "15",
                                "monoisotopic_mass": "1567.7451",
                                "monoisotopic_mz": "784.8798",
                                "intensity": "2910.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "16",
                                "monoisotopic_mass": "3549.9390",
                                "monoisotopic_mz": "1184.3203",
                                "intensity": "5228.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "17",
                                "monoisotopic_mass": "1962.0171",
                                "monoisotopic_mz": "982.0158",
                                "intensity": "1562.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "18",
                                "monoisotopic_mass": "847.4054",
                                "monoisotopic_mz": "848.4127",
                                "intensity": "2614.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "19",
                                "monoisotopic_mass": "1551.7807",
                                "monoisotopic_mz": "776.8976",
                                "intensity": "2856.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "20",
                                "monoisotopic_mass": "2315.0883",
                                "monoisotopic_mz": "772.7034",
                                "intensity": "1687.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "21",
                                "monoisotopic_mass": "1359.7334",
                                "monoisotopic_mz": "1360.7407",
                                "intensity": "2116.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "22",
                                "monoisotopic_mass": "1825.0791",
                                "monoisotopic_mz": "913.5468",
                                "intensity": "1637.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "23",
                                "monoisotopic_mass": "3676.9969",
                                "monoisotopic_mz": "920.2565",
                                "intensity": "1925.62",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0100",
                                        "ppm": "2.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "24",
                                "monoisotopic_mass": "1589.7259",
                                "monoisotopic_mz": "795.8702",
                                "intensity": "2234.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "25",
                                "monoisotopic_mass": "2016.9958",
                                "monoisotopic_mz": "1009.5052",
                                "intensity": "866.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "26",
                                "monoisotopic_mass": "1450.8189",
                                "monoisotopic_mz": "726.4167",
                                "intensity": "1048.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "27",
                                "monoisotopic_mass": "777.3951",
                                "monoisotopic_mz": "778.4023",
                                "intensity": "1264.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "28",
                                "monoisotopic_mass": "3384.8196",
                                "monoisotopic_mz": "1129.2805",
                                "intensity": "1830.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "29",
                                "monoisotopic_mass": "1283.5794",
                                "monoisotopic_mz": "642.7970",
                                "intensity": "793.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "30",
                                "monoisotopic_mass": "3321.7881",
                                "monoisotopic_mz": "1108.2700",
                                "intensity": "1873.87",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0232",
                                        "ppm": "6.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "31",
                                "monoisotopic_mass": "1611.7085",
                                "monoisotopic_mz": "806.8615",
                                "intensity": "1016.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "32",
                                "monoisotopic_mass": "612.3981",
                                "monoisotopic_mz": "613.4053",
                                "intensity": "1631.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "612.3959",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0022",
                                        "ppm": "3.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "33",
                                "monoisotopic_mass": "542.1409",
                                "monoisotopic_mz": "543.1481",
                                "intensity": "2515.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "34",
                                "monoisotopic_mass": "567.3769",
                                "monoisotopic_mz": "568.3842",
                                "intensity": "1878.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "35",
                                "monoisotopic_mass": "3506.8968",
                                "monoisotopic_mz": "1169.9729",
                                "intensity": "2055.49",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3506.8814",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0154",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "36",
                                "monoisotopic_mass": "711.4674",
                                "monoisotopic_mz": "712.4747",
                                "intensity": "1218.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0031",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "37",
                                "monoisotopic_mass": "484.3029",
                                "monoisotopic_mz": "485.3102",
                                "intensity": "3336.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3009",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0020",
                                        "ppm": "4.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "38",
                                "monoisotopic_mass": "472.2191",
                                "monoisotopic_mz": "473.2264",
                                "intensity": "1327.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "39",
                                "monoisotopic_mass": "3577.9417",
                                "monoisotopic_mz": "1193.6545",
                                "intensity": "7619.40",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0232",
                                        "ppm": "6.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "40",
                                "monoisotopic_mass": "1365.7325",
                                "monoisotopic_mz": "683.8735",
                                "intensity": "947.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "41",
                                "monoisotopic_mass": "1214.3224",
                                "monoisotopic_mz": "1215.3297",
                                "intensity": "527.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "42",
                                "monoisotopic_mass": "395.2549",
                                "monoisotopic_mz": "396.2621",
                                "intensity": "1976.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "43",
                                "monoisotopic_mass": "1177.6789",
                                "monoisotopic_mz": "1178.6862",
                                "intensity": "996.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "44",
                                "monoisotopic_mass": "417.2140",
                                "monoisotopic_mz": "418.2213",
                                "intensity": "2705.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "45",
                                "monoisotopic_mass": "1398.7041",
                                "monoisotopic_mz": "700.3593",
                                "intensity": "360.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "46",
                                "monoisotopic_mass": "1666.7684",
                                "monoisotopic_mz": "834.3915",
                                "intensity": "1245.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "47",
                                "monoisotopic_mass": "2854.5183",
                                "monoisotopic_mz": "952.5134",
                                "intensity": "1274.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "48",
                                "monoisotopic_mass": "4262.2525",
                                "monoisotopic_mz": "1421.7581",
                                "intensity": "2786.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0262",
                                        "ppm": "6.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "49",
                                "monoisotopic_mass": "632.7849",
                                "monoisotopic_mz": "633.7922",
                                "intensity": "1123.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "50",
                                "monoisotopic_mass": "3450.8537",
                                "monoisotopic_mz": "1151.2918",
                                "intensity": "1817.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "51",
                                "monoisotopic_mass": "824.5514",
                                "monoisotopic_mz": "825.5587",
                                "intensity": "812.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "824.5484",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0030",
                                        "ppm": "3.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "52",
                                "monoisotopic_mass": "764.8997",
                                "monoisotopic_mz": "765.9070",
                                "intensity": "1645.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "53",
                                "monoisotopic_mass": "454.2921",
                                "monoisotopic_mz": "455.2994",
                                "intensity": "1492.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "54",
                                "monoisotopic_mass": "3417.8621",
                                "monoisotopic_mz": "1140.2946",
                                "intensity": "2416.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "55",
                                "monoisotopic_mass": "1117.5674",
                                "monoisotopic_mz": "1118.5747",
                                "intensity": "303.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "56",
                                "monoisotopic_mass": "3487.8724",
                                "monoisotopic_mz": "1163.6314",
                                "intensity": "1432.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "57",
                                "monoisotopic_mass": "2831.5335",
                                "monoisotopic_mz": "944.8518",
                                "intensity": "1255.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "58",
                                "monoisotopic_mass": "3117.7291",
                                "monoisotopic_mz": "1040.2503",
                                "intensity": "6201.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "59",
                                "monoisotopic_mass": "1995.0672",
                                "monoisotopic_mz": "998.5409",
                                "intensity": "625.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "60",
                                "monoisotopic_mass": "4156.4717",
                                "monoisotopic_mz": "1040.1252",
                                "intensity": "4592.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "61",
                                "monoisotopic_mass": "3220.7577",
                                "monoisotopic_mz": "1074.5932",
                                "intensity": "513.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "62",
                                "monoisotopic_mass": "2078.0175",
                                "monoisotopic_mz": "1040.0160",
                                "intensity": "2068.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "63",
                                "monoisotopic_mass": "2412.2290",
                                "monoisotopic_mz": "1207.1218",
                                "intensity": "3295.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "64",
                                "monoisotopic_mass": "1874.2635",
                                "monoisotopic_mz": "938.1391",
                                "intensity": "670.86",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "19",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "annotated_seq": "K.KMAGQMGNERVTVQSLDVVRVDAERNLLLVKGAVPGATGSDLIVKPAVKA.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "83",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "83",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "83",
                                        "peak_id": "39",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "83",
                                            "peak_id": "23",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "83",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "83",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "83",
                                        "peak_id": "48",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "spec_id": "83",
                                        "peak_id": "51",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "83",
                                        "peak_id": "36",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "6",
                                        "spec_id": "83",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "83",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "5",
                "p_value": "5.06e-06",
                "e_value": "5.06e-06",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "503",
                        "ms1_scans": "536",
                        "ids": "32",
                        "scans": "537",
                        "precursor_mono_mass": "5199.8721",
                        "precursor_charge": "5",
                        "precursor_mz": "1040.9817",
                        "feature_inte": "3.5935e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "32",
                                "peak_id": "0",
                                "monoisotopic_mass": "1630.8304",
                                "monoisotopic_mz": "1631.8376",
                                "intensity": "1388.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "1",
                                "monoisotopic_mass": "1460.7370",
                                "monoisotopic_mz": "1461.7443",
                                "intensity": "3388.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "2",
                                "monoisotopic_mass": "1522.8802",
                                "monoisotopic_mz": "1523.8874",
                                "intensity": "2122.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0083",
                                        "ppm": "5.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "3",
                                "monoisotopic_mass": "1614.8641",
                                "monoisotopic_mz": "1615.8713",
                                "intensity": "2100.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "4",
                                "monoisotopic_mass": "1552.8255",
                                "monoisotopic_mz": "1553.8328",
                                "intensity": "2964.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "5",
                                "monoisotopic_mass": "2062.0145",
                                "monoisotopic_mz": "1032.0145",
                                "intensity": "4872.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "6",
                                "monoisotopic_mass": "583.3713",
                                "monoisotopic_mz": "584.3785",
                                "intensity": "3430.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "7",
                                "monoisotopic_mass": "1719.9330",
                                "monoisotopic_mz": "860.9738",
                                "intensity": "1045.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "8",
                                "monoisotopic_mass": "1844.8957",
                                "monoisotopic_mz": "1845.9030",
                                "intensity": "1787.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1844.8873",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0084",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "9",
                                "monoisotopic_mass": "1783.0148",
                                "monoisotopic_mz": "892.5147",
                                "intensity": "3771.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "10",
                                "monoisotopic_mass": "802.4762",
                                "monoisotopic_mz": "803.4835",
                                "intensity": "1809.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "11",
                                "monoisotopic_mass": "1142.6707",
                                "monoisotopic_mz": "1143.6780",
                                "intensity": "2219.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "12",
                                "monoisotopic_mass": "3677.0010",
                                "monoisotopic_mz": "1226.6743",
                                "intensity": "9841.92",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0141",
                                        "ppm": "3.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "13",
                                "monoisotopic_mass": "842.4756",
                                "monoisotopic_mz": "843.4828",
                                "intensity": "1884.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "14",
                                "monoisotopic_mass": "2883.5721",
                                "monoisotopic_mz": "962.1980",
                                "intensity": "1740.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "15",
                                "monoisotopic_mass": "1361.6661",
                                "monoisotopic_mz": "1362.6733",
                                "intensity": "2311.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "16",
                                "monoisotopic_mass": "1562.8529",
                                "monoisotopic_mz": "782.4337",
                                "intensity": "5490.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "17",
                                "monoisotopic_mass": "1592.8846",
                                "monoisotopic_mz": "797.4496",
                                "intensity": "2482.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "18",
                                "monoisotopic_mass": "1830.0145",
                                "monoisotopic_mz": "916.0145",
                                "intensity": "3711.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "19",
                                "monoisotopic_mass": "3319.8003",
                                "monoisotopic_mz": "1107.6074",
                                "intensity": "1916.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "20",
                                "monoisotopic_mass": "1164.6539",
                                "monoisotopic_mz": "1165.6611",
                                "intensity": "2415.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "21",
                                "monoisotopic_mass": "1961.0517",
                                "monoisotopic_mz": "981.5331",
                                "intensity": "3329.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "22",
                                "monoisotopic_mass": "3549.9349",
                                "monoisotopic_mz": "1184.3189",
                                "intensity": "7060.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "23",
                                "monoisotopic_mass": "1614.8642",
                                "monoisotopic_mz": "808.4394",
                                "intensity": "1224.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "24",
                                "monoisotopic_mass": "3577.9329",
                                "monoisotopic_mz": "1193.6516",
                                "intensity": "7769.10",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0144",
                                        "ppm": "4.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "25",
                                "monoisotopic_mass": "3649.0078",
                                "monoisotopic_mz": "1217.3432",
                                "intensity": "8487.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "26",
                                "monoisotopic_mass": "2079.0380",
                                "monoisotopic_mz": "1040.5263",
                                "intensity": "33101.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "27",
                                "monoisotopic_mass": "937.6354",
                                "monoisotopic_mz": "938.6427",
                                "intensity": "739.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "937.6324",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0030",
                                        "ppm": "3.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "28",
                                "monoisotopic_mass": "2251.2295",
                                "monoisotopic_mz": "751.4171",
                                "intensity": "1281.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "29",
                                "monoisotopic_mass": "1433.7426",
                                "monoisotopic_mz": "717.8786",
                                "intensity": "1143.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "30",
                                "monoisotopic_mass": "3449.8795",
                                "monoisotopic_mz": "1150.9671",
                                "intensity": "2252.64",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0196",
                                        "ppm": "5.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "31",
                                "monoisotopic_mass": "1812.0003",
                                "monoisotopic_mz": "907.0074",
                                "intensity": "1657.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "32",
                                "monoisotopic_mass": "1026.5304",
                                "monoisotopic_mz": "1027.5377",
                                "intensity": "1508.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "33",
                                "monoisotopic_mass": "1105.6510",
                                "monoisotopic_mz": "553.8328",
                                "intensity": "1203.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "34",
                                "monoisotopic_mass": "1255.7546",
                                "monoisotopic_mz": "628.8846",
                                "intensity": "1485.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "35",
                                "monoisotopic_mass": "1636.8443",
                                "monoisotopic_mz": "819.4294",
                                "intensity": "1684.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "36",
                                "monoisotopic_mass": "3114.6774",
                                "monoisotopic_mz": "1039.2331",
                                "intensity": "54618.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "37",
                                "monoisotopic_mass": "1297.7659",
                                "monoisotopic_mz": "1298.7732",
                                "intensity": "847.44",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1297.7606",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0054",
                                        "ppm": "4.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "38",
                                "monoisotopic_mass": "2119.1447",
                                "monoisotopic_mz": "707.3888",
                                "intensity": "5694.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "39",
                                "monoisotopic_mass": "596.0705",
                                "monoisotopic_mz": "597.0778",
                                "intensity": "1010.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "40",
                                "monoisotopic_mass": "756.8770",
                                "monoisotopic_mz": "757.8843",
                                "intensity": "522.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "41",
                                "monoisotopic_mass": "3097.6622",
                                "monoisotopic_mz": "1033.5613",
                                "intensity": "4689.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "42",
                                "monoisotopic_mass": "1361.6618",
                                "monoisotopic_mz": "681.8382",
                                "intensity": "947.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "43",
                                "monoisotopic_mass": "484.3026",
                                "monoisotopic_mz": "485.3099",
                                "intensity": "4553.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3009",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "3.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "44",
                                "monoisotopic_mass": "542.1405",
                                "monoisotopic_mz": "543.1478",
                                "intensity": "3401.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "45",
                                "monoisotopic_mass": "1460.7357",
                                "monoisotopic_mz": "731.3751",
                                "intensity": "1281.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "46",
                                "monoisotopic_mass": "2119.1432",
                                "monoisotopic_mz": "1060.5789",
                                "intensity": "1953.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "47",
                                "monoisotopic_mass": "1487.7066",
                                "monoisotopic_mz": "744.8606",
                                "intensity": "1313.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "48",
                                "monoisotopic_mass": "1446.7375",
                                "monoisotopic_mz": "724.3760",
                                "intensity": "783.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "49",
                                "monoisotopic_mass": "1180.6170",
                                "monoisotopic_mz": "591.3158",
                                "intensity": "808.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "50",
                                "monoisotopic_mass": "455.2759",
                                "monoisotopic_mz": "456.2832",
                                "intensity": "2354.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "51",
                                "monoisotopic_mass": "698.3263",
                                "monoisotopic_mz": "699.3336",
                                "intensity": "992.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "52",
                                "monoisotopic_mass": "395.2545",
                                "monoisotopic_mz": "396.2617",
                                "intensity": "1961.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "53",
                                "monoisotopic_mass": "2900.5836",
                                "monoisotopic_mz": "967.8685",
                                "intensity": "8917.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "54",
                                "monoisotopic_mass": "1653.8170",
                                "monoisotopic_mz": "827.9158",
                                "intensity": "943.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "55",
                                "monoisotopic_mass": "2035.0069",
                                "monoisotopic_mz": "1018.5107",
                                "intensity": "881.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "56",
                                "monoisotopic_mass": "3417.8639",
                                "monoisotopic_mz": "1140.2953",
                                "intensity": "2580.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "57",
                                "monoisotopic_mass": "4031.1653",
                                "monoisotopic_mz": "1008.7986",
                                "intensity": "554.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "58",
                                "monoisotopic_mass": "4261.2428",
                                "monoisotopic_mz": "1421.4216",
                                "intensity": "2762.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "59",
                                "monoisotopic_mass": "3506.8920",
                                "monoisotopic_mz": "1169.9713",
                                "intensity": "1989.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3506.8814",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0106",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "60",
                                "monoisotopic_mass": "2008.0006",
                                "monoisotopic_mz": "1005.0076",
                                "intensity": "2178.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "61",
                                "monoisotopic_mass": "3648.0043",
                                "monoisotopic_mz": "913.0083",
                                "intensity": "1238.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "62",
                                "monoisotopic_mass": "2614.3733",
                                "monoisotopic_mz": "1308.1939",
                                "intensity": "1307.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "63",
                                "monoisotopic_mass": "2412.2273",
                                "monoisotopic_mz": "1207.1209",
                                "intensity": "3310.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "64",
                                "monoisotopic_mass": "1879.8851",
                                "monoisotopic_mz": "940.9498",
                                "intensity": "829.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "65",
                                "monoisotopic_mass": "3873.1289",
                                "monoisotopic_mz": "1292.0502",
                                "intensity": "889.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "32",
                                "peak_id": "66",
                                "monoisotopic_mass": "4160.2485",
                                "monoisotopic_mz": "1041.0694",
                                "intensity": "3751.35",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "19",
                    "proteoform_id": "19",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "annotated_seq": "K.KMAGQMGNERVTVQSLDVVRVDAERNLLLVKGAVPGATGSDLIVKPAVKA.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "32",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "32",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "32",
                                        "peak_id": "59",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "32",
                                        "peak_id": "24",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "32",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "32",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "spec_id": "32",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "spec_id": "32",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "32",
                                        "peak_id": "43",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
