prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "16",
        "sequence_name": "sp|P0ADE6|KBP_ECOLI",
        "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
        "proteoform_id": "16",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "46",
            "p_value": "8.66e-20",
            "e_value": "8.66e-20",
            "fdr": "0",
            "matched_fragment_number": "22",
            "matched_peak_number": "24",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                    "ms1_ids": "530",
                    "ms1_scans": "623",
                    "ids": "92",
                    "scans": "624",
                    "precursor_mono_mass": "16105.2157",
                    "precursor_charge": "8",
                    "precursor_mz": "2014.1592",
                    "feature_inte": "7.8845e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "92",
                            "peak_id": "0",
                            "monoisotopic_mass": "1839.9878",
                            "monoisotopic_mz": "1840.9950",
                            "intensity": "4912.86",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1839.9731",
                                    "ion_position": "132",
                                    "ion_display_position": "16",
                                    "ion_sort_name": "Y00016",
                                    "ion_left_position": "132",
                                    "mass_error": "0.0147",
                                    "ppm": "7.99"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "1",
                            "monoisotopic_mass": "1434.7396",
                            "monoisotopic_mz": "1435.7468",
                            "intensity": "1124.81",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "2",
                            "monoisotopic_mass": "1702.9051",
                            "monoisotopic_mz": "1703.9124",
                            "intensity": "1951.06",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "3",
                            "monoisotopic_mass": "2786.3250",
                            "monoisotopic_mz": "2787.3323",
                            "intensity": "2063.73",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2786.3300",
                                    "ion_position": "25",
                                    "ion_display_position": "25",
                                    "ion_sort_name": "B00025",
                                    "ion_left_position": "25",
                                    "mass_error": "-0.0050",
                                    "ppm": "-1.78"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "4",
                            "monoisotopic_mass": "2309.2518",
                            "monoisotopic_mz": "2310.2591",
                            "intensity": "8076.68",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2309.2453",
                                    "ion_position": "128",
                                    "ion_display_position": "20",
                                    "ion_sort_name": "Y00020",
                                    "ion_left_position": "128",
                                    "mass_error": "0.0065",
                                    "ppm": "2.80"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "5",
                            "monoisotopic_mass": "1752.9533",
                            "monoisotopic_mz": "1753.9606",
                            "intensity": "4454.96",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1752.9410",
                                    "ion_position": "133",
                                    "ion_display_position": "15",
                                    "ion_sort_name": "Y00015",
                                    "ion_left_position": "133",
                                    "mass_error": "0.0123",
                                    "ppm": "6.99"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "6",
                            "monoisotopic_mass": "2622.4227",
                            "monoisotopic_mz": "2623.4300",
                            "intensity": "1596.64",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2622.4203",
                                    "ion_position": "125",
                                    "ion_display_position": "23",
                                    "ion_sort_name": "Y00023",
                                    "ion_left_position": "125",
                                    "mass_error": "0.0024",
                                    "ppm": "0.90"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "7",
                            "monoisotopic_mass": "2428.1886",
                            "monoisotopic_mz": "2429.1958",
                            "intensity": "2243.09",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2428.1812",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "ion_sort_name": "B00022",
                                    "ion_left_position": "22",
                                    "mass_error": "0.0074",
                                    "ppm": "3.05"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "8",
                            "monoisotopic_mass": "1881.9608",
                            "monoisotopic_mz": "1882.9681",
                            "intensity": "1154.01",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "9",
                            "monoisotopic_mass": "1979.0453",
                            "monoisotopic_mz": "990.5299",
                            "intensity": "4534.09",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "10",
                            "monoisotopic_mass": "1540.8708",
                            "monoisotopic_mz": "1541.8781",
                            "intensity": "9771.24",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1540.8613",
                                    "ion_position": "135",
                                    "ion_display_position": "13",
                                    "ion_sort_name": "Y00013",
                                    "ion_left_position": "135",
                                    "mass_error": "0.0095",
                                    "ppm": "6.13"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "11",
                            "monoisotopic_mass": "3920.0182",
                            "monoisotopic_mz": "1961.0164",
                            "intensity": "2393.83",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "12",
                            "monoisotopic_mass": "1606.8405",
                            "monoisotopic_mz": "1607.8478",
                            "intensity": "2090.61",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "13",
                            "monoisotopic_mass": "1299.6902",
                            "monoisotopic_mz": "1300.6975",
                            "intensity": "3188.07",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1299.6823",
                                    "ion_position": "137",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "Y00011",
                                    "ion_left_position": "137",
                                    "mass_error": "0.0079",
                                    "ppm": "6.10"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "14",
                            "monoisotopic_mass": "1702.9027",
                            "monoisotopic_mz": "852.4586",
                            "intensity": "3580.35",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "15",
                            "monoisotopic_mass": "1412.7729",
                            "monoisotopic_mz": "1413.7801",
                            "intensity": "1175.76",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1412.7664",
                                    "ion_position": "136",
                                    "ion_display_position": "12",
                                    "ion_sort_name": "Y00012",
                                    "ion_left_position": "136",
                                    "mass_error": "0.0065",
                                    "ppm": "4.60"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "16",
                            "monoisotopic_mass": "847.4056",
                            "monoisotopic_mz": "848.4128",
                            "intensity": "4066.46",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "17",
                            "monoisotopic_mass": "1136.6248",
                            "monoisotopic_mz": "1137.6321",
                            "intensity": "4544.49",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1136.6190",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "138",
                                    "mass_error": "0.0058",
                                    "ppm": "5.13"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "18",
                            "monoisotopic_mass": "920.4799",
                            "monoisotopic_mz": "921.4871",
                            "intensity": "3816.17",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "920.4756",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "B00008",
                                    "ion_left_position": "8",
                                    "mass_error": "0.0042",
                                    "ppm": "4.61"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "19",
                            "monoisotopic_mass": "1799.9133",
                            "monoisotopic_mz": "1800.9206",
                            "intensity": "1221.66",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "20",
                            "monoisotopic_mass": "1719.8708",
                            "monoisotopic_mz": "1720.8781",
                            "intensity": "4974.87",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1719.8621",
                                    "ion_position": "15",
                                    "ion_display_position": "15",
                                    "ion_sort_name": "B00015",
                                    "ion_left_position": "15",
                                    "mass_error": "0.0087",
                                    "ppm": "5.07"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "21",
                            "monoisotopic_mass": "4068.0831",
                            "monoisotopic_mz": "2035.0489",
                            "intensity": "2131.03",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "22",
                            "monoisotopic_mass": "632.3347",
                            "monoisotopic_mz": "633.3420",
                            "intensity": "1127.72",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "23",
                            "monoisotopic_mass": "1463.7214",
                            "monoisotopic_mz": "1464.7286",
                            "intensity": "2118.20",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "24",
                            "monoisotopic_mass": "2309.2484",
                            "monoisotopic_mz": "1155.6315",
                            "intensity": "1376.77",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2309.2453",
                                    "ion_position": "128",
                                    "ion_display_position": "20",
                                    "ion_sort_name": "Y00020",
                                    "ion_left_position": "128",
                                    "mass_error": "0.0031",
                                    "ppm": "1.34"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "25",
                            "monoisotopic_mass": "578.2872",
                            "monoisotopic_mz": "579.2945",
                            "intensity": "881.85",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "578.2853",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "ion_sort_name": "B00005",
                                    "ion_left_position": "5",
                                    "mass_error": "0.0019",
                                    "ppm": "3.35"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "26",
                            "monoisotopic_mass": "2180.1041",
                            "monoisotopic_mz": "2181.1114",
                            "intensity": "2034.69",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "27",
                            "monoisotopic_mass": "752.4041",
                            "monoisotopic_mz": "753.4114",
                            "intensity": "1094.93",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "28",
                            "monoisotopic_mass": "3776.0907",
                            "monoisotopic_mz": "1259.7042",
                            "intensity": "1967.16",
                            "charge": "3"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "29",
                            "monoisotopic_mass": "1279.6493",
                            "monoisotopic_mz": "1280.6566",
                            "intensity": "770.63",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "30",
                            "monoisotopic_mass": "1177.5812",
                            "monoisotopic_mz": "1178.5885",
                            "intensity": "725.03",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1177.5768",
                                    "ion_position": "11",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "B00011",
                                    "ion_left_position": "11",
                                    "mass_error": "0.0044",
                                    "ppm": "3.78"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "31",
                            "monoisotopic_mass": "2898.5397",
                            "monoisotopic_mz": "1450.2771",
                            "intensity": "1622.40",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2898.5314",
                                    "ion_position": "123",
                                    "ion_display_position": "25",
                                    "ion_sort_name": "Y00025",
                                    "ion_left_position": "123",
                                    "mass_error": "0.0083",
                                    "ppm": "2.88"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "32",
                            "monoisotopic_mass": "2810.5595",
                            "monoisotopic_mz": "1406.2870",
                            "intensity": "2475.27",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "33",
                            "monoisotopic_mass": "5453.8196",
                            "monoisotopic_mz": "1818.9471",
                            "intensity": "3644.07",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5454.7961",
                                    "ion_position": "49",
                                    "ion_display_position": "49",
                                    "ion_sort_name": "B00049",
                                    "ion_left_position": "49",
                                    "mass_error": "0.0259",
                                    "ppm": "4.75"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "34",
                            "monoisotopic_mass": "2786.3432",
                            "monoisotopic_mz": "1394.1789",
                            "intensity": "1392.83",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2786.3300",
                                    "ion_position": "25",
                                    "ion_display_position": "25",
                                    "ion_sort_name": "B00025",
                                    "ion_left_position": "25",
                                    "mass_error": "0.0131",
                                    "ppm": "4.72"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "35",
                            "monoisotopic_mass": "4232.1528",
                            "monoisotopic_mz": "2117.0837",
                            "intensity": "3286.74",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "183.0616730376",
                                    "theoretical_mass": "4232.1701",
                                    "ion_position": "113",
                                    "ion_display_position": "35",
                                    "ion_sort_name": "Y00035",
                                    "ion_left_position": "113",
                                    "mass_error": "-0.0173",
                                    "ppm": "-4.09"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "36",
                            "monoisotopic_mass": "3064.6015",
                            "monoisotopic_mz": "1533.3080",
                            "intensity": "1229.67",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "37",
                            "monoisotopic_mass": "1363.6866",
                            "monoisotopic_mz": "1364.6938",
                            "intensity": "1048.71",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "38",
                            "monoisotopic_mass": "1375.7449",
                            "monoisotopic_mz": "1376.7522",
                            "intensity": "371.59",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "39",
                            "monoisotopic_mass": "5473.7623",
                            "monoisotopic_mz": "1825.5947",
                            "intensity": "1603.08",
                            "charge": "3"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "40",
                            "monoisotopic_mass": "2897.5336",
                            "monoisotopic_mz": "2898.5409",
                            "intensity": "1181.30",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "41",
                            "monoisotopic_mass": "5437.7744",
                            "monoisotopic_mz": "1813.5987",
                            "intensity": "1892.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "42",
                            "monoisotopic_mass": "1400.7508",
                            "monoisotopic_mz": "1401.7581",
                            "intensity": "386.91",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "43",
                            "monoisotopic_mass": "2211.1159",
                            "monoisotopic_mz": "2212.1232",
                            "intensity": "1248.85",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "44",
                            "monoisotopic_mass": "1196.6836",
                            "monoisotopic_mz": "1197.6909",
                            "intensity": "350.76",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "45",
                            "monoisotopic_mass": "5417.7874",
                            "monoisotopic_mz": "1806.9364",
                            "intensity": "2214.05",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "183.0616730376",
                                    "theoretical_mass": "5418.7895",
                                    "ion_position": "101",
                                    "ion_display_position": "47",
                                    "ion_sort_name": "Y00047",
                                    "ion_left_position": "101",
                                    "mass_error": "0.0003",
                                    "ppm": "0.05"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "46",
                            "monoisotopic_mass": "4760.3861",
                            "monoisotopic_mz": "2381.2003",
                            "intensity": "1405.01",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "47",
                            "monoisotopic_mass": "1967.0753",
                            "monoisotopic_mz": "1968.0825",
                            "intensity": "1992.65",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "48",
                            "monoisotopic_mass": "1868.9423",
                            "monoisotopic_mz": "1869.9495",
                            "intensity": "1553.41",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "49",
                            "monoisotopic_mass": "4674.4205",
                            "monoisotopic_mz": "2338.2175",
                            "intensity": "3830.00",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "183.0616730376",
                                    "theoretical_mass": "4674.4241",
                                    "ion_position": "109",
                                    "ion_display_position": "39",
                                    "ion_sort_name": "Y00039",
                                    "ion_left_position": "109",
                                    "mass_error": "-0.0036",
                                    "ppm": "-0.78"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "50",
                            "monoisotopic_mass": "8772.6987",
                            "monoisotopic_mz": "1755.5470",
                            "intensity": "1697.77",
                            "charge": "5"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "51",
                            "monoisotopic_mass": "1954.0122",
                            "monoisotopic_mz": "1955.0194",
                            "intensity": "691.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "52",
                            "monoisotopic_mass": "4331.2485",
                            "monoisotopic_mz": "2166.6315",
                            "intensity": "2229.24",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "183.0616730376",
                                    "theoretical_mass": "4331.2385",
                                    "ion_position": "112",
                                    "ion_display_position": "36",
                                    "ion_sort_name": "Y00036",
                                    "ion_left_position": "112",
                                    "mass_error": "0.0100",
                                    "ppm": "2.30"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "53",
                            "monoisotopic_mass": "15788.6411",
                            "monoisotopic_mz": "1974.5874",
                            "intensity": "662.00",
                            "charge": "8"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "54",
                            "monoisotopic_mass": "6565.5755",
                            "monoisotopic_mz": "1642.4012",
                            "intensity": "1027.05",
                            "charge": "4"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "55",
                            "monoisotopic_mass": "10923.6930",
                            "monoisotopic_mz": "1821.6228",
                            "intensity": "688.62",
                            "charge": "6"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "56",
                            "monoisotopic_mass": "5141.6519",
                            "monoisotopic_mz": "2571.8332",
                            "intensity": "1526.53",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "57",
                            "monoisotopic_mass": "2064.7533",
                            "monoisotopic_mz": "2065.7605",
                            "intensity": "809.91",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "58",
                            "monoisotopic_mass": "3589.5395",
                            "monoisotopic_mz": "1795.7770",
                            "intensity": "509.80",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "59",
                            "monoisotopic_mass": "3614.5051",
                            "monoisotopic_mz": "1808.2598",
                            "intensity": "584.71",
                            "charge": "2"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "60",
                            "monoisotopic_mass": "2006.9999",
                            "monoisotopic_mz": "2008.0072",
                            "intensity": "982.43",
                            "charge": "1"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "61",
                            "monoisotopic_mass": "5640.8779",
                            "monoisotopic_mz": "1881.2999",
                            "intensity": "1759.77",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5640.8601",
                                    "ion_position": "51",
                                    "ion_display_position": "51",
                                    "ion_sort_name": "B00051",
                                    "ion_left_position": "51",
                                    "mass_error": "0.0178",
                                    "ppm": "3.15"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "62",
                            "monoisotopic_mass": "10819.5727",
                            "monoisotopic_mz": "1804.2694",
                            "intensity": "693.40",
                            "charge": "6"
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "63",
                            "monoisotopic_mass": "5158.6958",
                            "monoisotopic_mz": "2580.3552",
                            "intensity": "3421.03",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "183.0616730376",
                                    "theoretical_mass": "5159.7091",
                                    "ion_position": "104",
                                    "ion_display_position": "44",
                                    "ion_sort_name": "Y00044",
                                    "ion_left_position": "104",
                                    "mass_error": "-0.0109",
                                    "ppm": "-2.11"
                                }
                            }
                        },
                        {
                            "spec_id": "92",
                            "peak_id": "64",
                            "monoisotopic_mass": "7706.1669",
                            "monoisotopic_mz": "1927.5490",
                            "intensity": "657.35",
                            "charge": "4"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "16",
                "proteoform_id": "16",
                "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                "proteoform_mass": "16105.3057",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "149",
                    "first_residue_position": "1",
                    "last_residue_position": "148",
                    "annotated_seq": "M.GLFNFVKDAGEKLWDAVTGQHDKDDQAKKVQEHLNKTGIPDADKVNIQIADGKATVTGDGLSQEAKEKILVAVGNISGIASVDDQVKTATPATASQFYTVKSGDTLSAISKQV(YGNANLYNKI)[+183.0617]FEANKPMLKSPDKIYPGQVLRIPEE.",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "G"
                        },
                        {
                            "position": "2",
                            "acid": "L"
                        },
                        {
                            "position": "3",
                            "acid": "F"
                        },
                        {
                            "position": "4",
                            "acid": "N"
                        },
                        {
                            "position": "5",
                            "acid": "F"
                        },
                        {
                            "position": "6",
                            "acid": "V"
                        },
                        {
                            "position": "7",
                            "acid": "K"
                        },
                        {
                            "position": "8",
                            "acid": "D"
                        },
                        {
                            "position": "9",
                            "acid": "A"
                        },
                        {
                            "position": "10",
                            "acid": "G"
                        },
                        {
                            "position": "11",
                            "acid": "E"
                        },
                        {
                            "position": "12",
                            "acid": "K"
                        },
                        {
                            "position": "13",
                            "acid": "L"
                        },
                        {
                            "position": "14",
                            "acid": "W"
                        },
                        {
                            "position": "15",
                            "acid": "D"
                        },
                        {
                            "position": "16",
                            "acid": "A"
                        },
                        {
                            "position": "17",
                            "acid": "V"
                        },
                        {
                            "position": "18",
                            "acid": "T"
                        },
                        {
                            "position": "19",
                            "acid": "G"
                        },
                        {
                            "position": "20",
                            "acid": "Q"
                        },
                        {
                            "position": "21",
                            "acid": "H"
                        },
                        {
                            "position": "22",
                            "acid": "D"
                        },
                        {
                            "position": "23",
                            "acid": "K"
                        },
                        {
                            "position": "24",
                            "acid": "D"
                        },
                        {
                            "position": "25",
                            "acid": "D"
                        },
                        {
                            "position": "26",
                            "acid": "Q"
                        },
                        {
                            "position": "27",
                            "acid": "A"
                        },
                        {
                            "position": "28",
                            "acid": "K"
                        },
                        {
                            "position": "29",
                            "acid": "K"
                        },
                        {
                            "position": "30",
                            "acid": "V"
                        },
                        {
                            "position": "31",
                            "acid": "Q"
                        },
                        {
                            "position": "32",
                            "acid": "E"
                        },
                        {
                            "position": "33",
                            "acid": "H"
                        },
                        {
                            "position": "34",
                            "acid": "L"
                        },
                        {
                            "position": "35",
                            "acid": "N"
                        },
                        {
                            "position": "36",
                            "acid": "K"
                        },
                        {
                            "position": "37",
                            "acid": "T"
                        },
                        {
                            "position": "38",
                            "acid": "G"
                        },
                        {
                            "position": "39",
                            "acid": "I"
                        },
                        {
                            "position": "40",
                            "acid": "P"
                        },
                        {
                            "position": "41",
                            "acid": "D"
                        },
                        {
                            "position": "42",
                            "acid": "A"
                        },
                        {
                            "position": "43",
                            "acid": "D"
                        },
                        {
                            "position": "44",
                            "acid": "K"
                        },
                        {
                            "position": "45",
                            "acid": "V"
                        },
                        {
                            "position": "46",
                            "acid": "N"
                        },
                        {
                            "position": "47",
                            "acid": "I"
                        },
                        {
                            "position": "48",
                            "acid": "Q"
                        },
                        {
                            "position": "49",
                            "acid": "I"
                        },
                        {
                            "position": "50",
                            "acid": "A"
                        },
                        {
                            "position": "51",
                            "acid": "D"
                        },
                        {
                            "position": "52",
                            "acid": "G"
                        },
                        {
                            "position": "53",
                            "acid": "K"
                        },
                        {
                            "position": "54",
                            "acid": "A"
                        },
                        {
                            "position": "55",
                            "acid": "T"
                        },
                        {
                            "position": "56",
                            "acid": "V"
                        },
                        {
                            "position": "57",
                            "acid": "T"
                        },
                        {
                            "position": "58",
                            "acid": "G"
                        },
                        {
                            "position": "59",
                            "acid": "D"
                        },
                        {
                            "position": "60",
                            "acid": "G"
                        },
                        {
                            "position": "61",
                            "acid": "L"
                        },
                        {
                            "position": "62",
                            "acid": "S"
                        },
                        {
                            "position": "63",
                            "acid": "Q"
                        },
                        {
                            "position": "64",
                            "acid": "E"
                        },
                        {
                            "position": "65",
                            "acid": "A"
                        },
                        {
                            "position": "66",
                            "acid": "K"
                        },
                        {
                            "position": "67",
                            "acid": "E"
                        },
                        {
                            "position": "68",
                            "acid": "K"
                        },
                        {
                            "position": "69",
                            "acid": "I"
                        },
                        {
                            "position": "70",
                            "acid": "L"
                        },
                        {
                            "position": "71",
                            "acid": "V"
                        },
                        {
                            "position": "72",
                            "acid": "A"
                        },
                        {
                            "position": "73",
                            "acid": "V"
                        },
                        {
                            "position": "74",
                            "acid": "G"
                        },
                        {
                            "position": "75",
                            "acid": "N"
                        },
                        {
                            "position": "76",
                            "acid": "I"
                        },
                        {
                            "position": "77",
                            "acid": "S"
                        },
                        {
                            "position": "78",
                            "acid": "G"
                        },
                        {
                            "position": "79",
                            "acid": "I"
                        },
                        {
                            "position": "80",
                            "acid": "A"
                        },
                        {
                            "position": "81",
                            "acid": "S"
                        },
                        {
                            "position": "82",
                            "acid": "V"
                        },
                        {
                            "position": "83",
                            "acid": "D"
                        },
                        {
                            "position": "84",
                            "acid": "D"
                        },
                        {
                            "position": "85",
                            "acid": "Q"
                        },
                        {
                            "position": "86",
                            "acid": "V"
                        },
                        {
                            "position": "87",
                            "acid": "K"
                        },
                        {
                            "position": "88",
                            "acid": "T"
                        },
                        {
                            "position": "89",
                            "acid": "A"
                        },
                        {
                            "position": "90",
                            "acid": "T"
                        },
                        {
                            "position": "91",
                            "acid": "P"
                        },
                        {
                            "position": "92",
                            "acid": "A"
                        },
                        {
                            "position": "93",
                            "acid": "T"
                        },
                        {
                            "position": "94",
                            "acid": "A"
                        },
                        {
                            "position": "95",
                            "acid": "S"
                        },
                        {
                            "position": "96",
                            "acid": "Q"
                        },
                        {
                            "position": "97",
                            "acid": "F"
                        },
                        {
                            "position": "98",
                            "acid": "Y"
                        },
                        {
                            "position": "99",
                            "acid": "T"
                        },
                        {
                            "position": "100",
                            "acid": "V"
                        },
                        {
                            "position": "101",
                            "acid": "K"
                        },
                        {
                            "position": "102",
                            "acid": "S"
                        },
                        {
                            "position": "103",
                            "acid": "G"
                        },
                        {
                            "position": "104",
                            "acid": "D"
                        },
                        {
                            "position": "105",
                            "acid": "T"
                        },
                        {
                            "position": "106",
                            "acid": "L"
                        },
                        {
                            "position": "107",
                            "acid": "S"
                        },
                        {
                            "position": "108",
                            "acid": "A"
                        },
                        {
                            "position": "109",
                            "acid": "I"
                        },
                        {
                            "position": "110",
                            "acid": "S"
                        },
                        {
                            "position": "111",
                            "acid": "K"
                        },
                        {
                            "position": "112",
                            "acid": "Q"
                        },
                        {
                            "position": "113",
                            "acid": "V"
                        },
                        {
                            "position": "114",
                            "acid": "Y"
                        },
                        {
                            "position": "115",
                            "acid": "G"
                        },
                        {
                            "position": "116",
                            "acid": "N"
                        },
                        {
                            "position": "117",
                            "acid": "A"
                        },
                        {
                            "position": "118",
                            "acid": "N"
                        },
                        {
                            "position": "119",
                            "acid": "L"
                        },
                        {
                            "position": "120",
                            "acid": "Y"
                        },
                        {
                            "position": "121",
                            "acid": "N"
                        },
                        {
                            "position": "122",
                            "acid": "K"
                        },
                        {
                            "position": "123",
                            "acid": "I"
                        },
                        {
                            "position": "124",
                            "acid": "F"
                        },
                        {
                            "position": "125",
                            "acid": "E"
                        },
                        {
                            "position": "126",
                            "acid": "A"
                        },
                        {
                            "position": "127",
                            "acid": "N"
                        },
                        {
                            "position": "128",
                            "acid": "K"
                        },
                        {
                            "position": "129",
                            "acid": "P"
                        },
                        {
                            "position": "130",
                            "acid": "M"
                        },
                        {
                            "position": "131",
                            "acid": "L"
                        },
                        {
                            "position": "132",
                            "acid": "K"
                        },
                        {
                            "position": "133",
                            "acid": "S"
                        },
                        {
                            "position": "134",
                            "acid": "P"
                        },
                        {
                            "position": "135",
                            "acid": "D"
                        },
                        {
                            "position": "136",
                            "acid": "K"
                        },
                        {
                            "position": "137",
                            "acid": "I"
                        },
                        {
                            "position": "138",
                            "acid": "Y"
                        },
                        {
                            "position": "139",
                            "acid": "P"
                        },
                        {
                            "position": "140",
                            "acid": "G"
                        },
                        {
                            "position": "141",
                            "acid": "Q"
                        },
                        {
                            "position": "142",
                            "acid": "V"
                        },
                        {
                            "position": "143",
                            "acid": "L"
                        },
                        {
                            "position": "144",
                            "acid": "R"
                        },
                        {
                            "position": "145",
                            "acid": "I"
                        },
                        {
                            "position": "146",
                            "acid": "P"
                        },
                        {
                            "position": "147",
                            "acid": "E"
                        },
                        {
                            "position": "148",
                            "acid": "E"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "spec_id": "92",
                                    "peak_id": "25",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "spec_id": "92",
                                    "peak_id": "18",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "11",
                                    "ion_display_position": "11",
                                    "spec_id": "92",
                                    "peak_id": "30",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "15",
                                    "ion_display_position": "15",
                                    "spec_id": "92",
                                    "peak_id": "20",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "spec_id": "92",
                                    "peak_id": "7",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "92",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    },
                                    {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "92",
                                        "peak_id": "34",
                                        "peak_charge": "2"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "49",
                                    "ion_display_position": "49",
                                    "spec_id": "92",
                                    "peak_id": "33",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "51",
                                    "ion_display_position": "51",
                                    "spec_id": "92",
                                    "peak_id": "61",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "101",
                                    "ion_display_position": "47",
                                    "spec_id": "92",
                                    "peak_id": "45",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "104",
                                    "ion_display_position": "44",
                                    "spec_id": "92",
                                    "peak_id": "63",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "109",
                                    "ion_display_position": "39",
                                    "spec_id": "92",
                                    "peak_id": "49",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "112",
                                    "ion_display_position": "36",
                                    "spec_id": "92",
                                    "peak_id": "52",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "113",
                                    "ion_display_position": "35",
                                    "spec_id": "92",
                                    "peak_id": "35",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "123",
                                    "ion_display_position": "25",
                                    "spec_id": "92",
                                    "peak_id": "31",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "125",
                                    "ion_display_position": "23",
                                    "spec_id": "92",
                                    "peak_id": "6",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "128",
                                        "ion_display_position": "20",
                                        "spec_id": "92",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "128",
                                        "ion_display_position": "20",
                                        "spec_id": "92",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "132",
                                    "ion_display_position": "16",
                                    "spec_id": "92",
                                    "peak_id": "0",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "133",
                                    "ion_display_position": "15",
                                    "spec_id": "92",
                                    "peak_id": "5",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "135",
                                    "ion_display_position": "13",
                                    "spec_id": "92",
                                    "peak_id": "10",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "136",
                                    "ion_display_position": "12",
                                    "spec_id": "92",
                                    "peak_id": "15",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "137",
                                    "ion_display_position": "11",
                                    "spec_id": "92",
                                    "peak_id": "13",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "spec_id": "92",
                                    "peak_id": "17",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "140",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "141",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "142",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "143",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "144",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "145",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "146",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "147",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "148",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "149",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "114",
                        "right_position": "124",
                        "shift": "183.0616730376",
                        "anno": "+183.0617",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
