prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "12",
        "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
        "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
        "proteoform_id": "12",
        "prsm_number": "6",
        "prsm": [
            {
                "prsm_id": "98",
                "p_value": "6.12e-23",
                "e_value": "6.12e-23",
                "fdr": "0",
                "matched_fragment_number": "23",
                "matched_peak_number": "28",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "590",
                        "ms1_scans": "863",
                        "ids": "272",
                        "scans": "864",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "272",
                                "peak_id": "0",
                                "monoisotopic_mass": "1643.9212",
                                "monoisotopic_mz": "1644.9285",
                                "intensity": "6035.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0064",
                                        "ppm": "3.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "1",
                                "monoisotopic_mass": "1870.8855",
                                "monoisotopic_mz": "1871.8928",
                                "intensity": "5006.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "2",
                                "monoisotopic_mass": "1986.0111",
                                "monoisotopic_mz": "1987.0184",
                                "intensity": "3404.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1986.0058",
                                        "ion_position": "49",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0053",
                                        "ppm": "2.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "3",
                                "monoisotopic_mass": "1587.7749",
                                "monoisotopic_mz": "1588.7822",
                                "intensity": "4078.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "4",
                                "monoisotopic_mass": "2266.2318",
                                "monoisotopic_mz": "2267.2391",
                                "intensity": "5235.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0055",
                                        "ppm": "2.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "5",
                                "monoisotopic_mass": "2109.0321",
                                "monoisotopic_mz": "2110.0394",
                                "intensity": "3841.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "6",
                                "monoisotopic_mass": "3281.7357",
                                "monoisotopic_mz": "1641.8751",
                                "intensity": "6731.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3281.7237",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0120",
                                        "ppm": "3.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "7",
                                "monoisotopic_mass": "1922.9566",
                                "monoisotopic_mz": "1923.9639",
                                "intensity": "2529.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "8",
                                "monoisotopic_mass": "2549.3436",
                                "monoisotopic_mz": "2550.3509",
                                "intensity": "4650.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0005",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "9",
                                "monoisotopic_mass": "852.5589",
                                "monoisotopic_mz": "853.5662",
                                "intensity": "12258.57",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0044",
                                        "ppm": "5.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "10",
                                "monoisotopic_mass": "2248.2230",
                                "monoisotopic_mz": "2249.2303",
                                "intensity": "3129.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "11",
                                "monoisotopic_mass": "1681.8335",
                                "monoisotopic_mz": "1682.8408",
                                "intensity": "2157.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "12",
                                "monoisotopic_mass": "1015.5019",
                                "monoisotopic_mz": "1016.5092",
                                "intensity": "7844.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "13",
                                "monoisotopic_mass": "1038.6392",
                                "monoisotopic_mz": "1039.6465",
                                "intensity": "12838.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1038.6338",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0054",
                                        "ppm": "5.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "14",
                                "monoisotopic_mass": "2266.2389",
                                "monoisotopic_mz": "1134.1267",
                                "intensity": "21313.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0127",
                                        "ppm": "5.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "15",
                                "monoisotopic_mass": "2165.1825",
                                "monoisotopic_mz": "2166.1897",
                                "intensity": "4406.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0039",
                                        "ppm": "1.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "16",
                                "monoisotopic_mass": "1534.7680",
                                "monoisotopic_mz": "1535.7753",
                                "intensity": "3397.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "17",
                                "monoisotopic_mass": "1755.8710",
                                "monoisotopic_mz": "1756.8783",
                                "intensity": "2608.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "18",
                                "monoisotopic_mass": "1700.9441",
                                "monoisotopic_mz": "851.4793",
                                "intensity": "6812.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1700.9362",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0078",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "19",
                                "monoisotopic_mass": "2137.1969",
                                "monoisotopic_mz": "1069.6057",
                                "intensity": "6970.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "20",
                                "monoisotopic_mass": "1266.5291",
                                "monoisotopic_mz": "1267.5364",
                                "intensity": "2424.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "21",
                                "monoisotopic_mass": "1848.0149",
                                "monoisotopic_mz": "925.0147",
                                "intensity": "10308.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1848.0046",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0103",
                                        "ppm": "5.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "22",
                                "monoisotopic_mass": "2165.1898",
                                "monoisotopic_mz": "1083.6022",
                                "intensity": "21934.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0112",
                                        "ppm": "5.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "23",
                                "monoisotopic_mass": "2052.1056",
                                "monoisotopic_mz": "1027.0601",
                                "intensity": "17102.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2052.0945",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0111",
                                        "ppm": "5.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "24",
                                "monoisotopic_mass": "1905.0359",
                                "monoisotopic_mz": "953.5252",
                                "intensity": "6910.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1905.0261",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0098",
                                        "ppm": "5.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "25",
                                "monoisotopic_mass": "1185.7084",
                                "monoisotopic_mz": "1186.7157",
                                "intensity": "10396.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1185.7022",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0062",
                                        "ppm": "5.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "26",
                                "monoisotopic_mass": "724.4632",
                                "monoisotopic_mz": "725.4705",
                                "intensity": "18395.47",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0036",
                                        "ppm": "5.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "27",
                                "monoisotopic_mass": "1224.6873",
                                "monoisotopic_mz": "1225.6946",
                                "intensity": "7273.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1224.6826",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0047",
                                        "ppm": "3.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "28",
                                "monoisotopic_mass": "1116.5481",
                                "monoisotopic_mz": "1117.5554",
                                "intensity": "2537.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "29",
                                "monoisotopic_mass": "2248.2262",
                                "monoisotopic_mz": "1125.1204",
                                "intensity": "6701.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "30",
                                "monoisotopic_mass": "1643.9232",
                                "monoisotopic_mz": "822.9689",
                                "intensity": "10313.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0084",
                                        "ppm": "5.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "31",
                                "monoisotopic_mass": "625.3941",
                                "monoisotopic_mz": "626.4014",
                                "intensity": "6375.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "625.3911",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0029",
                                        "ppm": "4.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "32",
                                "monoisotopic_mass": "1428.7956",
                                "monoisotopic_mz": "1429.8029",
                                "intensity": "10789.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0078",
                                        "ppm": "5.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "33",
                                "monoisotopic_mass": "1682.9352",
                                "monoisotopic_mz": "842.4749",
                                "intensity": "3032.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "34",
                                "monoisotopic_mass": "2549.3585",
                                "monoisotopic_mz": "1275.6865",
                                "intensity": "13421.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0155",
                                        "ppm": "6.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "35",
                                "monoisotopic_mass": "1457.6984",
                                "monoisotopic_mz": "1458.7057",
                                "intensity": "5815.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "36",
                                "monoisotopic_mass": "1611.7936",
                                "monoisotopic_mz": "1612.8009",
                                "intensity": "2809.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "37",
                                "monoisotopic_mass": "2936.5480",
                                "monoisotopic_mz": "1469.2813",
                                "intensity": "5798.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "38",
                                "monoisotopic_mass": "1339.7173",
                                "monoisotopic_mz": "1340.7246",
                                "intensity": "3108.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1339.7096",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0078",
                                        "ppm": "5.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "39",
                                "monoisotopic_mass": "1500.8198",
                                "monoisotopic_mz": "751.4172",
                                "intensity": "3138.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "40",
                                "monoisotopic_mass": "1428.7933",
                                "monoisotopic_mz": "715.4039",
                                "intensity": "2072.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0055",
                                        "ppm": "3.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "41",
                                "monoisotopic_mass": "746.3990",
                                "monoisotopic_mz": "747.4062",
                                "intensity": "1375.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "42",
                                "monoisotopic_mass": "1829.9939",
                                "monoisotopic_mz": "916.0042",
                                "intensity": "2316.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "43",
                                "monoisotopic_mass": "805.4118",
                                "monoisotopic_mz": "806.4191",
                                "intensity": "1311.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "44",
                                "monoisotopic_mass": "696.4679",
                                "monoisotopic_mz": "697.4752",
                                "intensity": "3212.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "45",
                                "monoisotopic_mass": "1552.7688",
                                "monoisotopic_mz": "1553.7761",
                                "intensity": "2561.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "46",
                                "monoisotopic_mass": "2581.5785",
                                "monoisotopic_mz": "1291.7965",
                                "intensity": "4952.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "47",
                                "monoisotopic_mass": "791.3647",
                                "monoisotopic_mz": "792.3720",
                                "intensity": "2338.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "48",
                                "monoisotopic_mass": "551.3090",
                                "monoisotopic_mz": "552.3163",
                                "intensity": "2544.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "49",
                                "monoisotopic_mass": "523.3140",
                                "monoisotopic_mz": "524.3213",
                                "intensity": "8460.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "50",
                                "monoisotopic_mass": "769.3642",
                                "monoisotopic_mz": "770.3715",
                                "intensity": "2841.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "51",
                                "monoisotopic_mass": "1472.7508",
                                "monoisotopic_mz": "1473.7581",
                                "intensity": "2491.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "52",
                                "monoisotopic_mass": "670.2955",
                                "monoisotopic_mz": "671.3027",
                                "intensity": "3456.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "53",
                                "monoisotopic_mass": "1905.9198",
                                "monoisotopic_mz": "1906.9270",
                                "intensity": "2330.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "54",
                                "monoisotopic_mass": "1152.5638",
                                "monoisotopic_mz": "1153.5710",
                                "intensity": "6768.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "55",
                                "monoisotopic_mass": "466.2557",
                                "monoisotopic_mz": "467.2630",
                                "intensity": "2199.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "56",
                                "monoisotopic_mass": "1515.8270",
                                "monoisotopic_mz": "758.9208",
                                "intensity": "2928.19",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1515.8198",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0072",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "57",
                                "monoisotopic_mass": "591.3044",
                                "monoisotopic_mz": "592.3116",
                                "intensity": "3060.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "58",
                                "monoisotopic_mass": "3008.5066",
                                "monoisotopic_mz": "1505.2606",
                                "intensity": "2556.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "59",
                                "monoisotopic_mass": "3160.9584",
                                "monoisotopic_mz": "1054.6601",
                                "intensity": "4016.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "60",
                                "monoisotopic_mass": "2326.1381",
                                "monoisotopic_mz": "1164.0763",
                                "intensity": "954.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "61",
                                "monoisotopic_mass": "3183.6663",
                                "monoisotopic_mz": "1592.8404",
                                "intensity": "2436.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "62",
                                "monoisotopic_mass": "1847.0087",
                                "monoisotopic_mz": "1848.0160",
                                "intensity": "2371.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "63",
                                "monoisotopic_mass": "2111.3063",
                                "monoisotopic_mz": "1056.6604",
                                "intensity": "3141.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "64",
                                "monoisotopic_mass": "2187.1885",
                                "monoisotopic_mz": "1094.6015",
                                "intensity": "3296.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "65",
                                "monoisotopic_mass": "2860.4091",
                                "monoisotopic_mz": "1431.2118",
                                "intensity": "3079.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "66",
                                "monoisotopic_mass": "3552.7116",
                                "monoisotopic_mz": "1185.2445",
                                "intensity": "3814.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "67",
                                "monoisotopic_mass": "2881.7908",
                                "monoisotopic_mz": "1441.9027",
                                "intensity": "2158.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "68",
                                "monoisotopic_mass": "2221.2185",
                                "monoisotopic_mz": "1111.6165",
                                "intensity": "1920.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "69",
                                "monoisotopic_mass": "3182.6798",
                                "monoisotopic_mz": "1061.9006",
                                "intensity": "3250.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3182.6553",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0245",
                                        "ppm": "7.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "70",
                                "monoisotopic_mass": "2615.2907",
                                "monoisotopic_mz": "1308.6526",
                                "intensity": "3723.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "71",
                                "monoisotopic_mass": "4137.1209",
                                "monoisotopic_mz": "2069.5677",
                                "intensity": "4037.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "72",
                                "monoisotopic_mass": "2648.6383",
                                "monoisotopic_mz": "1325.3264",
                                "intensity": "3767.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "73",
                                "monoisotopic_mass": "2411.4889",
                                "monoisotopic_mz": "1206.7517",
                                "intensity": "1507.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "74",
                                "monoisotopic_mass": "2433.3436",
                                "monoisotopic_mz": "1217.6791",
                                "intensity": "3054.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "75",
                                "monoisotopic_mass": "3357.8123",
                                "monoisotopic_mz": "1120.2780",
                                "intensity": "2852.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "76",
                                "monoisotopic_mass": "3628.7443",
                                "monoisotopic_mz": "1210.5887",
                                "intensity": "2486.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "77",
                                "monoisotopic_mass": "3965.0768",
                                "monoisotopic_mz": "1322.6995",
                                "intensity": "3778.11",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0139",
                                        "ppm": "3.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "78",
                                "monoisotopic_mass": "2737.6878",
                                "monoisotopic_mz": "913.5699",
                                "intensity": "1018.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "79",
                                "monoisotopic_mass": "4033.4897",
                                "monoisotopic_mz": "1345.5038",
                                "intensity": "2967.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "80",
                                "monoisotopic_mass": "3417.7877",
                                "monoisotopic_mz": "1140.2698",
                                "intensity": "4362.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "81",
                                "monoisotopic_mass": "6337.7921",
                                "monoisotopic_mz": "1268.5657",
                                "intensity": "3499.96",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "82",
                                "monoisotopic_mass": "4086.0245",
                                "monoisotopic_mz": "1363.0154",
                                "intensity": "4373.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "83",
                                "monoisotopic_mass": "3344.6118",
                                "monoisotopic_mz": "1115.8779",
                                "intensity": "1919.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "84",
                                "monoisotopic_mass": "3738.8580",
                                "monoisotopic_mz": "1247.2933",
                                "intensity": "4203.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "85",
                                "monoisotopic_mass": "2361.1436",
                                "monoisotopic_mz": "1181.5791",
                                "intensity": "2255.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "86",
                                "monoisotopic_mass": "5042.5171",
                                "monoisotopic_mz": "1261.6366",
                                "intensity": "3473.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "87",
                                "monoisotopic_mass": "3723.9400",
                                "monoisotopic_mz": "1242.3206",
                                "intensity": "5247.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3723.9202",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0198",
                                        "ppm": "5.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "88",
                                "monoisotopic_mass": "4045.2348",
                                "monoisotopic_mz": "1349.4189",
                                "intensity": "4530.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "89",
                                "monoisotopic_mass": "3328.6872",
                                "monoisotopic_mz": "1110.5697",
                                "intensity": "1686.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "90",
                                "monoisotopic_mass": "2311.1410",
                                "monoisotopic_mz": "1156.5778",
                                "intensity": "3184.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "91",
                                "monoisotopic_mass": "4430.8838",
                                "monoisotopic_mz": "1108.7282",
                                "intensity": "2476.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "92",
                                "monoisotopic_mass": "2663.6513",
                                "monoisotopic_mz": "1332.8329",
                                "intensity": "3206.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "93",
                                "monoisotopic_mass": "4093.5537",
                                "monoisotopic_mz": "1024.3957",
                                "intensity": "892.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "94",
                                "monoisotopic_mass": "3221.2459",
                                "monoisotopic_mz": "1074.7559",
                                "intensity": "5627.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "95",
                                "monoisotopic_mass": "2506.5430",
                                "monoisotopic_mz": "1254.2788",
                                "intensity": "2936.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "96",
                                "monoisotopic_mass": "4965.8254",
                                "monoisotopic_mz": "1242.4636",
                                "intensity": "2252.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "97",
                                "monoisotopic_mass": "4755.2207",
                                "monoisotopic_mz": "1189.8124",
                                "intensity": "1422.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "98",
                                "monoisotopic_mass": "5383.0873",
                                "monoisotopic_mz": "1346.7791",
                                "intensity": "2609.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "99",
                                "monoisotopic_mass": "3981.2208",
                                "monoisotopic_mz": "1328.0809",
                                "intensity": "2234.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "100",
                                "monoisotopic_mass": "3809.0387",
                                "monoisotopic_mz": "1270.6868",
                                "intensity": "2255.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "101",
                                "monoisotopic_mass": "2023.1135",
                                "monoisotopic_mz": "1012.5640",
                                "intensity": "5935.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "102",
                                "monoisotopic_mass": "5230.2020",
                                "monoisotopic_mz": "1308.5578",
                                "intensity": "2160.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "103",
                                "monoisotopic_mass": "5353.8066",
                                "monoisotopic_mz": "1339.4589",
                                "intensity": "2683.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "104",
                                "monoisotopic_mass": "4139.1324",
                                "monoisotopic_mz": "1380.7181",
                                "intensity": "2393.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "105",
                                "monoisotopic_mass": "4630.2827",
                                "monoisotopic_mz": "1158.5780",
                                "intensity": "1911.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "106",
                                "monoisotopic_mass": "6123.2386",
                                "monoisotopic_mz": "1225.6550",
                                "intensity": "1810.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "107",
                                "monoisotopic_mass": "5132.5099",
                                "monoisotopic_mz": "1284.1347",
                                "intensity": "3715.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "108",
                                "monoisotopic_mass": "1514.7411",
                                "monoisotopic_mz": "1515.7483",
                                "intensity": "1801.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "109",
                                "monoisotopic_mass": "4270.6490",
                                "monoisotopic_mz": "1424.5569",
                                "intensity": "5312.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "110",
                                "monoisotopic_mass": "4598.3701",
                                "monoisotopic_mz": "1150.5998",
                                "intensity": "2253.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "111",
                                "monoisotopic_mass": "3855.0424",
                                "monoisotopic_mz": "1286.0214",
                                "intensity": "3906.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "112",
                                "monoisotopic_mass": "3154.9547",
                                "monoisotopic_mz": "789.7459",
                                "intensity": "1590.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "113",
                                "monoisotopic_mass": "3681.6186",
                                "monoisotopic_mz": "1228.2135",
                                "intensity": "2710.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "114",
                                "monoisotopic_mass": "6566.1000",
                                "monoisotopic_mz": "1314.2273",
                                "intensity": "2690.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "115",
                                "monoisotopic_mass": "3757.7018",
                                "monoisotopic_mz": "1253.5745",
                                "intensity": "3240.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "116",
                                "monoisotopic_mass": "6540.7687",
                                "monoisotopic_mz": "1309.1610",
                                "intensity": "2433.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "117",
                                "monoisotopic_mass": "6152.3597",
                                "monoisotopic_mz": "1231.4792",
                                "intensity": "2048.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "118",
                                "monoisotopic_mass": "3292.2949",
                                "monoisotopic_mz": "1098.4389",
                                "intensity": "1782.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "119",
                                "monoisotopic_mass": "6527.0882",
                                "monoisotopic_mz": "1306.4249",
                                "intensity": "2319.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "272",
                                "peak_id": "120",
                                "monoisotopic_mass": "3565.8662",
                                "monoisotopic_mz": "1189.6293",
                                "intensity": "4055.46",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3565.8510",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0151",
                                        "ppm": "4.25"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKWFNESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "272",
                                        "peak_id": "31",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "272",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "272",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "272",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "272",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "272",
                                            "peak_id": "40",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "272",
                                            "peak_id": "32",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "272",
                                        "peak_id": "56",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "272",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "272",
                                            "peak_id": "30",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "272",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "272",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "272",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "272",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "272",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "272",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "272",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "272",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "272",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "272",
                                            "peak_id": "34",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "272",
                                        "peak_id": "69",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "272",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "272",
                                        "peak_id": "120",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "272",
                                        "peak_id": "87",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "272",
                                        "peak_id": "77",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "49",
                                        "ion_display_position": "19",
                                        "spec_id": "272",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "spec_id": "272",
                                        "peak_id": "38",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "272",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "136",
                "p_value": "9.41e-19",
                "e_value": "9.41e-19",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "612",
                        "ms1_scans": "950",
                        "ids": "338",
                        "scans": "952",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "338",
                                "peak_id": "0",
                                "monoisotopic_mass": "1643.9218",
                                "monoisotopic_mz": "1644.9291",
                                "intensity": "1939.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0070",
                                        "ppm": "4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "1",
                                "monoisotopic_mass": "2549.3468",
                                "monoisotopic_mz": "2550.3540",
                                "intensity": "2160.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0037",
                                        "ppm": "1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "2",
                                "monoisotopic_mass": "1848.0142",
                                "monoisotopic_mz": "925.0144",
                                "intensity": "3258.45",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1848.0046",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0095",
                                        "ppm": "5.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "3",
                                "monoisotopic_mass": "1020.6293",
                                "monoisotopic_mz": "1021.6366",
                                "intensity": "1789.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "4",
                                "monoisotopic_mass": "1038.6397",
                                "monoisotopic_mz": "1039.6470",
                                "intensity": "3179.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1038.6338",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0059",
                                        "ppm": "5.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "5",
                                "monoisotopic_mass": "1185.7072",
                                "monoisotopic_mz": "1186.7145",
                                "intensity": "2563.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1185.7022",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0050",
                                        "ppm": "4.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "6",
                                "monoisotopic_mass": "1428.7936",
                                "monoisotopic_mz": "1429.8009",
                                "intensity": "3575.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0059",
                                        "ppm": "4.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "7",
                                "monoisotopic_mass": "2052.1041",
                                "monoisotopic_mz": "1027.0593",
                                "intensity": "3958.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2052.0945",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0096",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "8",
                                "monoisotopic_mass": "2266.2357",
                                "monoisotopic_mz": "1134.1251",
                                "intensity": "7097.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0095",
                                        "ppm": "4.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "9",
                                "monoisotopic_mass": "1515.8244",
                                "monoisotopic_mz": "1516.8317",
                                "intensity": "1717.54",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1515.8198",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0046",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "10",
                                "monoisotopic_mass": "1700.9430",
                                "monoisotopic_mz": "851.4788",
                                "intensity": "1381.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1700.9362",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0067",
                                        "ppm": "3.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "11",
                                "monoisotopic_mass": "724.4629",
                                "monoisotopic_mz": "725.4702",
                                "intensity": "5539.67",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0033",
                                        "ppm": "4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "12",
                                "monoisotopic_mass": "852.5581",
                                "monoisotopic_mz": "853.5654",
                                "intensity": "3227.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0036",
                                        "ppm": "4.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "13",
                                "monoisotopic_mass": "1570.7848",
                                "monoisotopic_mz": "1571.7921",
                                "intensity": "2135.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "14",
                                "monoisotopic_mass": "1905.0343",
                                "monoisotopic_mz": "953.5244",
                                "intensity": "1890.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1905.0261",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0082",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "15",
                                "monoisotopic_mass": "1643.9228",
                                "monoisotopic_mz": "822.9687",
                                "intensity": "3124.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0081",
                                        "ppm": "4.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "16",
                                "monoisotopic_mass": "770.3589",
                                "monoisotopic_mz": "771.3661",
                                "intensity": "1449.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "17",
                                "monoisotopic_mass": "523.3142",
                                "monoisotopic_mz": "524.3215",
                                "intensity": "3203.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "18",
                                "monoisotopic_mass": "1434.7422",
                                "monoisotopic_mz": "718.3784",
                                "intensity": "678.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "19",
                                "monoisotopic_mass": "591.3041",
                                "monoisotopic_mz": "592.3113",
                                "intensity": "1114.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "20",
                                "monoisotopic_mass": "440.3126",
                                "monoisotopic_mz": "441.3199",
                                "intensity": "1925.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "440.3111",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0015",
                                        "ppm": "3.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "21",
                                "monoisotopic_mass": "424.2452",
                                "monoisotopic_mz": "425.2524",
                                "intensity": "1390.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "22",
                                "monoisotopic_mass": "1224.6879",
                                "monoisotopic_mz": "1225.6952",
                                "intensity": "2431.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1224.6826",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0053",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "23",
                                "monoisotopic_mass": "1453.7317",
                                "monoisotopic_mz": "1454.7390",
                                "intensity": "1886.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "24",
                                "monoisotopic_mass": "2235.1859",
                                "monoisotopic_mz": "1118.6002",
                                "intensity": "1107.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "25",
                                "monoisotopic_mass": "625.3943",
                                "monoisotopic_mz": "626.4016",
                                "intensity": "1279.33",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "625.3911",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0032",
                                        "ppm": "5.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "26",
                                "monoisotopic_mass": "2549.3632",
                                "monoisotopic_mz": "1275.6889",
                                "intensity": "3625.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0201",
                                        "ppm": "7.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "27",
                                "monoisotopic_mass": "2497.2459",
                                "monoisotopic_mz": "1249.6302",
                                "intensity": "2002.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "28",
                                "monoisotopic_mass": "1467.7769",
                                "monoisotopic_mz": "1468.7842",
                                "intensity": "1059.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1467.7682",
                                        "ion_position": "53",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "53",
                                        "mass_error": "0.0087",
                                        "ppm": "5.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "29",
                                "monoisotopic_mass": "555.2671",
                                "monoisotopic_mz": "556.2744",
                                "intensity": "913.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "30",
                                "monoisotopic_mass": "4647.2848",
                                "monoisotopic_mz": "1162.8285",
                                "intensity": "2104.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "31",
                                "monoisotopic_mass": "1203.6109",
                                "monoisotopic_mz": "1204.6182",
                                "intensity": "2390.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "32",
                                "monoisotopic_mass": "1373.9418",
                                "monoisotopic_mz": "1374.9491",
                                "intensity": "967.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "33",
                                "monoisotopic_mass": "1314.6772",
                                "monoisotopic_mz": "1315.6844",
                                "intensity": "641.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "34",
                                "monoisotopic_mass": "3966.0754",
                                "monoisotopic_mz": "1323.0324",
                                "intensity": "1534.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "35",
                                "monoisotopic_mass": "6459.1757",
                                "monoisotopic_mz": "1292.8424",
                                "intensity": "695.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "36",
                                "monoisotopic_mass": "1103.5477",
                                "monoisotopic_mz": "1104.5550",
                                "intensity": "246.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "37",
                                "monoisotopic_mass": "1140.6006",
                                "monoisotopic_mz": "1141.6079",
                                "intensity": "2221.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "38",
                                "monoisotopic_mass": "2830.4508",
                                "monoisotopic_mz": "1416.2327",
                                "intensity": "1230.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "39",
                                "monoisotopic_mass": "5230.6851",
                                "monoisotopic_mz": "1308.6785",
                                "intensity": "511.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "40",
                                "monoisotopic_mass": "2534.3053",
                                "monoisotopic_mz": "1268.1599",
                                "intensity": "1342.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "41",
                                "monoisotopic_mass": "2731.3782",
                                "monoisotopic_mz": "1366.6964",
                                "intensity": "1349.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "42",
                                "monoisotopic_mass": "1299.6293",
                                "monoisotopic_mz": "1300.6366",
                                "intensity": "1547.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "43",
                                "monoisotopic_mass": "1261.5458",
                                "monoisotopic_mz": "1262.5531",
                                "intensity": "817.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "44",
                                "monoisotopic_mass": "3797.3298",
                                "monoisotopic_mz": "1266.7839",
                                "intensity": "1511.73",
                                "charge": "3"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "45",
                                "monoisotopic_mass": "822.4383",
                                "monoisotopic_mz": "823.4456",
                                "intensity": "942.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "46",
                                "monoisotopic_mass": "6528.6476",
                                "monoisotopic_mz": "1306.7368",
                                "intensity": "2691.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "47",
                                "monoisotopic_mass": "2164.1860",
                                "monoisotopic_mz": "1083.1003",
                                "intensity": "5643.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "48",
                                "monoisotopic_mass": "2632.3782",
                                "monoisotopic_mz": "1317.1964",
                                "intensity": "1231.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "49",
                                "monoisotopic_mass": "6077.0185",
                                "monoisotopic_mz": "1216.4110",
                                "intensity": "1353.99",
                                "charge": "5"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "50",
                                "monoisotopic_mass": "3522.2040",
                                "monoisotopic_mz": "1175.0753",
                                "intensity": "585.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "51",
                                "monoisotopic_mass": "2297.1724",
                                "monoisotopic_mz": "1149.5935",
                                "intensity": "932.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "52",
                                "monoisotopic_mass": "6733.3664",
                                "monoisotopic_mz": "1347.6806",
                                "intensity": "1876.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "53",
                                "monoisotopic_mass": "5662.0189",
                                "monoisotopic_mz": "1416.5120",
                                "intensity": "1409.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "54",
                                "monoisotopic_mass": "2247.2295",
                                "monoisotopic_mz": "1124.6220",
                                "intensity": "2582.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "55",
                                "monoisotopic_mass": "2667.1347",
                                "monoisotopic_mz": "1334.5746",
                                "intensity": "1097.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "56",
                                "monoisotopic_mass": "4846.9992",
                                "monoisotopic_mz": "1212.7571",
                                "intensity": "1552.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "57",
                                "monoisotopic_mass": "4708.8659",
                                "monoisotopic_mz": "1178.2238",
                                "intensity": "1177.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "58",
                                "monoisotopic_mass": "2431.0404",
                                "monoisotopic_mz": "1216.5275",
                                "intensity": "725.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "59",
                                "monoisotopic_mass": "6569.2050",
                                "monoisotopic_mz": "1314.8483",
                                "intensity": "663.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "60",
                                "monoisotopic_mass": "3034.6002",
                                "monoisotopic_mz": "1012.5407",
                                "intensity": "744.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "61",
                                "monoisotopic_mass": "4078.3329",
                                "monoisotopic_mz": "1360.4516",
                                "intensity": "589.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "62",
                                "monoisotopic_mass": "3565.8724",
                                "monoisotopic_mz": "1189.6314",
                                "intensity": "594.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3565.8510",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0214",
                                        "ppm": "6.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "63",
                                "monoisotopic_mass": "1820.0174",
                                "monoisotopic_mz": "911.0160",
                                "intensity": "1169.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "64",
                                "monoisotopic_mass": "2202.1030",
                                "monoisotopic_mz": "1102.0588",
                                "intensity": "459.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "65",
                                "monoisotopic_mass": "2398.4563",
                                "monoisotopic_mz": "1200.2354",
                                "intensity": "1399.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "338",
                                "peak_id": "66",
                                "monoisotopic_mass": "5636.4166",
                                "monoisotopic_mz": "1128.2906",
                                "intensity": "614.35",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKWFNESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "338",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "338",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "338",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "338",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "338",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "338",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "338",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "338",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "338",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "338",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "338",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "338",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "338",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "338",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "338",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "338",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "338",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "338",
                                        "peak_id": "62",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "53",
                                        "ion_display_position": "15",
                                        "spec_id": "338",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "338",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "116",
                "p_value": "2.34e-18",
                "e_value": "2.34e-18",
                "fdr": "0",
                "matched_fragment_number": "21",
                "matched_peak_number": "23",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "601",
                        "ms1_scans": "907",
                        "ids": "305",
                        "scans": "908",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "305",
                                "peak_id": "0",
                                "monoisotopic_mass": "1825.9177",
                                "monoisotopic_mz": "1826.9250",
                                "intensity": "1790.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "1",
                                "monoisotopic_mass": "1870.8949",
                                "monoisotopic_mz": "1871.9022",
                                "intensity": "2366.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "2",
                                "monoisotopic_mass": "1570.7834",
                                "monoisotopic_mz": "1571.7906",
                                "intensity": "2108.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "3",
                                "monoisotopic_mass": "2549.3504",
                                "monoisotopic_mz": "2550.3577",
                                "intensity": "2820.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0074",
                                        "ppm": "2.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "4",
                                "monoisotopic_mass": "1015.5012",
                                "monoisotopic_mz": "1016.5085",
                                "intensity": "3960.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "5",
                                "monoisotopic_mass": "2248.2210",
                                "monoisotopic_mz": "2249.2283",
                                "intensity": "1879.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "6",
                                "monoisotopic_mass": "2266.2370",
                                "monoisotopic_mz": "1134.1258",
                                "intensity": "11802.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0107",
                                        "ppm": "4.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "7",
                                "monoisotopic_mass": "852.5585",
                                "monoisotopic_mz": "853.5658",
                                "intensity": "5940.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0040",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "8",
                                "monoisotopic_mass": "1224.6883",
                                "monoisotopic_mz": "1225.6956",
                                "intensity": "4815.67",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1224.6826",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0056",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "9",
                                "monoisotopic_mass": "1428.7924",
                                "monoisotopic_mz": "1429.7997",
                                "intensity": "6498.92",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0046",
                                        "ppm": "3.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "10",
                                "monoisotopic_mass": "2165.1839",
                                "monoisotopic_mz": "2166.1912",
                                "intensity": "2970.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0053",
                                        "ppm": "2.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "11",
                                "monoisotopic_mass": "1457.7094",
                                "monoisotopic_mz": "1458.7167",
                                "intensity": "1976.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "12",
                                "monoisotopic_mass": "1185.7066",
                                "monoisotopic_mz": "1186.7139",
                                "intensity": "5076.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1185.7022",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0043",
                                        "ppm": "3.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "13",
                                "monoisotopic_mass": "1038.6387",
                                "monoisotopic_mz": "1039.6460",
                                "intensity": "5677.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1038.6338",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0049",
                                        "ppm": "4.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "14",
                                "monoisotopic_mass": "724.4630",
                                "monoisotopic_mz": "725.4703",
                                "intensity": "10801.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0034",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "15",
                                "monoisotopic_mass": "1905.0342",
                                "monoisotopic_mz": "953.5244",
                                "intensity": "3493.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1905.0261",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0081",
                                        "ppm": "4.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "16",
                                "monoisotopic_mass": "2052.1046",
                                "monoisotopic_mz": "1027.0596",
                                "intensity": "9261.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2052.0945",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0101",
                                        "ppm": "4.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "17",
                                "monoisotopic_mass": "2165.1874",
                                "monoisotopic_mz": "1083.6010",
                                "intensity": "9992.64",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0088",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "18",
                                "monoisotopic_mass": "3281.7482",
                                "monoisotopic_mz": "1641.8814",
                                "intensity": "4670.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3281.7237",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0245",
                                        "ppm": "7.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "19",
                                "monoisotopic_mass": "1700.9463",
                                "monoisotopic_mz": "851.4804",
                                "intensity": "2547.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1700.9362",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0100",
                                        "ppm": "5.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "20",
                                "monoisotopic_mass": "1848.0131",
                                "monoisotopic_mz": "925.0138",
                                "intensity": "4524.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1848.0046",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0084",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "21",
                                "monoisotopic_mass": "2248.2252",
                                "monoisotopic_mz": "1125.1199",
                                "intensity": "5275.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "22",
                                "monoisotopic_mass": "1643.9228",
                                "monoisotopic_mz": "822.9687",
                                "intensity": "4297.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0081",
                                        "ppm": "4.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "23",
                                "monoisotopic_mass": "791.3647",
                                "monoisotopic_mz": "792.3719",
                                "intensity": "1295.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "24",
                                "monoisotopic_mass": "2936.5382",
                                "monoisotopic_mz": "1469.2764",
                                "intensity": "4084.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2936.5185",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0197",
                                        "ppm": "6.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "25",
                                "monoisotopic_mass": "625.3941",
                                "monoisotopic_mz": "626.4014",
                                "intensity": "4102.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "625.3911",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0029",
                                        "ppm": "4.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "26",
                                "monoisotopic_mass": "1820.0199",
                                "monoisotopic_mz": "911.0172",
                                "intensity": "1664.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "27",
                                "monoisotopic_mass": "916.4324",
                                "monoisotopic_mz": "917.4396",
                                "intensity": "2190.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "28",
                                "monoisotopic_mass": "2024.1090",
                                "monoisotopic_mz": "1013.0618",
                                "intensity": "2891.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "29",
                                "monoisotopic_mass": "1386.6663",
                                "monoisotopic_mz": "1387.6736",
                                "intensity": "1510.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "30",
                                "monoisotopic_mass": "1203.6165",
                                "monoisotopic_mz": "1204.6238",
                                "intensity": "3002.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "31",
                                "monoisotopic_mass": "746.3985",
                                "monoisotopic_mz": "747.4058",
                                "intensity": "782.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "32",
                                "monoisotopic_mass": "2995.6229",
                                "monoisotopic_mz": "1498.8187",
                                "intensity": "2854.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "33",
                                "monoisotopic_mass": "2768.3666",
                                "monoisotopic_mz": "1385.1906",
                                "intensity": "611.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "34",
                                "monoisotopic_mass": "708.3952",
                                "monoisotopic_mz": "709.4025",
                                "intensity": "1461.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "35",
                                "monoisotopic_mass": "869.4439",
                                "monoisotopic_mz": "870.4512",
                                "intensity": "1607.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "36",
                                "monoisotopic_mass": "591.3044",
                                "monoisotopic_mz": "592.3116",
                                "intensity": "1380.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "37",
                                "monoisotopic_mass": "424.2449",
                                "monoisotopic_mz": "425.2521",
                                "intensity": "3649.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "38",
                                "monoisotopic_mass": "523.3139",
                                "monoisotopic_mz": "524.3212",
                                "intensity": "4361.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "39",
                                "monoisotopic_mass": "2549.3585",
                                "monoisotopic_mz": "1275.6865",
                                "intensity": "5586.50",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0155",
                                        "ppm": "6.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "40",
                                "monoisotopic_mass": "691.3689",
                                "monoisotopic_mz": "692.3762",
                                "intensity": "1128.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "41",
                                "monoisotopic_mass": "412.2446",
                                "monoisotopic_mz": "413.2519",
                                "intensity": "1801.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "42",
                                "monoisotopic_mass": "769.3635",
                                "monoisotopic_mz": "770.3708",
                                "intensity": "1731.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "43",
                                "monoisotopic_mass": "609.3265",
                                "monoisotopic_mz": "610.3337",
                                "intensity": "888.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "44",
                                "monoisotopic_mass": "1339.7161",
                                "monoisotopic_mz": "1340.7234",
                                "intensity": "2947.38",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1339.7096",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0065",
                                        "ppm": "4.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "45",
                                "monoisotopic_mass": "2137.1901",
                                "monoisotopic_mz": "1069.6023",
                                "intensity": "2517.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "46",
                                "monoisotopic_mass": "837.4747",
                                "monoisotopic_mz": "838.4819",
                                "intensity": "916.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "47",
                                "monoisotopic_mass": "3390.8086",
                                "monoisotopic_mz": "1131.2768",
                                "intensity": "2528.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "48",
                                "monoisotopic_mass": "1515.8420",
                                "monoisotopic_mz": "1516.8493",
                                "intensity": "2516.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "49",
                                "monoisotopic_mass": "2787.7036",
                                "monoisotopic_mz": "1394.8591",
                                "intensity": "1517.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "50",
                                "monoisotopic_mass": "3144.5531",
                                "monoisotopic_mz": "1573.2838",
                                "intensity": "1419.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "51",
                                "monoisotopic_mass": "3035.6066",
                                "monoisotopic_mz": "1518.8106",
                                "intensity": "2095.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3035.5869",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0197",
                                        "ppm": "6.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "52",
                                "monoisotopic_mass": "3565.8823",
                                "monoisotopic_mz": "1189.6347",
                                "intensity": "2487.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3565.8510",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0313",
                                        "ppm": "8.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "53",
                                "monoisotopic_mass": "2222.2325",
                                "monoisotopic_mz": "1112.1235",
                                "intensity": "1806.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "54",
                                "monoisotopic_mass": "4723.5597",
                                "monoisotopic_mz": "1181.8972",
                                "intensity": "1688.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "55",
                                "monoisotopic_mass": "3418.8025",
                                "monoisotopic_mz": "1140.6081",
                                "intensity": "2436.29",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3418.7826",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0199",
                                        "ppm": "5.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "56",
                                "monoisotopic_mass": "3913.5717",
                                "monoisotopic_mz": "1305.5312",
                                "intensity": "630.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "57",
                                "monoisotopic_mass": "4565.8276",
                                "monoisotopic_mz": "1142.4642",
                                "intensity": "1654.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "58",
                                "monoisotopic_mass": "2265.2304",
                                "monoisotopic_mz": "2266.2377",
                                "intensity": "2220.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "59",
                                "monoisotopic_mass": "4830.4741",
                                "monoisotopic_mz": "1208.6258",
                                "intensity": "2680.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "60",
                                "monoisotopic_mass": "2280.2031",
                                "monoisotopic_mz": "1141.1088",
                                "intensity": "3828.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "61",
                                "monoisotopic_mass": "2900.5182",
                                "monoisotopic_mz": "1451.2664",
                                "intensity": "2943.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "62",
                                "monoisotopic_mass": "4017.4871",
                                "monoisotopic_mz": "1005.3790",
                                "intensity": "684.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "63",
                                "monoisotopic_mass": "2731.3793",
                                "monoisotopic_mz": "1366.6969",
                                "intensity": "1833.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "64",
                                "monoisotopic_mass": "2749.7252",
                                "monoisotopic_mz": "1375.8699",
                                "intensity": "758.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "65",
                                "monoisotopic_mass": "4089.0362",
                                "monoisotopic_mz": "1364.0193",
                                "intensity": "2540.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "66",
                                "monoisotopic_mass": "5107.4706",
                                "monoisotopic_mz": "1277.8749",
                                "intensity": "2960.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "67",
                                "monoisotopic_mass": "2397.4950",
                                "monoisotopic_mz": "1199.7548",
                                "intensity": "1058.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "68",
                                "monoisotopic_mass": "5611.0833",
                                "monoisotopic_mz": "1123.2239",
                                "intensity": "641.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "69",
                                "monoisotopic_mass": "3309.2794",
                                "monoisotopic_mz": "1104.1004",
                                "intensity": "1037.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "70",
                                "monoisotopic_mass": "4475.1226",
                                "monoisotopic_mz": "1119.7879",
                                "intensity": "1608.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "71",
                                "monoisotopic_mass": "4239.3139",
                                "monoisotopic_mz": "1060.8358",
                                "intensity": "717.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "72",
                                "monoisotopic_mass": "2644.0428",
                                "monoisotopic_mz": "1323.0287",
                                "intensity": "1158.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "73",
                                "monoisotopic_mass": "4775.4648",
                                "monoisotopic_mz": "1194.8735",
                                "intensity": "1494.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "74",
                                "monoisotopic_mass": "6896.5756",
                                "monoisotopic_mz": "1380.3224",
                                "intensity": "1681.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "75",
                                "monoisotopic_mass": "2519.2720",
                                "monoisotopic_mz": "1260.6433",
                                "intensity": "2056.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "76",
                                "monoisotopic_mass": "2114.3044",
                                "monoisotopic_mz": "1058.1595",
                                "intensity": "1225.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "77",
                                "monoisotopic_mass": "5849.9842",
                                "monoisotopic_mz": "1171.0041",
                                "intensity": "1567.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "78",
                                "monoisotopic_mass": "2715.1918",
                                "monoisotopic_mz": "1358.6032",
                                "intensity": "2260.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "79",
                                "monoisotopic_mass": "5453.7621",
                                "monoisotopic_mz": "1364.4478",
                                "intensity": "452.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "80",
                                "monoisotopic_mass": "3898.6630",
                                "monoisotopic_mz": "1300.5616",
                                "intensity": "1714.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "81",
                                "monoisotopic_mass": "4505.2072",
                                "monoisotopic_mz": "1127.3091",
                                "intensity": "1654.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "82",
                                "monoisotopic_mass": "5822.9217",
                                "monoisotopic_mz": "1165.5916",
                                "intensity": "616.01",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "83",
                                "monoisotopic_mass": "6661.2312",
                                "monoisotopic_mz": "1333.2535",
                                "intensity": "2046.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "84",
                                "monoisotopic_mass": "2296.1709",
                                "monoisotopic_mz": "1149.0927",
                                "intensity": "1959.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "85",
                                "monoisotopic_mass": "6441.2585",
                                "monoisotopic_mz": "1289.2590",
                                "intensity": "1879.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "86",
                                "monoisotopic_mass": "6489.1129",
                                "monoisotopic_mz": "1298.8299",
                                "intensity": "743.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "87",
                                "monoisotopic_mass": "2416.3312",
                                "monoisotopic_mz": "1209.1729",
                                "intensity": "1587.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "88",
                                "monoisotopic_mass": "4395.7026",
                                "monoisotopic_mz": "1099.9329",
                                "intensity": "619.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "89",
                                "monoisotopic_mass": "3129.6481",
                                "monoisotopic_mz": "1044.2233",
                                "intensity": "1130.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "90",
                                "monoisotopic_mass": "2453.2193",
                                "monoisotopic_mz": "1227.6169",
                                "intensity": "1573.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "91",
                                "monoisotopic_mass": "6219.1593",
                                "monoisotopic_mz": "1244.8391",
                                "intensity": "831.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "92",
                                "monoisotopic_mass": "2006.0803",
                                "monoisotopic_mz": "1004.0474",
                                "intensity": "1238.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "93",
                                "monoisotopic_mass": "5254.7027",
                                "monoisotopic_mz": "1314.6830",
                                "intensity": "1326.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "94",
                                "monoisotopic_mass": "2580.9136",
                                "monoisotopic_mz": "1291.4641",
                                "intensity": "1164.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "95",
                                "monoisotopic_mass": "4004.4280",
                                "monoisotopic_mz": "1335.8166",
                                "intensity": "1822.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "96",
                                "monoisotopic_mass": "6692.4505",
                                "monoisotopic_mz": "1339.4974",
                                "intensity": "1426.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "97",
                                "monoisotopic_mass": "5402.3290",
                                "monoisotopic_mz": "1351.5895",
                                "intensity": "484.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "98",
                                "monoisotopic_mass": "2466.7512",
                                "monoisotopic_mz": "1234.3829",
                                "intensity": "1396.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "99",
                                "monoisotopic_mass": "5201.1781",
                                "monoisotopic_mz": "1301.3018",
                                "intensity": "559.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "100",
                                "monoisotopic_mass": "1559.7553",
                                "monoisotopic_mz": "1560.7626",
                                "intensity": "1185.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "101",
                                "monoisotopic_mass": "3717.6998",
                                "monoisotopic_mz": "1240.2405",
                                "intensity": "1271.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "102",
                                "monoisotopic_mass": "4906.4128",
                                "monoisotopic_mz": "1227.6105",
                                "intensity": "1072.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "103",
                                "monoisotopic_mass": "4042.9900",
                                "monoisotopic_mz": "1348.6706",
                                "intensity": "670.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "104",
                                "monoisotopic_mass": "5335.9796",
                                "monoisotopic_mz": "1335.0022",
                                "intensity": "2135.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "105",
                                "monoisotopic_mass": "6588.0025",
                                "monoisotopic_mz": "1318.6078",
                                "intensity": "620.88",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "106",
                                "monoisotopic_mass": "2698.6711",
                                "monoisotopic_mz": "1350.3428",
                                "intensity": "578.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "107",
                                "monoisotopic_mass": "2879.7817",
                                "monoisotopic_mz": "1440.8981",
                                "intensity": "1571.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "108",
                                "monoisotopic_mass": "3867.0245",
                                "monoisotopic_mz": "1290.0154",
                                "intensity": "1179.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "109",
                                "monoisotopic_mass": "5531.7173",
                                "monoisotopic_mz": "1383.9366",
                                "intensity": "609.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "110",
                                "monoisotopic_mass": "6376.9525",
                                "monoisotopic_mz": "1276.3978",
                                "intensity": "1114.88",
                                "charge": "5"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "111",
                                "monoisotopic_mass": "4148.3085",
                                "monoisotopic_mz": "1383.7768",
                                "intensity": "643.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "305",
                                "peak_id": "112",
                                "monoisotopic_mass": "6353.9322",
                                "monoisotopic_mz": "1271.7937",
                                "intensity": "853.08",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKWFNESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "305",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "305",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "305",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "305",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "305",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "305",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "305",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "305",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "305",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "305",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "305",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "305",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "305",
                                            "peak_id": "17",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "305",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "305",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "305",
                                            "peak_id": "39",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "305",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "305",
                                        "peak_id": "51",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "305",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "305",
                                        "peak_id": "55",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "305",
                                        "peak_id": "52",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "14",
                                        "spec_id": "305",
                                        "peak_id": "44",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "305",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "75",
                "p_value": "7.69e-18",
                "e_value": "7.69e-18",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "21",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "579",
                        "ms1_scans": "819",
                        "ids": "239",
                        "scans": "820",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "239",
                                "peak_id": "0",
                                "monoisotopic_mass": "1448.7102",
                                "monoisotopic_mz": "725.3624",
                                "intensity": "2887.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "1",
                                "monoisotopic_mass": "1505.2765",
                                "monoisotopic_mz": "1506.2838",
                                "intensity": "4060.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "2",
                                "monoisotopic_mass": "2266.2340",
                                "monoisotopic_mz": "2267.2413",
                                "intensity": "3341.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0077",
                                        "ppm": "3.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "3",
                                "monoisotopic_mass": "2165.1820",
                                "monoisotopic_mz": "2166.1892",
                                "intensity": "4453.14",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0034",
                                        "ppm": "1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "4",
                                "monoisotopic_mass": "1724.8749",
                                "monoisotopic_mz": "1725.8822",
                                "intensity": "3385.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "5",
                                "monoisotopic_mass": "2549.3431",
                                "monoisotopic_mz": "2550.3504",
                                "intensity": "3854.34",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0000",
                                        "ppm": "0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "6",
                                "monoisotopic_mass": "852.5595",
                                "monoisotopic_mz": "853.5668",
                                "intensity": "12229.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0050",
                                        "ppm": "5.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "7",
                                "monoisotopic_mass": "1015.5025",
                                "monoisotopic_mz": "1016.5098",
                                "intensity": "7704.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "8",
                                "monoisotopic_mass": "1643.9224",
                                "monoisotopic_mz": "1644.9297",
                                "intensity": "6052.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0076",
                                        "ppm": "4.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "9",
                                "monoisotopic_mass": "916.4339",
                                "monoisotopic_mz": "917.4412",
                                "intensity": "5243.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "10",
                                "monoisotopic_mass": "2266.2406",
                                "monoisotopic_mz": "1134.1276",
                                "intensity": "26342.41",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0144",
                                        "ppm": "6.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "11",
                                "monoisotopic_mass": "2165.1918",
                                "monoisotopic_mz": "1083.6032",
                                "intensity": "19958.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0132",
                                        "ppm": "6.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "12",
                                "monoisotopic_mass": "1224.6923",
                                "monoisotopic_mz": "1225.6996",
                                "intensity": "8456.23",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1224.6826",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0097",
                                        "ppm": "7.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "13",
                                "monoisotopic_mass": "724.4635",
                                "monoisotopic_mz": "725.4708",
                                "intensity": "21231.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0039",
                                        "ppm": "5.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "14",
                                "monoisotopic_mass": "986.6104",
                                "monoisotopic_mz": "987.6177",
                                "intensity": "6088.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "15",
                                "monoisotopic_mass": "1745.0791",
                                "monoisotopic_mz": "873.5468",
                                "intensity": "2474.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "16",
                                "monoisotopic_mass": "2052.1051",
                                "monoisotopic_mz": "1027.0598",
                                "intensity": "14909.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2052.0945",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0106",
                                        "ppm": "5.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "17",
                                "monoisotopic_mass": "696.4684",
                                "monoisotopic_mz": "697.4757",
                                "intensity": "4316.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "18",
                                "monoisotopic_mass": "1700.9468",
                                "monoisotopic_mz": "851.4807",
                                "intensity": "6290.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1700.9362",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0105",
                                        "ppm": "6.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "19",
                                "monoisotopic_mass": "1643.9241",
                                "monoisotopic_mz": "822.9693",
                                "intensity": "10804.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0093",
                                        "ppm": "5.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "20",
                                "monoisotopic_mass": "625.3947",
                                "monoisotopic_mz": "626.4020",
                                "intensity": "6223.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "625.3911",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0036",
                                        "ppm": "5.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "21",
                                "monoisotopic_mass": "2549.3659",
                                "monoisotopic_mz": "1275.6902",
                                "intensity": "11215.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0228",
                                        "ppm": "8.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "22",
                                "monoisotopic_mass": "1717.0644",
                                "monoisotopic_mz": "859.5395",
                                "intensity": "3505.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "23",
                                "monoisotopic_mass": "1682.9388",
                                "monoisotopic_mz": "842.4767",
                                "intensity": "3319.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "24",
                                "monoisotopic_mass": "1185.7110",
                                "monoisotopic_mz": "1186.7183",
                                "intensity": "9069.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1185.7022",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0087",
                                        "ppm": "7.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "25",
                                "monoisotopic_mass": "2519.5488",
                                "monoisotopic_mz": "630.8945",
                                "intensity": "1180.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "26",
                                "monoisotopic_mass": "1428.7953",
                                "monoisotopic_mz": "715.4049",
                                "intensity": "3028.07",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0075",
                                        "ppm": "5.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "27",
                                "monoisotopic_mass": "670.2960",
                                "monoisotopic_mz": "671.3033",
                                "intensity": "3613.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "28",
                                "monoisotopic_mass": "649.3626",
                                "monoisotopic_mz": "650.3699",
                                "intensity": "2350.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "29",
                                "monoisotopic_mass": "1905.0380",
                                "monoisotopic_mz": "953.5263",
                                "intensity": "5944.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1905.0261",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0119",
                                        "ppm": "6.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "30",
                                "monoisotopic_mass": "2248.2255",
                                "monoisotopic_mz": "1125.1200",
                                "intensity": "9705.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "31",
                                "monoisotopic_mass": "523.3144",
                                "monoisotopic_mz": "524.3217",
                                "intensity": "8134.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "32",
                                "monoisotopic_mass": "2197.3585",
                                "monoisotopic_mz": "1099.6865",
                                "intensity": "5740.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "33",
                                "monoisotopic_mass": "412.2450",
                                "monoisotopic_mz": "413.2523",
                                "intensity": "4721.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "34",
                                "monoisotopic_mass": "1931.1966",
                                "monoisotopic_mz": "966.6056",
                                "intensity": "4006.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "35",
                                "monoisotopic_mass": "2936.5490",
                                "monoisotopic_mz": "1469.2818",
                                "intensity": "6070.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "36",
                                "monoisotopic_mass": "1570.7832",
                                "monoisotopic_mz": "1571.7905",
                                "intensity": "5276.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "37",
                                "monoisotopic_mass": "4080.5083",
                                "monoisotopic_mz": "1021.1343",
                                "intensity": "11716.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "38",
                                "monoisotopic_mass": "2010.2438",
                                "monoisotopic_mz": "1006.1292",
                                "intensity": "4512.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "39",
                                "monoisotopic_mass": "1875.1638",
                                "monoisotopic_mz": "938.5892",
                                "intensity": "3815.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "40",
                                "monoisotopic_mass": "555.2682",
                                "monoisotopic_mz": "556.2755",
                                "intensity": "3652.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "41",
                                "monoisotopic_mass": "955.5915",
                                "monoisotopic_mz": "956.5988",
                                "intensity": "3588.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "42",
                                "monoisotopic_mass": "2479.5217",
                                "monoisotopic_mz": "620.8877",
                                "intensity": "1223.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "43",
                                "monoisotopic_mass": "424.2452",
                                "monoisotopic_mz": "425.2524",
                                "intensity": "5458.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "44",
                                "monoisotopic_mass": "3281.7290",
                                "monoisotopic_mz": "1641.8718",
                                "intensity": "5244.19",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3281.7237",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0053",
                                        "ppm": "1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "45",
                                "monoisotopic_mass": "2115.3085",
                                "monoisotopic_mz": "1058.6615",
                                "intensity": "3050.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "46",
                                "monoisotopic_mass": "683.3428",
                                "monoisotopic_mz": "684.3500",
                                "intensity": "1537.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "47",
                                "monoisotopic_mass": "440.3130",
                                "monoisotopic_mz": "441.3203",
                                "intensity": "7490.31",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "440.3111",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0019",
                                        "ppm": "4.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "48",
                                "monoisotopic_mass": "466.2560",
                                "monoisotopic_mz": "467.2633",
                                "intensity": "1696.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "49",
                                "monoisotopic_mass": "796.4954",
                                "monoisotopic_mz": "797.5027",
                                "intensity": "1291.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "50",
                                "monoisotopic_mass": "540.3414",
                                "monoisotopic_mz": "541.3486",
                                "intensity": "3479.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "51",
                                "monoisotopic_mass": "2098.2911",
                                "monoisotopic_mz": "1050.1528",
                                "intensity": "4404.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "52",
                                "monoisotopic_mass": "1760.0808",
                                "monoisotopic_mz": "881.0477",
                                "intensity": "1948.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "53",
                                "monoisotopic_mass": "1669.0331",
                                "monoisotopic_mz": "835.5238",
                                "intensity": "2074.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "54",
                                "monoisotopic_mass": "2461.5219",
                                "monoisotopic_mz": "821.5146",
                                "intensity": "3156.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "55",
                                "monoisotopic_mass": "2936.5411",
                                "monoisotopic_mz": "979.8543",
                                "intensity": "3102.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2936.5185",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0226",
                                        "ppm": "7.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "56",
                                "monoisotopic_mass": "497.3349",
                                "monoisotopic_mz": "498.3422",
                                "intensity": "3527.30",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "497.3326",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0024",
                                        "ppm": "4.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "57",
                                "monoisotopic_mass": "1489.2553",
                                "monoisotopic_mz": "1490.2626",
                                "intensity": "2816.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "58",
                                "monoisotopic_mass": "3250.0132",
                                "monoisotopic_mz": "1084.3450",
                                "intensity": "5950.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "59",
                                "monoisotopic_mass": "3346.5575",
                                "monoisotopic_mz": "1116.5265",
                                "intensity": "4791.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "60",
                                "monoisotopic_mass": "2545.5725",
                                "monoisotopic_mz": "849.5314",
                                "intensity": "1098.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "61",
                                "monoisotopic_mass": "1796.1110",
                                "monoisotopic_mz": "899.0628",
                                "intensity": "1207.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "62",
                                "monoisotopic_mass": "3038.3781",
                                "monoisotopic_mz": "1013.8000",
                                "intensity": "2981.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "63",
                                "monoisotopic_mass": "2137.1964",
                                "monoisotopic_mz": "1069.6055",
                                "intensity": "5759.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "64",
                                "monoisotopic_mass": "1604.9959",
                                "monoisotopic_mz": "803.5052",
                                "intensity": "1905.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "65",
                                "monoisotopic_mass": "5205.2916",
                                "monoisotopic_mz": "1302.3302",
                                "intensity": "7355.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "66",
                                "monoisotopic_mass": "2767.7078",
                                "monoisotopic_mz": "1384.8612",
                                "intensity": "6556.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "67",
                                "monoisotopic_mass": "3436.1349",
                                "monoisotopic_mz": "1146.3856",
                                "intensity": "4226.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "68",
                                "monoisotopic_mass": "4553.8159",
                                "monoisotopic_mz": "1139.4613",
                                "intensity": "4275.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "69",
                                "monoisotopic_mass": "6145.2312",
                                "monoisotopic_mz": "1230.0535",
                                "intensity": "6013.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "70",
                                "monoisotopic_mass": "2684.6667",
                                "monoisotopic_mz": "895.8962",
                                "intensity": "2174.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "71",
                                "monoisotopic_mass": "2910.8038",
                                "monoisotopic_mz": "971.2752",
                                "intensity": "2417.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "72",
                                "monoisotopic_mass": "4151.5567",
                                "monoisotopic_mz": "1038.8965",
                                "intensity": "10961.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "73",
                                "monoisotopic_mass": "3454.1272",
                                "monoisotopic_mz": "1152.3830",
                                "intensity": "9202.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "74",
                                "monoisotopic_mass": "3706.9413",
                                "monoisotopic_mz": "927.7426",
                                "intensity": "3053.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "75",
                                "monoisotopic_mass": "2388.4716",
                                "monoisotopic_mz": "1195.2431",
                                "intensity": "4272.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "76",
                                "monoisotopic_mass": "2296.4265",
                                "monoisotopic_mz": "1149.2205",
                                "intensity": "5900.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "77",
                                "monoisotopic_mass": "3262.9782",
                                "monoisotopic_mz": "1088.6667",
                                "intensity": "4325.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "78",
                                "monoisotopic_mass": "2419.1613",
                                "monoisotopic_mz": "1210.5879",
                                "intensity": "3712.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "79",
                                "monoisotopic_mass": "3093.9169",
                                "monoisotopic_mz": "1032.3129",
                                "intensity": "5734.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "80",
                                "monoisotopic_mass": "2994.8534",
                                "monoisotopic_mz": "999.2917",
                                "intensity": "2815.33",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "81",
                                "monoisotopic_mass": "2849.2677",
                                "monoisotopic_mz": "950.7632",
                                "intensity": "1075.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "82",
                                "monoisotopic_mass": "5845.6159",
                                "monoisotopic_mz": "1170.1305",
                                "intensity": "9712.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "83",
                                "monoisotopic_mass": "5382.5743",
                                "monoisotopic_mz": "1346.6508",
                                "intensity": "5224.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "84",
                                "monoisotopic_mass": "3050.4587",
                                "monoisotopic_mz": "1017.8268",
                                "intensity": "2926.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "85",
                                "monoisotopic_mass": "3696.3197",
                                "monoisotopic_mz": "1233.1138",
                                "intensity": "5431.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "86",
                                "monoisotopic_mass": "5454.1639",
                                "monoisotopic_mz": "1364.5483",
                                "intensity": "7284.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "87",
                                "monoisotopic_mass": "6473.0580",
                                "monoisotopic_mz": "1295.6189",
                                "intensity": "6457.01",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "88",
                                "monoisotopic_mass": "2177.3522",
                                "monoisotopic_mz": "1089.6834",
                                "intensity": "3733.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "89",
                                "monoisotopic_mass": "4055.5055",
                                "monoisotopic_mz": "1014.8837",
                                "intensity": "4916.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "90",
                                "monoisotopic_mass": "1520.3475",
                                "monoisotopic_mz": "1521.3547",
                                "intensity": "3254.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "91",
                                "monoisotopic_mass": "4938.0567",
                                "monoisotopic_mz": "1235.5215",
                                "intensity": "7349.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "92",
                                "monoisotopic_mass": "3517.1770",
                                "monoisotopic_mz": "1173.3996",
                                "intensity": "5861.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "93",
                                "monoisotopic_mass": "3330.0634",
                                "monoisotopic_mz": "1111.0284",
                                "intensity": "4743.27",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "94",
                                "monoisotopic_mass": "3129.9605",
                                "monoisotopic_mz": "1044.3274",
                                "intensity": "1641.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "95",
                                "monoisotopic_mass": "1948.0359",
                                "monoisotopic_mz": "975.0252",
                                "intensity": "2130.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "96",
                                "monoisotopic_mass": "5133.6402",
                                "monoisotopic_mz": "1027.7353",
                                "intensity": "4010.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "97",
                                "monoisotopic_mass": "3169.9401",
                                "monoisotopic_mz": "1057.6540",
                                "intensity": "2738.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "98",
                                "monoisotopic_mass": "4711.9030",
                                "monoisotopic_mz": "1178.9830",
                                "intensity": "9390.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "99",
                                "monoisotopic_mass": "4729.6445",
                                "monoisotopic_mz": "1183.4184",
                                "intensity": "1666.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "100",
                                "monoisotopic_mass": "5729.5134",
                                "monoisotopic_mz": "1146.9099",
                                "intensity": "5496.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "101",
                                "monoisotopic_mass": "5117.1664",
                                "monoisotopic_mz": "1280.2989",
                                "intensity": "6997.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "102",
                                "monoisotopic_mass": "6303.3750",
                                "monoisotopic_mz": "1261.6823",
                                "intensity": "7302.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "103",
                                "monoisotopic_mass": "3301.0598",
                                "monoisotopic_mz": "1101.3605",
                                "intensity": "4477.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "104",
                                "monoisotopic_mass": "2455.1730",
                                "monoisotopic_mz": "1228.5938",
                                "intensity": "5425.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "105",
                                "monoisotopic_mass": "2679.6544",
                                "monoisotopic_mz": "1340.8345",
                                "intensity": "5159.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "106",
                                "monoisotopic_mass": "3636.2484",
                                "monoisotopic_mz": "910.0694",
                                "intensity": "2651.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "107",
                                "monoisotopic_mass": "2526.7760",
                                "monoisotopic_mz": "1264.3953",
                                "intensity": "5429.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "108",
                                "monoisotopic_mass": "4885.4279",
                                "monoisotopic_mz": "978.0928",
                                "intensity": "1192.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "109",
                                "monoisotopic_mass": "5475.3680",
                                "monoisotopic_mz": "1369.8493",
                                "intensity": "2591.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "110",
                                "monoisotopic_mass": "5322.7431",
                                "monoisotopic_mz": "1065.5559",
                                "intensity": "2626.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "111",
                                "monoisotopic_mass": "4373.2016",
                                "monoisotopic_mz": "1458.7411",
                                "intensity": "5762.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "112",
                                "monoisotopic_mass": "2400.6662",
                                "monoisotopic_mz": "1201.3404",
                                "intensity": "4197.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "113",
                                "monoisotopic_mass": "3801.1382",
                                "monoisotopic_mz": "951.2918",
                                "intensity": "1340.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "114",
                                "monoisotopic_mass": "3973.9405",
                                "monoisotopic_mz": "1325.6541",
                                "intensity": "3285.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "115",
                                "monoisotopic_mass": "3873.4018",
                                "monoisotopic_mz": "969.3577",
                                "intensity": "3364.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "116",
                                "monoisotopic_mass": "6442.7751",
                                "monoisotopic_mz": "1289.5623",
                                "intensity": "6728.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "117",
                                "monoisotopic_mass": "5263.7510",
                                "monoisotopic_mz": "1316.9450",
                                "intensity": "6929.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "118",
                                "monoisotopic_mass": "5086.9228",
                                "monoisotopic_mz": "1272.7380",
                                "intensity": "5980.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "119",
                                "monoisotopic_mass": "4304.6359",
                                "monoisotopic_mz": "1435.8859",
                                "intensity": "10300.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "120",
                                "monoisotopic_mass": "5228.9168",
                                "monoisotopic_mz": "1046.7906",
                                "intensity": "1158.83",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKWFNESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "239",
                                        "peak_id": "47",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "239",
                                        "peak_id": "56",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "239",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "239",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "239",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "239",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "239",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "239",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "239",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "239",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "239",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "239",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "239",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "239",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "239",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "239",
                                            "peak_id": "10",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "239",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "239",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "239",
                                        "peak_id": "55",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "239",
                                        "peak_id": "44",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "239",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "60",
                "p_value": "4.85e-17",
                "e_value": "4.85e-17",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "25",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "568",
                        "ms1_scans": "775",
                        "ids": "208",
                        "scans": "778",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "208",
                                "peak_id": "0",
                                "monoisotopic_mass": "1480.2377",
                                "monoisotopic_mz": "1481.2450",
                                "intensity": "4901.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "1",
                                "monoisotopic_mass": "1698.8426",
                                "monoisotopic_mz": "1699.8499",
                                "intensity": "6676.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "2",
                                "monoisotopic_mass": "2266.2296",
                                "monoisotopic_mz": "2267.2369",
                                "intensity": "6394.47",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0033",
                                        "ppm": "1.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "3",
                                "monoisotopic_mass": "2165.1820",
                                "monoisotopic_mz": "2166.1892",
                                "intensity": "7051.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0034",
                                        "ppm": "1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "4",
                                "monoisotopic_mass": "1515.8283",
                                "monoisotopic_mz": "1516.8356",
                                "intensity": "9265.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1515.8198",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0085",
                                        "ppm": "5.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "5",
                                "monoisotopic_mass": "852.5602",
                                "monoisotopic_mz": "853.5674",
                                "intensity": "33123.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0056",
                                        "ppm": "6.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "6",
                                "monoisotopic_mass": "2549.3495",
                                "monoisotopic_mz": "2550.3567",
                                "intensity": "9138.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0064",
                                        "ppm": "2.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "7",
                                "monoisotopic_mass": "2248.2042",
                                "monoisotopic_mz": "2249.2115",
                                "intensity": "5795.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "8",
                                "monoisotopic_mass": "1643.9123",
                                "monoisotopic_mz": "1644.9196",
                                "intensity": "9577.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0025",
                                        "ppm": "-1.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "9",
                                "monoisotopic_mass": "1570.7815",
                                "monoisotopic_mz": "1571.7888",
                                "intensity": "8692.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "10",
                                "monoisotopic_mass": "2052.1127",
                                "monoisotopic_mz": "1027.0636",
                                "intensity": "36296.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2052.0945",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0182",
                                        "ppm": "8.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "11",
                                "monoisotopic_mass": "1848.0186",
                                "monoisotopic_mz": "925.0166",
                                "intensity": "23629.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1848.0046",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0139",
                                        "ppm": "7.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "12",
                                "monoisotopic_mass": "2266.2440",
                                "monoisotopic_mz": "1134.1293",
                                "intensity": "53306.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0178",
                                        "ppm": "7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "13",
                                "monoisotopic_mass": "769.3653",
                                "monoisotopic_mz": "770.3726",
                                "intensity": "9001.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "14",
                                "monoisotopic_mass": "1015.5047",
                                "monoisotopic_mz": "1016.5120",
                                "intensity": "21003.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "15",
                                "monoisotopic_mass": "724.4642",
                                "monoisotopic_mz": "725.4715",
                                "intensity": "61963.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0047",
                                        "ppm": "6.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "16",
                                "monoisotopic_mass": "916.4353",
                                "monoisotopic_mz": "917.4426",
                                "intensity": "13364.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "17",
                                "monoisotopic_mass": "1152.5645",
                                "monoisotopic_mz": "1153.5718",
                                "intensity": "16197.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "18",
                                "monoisotopic_mass": "1224.6918",
                                "monoisotopic_mz": "1225.6991",
                                "intensity": "16985.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1224.6826",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "55",
                                        "mass_error": "0.0092",
                                        "ppm": "7.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "19",
                                "monoisotopic_mass": "1820.0237",
                                "monoisotopic_mz": "911.0191",
                                "intensity": "9347.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "20",
                                "monoisotopic_mass": "2165.1964",
                                "monoisotopic_mz": "1083.6055",
                                "intensity": "42511.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0178",
                                        "ppm": "8.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "21",
                                "monoisotopic_mass": "696.4689",
                                "monoisotopic_mz": "697.4761",
                                "intensity": "12080.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "22",
                                "monoisotopic_mass": "625.3951",
                                "monoisotopic_mz": "626.4023",
                                "intensity": "18554.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "625.3911",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0039",
                                        "ppm": "6.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "23",
                                "monoisotopic_mass": "670.2966",
                                "monoisotopic_mz": "671.3039",
                                "intensity": "10659.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "24",
                                "monoisotopic_mass": "1643.9253",
                                "monoisotopic_mz": "822.9699",
                                "intensity": "24476.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0105",
                                        "ppm": "6.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "25",
                                "monoisotopic_mass": "1362.8462",
                                "monoisotopic_mz": "682.4304",
                                "intensity": "7951.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "26",
                                "monoisotopic_mass": "2248.2284",
                                "monoisotopic_mz": "1125.1215",
                                "intensity": "18188.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "27",
                                "monoisotopic_mass": "1464.7701",
                                "monoisotopic_mz": "733.3923",
                                "intensity": "4407.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "28",
                                "monoisotopic_mass": "1905.0380",
                                "monoisotopic_mz": "953.5263",
                                "intensity": "15457.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1905.0261",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0119",
                                        "ppm": "6.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "29",
                                "monoisotopic_mass": "1298.7259",
                                "monoisotopic_mz": "650.3702",
                                "intensity": "9114.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "30",
                                "monoisotopic_mass": "2137.1974",
                                "monoisotopic_mz": "1069.6060",
                                "intensity": "14393.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "31",
                                "monoisotopic_mass": "1682.9432",
                                "monoisotopic_mz": "842.4789",
                                "intensity": "7427.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "32",
                                "monoisotopic_mass": "523.3148",
                                "monoisotopic_mz": "524.3220",
                                "intensity": "27815.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "33",
                                "monoisotopic_mass": "791.3651",
                                "monoisotopic_mz": "792.3724",
                                "intensity": "5551.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "34",
                                "monoisotopic_mass": "609.3257",
                                "monoisotopic_mz": "610.3330",
                                "intensity": "6215.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "35",
                                "monoisotopic_mass": "1185.7071",
                                "monoisotopic_mz": "1186.7144",
                                "intensity": "19851.31",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1185.7022",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0048",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "36",
                                "monoisotopic_mass": "2549.3605",
                                "monoisotopic_mz": "1275.6875",
                                "intensity": "20173.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0174",
                                        "ppm": "6.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "37",
                                "monoisotopic_mass": "974.6012",
                                "monoisotopic_mz": "975.6085",
                                "intensity": "7298.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "38",
                                "monoisotopic_mass": "1515.8277",
                                "monoisotopic_mz": "758.9211",
                                "intensity": "7894.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1515.8198",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0079",
                                        "ppm": "5.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "39",
                                "monoisotopic_mass": "466.2559",
                                "monoisotopic_mz": "467.2632",
                                "intensity": "6061.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "40",
                                "monoisotopic_mass": "2024.1232",
                                "monoisotopic_mz": "1013.0689",
                                "intensity": "9836.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "41",
                                "monoisotopic_mass": "2708.6733",
                                "monoisotopic_mz": "678.1756",
                                "intensity": "3425.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "42",
                                "monoisotopic_mass": "1428.7966",
                                "monoisotopic_mz": "715.4056",
                                "intensity": "7333.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0088",
                                        "ppm": "6.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "43",
                                "monoisotopic_mass": "1683.0309",
                                "monoisotopic_mz": "562.0176",
                                "intensity": "2939.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "44",
                                "monoisotopic_mass": "1753.0858",
                                "monoisotopic_mz": "877.5502",
                                "intensity": "4337.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "45",
                                "monoisotopic_mass": "1700.9464",
                                "monoisotopic_mz": "851.4805",
                                "intensity": "15024.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1700.9362",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0102",
                                        "ppm": "5.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "46",
                                "monoisotopic_mass": "990.6390",
                                "monoisotopic_mz": "496.3268",
                                "intensity": "5228.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "47",
                                "monoisotopic_mass": "2495.5500",
                                "monoisotopic_mz": "832.8573",
                                "intensity": "5109.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "48",
                                "monoisotopic_mass": "1428.7929",
                                "monoisotopic_mz": "1429.8002",
                                "intensity": "20758.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1428.7878",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0051",
                                        "ppm": "3.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "49",
                                "monoisotopic_mass": "412.2453",
                                "monoisotopic_mz": "413.2525",
                                "intensity": "9560.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "50",
                                "monoisotopic_mass": "555.2836",
                                "monoisotopic_mz": "556.2909",
                                "intensity": "4865.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "51",
                                "monoisotopic_mass": "2829.7542",
                                "monoisotopic_mz": "944.2587",
                                "intensity": "3479.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "52",
                                "monoisotopic_mass": "3032.8806",
                                "monoisotopic_mz": "759.2274",
                                "intensity": "3360.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "53",
                                "monoisotopic_mass": "2656.6323",
                                "monoisotopic_mz": "665.1654",
                                "intensity": "5069.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "54",
                                "monoisotopic_mass": "2690.6700",
                                "monoisotopic_mz": "897.8973",
                                "intensity": "3881.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "55",
                                "monoisotopic_mass": "1932.1961",
                                "monoisotopic_mz": "645.0726",
                                "intensity": "1787.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "56",
                                "monoisotopic_mass": "2065.2772",
                                "monoisotopic_mz": "1033.6459",
                                "intensity": "8442.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "57",
                                "monoisotopic_mass": "3645.2640",
                                "monoisotopic_mz": "912.3233",
                                "intensity": "1610.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "58",
                                "monoisotopic_mass": "2532.5678",
                                "monoisotopic_mz": "845.1965",
                                "intensity": "5466.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "59",
                                "monoisotopic_mass": "1891.1746",
                                "monoisotopic_mz": "946.5946",
                                "intensity": "4720.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "60",
                                "monoisotopic_mass": "3968.4641",
                                "monoisotopic_mz": "993.1233",
                                "intensity": "9293.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "61",
                                "monoisotopic_mass": "2922.8069",
                                "monoisotopic_mz": "731.7090",
                                "intensity": "5226.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "62",
                                "monoisotopic_mass": "1572.9773",
                                "monoisotopic_mz": "787.4959",
                                "intensity": "4386.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "63",
                                "monoisotopic_mass": "6495.7971",
                                "monoisotopic_mz": "1300.1667",
                                "intensity": "14531.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "64",
                                "monoisotopic_mass": "3418.7973",
                                "monoisotopic_mz": "1710.4059",
                                "intensity": "7542.16",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3418.7826",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0146",
                                        "ppm": "4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "65",
                                "monoisotopic_mass": "1877.1630",
                                "monoisotopic_mz": "939.5888",
                                "intensity": "4384.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "66",
                                "monoisotopic_mass": "2649.6445",
                                "monoisotopic_mz": "884.2221",
                                "intensity": "4410.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "67",
                                "monoisotopic_mass": "1619.0019",
                                "monoisotopic_mz": "810.5082",
                                "intensity": "3352.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "68",
                                "monoisotopic_mass": "2789.7414",
                                "monoisotopic_mz": "930.9211",
                                "intensity": "4733.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "69",
                                "monoisotopic_mass": "2676.6573",
                                "monoisotopic_mz": "893.2264",
                                "intensity": "5073.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "70",
                                "monoisotopic_mass": "4628.8673",
                                "monoisotopic_mz": "1158.2241",
                                "intensity": "17521.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "71",
                                "monoisotopic_mass": "3101.9293",
                                "monoisotopic_mz": "1034.9837",
                                "intensity": "12763.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "72",
                                "monoisotopic_mass": "1659.0310",
                                "monoisotopic_mz": "830.5228",
                                "intensity": "5666.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "73",
                                "monoisotopic_mass": "4177.5618",
                                "monoisotopic_mz": "1393.5279",
                                "intensity": "11956.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "74",
                                "monoisotopic_mass": "2427.4902",
                                "monoisotopic_mz": "607.8798",
                                "intensity": "1595.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "75",
                                "monoisotopic_mass": "5353.8910",
                                "monoisotopic_mz": "1071.7855",
                                "intensity": "5715.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "76",
                                "monoisotopic_mass": "4553.9118",
                                "monoisotopic_mz": "1518.9779",
                                "intensity": "7410.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "77",
                                "monoisotopic_mass": "5223.2521",
                                "monoisotopic_mz": "1306.8203",
                                "intensity": "10717.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "78",
                                "monoisotopic_mass": "2453.2174",
                                "monoisotopic_mz": "1227.6160",
                                "intensity": "7445.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "79",
                                "monoisotopic_mass": "1931.1947",
                                "monoisotopic_mz": "966.6046",
                                "intensity": "6054.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "80",
                                "monoisotopic_mass": "4063.5160",
                                "monoisotopic_mz": "1016.8863",
                                "intensity": "8731.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "81",
                                "monoisotopic_mass": "2245.3829",
                                "monoisotopic_mz": "749.4683",
                                "intensity": "1484.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "82",
                                "monoisotopic_mass": "2807.2560",
                                "monoisotopic_mz": "936.7593",
                                "intensity": "1813.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "83",
                                "monoisotopic_mass": "3730.3061",
                                "monoisotopic_mz": "933.5838",
                                "intensity": "5747.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "84",
                                "monoisotopic_mass": "2997.8657",
                                "monoisotopic_mz": "1000.2958",
                                "intensity": "4350.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "85",
                                "monoisotopic_mass": "2820.7224",
                                "monoisotopic_mz": "1411.3685",
                                "intensity": "6988.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "86",
                                "monoisotopic_mass": "4407.2382",
                                "monoisotopic_mz": "1102.8168",
                                "intensity": "6812.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "87",
                                "monoisotopic_mass": "2500.5534",
                                "monoisotopic_mz": "1251.2840",
                                "intensity": "10271.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "88",
                                "monoisotopic_mass": "4401.7356",
                                "monoisotopic_mz": "881.3544",
                                "intensity": "4362.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "89",
                                "monoisotopic_mass": "4819.9904",
                                "monoisotopic_mz": "965.0054",
                                "intensity": "6834.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "90",
                                "monoisotopic_mass": "3486.1535",
                                "monoisotopic_mz": "872.5457",
                                "intensity": "2908.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "91",
                                "monoisotopic_mass": "2571.5947",
                                "monoisotopic_mz": "858.2055",
                                "intensity": "3451.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "92",
                                "monoisotopic_mass": "3708.2854",
                                "monoisotopic_mz": "928.0786",
                                "intensity": "5227.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "93",
                                "monoisotopic_mass": "6234.2424",
                                "monoisotopic_mz": "1247.8558",
                                "intensity": "12504.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "94",
                                "monoisotopic_mass": "2936.5324",
                                "monoisotopic_mz": "1469.2735",
                                "intensity": "10748.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2936.5185",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0139",
                                        "ppm": "4.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "95",
                                "monoisotopic_mass": "3571.2033",
                                "monoisotopic_mz": "893.8081",
                                "intensity": "5533.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "96",
                                "monoisotopic_mass": "4089.5264",
                                "monoisotopic_mz": "1023.3889",
                                "intensity": "14509.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "97",
                                "monoisotopic_mass": "2060.2683",
                                "monoisotopic_mz": "687.7634",
                                "intensity": "1657.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "98",
                                "monoisotopic_mass": "3874.3957",
                                "monoisotopic_mz": "969.6062",
                                "intensity": "5138.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "99",
                                "monoisotopic_mass": "3295.0476",
                                "monoisotopic_mz": "824.7692",
                                "intensity": "4841.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "100",
                                "monoisotopic_mass": "5329.2598",
                                "monoisotopic_mz": "1333.3222",
                                "intensity": "4953.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "101",
                                "monoisotopic_mass": "2187.3514",
                                "monoisotopic_mz": "1094.6830",
                                "intensity": "9546.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "102",
                                "monoisotopic_mass": "4892.2818",
                                "monoisotopic_mz": "1224.0777",
                                "intensity": "11357.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "103",
                                "monoisotopic_mass": "3418.8143",
                                "monoisotopic_mz": "1140.6120",
                                "intensity": "10407.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3418.7826",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0316",
                                        "ppm": "9.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "104",
                                "monoisotopic_mass": "1955.2049",
                                "monoisotopic_mz": "978.6097",
                                "intensity": "5833.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "105",
                                "monoisotopic_mass": "4426.7544",
                                "monoisotopic_mz": "1107.6959",
                                "intensity": "14453.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "106",
                                "monoisotopic_mass": "2425.2052",
                                "monoisotopic_mz": "1213.6099",
                                "intensity": "8356.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "107",
                                "monoisotopic_mass": "2530.5636",
                                "monoisotopic_mz": "1266.2891",
                                "intensity": "8842.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "108",
                                "monoisotopic_mass": "2468.5419",
                                "monoisotopic_mz": "1235.2782",
                                "intensity": "9930.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "109",
                                "monoisotopic_mass": "6664.3635",
                                "monoisotopic_mz": "1333.8800",
                                "intensity": "11729.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "110",
                                "monoisotopic_mass": "1727.0665",
                                "monoisotopic_mz": "864.5405",
                                "intensity": "4201.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "111",
                                "monoisotopic_mass": "5404.6741",
                                "monoisotopic_mz": "1081.9421",
                                "intensity": "8155.53",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "112",
                                "monoisotopic_mass": "3511.1666",
                                "monoisotopic_mz": "878.7989",
                                "intensity": "3988.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "113",
                                "monoisotopic_mass": "4123.1172",
                                "monoisotopic_mz": "1375.3797",
                                "intensity": "9732.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "114",
                                "monoisotopic_mass": "5858.3514",
                                "monoisotopic_mz": "1172.6776",
                                "intensity": "6732.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "115",
                                "monoisotopic_mass": "2606.3856",
                                "monoisotopic_mz": "1304.2001",
                                "intensity": "7475.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2606.3645",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0211",
                                        "ppm": "8.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "116",
                                "monoisotopic_mass": "3955.4508",
                                "monoisotopic_mz": "989.8700",
                                "intensity": "8082.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "117",
                                "monoisotopic_mass": "3571.2125",
                                "monoisotopic_mz": "1191.4115",
                                "intensity": "11317.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "118",
                                "monoisotopic_mass": "2701.0775",
                                "monoisotopic_mz": "1351.5460",
                                "intensity": "7551.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "119",
                                "monoisotopic_mass": "3827.3888",
                                "monoisotopic_mz": "957.8545",
                                "intensity": "5223.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "208",
                                "peak_id": "120",
                                "monoisotopic_mass": "4671.6007",
                                "monoisotopic_mz": "1168.9074",
                                "intensity": "6487.48",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKWFNESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "208",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "208",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "208",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "208",
                                        "peak_id": "35",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "208",
                                            "peak_id": "48",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "208",
                                            "peak_id": "42",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "208",
                                            "peak_id": "38",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "208",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "208",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "208",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "208",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "208",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "208",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "208",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "208",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "208",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "208",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "208",
                                            "peak_id": "12",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "208",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "208",
                                            "peak_id": "36",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "208",
                                        "peak_id": "115",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "208",
                                        "peak_id": "94",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "208",
                                            "peak_id": "64",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "208",
                                            "peak_id": "103",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "13",
                                        "spec_id": "208",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "155",
                "p_value": "2.36e-06",
                "e_value": "2.36e-06",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                        "ms1_ids": "623",
                        "ms1_scans": "993",
                        "ids": "370",
                        "scans": "995",
                        "precursor_mono_mass": "7266.7415",
                        "precursor_charge": "5",
                        "precursor_mz": "1454.3556",
                        "feature_inte": "6.4370e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "370",
                                "peak_id": "0",
                                "monoisotopic_mass": "1825.9096",
                                "monoisotopic_mz": "1826.9169",
                                "intensity": "1703.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "1",
                                "monoisotopic_mass": "1376.7178",
                                "monoisotopic_mz": "1377.7251",
                                "intensity": "1936.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "2",
                                "monoisotopic_mass": "1654.8359",
                                "monoisotopic_mz": "1655.8431",
                                "intensity": "1133.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "3",
                                "monoisotopic_mass": "1248.6215",
                                "monoisotopic_mz": "1249.6288",
                                "intensity": "3262.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "4",
                                "monoisotopic_mass": "1603.8815",
                                "monoisotopic_mz": "1604.8888",
                                "intensity": "3962.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "5",
                                "monoisotopic_mass": "1723.8841",
                                "monoisotopic_mz": "1724.8914",
                                "intensity": "1439.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "6",
                                "monoisotopic_mass": "2435.3016",
                                "monoisotopic_mz": "2436.3089",
                                "intensity": "2771.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "7",
                                "monoisotopic_mass": "3594.8169",
                                "monoisotopic_mz": "1798.4157",
                                "intensity": "3996.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "8",
                                "monoisotopic_mass": "1140.5955",
                                "monoisotopic_mz": "1141.6028",
                                "intensity": "3985.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "9",
                                "monoisotopic_mass": "724.4629",
                                "monoisotopic_mz": "725.4702",
                                "intensity": "3434.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "724.4596",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0033",
                                        "ppm": "4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "10",
                                "monoisotopic_mass": "2023.1054",
                                "monoisotopic_mz": "1012.5600",
                                "intensity": "1415.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "11",
                                "monoisotopic_mass": "3766.8649",
                                "monoisotopic_mz": "1884.4397",
                                "intensity": "3379.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "12",
                                "monoisotopic_mass": "1643.9223",
                                "monoisotopic_mz": "822.9684",
                                "intensity": "1626.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "1.5807671501e-02",
                                        "theoretical_mass": "1643.9306",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0082",
                                        "ppm": "-5.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "13",
                                "monoisotopic_mass": "2266.2406",
                                "monoisotopic_mz": "1134.1276",
                                "intensity": "5762.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "1.5807671501e-02",
                                        "theoretical_mass": "2266.2421",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "14",
                                "monoisotopic_mass": "584.2944",
                                "monoisotopic_mz": "585.3017",
                                "intensity": "3216.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "15",
                                "monoisotopic_mass": "852.5583",
                                "monoisotopic_mz": "853.5656",
                                "intensity": "2079.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "852.5545",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0038",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "16",
                                "monoisotopic_mass": "2052.1098",
                                "monoisotopic_mz": "1027.0622",
                                "intensity": "2612.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "1.5807671501e-02",
                                        "theoretical_mass": "2052.1103",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "17",
                                "monoisotopic_mass": "761.4505",
                                "monoisotopic_mz": "762.4578",
                                "intensity": "3683.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "18",
                                "monoisotopic_mass": "2165.1903",
                                "monoisotopic_mz": "1083.6024",
                                "intensity": "4160.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "1.5807671501e-02",
                                        "theoretical_mass": "2165.1944",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0041",
                                        "ppm": "-1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "19",
                                "monoisotopic_mass": "3636.8134",
                                "monoisotopic_mz": "1819.4140",
                                "intensity": "1880.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "20",
                                "monoisotopic_mass": "1453.7327",
                                "monoisotopic_mz": "1454.7400",
                                "intensity": "5195.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "21",
                                "monoisotopic_mass": "1274.6818",
                                "monoisotopic_mz": "1275.6891",
                                "intensity": "1939.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "22",
                                "monoisotopic_mass": "655.3322",
                                "monoisotopic_mz": "656.3395",
                                "intensity": "1935.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "23",
                                "monoisotopic_mass": "1336.7140",
                                "monoisotopic_mz": "1337.7213",
                                "intensity": "1453.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "24",
                                "monoisotopic_mass": "555.2681",
                                "monoisotopic_mz": "556.2754",
                                "intensity": "692.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "25",
                                "monoisotopic_mass": "523.3141",
                                "monoisotopic_mz": "524.3213",
                                "intensity": "1864.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "26",
                                "monoisotopic_mass": "916.4329",
                                "monoisotopic_mz": "917.4401",
                                "intensity": "969.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "27",
                                "monoisotopic_mass": "2248.2272",
                                "monoisotopic_mz": "1125.1209",
                                "intensity": "1003.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "28",
                                "monoisotopic_mass": "1701.9490",
                                "monoisotopic_mz": "851.9818",
                                "intensity": "905.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "29",
                                "monoisotopic_mass": "424.2451",
                                "monoisotopic_mz": "425.2523",
                                "intensity": "1522.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "30",
                                "monoisotopic_mass": "1497.8143",
                                "monoisotopic_mz": "1498.8215",
                                "intensity": "696.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "31",
                                "monoisotopic_mass": "1038.6382",
                                "monoisotopic_mz": "1039.6455",
                                "intensity": "2233.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1038.6338",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0044",
                                        "ppm": "4.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "32",
                                "monoisotopic_mass": "1012.5003",
                                "monoisotopic_mz": "1013.5076",
                                "intensity": "1831.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "33",
                                "monoisotopic_mass": "2636.2133",
                                "monoisotopic_mz": "1319.1139",
                                "intensity": "1903.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "34",
                                "monoisotopic_mass": "1906.0395",
                                "monoisotopic_mz": "954.0270",
                                "intensity": "424.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "35",
                                "monoisotopic_mass": "1203.6086",
                                "monoisotopic_mz": "1204.6158",
                                "intensity": "1532.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "36",
                                "monoisotopic_mass": "1927.9497",
                                "monoisotopic_mz": "1928.9570",
                                "intensity": "1003.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "37",
                                "monoisotopic_mass": "1408.8786",
                                "monoisotopic_mz": "1409.8859",
                                "intensity": "1045.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "38",
                                "monoisotopic_mass": "1185.7089",
                                "monoisotopic_mz": "1186.7162",
                                "intensity": "1744.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "1.5807671501e-02",
                                        "theoretical_mass": "1185.7181",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0091",
                                        "ppm": "-7.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "39",
                                "monoisotopic_mass": "1218.1584",
                                "monoisotopic_mz": "1219.1656",
                                "intensity": "1490.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "40",
                                "monoisotopic_mass": "608.3312",
                                "monoisotopic_mz": "609.3384",
                                "intensity": "707.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "41",
                                "monoisotopic_mass": "6227.1527",
                                "monoisotopic_mz": "1246.4378",
                                "intensity": "1299.87",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "1.5807671501e-02",
                                            "theoretical_mass": "6227.1339",
                                            "ion_position": "57",
                                            "ion_display_position": "57",
                                            "ion_sort_name": "B00057",
                                            "ion_left_position": "57",
                                            "mass_error": "0.0188",
                                            "ppm": "3.02"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "1.5807671501e-02",
                                            "theoretical_mass": "6228.1027",
                                            "ion_position": "9",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "Y00059",
                                            "ion_left_position": "9",
                                            "mass_error": "0.0524",
                                            "ppm": "8.41"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "42",
                                "monoisotopic_mass": "953.5189",
                                "monoisotopic_mz": "954.5262",
                                "intensity": "257.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "43",
                                "monoisotopic_mass": "452.2397",
                                "monoisotopic_mz": "453.2470",
                                "intensity": "1205.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "44",
                                "monoisotopic_mass": "3618.8097",
                                "monoisotopic_mz": "1810.4121",
                                "intensity": "1852.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "45",
                                "monoisotopic_mass": "4991.0840",
                                "monoisotopic_mz": "1248.7783",
                                "intensity": "1061.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "46",
                                "monoisotopic_mass": "6501.1933",
                                "monoisotopic_mz": "1301.2459",
                                "intensity": "1897.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "47",
                                "monoisotopic_mass": "5199.6406",
                                "monoisotopic_mz": "1300.9174",
                                "intensity": "551.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "48",
                                "monoisotopic_mass": "2566.1713",
                                "monoisotopic_mz": "1284.0929",
                                "intensity": "704.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "49",
                                "monoisotopic_mass": "3873.0158",
                                "monoisotopic_mz": "1292.0125",
                                "intensity": "1371.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "50",
                                "monoisotopic_mass": "6190.2433",
                                "monoisotopic_mz": "1239.0559",
                                "intensity": "702.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "51",
                                "monoisotopic_mass": "2291.1913",
                                "monoisotopic_mz": "1146.6029",
                                "intensity": "536.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "52",
                                "monoisotopic_mass": "5301.3306",
                                "monoisotopic_mz": "1326.3399",
                                "intensity": "1673.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "53",
                                "monoisotopic_mass": "6398.6371",
                                "monoisotopic_mz": "1280.7347",
                                "intensity": "1468.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "54",
                                "monoisotopic_mass": "5446.1737",
                                "monoisotopic_mz": "1362.5507",
                                "intensity": "534.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "55",
                                "monoisotopic_mass": "3814.2118",
                                "monoisotopic_mz": "1272.4112",
                                "intensity": "621.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "56",
                                "monoisotopic_mass": "5509.7241",
                                "monoisotopic_mz": "1102.9521",
                                "intensity": "677.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "57",
                                "monoisotopic_mass": "6674.5816",
                                "monoisotopic_mz": "1335.9236",
                                "intensity": "1307.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "58",
                                "monoisotopic_mass": "2734.2834",
                                "monoisotopic_mz": "1368.1490",
                                "intensity": "1127.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "59",
                                "monoisotopic_mass": "1847.0102",
                                "monoisotopic_mz": "924.5124",
                                "intensity": "1521.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "60",
                                "monoisotopic_mass": "3594.2340",
                                "monoisotopic_mz": "1199.0853",
                                "intensity": "616.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "61",
                                "monoisotopic_mass": "4874.4697",
                                "monoisotopic_mz": "1219.6247",
                                "intensity": "567.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "62",
                                "monoisotopic_mass": "6630.6097",
                                "monoisotopic_mz": "1327.1292",
                                "intensity": "1362.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "63",
                                "monoisotopic_mass": "4336.4776",
                                "monoisotopic_mz": "1085.1267",
                                "intensity": "537.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "370",
                                "peak_id": "64",
                                "monoisotopic_mass": "6804.1839",
                                "monoisotopic_mz": "1361.8441",
                                "intensity": "424.86",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "12",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7365",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "annotated_seq": "M.AKIKGQVKW(F)[+0.0158]NESKGFGFITPADGSKDVFVHFSAIQGNGFKTLAEGQNVEFEIQDGQKGPAAVNVTAI.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "370",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "370",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "370",
                                            "peak_id": "31",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "9",
                                            "ion_display_position": "59",
                                            "spec_id": "370",
                                            "peak_id": "41",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "370",
                                        "peak_id": "38",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "370",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "370",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "370",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "370",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "57",
                                        "ion_display_position": "57",
                                        "spec_id": "370",
                                        "peak_id": "41",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "10",
                            "right_position": "11",
                            "shift": "1.5807671501e-02",
                            "anno": "+0.0158",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
