prsm_data =
{
    "protein": {
        "sequence_id": "9",
        "sequence_name": "sp|P0A972|CSPE_ECOLI",
        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "9",
            "sequence_name": "sp|P0A972|CSPE_ECOLI",
            "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
            "proteoform_id": "9",
            "prsm_number": "5",
            "prsm": [
                {
                    "prsm_id": "52",
                    "p_value": "1.88e-25",
                    "e_value": "1.88e-25",
                    "fdr": "0",
                    "matched_fragment_number": "32",
                    "matched_peak_number": "39",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "533",
                            "ms1_scans": "635",
                            "ids": "101",
                            "scans": "636",
                            "precursor_mono_mass": "7327.7964",
                            "precursor_charge": "5",
                            "precursor_mz": "1466.5666",
                            "feature_inte": "1.0712e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_mass": "7327.7735",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "69",
                            "first_residue_position": "1",
                            "last_residue_position": "68",
                            "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "N"
                                },
                                {
                                    "position": "7",
                                    "acid": "V"
                                },
                                {
                                    "position": "8",
                                    "acid": "K"
                                },
                                {
                                    "position": "9",
                                    "acid": "W"
                                },
                                {
                                    "position": "10",
                                    "acid": "F"
                                },
                                {
                                    "position": "11",
                                    "acid": "N"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "K"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "F"
                                },
                                {
                                    "position": "17",
                                    "acid": "G"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "I"
                                },
                                {
                                    "position": "20",
                                    "acid": "T"
                                },
                                {
                                    "position": "21",
                                    "acid": "P"
                                },
                                {
                                    "position": "22",
                                    "acid": "E"
                                },
                                {
                                    "position": "23",
                                    "acid": "D"
                                },
                                {
                                    "position": "24",
                                    "acid": "G"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "K"
                                },
                                {
                                    "position": "27",
                                    "acid": "D"
                                },
                                {
                                    "position": "28",
                                    "acid": "V"
                                },
                                {
                                    "position": "29",
                                    "acid": "F"
                                },
                                {
                                    "position": "30",
                                    "acid": "V"
                                },
                                {
                                    "position": "31",
                                    "acid": "H"
                                },
                                {
                                    "position": "32",
                                    "acid": "F"
                                },
                                {
                                    "position": "33",
                                    "acid": "S"
                                },
                                {
                                    "position": "34",
                                    "acid": "A"
                                },
                                {
                                    "position": "35",
                                    "acid": "I"
                                },
                                {
                                    "position": "36",
                                    "acid": "Q"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "N"
                                },
                                {
                                    "position": "39",
                                    "acid": "G"
                                },
                                {
                                    "position": "40",
                                    "acid": "F"
                                },
                                {
                                    "position": "41",
                                    "acid": "K"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "A"
                                },
                                {
                                    "position": "45",
                                    "acid": "E"
                                },
                                {
                                    "position": "46",
                                    "acid": "G"
                                },
                                {
                                    "position": "47",
                                    "acid": "Q"
                                },
                                {
                                    "position": "48",
                                    "acid": "R"
                                },
                                {
                                    "position": "49",
                                    "acid": "V"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "F"
                                },
                                {
                                    "position": "52",
                                    "acid": "E"
                                },
                                {
                                    "position": "53",
                                    "acid": "I"
                                },
                                {
                                    "position": "54",
                                    "acid": "T"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "G"
                                },
                                {
                                    "position": "57",
                                    "acid": "A"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "G"
                                },
                                {
                                    "position": "60",
                                    "acid": "P"
                                },
                                {
                                    "position": "61",
                                    "acid": "S"
                                },
                                {
                                    "position": "62",
                                    "acid": "A"
                                },
                                {
                                    "position": "63",
                                    "acid": "A"
                                },
                                {
                                    "position": "64",
                                    "acid": "N"
                                },
                                {
                                    "position": "65",
                                    "acid": "V"
                                },
                                {
                                    "position": "66",
                                    "acid": "I"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "L"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "101",
                                            "peak_id": "76",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "101",
                                            "peak_id": "69",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "101",
                                            "peak_id": "90",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "101",
                                            "peak_id": "60",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "101",
                                            "peak_id": "35",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "101",
                                            "peak_id": "85",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "101",
                                            "peak_id": "46",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "101",
                                                "peak_id": "32",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "101",
                                                "peak_id": "108",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "101",
                                                "peak_id": "77",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "101",
                                                "peak_id": "101",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "101",
                                            "peak_id": "53",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "101",
                                            "peak_id": "48",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "101",
                                            "peak_id": "62",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "18",
                                                "ion_display_position": "18",
                                                "spec_id": "101",
                                                "peak_id": "50",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "18",
                                                "ion_display_position": "18",
                                                "spec_id": "101",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "19",
                                                "ion_display_position": "19",
                                                "spec_id": "101",
                                                "peak_id": "30",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "19",
                                                "ion_display_position": "19",
                                                "spec_id": "101",
                                                "peak_id": "94",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "101",
                                                "peak_id": "71",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "101",
                                                "peak_id": "83",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "101",
                                            "peak_id": "113",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "23",
                                                "ion_display_position": "23",
                                                "spec_id": "101",
                                                "peak_id": "20",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "23",
                                                "ion_display_position": "23",
                                                "spec_id": "101",
                                                "peak_id": "100",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "27",
                                                "ion_display_position": "27",
                                                "spec_id": "101",
                                                "peak_id": "114",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "27",
                                                "ion_display_position": "27",
                                                "spec_id": "101",
                                                "peak_id": "91",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "40",
                                            "spec_id": "101",
                                            "peak_id": "6",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "29",
                                                "ion_display_position": "29",
                                                "spec_id": "101",
                                                "peak_id": "15",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "29",
                                                "ion_display_position": "39",
                                                "spec_id": "101",
                                                "peak_id": "110",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "30",
                                                "ion_display_position": "30",
                                                "spec_id": "101",
                                                "peak_id": "23",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "38",
                                                "spec_id": "101",
                                                "peak_id": "49",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "31",
                                            "ion_display_position": "37",
                                            "spec_id": "101",
                                            "peak_id": "79",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "36",
                                            "spec_id": "101",
                                            "peak_id": "67",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "34",
                                                "ion_display_position": "34",
                                                "spec_id": "101",
                                                "peak_id": "42",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "34",
                                                "ion_display_position": "34",
                                                "spec_id": "101",
                                                "peak_id": "99",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "35",
                                            "ion_display_position": "33",
                                            "spec_id": "101",
                                            "peak_id": "38",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "36",
                                            "ion_display_position": "32",
                                            "spec_id": "101",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "27",
                                            "spec_id": "101",
                                            "peak_id": "36",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "23",
                                            "spec_id": "101",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "54",
                                            "ion_display_position": "14",
                                            "spec_id": "101",
                                            "peak_id": "64",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ]
                        }
                    }
                },
                {
                    "prsm_id": "31",
                    "p_value": "3.98e-21",
                    "e_value": "3.98e-21",
                    "fdr": "0",
                    "matched_fragment_number": "27",
                    "matched_peak_number": "34",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "522",
                            "ms1_scans": "591",
                            "ids": "68",
                            "scans": "592",
                            "precursor_mono_mass": "7327.7964",
                            "precursor_charge": "5",
                            "precursor_mz": "1466.5666",
                            "feature_inte": "1.0712e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_mass": "7327.7735",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "69",
                            "first_residue_position": "1",
                            "last_residue_position": "68",
                            "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "N"
                                },
                                {
                                    "position": "7",
                                    "acid": "V"
                                },
                                {
                                    "position": "8",
                                    "acid": "K"
                                },
                                {
                                    "position": "9",
                                    "acid": "W"
                                },
                                {
                                    "position": "10",
                                    "acid": "F"
                                },
                                {
                                    "position": "11",
                                    "acid": "N"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "K"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "F"
                                },
                                {
                                    "position": "17",
                                    "acid": "G"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "I"
                                },
                                {
                                    "position": "20",
                                    "acid": "T"
                                },
                                {
                                    "position": "21",
                                    "acid": "P"
                                },
                                {
                                    "position": "22",
                                    "acid": "E"
                                },
                                {
                                    "position": "23",
                                    "acid": "D"
                                },
                                {
                                    "position": "24",
                                    "acid": "G"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "K"
                                },
                                {
                                    "position": "27",
                                    "acid": "D"
                                },
                                {
                                    "position": "28",
                                    "acid": "V"
                                },
                                {
                                    "position": "29",
                                    "acid": "F"
                                },
                                {
                                    "position": "30",
                                    "acid": "V"
                                },
                                {
                                    "position": "31",
                                    "acid": "H"
                                },
                                {
                                    "position": "32",
                                    "acid": "F"
                                },
                                {
                                    "position": "33",
                                    "acid": "S"
                                },
                                {
                                    "position": "34",
                                    "acid": "A"
                                },
                                {
                                    "position": "35",
                                    "acid": "I"
                                },
                                {
                                    "position": "36",
                                    "acid": "Q"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "N"
                                },
                                {
                                    "position": "39",
                                    "acid": "G"
                                },
                                {
                                    "position": "40",
                                    "acid": "F"
                                },
                                {
                                    "position": "41",
                                    "acid": "K"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "A"
                                },
                                {
                                    "position": "45",
                                    "acid": "E"
                                },
                                {
                                    "position": "46",
                                    "acid": "G"
                                },
                                {
                                    "position": "47",
                                    "acid": "Q"
                                },
                                {
                                    "position": "48",
                                    "acid": "R"
                                },
                                {
                                    "position": "49",
                                    "acid": "V"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "F"
                                },
                                {
                                    "position": "52",
                                    "acid": "E"
                                },
                                {
                                    "position": "53",
                                    "acid": "I"
                                },
                                {
                                    "position": "54",
                                    "acid": "T"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "G"
                                },
                                {
                                    "position": "57",
                                    "acid": "A"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "G"
                                },
                                {
                                    "position": "60",
                                    "acid": "P"
                                },
                                {
                                    "position": "61",
                                    "acid": "S"
                                },
                                {
                                    "position": "62",
                                    "acid": "A"
                                },
                                {
                                    "position": "63",
                                    "acid": "A"
                                },
                                {
                                    "position": "64",
                                    "acid": "N"
                                },
                                {
                                    "position": "65",
                                    "acid": "V"
                                },
                                {
                                    "position": "66",
                                    "acid": "I"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "L"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "68",
                                            "peak_id": "71",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "68",
                                            "peak_id": "32",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "68",
                                            "peak_id": "57",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "68",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "68",
                                            "peak_id": "29",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "68",
                                                "peak_id": "59",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "68",
                                                "peak_id": "14",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "68",
                                                "peak_id": "43",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "68",
                                                "peak_id": "25",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "68",
                                                "peak_id": "34",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "68",
                                                "peak_id": "4",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "68",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "68",
                                            "peak_id": "45",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "68",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "19",
                                                "ion_display_position": "19",
                                                "spec_id": "68",
                                                "peak_id": "39",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "19",
                                                "ion_display_position": "19",
                                                "spec_id": "68",
                                                "peak_id": "2",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "68",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "68",
                                                "peak_id": "26",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "20",
                                                "ion_display_position": "48",
                                                "spec_id": "68",
                                                "peak_id": "80",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "68",
                                            "peak_id": "95",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "23",
                                                "ion_display_position": "23",
                                                "spec_id": "68",
                                                "peak_id": "27",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "23",
                                                "ion_display_position": "23",
                                                "spec_id": "68",
                                                "peak_id": "115",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "27",
                                                "ion_display_position": "27",
                                                "spec_id": "68",
                                                "peak_id": "75",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "27",
                                                "ion_display_position": "27",
                                                "spec_id": "68",
                                                "peak_id": "68",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "68",
                                            "peak_id": "21",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "30",
                                                "ion_display_position": "30",
                                                "spec_id": "68",
                                                "peak_id": "52",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "30",
                                                "ion_display_position": "38",
                                                "spec_id": "68",
                                                "peak_id": "73",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "31",
                                                "ion_display_position": "31",
                                                "spec_id": "68",
                                                "peak_id": "89",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "31",
                                                "ion_display_position": "37",
                                                "spec_id": "68",
                                                "peak_id": "30",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "32",
                                            "ion_display_position": "36",
                                            "spec_id": "68",
                                            "peak_id": "37",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "68",
                                            "peak_id": "101",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "23",
                                            "spec_id": "68",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "53",
                                            "ion_display_position": "15",
                                            "spec_id": "68",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "55",
                                            "ion_display_position": "13",
                                            "spec_id": "68",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ]
                        }
                    }
                },
                {
                    "prsm_id": "58",
                    "p_value": "5.43e-08",
                    "e_value": "5.43e-08",
                    "fdr": "0",
                    "matched_fragment_number": "8",
                    "matched_peak_number": "8",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "537",
                            "ms1_scans": "651",
                            "ids": "113",
                            "scans": "652",
                            "precursor_mono_mass": "7327.7964",
                            "precursor_charge": "6",
                            "precursor_mz": "1222.3067",
                            "feature_inte": "1.0712e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_mass": "7327.7735",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "69",
                            "first_residue_position": "1",
                            "last_residue_position": "68",
                            "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "N"
                                },
                                {
                                    "position": "7",
                                    "acid": "V"
                                },
                                {
                                    "position": "8",
                                    "acid": "K"
                                },
                                {
                                    "position": "9",
                                    "acid": "W"
                                },
                                {
                                    "position": "10",
                                    "acid": "F"
                                },
                                {
                                    "position": "11",
                                    "acid": "N"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "K"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "F"
                                },
                                {
                                    "position": "17",
                                    "acid": "G"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "I"
                                },
                                {
                                    "position": "20",
                                    "acid": "T"
                                },
                                {
                                    "position": "21",
                                    "acid": "P"
                                },
                                {
                                    "position": "22",
                                    "acid": "E"
                                },
                                {
                                    "position": "23",
                                    "acid": "D"
                                },
                                {
                                    "position": "24",
                                    "acid": "G"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "K"
                                },
                                {
                                    "position": "27",
                                    "acid": "D"
                                },
                                {
                                    "position": "28",
                                    "acid": "V"
                                },
                                {
                                    "position": "29",
                                    "acid": "F"
                                },
                                {
                                    "position": "30",
                                    "acid": "V"
                                },
                                {
                                    "position": "31",
                                    "acid": "H"
                                },
                                {
                                    "position": "32",
                                    "acid": "F"
                                },
                                {
                                    "position": "33",
                                    "acid": "S"
                                },
                                {
                                    "position": "34",
                                    "acid": "A"
                                },
                                {
                                    "position": "35",
                                    "acid": "I"
                                },
                                {
                                    "position": "36",
                                    "acid": "Q"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "N"
                                },
                                {
                                    "position": "39",
                                    "acid": "G"
                                },
                                {
                                    "position": "40",
                                    "acid": "F"
                                },
                                {
                                    "position": "41",
                                    "acid": "K"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "A"
                                },
                                {
                                    "position": "45",
                                    "acid": "E"
                                },
                                {
                                    "position": "46",
                                    "acid": "G"
                                },
                                {
                                    "position": "47",
                                    "acid": "Q"
                                },
                                {
                                    "position": "48",
                                    "acid": "R"
                                },
                                {
                                    "position": "49",
                                    "acid": "V"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "F"
                                },
                                {
                                    "position": "52",
                                    "acid": "E"
                                },
                                {
                                    "position": "53",
                                    "acid": "I"
                                },
                                {
                                    "position": "54",
                                    "acid": "T"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "G"
                                },
                                {
                                    "position": "57",
                                    "acid": "A"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "G"
                                },
                                {
                                    "position": "60",
                                    "acid": "P"
                                },
                                {
                                    "position": "61",
                                    "acid": "S"
                                },
                                {
                                    "position": "62",
                                    "acid": "A"
                                },
                                {
                                    "position": "63",
                                    "acid": "A"
                                },
                                {
                                    "position": "64",
                                    "acid": "N"
                                },
                                {
                                    "position": "65",
                                    "acid": "V"
                                },
                                {
                                    "position": "66",
                                    "acid": "I"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "L"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "113",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "113",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "113",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "113",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "113",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "113",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "113",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "23",
                                            "ion_display_position": "23",
                                            "spec_id": "113",
                                            "peak_id": "38",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ]
                        }
                    }
                },
                {
                    "prsm_id": "41",
                    "p_value": "1.05e-07",
                    "e_value": "1.05e-07",
                    "fdr": "0",
                    "matched_fragment_number": "9",
                    "matched_peak_number": "10",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "526",
                            "ms1_scans": "607",
                            "ids": "81",
                            "scans": "609",
                            "precursor_mono_mass": "7327.7964",
                            "precursor_charge": "6",
                            "precursor_mz": "1222.3067",
                            "feature_inte": "1.0712e+08"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_mass": "7327.7735",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "69",
                            "first_residue_position": "1",
                            "last_residue_position": "68",
                            "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "N"
                                },
                                {
                                    "position": "7",
                                    "acid": "V"
                                },
                                {
                                    "position": "8",
                                    "acid": "K"
                                },
                                {
                                    "position": "9",
                                    "acid": "W"
                                },
                                {
                                    "position": "10",
                                    "acid": "F"
                                },
                                {
                                    "position": "11",
                                    "acid": "N"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "K"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "F"
                                },
                                {
                                    "position": "17",
                                    "acid": "G"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "I"
                                },
                                {
                                    "position": "20",
                                    "acid": "T"
                                },
                                {
                                    "position": "21",
                                    "acid": "P"
                                },
                                {
                                    "position": "22",
                                    "acid": "E"
                                },
                                {
                                    "position": "23",
                                    "acid": "D"
                                },
                                {
                                    "position": "24",
                                    "acid": "G"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "K"
                                },
                                {
                                    "position": "27",
                                    "acid": "D"
                                },
                                {
                                    "position": "28",
                                    "acid": "V"
                                },
                                {
                                    "position": "29",
                                    "acid": "F"
                                },
                                {
                                    "position": "30",
                                    "acid": "V"
                                },
                                {
                                    "position": "31",
                                    "acid": "H"
                                },
                                {
                                    "position": "32",
                                    "acid": "F"
                                },
                                {
                                    "position": "33",
                                    "acid": "S"
                                },
                                {
                                    "position": "34",
                                    "acid": "A"
                                },
                                {
                                    "position": "35",
                                    "acid": "I"
                                },
                                {
                                    "position": "36",
                                    "acid": "Q"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "N"
                                },
                                {
                                    "position": "39",
                                    "acid": "G"
                                },
                                {
                                    "position": "40",
                                    "acid": "F"
                                },
                                {
                                    "position": "41",
                                    "acid": "K"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "A"
                                },
                                {
                                    "position": "45",
                                    "acid": "E"
                                },
                                {
                                    "position": "46",
                                    "acid": "G"
                                },
                                {
                                    "position": "47",
                                    "acid": "Q"
                                },
                                {
                                    "position": "48",
                                    "acid": "R"
                                },
                                {
                                    "position": "49",
                                    "acid": "V"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "F"
                                },
                                {
                                    "position": "52",
                                    "acid": "E"
                                },
                                {
                                    "position": "53",
                                    "acid": "I"
                                },
                                {
                                    "position": "54",
                                    "acid": "T"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "G"
                                },
                                {
                                    "position": "57",
                                    "acid": "A"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "G"
                                },
                                {
                                    "position": "60",
                                    "acid": "P"
                                },
                                {
                                    "position": "61",
                                    "acid": "S"
                                },
                                {
                                    "position": "62",
                                    "acid": "A"
                                },
                                {
                                    "position": "63",
                                    "acid": "A"
                                },
                                {
                                    "position": "64",
                                    "acid": "N"
                                },
                                {
                                    "position": "65",
                                    "acid": "V"
                                },
                                {
                                    "position": "66",
                                    "acid": "I"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "L"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "81",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "81",
                                            "peak_id": "45",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "81",
                                            "peak_id": "38",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "81",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "81",
                                                "peak_id": "22",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "12",
                                                "ion_display_position": "12",
                                                "spec_id": "81",
                                                "peak_id": "19",
                                                "peak_charge": "1"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "81",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "81",
                                            "peak_id": "34",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "81",
                                            "peak_id": "39",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "81",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ]
                        }
                    }
                },
                {
                    "prsm_id": "130",
                    "p_value": "4.73e-07",
                    "e_value": "4.73e-07",
                    "fdr": "0",
                    "matched_fragment_number": "9",
                    "matched_peak_number": "9",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "608",
                            "ms1_scans": "935",
                            "ids": "327",
                            "scans": "937",
                            "precursor_mono_mass": "7327.7903",
                            "precursor_charge": "5",
                            "precursor_mz": "1466.5653",
                            "feature_inte": "1.9162e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "9",
                        "proteoform_id": "9",
                        "sequence_name": "sp|P0A972|CSPE_ECOLI",
                        "sequence_description": "Cold shock-like protein CspE OS=Escherichia coli (strain K12) OX=83333 GN=cspE PE=1 SV=2",
                        "proteoform_mass": "7327.7735",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "0",
                        "annotation": {
                            "protein_length": "69",
                            "first_residue_position": "1",
                            "last_residue_position": "68",
                            "annotated_seq": "M.SKIKGNVKWFNESKGFGFITPEDGSKDVFVHFSAIQTNGFKTLAEGQRVEFEITNGAKGPSAANVIAL.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "I"
                                },
                                {
                                    "position": "4",
                                    "acid": "K"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "N"
                                },
                                {
                                    "position": "7",
                                    "acid": "V"
                                },
                                {
                                    "position": "8",
                                    "acid": "K"
                                },
                                {
                                    "position": "9",
                                    "acid": "W"
                                },
                                {
                                    "position": "10",
                                    "acid": "F"
                                },
                                {
                                    "position": "11",
                                    "acid": "N"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "K"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "F"
                                },
                                {
                                    "position": "17",
                                    "acid": "G"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "I"
                                },
                                {
                                    "position": "20",
                                    "acid": "T"
                                },
                                {
                                    "position": "21",
                                    "acid": "P"
                                },
                                {
                                    "position": "22",
                                    "acid": "E"
                                },
                                {
                                    "position": "23",
                                    "acid": "D"
                                },
                                {
                                    "position": "24",
                                    "acid": "G"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "K"
                                },
                                {
                                    "position": "27",
                                    "acid": "D"
                                },
                                {
                                    "position": "28",
                                    "acid": "V"
                                },
                                {
                                    "position": "29",
                                    "acid": "F"
                                },
                                {
                                    "position": "30",
                                    "acid": "V"
                                },
                                {
                                    "position": "31",
                                    "acid": "H"
                                },
                                {
                                    "position": "32",
                                    "acid": "F"
                                },
                                {
                                    "position": "33",
                                    "acid": "S"
                                },
                                {
                                    "position": "34",
                                    "acid": "A"
                                },
                                {
                                    "position": "35",
                                    "acid": "I"
                                },
                                {
                                    "position": "36",
                                    "acid": "Q"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "N"
                                },
                                {
                                    "position": "39",
                                    "acid": "G"
                                },
                                {
                                    "position": "40",
                                    "acid": "F"
                                },
                                {
                                    "position": "41",
                                    "acid": "K"
                                },
                                {
                                    "position": "42",
                                    "acid": "T"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "A"
                                },
                                {
                                    "position": "45",
                                    "acid": "E"
                                },
                                {
                                    "position": "46",
                                    "acid": "G"
                                },
                                {
                                    "position": "47",
                                    "acid": "Q"
                                },
                                {
                                    "position": "48",
                                    "acid": "R"
                                },
                                {
                                    "position": "49",
                                    "acid": "V"
                                },
                                {
                                    "position": "50",
                                    "acid": "E"
                                },
                                {
                                    "position": "51",
                                    "acid": "F"
                                },
                                {
                                    "position": "52",
                                    "acid": "E"
                                },
                                {
                                    "position": "53",
                                    "acid": "I"
                                },
                                {
                                    "position": "54",
                                    "acid": "T"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "G"
                                },
                                {
                                    "position": "57",
                                    "acid": "A"
                                },
                                {
                                    "position": "58",
                                    "acid": "K"
                                },
                                {
                                    "position": "59",
                                    "acid": "G"
                                },
                                {
                                    "position": "60",
                                    "acid": "P"
                                },
                                {
                                    "position": "61",
                                    "acid": "S"
                                },
                                {
                                    "position": "62",
                                    "acid": "A"
                                },
                                {
                                    "position": "63",
                                    "acid": "A"
                                },
                                {
                                    "position": "64",
                                    "acid": "N"
                                },
                                {
                                    "position": "65",
                                    "acid": "V"
                                },
                                {
                                    "position": "66",
                                    "acid": "I"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "L"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "327",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "327",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "327",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "8",
                                                "ion_display_position": "60",
                                                "spec_id": "327",
                                                "peak_id": "32",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "327",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "327",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "327",
                                            "peak_id": "44",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "327",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "327",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ]
                        }
                    }
                }
            ]
        }
    }
}
