prsm_data =
{
    "protein": {
        "sequence_id": "26",
        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
        "compatible_proteoform_number": "4",
        "compatible_proteoform": [
            {
                "sequence_id": "26",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_id": "27",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "153",
                    "p_value": "7.90e-12",
                    "e_value": "7.90e-12",
                    "fdr": "0",
                    "matched_fragment_number": "19",
                    "matched_peak_number": "20",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "622",
                            "ms1_scans": "989",
                            "ids": "366",
                            "scans": "990",
                            "precursor_mono_mass": "10343.9422",
                            "precursor_charge": "6",
                            "precursor_mz": "1724.9976",
                            "feature_inte": "3.8654e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "26",
                        "proteoform_id": "27",
                        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                        "proteoform_mass": "10344.1472",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "110",
                            "first_residue_position": "21",
                            "last_residue_position": "109",
                            "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+495.2755]KQANFKDKVKGEWDKIKKDM.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "K"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "V"
                                },
                                {
                                    "position": "4",
                                    "acid": "L"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "I"
                                },
                                {
                                    "position": "8",
                                    "acid": "L"
                                },
                                {
                                    "position": "9",
                                    "acid": "G"
                                },
                                {
                                    "position": "10",
                                    "acid": "G"
                                },
                                {
                                    "position": "11",
                                    "acid": "L"
                                },
                                {
                                    "position": "12",
                                    "acid": "L"
                                },
                                {
                                    "position": "13",
                                    "acid": "L"
                                },
                                {
                                    "position": "14",
                                    "acid": "L"
                                },
                                {
                                    "position": "15",
                                    "acid": "P"
                                },
                                {
                                    "position": "16",
                                    "acid": "V"
                                },
                                {
                                    "position": "17",
                                    "acid": "V"
                                },
                                {
                                    "position": "18",
                                    "acid": "S"
                                },
                                {
                                    "position": "19",
                                    "acid": "N"
                                },
                                {
                                    "position": "20",
                                    "acid": "A"
                                },
                                {
                                    "position": "21",
                                    "acid": "A"
                                },
                                {
                                    "position": "22",
                                    "acid": "D"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "K"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "D"
                                },
                                {
                                    "position": "29",
                                    "acid": "N"
                                },
                                {
                                    "position": "30",
                                    "acid": "K"
                                },
                                {
                                    "position": "31",
                                    "acid": "K"
                                },
                                {
                                    "position": "32",
                                    "acid": "P"
                                },
                                {
                                    "position": "33",
                                    "acid": "V"
                                },
                                {
                                    "position": "34",
                                    "acid": "N"
                                },
                                {
                                    "position": "35",
                                    "acid": "S"
                                },
                                {
                                    "position": "36",
                                    "acid": "W"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "E"
                                },
                                {
                                    "position": "40",
                                    "acid": "D"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "L"
                                },
                                {
                                    "position": "43",
                                    "acid": "A"
                                },
                                {
                                    "position": "44",
                                    "acid": "V"
                                },
                                {
                                    "position": "45",
                                    "acid": "D"
                                },
                                {
                                    "position": "46",
                                    "acid": "E"
                                },
                                {
                                    "position": "47",
                                    "acid": "S"
                                },
                                {
                                    "position": "48",
                                    "acid": "F"
                                },
                                {
                                    "position": "49",
                                    "acid": "Q"
                                },
                                {
                                    "position": "50",
                                    "acid": "P"
                                },
                                {
                                    "position": "51",
                                    "acid": "T"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "V"
                                },
                                {
                                    "position": "54",
                                    "acid": "G"
                                },
                                {
                                    "position": "55",
                                    "acid": "F"
                                },
                                {
                                    "position": "56",
                                    "acid": "A"
                                },
                                {
                                    "position": "57",
                                    "acid": "E"
                                },
                                {
                                    "position": "58",
                                    "acid": "A"
                                },
                                {
                                    "position": "59",
                                    "acid": "L"
                                },
                                {
                                    "position": "60",
                                    "acid": "N"
                                },
                                {
                                    "position": "61",
                                    "acid": "N"
                                },
                                {
                                    "position": "62",
                                    "acid": "K"
                                },
                                {
                                    "position": "63",
                                    "acid": "D"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "P"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "A"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "L"
                                },
                                {
                                    "position": "71",
                                    "acid": "D"
                                },
                                {
                                    "position": "72",
                                    "acid": "V"
                                },
                                {
                                    "position": "73",
                                    "acid": "Q"
                                },
                                {
                                    "position": "74",
                                    "acid": "G"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "A"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "V"
                                },
                                {
                                    "position": "79",
                                    "acid": "T"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "A"
                                },
                                {
                                    "position": "82",
                                    "acid": "I"
                                },
                                {
                                    "position": "83",
                                    "acid": "V"
                                },
                                {
                                    "position": "84",
                                    "acid": "Q"
                                },
                                {
                                    "position": "85",
                                    "acid": "A"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "T"
                                },
                                {
                                    "position": "88",
                                    "acid": "Q"
                                },
                                {
                                    "position": "89",
                                    "acid": "D"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "A"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "F"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "K"
                                },
                                {
                                    "position": "98",
                                    "acid": "V"
                                },
                                {
                                    "position": "99",
                                    "acid": "K"
                                },
                                {
                                    "position": "100",
                                    "acid": "G"
                                },
                                {
                                    "position": "101",
                                    "acid": "E"
                                },
                                {
                                    "position": "102",
                                    "acid": "W"
                                },
                                {
                                    "position": "103",
                                    "acid": "D"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "K"
                                },
                                {
                                    "position": "107",
                                    "acid": "K"
                                },
                                {
                                    "position": "108",
                                    "acid": "D"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "366",
                                            "peak_id": "41",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "366",
                                            "peak_id": "37",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "366",
                                            "peak_id": "24",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "366",
                                            "peak_id": "38",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "366",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "366",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "366",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "366",
                                            "peak_id": "27",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "366",
                                            "peak_id": "72",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "69",
                                                "ion_display_position": "20",
                                                "spec_id": "366",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "69",
                                                "ion_display_position": "20",
                                                "spec_id": "366",
                                                "peak_id": "88",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "71",
                                            "ion_display_position": "18",
                                            "spec_id": "366",
                                            "peak_id": "73",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "72",
                                            "ion_display_position": "17",
                                            "spec_id": "366",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "75",
                                            "ion_display_position": "14",
                                            "spec_id": "366",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "13",
                                            "spec_id": "366",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "77",
                                            "ion_display_position": "12",
                                            "spec_id": "366",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "78",
                                            "ion_display_position": "11",
                                            "spec_id": "366",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "79",
                                            "ion_display_position": "10",
                                            "spec_id": "366",
                                            "peak_id": "21",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "8",
                                            "spec_id": "366",
                                            "peak_id": "42",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "85",
                                            "ion_display_position": "4",
                                            "spec_id": "366",
                                            "peak_id": "57",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "38",
                                "right_position": "90",
                                "shift": "495.2754835793",
                                "anno": "+495.2755",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            },
            {
                "sequence_id": "26",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_id": "31",
                "prsm_number": "2",
                "prsm": [
                    {
                        "prsm_id": "140",
                        "p_value": "4.08e-10",
                        "e_value": "4.08e-10",
                        "fdr": "0",
                        "matched_fragment_number": "14",
                        "matched_peak_number": "14",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "614",
                                "ms1_scans": "957",
                                "ids": "344",
                                "scans": "960",
                                "precursor_mono_mass": "10171.8929",
                                "precursor_charge": "6",
                                "precursor_mz": "1696.3228",
                                "feature_inte": "5.5224e+06"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "26",
                            "proteoform_id": "31",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10172.0929",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+323.2212]KQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "344",
                                                "peak_id": "13",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "344",
                                                "peak_id": "21",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "344",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "344",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "344",
                                                "peak_id": "9",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "344",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "344",
                                                "peak_id": "20",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "69",
                                                "ion_display_position": "20",
                                                "spec_id": "344",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "344",
                                                "peak_id": "8",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "344",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "344",
                                                "peak_id": "2",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "344",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "344",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "344",
                                                "peak_id": "23",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "34",
                                    "right_position": "90",
                                    "shift": "323.2212035793",
                                    "anno": "+323.2212",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "154",
                        "p_value": "3.41e-06",
                        "e_value": "3.41e-06",
                        "fdr": "0",
                        "matched_fragment_number": "13",
                        "matched_peak_number": "14",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "623",
                                "ms1_scans": "993",
                                "ids": "369",
                                "scans": "994",
                                "precursor_mono_mass": "10172.9631",
                                "precursor_charge": "8",
                                "precursor_mz": "1272.6277",
                                "feature_inte": "5.7741e+06"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "26",
                            "proteoform_id": "31",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10173.1632",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSW(T(C)[Carbamidomethylation]EDFLAV)[+324.2915]DESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "369",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "369",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "369",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "369",
                                                    "peak_id": "20",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "369",
                                                    "peak_id": "6",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "369",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "369",
                                                "peak_id": "24",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "24",
                                                "ion_display_position": "65",
                                                "spec_id": "369",
                                                "peak_id": "55",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "69",
                                                "ion_display_position": "20",
                                                "spec_id": "369",
                                                "peak_id": "17",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "369",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "369",
                                                "peak_id": "4",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "369",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "369",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "369",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "37",
                                    "right_position": "45",
                                    "shift": "324.2914535793",
                                    "anno": "+324.2915",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    }
                ]
            },
            {
                "sequence_id": "26",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_id": "37",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "151",
                    "p_value": "8.46e-06",
                    "e_value": "8.46e-06",
                    "fdr": "0",
                    "matched_fragment_number": "12",
                    "matched_peak_number": "12",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "620",
                            "ms1_scans": "981",
                            "ids": "362",
                            "scans": "984",
                            "precursor_mono_mass": "10316.0127",
                            "precursor_charge": "6",
                            "precursor_mz": "1720.3427",
                            "feature_inte": "3.7648e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "26",
                        "proteoform_id": "37",
                        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                        "proteoform_mass": "10316.2177",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "110",
                            "first_residue_position": "21",
                            "last_residue_position": "109",
                            "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+467.3460]KQANFKDKVKGEWDKIKKDM.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "K"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "V"
                                },
                                {
                                    "position": "4",
                                    "acid": "L"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "I"
                                },
                                {
                                    "position": "8",
                                    "acid": "L"
                                },
                                {
                                    "position": "9",
                                    "acid": "G"
                                },
                                {
                                    "position": "10",
                                    "acid": "G"
                                },
                                {
                                    "position": "11",
                                    "acid": "L"
                                },
                                {
                                    "position": "12",
                                    "acid": "L"
                                },
                                {
                                    "position": "13",
                                    "acid": "L"
                                },
                                {
                                    "position": "14",
                                    "acid": "L"
                                },
                                {
                                    "position": "15",
                                    "acid": "P"
                                },
                                {
                                    "position": "16",
                                    "acid": "V"
                                },
                                {
                                    "position": "17",
                                    "acid": "V"
                                },
                                {
                                    "position": "18",
                                    "acid": "S"
                                },
                                {
                                    "position": "19",
                                    "acid": "N"
                                },
                                {
                                    "position": "20",
                                    "acid": "A"
                                },
                                {
                                    "position": "21",
                                    "acid": "A"
                                },
                                {
                                    "position": "22",
                                    "acid": "D"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "K"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "D"
                                },
                                {
                                    "position": "29",
                                    "acid": "N"
                                },
                                {
                                    "position": "30",
                                    "acid": "K"
                                },
                                {
                                    "position": "31",
                                    "acid": "K"
                                },
                                {
                                    "position": "32",
                                    "acid": "P"
                                },
                                {
                                    "position": "33",
                                    "acid": "V"
                                },
                                {
                                    "position": "34",
                                    "acid": "N"
                                },
                                {
                                    "position": "35",
                                    "acid": "S"
                                },
                                {
                                    "position": "36",
                                    "acid": "W"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "E"
                                },
                                {
                                    "position": "40",
                                    "acid": "D"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "L"
                                },
                                {
                                    "position": "43",
                                    "acid": "A"
                                },
                                {
                                    "position": "44",
                                    "acid": "V"
                                },
                                {
                                    "position": "45",
                                    "acid": "D"
                                },
                                {
                                    "position": "46",
                                    "acid": "E"
                                },
                                {
                                    "position": "47",
                                    "acid": "S"
                                },
                                {
                                    "position": "48",
                                    "acid": "F"
                                },
                                {
                                    "position": "49",
                                    "acid": "Q"
                                },
                                {
                                    "position": "50",
                                    "acid": "P"
                                },
                                {
                                    "position": "51",
                                    "acid": "T"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "V"
                                },
                                {
                                    "position": "54",
                                    "acid": "G"
                                },
                                {
                                    "position": "55",
                                    "acid": "F"
                                },
                                {
                                    "position": "56",
                                    "acid": "A"
                                },
                                {
                                    "position": "57",
                                    "acid": "E"
                                },
                                {
                                    "position": "58",
                                    "acid": "A"
                                },
                                {
                                    "position": "59",
                                    "acid": "L"
                                },
                                {
                                    "position": "60",
                                    "acid": "N"
                                },
                                {
                                    "position": "61",
                                    "acid": "N"
                                },
                                {
                                    "position": "62",
                                    "acid": "K"
                                },
                                {
                                    "position": "63",
                                    "acid": "D"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "P"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "A"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "L"
                                },
                                {
                                    "position": "71",
                                    "acid": "D"
                                },
                                {
                                    "position": "72",
                                    "acid": "V"
                                },
                                {
                                    "position": "73",
                                    "acid": "Q"
                                },
                                {
                                    "position": "74",
                                    "acid": "G"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "A"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "V"
                                },
                                {
                                    "position": "79",
                                    "acid": "T"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "A"
                                },
                                {
                                    "position": "82",
                                    "acid": "I"
                                },
                                {
                                    "position": "83",
                                    "acid": "V"
                                },
                                {
                                    "position": "84",
                                    "acid": "Q"
                                },
                                {
                                    "position": "85",
                                    "acid": "A"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "T"
                                },
                                {
                                    "position": "88",
                                    "acid": "Q"
                                },
                                {
                                    "position": "89",
                                    "acid": "D"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "A"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "F"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "K"
                                },
                                {
                                    "position": "98",
                                    "acid": "V"
                                },
                                {
                                    "position": "99",
                                    "acid": "K"
                                },
                                {
                                    "position": "100",
                                    "acid": "G"
                                },
                                {
                                    "position": "101",
                                    "acid": "E"
                                },
                                {
                                    "position": "102",
                                    "acid": "W"
                                },
                                {
                                    "position": "103",
                                    "acid": "D"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "K"
                                },
                                {
                                    "position": "107",
                                    "acid": "K"
                                },
                                {
                                    "position": "108",
                                    "acid": "D"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "5",
                                            "ion_display_position": "5",
                                            "spec_id": "362",
                                            "peak_id": "40",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "362",
                                            "peak_id": "16",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "362",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "362",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "362",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "362",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "362",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "362",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "13",
                                            "spec_id": "362",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "78",
                                            "ion_display_position": "11",
                                            "spec_id": "362",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "79",
                                            "ion_display_position": "10",
                                            "spec_id": "362",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "8",
                                            "spec_id": "362",
                                            "peak_id": "23",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "34",
                                "right_position": "90",
                                "shift": "467.3459635793",
                                "anno": "+467.3460",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            },
            {
                "sequence_id": "26",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_id": "42",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "115",
                    "p_value": "1.33e-03",
                    "e_value": "1.33e-03",
                    "fdr": "0",
                    "matched_fragment_number": "10",
                    "matched_peak_number": "10",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "600",
                            "ms1_scans": "903",
                            "ids": "304",
                            "scans": "906",
                            "precursor_mono_mass": "10472.1090",
                            "precursor_charge": "6",
                            "precursor_mz": "1746.3588",
                            "feature_inte": "7.8845e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "26",
                        "proteoform_id": "42",
                        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                        "proteoform_mass": "10472.3140",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "110",
                            "first_residue_position": "16",
                            "last_residue_position": "109",
                            "annotated_seq": "P.VVSNAADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+153.1934]KQANFKDKVKGEWDKIKKDM.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "K"
                                },
                                {
                                    "position": "2",
                                    "acid": "K"
                                },
                                {
                                    "position": "3",
                                    "acid": "V"
                                },
                                {
                                    "position": "4",
                                    "acid": "L"
                                },
                                {
                                    "position": "5",
                                    "acid": "G"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "I"
                                },
                                {
                                    "position": "8",
                                    "acid": "L"
                                },
                                {
                                    "position": "9",
                                    "acid": "G"
                                },
                                {
                                    "position": "10",
                                    "acid": "G"
                                },
                                {
                                    "position": "11",
                                    "acid": "L"
                                },
                                {
                                    "position": "12",
                                    "acid": "L"
                                },
                                {
                                    "position": "13",
                                    "acid": "L"
                                },
                                {
                                    "position": "14",
                                    "acid": "L"
                                },
                                {
                                    "position": "15",
                                    "acid": "P"
                                },
                                {
                                    "position": "16",
                                    "acid": "V"
                                },
                                {
                                    "position": "17",
                                    "acid": "V"
                                },
                                {
                                    "position": "18",
                                    "acid": "S"
                                },
                                {
                                    "position": "19",
                                    "acid": "N"
                                },
                                {
                                    "position": "20",
                                    "acid": "A"
                                },
                                {
                                    "position": "21",
                                    "acid": "A"
                                },
                                {
                                    "position": "22",
                                    "acid": "D"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "K"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "D"
                                },
                                {
                                    "position": "29",
                                    "acid": "N"
                                },
                                {
                                    "position": "30",
                                    "acid": "K"
                                },
                                {
                                    "position": "31",
                                    "acid": "K"
                                },
                                {
                                    "position": "32",
                                    "acid": "P"
                                },
                                {
                                    "position": "33",
                                    "acid": "V"
                                },
                                {
                                    "position": "34",
                                    "acid": "N"
                                },
                                {
                                    "position": "35",
                                    "acid": "S"
                                },
                                {
                                    "position": "36",
                                    "acid": "W"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "E"
                                },
                                {
                                    "position": "40",
                                    "acid": "D"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "L"
                                },
                                {
                                    "position": "43",
                                    "acid": "A"
                                },
                                {
                                    "position": "44",
                                    "acid": "V"
                                },
                                {
                                    "position": "45",
                                    "acid": "D"
                                },
                                {
                                    "position": "46",
                                    "acid": "E"
                                },
                                {
                                    "position": "47",
                                    "acid": "S"
                                },
                                {
                                    "position": "48",
                                    "acid": "F"
                                },
                                {
                                    "position": "49",
                                    "acid": "Q"
                                },
                                {
                                    "position": "50",
                                    "acid": "P"
                                },
                                {
                                    "position": "51",
                                    "acid": "T"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "V"
                                },
                                {
                                    "position": "54",
                                    "acid": "G"
                                },
                                {
                                    "position": "55",
                                    "acid": "F"
                                },
                                {
                                    "position": "56",
                                    "acid": "A"
                                },
                                {
                                    "position": "57",
                                    "acid": "E"
                                },
                                {
                                    "position": "58",
                                    "acid": "A"
                                },
                                {
                                    "position": "59",
                                    "acid": "L"
                                },
                                {
                                    "position": "60",
                                    "acid": "N"
                                },
                                {
                                    "position": "61",
                                    "acid": "N"
                                },
                                {
                                    "position": "62",
                                    "acid": "K"
                                },
                                {
                                    "position": "63",
                                    "acid": "D"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "P"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "A"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "L"
                                },
                                {
                                    "position": "71",
                                    "acid": "D"
                                },
                                {
                                    "position": "72",
                                    "acid": "V"
                                },
                                {
                                    "position": "73",
                                    "acid": "Q"
                                },
                                {
                                    "position": "74",
                                    "acid": "G"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "A"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "V"
                                },
                                {
                                    "position": "79",
                                    "acid": "T"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "A"
                                },
                                {
                                    "position": "82",
                                    "acid": "I"
                                },
                                {
                                    "position": "83",
                                    "acid": "V"
                                },
                                {
                                    "position": "84",
                                    "acid": "Q"
                                },
                                {
                                    "position": "85",
                                    "acid": "A"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "T"
                                },
                                {
                                    "position": "88",
                                    "acid": "Q"
                                },
                                {
                                    "position": "89",
                                    "acid": "D"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "A"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "F"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "K"
                                },
                                {
                                    "position": "98",
                                    "acid": "V"
                                },
                                {
                                    "position": "99",
                                    "acid": "K"
                                },
                                {
                                    "position": "100",
                                    "acid": "G"
                                },
                                {
                                    "position": "101",
                                    "acid": "E"
                                },
                                {
                                    "position": "102",
                                    "acid": "W"
                                },
                                {
                                    "position": "103",
                                    "acid": "D"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "K"
                                },
                                {
                                    "position": "107",
                                    "acid": "K"
                                },
                                {
                                    "position": "108",
                                    "acid": "D"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "304",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "74",
                                            "ion_display_position": "20",
                                            "spec_id": "304",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "14",
                                            "spec_id": "304",
                                            "peak_id": "23",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "13",
                                            "spec_id": "304",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "82",
                                            "ion_display_position": "12",
                                            "spec_id": "304",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "83",
                                            "ion_display_position": "11",
                                            "spec_id": "304",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "10",
                                            "spec_id": "304",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "86",
                                            "ion_display_position": "8",
                                            "spec_id": "304",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "88",
                                            "ion_display_position": "6",
                                            "spec_id": "304",
                                            "peak_id": "7",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "4",
                                            "spec_id": "304",
                                            "peak_id": "18",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "38",
                                "right_position": "90",
                                "shift": "153.1934261235",
                                "anno": "+153.1934",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            }
        ]
    }
}
