prsm_data =
{
    "protein": {
        "sequence_id": "15",
        "sequence_name": "sp|P37903|USPF_ECOLI",
        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
        "compatible_proteoform_number": "2",
        "compatible_proteoform": [
            {
                "sequence_id": "15",
                "sequence_name": "sp|P37903|USPF_ECOLI",
                "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                "proteoform_id": "15",
                "prsm_number": "4",
                "prsm": [
                    {
                        "prsm_id": "143",
                        "p_value": "1.26e-20",
                        "e_value": "1.26e-20",
                        "fdr": "0",
                        "matched_fragment_number": "34",
                        "matched_peak_number": "38",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "616",
                                "ms1_scans": "965",
                                "ids": "348",
                                "scans": "966",
                                "precursor_mono_mass": "16311.5225",
                                "precursor_charge": "8",
                                "precursor_mz": "2039.9476",
                                "feature_inte": "2.8032e+07"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "15",
                            "proteoform_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_mass": "16311.6175",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "144",
                                "first_residue_position": "0",
                                "last_residue_position": "143",
                                "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0818].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "110",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "111",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "112",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "113",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "114",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "115",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "116",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "117",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "118",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "119",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "120",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "121",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "122",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "123",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "124",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "125",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "126",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "127",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "128",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "129",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "130",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "131",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "132",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "133",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "134",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "135",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "136",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "137",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "138",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "139",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "140",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "141",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "142",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "143",
                                        "acid": "R"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "348",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "348",
                                                "peak_id": "4",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "348",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "21",
                                                "ion_display_position": "21",
                                                "spec_id": "348",
                                                "peak_id": "15",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "25",
                                                "ion_display_position": "25",
                                                "spec_id": "348",
                                                "peak_id": "30",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "26",
                                                "ion_display_position": "26",
                                                "spec_id": "348",
                                                "peak_id": "21",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "29",
                                                "ion_display_position": "29",
                                                "spec_id": "348",
                                                "peak_id": "51",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "30",
                                                "ion_display_position": "30",
                                                "spec_id": "348",
                                                "peak_id": "54",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "31",
                                                "ion_display_position": "31",
                                                "spec_id": "348",
                                                "peak_id": "2",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "32",
                                                "ion_display_position": "32",
                                                "spec_id": "348",
                                                "peak_id": "3",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "34",
                                                "ion_display_position": "34",
                                                "spec_id": "348",
                                                "peak_id": "9",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "36",
                                                "ion_display_position": "36",
                                                "spec_id": "348",
                                                "peak_id": "12",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "37",
                                                    "ion_display_position": "37",
                                                    "spec_id": "348",
                                                    "peak_id": "25",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "37",
                                                    "ion_display_position": "37",
                                                    "spec_id": "348",
                                                    "peak_id": "118",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "38",
                                                "ion_display_position": "38",
                                                "spec_id": "348",
                                                "peak_id": "50",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "39",
                                                "ion_display_position": "39",
                                                "spec_id": "348",
                                                "peak_id": "41",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "40",
                                                "ion_display_position": "40",
                                                "spec_id": "348",
                                                "peak_id": "14",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "41",
                                                    "ion_display_position": "41",
                                                    "spec_id": "348",
                                                    "peak_id": "104",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "41",
                                                    "ion_display_position": "41",
                                                    "spec_id": "348",
                                                    "peak_id": "38",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "41",
                                                    "ion_display_position": "103",
                                                    "spec_id": "348",
                                                    "peak_id": "137",
                                                    "peak_charge": "5"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "44",
                                                "ion_display_position": "44",
                                                "spec_id": "348",
                                                "peak_id": "94",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "57",
                                                "ion_display_position": "87",
                                                "spec_id": "348",
                                                "peak_id": "98",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "58",
                                                "ion_display_position": "86",
                                                "spec_id": "348",
                                                "peak_id": "123",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "62",
                                                "ion_display_position": "82",
                                                "spec_id": "348",
                                                "peak_id": "89",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "63",
                                                "ion_display_position": "81",
                                                "spec_id": "348",
                                                "peak_id": "40",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "64",
                                                "ion_display_position": "80",
                                                "spec_id": "348",
                                                "peak_id": "81",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "65",
                                                "ion_display_position": "79",
                                                "spec_id": "348",
                                                "peak_id": "71",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "67",
                                                "ion_display_position": "77",
                                                "spec_id": "348",
                                                "peak_id": "29",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "71",
                                                "spec_id": "348",
                                                "peak_id": "84",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "84",
                                                    "ion_display_position": "60",
                                                    "spec_id": "348",
                                                    "peak_id": "65",
                                                    "peak_charge": "4"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "84",
                                                    "ion_display_position": "60",
                                                    "spec_id": "348",
                                                    "peak_id": "34",
                                                    "peak_charge": "5"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "88",
                                                "ion_display_position": "56",
                                                "spec_id": "348",
                                                "peak_id": "109",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "92",
                                                "ion_display_position": "52",
                                                "spec_id": "348",
                                                "peak_id": "7",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "97",
                                                    "ion_display_position": "47",
                                                    "spec_id": "348",
                                                    "peak_id": "8",
                                                    "peak_charge": "4"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "97",
                                                    "ion_display_position": "47",
                                                    "spec_id": "348",
                                                    "peak_id": "132",
                                                    "peak_charge": "3"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "105",
                                                "ion_display_position": "39",
                                                "spec_id": "348",
                                                "peak_id": "55",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "111",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "112",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "113",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "114",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "115",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "116",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "117",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "117",
                                                "ion_display_position": "27",
                                                "spec_id": "348",
                                                "peak_id": "5",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "118",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "119",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "119",
                                                "ion_display_position": "25",
                                                "spec_id": "348",
                                                "peak_id": "20",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "120",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "121",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "122",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "123",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "124",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "125",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "126",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "127",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "128",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "129",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "130",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "131",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "132",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "133",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "134",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "135",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "136",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "137",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "138",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "139",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "140",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "141",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "142",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "143",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "144",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "137",
                                        "right_pos": "138",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "119",
                                    "right_position": "144",
                                    "shift": "248.0818363914",
                                    "anno": "+248.0818",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "124",
                        "p_value": "2.70e-13",
                        "e_value": "2.70e-13",
                        "fdr": "0",
                        "matched_fragment_number": "16",
                        "matched_peak_number": "17",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "605",
                                "ms1_scans": "923",
                                "ids": "318",
                                "scans": "925",
                                "precursor_mono_mass": "16311.5225",
                                "precursor_charge": "8",
                                "precursor_mz": "2039.9476",
                                "feature_inte": "2.8032e+07"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "15",
                            "proteoform_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_mass": "16311.6075",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "144",
                                "first_residue_position": "0",
                                "last_residue_position": "143",
                                "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0718].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "110",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "111",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "112",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "113",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "114",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "115",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "116",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "117",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "118",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "119",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "120",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "121",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "122",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "123",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "124",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "125",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "126",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "127",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "128",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "129",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "130",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "131",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "132",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "133",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "134",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "135",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "136",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "137",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "138",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "139",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "140",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "141",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "142",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "143",
                                        "acid": "R"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "318",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "318",
                                                "peak_id": "2",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "318",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "318",
                                                "peak_id": "4",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "32",
                                                "ion_display_position": "32",
                                                "spec_id": "318",
                                                "peak_id": "6",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "34",
                                                "ion_display_position": "34",
                                                "spec_id": "318",
                                                "peak_id": "13",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "37",
                                                "ion_display_position": "37",
                                                "spec_id": "318",
                                                "peak_id": "25",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "38",
                                                "ion_display_position": "38",
                                                "spec_id": "318",
                                                "peak_id": "24",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "40",
                                                "ion_display_position": "40",
                                                "spec_id": "318",
                                                "peak_id": "20",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "41",
                                                    "ion_display_position": "41",
                                                    "spec_id": "318",
                                                    "peak_id": "15",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "41",
                                                    "ion_display_position": "41",
                                                    "spec_id": "318",
                                                    "peak_id": "18",
                                                    "peak_charge": "3"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "58",
                                                "ion_display_position": "86",
                                                "spec_id": "318",
                                                "peak_id": "37",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "63",
                                                "ion_display_position": "81",
                                                "spec_id": "318",
                                                "peak_id": "27",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "92",
                                                "ion_display_position": "52",
                                                "spec_id": "318",
                                                "peak_id": "5",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "97",
                                                "ion_display_position": "47",
                                                "spec_id": "318",
                                                "peak_id": "3",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "111",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "112",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "113",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "114",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "115",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "116",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "117",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "117",
                                                "ion_display_position": "27",
                                                "spec_id": "318",
                                                "peak_id": "12",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "118",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "119",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "119",
                                                "ion_display_position": "25",
                                                "spec_id": "318",
                                                "peak_id": "8",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "120",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "121",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "122",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "123",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "124",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "125",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "126",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "127",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "128",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "129",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "130",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "131",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "132",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "133",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "134",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "135",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "136",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "137",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "138",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "139",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "140",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "141",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "142",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "143",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "144",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "137",
                                        "right_pos": "138",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "119",
                                    "right_position": "144",
                                    "shift": "248.0718363914",
                                    "anno": "+248.0718",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "145",
                        "p_value": "2.62e-11",
                        "e_value": "2.62e-11",
                        "fdr": "0",
                        "matched_fragment_number": "15",
                        "matched_peak_number": "16",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "617",
                                "ms1_scans": "969",
                                "ids": "351",
                                "scans": "970",
                                "precursor_mono_mass": "16311.5225",
                                "precursor_charge": "7",
                                "precursor_mz": "2331.2248",
                                "feature_inte": "2.8032e+07"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "15",
                            "proteoform_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_mass": "16311.6125",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "144",
                                "first_residue_position": "0",
                                "last_residue_position": "143",
                                "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0768].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "110",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "111",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "112",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "113",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "114",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "115",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "116",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "117",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "118",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "119",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "120",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "121",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "122",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "123",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "124",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "125",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "126",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "127",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "128",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "129",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "130",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "131",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "132",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "133",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "134",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "135",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "136",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "137",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "138",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "139",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "140",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "141",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "142",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "143",
                                        "acid": "R"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "351",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "351",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "351",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "351",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "351",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "25",
                                                "ion_display_position": "25",
                                                "spec_id": "351",
                                                "peak_id": "15",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "27",
                                                "ion_display_position": "27",
                                                "spec_id": "351",
                                                "peak_id": "19",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "29",
                                                "ion_display_position": "29",
                                                "spec_id": "351",
                                                "peak_id": "35",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "31",
                                                "ion_display_position": "31",
                                                "spec_id": "351",
                                                "peak_id": "9",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "32",
                                                "ion_display_position": "32",
                                                "spec_id": "351",
                                                "peak_id": "6",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "38",
                                                "ion_display_position": "38",
                                                "spec_id": "351",
                                                "peak_id": "37",
                                                "peak_charge": "3"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "92",
                                                "ion_display_position": "52",
                                                "spec_id": "351",
                                                "peak_id": "10",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "97",
                                                    "ion_display_position": "47",
                                                    "spec_id": "351",
                                                    "peak_id": "49",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "97",
                                                    "ion_display_position": "47",
                                                    "spec_id": "351",
                                                    "peak_id": "14",
                                                    "peak_charge": "4"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "111",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "112",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "113",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "114",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "115",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "116",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "117",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "117",
                                                "ion_display_position": "27",
                                                "spec_id": "351",
                                                "peak_id": "8",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "118",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "119",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "119",
                                                "ion_display_position": "25",
                                                "spec_id": "351",
                                                "peak_id": "13",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "120",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "121",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "122",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "123",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "124",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "125",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "126",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "127",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "128",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "129",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "130",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "131",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "132",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "133",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "134",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "135",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "136",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "137",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "138",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "139",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "140",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "141",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "142",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "143",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "144",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "137",
                                        "right_pos": "138",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "119",
                                    "right_position": "144",
                                    "shift": "248.0768463914",
                                    "anno": "+248.0768",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "127",
                        "p_value": "3.32e-10",
                        "e_value": "3.32e-10",
                        "fdr": "0",
                        "matched_fragment_number": "9",
                        "matched_peak_number": "9",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                                "ms1_ids": "606",
                                "ms1_scans": "927",
                                "ids": "322",
                                "scans": "930",
                                "precursor_mono_mass": "16311.5225",
                                "precursor_charge": "7",
                                "precursor_mz": "2331.2248",
                                "feature_inte": "2.8032e+07"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "15",
                            "proteoform_id": "15",
                            "sequence_name": "sp|P37903|USPF_ECOLI",
                            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                            "proteoform_mass": "16310.6052",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "144",
                                "first_residue_position": "0",
                                "last_residue_position": "143",
                                "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+247.0695].",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "110",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "111",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "112",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "113",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "114",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "115",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "116",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "117",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "118",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "119",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "120",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "121",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "122",
                                        "acid": "Y"
                                    },
                                    {
                                        "position": "123",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "124",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "125",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "126",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "127",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "128",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "129",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "130",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "131",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "132",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "133",
                                        "acid": "R"
                                    },
                                    {
                                        "position": "134",
                                        "acid": "H"
                                    },
                                    {
                                        "position": "135",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "136",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "137",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "138",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "139",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "140",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "141",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "142",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "143",
                                        "acid": "R"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "322",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "322",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "20",
                                                "ion_display_position": "20",
                                                "spec_id": "322",
                                                "peak_id": "5",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "31",
                                                "ion_display_position": "31",
                                                "spec_id": "322",
                                                "peak_id": "2",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "32",
                                                "ion_display_position": "32",
                                                "spec_id": "322",
                                                "peak_id": "4",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "322",
                                                "peak_id": "15",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "63",
                                                "ion_display_position": "81",
                                                "spec_id": "322",
                                                "peak_id": "13",
                                                "peak_charge": "5"
                                            }
                                        }
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "97",
                                                "ion_display_position": "47",
                                                "spec_id": "322",
                                                "peak_id": "8",
                                                "peak_charge": "4"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "111",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "112",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "113",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "114",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "115",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "116",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "117",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "118",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "119",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "119",
                                                "ion_display_position": "25",
                                                "spec_id": "322",
                                                "peak_id": "12",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "120",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "121",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "122",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "123",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "124",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "125",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "126",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "127",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "128",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "129",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "130",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "131",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "132",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "133",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "134",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "135",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "136",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "137",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "138",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "139",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "140",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "141",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "142",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "143",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "144",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "137",
                                        "right_pos": "138",
                                        "anno": "C"
                                    }
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "119",
                                    "right_position": "144",
                                    "shift": "247.0694963914",
                                    "anno": "+247.0695",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    }
                ]
            },
            {
                "sequence_id": "15",
                "sequence_name": "sp|P37903|USPF_ECOLI",
                "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                "proteoform_id": "47",
                "prsm_number": "1",
                "prsm": {
                    "prsm_id": "142",
                    "p_value": "0.25",
                    "e_value": "0.29",
                    "fdr": "0",
                    "matched_fragment_number": "7",
                    "matched_peak_number": "7",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_2_ms2.msalign",
                            "ms1_ids": "615",
                            "ms1_scans": "961",
                            "ids": "346",
                            "scans": "963",
                            "precursor_mono_mass": "9057.3502",
                            "precursor_charge": "5",
                            "precursor_mz": "1812.4773",
                            "feature_inte": "2.3307e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "15",
                        "proteoform_id": "47",
                        "sequence_name": "sp|P37903|USPF_ECOLI",
                        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                        "proteoform_mass": "9057.5302",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "144",
                            "first_residue_position": "0",
                            "last_residue_position": "83",
                            "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVI(PSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTD)[-352.3623].R",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "P"
                                },
                                {
                                    "position": "8",
                                    "acid": "I"
                                },
                                {
                                    "position": "9",
                                    "acid": "D"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "S"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "T"
                                },
                                {
                                    "position": "17",
                                    "acid": "Q"
                                },
                                {
                                    "position": "18",
                                    "acid": "R"
                                },
                                {
                                    "position": "19",
                                    "acid": "V"
                                },
                                {
                                    "position": "20",
                                    "acid": "I"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "H"
                                },
                                {
                                    "position": "23",
                                    "acid": "V"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "E"
                                },
                                {
                                    "position": "26",
                                    "acid": "E"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "K"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "D"
                                },
                                {
                                    "position": "31",
                                    "acid": "D"
                                },
                                {
                                    "position": "32",
                                    "acid": "A"
                                },
                                {
                                    "position": "33",
                                    "acid": "E"
                                },
                                {
                                    "position": "34",
                                    "acid": "V"
                                },
                                {
                                    "position": "35",
                                    "acid": "H"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "L"
                                },
                                {
                                    "position": "38",
                                    "acid": "T"
                                },
                                {
                                    "position": "39",
                                    "acid": "V"
                                },
                                {
                                    "position": "40",
                                    "acid": "I"
                                },
                                {
                                    "position": "41",
                                    "acid": "P"
                                },
                                {
                                    "position": "42",
                                    "acid": "S"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "P"
                                },
                                {
                                    "position": "45",
                                    "acid": "Y"
                                },
                                {
                                    "position": "46",
                                    "acid": "Y"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "S"
                                },
                                {
                                    "position": "49",
                                    "acid": "L"
                                },
                                {
                                    "position": "50",
                                    "acid": "G"
                                },
                                {
                                    "position": "51",
                                    "acid": "L"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "Y"
                                },
                                {
                                    "position": "54",
                                    "acid": "S"
                                },
                                {
                                    "position": "55",
                                    "acid": "A"
                                },
                                {
                                    "position": "56",
                                    "acid": "E"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "P"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "M"
                                },
                                {
                                    "position": "61",
                                    "acid": "D"
                                },
                                {
                                    "position": "62",
                                    "acid": "D"
                                },
                                {
                                    "position": "63",
                                    "acid": "L"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "A"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "K"
                                },
                                {
                                    "position": "69",
                                    "acid": "S"
                                },
                                {
                                    "position": "70",
                                    "acid": "Q"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "E"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "I"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "K"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "F"
                                },
                                {
                                    "position": "79",
                                    "acid": "K"
                                },
                                {
                                    "position": "80",
                                    "acid": "L"
                                },
                                {
                                    "position": "81",
                                    "acid": "P"
                                },
                                {
                                    "position": "82",
                                    "acid": "T"
                                },
                                {
                                    "position": "83",
                                    "acid": "D"
                                },
                                {
                                    "position": "84",
                                    "acid": "R"
                                },
                                {
                                    "position": "85",
                                    "acid": "V"
                                },
                                {
                                    "position": "86",
                                    "acid": "H"
                                },
                                {
                                    "position": "87",
                                    "acid": "V"
                                },
                                {
                                    "position": "88",
                                    "acid": "H"
                                },
                                {
                                    "position": "89",
                                    "acid": "V"
                                },
                                {
                                    "position": "90",
                                    "acid": "E"
                                },
                                {
                                    "position": "91",
                                    "acid": "E"
                                },
                                {
                                    "position": "92",
                                    "acid": "G"
                                },
                                {
                                    "position": "93",
                                    "acid": "S"
                                },
                                {
                                    "position": "94",
                                    "acid": "P"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "R"
                                },
                                {
                                    "position": "98",
                                    "acid": "I"
                                },
                                {
                                    "position": "99",
                                    "acid": "L"
                                },
                                {
                                    "position": "100",
                                    "acid": "E"
                                },
                                {
                                    "position": "101",
                                    "acid": "L"
                                },
                                {
                                    "position": "102",
                                    "acid": "A"
                                },
                                {
                                    "position": "103",
                                    "acid": "K"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "A"
                                },
                                {
                                    "position": "108",
                                    "acid": "H"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                },
                                {
                                    "position": "110",
                                    "acid": "I"
                                },
                                {
                                    "position": "111",
                                    "acid": "I"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "A"
                                },
                                {
                                    "position": "114",
                                    "acid": "S"
                                },
                                {
                                    "position": "115",
                                    "acid": "H"
                                },
                                {
                                    "position": "116",
                                    "acid": "R"
                                },
                                {
                                    "position": "117",
                                    "acid": "P"
                                },
                                {
                                    "position": "118",
                                    "acid": "D"
                                },
                                {
                                    "position": "119",
                                    "acid": "I"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "T"
                                },
                                {
                                    "position": "122",
                                    "acid": "Y"
                                },
                                {
                                    "position": "123",
                                    "acid": "L"
                                },
                                {
                                    "position": "124",
                                    "acid": "L"
                                },
                                {
                                    "position": "125",
                                    "acid": "G"
                                },
                                {
                                    "position": "126",
                                    "acid": "S"
                                },
                                {
                                    "position": "127",
                                    "acid": "N"
                                },
                                {
                                    "position": "128",
                                    "acid": "A"
                                },
                                {
                                    "position": "129",
                                    "acid": "A"
                                },
                                {
                                    "position": "130",
                                    "acid": "A"
                                },
                                {
                                    "position": "131",
                                    "acid": "V"
                                },
                                {
                                    "position": "132",
                                    "acid": "V"
                                },
                                {
                                    "position": "133",
                                    "acid": "R"
                                },
                                {
                                    "position": "134",
                                    "acid": "H"
                                },
                                {
                                    "position": "135",
                                    "acid": "A"
                                },
                                {
                                    "position": "136",
                                    "acid": "E"
                                },
                                {
                                    "position": "137",
                                    "acid": "C"
                                },
                                {
                                    "position": "138",
                                    "acid": "S"
                                },
                                {
                                    "position": "139",
                                    "acid": "V"
                                },
                                {
                                    "position": "140",
                                    "acid": "L"
                                },
                                {
                                    "position": "141",
                                    "acid": "V"
                                },
                                {
                                    "position": "142",
                                    "acid": "V"
                                },
                                {
                                    "position": "143",
                                    "acid": "R"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "346",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "346",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "346",
                                            "peak_id": "45",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "346",
                                            "peak_id": "34",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "346",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "346",
                                            "peak_id": "37",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "346",
                                            "peak_id": "33",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "127",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "128",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "129",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "130",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "131",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "132",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "133",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "134",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "135",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "136",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "137",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "138",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "139",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "140",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "141",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "142",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "143",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "144",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "mass_shift": {
                                "id": "0",
                                "left_position": "41",
                                "right_position": "84",
                                "shift": "-352.3623006464",
                                "anno": "-352.3623",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            }
        ]
    }
}
