prsm_data =
{
    "prsm": {
        "prsm_id": "16",
        "p_value": "1.91e-16",
        "e_value": "1.91e-16",
        "fdr": "0",
        "matched_fragment_number": "20",
        "matched_peak_number": "20",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                "ms1_ids": "525",
                "ms1_scans": "570",
                "ids": "44",
                "scans": "571",
                "precursor_mono_mass": "11884.9202",
                "precursor_charge": "7",
                "precursor_mz": "1698.8530",
                "feature_inte": "7.2266e+07"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "44",
                        "peak_id": "0",
                        "monoisotopic_mass": "1864.9414",
                        "monoisotopic_mz": "1865.9487",
                        "intensity": "1444.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "1",
                        "monoisotopic_mass": "2048.0182",
                        "monoisotopic_mz": "2049.0254",
                        "intensity": "494.43",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "2",
                        "monoisotopic_mass": "1739.8737",
                        "monoisotopic_mz": "1740.8810",
                        "intensity": "933.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "3",
                        "monoisotopic_mass": "1844.9253",
                        "monoisotopic_mz": "1845.9325",
                        "intensity": "1098.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "4",
                        "monoisotopic_mass": "3400.6716",
                        "monoisotopic_mz": "1701.3431",
                        "intensity": "2710.69",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3400.6529",
                                "ion_position": "76",
                                "ion_display_position": "33",
                                "ion_sort_name": "Y00033",
                                "ion_left_position": "76",
                                "mass_error": "0.0187",
                                "ppm": "5.51"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "5",
                        "monoisotopic_mass": "1592.8847",
                        "monoisotopic_mz": "1593.8920",
                        "intensity": "1753.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "6",
                        "monoisotopic_mass": "1207.5568",
                        "monoisotopic_mz": "1208.5641",
                        "intensity": "1951.04",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1207.5510",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "0.0059",
                                "ppm": "4.85"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "7",
                        "monoisotopic_mass": "1163.5483",
                        "monoisotopic_mz": "1164.5555",
                        "intensity": "951.11",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1163.5418",
                                "ion_position": "98",
                                "ion_display_position": "11",
                                "ion_sort_name": "Y00011",
                                "ion_left_position": "98",
                                "mass_error": "0.0064",
                                "ppm": "5.52"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "8",
                        "monoisotopic_mass": "1005.4967",
                        "monoisotopic_mz": "1006.5040",
                        "intensity": "1156.69",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1005.4920",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "0.0047",
                                "ppm": "4.68"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "9",
                        "monoisotopic_mass": "1234.5849",
                        "monoisotopic_mz": "1235.5922",
                        "intensity": "1822.74",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1234.5790",
                                "ion_position": "97",
                                "ion_display_position": "12",
                                "ion_sort_name": "Y00012",
                                "ion_left_position": "97",
                                "mass_error": "0.0059",
                                "ppm": "4.80"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "10",
                        "monoisotopic_mass": "2240.1500",
                        "monoisotopic_mz": "1121.0823",
                        "intensity": "1981.76",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2240.1378",
                                "ion_position": "19",
                                "ion_display_position": "19",
                                "ion_sort_name": "B00019",
                                "ion_left_position": "19",
                                "mass_error": "0.0122",
                                "ppm": "5.45"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "11",
                        "monoisotopic_mass": "3311.6676",
                        "monoisotopic_mz": "1656.8411",
                        "intensity": "1258.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "12",
                        "monoisotopic_mass": "1455.7200",
                        "monoisotopic_mz": "1456.7273",
                        "intensity": "691.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "13",
                        "monoisotopic_mass": "886.4546",
                        "monoisotopic_mz": "887.4619",
                        "intensity": "424.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "14",
                        "monoisotopic_mass": "847.4059",
                        "monoisotopic_mz": "848.4131",
                        "intensity": "968.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "15",
                        "monoisotopic_mass": "2295.1754",
                        "monoisotopic_mz": "1148.5950",
                        "intensity": "372.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "16",
                        "monoisotopic_mass": "790.3690",
                        "monoisotopic_mz": "791.3763",
                        "intensity": "635.40",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "790.3650",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "ion_sort_name": "B00007",
                                "ion_left_position": "7",
                                "mass_error": "0.0040",
                                "ppm": "5.09"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "17",
                        "monoisotopic_mass": "703.3357",
                        "monoisotopic_mz": "704.3430",
                        "intensity": "1062.30",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "703.3330",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "0.0028",
                                "ppm": "3.95"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "18",
                        "monoisotopic_mass": "1301.7270",
                        "monoisotopic_mz": "1302.7343",
                        "intensity": "716.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "19",
                        "monoisotopic_mass": "1362.6784",
                        "monoisotopic_mz": "1363.6857",
                        "intensity": "1512.14",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1362.6739",
                                "ion_position": "96",
                                "ion_display_position": "13",
                                "ion_sort_name": "Y00013",
                                "ion_left_position": "96",
                                "mass_error": "0.0045",
                                "ppm": "3.28"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "20",
                        "monoisotopic_mass": "3777.8639",
                        "monoisotopic_mz": "1889.9392",
                        "intensity": "1790.02",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-9.8227922496e-01",
                                "theoretical_mass": "3777.8721",
                                "ion_position": "73",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "73",
                                "mass_error": "-0.0082",
                                "ppm": "-2.18"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "21",
                        "monoisotopic_mass": "4035.9918",
                        "monoisotopic_mz": "2019.0032",
                        "intensity": "1567.49",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "22",
                        "monoisotopic_mass": "590.2514",
                        "monoisotopic_mz": "591.2587",
                        "intensity": "1507.94",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "590.2489",
                                "ion_position": "5",
                                "ion_display_position": "5",
                                "ion_sort_name": "B00005",
                                "ion_left_position": "5",
                                "mass_error": "0.0026",
                                "ppm": "4.32"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "23",
                        "monoisotopic_mass": "476.2250",
                        "monoisotopic_mz": "477.2323",
                        "intensity": "2358.55",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "476.2231",
                                "ion_position": "105",
                                "ion_display_position": "4",
                                "ion_sort_name": "Y00004",
                                "ion_left_position": "105",
                                "mass_error": "0.0019",
                                "ppm": "4.02"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "24",
                        "monoisotopic_mass": "562.2568",
                        "monoisotopic_mz": "563.2641",
                        "intensity": "1319.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "25",
                        "monoisotopic_mass": "658.3144",
                        "monoisotopic_mz": "659.3217",
                        "intensity": "552.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "26",
                        "monoisotopic_mass": "2668.3174",
                        "monoisotopic_mz": "1335.1660",
                        "intensity": "939.17",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2668.3034",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "0.0140",
                                "ppm": "5.26"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "27",
                        "monoisotopic_mass": "2149.0781",
                        "monoisotopic_mz": "2150.0854",
                        "intensity": "1265.64",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "28",
                        "monoisotopic_mass": "2995.5299",
                        "monoisotopic_mz": "1498.7722",
                        "intensity": "1735.41",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2995.5192",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "ion_sort_name": "B00027",
                                "ion_left_position": "27",
                                "mass_error": "0.0107",
                                "ppm": "3.58"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "29",
                        "monoisotopic_mass": "3514.7567",
                        "monoisotopic_mz": "1758.3856",
                        "intensity": "2207.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "30",
                        "monoisotopic_mass": "1301.7241",
                        "monoisotopic_mz": "651.8693",
                        "intensity": "239.11",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "31",
                        "monoisotopic_mass": "1398.7686",
                        "monoisotopic_mz": "1399.7759",
                        "intensity": "504.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "32",
                        "monoisotopic_mass": "433.2133",
                        "monoisotopic_mz": "434.2205",
                        "intensity": "1022.10",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "33",
                        "monoisotopic_mass": "2769.3659",
                        "monoisotopic_mz": "1385.6902",
                        "intensity": "1264.19",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2769.3511",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0148",
                                "ppm": "5.34"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "34",
                        "monoisotopic_mass": "3164.6093",
                        "monoisotopic_mz": "1583.3119",
                        "intensity": "896.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "35",
                        "monoisotopic_mass": "1946.9678",
                        "monoisotopic_mz": "1947.9750",
                        "intensity": "1053.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "36",
                        "monoisotopic_mass": "1322.6879",
                        "monoisotopic_mz": "1323.6952",
                        "intensity": "974.86",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "37",
                        "monoisotopic_mass": "461.2083",
                        "monoisotopic_mz": "462.2155",
                        "intensity": "857.36",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "461.2063",
                                "ion_position": "4",
                                "ion_display_position": "4",
                                "ion_sort_name": "B00004",
                                "ion_left_position": "4",
                                "mass_error": "0.0020",
                                "ppm": "4.26"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "38",
                        "monoisotopic_mass": "3240.6330",
                        "monoisotopic_mz": "1621.3238",
                        "intensity": "1043.19",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "39",
                        "monoisotopic_mass": "2009.9950",
                        "monoisotopic_mz": "2011.0023",
                        "intensity": "896.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "40",
                        "monoisotopic_mass": "1812.8972",
                        "monoisotopic_mz": "1813.9045",
                        "intensity": "814.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "41",
                        "monoisotopic_mass": "1891.9600",
                        "monoisotopic_mz": "1892.9672",
                        "intensity": "713.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "42",
                        "monoisotopic_mass": "2112.0497",
                        "monoisotopic_mz": "2113.0569",
                        "intensity": "1524.73",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2112.0429",
                                "ion_position": "18",
                                "ion_display_position": "18",
                                "ion_sort_name": "B00018",
                                "ion_left_position": "18",
                                "mass_error": "0.0068",
                                "ppm": "3.21"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "43",
                        "monoisotopic_mass": "1429.7228",
                        "monoisotopic_mz": "1430.7301",
                        "intensity": "251.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "44",
                        "monoisotopic_mass": "1049.5048",
                        "monoisotopic_mz": "1050.5121",
                        "intensity": "724.81",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1049.4989",
                                "ion_position": "99",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "99",
                                "mass_error": "0.0059",
                                "ppm": "5.61"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "45",
                        "monoisotopic_mass": "676.3433",
                        "monoisotopic_mz": "677.3506",
                        "intensity": "737.92",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "676.3392",
                                "ion_position": "103",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "103",
                                "mass_error": "0.0041",
                                "ppm": "6.08"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "46",
                        "monoisotopic_mass": "2881.4475",
                        "monoisotopic_mz": "1441.7310",
                        "intensity": "1576.43",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "47",
                        "monoisotopic_mass": "3595.8111",
                        "monoisotopic_mz": "1798.9128",
                        "intensity": "1366.40",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "48",
                        "monoisotopic_mass": "6891.4278",
                        "monoisotopic_mz": "1723.8642",
                        "intensity": "496.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "49",
                        "monoisotopic_mass": "2024.0087",
                        "monoisotopic_mz": "2025.0160",
                        "intensity": "781.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "50",
                        "monoisotopic_mass": "2072.5360",
                        "monoisotopic_mz": "2073.5433",
                        "intensity": "380.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "51",
                        "monoisotopic_mass": "2310.1828",
                        "monoisotopic_mz": "1156.0987",
                        "intensity": "955.76",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "52",
                        "monoisotopic_mass": "3286.5805",
                        "monoisotopic_mz": "1644.2975",
                        "intensity": "2643.48",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "53",
                        "monoisotopic_mass": "1969.9748",
                        "monoisotopic_mz": "1970.9821",
                        "intensity": "724.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "54",
                        "monoisotopic_mass": "4148.0604",
                        "monoisotopic_mz": "2075.0375",
                        "intensity": "953.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "55",
                        "monoisotopic_mass": "3051.5595",
                        "monoisotopic_mz": "1526.7870",
                        "intensity": "832.13",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "56",
                        "monoisotopic_mass": "7929.0192",
                        "monoisotopic_mz": "1586.8111",
                        "intensity": "436.94",
                        "charge": "5"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "57",
                        "monoisotopic_mass": "3640.8108",
                        "monoisotopic_mz": "1821.4127",
                        "intensity": "1872.06",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-9.8227922496e-01",
                                "theoretical_mass": "3640.8132",
                                "ion_position": "74",
                                "ion_display_position": "35",
                                "ion_sort_name": "Y00035",
                                "ion_left_position": "74",
                                "mass_error": "-0.0024",
                                "ppm": "-0.66"
                            }
                        }
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "58",
                        "monoisotopic_mass": "2481.2544",
                        "monoisotopic_mz": "1241.6345",
                        "intensity": "929.29",
                        "charge": "2"
                    },
                    {
                        "spec_id": "44",
                        "peak_id": "59",
                        "monoisotopic_mass": "3716.8666",
                        "monoisotopic_mz": "1859.4406",
                        "intensity": "468.47",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "9",
            "sequence_name": "sp|P76402|YEGP_ECOLI",
            "sequence_description": "UPF0339 protein YegP OS=Escherichia coli (strain K12) OX=83333 GN=yegP PE=1 SV=2",
            "proteoform_mass": "11884.9502",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "1",
                "last_residue_position": "109",
                "annotated_seq": "M.AGWFELSKSSDNQFRFVLKAGNGETILTSELYTSKTSAEKGIASVRSNSPQEERYEKKTASNGKFYFNLKAANH(QI)[-0.9823]IGSSQMYATAQSRETGIASVKANGTSQTVKDNT.",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "A"
                    },
                    {
                        "position": "2",
                        "acid": "G"
                    },
                    {
                        "position": "3",
                        "acid": "W"
                    },
                    {
                        "position": "4",
                        "acid": "F"
                    },
                    {
                        "position": "5",
                        "acid": "E"
                    },
                    {
                        "position": "6",
                        "acid": "L"
                    },
                    {
                        "position": "7",
                        "acid": "S"
                    },
                    {
                        "position": "8",
                        "acid": "K"
                    },
                    {
                        "position": "9",
                        "acid": "S"
                    },
                    {
                        "position": "10",
                        "acid": "S"
                    },
                    {
                        "position": "11",
                        "acid": "D"
                    },
                    {
                        "position": "12",
                        "acid": "N"
                    },
                    {
                        "position": "13",
                        "acid": "Q"
                    },
                    {
                        "position": "14",
                        "acid": "F"
                    },
                    {
                        "position": "15",
                        "acid": "R"
                    },
                    {
                        "position": "16",
                        "acid": "F"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "K"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "G"
                    },
                    {
                        "position": "24",
                        "acid": "E"
                    },
                    {
                        "position": "25",
                        "acid": "T"
                    },
                    {
                        "position": "26",
                        "acid": "I"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "T"
                    },
                    {
                        "position": "29",
                        "acid": "S"
                    },
                    {
                        "position": "30",
                        "acid": "E"
                    },
                    {
                        "position": "31",
                        "acid": "L"
                    },
                    {
                        "position": "32",
                        "acid": "Y"
                    },
                    {
                        "position": "33",
                        "acid": "T"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "K"
                    },
                    {
                        "position": "36",
                        "acid": "T"
                    },
                    {
                        "position": "37",
                        "acid": "S"
                    },
                    {
                        "position": "38",
                        "acid": "A"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "K"
                    },
                    {
                        "position": "41",
                        "acid": "G"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "S"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "R"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "N"
                    },
                    {
                        "position": "49",
                        "acid": "S"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "Q"
                    },
                    {
                        "position": "52",
                        "acid": "E"
                    },
                    {
                        "position": "53",
                        "acid": "E"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "Y"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "K"
                    },
                    {
                        "position": "58",
                        "acid": "K"
                    },
                    {
                        "position": "59",
                        "acid": "T"
                    },
                    {
                        "position": "60",
                        "acid": "A"
                    },
                    {
                        "position": "61",
                        "acid": "S"
                    },
                    {
                        "position": "62",
                        "acid": "N"
                    },
                    {
                        "position": "63",
                        "acid": "G"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "F"
                    },
                    {
                        "position": "66",
                        "acid": "Y"
                    },
                    {
                        "position": "67",
                        "acid": "F"
                    },
                    {
                        "position": "68",
                        "acid": "N"
                    },
                    {
                        "position": "69",
                        "acid": "L"
                    },
                    {
                        "position": "70",
                        "acid": "K"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "N"
                    },
                    {
                        "position": "74",
                        "acid": "H"
                    },
                    {
                        "position": "75",
                        "acid": "Q"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "I"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "S"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "Q"
                    },
                    {
                        "position": "82",
                        "acid": "M"
                    },
                    {
                        "position": "83",
                        "acid": "Y"
                    },
                    {
                        "position": "84",
                        "acid": "A"
                    },
                    {
                        "position": "85",
                        "acid": "T"
                    },
                    {
                        "position": "86",
                        "acid": "A"
                    },
                    {
                        "position": "87",
                        "acid": "Q"
                    },
                    {
                        "position": "88",
                        "acid": "S"
                    },
                    {
                        "position": "89",
                        "acid": "R"
                    },
                    {
                        "position": "90",
                        "acid": "E"
                    },
                    {
                        "position": "91",
                        "acid": "T"
                    },
                    {
                        "position": "92",
                        "acid": "G"
                    },
                    {
                        "position": "93",
                        "acid": "I"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "V"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "A"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "T"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "Q"
                    },
                    {
                        "position": "104",
                        "acid": "T"
                    },
                    {
                        "position": "105",
                        "acid": "V"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "D"
                    },
                    {
                        "position": "108",
                        "acid": "N"
                    },
                    {
                        "position": "109",
                        "acid": "T"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "4",
                                "ion_display_position": "4",
                                "spec_id": "44",
                                "peak_id": "37",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "5",
                                "ion_display_position": "5",
                                "spec_id": "44",
                                "peak_id": "22",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "44",
                                "peak_id": "17",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "spec_id": "44",
                                "peak_id": "16",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "44",
                                "peak_id": "8",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "44",
                                "peak_id": "6",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "18",
                                "ion_display_position": "18",
                                "spec_id": "44",
                                "peak_id": "42",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "19",
                                "ion_display_position": "19",
                                "spec_id": "44",
                                "peak_id": "10",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "spec_id": "44",
                                "peak_id": "26",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "44",
                                "peak_id": "33",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "spec_id": "44",
                                "peak_id": "28",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "73",
                                "ion_display_position": "36",
                                "spec_id": "44",
                                "peak_id": "20",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "74",
                                "ion_display_position": "35",
                                "spec_id": "44",
                                "peak_id": "57",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "76",
                                "ion_display_position": "33",
                                "spec_id": "44",
                                "peak_id": "4",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "96",
                                "ion_display_position": "13",
                                "spec_id": "44",
                                "peak_id": "19",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "97",
                                "ion_display_position": "12",
                                "spec_id": "44",
                                "peak_id": "9",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "98",
                                "ion_display_position": "11",
                                "spec_id": "44",
                                "peak_id": "7",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "99",
                                "ion_display_position": "10",
                                "spec_id": "44",
                                "peak_id": "44",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "103",
                                "ion_display_position": "6",
                                "spec_id": "44",
                                "peak_id": "45",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "105",
                                "ion_display_position": "4",
                                "spec_id": "44",
                                "peak_id": "23",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "75",
                    "right_position": "77",
                    "shift": "-9.8227922496e-01",
                    "anno": "-0.9823",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
