prsm_data =
{
    "prsm": {
        "prsm_id": "137",
        "p_value": "9.12e-10",
        "e_value": "9.12e-10",
        "fdr": "0",
        "matched_fragment_number": "16",
        "matched_peak_number": "17",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                "ms1_ids": "614",
                "ms1_scans": "920",
                "ids": "306",
                "scans": "922",
                "precursor_mono_mass": "10344.9866",
                "precursor_charge": "7",
                "precursor_mz": "1478.8625",
                "feature_inte": "1.8578e+09"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "306",
                        "peak_id": "0",
                        "monoisotopic_mass": "1673.8689",
                        "monoisotopic_mz": "1674.8762",
                        "intensity": "1335.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "1",
                        "monoisotopic_mass": "1336.7158",
                        "monoisotopic_mz": "1337.7230",
                        "intensity": "1824.32",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1336.7099",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "ion_sort_name": "B00013",
                                "ion_left_position": "13",
                                "mass_error": "0.0058",
                                "ppm": "4.37"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "2",
                        "monoisotopic_mass": "2026.0101",
                        "monoisotopic_mz": "2027.0174",
                        "intensity": "1812.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "3",
                        "monoisotopic_mass": "2435.3079",
                        "monoisotopic_mz": "2436.3152",
                        "intensity": "4796.96",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2435.2995",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "69",
                                "mass_error": "0.0084",
                                "ppm": "3.47"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "4",
                        "monoisotopic_mass": "2286.2483",
                        "monoisotopic_mz": "2287.2556",
                        "intensity": "1447.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "5",
                        "monoisotopic_mass": "1603.8832",
                        "monoisotopic_mz": "1604.8905",
                        "intensity": "6213.79",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1603.8756",
                                "ion_position": "76",
                                "ion_display_position": "13",
                                "ion_sort_name": "Y00013",
                                "ion_left_position": "76",
                                "mass_error": "0.0076",
                                "ppm": "4.76"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "6",
                        "monoisotopic_mass": "1698.8300",
                        "monoisotopic_mz": "1699.8373",
                        "intensity": "1409.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "7",
                        "monoisotopic_mass": "1376.7168",
                        "monoisotopic_mz": "1377.7241",
                        "intensity": "3129.44",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1376.7122",
                                "ion_position": "78",
                                "ion_display_position": "11",
                                "ion_sort_name": "Y00011",
                                "ion_left_position": "78",
                                "mass_error": "0.0046",
                                "ppm": "3.35"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "8",
                        "monoisotopic_mass": "3766.8664",
                        "monoisotopic_mz": "1884.4405",
                        "intensity": "6038.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "9",
                        "monoisotopic_mass": "3637.8254",
                        "monoisotopic_mz": "1819.9200",
                        "intensity": "3738.07",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "10",
                        "monoisotopic_mass": "770.3600",
                        "monoisotopic_mz": "771.3672",
                        "intensity": "5602.76",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0041",
                                "ppm": "5.31"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "11",
                        "monoisotopic_mass": "1012.4992",
                        "monoisotopic_mz": "1013.5065",
                        "intensity": "3242.48",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1012.4938",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "0.0055",
                                "ppm": "5.41"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "12",
                        "monoisotopic_mass": "3493.7702",
                        "monoisotopic_mz": "1747.8924",
                        "intensity": "4488.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "13",
                        "monoisotopic_mass": "3617.8193",
                        "monoisotopic_mz": "1809.9169",
                        "intensity": "2488.83",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "14",
                        "monoisotopic_mass": "1140.5950",
                        "monoisotopic_mz": "1141.6023",
                        "intensity": "6275.37",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1140.5887",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "0.0063",
                                "ppm": "5.51"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "15",
                        "monoisotopic_mass": "1718.9076",
                        "monoisotopic_mz": "1719.9149",
                        "intensity": "2100.48",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1718.9025",
                                "ion_position": "75",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "75",
                                "mass_error": "0.0051",
                                "ppm": "2.97"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "16",
                        "monoisotopic_mass": "1062.5579",
                        "monoisotopic_mz": "1063.5652",
                        "intensity": "2115.25",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1062.5532",
                                "ion_position": "81",
                                "ion_display_position": "8",
                                "ion_sort_name": "Y00008",
                                "ion_left_position": "81",
                                "mass_error": "0.0047",
                                "ppm": "4.43"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "17",
                        "monoisotopic_mass": "1464.9098",
                        "monoisotopic_mz": "1465.9171",
                        "intensity": "1683.65",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "18",
                        "monoisotopic_mass": "1248.6251",
                        "monoisotopic_mz": "1249.6323",
                        "intensity": "3901.40",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1248.6173",
                                "ion_position": "79",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "79",
                                "mass_error": "0.0078",
                                "ppm": "6.24"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "19",
                        "monoisotopic_mass": "739.3424",
                        "monoisotopic_mz": "740.3497",
                        "intensity": "1787.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "20",
                        "monoisotopic_mass": "2179.1490",
                        "monoisotopic_mz": "2180.1563",
                        "intensity": "1384.83",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2179.1460",
                                "ion_position": "71",
                                "ion_display_position": "18",
                                "ion_sort_name": "Y00018",
                                "ion_left_position": "71",
                                "mass_error": "0.0031",
                                "ppm": "1.40"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "21",
                        "monoisotopic_mass": "655.3324",
                        "monoisotopic_mz": "656.3397",
                        "intensity": "2465.43",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "655.3289",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "ion_sort_name": "B00007",
                                "ion_left_position": "7",
                                "mass_error": "0.0034",
                                "ppm": "5.25"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "22",
                        "monoisotopic_mass": "867.4381",
                        "monoisotopic_mz": "868.4454",
                        "intensity": "717.01",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "23",
                        "monoisotopic_mass": "2435.3048",
                        "monoisotopic_mz": "1218.6597",
                        "intensity": "2610.39",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2435.2995",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "69",
                                "mass_error": "0.0053",
                                "ppm": "2.19"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "24",
                        "monoisotopic_mass": "584.2942",
                        "monoisotopic_mz": "585.3015",
                        "intensity": "4369.24",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "584.2918",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "0.0024",
                                "ppm": "4.03"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "25",
                        "monoisotopic_mass": "842.4323",
                        "monoisotopic_mz": "843.4396",
                        "intensity": "558.26",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "26",
                        "monoisotopic_mass": "1427.7054",
                        "monoisotopic_mz": "1428.7126",
                        "intensity": "1312.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "27",
                        "monoisotopic_mass": "2808.2603",
                        "monoisotopic_mz": "937.0940",
                        "intensity": "1860.48",
                        "charge": "3"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "28",
                        "monoisotopic_mass": "627.3362",
                        "monoisotopic_mz": "628.3434",
                        "intensity": "935.58",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "29",
                        "monoisotopic_mass": "610.3100",
                        "monoisotopic_mz": "611.3173",
                        "intensity": "534.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "30",
                        "monoisotopic_mass": "3384.5168",
                        "monoisotopic_mz": "1693.2657",
                        "intensity": "3369.60",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "31",
                        "monoisotopic_mass": "3130.5387",
                        "monoisotopic_mz": "1566.2766",
                        "intensity": "1878.63",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "32",
                        "monoisotopic_mass": "520.2701",
                        "monoisotopic_mz": "521.2774",
                        "intensity": "2886.38",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "520.2679",
                                "ion_position": "85",
                                "ion_display_position": "4",
                                "ion_sort_name": "Y00004",
                                "ion_left_position": "85",
                                "mass_error": "0.0022",
                                "ppm": "4.25"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "33",
                        "monoisotopic_mass": "783.4274",
                        "monoisotopic_mz": "784.4346",
                        "intensity": "615.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "34",
                        "monoisotopic_mass": "884.4029",
                        "monoisotopic_mz": "885.4102",
                        "intensity": "924.97",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "884.3988",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "0.0041",
                                "ppm": "4.67"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "35",
                        "monoisotopic_mass": "1083.6130",
                        "monoisotopic_mz": "1084.6202",
                        "intensity": "1291.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "36",
                        "monoisotopic_mass": "2737.2119",
                        "monoisotopic_mz": "913.4113",
                        "intensity": "1104.78",
                        "charge": "3"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "37",
                        "monoisotopic_mass": "2295.1525",
                        "monoisotopic_mz": "1148.5835",
                        "intensity": "1560.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "38",
                        "monoisotopic_mass": "412.1609",
                        "monoisotopic_mz": "413.1682",
                        "intensity": "1872.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "39",
                        "monoisotopic_mass": "1434.7422",
                        "monoisotopic_mz": "718.3784",
                        "intensity": "622.23",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "40",
                        "monoisotopic_mass": "566.2837",
                        "monoisotopic_mz": "567.2910",
                        "intensity": "1640.49",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "41",
                        "monoisotopic_mass": "435.2134",
                        "monoisotopic_mz": "436.2207",
                        "intensity": "1704.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "42",
                        "monoisotopic_mass": "1155.4921",
                        "monoisotopic_mz": "1156.4994",
                        "intensity": "295.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "43",
                        "monoisotopic_mass": "3594.8163",
                        "monoisotopic_mz": "1798.4154",
                        "intensity": "2389.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "44",
                        "monoisotopic_mass": "2986.4608",
                        "monoisotopic_mz": "1494.2377",
                        "intensity": "1480.01",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "45",
                        "monoisotopic_mass": "3246.6093",
                        "monoisotopic_mz": "1624.3119",
                        "intensity": "1080.31",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "46",
                        "monoisotopic_mass": "1810.9150",
                        "monoisotopic_mz": "1811.9223",
                        "intensity": "1807.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "47",
                        "monoisotopic_mass": "2907.3405",
                        "monoisotopic_mz": "1454.6775",
                        "intensity": "2400.90",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "48",
                        "monoisotopic_mass": "1870.9276",
                        "monoisotopic_mz": "1871.9349",
                        "intensity": "939.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "49",
                        "monoisotopic_mass": "2535.2870",
                        "monoisotopic_mz": "1268.6508",
                        "intensity": "428.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "50",
                        "monoisotopic_mass": "4513.3732",
                        "monoisotopic_mz": "1129.3506",
                        "intensity": "512.87",
                        "charge": "4"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "51",
                        "monoisotopic_mass": "2830.4481",
                        "monoisotopic_mz": "1416.2313",
                        "intensity": "1860.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "52",
                        "monoisotopic_mass": "3867.9229",
                        "monoisotopic_mz": "1934.9687",
                        "intensity": "3611.52",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "53",
                        "monoisotopic_mass": "8150.9915",
                        "monoisotopic_mz": "1359.5059",
                        "intensity": "1078.63",
                        "charge": "6"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "54",
                        "monoisotopic_mass": "2107.1098",
                        "monoisotopic_mz": "2108.1171",
                        "intensity": "1034.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "55",
                        "monoisotopic_mass": "5324.3773",
                        "monoisotopic_mz": "1332.1016",
                        "intensity": "392.41",
                        "charge": "4"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "56",
                        "monoisotopic_mass": "4123.0503",
                        "monoisotopic_mz": "1375.3574",
                        "intensity": "1884.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "57",
                        "monoisotopic_mass": "2779.4510",
                        "monoisotopic_mz": "1390.7328",
                        "intensity": "1302.36",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2779.4327",
                                "ion_position": "66",
                                "ion_display_position": "23",
                                "ion_sort_name": "Y00023",
                                "ion_left_position": "66",
                                "mass_error": "0.0183",
                                "ppm": "6.57"
                            }
                        }
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "58",
                        "monoisotopic_mass": "7786.7644",
                        "monoisotopic_mz": "1298.8013",
                        "intensity": "468.75",
                        "charge": "6"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "59",
                        "monoisotopic_mass": "2738.2276",
                        "monoisotopic_mz": "1370.1211",
                        "intensity": "1692.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "60",
                        "monoisotopic_mass": "3637.8197",
                        "monoisotopic_mz": "1213.6138",
                        "intensity": "2277.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "61",
                        "monoisotopic_mass": "2807.2614",
                        "monoisotopic_mz": "1404.6380",
                        "intensity": "2810.20",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "62",
                        "monoisotopic_mass": "7155.8373",
                        "monoisotopic_mz": "1432.1747",
                        "intensity": "1259.00",
                        "charge": "5"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "63",
                        "monoisotopic_mass": "4404.3008",
                        "monoisotopic_mz": "1102.0825",
                        "intensity": "956.91",
                        "charge": "4"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "64",
                        "monoisotopic_mass": "3096.6892",
                        "monoisotopic_mz": "1033.2370",
                        "intensity": "933.61",
                        "charge": "3"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "65",
                        "monoisotopic_mass": "6653.7436",
                        "monoisotopic_mz": "1331.7560",
                        "intensity": "501.85",
                        "charge": "5"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "66",
                        "monoisotopic_mass": "3512.5562",
                        "monoisotopic_mz": "1757.2854",
                        "intensity": "3338.42",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "67",
                        "monoisotopic_mass": "2504.3940",
                        "monoisotopic_mz": "1253.2043",
                        "intensity": "2417.61",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "68",
                        "monoisotopic_mass": "3021.3550",
                        "monoisotopic_mz": "1511.6848",
                        "intensity": "2119.33",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "69",
                        "monoisotopic_mass": "2603.4678",
                        "monoisotopic_mz": "1302.7412",
                        "intensity": "1860.85",
                        "charge": "2"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "70",
                        "monoisotopic_mass": "7495.9027",
                        "monoisotopic_mz": "1071.8505",
                        "intensity": "383.56",
                        "charge": "7"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "71",
                        "monoisotopic_mass": "7859.9393",
                        "monoisotopic_mz": "1123.8558",
                        "intensity": "600.91",
                        "charge": "7"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "72",
                        "monoisotopic_mass": "5518.7461",
                        "monoisotopic_mz": "1380.6938",
                        "intensity": "1469.10",
                        "charge": "4"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "73",
                        "monoisotopic_mass": "8191.9448",
                        "monoisotopic_mz": "1366.3314",
                        "intensity": "486.92",
                        "charge": "6"
                    },
                    {
                        "spec_id": "306",
                        "peak_id": "74",
                        "monoisotopic_mass": "1620.2181",
                        "monoisotopic_mz": "1621.2254",
                        "intensity": "975.20",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "22",
            "proteoform_id": "28",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "10345.1916",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "306",
                                "peak_id": "24",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "spec_id": "306",
                                "peak_id": "21",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "306",
                                "peak_id": "10",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "306",
                                "peak_id": "34",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "spec_id": "306",
                                "peak_id": "11",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "306",
                                "peak_id": "14",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "spec_id": "306",
                                "peak_id": "1",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "66",
                                "ion_display_position": "23",
                                "spec_id": "306",
                                "peak_id": "57",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "69",
                                    "ion_display_position": "20",
                                    "spec_id": "306",
                                    "peak_id": "23",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "69",
                                    "ion_display_position": "20",
                                    "spec_id": "306",
                                    "peak_id": "3",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "18",
                                "spec_id": "306",
                                "peak_id": "20",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "75",
                                "ion_display_position": "14",
                                "spec_id": "306",
                                "peak_id": "15",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "76",
                                "ion_display_position": "13",
                                "spec_id": "306",
                                "peak_id": "5",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "78",
                                "ion_display_position": "11",
                                "spec_id": "306",
                                "peak_id": "7",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "10",
                                "spec_id": "306",
                                "peak_id": "18",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "81",
                                "ion_display_position": "8",
                                "spec_id": "306",
                                "peak_id": "16",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "85",
                                "ion_display_position": "4",
                                "spec_id": "306",
                                "peak_id": "32",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "34",
                    "right_position": "87",
                    "shift": "496.3199335793",
                    "anno": "+496.3199",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
