prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "29",
        "sequence_name": "sp|P0A7V0|RS2_ECOLI",
        "sequence_description": "30S ribosomal protein S2 OS=Escherichia coli (strain K12) OX=83333 GN=rpsB PE=1 SV=2",
        "proteoform_id": "49",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "47",
            "p_value": "6.68e-04",
            "e_value": "6.68e-04",
            "fdr": "0",
            "matched_fragment_number": "10",
            "matched_peak_number": "11",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                    "ms1_ids": "561",
                    "ms1_scans": "710",
                    "ids": "148",
                    "scans": "711",
                    "precursor_mono_mass": "6626.0709",
                    "precursor_charge": "8",
                    "precursor_mz": "829.2661",
                    "feature_inte": "3.0575e+08"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "148",
                            "peak_id": "0",
                            "monoisotopic_mass": "1392.7791",
                            "monoisotopic_mz": "1393.7864",
                            "intensity": "2191.13",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "1",
                            "monoisotopic_mass": "1979.1160",
                            "monoisotopic_mz": "990.5653",
                            "intensity": "2300.09",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "2",
                            "monoisotopic_mass": "1000.5708",
                            "monoisotopic_mz": "1001.5781",
                            "intensity": "9128.60",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1000.5665",
                                    "ion_position": "50",
                                    "ion_display_position": "9",
                                    "ion_sort_name": "Y00009",
                                    "ion_left_position": "50",
                                    "mass_error": "0.0043",
                                    "ppm": "4.30"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "3",
                            "monoisotopic_mass": "1313.7360",
                            "monoisotopic_mz": "1314.7433",
                            "intensity": "1988.46",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1313.7303",
                                    "ion_position": "47",
                                    "ion_display_position": "12",
                                    "ion_sort_name": "Y00012",
                                    "ion_left_position": "47",
                                    "mass_error": "0.0057",
                                    "ppm": "4.34"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "4",
                            "monoisotopic_mass": "1427.7791",
                            "monoisotopic_mz": "1428.7864",
                            "intensity": "2284.14",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1427.7732",
                                    "ion_position": "46",
                                    "ion_display_position": "13",
                                    "ion_sort_name": "Y00013",
                                    "ion_left_position": "46",
                                    "mass_error": "0.0059",
                                    "ppm": "4.10"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "5",
                            "monoisotopic_mass": "1802.9434",
                            "monoisotopic_mz": "902.4790",
                            "intensity": "3879.59",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1802.9349",
                                    "ion_position": "43",
                                    "ion_display_position": "16",
                                    "ion_sort_name": "Y00016",
                                    "ion_left_position": "43",
                                    "mass_error": "0.0085",
                                    "ppm": "4.71"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "6",
                            "monoisotopic_mass": "882.5322",
                            "monoisotopic_mz": "883.5394",
                            "intensity": "6506.18",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "7",
                            "monoisotopic_mass": "666.3729",
                            "monoisotopic_mz": "667.3802",
                            "intensity": "2053.04",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "8",
                            "monoisotopic_mass": "1184.6933",
                            "monoisotopic_mz": "1185.7006",
                            "intensity": "4879.62",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1184.6877",
                                    "ion_position": "48",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "Y00011",
                                    "ion_left_position": "48",
                                    "mass_error": "0.0056",
                                    "ppm": "4.70"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "9",
                            "monoisotopic_mass": "929.5337",
                            "monoisotopic_mz": "930.5410",
                            "intensity": "4615.47",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "929.5294",
                                    "ion_position": "51",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "Y00008",
                                    "ion_left_position": "51",
                                    "mass_error": "0.0043",
                                    "ppm": "4.64"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "10",
                            "monoisotopic_mass": "1295.7247",
                            "monoisotopic_mz": "1296.7319",
                            "intensity": "1234.02",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "11",
                            "monoisotopic_mass": "1113.6557",
                            "monoisotopic_mz": "1114.6630",
                            "intensity": "5847.61",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1113.6506",
                                    "ion_position": "49",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "49",
                                    "mass_error": "0.0051",
                                    "ppm": "4.56"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "12",
                            "monoisotopic_mass": "1224.6878",
                            "monoisotopic_mz": "1225.6951",
                            "intensity": "1829.17",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "13",
                            "monoisotopic_mass": "1059.5470",
                            "monoisotopic_mz": "1060.5543",
                            "intensity": "1196.76",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "14",
                            "monoisotopic_mass": "800.4903",
                            "monoisotopic_mz": "801.4976",
                            "intensity": "3468.43",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "800.4868",
                                    "ion_position": "52",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "Y00007",
                                    "ion_left_position": "52",
                                    "mass_error": "0.0034",
                                    "ppm": "4.30"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "15",
                            "monoisotopic_mass": "687.4054",
                            "monoisotopic_mz": "688.4127",
                            "intensity": "2406.46",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "687.4028",
                                    "ion_position": "53",
                                    "ion_display_position": "6",
                                    "ion_sort_name": "Y00006",
                                    "ion_left_position": "53",
                                    "mass_error": "0.0026",
                                    "ppm": "3.79"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "16",
                            "monoisotopic_mass": "828.4047",
                            "monoisotopic_mz": "829.4120",
                            "intensity": "4031.21",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "17",
                            "monoisotopic_mass": "711.3257",
                            "monoisotopic_mz": "712.3329",
                            "intensity": "719.44",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "18",
                            "monoisotopic_mass": "567.3035",
                            "monoisotopic_mz": "568.3108",
                            "intensity": "1039.27",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "19",
                            "monoisotopic_mass": "502.3005",
                            "monoisotopic_mz": "503.3078",
                            "intensity": "1556.11",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "20",
                            "monoisotopic_mass": "1268.7602",
                            "monoisotopic_mz": "635.3874",
                            "intensity": "1219.67",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "21",
                            "monoisotopic_mass": "489.2065",
                            "monoisotopic_mz": "490.2138",
                            "intensity": "762.15",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "489.2006",
                                    "ion_position": "4",
                                    "ion_display_position": "4",
                                    "ion_sort_name": "B00004",
                                    "ion_left_position": "4",
                                    "mass_error": "0.0059",
                                    "ppm": "12.13"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "22",
                            "monoisotopic_mass": "1076.5286",
                            "monoisotopic_mz": "1077.5359",
                            "intensity": "684.41",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "23",
                            "monoisotopic_mass": "618.2499",
                            "monoisotopic_mz": "619.2571",
                            "intensity": "1366.05",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "24",
                            "monoisotopic_mass": "2071.1735",
                            "monoisotopic_mz": "1036.5940",
                            "intensity": "1378.81",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "25",
                            "monoisotopic_mass": "414.2478",
                            "monoisotopic_mz": "415.2550",
                            "intensity": "3350.93",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "26",
                            "monoisotopic_mass": "1000.5702",
                            "monoisotopic_mz": "501.2924",
                            "intensity": "616.96",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1000.5665",
                                    "ion_position": "50",
                                    "ion_display_position": "9",
                                    "ion_sort_name": "Y00009",
                                    "ion_left_position": "50",
                                    "mass_error": "0.0036",
                                    "ppm": "3.61"
                                }
                            }
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "27",
                            "monoisotopic_mass": "1061.5654",
                            "monoisotopic_mz": "531.7900",
                            "intensity": "551.20",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "28",
                            "monoisotopic_mass": "1882.0961",
                            "monoisotopic_mz": "942.0553",
                            "intensity": "778.58",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "29",
                            "monoisotopic_mass": "1801.9433",
                            "monoisotopic_mz": "1802.9506",
                            "intensity": "1717.11",
                            "charge": "1"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "30",
                            "monoisotopic_mass": "1996.1223",
                            "monoisotopic_mz": "999.0684",
                            "intensity": "2020.06",
                            "charge": "2"
                        },
                        {
                            "spec_id": "148",
                            "peak_id": "31",
                            "monoisotopic_mass": "1951.1169",
                            "monoisotopic_mz": "976.5657",
                            "intensity": "371.71",
                            "charge": "2"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "29",
                "proteoform_id": "49",
                "sequence_name": "sp|P0A7V0|RS2_ECOLI",
                "sequence_description": "30S ribosomal protein S2 OS=Escherichia coli (strain K12) OX=83333 GN=rpsB PE=1 SV=2",
                "proteoform_mass": "6626.2009",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "241",
                    "first_residue_position": "4",
                    "last_residue_position": "62",
                    "annotated_seq": "V.SMRD(MLKAGVHFGHQTRYWNPKMKPFIFGARNKVHIINLEKTV)[-253.4122]PMFNEALAELNKIASR.K",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "A"
                        },
                        {
                            "position": "2",
                            "acid": "T"
                        },
                        {
                            "position": "3",
                            "acid": "V"
                        },
                        {
                            "position": "4",
                            "acid": "S"
                        },
                        {
                            "position": "5",
                            "acid": "M"
                        },
                        {
                            "position": "6",
                            "acid": "R"
                        },
                        {
                            "position": "7",
                            "acid": "D"
                        },
                        {
                            "position": "8",
                            "acid": "M"
                        },
                        {
                            "position": "9",
                            "acid": "L"
                        },
                        {
                            "position": "10",
                            "acid": "K"
                        },
                        {
                            "position": "11",
                            "acid": "A"
                        },
                        {
                            "position": "12",
                            "acid": "G"
                        },
                        {
                            "position": "13",
                            "acid": "V"
                        },
                        {
                            "position": "14",
                            "acid": "H"
                        },
                        {
                            "position": "15",
                            "acid": "F"
                        },
                        {
                            "position": "16",
                            "acid": "G"
                        },
                        {
                            "position": "17",
                            "acid": "H"
                        },
                        {
                            "position": "18",
                            "acid": "Q"
                        },
                        {
                            "position": "19",
                            "acid": "T"
                        },
                        {
                            "position": "20",
                            "acid": "R"
                        },
                        {
                            "position": "21",
                            "acid": "Y"
                        },
                        {
                            "position": "22",
                            "acid": "W"
                        },
                        {
                            "position": "23",
                            "acid": "N"
                        },
                        {
                            "position": "24",
                            "acid": "P"
                        },
                        {
                            "position": "25",
                            "acid": "K"
                        },
                        {
                            "position": "26",
                            "acid": "M"
                        },
                        {
                            "position": "27",
                            "acid": "K"
                        },
                        {
                            "position": "28",
                            "acid": "P"
                        },
                        {
                            "position": "29",
                            "acid": "F"
                        },
                        {
                            "position": "30",
                            "acid": "I"
                        },
                        {
                            "position": "31",
                            "acid": "F"
                        },
                        {
                            "position": "32",
                            "acid": "G"
                        },
                        {
                            "position": "33",
                            "acid": "A"
                        },
                        {
                            "position": "34",
                            "acid": "R"
                        },
                        {
                            "position": "35",
                            "acid": "N"
                        },
                        {
                            "position": "36",
                            "acid": "K"
                        },
                        {
                            "position": "37",
                            "acid": "V"
                        },
                        {
                            "position": "38",
                            "acid": "H"
                        },
                        {
                            "position": "39",
                            "acid": "I"
                        },
                        {
                            "position": "40",
                            "acid": "I"
                        },
                        {
                            "position": "41",
                            "acid": "N"
                        },
                        {
                            "position": "42",
                            "acid": "L"
                        },
                        {
                            "position": "43",
                            "acid": "E"
                        },
                        {
                            "position": "44",
                            "acid": "K"
                        },
                        {
                            "position": "45",
                            "acid": "T"
                        },
                        {
                            "position": "46",
                            "acid": "V"
                        },
                        {
                            "position": "47",
                            "acid": "P"
                        },
                        {
                            "position": "48",
                            "acid": "M"
                        },
                        {
                            "position": "49",
                            "acid": "F"
                        },
                        {
                            "position": "50",
                            "acid": "N"
                        },
                        {
                            "position": "51",
                            "acid": "E"
                        },
                        {
                            "position": "52",
                            "acid": "A"
                        },
                        {
                            "position": "53",
                            "acid": "L"
                        },
                        {
                            "position": "54",
                            "acid": "A"
                        },
                        {
                            "position": "55",
                            "acid": "E"
                        },
                        {
                            "position": "56",
                            "acid": "L"
                        },
                        {
                            "position": "57",
                            "acid": "N"
                        },
                        {
                            "position": "58",
                            "acid": "K"
                        },
                        {
                            "position": "59",
                            "acid": "I"
                        },
                        {
                            "position": "60",
                            "acid": "A"
                        },
                        {
                            "position": "61",
                            "acid": "S"
                        },
                        {
                            "position": "62",
                            "acid": "R"
                        },
                        {
                            "position": "63",
                            "acid": "K"
                        },
                        {
                            "position": "64",
                            "acid": "G"
                        },
                        {
                            "position": "65",
                            "acid": "K"
                        },
                        {
                            "position": "66",
                            "acid": "I"
                        },
                        {
                            "position": "67",
                            "acid": "L"
                        },
                        {
                            "position": "68",
                            "acid": "F"
                        },
                        {
                            "position": "69",
                            "acid": "V"
                        },
                        {
                            "position": "70",
                            "acid": "G"
                        },
                        {
                            "position": "71",
                            "acid": "T"
                        },
                        {
                            "position": "72",
                            "acid": "K"
                        },
                        {
                            "position": "73",
                            "acid": "R"
                        },
                        {
                            "position": "74",
                            "acid": "A"
                        },
                        {
                            "position": "75",
                            "acid": "A"
                        },
                        {
                            "position": "76",
                            "acid": "S"
                        },
                        {
                            "position": "77",
                            "acid": "E"
                        },
                        {
                            "position": "78",
                            "acid": "A"
                        },
                        {
                            "position": "79",
                            "acid": "V"
                        },
                        {
                            "position": "80",
                            "acid": "K"
                        },
                        {
                            "position": "81",
                            "acid": "D"
                        },
                        {
                            "position": "82",
                            "acid": "A"
                        },
                        {
                            "position": "83",
                            "acid": "A"
                        },
                        {
                            "position": "84",
                            "acid": "L"
                        },
                        {
                            "position": "85",
                            "acid": "S"
                        },
                        {
                            "position": "86",
                            "acid": "C"
                        },
                        {
                            "position": "87",
                            "acid": "D"
                        },
                        {
                            "position": "88",
                            "acid": "Q"
                        },
                        {
                            "position": "89",
                            "acid": "F"
                        },
                        {
                            "position": "90",
                            "acid": "F"
                        },
                        {
                            "position": "91",
                            "acid": "V"
                        },
                        {
                            "position": "92",
                            "acid": "N"
                        },
                        {
                            "position": "93",
                            "acid": "H"
                        },
                        {
                            "position": "94",
                            "acid": "R"
                        },
                        {
                            "position": "95",
                            "acid": "W"
                        },
                        {
                            "position": "96",
                            "acid": "L"
                        },
                        {
                            "position": "97",
                            "acid": "G"
                        },
                        {
                            "position": "98",
                            "acid": "G"
                        },
                        {
                            "position": "99",
                            "acid": "M"
                        },
                        {
                            "position": "100",
                            "acid": "L"
                        },
                        {
                            "position": "101",
                            "acid": "T"
                        },
                        {
                            "position": "102",
                            "acid": "N"
                        },
                        {
                            "position": "103",
                            "acid": "W"
                        },
                        {
                            "position": "104",
                            "acid": "K"
                        },
                        {
                            "position": "105",
                            "acid": "T"
                        },
                        {
                            "position": "106",
                            "acid": "V"
                        },
                        {
                            "position": "107",
                            "acid": "R"
                        },
                        {
                            "position": "108",
                            "acid": "Q"
                        },
                        {
                            "position": "109",
                            "acid": "S"
                        },
                        {
                            "position": "110",
                            "acid": "I"
                        },
                        {
                            "position": "111",
                            "acid": "K"
                        },
                        {
                            "position": "112",
                            "acid": "R"
                        },
                        {
                            "position": "113",
                            "acid": "L"
                        },
                        {
                            "position": "114",
                            "acid": "K"
                        },
                        {
                            "position": "115",
                            "acid": "D"
                        },
                        {
                            "position": "116",
                            "acid": "L"
                        },
                        {
                            "position": "117",
                            "acid": "E"
                        },
                        {
                            "position": "118",
                            "acid": "T"
                        },
                        {
                            "position": "119",
                            "acid": "Q"
                        },
                        {
                            "position": "120",
                            "acid": "S"
                        },
                        {
                            "position": "121",
                            "acid": "Q"
                        },
                        {
                            "position": "122",
                            "acid": "D"
                        },
                        {
                            "position": "123",
                            "acid": "G"
                        },
                        {
                            "position": "124",
                            "acid": "T"
                        },
                        {
                            "position": "125",
                            "acid": "F"
                        },
                        {
                            "position": "126",
                            "acid": "D"
                        },
                        {
                            "position": "127",
                            "acid": "K"
                        },
                        {
                            "position": "128",
                            "acid": "L"
                        },
                        {
                            "position": "129",
                            "acid": "T"
                        },
                        {
                            "position": "130",
                            "acid": "K"
                        },
                        {
                            "position": "131",
                            "acid": "K"
                        },
                        {
                            "position": "132",
                            "acid": "E"
                        },
                        {
                            "position": "133",
                            "acid": "A"
                        },
                        {
                            "position": "134",
                            "acid": "L"
                        },
                        {
                            "position": "135",
                            "acid": "M"
                        },
                        {
                            "position": "136",
                            "acid": "R"
                        },
                        {
                            "position": "137",
                            "acid": "T"
                        },
                        {
                            "position": "138",
                            "acid": "R"
                        },
                        {
                            "position": "139",
                            "acid": "E"
                        },
                        {
                            "position": "140",
                            "acid": "L"
                        },
                        {
                            "position": "141",
                            "acid": "E"
                        },
                        {
                            "position": "142",
                            "acid": "K"
                        },
                        {
                            "position": "143",
                            "acid": "L"
                        },
                        {
                            "position": "144",
                            "acid": "E"
                        },
                        {
                            "position": "145",
                            "acid": "N"
                        },
                        {
                            "position": "146",
                            "acid": "S"
                        },
                        {
                            "position": "147",
                            "acid": "L"
                        },
                        {
                            "position": "148",
                            "acid": "G"
                        },
                        {
                            "position": "149",
                            "acid": "G"
                        },
                        {
                            "position": "150",
                            "acid": "I"
                        },
                        {
                            "position": "151",
                            "acid": "K"
                        },
                        {
                            "position": "152",
                            "acid": "D"
                        },
                        {
                            "position": "153",
                            "acid": "M"
                        },
                        {
                            "position": "154",
                            "acid": "G"
                        },
                        {
                            "position": "155",
                            "acid": "G"
                        },
                        {
                            "position": "156",
                            "acid": "L"
                        },
                        {
                            "position": "157",
                            "acid": "P"
                        },
                        {
                            "position": "158",
                            "acid": "D"
                        },
                        {
                            "position": "159",
                            "acid": "A"
                        },
                        {
                            "position": "160",
                            "acid": "L"
                        },
                        {
                            "position": "161",
                            "acid": "F"
                        },
                        {
                            "position": "162",
                            "acid": "V"
                        },
                        {
                            "position": "163",
                            "acid": "I"
                        },
                        {
                            "position": "164",
                            "acid": "D"
                        },
                        {
                            "position": "165",
                            "acid": "A"
                        },
                        {
                            "position": "166",
                            "acid": "D"
                        },
                        {
                            "position": "167",
                            "acid": "H"
                        },
                        {
                            "position": "168",
                            "acid": "E"
                        },
                        {
                            "position": "169",
                            "acid": "H"
                        },
                        {
                            "position": "170",
                            "acid": "I"
                        },
                        {
                            "position": "171",
                            "acid": "A"
                        },
                        {
                            "position": "172",
                            "acid": "I"
                        },
                        {
                            "position": "173",
                            "acid": "K"
                        },
                        {
                            "position": "174",
                            "acid": "E"
                        },
                        {
                            "position": "175",
                            "acid": "A"
                        },
                        {
                            "position": "176",
                            "acid": "N"
                        },
                        {
                            "position": "177",
                            "acid": "N"
                        },
                        {
                            "position": "178",
                            "acid": "L"
                        },
                        {
                            "position": "179",
                            "acid": "G"
                        },
                        {
                            "position": "180",
                            "acid": "I"
                        },
                        {
                            "position": "181",
                            "acid": "P"
                        },
                        {
                            "position": "182",
                            "acid": "V"
                        },
                        {
                            "position": "183",
                            "acid": "F"
                        },
                        {
                            "position": "184",
                            "acid": "A"
                        },
                        {
                            "position": "185",
                            "acid": "I"
                        },
                        {
                            "position": "186",
                            "acid": "V"
                        },
                        {
                            "position": "187",
                            "acid": "D"
                        },
                        {
                            "position": "188",
                            "acid": "T"
                        },
                        {
                            "position": "189",
                            "acid": "N"
                        },
                        {
                            "position": "190",
                            "acid": "S"
                        },
                        {
                            "position": "191",
                            "acid": "D"
                        },
                        {
                            "position": "192",
                            "acid": "P"
                        },
                        {
                            "position": "193",
                            "acid": "D"
                        },
                        {
                            "position": "194",
                            "acid": "G"
                        },
                        {
                            "position": "195",
                            "acid": "V"
                        },
                        {
                            "position": "196",
                            "acid": "D"
                        },
                        {
                            "position": "197",
                            "acid": "F"
                        },
                        {
                            "position": "198",
                            "acid": "V"
                        },
                        {
                            "position": "199",
                            "acid": "I"
                        },
                        {
                            "position": "200",
                            "acid": "P"
                        },
                        {
                            "position": "201",
                            "acid": "G"
                        },
                        {
                            "position": "202",
                            "acid": "N"
                        },
                        {
                            "position": "203",
                            "acid": "D"
                        },
                        {
                            "position": "204",
                            "acid": "D"
                        },
                        {
                            "position": "205",
                            "acid": "A"
                        },
                        {
                            "position": "206",
                            "acid": "I"
                        },
                        {
                            "position": "207",
                            "acid": "R"
                        },
                        {
                            "position": "208",
                            "acid": "A"
                        },
                        {
                            "position": "209",
                            "acid": "V"
                        },
                        {
                            "position": "210",
                            "acid": "T"
                        },
                        {
                            "position": "211",
                            "acid": "L"
                        },
                        {
                            "position": "212",
                            "acid": "Y"
                        },
                        {
                            "position": "213",
                            "acid": "L"
                        },
                        {
                            "position": "214",
                            "acid": "G"
                        },
                        {
                            "position": "215",
                            "acid": "A"
                        },
                        {
                            "position": "216",
                            "acid": "V"
                        },
                        {
                            "position": "217",
                            "acid": "A"
                        },
                        {
                            "position": "218",
                            "acid": "A"
                        },
                        {
                            "position": "219",
                            "acid": "T"
                        },
                        {
                            "position": "220",
                            "acid": "V"
                        },
                        {
                            "position": "221",
                            "acid": "R"
                        },
                        {
                            "position": "222",
                            "acid": "E"
                        },
                        {
                            "position": "223",
                            "acid": "G"
                        },
                        {
                            "position": "224",
                            "acid": "R"
                        },
                        {
                            "position": "225",
                            "acid": "S"
                        },
                        {
                            "position": "226",
                            "acid": "Q"
                        },
                        {
                            "position": "227",
                            "acid": "D"
                        },
                        {
                            "position": "228",
                            "acid": "L"
                        },
                        {
                            "position": "229",
                            "acid": "A"
                        },
                        {
                            "position": "230",
                            "acid": "S"
                        },
                        {
                            "position": "231",
                            "acid": "Q"
                        },
                        {
                            "position": "232",
                            "acid": "A"
                        },
                        {
                            "position": "233",
                            "acid": "E"
                        },
                        {
                            "position": "234",
                            "acid": "E"
                        },
                        {
                            "position": "235",
                            "acid": "S"
                        },
                        {
                            "position": "236",
                            "acid": "F"
                        },
                        {
                            "position": "237",
                            "acid": "V"
                        },
                        {
                            "position": "238",
                            "acid": "E"
                        },
                        {
                            "position": "239",
                            "acid": "A"
                        },
                        {
                            "position": "240",
                            "acid": "E"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "4",
                                    "ion_display_position": "4",
                                    "spec_id": "148",
                                    "peak_id": "21",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "43",
                                    "ion_display_position": "16",
                                    "spec_id": "148",
                                    "peak_id": "5",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "46",
                                    "ion_display_position": "13",
                                    "spec_id": "148",
                                    "peak_id": "4",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "47",
                                    "ion_display_position": "12",
                                    "spec_id": "148",
                                    "peak_id": "3",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "48",
                                    "ion_display_position": "11",
                                    "spec_id": "148",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "49",
                                    "ion_display_position": "10",
                                    "spec_id": "148",
                                    "peak_id": "11",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "9",
                                        "spec_id": "148",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "9",
                                        "spec_id": "148",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "51",
                                    "ion_display_position": "8",
                                    "spec_id": "148",
                                    "peak_id": "9",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "52",
                                    "ion_display_position": "7",
                                    "spec_id": "148",
                                    "peak_id": "14",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "53",
                                    "ion_display_position": "6",
                                    "spec_id": "148",
                                    "peak_id": "15",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "140",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "141",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "142",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "143",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "144",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "145",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "146",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "147",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "148",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "149",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "150",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "151",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "152",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "153",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "154",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "155",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "156",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "157",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "158",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "159",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "160",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "161",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "162",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "163",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "164",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "165",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "166",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "167",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "168",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "169",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "170",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "171",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "172",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "173",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "174",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "175",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "176",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "177",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "178",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "179",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "180",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "181",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "182",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "183",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "184",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "185",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "186",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "187",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "188",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "189",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "190",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "191",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "192",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "193",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "194",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "195",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "196",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "197",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "198",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "199",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "200",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "201",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "202",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "203",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "204",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "205",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "206",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "207",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "208",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "209",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "210",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "211",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "212",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "213",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "214",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "215",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "216",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "217",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "218",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "219",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "220",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "221",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "222",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "223",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "224",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "225",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "226",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "227",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "228",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "229",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "230",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "231",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "232",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "233",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "234",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "235",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "236",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "237",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "238",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "239",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "240",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "241",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "8",
                        "right_position": "47",
                        "shift": "-253.4121858584",
                        "anno": "-253.4122",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
