prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "9",
        "sequence_name": "sp|P61175|RL22_ECOLI",
        "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
        "proteoform_id": "10",
        "prsm_number": "2",
        "prsm": [
            {
                "prsm_id": "56",
                "p_value": "2.54e-25",
                "e_value": "2.54e-25",
                "fdr": "0",
                "matched_fragment_number": "26",
                "matched_peak_number": "29",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "569",
                        "ms1_scans": "741",
                        "ids": "172",
                        "scans": "743",
                        "precursor_mono_mass": "4478.3962",
                        "precursor_charge": "5",
                        "precursor_mz": "896.6865",
                        "feature_inte": "2.9627e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "172",
                                "peak_id": "0",
                                "monoisotopic_mass": "1577.8571",
                                "monoisotopic_mz": "1578.8644",
                                "intensity": "3197.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0084",
                                        "ppm": "5.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "1",
                                "monoisotopic_mass": "1608.6724",
                                "monoisotopic_mz": "1609.6797",
                                "intensity": "2150.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "2",
                                "monoisotopic_mass": "1920.9986",
                                "monoisotopic_mz": "1922.0059",
                                "intensity": "921.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1920.9867",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0120",
                                        "ppm": "6.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "3",
                                "monoisotopic_mass": "1249.6440",
                                "monoisotopic_mz": "1250.6512",
                                "intensity": "8875.99",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0063",
                                        "ppm": "5.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "4",
                                "monoisotopic_mass": "1350.6918",
                                "monoisotopic_mz": "1351.6991",
                                "intensity": "18236.92",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0065",
                                        "ppm": "4.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "5",
                                "monoisotopic_mass": "1008.4632",
                                "monoisotopic_mz": "1009.4705",
                                "intensity": "20573.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0045",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "6",
                                "monoisotopic_mass": "1737.7168",
                                "monoisotopic_mz": "1738.7241",
                                "intensity": "1416.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "7",
                                "monoisotopic_mass": "952.3567",
                                "monoisotopic_mz": "953.3640",
                                "intensity": "3346.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "8",
                                "monoisotopic_mass": "1825.0134",
                                "monoisotopic_mz": "913.5140",
                                "intensity": "1188.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "9",
                                "monoisotopic_mass": "1690.9436",
                                "monoisotopic_mz": "1691.9509",
                                "intensity": "1681.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0109",
                                        "ppm": "6.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "10",
                                "monoisotopic_mass": "3543.7808",
                                "monoisotopic_mz": "1182.2675",
                                "intensity": "1686.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "11",
                                "monoisotopic_mass": "994.3783",
                                "monoisotopic_mz": "995.3856",
                                "intensity": "3204.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "12",
                                "monoisotopic_mass": "861.3937",
                                "monoisotopic_mz": "862.4010",
                                "intensity": "6937.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0035",
                                        "ppm": "4.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "13",
                                "monoisotopic_mass": "1121.5478",
                                "monoisotopic_mz": "1122.5551",
                                "intensity": "17013.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0051",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "14",
                                "monoisotopic_mass": "1431.7526",
                                "monoisotopic_mz": "1432.7599",
                                "intensity": "1384.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "15",
                                "monoisotopic_mass": "1337.5175",
                                "monoisotopic_mz": "1338.5248",
                                "intensity": "3409.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "16",
                                "monoisotopic_mass": "923.3415",
                                "monoisotopic_mz": "924.3488",
                                "intensity": "1714.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "17",
                                "monoisotopic_mass": "1449.7603",
                                "monoisotopic_mz": "1450.7676",
                                "intensity": "10483.99",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0065",
                                        "ppm": "4.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "18",
                                "monoisotopic_mass": "1690.9402",
                                "monoisotopic_mz": "846.4774",
                                "intensity": "1641.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0074",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "19",
                                "monoisotopic_mass": "1706.0062",
                                "monoisotopic_mz": "854.0104",
                                "intensity": "1497.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "20",
                                "monoisotopic_mass": "1591.9598",
                                "monoisotopic_mz": "796.9872",
                                "intensity": "2110.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "21",
                                "monoisotopic_mass": "762.3252",
                                "monoisotopic_mz": "763.3325",
                                "intensity": "10966.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0034",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "22",
                                "monoisotopic_mass": "936.6522",
                                "monoisotopic_mz": "937.6594",
                                "intensity": "2272.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "936.6484",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0037",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "23",
                                "monoisotopic_mass": "2021.1464",
                                "monoisotopic_mz": "1011.5805",
                                "intensity": "2662.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "24",
                                "monoisotopic_mass": "837.5830",
                                "monoisotopic_mz": "838.5903",
                                "intensity": "1364.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "837.5800",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0030",
                                        "ppm": "3.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "25",
                                "monoisotopic_mass": "1980.9052",
                                "monoisotopic_mz": "991.4599",
                                "intensity": "1806.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "26",
                                "monoisotopic_mass": "967.6115",
                                "monoisotopic_mz": "968.6188",
                                "intensity": "1978.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "27",
                                "monoisotopic_mass": "647.2976",
                                "monoisotopic_mz": "648.3049",
                                "intensity": "12860.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "647.2949",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0027",
                                        "ppm": "4.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "28",
                                "monoisotopic_mass": "2392.1971",
                                "monoisotopic_mz": "1197.1058",
                                "intensity": "1291.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2392.1832",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0139",
                                        "ppm": "5.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "29",
                                "monoisotopic_mass": "1635.0168",
                                "monoisotopic_mz": "818.5157",
                                "intensity": "1584.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1635.0083",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0085",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "30",
                                "monoisotopic_mass": "979.6474",
                                "monoisotopic_mz": "980.6547",
                                "intensity": "651.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "31",
                                "monoisotopic_mass": "1178.7799",
                                "monoisotopic_mz": "590.3972",
                                "intensity": "1409.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1178.7751",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0048",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "32",
                                "monoisotopic_mass": "709.4881",
                                "monoisotopic_mz": "710.4954",
                                "intensity": "3605.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "709.4850",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0030",
                                        "ppm": "4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "33",
                                "monoisotopic_mass": "629.2872",
                                "monoisotopic_mz": "630.2945",
                                "intensity": "4007.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "34",
                                "monoisotopic_mass": "680.4973",
                                "monoisotopic_mz": "681.5046",
                                "intensity": "874.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "35",
                                "monoisotopic_mass": "1103.5372",
                                "monoisotopic_mz": "1104.5444",
                                "intensity": "1809.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "36",
                                "monoisotopic_mass": "1049.7385",
                                "monoisotopic_mz": "1050.7457",
                                "intensity": "1019.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1049.7325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0060",
                                        "ppm": "5.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "37",
                                "monoisotopic_mass": "581.3924",
                                "monoisotopic_mz": "582.3997",
                                "intensity": "6101.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "581.3901",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0024",
                                        "ppm": "4.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "38",
                                "monoisotopic_mass": "2277.1622",
                                "monoisotopic_mz": "1139.5884",
                                "intensity": "1623.36",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2277.1562",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0060",
                                        "ppm": "2.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "39",
                                "monoisotopic_mass": "1449.9345",
                                "monoisotopic_mz": "725.9745",
                                "intensity": "1630.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.9283",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0063",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "40",
                                "monoisotopic_mass": "2506.2394",
                                "monoisotopic_mz": "1254.1270",
                                "intensity": "2514.98",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2506.2261",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0133",
                                        "ppm": "5.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "41",
                                "monoisotopic_mass": "2087.1717",
                                "monoisotopic_mz": "696.7312",
                                "intensity": "420.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "42",
                                "monoisotopic_mass": "3028.4625",
                                "monoisotopic_mz": "1515.2385",
                                "intensity": "695.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3028.4448",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0177",
                                        "ppm": "5.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "43",
                                "monoisotopic_mass": "2787.4516",
                                "monoisotopic_mz": "1394.7331",
                                "intensity": "2026.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2787.4403",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0113",
                                        "ppm": "4.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "44",
                                "monoisotopic_mass": "2444.3087",
                                "monoisotopic_mz": "815.7768",
                                "intensity": "1144.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0064",
                                        "ppm": "2.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "45",
                                "monoisotopic_mass": "3126.5771",
                                "monoisotopic_mz": "1043.1996",
                                "intensity": "1078.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "46",
                                "monoisotopic_mass": "2643.2994",
                                "monoisotopic_mz": "1322.6570",
                                "intensity": "2053.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2643.2850",
                                        "ion_position": "18",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0144",
                                        "ppm": "5.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "47",
                                "monoisotopic_mass": "4074.5161",
                                "monoisotopic_mz": "815.9105",
                                "intensity": "1246.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "48",
                                "monoisotopic_mass": "2444.3131",
                                "monoisotopic_mz": "1223.1638",
                                "intensity": "2931.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0108",
                                        "ppm": "4.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "49",
                                "monoisotopic_mass": "1849.8015",
                                "monoisotopic_mz": "1850.8087",
                                "intensity": "2029.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "50",
                                "monoisotopic_mass": "3028.4583",
                                "monoisotopic_mz": "1010.4934",
                                "intensity": "924.25",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3028.4448",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0136",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "51",
                                "monoisotopic_mass": "2033.0793",
                                "monoisotopic_mz": "1017.5469",
                                "intensity": "1506.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "52",
                                "monoisotopic_mass": "3726.2697",
                                "monoisotopic_mz": "746.2612",
                                "intensity": "400.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "53",
                                "monoisotopic_mass": "3529.9475",
                                "monoisotopic_mz": "706.9968",
                                "intensity": "445.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "172",
                                "peak_id": "54",
                                "monoisotopic_mass": "2642.2911",
                                "monoisotopic_mz": "881.7710",
                                "intensity": "1044.66",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "172",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "172",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "172",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "172",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "172",
                                        "peak_id": "36",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "172",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "14",
                                            "ion_display_position": "14",
                                            "spec_id": "172",
                                            "peak_id": "39",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "28",
                                            "spec_id": "172",
                                            "peak_id": "50",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "14",
                                            "ion_display_position": "28",
                                            "spec_id": "172",
                                            "peak_id": "42",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "172",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "18",
                                        "ion_display_position": "24",
                                        "spec_id": "172",
                                        "peak_id": "46",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "19",
                                        "ion_display_position": "23",
                                        "spec_id": "172",
                                        "peak_id": "40",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "spec_id": "172",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "172",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "24",
                                            "ion_display_position": "24",
                                            "spec_id": "172",
                                            "peak_id": "44",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "24",
                                            "ion_display_position": "24",
                                            "spec_id": "172",
                                            "peak_id": "48",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "spec_id": "172",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "172",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "172",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "172",
                                            "peak_id": "43",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "spec_id": "172",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "172",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "172",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "172",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "172",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "172",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "172",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "172",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "6",
                                        "spec_id": "172",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "77",
                "p_value": "2.05e-24",
                "e_value": "2.05e-24",
                "fdr": "0",
                "matched_fragment_number": "26",
                "matched_peak_number": "28",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "580",
                        "ms1_scans": "785",
                        "ids": "204",
                        "scans": "786",
                        "precursor_mono_mass": "4478.3999",
                        "precursor_charge": "5",
                        "precursor_mz": "896.6873",
                        "feature_inte": "2.8401e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "204",
                                "peak_id": "0",
                                "monoisotopic_mass": "1606.7319",
                                "monoisotopic_mz": "1607.7391",
                                "intensity": "1846.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "1",
                                "monoisotopic_mass": "1850.7963",
                                "monoisotopic_mz": "1851.8035",
                                "intensity": "3465.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "2",
                                "monoisotopic_mass": "1737.7160",
                                "monoisotopic_mz": "1738.7233",
                                "intensity": "2282.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "3",
                                "monoisotopic_mass": "1921.9951",
                                "monoisotopic_mz": "1923.0024",
                                "intensity": "1292.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "4",
                                "monoisotopic_mass": "1690.9433",
                                "monoisotopic_mz": "1691.9506",
                                "intensity": "2909.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1690.9328",
                                        "ion_position": "27",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0105",
                                        "ppm": "6.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "5",
                                "monoisotopic_mass": "1805.9659",
                                "monoisotopic_mz": "1806.9732",
                                "intensity": "1872.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1805.9597",
                                        "ion_position": "26",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0062",
                                        "ppm": "3.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "6",
                                "monoisotopic_mass": "994.3787",
                                "monoisotopic_mz": "995.3860",
                                "intensity": "6035.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "7",
                                "monoisotopic_mass": "1363.6432",
                                "monoisotopic_mz": "1364.6505",
                                "intensity": "928.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "8",
                                "monoisotopic_mass": "1008.4631",
                                "monoisotopic_mz": "1009.4703",
                                "intensity": "33598.58",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1008.4586",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0044",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "9",
                                "monoisotopic_mass": "1721.7592",
                                "monoisotopic_mz": "1722.7665",
                                "intensity": "1738.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "10",
                                "monoisotopic_mass": "1577.8547",
                                "monoisotopic_mz": "1578.8619",
                                "intensity": "5151.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0059",
                                        "ppm": "3.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "11",
                                "monoisotopic_mass": "1350.6911",
                                "monoisotopic_mz": "1351.6984",
                                "intensity": "34144.66",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1350.6853",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0058",
                                        "ppm": "4.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "12",
                                "monoisotopic_mass": "1337.5180",
                                "monoisotopic_mz": "1338.5253",
                                "intensity": "7343.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "13",
                                "monoisotopic_mass": "1249.6437",
                                "monoisotopic_mz": "1250.6510",
                                "intensity": "13489.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1249.6377",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0061",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "14",
                                "monoisotopic_mass": "1507.6613",
                                "monoisotopic_mz": "1508.6686",
                                "intensity": "3229.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "15",
                                "monoisotopic_mass": "2039.1093",
                                "monoisotopic_mz": "1020.5619",
                                "intensity": "5091.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "16",
                                "monoisotopic_mass": "1319.5073",
                                "monoisotopic_mz": "1320.5145",
                                "intensity": "1107.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "17",
                                "monoisotopic_mass": "1121.5477",
                                "monoisotopic_mz": "1122.5549",
                                "intensity": "28953.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1121.5427",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0050",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "18",
                                "monoisotopic_mass": "861.3939",
                                "monoisotopic_mz": "862.4011",
                                "intensity": "13593.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "861.3902",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0036",
                                        "ppm": "4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "19",
                                "monoisotopic_mass": "1431.7482",
                                "monoisotopic_mz": "1432.7555",
                                "intensity": "2456.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "20",
                                "monoisotopic_mass": "952.3564",
                                "monoisotopic_mz": "953.3637",
                                "intensity": "5484.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "21",
                                "monoisotopic_mass": "936.6526",
                                "monoisotopic_mz": "937.6598",
                                "intensity": "3637.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "936.6484",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0041",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "22",
                                "monoisotopic_mass": "981.6012",
                                "monoisotopic_mz": "982.6085",
                                "intensity": "3158.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "23",
                                "monoisotopic_mass": "1706.0023",
                                "monoisotopic_mz": "854.0084",
                                "intensity": "3362.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "24",
                                "monoisotopic_mass": "790.5464",
                                "monoisotopic_mz": "791.5536",
                                "intensity": "2227.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "25",
                                "monoisotopic_mass": "1920.9941",
                                "monoisotopic_mz": "961.5044",
                                "intensity": "1298.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1920.9867",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0075",
                                        "ppm": "3.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "26",
                                "monoisotopic_mass": "967.6099",
                                "monoisotopic_mz": "968.6171",
                                "intensity": "3171.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "27",
                                "monoisotopic_mass": "921.6410",
                                "monoisotopic_mz": "922.6483",
                                "intensity": "2353.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "28",
                                "monoisotopic_mass": "1449.7601",
                                "monoisotopic_mz": "1450.7673",
                                "intensity": "18555.93",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1449.7538",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0063",
                                        "ppm": "4.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "29",
                                "monoisotopic_mass": "1577.8546",
                                "monoisotopic_mz": "789.9346",
                                "intensity": "3172.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1577.8487",
                                        "ion_position": "28",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0059",
                                        "ppm": "3.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "30",
                                "monoisotopic_mass": "1049.7370",
                                "monoisotopic_mz": "1050.7443",
                                "intensity": "2447.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1049.7325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0045",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "31",
                                "monoisotopic_mass": "1107.4633",
                                "monoisotopic_mz": "1108.4706",
                                "intensity": "3509.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "32",
                                "monoisotopic_mass": "1691.9420",
                                "monoisotopic_mz": "846.9783",
                                "intensity": "2104.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "33",
                                "monoisotopic_mass": "762.3250",
                                "monoisotopic_mz": "763.3323",
                                "intensity": "20013.29",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3218",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0032",
                                        "ppm": "4.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "34",
                                "monoisotopic_mass": "2021.1471",
                                "monoisotopic_mz": "1011.5808",
                                "intensity": "3692.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "35",
                                "monoisotopic_mass": "1493.6423",
                                "monoisotopic_mz": "1494.6495",
                                "intensity": "1256.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "36",
                                "monoisotopic_mass": "1635.0134",
                                "monoisotopic_mz": "818.5140",
                                "intensity": "1263.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1635.0083",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0051",
                                        "ppm": "3.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "37",
                                "monoisotopic_mass": "1155.5455",
                                "monoisotopic_mz": "1156.5527",
                                "intensity": "1651.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "38",
                                "monoisotopic_mass": "567.4131",
                                "monoisotopic_mz": "568.4203",
                                "intensity": "4101.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "39",
                                "monoisotopic_mass": "1336.8504",
                                "monoisotopic_mz": "669.4325",
                                "intensity": "7050.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.8442",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0062",
                                        "ppm": "4.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "40",
                                "monoisotopic_mass": "609.2168",
                                "monoisotopic_mz": "610.2241",
                                "intensity": "3818.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "41",
                                "monoisotopic_mass": "1591.9590",
                                "monoisotopic_mz": "796.9868",
                                "intensity": "3746.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "42",
                                "monoisotopic_mass": "2990.0365",
                                "monoisotopic_mz": "599.0146",
                                "intensity": "1364.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "43",
                                "monoisotopic_mass": "1520.9724",
                                "monoisotopic_mz": "761.4935",
                                "intensity": "1875.95",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1520.9654",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0070",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "44",
                                "monoisotopic_mass": "2295.1402",
                                "monoisotopic_mz": "766.0540",
                                "intensity": "585.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "45",
                                "monoisotopic_mass": "2661.3593",
                                "monoisotopic_mz": "1331.6869",
                                "intensity": "775.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "46",
                                "monoisotopic_mass": "2392.1908",
                                "monoisotopic_mz": "1197.1027",
                                "intensity": "2493.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2392.1832",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0076",
                                        "ppm": "3.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "47",
                                "monoisotopic_mass": "1835.0968",
                                "monoisotopic_mz": "918.5557",
                                "intensity": "1608.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1835.0880",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0088",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "48",
                                "monoisotopic_mass": "2297.2958",
                                "monoisotopic_mz": "1149.6552",
                                "intensity": "2022.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "49",
                                "monoisotopic_mass": "3542.7733",
                                "monoisotopic_mz": "1181.9317",
                                "intensity": "2876.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "50",
                                "monoisotopic_mass": "3028.4620",
                                "monoisotopic_mz": "1515.2383",
                                "intensity": "2794.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3028.4448",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0173",
                                        "ppm": "5.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "51",
                                "monoisotopic_mass": "1672.9277",
                                "monoisotopic_mz": "837.4711",
                                "intensity": "977.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "52",
                                "monoisotopic_mass": "2277.1676",
                                "monoisotopic_mz": "1139.5911",
                                "intensity": "3892.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2277.1562",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0114",
                                        "ppm": "4.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "53",
                                "monoisotopic_mass": "3126.5730",
                                "monoisotopic_mz": "1043.1983",
                                "intensity": "1642.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "54",
                                "monoisotopic_mass": "2426.2917",
                                "monoisotopic_mz": "809.7712",
                                "intensity": "1645.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "55",
                                "monoisotopic_mass": "2787.4550",
                                "monoisotopic_mz": "1394.7348",
                                "intensity": "3675.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2787.4403",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0147",
                                        "ppm": "5.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "56",
                                "monoisotopic_mass": "2182.0603",
                                "monoisotopic_mz": "728.3607",
                                "intensity": "341.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "57",
                                "monoisotopic_mass": "2149.1080",
                                "monoisotopic_mz": "1075.5613",
                                "intensity": "909.76",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2149.0977",
                                        "ion_position": "23",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0104",
                                        "ppm": "4.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "58",
                                "monoisotopic_mass": "2444.3117",
                                "monoisotopic_mz": "815.7778",
                                "intensity": "2631.42",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0093",
                                        "ppm": "3.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "59",
                                "monoisotopic_mass": "2077.9674",
                                "monoisotopic_mz": "1039.9910",
                                "intensity": "740.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "60",
                                "monoisotopic_mass": "1792.9691",
                                "monoisotopic_mz": "897.4918",
                                "intensity": "616.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "61",
                                "monoisotopic_mass": "3299.6121",
                                "monoisotopic_mz": "1100.8780",
                                "intensity": "1137.61",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3299.5980",
                                        "ion_position": "11",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "Y00031",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0142",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "62",
                                "monoisotopic_mass": "2772.3272",
                                "monoisotopic_mz": "1387.1709",
                                "intensity": "1306.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2772.3276",
                                        "ion_position": "17",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "63",
                                "monoisotopic_mass": "3656.8568",
                                "monoisotopic_mz": "1219.9595",
                                "intensity": "557.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "64",
                                "monoisotopic_mass": "2905.0977",
                                "monoisotopic_mz": "727.2817",
                                "intensity": "577.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "65",
                                "monoisotopic_mass": "2529.9613",
                                "monoisotopic_mz": "633.4976",
                                "intensity": "458.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "66",
                                "monoisotopic_mass": "2033.0815",
                                "monoisotopic_mz": "2034.0888",
                                "intensity": "1583.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "67",
                                "monoisotopic_mass": "2642.2957",
                                "monoisotopic_mz": "881.7725",
                                "intensity": "1610.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "68",
                                "monoisotopic_mass": "1948.8668",
                                "monoisotopic_mz": "1949.8740",
                                "intensity": "1604.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "69",
                                "monoisotopic_mass": "2954.5275",
                                "monoisotopic_mz": "985.8498",
                                "intensity": "1615.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "70",
                                "monoisotopic_mass": "2843.3769",
                                "monoisotopic_mz": "1422.6957",
                                "intensity": "779.51",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2843.3647",
                                        "ion_position": "16",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "Y00026",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0122",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "71",
                                "monoisotopic_mass": "2444.3178",
                                "monoisotopic_mz": "1223.1662",
                                "intensity": "4298.23",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2444.3023",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0154",
                                        "ppm": "6.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "72",
                                "monoisotopic_mass": "2642.3015",
                                "monoisotopic_mz": "1322.1580",
                                "intensity": "3718.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "204",
                                "peak_id": "73",
                                "monoisotopic_mass": "2505.2317",
                                "monoisotopic_mz": "1253.6231",
                                "intensity": "4397.38",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "9",
                    "proteoform_id": "10",
                    "sequence_name": "sp|P61175|RL22_ECOLI",
                    "sequence_description": "50S ribosomal protein L22 OS=Escherichia coli (strain K12) OX=83333 GN=rplV PE=1 SV=1",
                    "proteoform_mass": "4478.3731",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "41",
                        "last_residue_position": "82",
                        "annotated_seq": "K.KAAVLVKKVLESAIANAEHNDGADIDDLKVTKIFVDEGPSMK.R",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "E"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "A"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "H"
                            },
                            {
                                "position": "7",
                                "acid": "R"
                            },
                            {
                                "position": "8",
                                "acid": "H"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "R"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "K"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "R"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "D"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "I"
                            },
                            {
                                "position": "24",
                                "acid": "R"
                            },
                            {
                                "position": "25",
                                "acid": "G"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "K"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "S"
                            },
                            {
                                "position": "30",
                                "acid": "Q"
                            },
                            {
                                "position": "31",
                                "acid": "A"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "D"
                            },
                            {
                                "position": "34",
                                "acid": "I"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "T"
                            },
                            {
                                "position": "37",
                                "acid": "Y"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "N"
                            },
                            {
                                "position": "40",
                                "acid": "K"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "L"
                            },
                            {
                                "position": "46",
                                "acid": "V"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "L"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "S"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "N"
                            },
                            {
                                "position": "57",
                                "acid": "A"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "G"
                            },
                            {
                                "position": "63",
                                "acid": "A"
                            },
                            {
                                "position": "64",
                                "acid": "D"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "D"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "L"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "V"
                            },
                            {
                                "position": "71",
                                "acid": "T"
                            },
                            {
                                "position": "72",
                                "acid": "K"
                            },
                            {
                                "position": "73",
                                "acid": "I"
                            },
                            {
                                "position": "74",
                                "acid": "F"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "D"
                            },
                            {
                                "position": "77",
                                "acid": "E"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "P"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "M"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "R"
                            },
                            {
                                "position": "84",
                                "acid": "I"
                            },
                            {
                                "position": "85",
                                "acid": "M"
                            },
                            {
                                "position": "86",
                                "acid": "P"
                            },
                            {
                                "position": "87",
                                "acid": "R"
                            },
                            {
                                "position": "88",
                                "acid": "A"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            },
                            {
                                "position": "90",
                                "acid": "G"
                            },
                            {
                                "position": "91",
                                "acid": "R"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "D"
                            },
                            {
                                "position": "94",
                                "acid": "R"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "L"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "R"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "S"
                            },
                            {
                                "position": "101",
                                "acid": "H"
                            },
                            {
                                "position": "102",
                                "acid": "I"
                            },
                            {
                                "position": "103",
                                "acid": "T"
                            },
                            {
                                "position": "104",
                                "acid": "V"
                            },
                            {
                                "position": "105",
                                "acid": "V"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "204",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "204",
                                        "peak_id": "30",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "11",
                                        "ion_display_position": "31",
                                        "spec_id": "204",
                                        "peak_id": "61",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "204",
                                        "peak_id": "39",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "14",
                                        "ion_display_position": "28",
                                        "spec_id": "204",
                                        "peak_id": "50",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "204",
                                        "peak_id": "43",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "16",
                                            "ion_display_position": "16",
                                            "spec_id": "204",
                                            "peak_id": "36",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "16",
                                            "ion_display_position": "26",
                                            "spec_id": "204",
                                            "peak_id": "70",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "25",
                                        "spec_id": "204",
                                        "peak_id": "62",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "204",
                                        "peak_id": "47",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "22",
                                        "spec_id": "204",
                                        "peak_id": "46",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "204",
                                        "peak_id": "52",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "23",
                                        "ion_display_position": "19",
                                        "spec_id": "204",
                                        "peak_id": "57",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "24",
                                            "ion_display_position": "24",
                                            "spec_id": "204",
                                            "peak_id": "58",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "24",
                                            "ion_display_position": "24",
                                            "spec_id": "204",
                                            "peak_id": "71",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "25",
                                        "ion_display_position": "17",
                                        "spec_id": "204",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "26",
                                        "ion_display_position": "16",
                                        "spec_id": "204",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "27",
                                            "ion_display_position": "15",
                                            "spec_id": "204",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "204",
                                            "peak_id": "55",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "204",
                                            "peak_id": "29",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "28",
                                            "ion_display_position": "14",
                                            "spec_id": "204",
                                            "peak_id": "10",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "29",
                                        "ion_display_position": "13",
                                        "spec_id": "204",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "30",
                                        "ion_display_position": "12",
                                        "spec_id": "204",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "11",
                                        "spec_id": "204",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "10",
                                        "spec_id": "204",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "9",
                                        "spec_id": "204",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "34",
                                        "ion_display_position": "8",
                                        "spec_id": "204",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "7",
                                        "spec_id": "204",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
