prsm_data =
{
    "protein": {
        "sequence_id": "34",
        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "34",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_id": "59",
            "prsm_number": "2",
            "prsm": [
                {
                    "prsm_id": "127",
                    "p_value": "0.09",
                    "e_value": "0.10",
                    "fdr": "0",
                    "matched_fragment_number": "7",
                    "matched_peak_number": "7",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "608",
                            "ms1_scans": "896",
                            "ids": "287",
                            "scans": "897",
                            "precursor_mono_mass": "9669.4981",
                            "precursor_charge": "5",
                            "precursor_mz": "1934.9069",
                            "feature_inte": "5.6702e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "34",
                        "proteoform_id": "59",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9669.6881",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "annotated_seq": "A.ANESAKDMT((C)[Carbamidomethylation]QEFIDLNPKAMTPVAWWMLHEETVYKGGDTVTLNETDLTQIPKVIEY(C)[Carbamidomethylation]KKN)[+496.2547]PQKNLYTFKNQASNDLPN.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "5",
                                            "ion_display_position": "5",
                                            "spec_id": "287",
                                            "peak_id": "38",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "287",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "287",
                                            "peak_id": "14",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "287",
                                            "peak_id": "12",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "61",
                                            "ion_display_position": "18",
                                            "spec_id": "287",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "12",
                                            "spec_id": "287",
                                            "peak_id": "43",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "10",
                                            "spec_id": "287",
                                            "peak_id": "30",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "38",
                                "right_position": "90",
                                "shift": "496.2547120337",
                                "anno": "+496.2547",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "148",
                    "p_value": "0.69",
                    "e_value": "1.05",
                    "fdr": "5.68e-03",
                    "matched_fragment_number": "7",
                    "matched_peak_number": "7",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "619",
                            "ms1_scans": "940",
                            "ids": "320",
                            "scans": "941",
                            "precursor_mono_mass": "9669.4981",
                            "precursor_charge": "5",
                            "precursor_mz": "1934.9069",
                            "feature_inte": "5.6702e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "34",
                        "proteoform_id": "59",
                        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                        "proteoform_mass": "9668.6858",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "108",
                            "first_residue_position": "29",
                            "last_residue_position": "107",
                            "annotated_seq": "A.ANESAKDMT((C)[Carbamidomethylation]QEFIDLNPKAMTPVAWWMLHEETVYKGGDTVTLNETDLTQIPKVIEY(C)[Carbamidomethylation]KKN)[+495.2524]PQKNLYTFKNQASNDLPN.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "I"
                                },
                                {
                                    "position": "3",
                                    "acid": "S"
                                },
                                {
                                    "position": "4",
                                    "acid": "S"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "R"
                                },
                                {
                                    "position": "7",
                                    "acid": "K"
                                },
                                {
                                    "position": "8",
                                    "acid": "A"
                                },
                                {
                                    "position": "9",
                                    "acid": "F"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "F"
                                },
                                {
                                    "position": "12",
                                    "acid": "M"
                                },
                                {
                                    "position": "13",
                                    "acid": "G"
                                },
                                {
                                    "position": "14",
                                    "acid": "A"
                                },
                                {
                                    "position": "15",
                                    "acid": "V"
                                },
                                {
                                    "position": "16",
                                    "acid": "A"
                                },
                                {
                                    "position": "17",
                                    "acid": "A"
                                },
                                {
                                    "position": "18",
                                    "acid": "L"
                                },
                                {
                                    "position": "19",
                                    "acid": "S"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "V"
                                },
                                {
                                    "position": "22",
                                    "acid": "N"
                                },
                                {
                                    "position": "23",
                                    "acid": "A"
                                },
                                {
                                    "position": "24",
                                    "acid": "Q"
                                },
                                {
                                    "position": "25",
                                    "acid": "S"
                                },
                                {
                                    "position": "26",
                                    "acid": "A"
                                },
                                {
                                    "position": "27",
                                    "acid": "L"
                                },
                                {
                                    "position": "28",
                                    "acid": "A"
                                },
                                {
                                    "position": "29",
                                    "acid": "A"
                                },
                                {
                                    "position": "30",
                                    "acid": "N"
                                },
                                {
                                    "position": "31",
                                    "acid": "E"
                                },
                                {
                                    "position": "32",
                                    "acid": "S"
                                },
                                {
                                    "position": "33",
                                    "acid": "A"
                                },
                                {
                                    "position": "34",
                                    "acid": "K"
                                },
                                {
                                    "position": "35",
                                    "acid": "D"
                                },
                                {
                                    "position": "36",
                                    "acid": "M"
                                },
                                {
                                    "position": "37",
                                    "acid": "T"
                                },
                                {
                                    "position": "38",
                                    "acid": "C"
                                },
                                {
                                    "position": "39",
                                    "acid": "Q"
                                },
                                {
                                    "position": "40",
                                    "acid": "E"
                                },
                                {
                                    "position": "41",
                                    "acid": "F"
                                },
                                {
                                    "position": "42",
                                    "acid": "I"
                                },
                                {
                                    "position": "43",
                                    "acid": "D"
                                },
                                {
                                    "position": "44",
                                    "acid": "L"
                                },
                                {
                                    "position": "45",
                                    "acid": "N"
                                },
                                {
                                    "position": "46",
                                    "acid": "P"
                                },
                                {
                                    "position": "47",
                                    "acid": "K"
                                },
                                {
                                    "position": "48",
                                    "acid": "A"
                                },
                                {
                                    "position": "49",
                                    "acid": "M"
                                },
                                {
                                    "position": "50",
                                    "acid": "T"
                                },
                                {
                                    "position": "51",
                                    "acid": "P"
                                },
                                {
                                    "position": "52",
                                    "acid": "V"
                                },
                                {
                                    "position": "53",
                                    "acid": "A"
                                },
                                {
                                    "position": "54",
                                    "acid": "W"
                                },
                                {
                                    "position": "55",
                                    "acid": "W"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "H"
                                },
                                {
                                    "position": "59",
                                    "acid": "E"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "T"
                                },
                                {
                                    "position": "62",
                                    "acid": "V"
                                },
                                {
                                    "position": "63",
                                    "acid": "Y"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "G"
                                },
                                {
                                    "position": "66",
                                    "acid": "G"
                                },
                                {
                                    "position": "67",
                                    "acid": "D"
                                },
                                {
                                    "position": "68",
                                    "acid": "T"
                                },
                                {
                                    "position": "69",
                                    "acid": "V"
                                },
                                {
                                    "position": "70",
                                    "acid": "T"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "N"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "T"
                                },
                                {
                                    "position": "75",
                                    "acid": "D"
                                },
                                {
                                    "position": "76",
                                    "acid": "L"
                                },
                                {
                                    "position": "77",
                                    "acid": "T"
                                },
                                {
                                    "position": "78",
                                    "acid": "Q"
                                },
                                {
                                    "position": "79",
                                    "acid": "I"
                                },
                                {
                                    "position": "80",
                                    "acid": "P"
                                },
                                {
                                    "position": "81",
                                    "acid": "K"
                                },
                                {
                                    "position": "82",
                                    "acid": "V"
                                },
                                {
                                    "position": "83",
                                    "acid": "I"
                                },
                                {
                                    "position": "84",
                                    "acid": "E"
                                },
                                {
                                    "position": "85",
                                    "acid": "Y"
                                },
                                {
                                    "position": "86",
                                    "acid": "C"
                                },
                                {
                                    "position": "87",
                                    "acid": "K"
                                },
                                {
                                    "position": "88",
                                    "acid": "K"
                                },
                                {
                                    "position": "89",
                                    "acid": "N"
                                },
                                {
                                    "position": "90",
                                    "acid": "P"
                                },
                                {
                                    "position": "91",
                                    "acid": "Q"
                                },
                                {
                                    "position": "92",
                                    "acid": "K"
                                },
                                {
                                    "position": "93",
                                    "acid": "N"
                                },
                                {
                                    "position": "94",
                                    "acid": "L"
                                },
                                {
                                    "position": "95",
                                    "acid": "Y"
                                },
                                {
                                    "position": "96",
                                    "acid": "T"
                                },
                                {
                                    "position": "97",
                                    "acid": "F"
                                },
                                {
                                    "position": "98",
                                    "acid": "K"
                                },
                                {
                                    "position": "99",
                                    "acid": "N"
                                },
                                {
                                    "position": "100",
                                    "acid": "Q"
                                },
                                {
                                    "position": "101",
                                    "acid": "A"
                                },
                                {
                                    "position": "102",
                                    "acid": "S"
                                },
                                {
                                    "position": "103",
                                    "acid": "N"
                                },
                                {
                                    "position": "104",
                                    "acid": "D"
                                },
                                {
                                    "position": "105",
                                    "acid": "L"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "N"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "320",
                                            "peak_id": "36",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "8",
                                            "ion_display_position": "8",
                                            "spec_id": "320",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "9",
                                            "ion_display_position": "9",
                                            "spec_id": "320",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "61",
                                            "ion_display_position": "18",
                                            "spec_id": "320",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "67",
                                            "ion_display_position": "12",
                                            "spec_id": "320",
                                            "peak_id": "24",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "68",
                                            "ion_display_position": "11",
                                            "spec_id": "320",
                                            "peak_id": "26",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "10",
                                            "spec_id": "320",
                                            "peak_id": "41",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": [
                                    {
                                        "left_pos": "38",
                                        "right_pos": "39",
                                        "anno": "C"
                                    },
                                    {
                                        "left_pos": "86",
                                        "right_pos": "87",
                                        "anno": "C"
                                    }
                                ]
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "38",
                                "right_position": "90",
                                "shift": "495.2523620337",
                                "anno": "+495.2524",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            ]
        }
    }
}
