prsm_data =
{
    "prsm": {
        "prsm_id": "57",
        "p_value": "0.04",
        "e_value": "0.05",
        "fdr": "0",
        "matched_fragment_number": "6",
        "matched_peak_number": "6",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                "ms1_ids": "569",
                "ms1_scans": "741",
                "ids": "173",
                "scans": "744",
                "precursor_mono_mass": "18332.2845",
                "precursor_charge": "8",
                "precursor_mz": "2292.5428",
                "feature_inte": "3.4575e+06"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "173",
                        "peak_id": "0",
                        "monoisotopic_mass": "2291.2855",
                        "monoisotopic_mz": "2292.2928",
                        "intensity": "2806.94",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "1",
                        "monoisotopic_mass": "1686.7531",
                        "monoisotopic_mz": "1687.7604",
                        "intensity": "5072.01",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1686.7445",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "ion_sort_name": "B00016",
                                "ion_left_position": "16",
                                "mass_error": "0.0086",
                                "ppm": "5.09"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "2",
                        "monoisotopic_mass": "2612.3092",
                        "monoisotopic_mz": "2613.3164",
                        "intensity": "2989.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "3",
                        "monoisotopic_mass": "1315.7885",
                        "monoisotopic_mz": "1316.7958",
                        "intensity": "13577.07",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1315.7823",
                                "ion_position": "161",
                                "ion_display_position": "12",
                                "ion_sort_name": "Y00012",
                                "ion_left_position": "161",
                                "mass_error": "0.0062",
                                "ppm": "4.67"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "4",
                        "monoisotopic_mass": "3012.2759",
                        "monoisotopic_mz": "3013.2831",
                        "intensity": "1666.68",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3012.2825",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "-0.0067",
                                "ppm": "-2.22"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "5",
                        "monoisotopic_mass": "1498.8210",
                        "monoisotopic_mz": "1499.8282",
                        "intensity": "1289.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "6",
                        "monoisotopic_mass": "1656.8175",
                        "monoisotopic_mz": "1657.8248",
                        "intensity": "3082.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "7",
                        "monoisotopic_mass": "3928.1081",
                        "monoisotopic_mz": "1965.0613",
                        "intensity": "5555.57",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3928.0865",
                                "ion_position": "135",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "135",
                                "mass_error": "0.0215",
                                "ppm": "5.48"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "8",
                        "monoisotopic_mass": "1068.6351",
                        "monoisotopic_mz": "1069.6423",
                        "intensity": "1734.62",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "9",
                        "monoisotopic_mass": "1576.8276",
                        "monoisotopic_mz": "1577.8348",
                        "intensity": "1869.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "10",
                        "monoisotopic_mass": "2229.1654",
                        "monoisotopic_mz": "2230.1726",
                        "intensity": "2013.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "11",
                        "monoisotopic_mass": "1032.5401",
                        "monoisotopic_mz": "1033.5474",
                        "intensity": "2541.35",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "12",
                        "monoisotopic_mass": "2356.3553",
                        "monoisotopic_mz": "1179.1849",
                        "intensity": "2630.25",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2356.3438",
                                "ion_position": "151",
                                "ion_display_position": "22",
                                "ion_sort_name": "Y00022",
                                "ion_left_position": "151",
                                "mass_error": "0.0115",
                                "ppm": "4.87"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "13",
                        "monoisotopic_mass": "1297.7779",
                        "monoisotopic_mz": "1298.7852",
                        "intensity": "1043.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "14",
                        "monoisotopic_mass": "1461.7997",
                        "monoisotopic_mz": "1462.8070",
                        "intensity": "737.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "15",
                        "monoisotopic_mass": "2355.3486",
                        "monoisotopic_mz": "2356.3559",
                        "intensity": "1691.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "16",
                        "monoisotopic_mass": "2954.5895",
                        "monoisotopic_mz": "1478.3020",
                        "intensity": "1934.20",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "17",
                        "monoisotopic_mass": "2481.2687",
                        "monoisotopic_mz": "2482.2760",
                        "intensity": "2001.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "18",
                        "monoisotopic_mass": "2743.4340",
                        "monoisotopic_mz": "2744.4413",
                        "intensity": "1681.68",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "19",
                        "monoisotopic_mass": "2971.6040",
                        "monoisotopic_mz": "1486.8093",
                        "intensity": "5690.07",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "20",
                        "monoisotopic_mass": "1926.2520",
                        "monoisotopic_mz": "1927.2592",
                        "intensity": "1064.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "21",
                        "monoisotopic_mass": "4280.0223",
                        "monoisotopic_mz": "2141.0184",
                        "intensity": "1818.52",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4280.0325",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "-0.0103",
                                "ppm": "-2.40"
                            }
                        }
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "22",
                        "monoisotopic_mass": "3798.9985",
                        "monoisotopic_mz": "1900.5065",
                        "intensity": "599.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "23",
                        "monoisotopic_mass": "10656.6189",
                        "monoisotopic_mz": "2132.3310",
                        "intensity": "1360.47",
                        "charge": "5"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "24",
                        "monoisotopic_mass": "9531.0379",
                        "monoisotopic_mz": "2383.7668",
                        "intensity": "1472.70",
                        "charge": "4"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "25",
                        "monoisotopic_mass": "4977.5460",
                        "monoisotopic_mz": "2489.7803",
                        "intensity": "1313.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "26",
                        "monoisotopic_mass": "8866.6207",
                        "monoisotopic_mz": "2217.6624",
                        "intensity": "589.46",
                        "charge": "4"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "27",
                        "monoisotopic_mass": "9370.0555",
                        "monoisotopic_mz": "2343.5212",
                        "intensity": "1946.06",
                        "charge": "4"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "28",
                        "monoisotopic_mass": "3909.0842",
                        "monoisotopic_mz": "1955.5494",
                        "intensity": "2837.57",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "29",
                        "monoisotopic_mass": "4468.2682",
                        "monoisotopic_mz": "2235.1414",
                        "intensity": "1167.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "173",
                        "peak_id": "30",
                        "monoisotopic_mass": "13783.4849",
                        "monoisotopic_mz": "1970.0765",
                        "intensity": "808.57",
                        "charge": "7"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "18",
            "proteoform_id": "56",
            "sequence_name": "sp|P0AFH8|OSMY_ECOLI",
            "sequence_description": "Osmotically-inducible protein Y OS=Escherichia coli (strain K12) OX=83333 GN=osmY PE=1 SV=1",
            "proteoform_mass": "18333.6519",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "201",
                "first_residue_position": "28",
                "last_residue_position": "200",
                "annotated_seq": "A.ENNAQTTNESAGQKVDSSMNKVGNFMDDSAITAKVKAALVD(HDNIKSTDISVKTDQKVVTLSGFVESQAQAEEAVKVAKGVEGVTSVSDKLHVRDAKEGSVKGYAGDTATTSEIKAKLLADDIVPSRHVKVETTD)[+183.3550]GVVQLSGTVDSQAQSDRAESIAKAVDGVKSVKNDLKTK.",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "T"
                    },
                    {
                        "position": "2",
                        "acid": "M"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "R"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "K"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "S"
                    },
                    {
                        "position": "9",
                        "acid": "K"
                    },
                    {
                        "position": "10",
                        "acid": "T"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "V"
                    },
                    {
                        "position": "15",
                        "acid": "M"
                    },
                    {
                        "position": "16",
                        "acid": "L"
                    },
                    {
                        "position": "17",
                        "acid": "T"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "A"
                    },
                    {
                        "position": "20",
                        "acid": "V"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "T"
                    },
                    {
                        "position": "23",
                        "acid": "G"
                    },
                    {
                        "position": "24",
                        "acid": "S"
                    },
                    {
                        "position": "25",
                        "acid": "A"
                    },
                    {
                        "position": "26",
                        "acid": "Y"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "E"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "A"
                    },
                    {
                        "position": "32",
                        "acid": "Q"
                    },
                    {
                        "position": "33",
                        "acid": "T"
                    },
                    {
                        "position": "34",
                        "acid": "T"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "E"
                    },
                    {
                        "position": "37",
                        "acid": "S"
                    },
                    {
                        "position": "38",
                        "acid": "A"
                    },
                    {
                        "position": "39",
                        "acid": "G"
                    },
                    {
                        "position": "40",
                        "acid": "Q"
                    },
                    {
                        "position": "41",
                        "acid": "K"
                    },
                    {
                        "position": "42",
                        "acid": "V"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "S"
                    },
                    {
                        "position": "45",
                        "acid": "S"
                    },
                    {
                        "position": "46",
                        "acid": "M"
                    },
                    {
                        "position": "47",
                        "acid": "N"
                    },
                    {
                        "position": "48",
                        "acid": "K"
                    },
                    {
                        "position": "49",
                        "acid": "V"
                    },
                    {
                        "position": "50",
                        "acid": "G"
                    },
                    {
                        "position": "51",
                        "acid": "N"
                    },
                    {
                        "position": "52",
                        "acid": "F"
                    },
                    {
                        "position": "53",
                        "acid": "M"
                    },
                    {
                        "position": "54",
                        "acid": "D"
                    },
                    {
                        "position": "55",
                        "acid": "D"
                    },
                    {
                        "position": "56",
                        "acid": "S"
                    },
                    {
                        "position": "57",
                        "acid": "A"
                    },
                    {
                        "position": "58",
                        "acid": "I"
                    },
                    {
                        "position": "59",
                        "acid": "T"
                    },
                    {
                        "position": "60",
                        "acid": "A"
                    },
                    {
                        "position": "61",
                        "acid": "K"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "K"
                    },
                    {
                        "position": "64",
                        "acid": "A"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "L"
                    },
                    {
                        "position": "67",
                        "acid": "V"
                    },
                    {
                        "position": "68",
                        "acid": "D"
                    },
                    {
                        "position": "69",
                        "acid": "H"
                    },
                    {
                        "position": "70",
                        "acid": "D"
                    },
                    {
                        "position": "71",
                        "acid": "N"
                    },
                    {
                        "position": "72",
                        "acid": "I"
                    },
                    {
                        "position": "73",
                        "acid": "K"
                    },
                    {
                        "position": "74",
                        "acid": "S"
                    },
                    {
                        "position": "75",
                        "acid": "T"
                    },
                    {
                        "position": "76",
                        "acid": "D"
                    },
                    {
                        "position": "77",
                        "acid": "I"
                    },
                    {
                        "position": "78",
                        "acid": "S"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "K"
                    },
                    {
                        "position": "81",
                        "acid": "T"
                    },
                    {
                        "position": "82",
                        "acid": "D"
                    },
                    {
                        "position": "83",
                        "acid": "Q"
                    },
                    {
                        "position": "84",
                        "acid": "K"
                    },
                    {
                        "position": "85",
                        "acid": "V"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "L"
                    },
                    {
                        "position": "89",
                        "acid": "S"
                    },
                    {
                        "position": "90",
                        "acid": "G"
                    },
                    {
                        "position": "91",
                        "acid": "F"
                    },
                    {
                        "position": "92",
                        "acid": "V"
                    },
                    {
                        "position": "93",
                        "acid": "E"
                    },
                    {
                        "position": "94",
                        "acid": "S"
                    },
                    {
                        "position": "95",
                        "acid": "Q"
                    },
                    {
                        "position": "96",
                        "acid": "A"
                    },
                    {
                        "position": "97",
                        "acid": "Q"
                    },
                    {
                        "position": "98",
                        "acid": "A"
                    },
                    {
                        "position": "99",
                        "acid": "E"
                    },
                    {
                        "position": "100",
                        "acid": "E"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "V"
                    },
                    {
                        "position": "103",
                        "acid": "K"
                    },
                    {
                        "position": "104",
                        "acid": "V"
                    },
                    {
                        "position": "105",
                        "acid": "A"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "G"
                    },
                    {
                        "position": "108",
                        "acid": "V"
                    },
                    {
                        "position": "109",
                        "acid": "E"
                    },
                    {
                        "position": "110",
                        "acid": "G"
                    },
                    {
                        "position": "111",
                        "acid": "V"
                    },
                    {
                        "position": "112",
                        "acid": "T"
                    },
                    {
                        "position": "113",
                        "acid": "S"
                    },
                    {
                        "position": "114",
                        "acid": "V"
                    },
                    {
                        "position": "115",
                        "acid": "S"
                    },
                    {
                        "position": "116",
                        "acid": "D"
                    },
                    {
                        "position": "117",
                        "acid": "K"
                    },
                    {
                        "position": "118",
                        "acid": "L"
                    },
                    {
                        "position": "119",
                        "acid": "H"
                    },
                    {
                        "position": "120",
                        "acid": "V"
                    },
                    {
                        "position": "121",
                        "acid": "R"
                    },
                    {
                        "position": "122",
                        "acid": "D"
                    },
                    {
                        "position": "123",
                        "acid": "A"
                    },
                    {
                        "position": "124",
                        "acid": "K"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "G"
                    },
                    {
                        "position": "127",
                        "acid": "S"
                    },
                    {
                        "position": "128",
                        "acid": "V"
                    },
                    {
                        "position": "129",
                        "acid": "K"
                    },
                    {
                        "position": "130",
                        "acid": "G"
                    },
                    {
                        "position": "131",
                        "acid": "Y"
                    },
                    {
                        "position": "132",
                        "acid": "A"
                    },
                    {
                        "position": "133",
                        "acid": "G"
                    },
                    {
                        "position": "134",
                        "acid": "D"
                    },
                    {
                        "position": "135",
                        "acid": "T"
                    },
                    {
                        "position": "136",
                        "acid": "A"
                    },
                    {
                        "position": "137",
                        "acid": "T"
                    },
                    {
                        "position": "138",
                        "acid": "T"
                    },
                    {
                        "position": "139",
                        "acid": "S"
                    },
                    {
                        "position": "140",
                        "acid": "E"
                    },
                    {
                        "position": "141",
                        "acid": "I"
                    },
                    {
                        "position": "142",
                        "acid": "K"
                    },
                    {
                        "position": "143",
                        "acid": "A"
                    },
                    {
                        "position": "144",
                        "acid": "K"
                    },
                    {
                        "position": "145",
                        "acid": "L"
                    },
                    {
                        "position": "146",
                        "acid": "L"
                    },
                    {
                        "position": "147",
                        "acid": "A"
                    },
                    {
                        "position": "148",
                        "acid": "D"
                    },
                    {
                        "position": "149",
                        "acid": "D"
                    },
                    {
                        "position": "150",
                        "acid": "I"
                    },
                    {
                        "position": "151",
                        "acid": "V"
                    },
                    {
                        "position": "152",
                        "acid": "P"
                    },
                    {
                        "position": "153",
                        "acid": "S"
                    },
                    {
                        "position": "154",
                        "acid": "R"
                    },
                    {
                        "position": "155",
                        "acid": "H"
                    },
                    {
                        "position": "156",
                        "acid": "V"
                    },
                    {
                        "position": "157",
                        "acid": "K"
                    },
                    {
                        "position": "158",
                        "acid": "V"
                    },
                    {
                        "position": "159",
                        "acid": "E"
                    },
                    {
                        "position": "160",
                        "acid": "T"
                    },
                    {
                        "position": "161",
                        "acid": "T"
                    },
                    {
                        "position": "162",
                        "acid": "D"
                    },
                    {
                        "position": "163",
                        "acid": "G"
                    },
                    {
                        "position": "164",
                        "acid": "V"
                    },
                    {
                        "position": "165",
                        "acid": "V"
                    },
                    {
                        "position": "166",
                        "acid": "Q"
                    },
                    {
                        "position": "167",
                        "acid": "L"
                    },
                    {
                        "position": "168",
                        "acid": "S"
                    },
                    {
                        "position": "169",
                        "acid": "G"
                    },
                    {
                        "position": "170",
                        "acid": "T"
                    },
                    {
                        "position": "171",
                        "acid": "V"
                    },
                    {
                        "position": "172",
                        "acid": "D"
                    },
                    {
                        "position": "173",
                        "acid": "S"
                    },
                    {
                        "position": "174",
                        "acid": "Q"
                    },
                    {
                        "position": "175",
                        "acid": "A"
                    },
                    {
                        "position": "176",
                        "acid": "Q"
                    },
                    {
                        "position": "177",
                        "acid": "S"
                    },
                    {
                        "position": "178",
                        "acid": "D"
                    },
                    {
                        "position": "179",
                        "acid": "R"
                    },
                    {
                        "position": "180",
                        "acid": "A"
                    },
                    {
                        "position": "181",
                        "acid": "E"
                    },
                    {
                        "position": "182",
                        "acid": "S"
                    },
                    {
                        "position": "183",
                        "acid": "I"
                    },
                    {
                        "position": "184",
                        "acid": "A"
                    },
                    {
                        "position": "185",
                        "acid": "K"
                    },
                    {
                        "position": "186",
                        "acid": "A"
                    },
                    {
                        "position": "187",
                        "acid": "V"
                    },
                    {
                        "position": "188",
                        "acid": "D"
                    },
                    {
                        "position": "189",
                        "acid": "G"
                    },
                    {
                        "position": "190",
                        "acid": "V"
                    },
                    {
                        "position": "191",
                        "acid": "K"
                    },
                    {
                        "position": "192",
                        "acid": "S"
                    },
                    {
                        "position": "193",
                        "acid": "V"
                    },
                    {
                        "position": "194",
                        "acid": "K"
                    },
                    {
                        "position": "195",
                        "acid": "N"
                    },
                    {
                        "position": "196",
                        "acid": "D"
                    },
                    {
                        "position": "197",
                        "acid": "L"
                    },
                    {
                        "position": "198",
                        "acid": "K"
                    },
                    {
                        "position": "199",
                        "acid": "T"
                    },
                    {
                        "position": "200",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "spec_id": "173",
                                "peak_id": "1",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "spec_id": "173",
                                "peak_id": "4",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "173",
                                "peak_id": "21",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "150",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "151",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "152",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "153",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "154",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "155",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "156",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "157",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "158",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "159",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "160",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "161",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "162",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "163",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "135",
                                "ion_display_position": "38",
                                "spec_id": "173",
                                "peak_id": "7",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "164",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "165",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "166",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "167",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "168",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "169",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "170",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "171",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "172",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "173",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "174",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "175",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "176",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "177",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "178",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "179",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "151",
                                "ion_display_position": "22",
                                "spec_id": "173",
                                "peak_id": "12",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "180",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "181",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "182",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "183",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "184",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "185",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "186",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "187",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "188",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "189",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "161",
                                "ion_display_position": "12",
                                "spec_id": "173",
                                "peak_id": "3",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "190",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "191",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "192",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "193",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "194",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "195",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "196",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "197",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "198",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "199",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "200",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "201",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "69",
                    "right_position": "163",
                    "shift": "183.3549633234",
                    "anno": "+183.3550",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
