prsm_data =
{
    "prsm": {
        "prsm_id": "126",
        "p_value": "0.09",
        "e_value": "0.10",
        "fdr": "0",
        "matched_fragment_number": "7",
        "matched_peak_number": "7",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                "ms1_ids": "608",
                "ms1_scans": "896",
                "ids": "287",
                "scans": "897",
                "precursor_mono_mass": "9669.4981",
                "precursor_charge": "5",
                "precursor_mz": "1934.9069",
                "feature_inte": "5.6702e+07"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "287",
                        "peak_id": "0",
                        "monoisotopic_mass": "1864.0826",
                        "monoisotopic_mz": "1865.0899",
                        "intensity": "4987.37",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "1",
                        "monoisotopic_mass": "2006.9725",
                        "monoisotopic_mz": "2007.9798",
                        "intensity": "1184.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "2",
                        "monoisotopic_mass": "2298.1283",
                        "monoisotopic_mz": "2299.1355",
                        "intensity": "2051.39",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "3",
                        "monoisotopic_mass": "1987.7727",
                        "monoisotopic_mz": "1988.7799",
                        "intensity": "3106.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "4",
                        "monoisotopic_mass": "1714.6683",
                        "monoisotopic_mz": "1715.6755",
                        "intensity": "1267.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "5",
                        "monoisotopic_mass": "2074.0186",
                        "monoisotopic_mz": "2075.0259",
                        "intensity": "4383.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "6",
                        "monoisotopic_mass": "1548.7875",
                        "monoisotopic_mz": "1549.7948",
                        "intensity": "1620.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "7",
                        "monoisotopic_mass": "981.5172",
                        "monoisotopic_mz": "982.5245",
                        "intensity": "1876.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "8",
                        "monoisotopic_mass": "2091.0506",
                        "monoisotopic_mz": "2092.0579",
                        "intensity": "4398.55",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2091.0385",
                                "ion_position": "61",
                                "ion_display_position": "18",
                                "ion_sort_name": "Y00018",
                                "ion_left_position": "61",
                                "mass_error": "0.0121",
                                "ppm": "5.79"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "9",
                        "monoisotopic_mass": "2171.0552",
                        "monoisotopic_mz": "2172.0624",
                        "intensity": "1880.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "10",
                        "monoisotopic_mass": "2214.8927",
                        "monoisotopic_mz": "2215.8999",
                        "intensity": "4533.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "11",
                        "monoisotopic_mass": "1428.8168",
                        "monoisotopic_mz": "1429.8241",
                        "intensity": "1366.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "12",
                        "monoisotopic_mass": "947.4065",
                        "monoisotopic_mz": "948.4138",
                        "intensity": "2164.55",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "947.4018",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "0.0047",
                                "ppm": "4.95"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "13",
                        "monoisotopic_mass": "1748.8573",
                        "monoisotopic_mz": "1749.8646",
                        "intensity": "1716.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "14",
                        "monoisotopic_mass": "846.3586",
                        "monoisotopic_mz": "847.3659",
                        "intensity": "2546.06",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "846.3542",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0045",
                                "ppm": "5.27"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "15",
                        "monoisotopic_mass": "1507.7258",
                        "monoisotopic_mz": "1508.7330",
                        "intensity": "1600.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "16",
                        "monoisotopic_mass": "1411.7211",
                        "monoisotopic_mz": "1412.7284",
                        "intensity": "1870.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "17",
                        "monoisotopic_mass": "2196.8700",
                        "monoisotopic_mz": "2197.8772",
                        "intensity": "2064.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "18",
                        "monoisotopic_mass": "1298.6363",
                        "monoisotopic_mz": "1299.6436",
                        "intensity": "1164.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "19",
                        "monoisotopic_mass": "1483.5431",
                        "monoisotopic_mz": "1484.5504",
                        "intensity": "1547.46",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "20",
                        "monoisotopic_mass": "715.3172",
                        "monoisotopic_mz": "716.3245",
                        "intensity": "5322.11",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "715.3137",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "ion_sort_name": "B00007",
                                "ion_left_position": "7",
                                "mass_error": "0.0035",
                                "ppm": "4.90"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "21",
                        "monoisotopic_mass": "1797.1336",
                        "monoisotopic_mz": "1798.1409",
                        "intensity": "1574.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "22",
                        "monoisotopic_mass": "1278.5904",
                        "monoisotopic_mz": "1279.5977",
                        "intensity": "1252.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "23",
                        "monoisotopic_mass": "1020.5058",
                        "monoisotopic_mz": "1021.5131",
                        "intensity": "956.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "24",
                        "monoisotopic_mass": "697.3063",
                        "monoisotopic_mz": "698.3136",
                        "intensity": "1369.98",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "25",
                        "monoisotopic_mass": "870.4230",
                        "monoisotopic_mz": "871.4303",
                        "intensity": "1219.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "26",
                        "monoisotopic_mass": "770.3602",
                        "monoisotopic_mz": "771.3675",
                        "intensity": "1926.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "27",
                        "monoisotopic_mass": "729.4097",
                        "monoisotopic_mz": "730.4169",
                        "intensity": "1389.60",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "28",
                        "monoisotopic_mass": "1056.6048",
                        "monoisotopic_mz": "1057.6121",
                        "intensity": "890.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "29",
                        "monoisotopic_mass": "528.2756",
                        "monoisotopic_mz": "529.2829",
                        "intensity": "2923.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "30",
                        "monoisotopic_mass": "1099.5285",
                        "monoisotopic_mz": "1100.5358",
                        "intensity": "1435.42",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1099.5258",
                                "ion_position": "69",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "69",
                                "mass_error": "0.0027",
                                "ppm": "2.45"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "31",
                        "monoisotopic_mass": "1188.5339",
                        "monoisotopic_mz": "1189.5411",
                        "intensity": "625.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "32",
                        "monoisotopic_mass": "1149.5480",
                        "monoisotopic_mz": "1150.5553",
                        "intensity": "789.58",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "33",
                        "monoisotopic_mass": "3128.5387",
                        "monoisotopic_mz": "1565.2766",
                        "intensity": "1388.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "34",
                        "monoisotopic_mass": "1230.5826",
                        "monoisotopic_mz": "1231.5898",
                        "intensity": "900.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "35",
                        "monoisotopic_mass": "3452.7072",
                        "monoisotopic_mz": "1727.3609",
                        "intensity": "1850.72",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "36",
                        "monoisotopic_mass": "510.2649",
                        "monoisotopic_mz": "511.2722",
                        "intensity": "917.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "37",
                        "monoisotopic_mass": "3369.6765",
                        "monoisotopic_mz": "1685.8455",
                        "intensity": "2404.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "38",
                        "monoisotopic_mass": "472.1937",
                        "monoisotopic_mz": "473.2010",
                        "intensity": "1453.60",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "472.1918",
                                "ion_position": "5",
                                "ion_display_position": "5",
                                "ion_sort_name": "B00005",
                                "ion_left_position": "5",
                                "mass_error": "0.0019",
                                "ppm": "4.09"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "39",
                        "monoisotopic_mass": "795.4351",
                        "monoisotopic_mz": "796.4423",
                        "intensity": "1321.49",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "40",
                        "monoisotopic_mass": "639.3197",
                        "monoisotopic_mz": "640.3270",
                        "intensity": "823.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "41",
                        "monoisotopic_mass": "5790.4747",
                        "monoisotopic_mz": "1931.1655",
                        "intensity": "2561.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "42",
                        "monoisotopic_mass": "4261.3417",
                        "monoisotopic_mz": "1421.4545",
                        "intensity": "1635.21",
                        "charge": "3"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "43",
                        "monoisotopic_mass": "1347.6495",
                        "monoisotopic_mz": "1348.6567",
                        "intensity": "978.82",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1347.6419",
                                "ion_position": "67",
                                "ion_display_position": "12",
                                "ion_sort_name": "Y00012",
                                "ion_left_position": "67",
                                "mass_error": "0.0076",
                                "ppm": "5.62"
                            }
                        }
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "44",
                        "monoisotopic_mass": "3598.7495",
                        "monoisotopic_mz": "1800.3820",
                        "intensity": "2649.50",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "45",
                        "monoisotopic_mass": "3470.7465",
                        "monoisotopic_mz": "1736.3805",
                        "intensity": "970.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "46",
                        "monoisotopic_mass": "1941.8075",
                        "monoisotopic_mz": "1942.8147",
                        "intensity": "1852.58",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "47",
                        "monoisotopic_mass": "4277.3645",
                        "monoisotopic_mz": "1426.7955",
                        "intensity": "1165.64",
                        "charge": "3"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "48",
                        "monoisotopic_mass": "3810.9097",
                        "monoisotopic_mz": "1906.4622",
                        "intensity": "2029.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "49",
                        "monoisotopic_mass": "2332.1784",
                        "monoisotopic_mz": "2333.1857",
                        "intensity": "1120.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "50",
                        "monoisotopic_mass": "2315.1535",
                        "monoisotopic_mz": "2316.1608",
                        "intensity": "1255.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "51",
                        "monoisotopic_mass": "6826.7623",
                        "monoisotopic_mz": "1707.6978",
                        "intensity": "4276.16",
                        "charge": "4"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "52",
                        "monoisotopic_mass": "3580.7523",
                        "monoisotopic_mz": "1791.3834",
                        "intensity": "4268.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "53",
                        "monoisotopic_mass": "3307.6467",
                        "monoisotopic_mz": "1654.8306",
                        "intensity": "1773.11",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "54",
                        "monoisotopic_mass": "5845.1938",
                        "monoisotopic_mz": "1462.3057",
                        "intensity": "3013.88",
                        "charge": "4"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "55",
                        "monoisotopic_mass": "3766.8612",
                        "monoisotopic_mz": "1884.4379",
                        "intensity": "618.46",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "56",
                        "monoisotopic_mass": "4035.0410",
                        "monoisotopic_mz": "2018.5278",
                        "intensity": "1124.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "57",
                        "monoisotopic_mass": "3434.6729",
                        "monoisotopic_mz": "1718.3437",
                        "intensity": "1527.97",
                        "charge": "2"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "58",
                        "monoisotopic_mass": "1883.3394",
                        "monoisotopic_mz": "1884.3466",
                        "intensity": "848.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "59",
                        "monoisotopic_mass": "6057.5160",
                        "monoisotopic_mz": "2020.1793",
                        "intensity": "1352.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "60",
                        "monoisotopic_mass": "5639.4948",
                        "monoisotopic_mz": "1880.8389",
                        "intensity": "1555.10",
                        "charge": "3"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "61",
                        "monoisotopic_mass": "7611.7719",
                        "monoisotopic_mz": "1903.9502",
                        "intensity": "754.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "287",
                        "peak_id": "62",
                        "monoisotopic_mass": "3716.9760",
                        "monoisotopic_mz": "1859.4953",
                        "intensity": "632.16",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "34",
            "proteoform_id": "59",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9669.6881",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "annotated_seq": "A.ANESAKDMT((C)[Carbamidomethylation]QEFIDLNPKAMTPVAWWMLHEETVYKGGDTVTLNETDLTQIPKVIEY(C)[Carbamidomethylation]KKN)[+496.2547]PQKNLYTFKNQASNDLPN.",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "5",
                                "ion_display_position": "5",
                                "spec_id": "287",
                                "peak_id": "38",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "spec_id": "287",
                                "peak_id": "20",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "287",
                                "peak_id": "14",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "287",
                                "peak_id": "12",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "61",
                                "ion_display_position": "18",
                                "spec_id": "287",
                                "peak_id": "8",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "67",
                                "ion_display_position": "12",
                                "spec_id": "287",
                                "peak_id": "43",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "69",
                                "ion_display_position": "10",
                                "spec_id": "287",
                                "peak_id": "30",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "38",
                    "right_position": "90",
                    "shift": "496.2547120337",
                    "anno": "+496.2547",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
