prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "1",
        "sequence_name": "sp|P0AA04|PTHP_ECOLI",
        "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
        "proteoform_id": "57",
        "prsm_number": "2",
        "prsm": [
            {
                "prsm_id": "93",
                "p_value": "0.05",
                "e_value": "0.06",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "589",
                        "ms1_scans": "821",
                        "ids": "232",
                        "scans": "823",
                        "precursor_mono_mass": "9097.7007",
                        "precursor_charge": "5",
                        "precursor_mz": "1820.5474",
                        "feature_inte": "2.5772e+06"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "232",
                                "peak_id": "0",
                                "monoisotopic_mass": "2454.1886",
                                "monoisotopic_mz": "2455.1958",
                                "intensity": "1653.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2454.1948",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0062",
                                        "ppm": "-2.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "1",
                                "monoisotopic_mass": "1722.3974",
                                "monoisotopic_mz": "1723.4047",
                                "intensity": "1694.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "2",
                                "monoisotopic_mass": "2259.2232",
                                "monoisotopic_mz": "1130.6189",
                                "intensity": "1165.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "3",
                                "monoisotopic_mass": "832.4405",
                                "monoisotopic_mz": "833.4478",
                                "intensity": "1081.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "832.4364",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0041",
                                        "ppm": "4.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "4",
                                "monoisotopic_mass": "3692.2846",
                                "monoisotopic_mz": "1847.1496",
                                "intensity": "1795.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "5",
                                "monoisotopic_mass": "663.2718",
                                "monoisotopic_mz": "664.2791",
                                "intensity": "1252.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "663.2686",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0032",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "6",
                                "monoisotopic_mass": "1149.0920",
                                "monoisotopic_mz": "1150.0992",
                                "intensity": "767.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "7",
                                "monoisotopic_mass": "2281.2067",
                                "monoisotopic_mz": "1141.6106",
                                "intensity": "2367.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "8",
                                "monoisotopic_mass": "1434.7424",
                                "monoisotopic_mz": "1435.7496",
                                "intensity": "1640.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "9",
                                "monoisotopic_mass": "1735.5024",
                                "monoisotopic_mz": "1736.5096",
                                "intensity": "964.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "10",
                                "monoisotopic_mass": "1162.7205",
                                "monoisotopic_mz": "1163.7278",
                                "intensity": "319.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "11",
                                "monoisotopic_mass": "1803.9253",
                                "monoisotopic_mz": "1804.9325",
                                "intensity": "1160.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "12",
                                "monoisotopic_mass": "5453.7995",
                                "monoisotopic_mz": "1818.9404",
                                "intensity": "5232.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "13",
                                "monoisotopic_mass": "1389.8606",
                                "monoisotopic_mz": "1390.8679",
                                "intensity": "314.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "14",
                                "monoisotopic_mass": "1310.7953",
                                "monoisotopic_mz": "1311.8026",
                                "intensity": "981.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "15",
                                "monoisotopic_mass": "4819.9505",
                                "monoisotopic_mz": "1607.6574",
                                "intensity": "1074.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "16",
                                "monoisotopic_mass": "1455.0137",
                                "monoisotopic_mz": "1456.0210",
                                "intensity": "334.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "17",
                                "monoisotopic_mass": "3258.6601",
                                "monoisotopic_mz": "1630.3373",
                                "intensity": "905.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "18",
                                "monoisotopic_mass": "762.3409",
                                "monoisotopic_mz": "763.3481",
                                "intensity": "553.99",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "762.3371",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0038",
                                        "ppm": "5.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "19",
                                "monoisotopic_mass": "1247.7707",
                                "monoisotopic_mz": "1248.7780",
                                "intensity": "373.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "20",
                                "monoisotopic_mass": "3060.5724",
                                "monoisotopic_mz": "1531.2935",
                                "intensity": "1090.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "21",
                                "monoisotopic_mass": "7661.6599",
                                "monoisotopic_mz": "1533.3393",
                                "intensity": "1117.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "22",
                                "monoisotopic_mass": "5417.7617",
                                "monoisotopic_mz": "1806.9279",
                                "intensity": "3645.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "23",
                                "monoisotopic_mass": "4806.3908",
                                "monoisotopic_mz": "1603.1375",
                                "intensity": "1834.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "24",
                                "monoisotopic_mass": "3865.9868",
                                "monoisotopic_mz": "1934.0007",
                                "intensity": "851.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "25",
                                "monoisotopic_mass": "6205.6425",
                                "monoisotopic_mz": "1552.4179",
                                "intensity": "580.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "26",
                                "monoisotopic_mass": "4851.6726",
                                "monoisotopic_mz": "1618.2315",
                                "intensity": "1140.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "27",
                                "monoisotopic_mass": "1789.9538",
                                "monoisotopic_mz": "1790.9611",
                                "intensity": "861.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "28",
                                "monoisotopic_mass": "3999.0264",
                                "monoisotopic_mz": "2000.5205",
                                "intensity": "550.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "29",
                                "monoisotopic_mass": "8553.2841",
                                "monoisotopic_mz": "1711.6641",
                                "intensity": "2013.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "30",
                                "monoisotopic_mass": "3345.8051",
                                "monoisotopic_mz": "1673.9098",
                                "intensity": "571.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "31",
                                "monoisotopic_mass": "5435.7764",
                                "monoisotopic_mz": "1812.9327",
                                "intensity": "4695.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "32",
                                "monoisotopic_mass": "1559.8313",
                                "monoisotopic_mz": "1560.8386",
                                "intensity": "759.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "33",
                                "monoisotopic_mass": "1829.2605",
                                "monoisotopic_mz": "1830.2678",
                                "intensity": "806.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "34",
                                "monoisotopic_mass": "7784.8279",
                                "monoisotopic_mz": "1557.9729",
                                "intensity": "565.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "35",
                                "monoisotopic_mass": "3604.2198",
                                "monoisotopic_mz": "1803.1172",
                                "intensity": "596.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "36",
                                "monoisotopic_mass": "6528.5111",
                                "monoisotopic_mz": "1306.7095",
                                "intensity": "745.62",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-16.9440374125",
                                        "theoretical_mass": "6529.5144",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "B00062",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "37",
                                "monoisotopic_mass": "7359.5588",
                                "monoisotopic_mz": "1472.9190",
                                "intensity": "606.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "38",
                                "monoisotopic_mass": "1275.1737",
                                "monoisotopic_mz": "1276.1810",
                                "intensity": "373.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "39",
                                "monoisotopic_mass": "8343.0801",
                                "monoisotopic_mz": "1669.6233",
                                "intensity": "1140.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "40",
                                "monoisotopic_mass": "6141.0876",
                                "monoisotopic_mz": "1536.2792",
                                "intensity": "1489.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "41",
                                "monoisotopic_mass": "1673.0263",
                                "monoisotopic_mz": "1674.0336",
                                "intensity": "816.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "42",
                                "monoisotopic_mass": "1488.2595",
                                "monoisotopic_mz": "1489.2667",
                                "intensity": "307.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "43",
                                "monoisotopic_mass": "4640.2965",
                                "monoisotopic_mz": "1547.7728",
                                "intensity": "559.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "44",
                                "monoisotopic_mass": "1417.7277",
                                "monoisotopic_mz": "1418.7350",
                                "intensity": "331.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "45",
                                "monoisotopic_mass": "5473.7969",
                                "monoisotopic_mz": "1369.4565",
                                "intensity": "683.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "46",
                                "monoisotopic_mass": "1626.0005",
                                "monoisotopic_mz": "1627.0078",
                                "intensity": "1236.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "47",
                                "monoisotopic_mass": "3491.1477",
                                "monoisotopic_mz": "1746.5811",
                                "intensity": "571.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "48",
                                "monoisotopic_mass": "7570.1045",
                                "monoisotopic_mz": "1515.0282",
                                "intensity": "653.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "49",
                                "monoisotopic_mass": "1376.7155",
                                "monoisotopic_mz": "1377.7228",
                                "intensity": "286.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "50",
                                "monoisotopic_mass": "1360.5187",
                                "monoisotopic_mz": "1361.5260",
                                "intensity": "317.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "51",
                                "monoisotopic_mass": "1401.9770",
                                "monoisotopic_mz": "1402.9843",
                                "intensity": "366.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "232",
                                "peak_id": "52",
                                "monoisotopic_mass": "1340.3245",
                                "monoisotopic_mz": "1341.3318",
                                "intensity": "298.37",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "57",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9096.7933",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "annotated_seq": ".MFQQEV(TITAPNGLHTRPAAQFVKEAKGFTSEITVTSNGKSASAKSLFKLQTLGLTQGTVVT)[-16.9440]ISAEGEDEQKAVEHLVKLMAELE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "232",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "232",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "spec_id": "232",
                                        "peak_id": "36",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "22",
                                        "spec_id": "232",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "spec_id": "232",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "6",
                            "right_position": "62",
                            "shift": "-16.9440374125",
                            "anno": "-16.9440",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "78",
                "p_value": "0.14",
                "e_value": "0.15",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "581",
                        "ms1_scans": "789",
                        "ids": "207",
                        "scans": "790",
                        "precursor_mono_mass": "9096.7542",
                        "precursor_charge": "8",
                        "precursor_mz": "1138.1016",
                        "feature_inte": "2.6302e+05"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "207",
                                "peak_id": "0",
                                "monoisotopic_mass": "1388.7403",
                                "monoisotopic_mz": "1389.7476",
                                "intensity": "2688.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "1",
                                "monoisotopic_mass": "1480.8042",
                                "monoisotopic_mz": "1481.8115",
                                "intensity": "2744.99",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1480.7960",
                                        "ion_position": "72",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0083",
                                        "ppm": "5.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "2",
                                "monoisotopic_mass": "1376.7217",
                                "monoisotopic_mz": "1377.7290",
                                "intensity": "2518.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "3",
                                "monoisotopic_mass": "663.2720",
                                "monoisotopic_mz": "664.2792",
                                "intensity": "4357.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "663.2686",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0033",
                                        "ppm": "4.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "4",
                                "monoisotopic_mass": "1094.6762",
                                "monoisotopic_mz": "1095.6835",
                                "intensity": "4194.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "5",
                                "monoisotopic_mass": "849.5281",
                                "monoisotopic_mz": "850.5353",
                                "intensity": "3959.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "6",
                                "monoisotopic_mass": "1281.1679",
                                "monoisotopic_mz": "1282.1752",
                                "intensity": "2129.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "7",
                                "monoisotopic_mass": "1181.6548",
                                "monoisotopic_mz": "1182.6621",
                                "intensity": "1895.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1181.6478",
                                        "ion_position": "75",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0070",
                                        "ppm": "5.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "8",
                                "monoisotopic_mass": "1727.0676",
                                "monoisotopic_mz": "864.5411",
                                "intensity": "3949.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "9",
                                "monoisotopic_mass": "1220.6685",
                                "monoisotopic_mz": "1221.6758",
                                "intensity": "1886.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "10",
                                "monoisotopic_mass": "832.4411",
                                "monoisotopic_mz": "833.4484",
                                "intensity": "4204.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "832.4364",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0047",
                                        "ppm": "5.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "11",
                                "monoisotopic_mass": "1432.7608",
                                "monoisotopic_mz": "1433.7681",
                                "intensity": "1708.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "12",
                                "monoisotopic_mass": "1629.0133",
                                "monoisotopic_mz": "815.5139",
                                "intensity": "3173.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "13",
                                "monoisotopic_mass": "1408.7461",
                                "monoisotopic_mz": "1409.7534",
                                "intensity": "1359.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "14",
                                "monoisotopic_mass": "875.5420",
                                "monoisotopic_mz": "876.5493",
                                "intensity": "4686.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "15",
                                "monoisotopic_mass": "965.5997",
                                "monoisotopic_mz": "966.6070",
                                "intensity": "3673.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "16",
                                "monoisotopic_mass": "577.3256",
                                "monoisotopic_mz": "578.3329",
                                "intensity": "1280.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "17",
                                "monoisotopic_mass": "1756.0902",
                                "monoisotopic_mz": "879.0524",
                                "intensity": "3754.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "18",
                                "monoisotopic_mass": "1661.0248",
                                "monoisotopic_mz": "831.5197",
                                "intensity": "3271.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "19",
                                "monoisotopic_mass": "2669.3189",
                                "monoisotopic_mz": "1335.6667",
                                "intensity": "3674.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "20",
                                "monoisotopic_mass": "444.2065",
                                "monoisotopic_mz": "445.2137",
                                "intensity": "2154.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "21",
                                "monoisotopic_mass": "406.1692",
                                "monoisotopic_mz": "407.1764",
                                "intensity": "5122.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "406.1675",
                                        "ion_position": "3",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "B00003",
                                        "ion_left_position": "3",
                                        "mass_error": "0.0017",
                                        "ppm": "4.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "22",
                                "monoisotopic_mass": "1299.6883",
                                "monoisotopic_mz": "1300.6956",
                                "intensity": "1183.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "23",
                                "monoisotopic_mass": "1582.9762",
                                "monoisotopic_mz": "792.4954",
                                "intensity": "1674.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "24",
                                "monoisotopic_mass": "6810.5579",
                                "monoisotopic_mz": "973.9441",
                                "intensity": "3030.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "25",
                                "monoisotopic_mass": "534.2287",
                                "monoisotopic_mz": "535.2360",
                                "intensity": "2062.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "534.2261",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0026",
                                        "ppm": "4.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "26",
                                "monoisotopic_mass": "1408.8736",
                                "monoisotopic_mz": "705.4441",
                                "intensity": "2226.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "27",
                                "monoisotopic_mass": "1171.7216",
                                "monoisotopic_mz": "586.8681",
                                "intensity": "556.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "28",
                                "monoisotopic_mass": "2852.5132",
                                "monoisotopic_mz": "1427.2639",
                                "intensity": "2819.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "29",
                                "monoisotopic_mass": "4696.8946",
                                "monoisotopic_mz": "783.8230",
                                "intensity": "1119.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "30",
                                "monoisotopic_mass": "550.2417",
                                "monoisotopic_mz": "551.2490",
                                "intensity": "2208.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "31",
                                "monoisotopic_mass": "1535.9498",
                                "monoisotopic_mz": "768.9822",
                                "intensity": "1930.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "32",
                                "monoisotopic_mass": "3356.0753",
                                "monoisotopic_mz": "840.0261",
                                "intensity": "5639.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "33",
                                "monoisotopic_mass": "2462.5180",
                                "monoisotopic_mz": "821.8466",
                                "intensity": "3541.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "34",
                                "monoisotopic_mass": "7632.8861",
                                "monoisotopic_mz": "955.1180",
                                "intensity": "5210.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "35",
                                "monoisotopic_mass": "625.3854",
                                "monoisotopic_mz": "626.3927",
                                "intensity": "904.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "36",
                                "monoisotopic_mass": "2991.8552",
                                "monoisotopic_mz": "998.2924",
                                "intensity": "2410.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "37",
                                "monoisotopic_mass": "697.4331",
                                "monoisotopic_mz": "698.4404",
                                "intensity": "1745.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "38",
                                "monoisotopic_mass": "1071.1702",
                                "monoisotopic_mz": "1072.1775",
                                "intensity": "2104.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "39",
                                "monoisotopic_mass": "1690.0404",
                                "monoisotopic_mz": "846.0275",
                                "intensity": "1833.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "40",
                                "monoisotopic_mass": "1973.0548",
                                "monoisotopic_mz": "987.5347",
                                "intensity": "2042.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "41",
                                "monoisotopic_mass": "3555.1812",
                                "monoisotopic_mz": "889.8026",
                                "intensity": "3249.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "42",
                                "monoisotopic_mass": "3599.9107",
                                "monoisotopic_mz": "900.9849",
                                "intensity": "2239.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "43",
                                "monoisotopic_mass": "2964.5694",
                                "monoisotopic_mz": "989.1971",
                                "intensity": "3547.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "44",
                                "monoisotopic_mass": "1938.1955",
                                "monoisotopic_mz": "970.1050",
                                "intensity": "2891.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "45",
                                "monoisotopic_mass": "1649.0166",
                                "monoisotopic_mz": "825.5156",
                                "intensity": "3206.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "46",
                                "monoisotopic_mass": "2232.3720",
                                "monoisotopic_mz": "745.1313",
                                "intensity": "2041.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "47",
                                "monoisotopic_mass": "7012.2753",
                                "monoisotopic_mz": "1002.7609",
                                "intensity": "2985.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "48",
                                "monoisotopic_mass": "2365.2247",
                                "monoisotopic_mz": "789.4155",
                                "intensity": "2268.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "49",
                                "monoisotopic_mass": "3562.2149",
                                "monoisotopic_mz": "713.4502",
                                "intensity": "701.56",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "50",
                                "monoisotopic_mass": "5029.1144",
                                "monoisotopic_mz": "839.1930",
                                "intensity": "8605.23",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "51",
                                "monoisotopic_mass": "3075.9032",
                                "monoisotopic_mz": "769.9831",
                                "intensity": "1501.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "52",
                                "monoisotopic_mass": "2553.5705",
                                "monoisotopic_mz": "852.1974",
                                "intensity": "2613.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "53",
                                "monoisotopic_mass": "1557.8250",
                                "monoisotopic_mz": "779.9198",
                                "intensity": "1410.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "54",
                                "monoisotopic_mass": "6116.2889",
                                "monoisotopic_mz": "874.7628",
                                "intensity": "1133.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "55",
                                "monoisotopic_mass": "5243.2163",
                                "monoisotopic_mz": "750.0382",
                                "intensity": "2473.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "56",
                                "monoisotopic_mass": "3223.9885",
                                "monoisotopic_mz": "807.0044",
                                "intensity": "2225.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "57",
                                "monoisotopic_mass": "2213.7091",
                                "monoisotopic_mz": "1107.8618",
                                "intensity": "2739.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "58",
                                "monoisotopic_mass": "4906.0284",
                                "monoisotopic_mz": "818.6787",
                                "intensity": "2344.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "59",
                                "monoisotopic_mass": "1918.1903",
                                "monoisotopic_mz": "960.1024",
                                "intensity": "2971.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "60",
                                "monoisotopic_mass": "2604.6168",
                                "monoisotopic_mz": "869.2129",
                                "intensity": "2993.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "61",
                                "monoisotopic_mass": "3785.3196",
                                "monoisotopic_mz": "947.3372",
                                "intensity": "2335.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "62",
                                "monoisotopic_mass": "2593.6014",
                                "monoisotopic_mz": "865.5411",
                                "intensity": "1349.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "63",
                                "monoisotopic_mass": "2891.4536",
                                "monoisotopic_mz": "723.8707",
                                "intensity": "1494.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "64",
                                "monoisotopic_mass": "7372.4751",
                                "monoisotopic_mz": "922.5667",
                                "intensity": "1898.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "65",
                                "monoisotopic_mass": "1860.1514",
                                "monoisotopic_mz": "931.0830",
                                "intensity": "2712.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "66",
                                "monoisotopic_mass": "4821.9776",
                                "monoisotopic_mz": "804.6702",
                                "intensity": "1846.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "67",
                                "monoisotopic_mass": "4559.7714",
                                "monoisotopic_mz": "912.9615",
                                "intensity": "5476.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "68",
                                "monoisotopic_mass": "4110.5398",
                                "monoisotopic_mz": "823.1152",
                                "intensity": "3457.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "69",
                                "monoisotopic_mass": "2064.2673",
                                "monoisotopic_mz": "1033.1409",
                                "intensity": "2547.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "70",
                                "monoisotopic_mass": "2111.2978",
                                "monoisotopic_mz": "1056.6562",
                                "intensity": "3032.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "71",
                                "monoisotopic_mass": "3436.1195",
                                "monoisotopic_mz": "860.0371",
                                "intensity": "3283.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "72",
                                "monoisotopic_mass": "4030.4912",
                                "monoisotopic_mz": "807.1055",
                                "intensity": "3487.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "73",
                                "monoisotopic_mass": "5290.2539",
                                "monoisotopic_mz": "882.7163",
                                "intensity": "3372.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "74",
                                "monoisotopic_mass": "3977.4471",
                                "monoisotopic_mz": "995.3691",
                                "intensity": "3662.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "75",
                                "monoisotopic_mass": "4611.8592",
                                "monoisotopic_mz": "923.3791",
                                "intensity": "1907.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "76",
                                "monoisotopic_mass": "1768.0980",
                                "monoisotopic_mz": "885.0563",
                                "intensity": "2564.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "77",
                                "monoisotopic_mass": "4043.4931",
                                "monoisotopic_mz": "1011.8805",
                                "intensity": "1662.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "78",
                                "monoisotopic_mass": "2105.8009",
                                "monoisotopic_mz": "702.9409",
                                "intensity": "843.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "79",
                                "monoisotopic_mass": "5143.6807",
                                "monoisotopic_mz": "1029.7434",
                                "intensity": "5230.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "80",
                                "monoisotopic_mass": "1811.1181",
                                "monoisotopic_mz": "906.5663",
                                "intensity": "4785.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "81",
                                "monoisotopic_mass": "2453.1913",
                                "monoisotopic_mz": "2454.1986",
                                "intensity": "1192.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "82",
                                "monoisotopic_mass": "5746.5445",
                                "monoisotopic_mz": "958.7647",
                                "intensity": "4346.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "83",
                                "monoisotopic_mass": "4435.7405",
                                "monoisotopic_mz": "740.2974",
                                "intensity": "2447.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "84",
                                "monoisotopic_mass": "2697.6683",
                                "monoisotopic_mz": "900.2300",
                                "intensity": "1965.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "85",
                                "monoisotopic_mass": "2912.7964",
                                "monoisotopic_mz": "729.2064",
                                "intensity": "2221.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "86",
                                "monoisotopic_mass": "2337.4447",
                                "monoisotopic_mz": "780.1555",
                                "intensity": "737.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "87",
                                "monoisotopic_mass": "3572.2105",
                                "monoisotopic_mz": "894.0599",
                                "intensity": "4612.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "88",
                                "monoisotopic_mass": "3229.9895",
                                "monoisotopic_mz": "647.0052",
                                "intensity": "2039.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "89",
                                "monoisotopic_mass": "3249.0080",
                                "monoisotopic_mz": "813.2593",
                                "intensity": "2842.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "90",
                                "monoisotopic_mass": "2191.7152",
                                "monoisotopic_mz": "1096.8649",
                                "intensity": "2046.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "91",
                                "monoisotopic_mass": "4136.1136",
                                "monoisotopic_mz": "828.2300",
                                "intensity": "1403.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "92",
                                "monoisotopic_mass": "3696.0498",
                                "monoisotopic_mz": "925.0197",
                                "intensity": "2628.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "93",
                                "monoisotopic_mass": "4169.5355",
                                "monoisotopic_mz": "834.9144",
                                "intensity": "3644.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "94",
                                "monoisotopic_mass": "6525.6694",
                                "monoisotopic_mz": "933.2458",
                                "intensity": "3499.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "95",
                                "monoisotopic_mass": "2889.4328",
                                "monoisotopic_mz": "964.1515",
                                "intensity": "1488.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "96",
                                "monoisotopic_mass": "5609.4008",
                                "monoisotopic_mz": "935.9074",
                                "intensity": "4984.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "97",
                                "monoisotopic_mass": "7125.8991",
                                "monoisotopic_mz": "891.7447",
                                "intensity": "1699.41",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "98",
                                "monoisotopic_mass": "1985.2315",
                                "monoisotopic_mz": "993.6230",
                                "intensity": "2376.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "99",
                                "monoisotopic_mass": "2263.1952",
                                "monoisotopic_mz": "1132.6049",
                                "intensity": "4046.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "100",
                                "monoisotopic_mass": "1895.1736",
                                "monoisotopic_mz": "948.5941",
                                "intensity": "1450.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "101",
                                "monoisotopic_mass": "3339.7833",
                                "monoisotopic_mz": "835.9531",
                                "intensity": "1543.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "102",
                                "monoisotopic_mass": "2047.2709",
                                "monoisotopic_mz": "1024.6427",
                                "intensity": "2680.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "103",
                                "monoisotopic_mass": "3841.3695",
                                "monoisotopic_mz": "961.3497",
                                "intensity": "4454.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "104",
                                "monoisotopic_mass": "4370.6852",
                                "monoisotopic_mz": "875.1443",
                                "intensity": "4293.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "105",
                                "monoisotopic_mass": "7452.9457",
                                "monoisotopic_mz": "1065.7138",
                                "intensity": "4294.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "106",
                                "monoisotopic_mass": "6881.2390",
                                "monoisotopic_mz": "861.1622",
                                "intensity": "3308.16",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "107",
                                "monoisotopic_mass": "4434.6928",
                                "monoisotopic_mz": "887.9458",
                                "intensity": "2073.34",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "108",
                                "monoisotopic_mass": "5712.8481",
                                "monoisotopic_mz": "953.1486",
                                "intensity": "3196.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "109",
                                "monoisotopic_mass": "6423.6262",
                                "monoisotopic_mz": "918.6682",
                                "intensity": "3561.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "110",
                                "monoisotopic_mass": "5769.0896",
                                "monoisotopic_mz": "962.5222",
                                "intensity": "1978.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "111",
                                "monoisotopic_mass": "2675.6612",
                                "monoisotopic_mz": "892.8944",
                                "intensity": "1982.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "112",
                                "monoisotopic_mass": "3198.9788",
                                "monoisotopic_mz": "800.7520",
                                "intensity": "4287.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "113",
                                "monoisotopic_mass": "3793.3409",
                                "monoisotopic_mz": "759.6755",
                                "intensity": "2981.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "114",
                                "monoisotopic_mass": "2059.2771",
                                "monoisotopic_mz": "687.4330",
                                "intensity": "855.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "115",
                                "monoisotopic_mass": "6627.0981",
                                "monoisotopic_mz": "947.7356",
                                "intensity": "3040.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "116",
                                "monoisotopic_mass": "3732.3113",
                                "monoisotopic_mz": "934.0851",
                                "intensity": "4255.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "117",
                                "monoisotopic_mass": "4485.0103",
                                "monoisotopic_mz": "1122.2598",
                                "intensity": "1731.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "118",
                                "monoisotopic_mass": "5889.6404",
                                "monoisotopic_mz": "982.6140",
                                "intensity": "2123.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "119",
                                "monoisotopic_mass": "4991.0867",
                                "monoisotopic_mz": "999.2246",
                                "intensity": "3615.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "120",
                                "monoisotopic_mass": "5209.2025",
                                "monoisotopic_mz": "745.1791",
                                "intensity": "1427.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "121",
                                "monoisotopic_mass": "4504.3856",
                                "monoisotopic_mz": "901.8844",
                                "intensity": "5082.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "122",
                                "monoisotopic_mass": "2649.6368",
                                "monoisotopic_mz": "884.2195",
                                "intensity": "2693.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "123",
                                "monoisotopic_mass": "3492.1702",
                                "monoisotopic_mz": "874.0498",
                                "intensity": "4489.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "124",
                                "monoisotopic_mass": "2873.0580",
                                "monoisotopic_mz": "958.6933",
                                "intensity": "2127.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "125",
                                "monoisotopic_mass": "1842.1354",
                                "monoisotopic_mz": "922.0750",
                                "intensity": "2739.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "126",
                                "monoisotopic_mass": "6279.8732",
                                "monoisotopic_mz": "785.9914",
                                "intensity": "4298.84",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "127",
                                "monoisotopic_mass": "4127.9389",
                                "monoisotopic_mz": "1032.9920",
                                "intensity": "1890.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "128",
                                "monoisotopic_mass": "3974.4578",
                                "monoisotopic_mz": "795.8988",
                                "intensity": "2471.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "129",
                                "monoisotopic_mass": "4058.5045",
                                "monoisotopic_mz": "812.7082",
                                "intensity": "2267.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "130",
                                "monoisotopic_mass": "1902.1735",
                                "monoisotopic_mz": "635.0651",
                                "intensity": "1579.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "131",
                                "monoisotopic_mass": "7605.0430",
                                "monoisotopic_mz": "951.6376",
                                "intensity": "3334.36",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "132",
                                "monoisotopic_mass": "5129.7622",
                                "monoisotopic_mz": "1026.9597",
                                "intensity": "3664.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "133",
                                "monoisotopic_mass": "7267.4987",
                                "monoisotopic_mz": "909.4446",
                                "intensity": "2169.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "134",
                                "monoisotopic_mass": "5477.3796",
                                "monoisotopic_mz": "913.9039",
                                "intensity": "3442.01",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "135",
                                "monoisotopic_mass": "3667.2893",
                                "monoisotopic_mz": "917.8296",
                                "intensity": "3709.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "136",
                                "monoisotopic_mass": "2721.0137",
                                "monoisotopic_mz": "908.0118",
                                "intensity": "2080.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "137",
                                "monoisotopic_mass": "6767.1748",
                                "monoisotopic_mz": "846.9041",
                                "intensity": "2039.63",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "138",
                                "monoisotopic_mass": "4596.8520",
                                "monoisotopic_mz": "920.3777",
                                "intensity": "2380.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "139",
                                "monoisotopic_mass": "6920.1709",
                                "monoisotopic_mz": "866.0286",
                                "intensity": "3247.57",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "140",
                                "monoisotopic_mass": "5124.0915",
                                "monoisotopic_mz": "855.0225",
                                "intensity": "2748.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "141",
                                "monoisotopic_mass": "6214.6085",
                                "monoisotopic_mz": "888.8085",
                                "intensity": "1595.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "142",
                                "monoisotopic_mass": "5566.4546",
                                "monoisotopic_mz": "1114.2982",
                                "intensity": "2442.68",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "143",
                                "monoisotopic_mass": "7546.4428",
                                "monoisotopic_mz": "944.3126",
                                "intensity": "2206.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "144",
                                "monoisotopic_mass": "5247.7514",
                                "monoisotopic_mz": "1050.5575",
                                "intensity": "2188.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "145",
                                "monoisotopic_mass": "4585.0282",
                                "monoisotopic_mz": "918.0129",
                                "intensity": "2736.93",
                                "charge": "5"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "146",
                                "monoisotopic_mass": "6964.3930",
                                "monoisotopic_mz": "871.5564",
                                "intensity": "1805.52",
                                "charge": "8"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "147",
                                "monoisotopic_mass": "5966.1169",
                                "monoisotopic_mz": "995.3601",
                                "intensity": "2857.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "148",
                                "monoisotopic_mass": "5647.4730",
                                "monoisotopic_mz": "807.7891",
                                "intensity": "766.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "149",
                                "monoisotopic_mass": "6269.3809",
                                "monoisotopic_mz": "896.6331",
                                "intensity": "3065.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "207",
                                "peak_id": "150",
                                "monoisotopic_mass": "4487.2540",
                                "monoisotopic_mz": "898.4581",
                                "intensity": "1384.34",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "57",
                    "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                    "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                    "proteoform_mass": "9096.9342",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "85",
                        "first_residue_position": "0",
                        "last_residue_position": "84",
                        "annotated_seq": ".MFQQE(VTITAPNGLHTRPAAQFVKEAKGFTSEITVTSNGKSASAKSLFKLQTLGLTQGTVVTISAEGEDEQK)[-16.8032]AVEHLVKLMAELE.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "F"
                            },
                            {
                                "position": "2",
                                "acid": "Q"
                            },
                            {
                                "position": "3",
                                "acid": "Q"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "V"
                            },
                            {
                                "position": "6",
                                "acid": "T"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "T"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "P"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "H"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "R"
                            },
                            {
                                "position": "17",
                                "acid": "P"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "F"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "G"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "T"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "I"
                            },
                            {
                                "position": "33",
                                "acid": "T"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "T"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "K"
                            },
                            {
                                "position": "40",
                                "acid": "S"
                            },
                            {
                                "position": "41",
                                "acid": "A"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "S"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "F"
                            },
                            {
                                "position": "48",
                                "acid": "K"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "Q"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "G"
                            },
                            {
                                "position": "54",
                                "acid": "L"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "Q"
                            },
                            {
                                "position": "57",
                                "acid": "G"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "V"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "S"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "E"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "D"
                            },
                            {
                                "position": "69",
                                "acid": "E"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "K"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "E"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "K"
                            },
                            {
                                "position": "79",
                                "acid": "L"
                            },
                            {
                                "position": "80",
                                "acid": "M"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "E"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "3",
                                        "ion_display_position": "3",
                                        "spec_id": "207",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "207",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "207",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "13",
                                        "spec_id": "207",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "75",
                                        "ion_display_position": "10",
                                        "spec_id": "207",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "7",
                                        "spec_id": "207",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "5",
                            "right_position": "72",
                            "shift": "-16.8031674125",
                            "anno": "-16.8032",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
