prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "32",
        "sequence_name": "sp|P64463|YDFZ_ECOLI",
        "sequence_description": "Putative selenoprotein YdfZ OS=Escherichia coli (strain K12) OX=83333 GN=ydfZ PE=1 SV=1",
        "proteoform_id": "53",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "41",
            "p_value": "0.01",
            "e_value": "0.01",
            "fdr": "0",
            "matched_fragment_number": "12",
            "matched_peak_number": "12",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                    "ms1_ids": "537",
                    "ms1_scans": "614",
                    "ids": "77",
                    "scans": "616",
                    "precursor_mono_mass": "7576.8123",
                    "precursor_charge": "5",
                    "precursor_mz": "1516.3697",
                    "feature_inte": "1.9379e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "77",
                            "peak_id": "0",
                            "monoisotopic_mass": "1510.7573",
                            "monoisotopic_mz": "1511.7645",
                            "intensity": "3737.32",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "1",
                            "monoisotopic_mass": "2176.0405",
                            "monoisotopic_mz": "2177.0478",
                            "intensity": "3239.58",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "2",
                            "monoisotopic_mass": "3415.7148",
                            "monoisotopic_mz": "1708.8647",
                            "intensity": "9040.69",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "3",
                            "monoisotopic_mass": "1211.6758",
                            "monoisotopic_mz": "1212.6831",
                            "intensity": "7241.87",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1211.6696",
                                    "ion_position": "56",
                                    "ion_display_position": "11",
                                    "ion_sort_name": "Y00011",
                                    "ion_left_position": "56",
                                    "mass_error": "0.0062",
                                    "ppm": "5.12"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "4",
                            "monoisotopic_mass": "1140.6385",
                            "monoisotopic_mz": "1141.6458",
                            "intensity": "11536.21",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1140.6325",
                                    "ion_position": "57",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "57",
                                    "mass_error": "0.0060",
                                    "ppm": "5.23"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "5",
                            "monoisotopic_mass": "1581.8984",
                            "monoisotopic_mz": "1582.9056",
                            "intensity": "2537.11",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1581.8912",
                                    "ion_position": "53",
                                    "ion_display_position": "14",
                                    "ion_sort_name": "Y00014",
                                    "ion_left_position": "53",
                                    "mass_error": "0.0071",
                                    "ppm": "4.50"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "6",
                            "monoisotopic_mass": "2857.3840",
                            "monoisotopic_mz": "953.4686",
                            "intensity": "2201.76",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "7",
                            "monoisotopic_mass": "2059.0194",
                            "monoisotopic_mz": "2060.0266",
                            "intensity": "2020.22",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "8",
                            "monoisotopic_mass": "815.4723",
                            "monoisotopic_mz": "816.4796",
                            "intensity": "14910.10",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "815.4687",
                                    "ion_position": "60",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "Y00007",
                                    "ion_left_position": "60",
                                    "mass_error": "0.0036",
                                    "ppm": "4.41"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "9",
                            "monoisotopic_mass": "6965.6476",
                            "monoisotopic_mz": "1394.1368",
                            "intensity": "8817.74",
                            "charge": "5",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "247.0845714723",
                                    "theoretical_mass": "6964.6439",
                                    "ion_position": "5",
                                    "ion_display_position": "62",
                                    "ion_sort_name": "Y00062",
                                    "ion_left_position": "5",
                                    "mass_error": "0.0014",
                                    "ppm": "0.21"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "10",
                            "monoisotopic_mass": "1123.6115",
                            "monoisotopic_mz": "1124.6188",
                            "intensity": "4759.35",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "11",
                            "monoisotopic_mass": "798.4459",
                            "monoisotopic_mz": "799.4532",
                            "intensity": "5370.55",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "12",
                            "monoisotopic_mass": "3433.7344",
                            "monoisotopic_mz": "1145.5854",
                            "intensity": "2342.36",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3433.7195",
                                    "ion_position": "32",
                                    "ion_display_position": "32",
                                    "ion_sort_name": "B00032",
                                    "ion_left_position": "32",
                                    "mass_error": "0.0149",
                                    "ppm": "4.35"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "13",
                            "monoisotopic_mass": "3300.6961",
                            "monoisotopic_mz": "1101.2393",
                            "intensity": "3129.68",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "14",
                            "monoisotopic_mass": "2874.4110",
                            "monoisotopic_mz": "959.1443",
                            "intensity": "3414.03",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "15",
                            "monoisotopic_mass": "1194.6487",
                            "monoisotopic_mz": "1195.6560",
                            "intensity": "2784.26",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "16",
                            "monoisotopic_mass": "1649.8326",
                            "monoisotopic_mz": "1650.8398",
                            "intensity": "2045.37",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "17",
                            "monoisotopic_mass": "2969.4856",
                            "monoisotopic_mz": "990.8358",
                            "intensity": "3256.94",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "18",
                            "monoisotopic_mass": "1324.7619",
                            "monoisotopic_mz": "1325.7692",
                            "intensity": "4770.40",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1324.7537",
                                    "ion_position": "55",
                                    "ion_display_position": "12",
                                    "ion_sort_name": "Y00012",
                                    "ion_left_position": "55",
                                    "mass_error": "0.0082",
                                    "ppm": "6.19"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "19",
                            "monoisotopic_mass": "3397.7012",
                            "monoisotopic_mz": "1699.8579",
                            "intensity": "6103.63",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "20",
                            "monoisotopic_mass": "7268.7427",
                            "monoisotopic_mz": "1454.7558",
                            "intensity": "35281.60",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "21",
                            "monoisotopic_mass": "7386.7764",
                            "monoisotopic_mz": "1478.3626",
                            "intensity": "15884.01",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "22",
                            "monoisotopic_mass": "4143.1369",
                            "monoisotopic_mz": "1382.0529",
                            "intensity": "7904.03",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "23",
                            "monoisotopic_mass": "7303.7677",
                            "monoisotopic_mz": "1461.7608",
                            "intensity": "15029.05",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "24",
                            "monoisotopic_mass": "2987.4979",
                            "monoisotopic_mz": "996.8399",
                            "intensity": "4363.21",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "25",
                            "monoisotopic_mass": "767.3312",
                            "monoisotopic_mz": "768.3384",
                            "intensity": "1231.34",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "767.3272",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "ion_sort_name": "B00006",
                                    "ion_left_position": "6",
                                    "mass_error": "0.0039",
                                    "ppm": "5.13"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "26",
                            "monoisotopic_mass": "3187.6017",
                            "monoisotopic_mz": "1063.5412",
                            "intensity": "1201.01",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "27",
                            "monoisotopic_mass": "3670.8076",
                            "monoisotopic_mz": "1224.6098",
                            "intensity": "4363.87",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "28",
                            "monoisotopic_mass": "930.4990",
                            "monoisotopic_mz": "931.5062",
                            "intensity": "1171.98",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "930.4957",
                                    "ion_position": "59",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "Y00008",
                                    "ion_left_position": "59",
                                    "mass_error": "0.0033",
                                    "ppm": "3.51"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "29",
                            "monoisotopic_mass": "7412.7981",
                            "monoisotopic_mz": "1483.5669",
                            "intensity": "30432.58",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "30",
                            "monoisotopic_mass": "3870.0366",
                            "monoisotopic_mz": "1291.0195",
                            "intensity": "4872.93",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "31",
                            "monoisotopic_mass": "784.3564",
                            "monoisotopic_mz": "785.3636",
                            "intensity": "1203.71",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "32",
                            "monoisotopic_mass": "7524.8202",
                            "monoisotopic_mz": "1505.9713",
                            "intensity": "27841.22",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "33",
                            "monoisotopic_mass": "837.5362",
                            "monoisotopic_mz": "838.5435",
                            "intensity": "1597.97",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "34",
                            "monoisotopic_mass": "7448.8034",
                            "monoisotopic_mz": "1490.7679",
                            "intensity": "9006.24",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "35",
                            "monoisotopic_mass": "7155.7099",
                            "monoisotopic_mz": "1432.1493",
                            "intensity": "4284.33",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "36",
                            "monoisotopic_mass": "7480.7992",
                            "monoisotopic_mz": "1497.1671",
                            "intensity": "15223.33",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "37",
                            "monoisotopic_mass": "7285.7501",
                            "monoisotopic_mz": "1458.1573",
                            "intensity": "37985.57",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "38",
                            "monoisotopic_mass": "3118.5970",
                            "monoisotopic_mz": "1040.5396",
                            "intensity": "1737.07",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3118.5764",
                                    "ion_position": "29",
                                    "ion_display_position": "29",
                                    "ion_sort_name": "B00029",
                                    "ion_left_position": "29",
                                    "mass_error": "0.0206",
                                    "ppm": "6.60"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "39",
                            "monoisotopic_mass": "6347.1824",
                            "monoisotopic_mz": "1587.8029",
                            "intensity": "3785.86",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "40",
                            "monoisotopic_mass": "6835.5859",
                            "monoisotopic_mz": "1368.1245",
                            "intensity": "4111.21",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "41",
                            "monoisotopic_mass": "7558.8528",
                            "monoisotopic_mz": "1512.7778",
                            "intensity": "78086.45",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "42",
                            "monoisotopic_mass": "7541.8307",
                            "monoisotopic_mz": "1509.3734",
                            "intensity": "68973.17",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "43",
                            "monoisotopic_mass": "7429.8123",
                            "monoisotopic_mz": "1486.9697",
                            "intensity": "33544.48",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "44",
                            "monoisotopic_mass": "3908.9648",
                            "monoisotopic_mz": "1955.4897",
                            "intensity": "3109.91",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "45",
                            "monoisotopic_mass": "7251.7256",
                            "monoisotopic_mz": "1451.3524",
                            "intensity": "15631.25",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "46",
                            "monoisotopic_mass": "7497.8140",
                            "monoisotopic_mz": "1500.5701",
                            "intensity": "29180.88",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "47",
                            "monoisotopic_mass": "6742.2671",
                            "monoisotopic_mz": "1349.4607",
                            "intensity": "7680.46",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "48",
                            "monoisotopic_mass": "5338.7889",
                            "monoisotopic_mz": "1335.7045",
                            "intensity": "5155.48",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "49",
                            "monoisotopic_mass": "6724.2291",
                            "monoisotopic_mz": "1345.8531",
                            "intensity": "6584.03",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "50",
                            "monoisotopic_mass": "6193.1253",
                            "monoisotopic_mz": "1549.2886",
                            "intensity": "2155.15",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "51",
                            "monoisotopic_mass": "6948.6184",
                            "monoisotopic_mz": "1390.7310",
                            "intensity": "7396.43",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "52",
                            "monoisotopic_mass": "7350.7583",
                            "monoisotopic_mz": "1471.1589",
                            "intensity": "5798.84",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "53",
                            "monoisotopic_mass": "5382.8120",
                            "monoisotopic_mz": "1346.7103",
                            "intensity": "11494.33",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "54",
                            "monoisotopic_mass": "6613.3221",
                            "monoisotopic_mz": "1654.3378",
                            "intensity": "4465.51",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "55",
                            "monoisotopic_mass": "7368.7686",
                            "monoisotopic_mz": "1474.7610",
                            "intensity": "11270.49",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "56",
                            "monoisotopic_mass": "4126.1081",
                            "monoisotopic_mz": "1376.3766",
                            "intensity": "4280.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "57",
                            "monoisotopic_mass": "3048.5345",
                            "monoisotopic_mz": "1525.2745",
                            "intensity": "1449.50",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "58",
                            "monoisotopic_mass": "3627.7764",
                            "monoisotopic_mz": "1210.2661",
                            "intensity": "2051.82",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "59",
                            "monoisotopic_mass": "3350.6777",
                            "monoisotopic_mz": "1676.3461",
                            "intensity": "2712.32",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "60",
                            "monoisotopic_mass": "3100.5842",
                            "monoisotopic_mz": "1034.5353",
                            "intensity": "3355.53",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "61",
                            "monoisotopic_mass": "7224.7032",
                            "monoisotopic_mz": "1445.9479",
                            "intensity": "16395.25",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "62",
                            "monoisotopic_mass": "6233.0941",
                            "monoisotopic_mz": "1559.2808",
                            "intensity": "4368.54",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "63",
                            "monoisotopic_mass": "7171.7235",
                            "monoisotopic_mz": "1435.3520",
                            "intensity": "7442.82",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "64",
                            "monoisotopic_mass": "994.5249",
                            "monoisotopic_mz": "995.5322",
                            "intensity": "1564.93",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "65",
                            "monoisotopic_mass": "6314.1609",
                            "monoisotopic_mz": "1579.5475",
                            "intensity": "2112.35",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "66",
                            "monoisotopic_mass": "518.2539",
                            "monoisotopic_mz": "519.2612",
                            "intensity": "664.23",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "67",
                            "monoisotopic_mass": "3122.5842",
                            "monoisotopic_mz": "1562.2994",
                            "intensity": "1757.35",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "68",
                            "monoisotopic_mass": "3160.5829",
                            "monoisotopic_mz": "1581.2987",
                            "intensity": "1759.53",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "69",
                            "monoisotopic_mass": "7068.6648",
                            "monoisotopic_mz": "1414.7402",
                            "intensity": "1905.30",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "70",
                            "monoisotopic_mass": "6146.0979",
                            "monoisotopic_mz": "1537.5317",
                            "intensity": "3707.14",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "71",
                            "monoisotopic_mass": "3897.0212",
                            "monoisotopic_mz": "1300.0144",
                            "intensity": "2147.61",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "72",
                            "monoisotopic_mass": "3912.0322",
                            "monoisotopic_mz": "1305.0180",
                            "intensity": "2796.98",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "247.0845714723",
                                    "theoretical_mass": "3912.0602",
                                    "ion_position": "34",
                                    "ion_display_position": "33",
                                    "ion_sort_name": "Y00033",
                                    "ion_left_position": "34",
                                    "mass_error": "-0.0281",
                                    "ppm": "-7.18"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "73",
                            "monoisotopic_mass": "6104.0526",
                            "monoisotopic_mz": "1527.0204",
                            "intensity": "4190.71",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "74",
                            "monoisotopic_mass": "3197.6206",
                            "monoisotopic_mz": "1599.8176",
                            "intensity": "1923.70",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "75",
                            "monoisotopic_mass": "2451.1708",
                            "monoisotopic_mz": "1226.5927",
                            "intensity": "1824.21",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "76",
                            "monoisotopic_mass": "6743.4016",
                            "monoisotopic_mz": "1686.8577",
                            "intensity": "9668.62",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "77",
                            "monoisotopic_mass": "6376.2161",
                            "monoisotopic_mz": "1595.0613",
                            "intensity": "1615.31",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "78",
                            "monoisotopic_mass": "6896.5638",
                            "monoisotopic_mz": "1380.3200",
                            "intensity": "3700.26",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "79",
                            "monoisotopic_mass": "7045.6226",
                            "monoisotopic_mz": "1410.1318",
                            "intensity": "2835.66",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "80",
                            "monoisotopic_mass": "7202.7712",
                            "monoisotopic_mz": "1441.5615",
                            "intensity": "10328.68",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "81",
                            "monoisotopic_mass": "2294.1259",
                            "monoisotopic_mz": "1148.0702",
                            "intensity": "620.65",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "82",
                            "monoisotopic_mass": "6330.1731",
                            "monoisotopic_mz": "1583.5505",
                            "intensity": "2650.06",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "83",
                            "monoisotopic_mass": "1008.4628",
                            "monoisotopic_mz": "1009.4701",
                            "intensity": "466.02",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "84",
                            "monoisotopic_mass": "7010.6243",
                            "monoisotopic_mz": "1403.1321",
                            "intensity": "1802.97",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "85",
                            "monoisotopic_mass": "5365.8099",
                            "monoisotopic_mz": "1342.4598",
                            "intensity": "5829.60",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "86",
                            "monoisotopic_mass": "6758.5122",
                            "monoisotopic_mz": "1352.7097",
                            "intensity": "2854.78",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "87",
                            "monoisotopic_mass": "2728.4320",
                            "monoisotopic_mz": "1365.2233",
                            "intensity": "2879.02",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "88",
                            "monoisotopic_mass": "3853.0030",
                            "monoisotopic_mz": "1285.3416",
                            "intensity": "2309.15",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "89",
                            "monoisotopic_mass": "1094.8958",
                            "monoisotopic_mz": "1095.9031",
                            "intensity": "423.62",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "90",
                            "monoisotopic_mass": "7094.6407",
                            "monoisotopic_mz": "1419.9354",
                            "intensity": "1499.83",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "91",
                            "monoisotopic_mass": "4015.0898",
                            "monoisotopic_mz": "1339.3705",
                            "intensity": "4654.97",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "92",
                            "monoisotopic_mass": "1064.2045",
                            "monoisotopic_mz": "1065.2118",
                            "intensity": "317.98",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "93",
                            "monoisotopic_mass": "2891.4120",
                            "monoisotopic_mz": "964.8113",
                            "intensity": "3125.57",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "94",
                            "monoisotopic_mass": "7112.6917",
                            "monoisotopic_mz": "1423.5456",
                            "intensity": "2177.88",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "95",
                            "monoisotopic_mass": "6057.0374",
                            "monoisotopic_mz": "1515.2666",
                            "intensity": "2751.68",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "96",
                            "monoisotopic_mass": "3143.5714",
                            "monoisotopic_mz": "1572.7930",
                            "intensity": "2398.48",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "97",
                            "monoisotopic_mass": "6853.5955",
                            "monoisotopic_mz": "1371.7264",
                            "intensity": "3370.52",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "98",
                            "monoisotopic_mass": "6804.5327",
                            "monoisotopic_mz": "1361.9138",
                            "intensity": "774.69",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "99",
                            "monoisotopic_mass": "3997.0649",
                            "monoisotopic_mz": "1333.3622",
                            "intensity": "2853.97",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "100",
                            "monoisotopic_mass": "2606.2621",
                            "monoisotopic_mz": "1304.1383",
                            "intensity": "1337.51",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2606.2442",
                                    "ion_position": "24",
                                    "ion_display_position": "24",
                                    "ion_sort_name": "B00024",
                                    "ion_left_position": "24",
                                    "mass_error": "0.0179",
                                    "ppm": "6.87"
                                }
                            }
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "101",
                            "monoisotopic_mass": "6522.3714",
                            "monoisotopic_mz": "1631.6001",
                            "intensity": "2370.06",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "102",
                            "monoisotopic_mass": "1695.8659",
                            "monoisotopic_mz": "1696.8732",
                            "intensity": "1919.14",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "103",
                            "monoisotopic_mass": "6770.4852",
                            "monoisotopic_mz": "1355.1043",
                            "intensity": "1940.23",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "104",
                            "monoisotopic_mass": "6452.2528",
                            "monoisotopic_mz": "1614.0705",
                            "intensity": "3296.48",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "105",
                            "monoisotopic_mass": "2842.8447",
                            "monoisotopic_mz": "1422.4296",
                            "intensity": "589.11",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "106",
                            "monoisotopic_mass": "7124.6623",
                            "monoisotopic_mz": "1425.9397",
                            "intensity": "1880.02",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "107",
                            "monoisotopic_mass": "3638.9293",
                            "monoisotopic_mz": "1213.9837",
                            "intensity": "1032.33",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "108",
                            "monoisotopic_mass": "3784.9991",
                            "monoisotopic_mz": "1262.6737",
                            "intensity": "756.39",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "109",
                            "monoisotopic_mass": "6921.5931",
                            "monoisotopic_mz": "1385.3259",
                            "intensity": "3166.82",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "110",
                            "monoisotopic_mass": "3414.7192",
                            "monoisotopic_mz": "1139.2470",
                            "intensity": "2744.51",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "111",
                            "monoisotopic_mass": "3319.7088",
                            "monoisotopic_mz": "1107.5769",
                            "intensity": "607.32",
                            "charge": "3"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "112",
                            "monoisotopic_mass": "7319.7493",
                            "monoisotopic_mz": "1464.9571",
                            "intensity": "1246.43",
                            "charge": "5"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "113",
                            "monoisotopic_mass": "6716.3684",
                            "monoisotopic_mz": "1680.0994",
                            "intensity": "895.70",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "114",
                            "monoisotopic_mass": "2871.6427",
                            "monoisotopic_mz": "1436.8286",
                            "intensity": "2356.24",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "115",
                            "monoisotopic_mass": "5464.8584",
                            "monoisotopic_mz": "1367.2219",
                            "intensity": "710.42",
                            "charge": "4"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "116",
                            "monoisotopic_mass": "3031.7248",
                            "monoisotopic_mz": "1516.8697",
                            "intensity": "8050.92",
                            "charge": "2"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "117",
                            "monoisotopic_mass": "1252.6579",
                            "monoisotopic_mz": "1253.6652",
                            "intensity": "426.33",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "118",
                            "monoisotopic_mass": "1390.1216",
                            "monoisotopic_mz": "1391.1289",
                            "intensity": "1150.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "77",
                            "peak_id": "119",
                            "monoisotopic_mass": "1487.7570",
                            "monoisotopic_mz": "1488.7643",
                            "intensity": "4259.58",
                            "charge": "1"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "32",
                "proteoform_id": "53",
                "sequence_name": "sp|P64463|YDFZ_ECOLI",
                "sequence_description": "Putative selenoprotein YdfZ OS=Escherichia coli (strain K12) OX=83333 GN=ydfZ PE=1 SV=1",
                "proteoform_mass": "7575.8700",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "67",
                    "first_residue_position": "0",
                    "last_residue_position": "66",
                    "annotated_seq": ".MTTYDRNRNAITTGSRVMVSGTGHTGKILSIDTE(GLTAEQIRRGKTVVVEG(C)[Carbamidomethylation]E)[+247.0846]EKLAPLDLIRLGMN.",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "T"
                        },
                        {
                            "position": "2",
                            "acid": "T"
                        },
                        {
                            "position": "3",
                            "acid": "Y"
                        },
                        {
                            "position": "4",
                            "acid": "D"
                        },
                        {
                            "position": "5",
                            "acid": "R"
                        },
                        {
                            "position": "6",
                            "acid": "N"
                        },
                        {
                            "position": "7",
                            "acid": "R"
                        },
                        {
                            "position": "8",
                            "acid": "N"
                        },
                        {
                            "position": "9",
                            "acid": "A"
                        },
                        {
                            "position": "10",
                            "acid": "I"
                        },
                        {
                            "position": "11",
                            "acid": "T"
                        },
                        {
                            "position": "12",
                            "acid": "T"
                        },
                        {
                            "position": "13",
                            "acid": "G"
                        },
                        {
                            "position": "14",
                            "acid": "S"
                        },
                        {
                            "position": "15",
                            "acid": "R"
                        },
                        {
                            "position": "16",
                            "acid": "V"
                        },
                        {
                            "position": "17",
                            "acid": "M"
                        },
                        {
                            "position": "18",
                            "acid": "V"
                        },
                        {
                            "position": "19",
                            "acid": "S"
                        },
                        {
                            "position": "20",
                            "acid": "G"
                        },
                        {
                            "position": "21",
                            "acid": "T"
                        },
                        {
                            "position": "22",
                            "acid": "G"
                        },
                        {
                            "position": "23",
                            "acid": "H"
                        },
                        {
                            "position": "24",
                            "acid": "T"
                        },
                        {
                            "position": "25",
                            "acid": "G"
                        },
                        {
                            "position": "26",
                            "acid": "K"
                        },
                        {
                            "position": "27",
                            "acid": "I"
                        },
                        {
                            "position": "28",
                            "acid": "L"
                        },
                        {
                            "position": "29",
                            "acid": "S"
                        },
                        {
                            "position": "30",
                            "acid": "I"
                        },
                        {
                            "position": "31",
                            "acid": "D"
                        },
                        {
                            "position": "32",
                            "acid": "T"
                        },
                        {
                            "position": "33",
                            "acid": "E"
                        },
                        {
                            "position": "34",
                            "acid": "G"
                        },
                        {
                            "position": "35",
                            "acid": "L"
                        },
                        {
                            "position": "36",
                            "acid": "T"
                        },
                        {
                            "position": "37",
                            "acid": "A"
                        },
                        {
                            "position": "38",
                            "acid": "E"
                        },
                        {
                            "position": "39",
                            "acid": "Q"
                        },
                        {
                            "position": "40",
                            "acid": "I"
                        },
                        {
                            "position": "41",
                            "acid": "R"
                        },
                        {
                            "position": "42",
                            "acid": "R"
                        },
                        {
                            "position": "43",
                            "acid": "G"
                        },
                        {
                            "position": "44",
                            "acid": "K"
                        },
                        {
                            "position": "45",
                            "acid": "T"
                        },
                        {
                            "position": "46",
                            "acid": "V"
                        },
                        {
                            "position": "47",
                            "acid": "V"
                        },
                        {
                            "position": "48",
                            "acid": "V"
                        },
                        {
                            "position": "49",
                            "acid": "E"
                        },
                        {
                            "position": "50",
                            "acid": "G"
                        },
                        {
                            "position": "51",
                            "acid": "C"
                        },
                        {
                            "position": "52",
                            "acid": "E"
                        },
                        {
                            "position": "53",
                            "acid": "E"
                        },
                        {
                            "position": "54",
                            "acid": "K"
                        },
                        {
                            "position": "55",
                            "acid": "L"
                        },
                        {
                            "position": "56",
                            "acid": "A"
                        },
                        {
                            "position": "57",
                            "acid": "P"
                        },
                        {
                            "position": "58",
                            "acid": "L"
                        },
                        {
                            "position": "59",
                            "acid": "D"
                        },
                        {
                            "position": "60",
                            "acid": "L"
                        },
                        {
                            "position": "61",
                            "acid": "I"
                        },
                        {
                            "position": "62",
                            "acid": "R"
                        },
                        {
                            "position": "63",
                            "acid": "L"
                        },
                        {
                            "position": "64",
                            "acid": "G"
                        },
                        {
                            "position": "65",
                            "acid": "M"
                        },
                        {
                            "position": "66",
                            "acid": "N"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "5",
                                    "ion_display_position": "62",
                                    "spec_id": "77",
                                    "peak_id": "9",
                                    "peak_charge": "5"
                                }
                            }
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "spec_id": "77",
                                    "peak_id": "25",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "24",
                                    "ion_display_position": "24",
                                    "spec_id": "77",
                                    "peak_id": "100",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "29",
                                    "ion_display_position": "29",
                                    "spec_id": "77",
                                    "peak_id": "38",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "32",
                                    "ion_display_position": "32",
                                    "spec_id": "77",
                                    "peak_id": "12",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "34",
                                    "ion_display_position": "33",
                                    "spec_id": "77",
                                    "peak_id": "72",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "53",
                                    "ion_display_position": "14",
                                    "spec_id": "77",
                                    "peak_id": "5",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "12",
                                    "spec_id": "77",
                                    "peak_id": "18",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "56",
                                    "ion_display_position": "11",
                                    "spec_id": "77",
                                    "peak_id": "3",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "57",
                                    "ion_display_position": "10",
                                    "spec_id": "77",
                                    "peak_id": "4",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "8",
                                    "spec_id": "77",
                                    "peak_id": "28",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "60",
                                    "ion_display_position": "7",
                                    "spec_id": "77",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Fixed",
                        "ptm": {
                            "abbreviation": "Carbamidomethylation",
                            "unimod": "-1",
                            "mono_mass": "57.0214640000"
                        },
                        "occurence": {
                            "left_pos": "51",
                            "right_pos": "52",
                            "anno": "C"
                        }
                    },
                    "mass_shift": {
                        "id": "0",
                        "left_position": "34",
                        "right_position": "53",
                        "shift": "247.0845714723",
                        "anno": "+247.0846",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
