prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "1",
        "sequence_name": "sp|P0AA04|PTHP_ECOLI",
        "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
        "proteoform_id": "52",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "103",
            "p_value": "2.96e-03",
            "e_value": "2.96e-03",
            "fdr": "0",
            "matched_fragment_number": "8",
            "matched_peak_number": "8",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                    "ms1_ids": "595",
                    "ms1_scans": "845",
                    "ids": "250",
                    "scans": "847",
                    "precursor_mono_mass": "9134.7222",
                    "precursor_charge": "6",
                    "precursor_mz": "1523.4610",
                    "feature_inte": "1.4711e+06"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "250",
                            "peak_id": "0",
                            "monoisotopic_mass": "2454.2032",
                            "monoisotopic_mz": "2455.2105",
                            "intensity": "3166.43",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2454.1948",
                                    "ion_position": "63",
                                    "ion_display_position": "22",
                                    "ion_sort_name": "Y00022",
                                    "ion_left_position": "63",
                                    "mass_error": "0.0084",
                                    "ppm": "3.42"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "1",
                            "monoisotopic_mass": "1866.0011",
                            "monoisotopic_mz": "1867.0084",
                            "intensity": "2238.07",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1865.9921",
                                    "ion_position": "69",
                                    "ion_display_position": "16",
                                    "ion_sort_name": "Y00016",
                                    "ion_left_position": "69",
                                    "mass_error": "0.0090",
                                    "ppm": "4.82"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "2",
                            "monoisotopic_mass": "2668.3267",
                            "monoisotopic_mz": "2669.3339",
                            "intensity": "2110.80",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2668.3266",
                                    "ion_position": "61",
                                    "ion_display_position": "24",
                                    "ion_sort_name": "Y00024",
                                    "ion_left_position": "61",
                                    "mass_error": "0.0001",
                                    "ppm": "0.04"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "3",
                            "monoisotopic_mass": "1413.8818",
                            "monoisotopic_mz": "1414.8890",
                            "intensity": "1548.71",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "4",
                            "monoisotopic_mass": "832.4402",
                            "monoisotopic_mz": "833.4475",
                            "intensity": "3306.71",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "832.4364",
                                    "ion_position": "78",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "Y00007",
                                    "ion_left_position": "78",
                                    "mass_error": "0.0038",
                                    "ppm": "4.55"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "5",
                            "monoisotopic_mass": "2545.3248",
                            "monoisotopic_mz": "1273.6697",
                            "intensity": "1357.37",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "6",
                            "monoisotopic_mass": "2753.4577",
                            "monoisotopic_mz": "1377.7361",
                            "intensity": "3125.30",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "7",
                            "monoisotopic_mass": "6078.0335",
                            "monoisotopic_mz": "1520.5157",
                            "intensity": "6602.03",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "8",
                            "monoisotopic_mass": "663.2717",
                            "monoisotopic_mz": "664.2790",
                            "intensity": "4020.26",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "663.2686",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "ion_sort_name": "B00005",
                                    "ion_left_position": "5",
                                    "mass_error": "0.0031",
                                    "ppm": "4.63"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "9",
                            "monoisotopic_mass": "712.4518",
                            "monoisotopic_mz": "713.4591",
                            "intensity": "608.35",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "10",
                            "monoisotopic_mass": "1181.6551",
                            "monoisotopic_mz": "1182.6624",
                            "intensity": "1866.21",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1181.6478",
                                    "ion_position": "75",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "75",
                                    "mass_error": "0.0072",
                                    "ppm": "6.14"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "11",
                            "monoisotopic_mass": "1459.7764",
                            "monoisotopic_mz": "1460.7837",
                            "intensity": "1404.93",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "12",
                            "monoisotopic_mass": "845.3781",
                            "monoisotopic_mz": "846.3854",
                            "intensity": "1728.74",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "13",
                            "monoisotopic_mass": "859.3936",
                            "monoisotopic_mz": "860.4009",
                            "intensity": "738.08",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "14",
                            "monoisotopic_mass": "746.3089",
                            "monoisotopic_mz": "747.3162",
                            "intensity": "605.97",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "15",
                            "monoisotopic_mass": "646.2445",
                            "monoisotopic_mz": "647.2518",
                            "intensity": "769.65",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "16",
                            "monoisotopic_mass": "532.2309",
                            "monoisotopic_mz": "533.2382",
                            "intensity": "1432.53",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "17",
                            "monoisotopic_mass": "406.1690",
                            "monoisotopic_mz": "407.1762",
                            "intensity": "3516.31",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "406.1675",
                                    "ion_position": "3",
                                    "ion_display_position": "3",
                                    "ion_sort_name": "B00003",
                                    "ion_left_position": "3",
                                    "mass_error": "0.0015",
                                    "ppm": "3.65"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "18",
                            "monoisotopic_mass": "3167.6830",
                            "monoisotopic_mz": "1584.8488",
                            "intensity": "1107.81",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "19",
                            "monoisotopic_mass": "1001.6208",
                            "monoisotopic_mz": "1002.6281",
                            "intensity": "497.83",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "20",
                            "monoisotopic_mass": "439.2084",
                            "monoisotopic_mz": "440.2157",
                            "intensity": "1962.69",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "21",
                            "monoisotopic_mass": "2259.2147",
                            "monoisotopic_mz": "1130.6146",
                            "intensity": "1785.40",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "22",
                            "monoisotopic_mass": "2297.1793",
                            "monoisotopic_mz": "1149.5969",
                            "intensity": "2264.64",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "23",
                            "monoisotopic_mass": "762.3409",
                            "monoisotopic_mz": "763.3482",
                            "intensity": "1388.80",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "762.3371",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "ion_sort_name": "B00006",
                                    "ion_left_position": "6",
                                    "mass_error": "0.0039",
                                    "ppm": "5.08"
                                }
                            }
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "24",
                            "monoisotopic_mass": "1107.6856",
                            "monoisotopic_mz": "1108.6929",
                            "intensity": "1038.02",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "25",
                            "monoisotopic_mass": "421.1976",
                            "monoisotopic_mz": "422.2048",
                            "intensity": "1148.65",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "26",
                            "monoisotopic_mass": "1226.7563",
                            "monoisotopic_mz": "1227.7635",
                            "intensity": "1380.51",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "27",
                            "monoisotopic_mass": "572.3024",
                            "monoisotopic_mz": "573.3096",
                            "intensity": "1261.61",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "28",
                            "monoisotopic_mass": "1325.6954",
                            "monoisotopic_mz": "1326.7026",
                            "intensity": "1404.71",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "29",
                            "monoisotopic_mass": "2733.4369",
                            "monoisotopic_mz": "1367.7257",
                            "intensity": "2757.13",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "30",
                            "monoisotopic_mass": "2980.8524",
                            "monoisotopic_mz": "1491.4335",
                            "intensity": "2187.47",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "31",
                            "monoisotopic_mass": "467.2035",
                            "monoisotopic_mz": "468.2108",
                            "intensity": "1911.56",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "32",
                            "monoisotopic_mass": "1716.9142",
                            "monoisotopic_mz": "1717.9215",
                            "intensity": "1461.95",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "33",
                            "monoisotopic_mass": "5475.7733",
                            "monoisotopic_mz": "1369.9506",
                            "intensity": "2094.38",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "34",
                            "monoisotopic_mass": "3065.6426",
                            "monoisotopic_mz": "1533.8286",
                            "intensity": "2025.99",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "35",
                            "monoisotopic_mass": "2281.2055",
                            "monoisotopic_mz": "1141.6100",
                            "intensity": "2888.76",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "36",
                            "monoisotopic_mass": "4791.9566",
                            "monoisotopic_mz": "1198.9964",
                            "intensity": "894.14",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "37",
                            "monoisotopic_mass": "1259.2781",
                            "monoisotopic_mz": "1260.2854",
                            "intensity": "1588.33",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "38",
                            "monoisotopic_mass": "958.4617",
                            "monoisotopic_mz": "959.4689",
                            "intensity": "873.09",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "39",
                            "monoisotopic_mass": "1388.7362",
                            "monoisotopic_mz": "1389.7435",
                            "intensity": "1458.60",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "40",
                            "monoisotopic_mass": "5417.8156",
                            "monoisotopic_mz": "1084.5704",
                            "intensity": "605.56",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "41",
                            "monoisotopic_mass": "1434.7440",
                            "monoisotopic_mz": "718.3793",
                            "intensity": "817.08",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "42",
                            "monoisotopic_mass": "4460.7770",
                            "monoisotopic_mz": "1487.9329",
                            "intensity": "2990.75",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "43",
                            "monoisotopic_mass": "3299.0723",
                            "monoisotopic_mz": "1100.6980",
                            "intensity": "1008.34",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "44",
                            "monoisotopic_mass": "3959.4423",
                            "monoisotopic_mz": "1320.8214",
                            "intensity": "1553.87",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "45",
                            "monoisotopic_mass": "4550.8219",
                            "monoisotopic_mz": "1138.7127",
                            "intensity": "1485.35",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "46",
                            "monoisotopic_mass": "3701.9806",
                            "monoisotopic_mz": "1235.0008",
                            "intensity": "932.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "47",
                            "monoisotopic_mass": "7414.0904",
                            "monoisotopic_mz": "1483.8254",
                            "intensity": "1283.51",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "48",
                            "monoisotopic_mass": "2766.8541",
                            "monoisotopic_mz": "1384.4343",
                            "intensity": "1420.77",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "49",
                            "monoisotopic_mass": "2166.0895",
                            "monoisotopic_mz": "2167.0968",
                            "intensity": "2291.91",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "50",
                            "monoisotopic_mass": "2630.3142",
                            "monoisotopic_mz": "1316.1644",
                            "intensity": "1358.64",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "51",
                            "monoisotopic_mass": "7604.0041",
                            "monoisotopic_mz": "1521.8081",
                            "intensity": "4769.00",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "52",
                            "monoisotopic_mass": "4540.1932",
                            "monoisotopic_mz": "1514.4050",
                            "intensity": "4457.63",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "53",
                            "monoisotopic_mass": "2017.9919",
                            "monoisotopic_mz": "2018.9992",
                            "intensity": "2274.46",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "54",
                            "monoisotopic_mass": "3933.1128",
                            "monoisotopic_mz": "1312.0449",
                            "intensity": "1507.02",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "55",
                            "monoisotopic_mass": "1979.0330",
                            "monoisotopic_mz": "1980.0403",
                            "intensity": "1375.25",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "56",
                            "monoisotopic_mass": "4051.4927",
                            "monoisotopic_mz": "1351.5048",
                            "intensity": "1455.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "57",
                            "monoisotopic_mass": "1675.8820",
                            "monoisotopic_mz": "1676.8893",
                            "intensity": "1042.67",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "58",
                            "monoisotopic_mass": "2976.3899",
                            "monoisotopic_mz": "993.1372",
                            "intensity": "1152.38",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "59",
                            "monoisotopic_mass": "6095.0395",
                            "monoisotopic_mz": "1524.7672",
                            "intensity": "10267.46",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "60",
                            "monoisotopic_mass": "2936.4989",
                            "monoisotopic_mz": "1469.2567",
                            "intensity": "1436.49",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "61",
                            "monoisotopic_mass": "1502.4322",
                            "monoisotopic_mz": "1503.4395",
                            "intensity": "2196.11",
                            "charge": "1"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "62",
                            "monoisotopic_mass": "6004.7097",
                            "monoisotopic_mz": "1001.7922",
                            "intensity": "795.59",
                            "charge": "6"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "63",
                            "monoisotopic_mass": "3007.5743",
                            "monoisotopic_mz": "1504.7944",
                            "intensity": "1476.42",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "64",
                            "monoisotopic_mass": "5251.7812",
                            "monoisotopic_mz": "1313.9526",
                            "intensity": "713.88",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "65",
                            "monoisotopic_mass": "2672.6544",
                            "monoisotopic_mz": "1337.3345",
                            "intensity": "1454.35",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "66",
                            "monoisotopic_mass": "2418.4868",
                            "monoisotopic_mz": "1210.2507",
                            "intensity": "1377.43",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "67",
                            "monoisotopic_mass": "2581.3431",
                            "monoisotopic_mz": "1291.6788",
                            "intensity": "1269.88",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "68",
                            "monoisotopic_mass": "4807.8849",
                            "monoisotopic_mz": "1202.9785",
                            "intensity": "795.54",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "69",
                            "monoisotopic_mass": "5524.9239",
                            "monoisotopic_mz": "1382.2382",
                            "intensity": "1741.96",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "70",
                            "monoisotopic_mass": "8008.0102",
                            "monoisotopic_mz": "1335.6756",
                            "intensity": "1738.08",
                            "charge": "6"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "71",
                            "monoisotopic_mass": "2122.3103",
                            "monoisotopic_mz": "1062.1624",
                            "intensity": "919.81",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "72",
                            "monoisotopic_mass": "3353.7694",
                            "monoisotopic_mz": "1677.8920",
                            "intensity": "858.16",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "73",
                            "monoisotopic_mass": "2310.4203",
                            "monoisotopic_mz": "1156.2174",
                            "intensity": "607.59",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "74",
                            "monoisotopic_mass": "5727.5257",
                            "monoisotopic_mz": "1432.8887",
                            "intensity": "1537.99",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "75",
                            "monoisotopic_mass": "5507.3886",
                            "monoisotopic_mz": "1377.8544",
                            "intensity": "696.05",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "76",
                            "monoisotopic_mass": "2102.1340",
                            "monoisotopic_mz": "1052.0743",
                            "intensity": "1307.75",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "77",
                            "monoisotopic_mass": "8194.4123",
                            "monoisotopic_mz": "1366.7427",
                            "intensity": "742.75",
                            "charge": "6"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "78",
                            "monoisotopic_mass": "3129.9293",
                            "monoisotopic_mz": "1044.3171",
                            "intensity": "981.88",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "79",
                            "monoisotopic_mass": "4962.6315",
                            "monoisotopic_mz": "1241.6652",
                            "intensity": "1662.44",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "80",
                            "monoisotopic_mass": "4297.0773",
                            "monoisotopic_mz": "1433.3664",
                            "intensity": "933.65",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "81",
                            "monoisotopic_mass": "6527.7680",
                            "monoisotopic_mz": "1306.5609",
                            "intensity": "1349.62",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "82",
                            "monoisotopic_mass": "5720.5468",
                            "monoisotopic_mz": "1145.1166",
                            "intensity": "517.58",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "83",
                            "monoisotopic_mass": "8233.5075",
                            "monoisotopic_mz": "1373.2585",
                            "intensity": "806.62",
                            "charge": "6"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "84",
                            "monoisotopic_mass": "4372.6993",
                            "monoisotopic_mz": "1094.1821",
                            "intensity": "530.36",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "85",
                            "monoisotopic_mass": "4132.5263",
                            "monoisotopic_mz": "1378.5160",
                            "intensity": "1242.72",
                            "charge": "3"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "86",
                            "monoisotopic_mass": "2220.1816",
                            "monoisotopic_mz": "1111.0981",
                            "intensity": "538.64",
                            "charge": "2"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "87",
                            "monoisotopic_mass": "5231.1637",
                            "monoisotopic_mz": "1308.7982",
                            "intensity": "646.49",
                            "charge": "4"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "88",
                            "monoisotopic_mass": "5553.9751",
                            "monoisotopic_mz": "1111.8023",
                            "intensity": "574.28",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "89",
                            "monoisotopic_mass": "7474.7996",
                            "monoisotopic_mz": "1495.9672",
                            "intensity": "1155.41",
                            "charge": "5"
                        },
                        {
                            "spec_id": "250",
                            "peak_id": "90",
                            "monoisotopic_mass": "6913.0106",
                            "monoisotopic_mz": "1153.1757",
                            "intensity": "602.82",
                            "charge": "6"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "1",
                "proteoform_id": "52",
                "sequence_name": "sp|P0AA04|PTHP_ECOLI",
                "sequence_description": "Phosphocarrier protein HPr OS=Escherichia coli (strain K12) OX=83333 GN=ptsH PE=1 SV=1",
                "proteoform_mass": "9134.9022",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "85",
                    "first_residue_position": "0",
                    "last_residue_position": "84",
                    "annotated_seq": ".MFQQEV(TITAPNGLHTRPAAQFVKEAKGFTSEITVTSNGKSASAKSLFKLQTLGLTQGTVV)[+21.1649]TISAEGEDEQKAVEHLVKLMAELE.",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "F"
                        },
                        {
                            "position": "2",
                            "acid": "Q"
                        },
                        {
                            "position": "3",
                            "acid": "Q"
                        },
                        {
                            "position": "4",
                            "acid": "E"
                        },
                        {
                            "position": "5",
                            "acid": "V"
                        },
                        {
                            "position": "6",
                            "acid": "T"
                        },
                        {
                            "position": "7",
                            "acid": "I"
                        },
                        {
                            "position": "8",
                            "acid": "T"
                        },
                        {
                            "position": "9",
                            "acid": "A"
                        },
                        {
                            "position": "10",
                            "acid": "P"
                        },
                        {
                            "position": "11",
                            "acid": "N"
                        },
                        {
                            "position": "12",
                            "acid": "G"
                        },
                        {
                            "position": "13",
                            "acid": "L"
                        },
                        {
                            "position": "14",
                            "acid": "H"
                        },
                        {
                            "position": "15",
                            "acid": "T"
                        },
                        {
                            "position": "16",
                            "acid": "R"
                        },
                        {
                            "position": "17",
                            "acid": "P"
                        },
                        {
                            "position": "18",
                            "acid": "A"
                        },
                        {
                            "position": "19",
                            "acid": "A"
                        },
                        {
                            "position": "20",
                            "acid": "Q"
                        },
                        {
                            "position": "21",
                            "acid": "F"
                        },
                        {
                            "position": "22",
                            "acid": "V"
                        },
                        {
                            "position": "23",
                            "acid": "K"
                        },
                        {
                            "position": "24",
                            "acid": "E"
                        },
                        {
                            "position": "25",
                            "acid": "A"
                        },
                        {
                            "position": "26",
                            "acid": "K"
                        },
                        {
                            "position": "27",
                            "acid": "G"
                        },
                        {
                            "position": "28",
                            "acid": "F"
                        },
                        {
                            "position": "29",
                            "acid": "T"
                        },
                        {
                            "position": "30",
                            "acid": "S"
                        },
                        {
                            "position": "31",
                            "acid": "E"
                        },
                        {
                            "position": "32",
                            "acid": "I"
                        },
                        {
                            "position": "33",
                            "acid": "T"
                        },
                        {
                            "position": "34",
                            "acid": "V"
                        },
                        {
                            "position": "35",
                            "acid": "T"
                        },
                        {
                            "position": "36",
                            "acid": "S"
                        },
                        {
                            "position": "37",
                            "acid": "N"
                        },
                        {
                            "position": "38",
                            "acid": "G"
                        },
                        {
                            "position": "39",
                            "acid": "K"
                        },
                        {
                            "position": "40",
                            "acid": "S"
                        },
                        {
                            "position": "41",
                            "acid": "A"
                        },
                        {
                            "position": "42",
                            "acid": "S"
                        },
                        {
                            "position": "43",
                            "acid": "A"
                        },
                        {
                            "position": "44",
                            "acid": "K"
                        },
                        {
                            "position": "45",
                            "acid": "S"
                        },
                        {
                            "position": "46",
                            "acid": "L"
                        },
                        {
                            "position": "47",
                            "acid": "F"
                        },
                        {
                            "position": "48",
                            "acid": "K"
                        },
                        {
                            "position": "49",
                            "acid": "L"
                        },
                        {
                            "position": "50",
                            "acid": "Q"
                        },
                        {
                            "position": "51",
                            "acid": "T"
                        },
                        {
                            "position": "52",
                            "acid": "L"
                        },
                        {
                            "position": "53",
                            "acid": "G"
                        },
                        {
                            "position": "54",
                            "acid": "L"
                        },
                        {
                            "position": "55",
                            "acid": "T"
                        },
                        {
                            "position": "56",
                            "acid": "Q"
                        },
                        {
                            "position": "57",
                            "acid": "G"
                        },
                        {
                            "position": "58",
                            "acid": "T"
                        },
                        {
                            "position": "59",
                            "acid": "V"
                        },
                        {
                            "position": "60",
                            "acid": "V"
                        },
                        {
                            "position": "61",
                            "acid": "T"
                        },
                        {
                            "position": "62",
                            "acid": "I"
                        },
                        {
                            "position": "63",
                            "acid": "S"
                        },
                        {
                            "position": "64",
                            "acid": "A"
                        },
                        {
                            "position": "65",
                            "acid": "E"
                        },
                        {
                            "position": "66",
                            "acid": "G"
                        },
                        {
                            "position": "67",
                            "acid": "E"
                        },
                        {
                            "position": "68",
                            "acid": "D"
                        },
                        {
                            "position": "69",
                            "acid": "E"
                        },
                        {
                            "position": "70",
                            "acid": "Q"
                        },
                        {
                            "position": "71",
                            "acid": "K"
                        },
                        {
                            "position": "72",
                            "acid": "A"
                        },
                        {
                            "position": "73",
                            "acid": "V"
                        },
                        {
                            "position": "74",
                            "acid": "E"
                        },
                        {
                            "position": "75",
                            "acid": "H"
                        },
                        {
                            "position": "76",
                            "acid": "L"
                        },
                        {
                            "position": "77",
                            "acid": "V"
                        },
                        {
                            "position": "78",
                            "acid": "K"
                        },
                        {
                            "position": "79",
                            "acid": "L"
                        },
                        {
                            "position": "80",
                            "acid": "M"
                        },
                        {
                            "position": "81",
                            "acid": "A"
                        },
                        {
                            "position": "82",
                            "acid": "E"
                        },
                        {
                            "position": "83",
                            "acid": "L"
                        },
                        {
                            "position": "84",
                            "acid": "E"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "3",
                                    "ion_display_position": "3",
                                    "spec_id": "250",
                                    "peak_id": "17",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "5",
                                    "ion_display_position": "5",
                                    "spec_id": "250",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "6",
                                    "ion_display_position": "6",
                                    "spec_id": "250",
                                    "peak_id": "23",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "61",
                                    "ion_display_position": "24",
                                    "spec_id": "250",
                                    "peak_id": "2",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "63",
                                    "ion_display_position": "22",
                                    "spec_id": "250",
                                    "peak_id": "0",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "69",
                                    "ion_display_position": "16",
                                    "spec_id": "250",
                                    "peak_id": "1",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "75",
                                    "ion_display_position": "10",
                                    "spec_id": "250",
                                    "peak_id": "10",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "78",
                                    "ion_display_position": "7",
                                    "spec_id": "250",
                                    "peak_id": "4",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "mass_shift": {
                        "id": "0",
                        "left_position": "6",
                        "right_position": "61",
                        "shift": "21.1648625875",
                        "anno": "+21.1649",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
