prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "22",
        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
        "proteoform_id": "29",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "163",
                "p_value": "4.11e-12",
                "e_value": "4.11e-12",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "627",
                        "ms1_scans": "972",
                        "ids": "344",
                        "scans": "973",
                        "precursor_mono_mass": "10172.9302",
                        "precursor_charge": "6",
                        "precursor_mz": "1696.4956",
                        "feature_inte": "5.4904e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "344",
                                "peak_id": "0",
                                "monoisotopic_mass": "1336.7151",
                                "monoisotopic_mz": "1337.7224",
                                "intensity": "2278.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.7099",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0052",
                                        "ppm": "3.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "1",
                                "monoisotopic_mass": "1555.8039",
                                "monoisotopic_mz": "1556.8112",
                                "intensity": "1162.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "2",
                                "monoisotopic_mass": "1475.7918",
                                "monoisotopic_mz": "1476.7991",
                                "intensity": "1952.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1475.7806",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0112",
                                        "ppm": "7.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "3",
                                "monoisotopic_mass": "2026.0065",
                                "monoisotopic_mz": "2027.0137",
                                "intensity": "2399.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "4",
                                "monoisotopic_mass": "1811.9187",
                                "monoisotopic_mz": "1812.9259",
                                "intensity": "1491.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "5",
                                "monoisotopic_mass": "2108.1192",
                                "monoisotopic_mz": "2109.1265",
                                "intensity": "641.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2108.1088",
                                        "ion_position": "72",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0104",
                                        "ppm": "4.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "6",
                                "monoisotopic_mass": "2295.1402",
                                "monoisotopic_mz": "2296.1475",
                                "intensity": "2138.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "7",
                                "monoisotopic_mass": "1603.8851",
                                "monoisotopic_mz": "1604.8923",
                                "intensity": "9324.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1603.8756",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0095",
                                        "ppm": "5.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "8",
                                "monoisotopic_mass": "2179.1585",
                                "monoisotopic_mz": "2180.1658",
                                "intensity": "2194.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2179.1460",
                                        "ion_position": "71",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0126",
                                        "ppm": "5.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "9",
                                "monoisotopic_mass": "1698.8295",
                                "monoisotopic_mz": "1699.8368",
                                "intensity": "1624.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "10",
                                "monoisotopic_mass": "1718.9103",
                                "monoisotopic_mz": "1719.9176",
                                "intensity": "2845.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1718.9025",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0078",
                                        "ppm": "4.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "11",
                                "monoisotopic_mass": "1926.9361",
                                "monoisotopic_mz": "1927.9434",
                                "intensity": "1777.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "12",
                                "monoisotopic_mass": "1012.4983",
                                "monoisotopic_mz": "1013.5056",
                                "intensity": "4618.71",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1012.4938",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0046",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "13",
                                "monoisotopic_mass": "2435.3063",
                                "monoisotopic_mz": "2436.3135",
                                "intensity": "7784.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0067",
                                        "ppm": "2.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "14",
                                "monoisotopic_mass": "1437.7129",
                                "monoisotopic_mz": "1438.7202",
                                "intensity": "1250.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "15",
                                "monoisotopic_mass": "1376.7193",
                                "monoisotopic_mz": "1377.7266",
                                "intensity": "3830.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1376.7122",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0071",
                                        "ppm": "5.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "16",
                                "monoisotopic_mass": "3695.8578",
                                "monoisotopic_mz": "1848.9362",
                                "intensity": "3653.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "17",
                                "monoisotopic_mass": "1454.8346",
                                "monoisotopic_mz": "1455.8419",
                                "intensity": "2173.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "18",
                                "monoisotopic_mass": "2067.0367",
                                "monoisotopic_mz": "2068.0440",
                                "intensity": "2086.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "19",
                                "monoisotopic_mass": "1140.5949",
                                "monoisotopic_mz": "1141.6022",
                                "intensity": "8876.74",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0062",
                                        "ppm": "5.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "20",
                                "monoisotopic_mass": "1083.6124",
                                "monoisotopic_mz": "1084.6196",
                                "intensity": "1580.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "21",
                                "monoisotopic_mass": "3579.8154",
                                "monoisotopic_mz": "1790.9150",
                                "intensity": "2222.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "22",
                                "monoisotopic_mass": "3385.5307",
                                "monoisotopic_mz": "1693.7726",
                                "intensity": "2738.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "23",
                                "monoisotopic_mass": "1248.6254",
                                "monoisotopic_mz": "1249.6327",
                                "intensity": "5177.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1248.6173",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0082",
                                        "ppm": "6.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "24",
                                "monoisotopic_mass": "2435.3109",
                                "monoisotopic_mz": "1218.6627",
                                "intensity": "2304.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0114",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "25",
                                "monoisotopic_mass": "1522.7704",
                                "monoisotopic_mz": "1523.7777",
                                "intensity": "1682.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "26",
                                "monoisotopic_mass": "761.4506",
                                "monoisotopic_mz": "762.4578",
                                "intensity": "7645.44",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "761.4469",
                                        "ion_position": "83",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "83",
                                        "mass_error": "0.0036",
                                        "ppm": "4.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "27",
                                "monoisotopic_mass": "2305.0241",
                                "monoisotopic_mz": "1153.5193",
                                "intensity": "1859.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "28",
                                "monoisotopic_mass": "1062.5591",
                                "monoisotopic_mz": "1063.5664",
                                "intensity": "2245.65",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1062.5532",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0059",
                                        "ppm": "5.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "29",
                                "monoisotopic_mass": "2154.0802",
                                "monoisotopic_mz": "2155.0874",
                                "intensity": "1688.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "30",
                                "monoisotopic_mass": "3447.7524",
                                "monoisotopic_mz": "1724.8835",
                                "intensity": "4262.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "31",
                                "monoisotopic_mass": "584.2945",
                                "monoisotopic_mz": "585.3018",
                                "intensity": "7489.65",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "584.2918",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0027",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "32",
                                "monoisotopic_mass": "1658.3222",
                                "monoisotopic_mz": "1659.3295",
                                "intensity": "1434.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "33",
                                "monoisotopic_mass": "2417.2918",
                                "monoisotopic_mz": "2418.2991",
                                "intensity": "1483.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "34",
                                "monoisotopic_mass": "843.4161",
                                "monoisotopic_mz": "844.4233",
                                "intensity": "1012.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "35",
                                "monoisotopic_mass": "856.4480",
                                "monoisotopic_mz": "857.4553",
                                "intensity": "862.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "36",
                                "monoisotopic_mass": "1673.8583",
                                "monoisotopic_mz": "1674.8656",
                                "intensity": "1519.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "37",
                                "monoisotopic_mass": "1537.7898",
                                "monoisotopic_mz": "1538.7971",
                                "intensity": "1652.02",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1537.7849",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0050",
                                        "ppm": "3.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "38",
                                "monoisotopic_mass": "2477.0704",
                                "monoisotopic_mz": "1239.5425",
                                "intensity": "578.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "39",
                                "monoisotopic_mass": "739.3423",
                                "monoisotopic_mz": "740.3495",
                                "intensity": "1888.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "40",
                                "monoisotopic_mass": "655.3321",
                                "monoisotopic_mz": "656.3394",
                                "intensity": "3917.31",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "655.3289",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0032",
                                        "ppm": "4.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "41",
                                "monoisotopic_mass": "2565.1759",
                                "monoisotopic_mz": "1283.5952",
                                "intensity": "2276.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "42",
                                "monoisotopic_mass": "627.3370",
                                "monoisotopic_mz": "628.3443",
                                "intensity": "1954.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "43",
                                "monoisotopic_mass": "520.2702",
                                "monoisotopic_mz": "521.2775",
                                "intensity": "3527.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "520.2679",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "85",
                                        "mass_error": "0.0023",
                                        "ppm": "4.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "44",
                                "monoisotopic_mass": "2636.2164",
                                "monoisotopic_mz": "1319.1155",
                                "intensity": "3420.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "45",
                                "monoisotopic_mass": "876.4782",
                                "monoisotopic_mz": "877.4855",
                                "intensity": "1242.58",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "876.4739",
                                        "ion_position": "82",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "82",
                                        "mass_error": "0.0043",
                                        "ppm": "4.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "46",
                                "monoisotopic_mass": "566.2834",
                                "monoisotopic_mz": "567.2906",
                                "intensity": "2602.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "47",
                                "monoisotopic_mass": "2737.2220",
                                "monoisotopic_mz": "1369.6183",
                                "intensity": "1612.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "48",
                                "monoisotopic_mass": "683.3321",
                                "monoisotopic_mz": "684.3394",
                                "intensity": "550.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "49",
                                "monoisotopic_mass": "1293.6608",
                                "monoisotopic_mz": "1294.6681",
                                "intensity": "737.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "50",
                                "monoisotopic_mass": "412.1609",
                                "monoisotopic_mz": "413.1682",
                                "intensity": "2636.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "51",
                                "monoisotopic_mass": "3637.8248",
                                "monoisotopic_mz": "1819.9197",
                                "intensity": "2689.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "52",
                                "monoisotopic_mass": "1123.5663",
                                "monoisotopic_mz": "1124.5736",
                                "intensity": "1380.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "53",
                                "monoisotopic_mass": "984.5432",
                                "monoisotopic_mz": "985.5505",
                                "intensity": "1219.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "54",
                                "monoisotopic_mass": "3022.3624",
                                "monoisotopic_mz": "1512.1885",
                                "intensity": "1378.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "55",
                                "monoisotopic_mass": "4704.8425",
                                "monoisotopic_mz": "1177.2179",
                                "intensity": "966.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "56",
                                "monoisotopic_mass": "3618.8236",
                                "monoisotopic_mz": "1810.4191",
                                "intensity": "2254.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "57",
                                "monoisotopic_mass": "3896.9906",
                                "monoisotopic_mz": "1949.5026",
                                "intensity": "2583.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "58",
                                "monoisotopic_mass": "3073.5507",
                                "monoisotopic_mz": "1537.7826",
                                "intensity": "1135.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "59",
                                "monoisotopic_mass": "4011.0240",
                                "monoisotopic_mz": "2006.5193",
                                "intensity": "1704.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "60",
                                "monoisotopic_mass": "3677.8597",
                                "monoisotopic_mz": "1839.9371",
                                "intensity": "867.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "61",
                                "monoisotopic_mass": "2850.3133",
                                "monoisotopic_mz": "1426.1639",
                                "intensity": "874.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "62",
                                "monoisotopic_mass": "3795.9395",
                                "monoisotopic_mz": "1898.9770",
                                "intensity": "2296.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "63",
                                "monoisotopic_mass": "1823.9134",
                                "monoisotopic_mz": "1824.9207",
                                "intensity": "1311.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "64",
                                "monoisotopic_mass": "2679.2008",
                                "monoisotopic_mz": "1340.6077",
                                "intensity": "1537.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "65",
                                "monoisotopic_mass": "3866.9771",
                                "monoisotopic_mz": "1934.4958",
                                "intensity": "2190.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "66",
                                "monoisotopic_mass": "3594.8155",
                                "monoisotopic_mz": "1798.4150",
                                "intensity": "7068.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "67",
                                "monoisotopic_mass": "3325.5050",
                                "monoisotopic_mz": "1663.7598",
                                "intensity": "1604.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "68",
                                "monoisotopic_mass": "3737.8679",
                                "monoisotopic_mz": "1869.9412",
                                "intensity": "2431.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "69",
                                "monoisotopic_mass": "1898.9672",
                                "monoisotopic_mz": "1899.9745",
                                "intensity": "857.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "70",
                                "monoisotopic_mass": "3766.8633",
                                "monoisotopic_mz": "1884.4389",
                                "intensity": "2720.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "71",
                                "monoisotopic_mass": "3512.5782",
                                "monoisotopic_mz": "1757.2964",
                                "intensity": "2413.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "72",
                                "monoisotopic_mass": "2807.2617",
                                "monoisotopic_mz": "1404.6381",
                                "intensity": "2008.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "73",
                                "monoisotopic_mass": "3340.5116",
                                "monoisotopic_mz": "1671.2631",
                                "intensity": "4209.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "344",
                                "peak_id": "74",
                                "monoisotopic_mass": "3966.0159",
                                "monoisotopic_mz": "1984.0152",
                                "intensity": "3366.26",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "22",
                    "proteoform_id": "29",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "proteoform_mass": "10173.1302",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "21",
                        "last_residue_position": "109",
                        "annotated_seq": "A.ADAQKAADNKKPVNS(WT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+324.2585]KQANFKDKVKGEWDKIKKDM.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "L"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "L"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "L"
                            },
                            {
                                "position": "15",
                                "acid": "P"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "D"
                            },
                            {
                                "position": "29",
                                "acid": "N"
                            },
                            {
                                "position": "30",
                                "acid": "K"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "P"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "S"
                            },
                            {
                                "position": "36",
                                "acid": "W"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "E"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "D"
                            },
                            {
                                "position": "46",
                                "acid": "E"
                            },
                            {
                                "position": "47",
                                "acid": "S"
                            },
                            {
                                "position": "48",
                                "acid": "F"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "P"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "V"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "F"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "A"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "K"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "D"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "Q"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "A"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "T"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "I"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "Q"
                            },
                            {
                                "position": "85",
                                "acid": "A"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "T"
                            },
                            {
                                "position": "88",
                                "acid": "Q"
                            },
                            {
                                "position": "89",
                                "acid": "D"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "F"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "V"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "G"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "W"
                            },
                            {
                                "position": "103",
                                "acid": "D"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "K"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "344",
                                        "peak_id": "31",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "344",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "344",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "344",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "344",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "344",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "344",
                                            "peak_id": "13",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "344",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "18",
                                        "spec_id": "344",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "17",
                                        "spec_id": "344",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "spec_id": "344",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "spec_id": "344",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "spec_id": "344",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "spec_id": "344",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "spec_id": "344",
                                        "peak_id": "23",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "spec_id": "344",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "82",
                                        "ion_display_position": "7",
                                        "spec_id": "344",
                                        "peak_id": "45",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "6",
                                        "spec_id": "344",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "spec_id": "344",
                                        "peak_id": "43",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "36",
                            "right_position": "90",
                            "shift": "324.2584835793",
                            "anno": "+324.2585",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "140",
                "p_value": "2.10e-10",
                "e_value": "2.10e-10",
                "fdr": "0",
                "matched_fragment_number": "19",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "616",
                        "ms1_scans": "928",
                        "ids": "311",
                        "scans": "929",
                        "precursor_mono_mass": "10172.9302",
                        "precursor_charge": "6",
                        "precursor_mz": "1696.4956",
                        "feature_inte": "5.4904e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "311",
                                "peak_id": "0",
                                "monoisotopic_mass": "1847.0124",
                                "monoisotopic_mz": "1848.0197",
                                "intensity": "1365.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1846.9975",
                                        "ion_position": "74",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0149",
                                        "ppm": "8.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "1",
                                "monoisotopic_mass": "1967.9756",
                                "monoisotopic_mz": "1968.9828",
                                "intensity": "2232.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "2",
                                "monoisotopic_mass": "2418.2911",
                                "monoisotopic_mz": "2419.2984",
                                "intensity": "2093.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "3",
                                "monoisotopic_mass": "1718.9124",
                                "monoisotopic_mz": "1719.9197",
                                "intensity": "4497.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1718.9025",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0099",
                                        "ppm": "5.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "4",
                                "monoisotopic_mass": "2026.0090",
                                "monoisotopic_mz": "2027.0163",
                                "intensity": "3497.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "5",
                                "monoisotopic_mass": "2435.3033",
                                "monoisotopic_mz": "2436.3106",
                                "intensity": "11862.42",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0038",
                                        "ppm": "1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "6",
                                "monoisotopic_mass": "1749.8893",
                                "monoisotopic_mz": "1750.8966",
                                "intensity": "2193.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "7",
                                "monoisotopic_mass": "2295.1493",
                                "monoisotopic_mz": "2296.1565",
                                "intensity": "3760.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "8",
                                "monoisotopic_mass": "2211.0990",
                                "monoisotopic_mz": "2212.1062",
                                "intensity": "2372.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "9",
                                "monoisotopic_mass": "1603.8826",
                                "monoisotopic_mz": "1604.8899",
                                "intensity": "14908.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1603.8756",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0070",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "10",
                                "monoisotopic_mass": "1673.8552",
                                "monoisotopic_mz": "1674.8624",
                                "intensity": "3239.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "11",
                                "monoisotopic_mass": "1454.8334",
                                "monoisotopic_mz": "1455.8407",
                                "intensity": "3571.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "12",
                                "monoisotopic_mass": "1336.7131",
                                "monoisotopic_mz": "1337.7203",
                                "intensity": "2996.79",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.7099",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0031",
                                        "ppm": "2.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "13",
                                "monoisotopic_mass": "2550.3243",
                                "monoisotopic_mz": "2551.3316",
                                "intensity": "2502.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2550.3264",
                                        "ion_position": "68",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "Y00021",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "14",
                                "monoisotopic_mass": "1926.9381",
                                "monoisotopic_mz": "1927.9453",
                                "intensity": "2998.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "15",
                                "monoisotopic_mass": "3341.5120",
                                "monoisotopic_mz": "1671.7633",
                                "intensity": "7060.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "16",
                                "monoisotopic_mass": "3766.8644",
                                "monoisotopic_mz": "1884.4395",
                                "intensity": "5267.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "17",
                                "monoisotopic_mass": "3475.7575",
                                "monoisotopic_mz": "1738.8860",
                                "intensity": "2712.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "18",
                                "monoisotopic_mass": "3494.7744",
                                "monoisotopic_mz": "1748.3945",
                                "intensity": "3648.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "19",
                                "monoisotopic_mass": "1012.4986",
                                "monoisotopic_mz": "1013.5059",
                                "intensity": "6672.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1012.4938",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0049",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "20",
                                "monoisotopic_mass": "1140.5951",
                                "monoisotopic_mz": "1141.6024",
                                "intensity": "13263.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0064",
                                        "ppm": "5.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "21",
                                "monoisotopic_mass": "2394.2105",
                                "monoisotopic_mz": "2395.2178",
                                "intensity": "2790.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "22",
                                "monoisotopic_mass": "1427.7122",
                                "monoisotopic_mz": "1428.7195",
                                "intensity": "2642.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "23",
                                "monoisotopic_mass": "2154.0633",
                                "monoisotopic_mz": "2155.0706",
                                "intensity": "2745.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "24",
                                "monoisotopic_mass": "3967.0151",
                                "monoisotopic_mz": "1984.5148",
                                "intensity": "6040.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "25",
                                "monoisotopic_mass": "3594.8166",
                                "monoisotopic_mz": "1798.4156",
                                "intensity": "13335.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "26",
                                "monoisotopic_mass": "1083.6137",
                                "monoisotopic_mz": "1084.6210",
                                "intensity": "2202.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "27",
                                "monoisotopic_mass": "3576.7964",
                                "monoisotopic_mz": "1789.4055",
                                "intensity": "5414.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "28",
                                "monoisotopic_mass": "1494.7358",
                                "monoisotopic_mz": "1495.7430",
                                "intensity": "1315.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "29",
                                "monoisotopic_mass": "1376.7210",
                                "monoisotopic_mz": "1377.7283",
                                "intensity": "6676.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1376.7122",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0088",
                                        "ppm": "6.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "30",
                                "monoisotopic_mass": "884.4031",
                                "monoisotopic_mz": "885.4103",
                                "intensity": "3053.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "884.3988",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0043",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "31",
                                "monoisotopic_mass": "1123.5632",
                                "monoisotopic_mz": "1124.5704",
                                "intensity": "1965.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "32",
                                "monoisotopic_mass": "1475.7922",
                                "monoisotopic_mz": "1476.7994",
                                "intensity": "2392.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1475.7806",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0115",
                                        "ppm": "7.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "33",
                                "monoisotopic_mass": "1537.7918",
                                "monoisotopic_mz": "1538.7991",
                                "intensity": "1946.18",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1537.7849",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0069",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "34",
                                "monoisotopic_mass": "770.3597",
                                "monoisotopic_mz": "771.3670",
                                "intensity": "16479.29",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "770.3559",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0038",
                                        "ppm": "5.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "35",
                                "monoisotopic_mass": "2452.0907",
                                "monoisotopic_mz": "1227.0526",
                                "intensity": "2115.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "36",
                                "monoisotopic_mass": "1223.6197",
                                "monoisotopic_mz": "1224.6270",
                                "intensity": "1905.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "37",
                                "monoisotopic_mass": "1062.5590",
                                "monoisotopic_mz": "1063.5663",
                                "intensity": "3863.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1062.5532",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0058",
                                        "ppm": "5.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "38",
                                "monoisotopic_mass": "2049.0374",
                                "monoisotopic_mz": "2050.0447",
                                "intensity": "1461.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "39",
                                "monoisotopic_mass": "566.2834",
                                "monoisotopic_mz": "567.2907",
                                "intensity": "4473.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "40",
                                "monoisotopic_mass": "1248.6235",
                                "monoisotopic_mz": "1249.6307",
                                "intensity": "6770.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1248.6173",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0062",
                                        "ppm": "4.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "41",
                                "monoisotopic_mass": "3695.8615",
                                "monoisotopic_mz": "1848.9380",
                                "intensity": "6754.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "42",
                                "monoisotopic_mass": "1187.6005",
                                "monoisotopic_mz": "1188.6078",
                                "intensity": "1808.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "43",
                                "monoisotopic_mass": "1810.9057",
                                "monoisotopic_mz": "1811.9130",
                                "intensity": "1696.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "44",
                                "monoisotopic_mass": "2435.3141",
                                "monoisotopic_mz": "1218.6643",
                                "intensity": "3347.82",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0146",
                                        "ppm": "6.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "45",
                                "monoisotopic_mass": "739.3429",
                                "monoisotopic_mz": "740.3502",
                                "intensity": "3203.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "46",
                                "monoisotopic_mass": "584.2944",
                                "monoisotopic_mz": "585.3017",
                                "intensity": "11144.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "584.2918",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0026",
                                        "ppm": "4.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "47",
                                "monoisotopic_mass": "1415.7115",
                                "monoisotopic_mz": "1416.7187",
                                "intensity": "1284.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "48",
                                "monoisotopic_mass": "655.3320",
                                "monoisotopic_mz": "656.3392",
                                "intensity": "6017.03",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "655.3289",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0030",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "49",
                                "monoisotopic_mass": "843.4159",
                                "monoisotopic_mz": "844.4232",
                                "intensity": "1523.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "50",
                                "monoisotopic_mass": "3638.8203",
                                "monoisotopic_mz": "1820.4174",
                                "intensity": "4037.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "51",
                                "monoisotopic_mass": "954.5283",
                                "monoisotopic_mz": "955.5356",
                                "intensity": "1410.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "52",
                                "monoisotopic_mass": "2636.2155",
                                "monoisotopic_mz": "1319.1150",
                                "intensity": "5219.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "53",
                                "monoisotopic_mass": "2505.4007",
                                "monoisotopic_mz": "1253.7076",
                                "intensity": "2572.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "54",
                                "monoisotopic_mass": "1773.9054",
                                "monoisotopic_mz": "1774.9127",
                                "intensity": "1359.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "55",
                                "monoisotopic_mass": "3748.8608",
                                "monoisotopic_mz": "1875.4377",
                                "intensity": "1958.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "56",
                                "monoisotopic_mass": "937.5027",
                                "monoisotopic_mz": "938.5099",
                                "intensity": "962.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "57",
                                "monoisotopic_mass": "513.2568",
                                "monoisotopic_mz": "514.2640",
                                "intensity": "3710.65",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "513.2547",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "B00005",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0020",
                                        "ppm": "3.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "58",
                                "monoisotopic_mass": "2735.2801",
                                "monoisotopic_mz": "1368.6473",
                                "intensity": "2902.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "59",
                                "monoisotopic_mass": "4011.0329",
                                "monoisotopic_mz": "2006.5237",
                                "intensity": "2571.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "60",
                                "monoisotopic_mass": "2535.1603",
                                "monoisotopic_mz": "1268.5874",
                                "intensity": "2362.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "61",
                                "monoisotopic_mass": "2741.5334",
                                "monoisotopic_mz": "914.8517",
                                "intensity": "1466.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "62",
                                "monoisotopic_mass": "3445.7687",
                                "monoisotopic_mz": "1723.8916",
                                "intensity": "4480.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "63",
                                "monoisotopic_mass": "2565.1753",
                                "monoisotopic_mz": "1283.5949",
                                "intensity": "3576.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "64",
                                "monoisotopic_mass": "3323.4997",
                                "monoisotopic_mz": "1662.7572",
                                "intensity": "1445.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "65",
                                "monoisotopic_mass": "2821.4122",
                                "monoisotopic_mz": "1411.7134",
                                "intensity": "1284.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "66",
                                "monoisotopic_mass": "2778.2855",
                                "monoisotopic_mz": "1390.1500",
                                "intensity": "2116.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "67",
                                "monoisotopic_mass": "1806.9124",
                                "monoisotopic_mz": "904.4635",
                                "intensity": "760.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "68",
                                "monoisotopic_mass": "2154.9826",
                                "monoisotopic_mz": "1078.4986",
                                "intensity": "574.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "69",
                                "monoisotopic_mass": "3676.8530",
                                "monoisotopic_mz": "1839.4338",
                                "intensity": "2497.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "70",
                                "monoisotopic_mass": "3022.3624",
                                "monoisotopic_mz": "1512.1885",
                                "intensity": "2101.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "71",
                                "monoisotopic_mass": "4137.1107",
                                "monoisotopic_mz": "2069.5626",
                                "intensity": "2915.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "72",
                                "monoisotopic_mass": "2850.2946",
                                "monoisotopic_mz": "1426.1546",
                                "intensity": "2812.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "73",
                                "monoisotopic_mass": "3214.5761",
                                "monoisotopic_mz": "1608.2953",
                                "intensity": "1278.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "74",
                                "monoisotopic_mass": "2305.0214",
                                "monoisotopic_mz": "1153.5180",
                                "intensity": "2285.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "75",
                                "monoisotopic_mass": "2809.2635",
                                "monoisotopic_mz": "937.4285",
                                "intensity": "645.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "76",
                                "monoisotopic_mass": "1698.8261",
                                "monoisotopic_mz": "1699.8334",
                                "intensity": "2675.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "77",
                                "monoisotopic_mass": "3086.5128",
                                "monoisotopic_mz": "1544.2637",
                                "intensity": "1911.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "78",
                                "monoisotopic_mass": "3196.4401",
                                "monoisotopic_mz": "1599.2273",
                                "intensity": "1604.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "79",
                                "monoisotopic_mass": "1623.7947",
                                "monoisotopic_mz": "1624.8020",
                                "intensity": "779.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "80",
                                "monoisotopic_mass": "5843.1262",
                                "monoisotopic_mz": "1169.6325",
                                "intensity": "547.69",
                                "charge": "5"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "81",
                                "monoisotopic_mass": "3867.9188",
                                "monoisotopic_mz": "1934.9667",
                                "intensity": "2344.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "82",
                                "monoisotopic_mass": "2604.4696",
                                "monoisotopic_mz": "1303.2421",
                                "intensity": "2118.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "83",
                                "monoisotopic_mass": "2417.3082",
                                "monoisotopic_mz": "1209.6614",
                                "intensity": "623.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "84",
                                "monoisotopic_mass": "3384.5211",
                                "monoisotopic_mz": "1693.2678",
                                "intensity": "2727.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "85",
                                "monoisotopic_mass": "3849.9520",
                                "monoisotopic_mz": "1925.9833",
                                "intensity": "1382.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "86",
                                "monoisotopic_mass": "3895.9629",
                                "monoisotopic_mz": "1948.9887",
                                "intensity": "3381.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "87",
                                "monoisotopic_mass": "1657.8813",
                                "monoisotopic_mz": "1658.8885",
                                "intensity": "1243.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "88",
                                "monoisotopic_mass": "1898.4594",
                                "monoisotopic_mz": "1899.4666",
                                "intensity": "1875.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "89",
                                "monoisotopic_mass": "6518.0403",
                                "monoisotopic_mz": "1630.5173",
                                "intensity": "2015.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "90",
                                "monoisotopic_mass": "2179.1471",
                                "monoisotopic_mz": "2180.1544",
                                "intensity": "1874.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2179.1460",
                                        "ion_position": "71",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0012",
                                        "ppm": "0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "91",
                                "monoisotopic_mass": "6621.4187",
                                "monoisotopic_mz": "1325.2910",
                                "intensity": "725.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "92",
                                "monoisotopic_mass": "3110.3823",
                                "monoisotopic_mz": "1556.1984",
                                "intensity": "912.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "93",
                                "monoisotopic_mass": "2107.1091",
                                "monoisotopic_mz": "2108.1164",
                                "intensity": "2074.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "94",
                                "monoisotopic_mass": "1993.0684",
                                "monoisotopic_mz": "1994.0757",
                                "intensity": "2071.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "95",
                                "monoisotopic_mass": "2621.1950",
                                "monoisotopic_mz": "1311.6048",
                                "intensity": "2074.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "96",
                                "monoisotopic_mass": "2124.0659",
                                "monoisotopic_mz": "2125.0731",
                                "intensity": "1796.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "97",
                                "monoisotopic_mass": "6700.0245",
                                "monoisotopic_mz": "1341.0122",
                                "intensity": "1637.68",
                                "charge": "5"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "98",
                                "monoisotopic_mass": "3513.5591",
                                "monoisotopic_mz": "1757.7868",
                                "intensity": "4424.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "99",
                                "monoisotopic_mass": "4023.1563",
                                "monoisotopic_mz": "1342.0594",
                                "intensity": "609.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "100",
                                "monoisotopic_mass": "2808.2547",
                                "monoisotopic_mz": "1405.1346",
                                "intensity": "2083.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "101",
                                "monoisotopic_mass": "2008.0026",
                                "monoisotopic_mz": "2009.0099",
                                "intensity": "1050.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "102",
                                "monoisotopic_mass": "4355.1624",
                                "monoisotopic_mz": "1452.7281",
                                "intensity": "690.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "103",
                                "monoisotopic_mass": "2721.2558",
                                "monoisotopic_mz": "1361.6352",
                                "intensity": "1427.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "104",
                                "monoisotopic_mass": "2907.3288",
                                "monoisotopic_mz": "1454.6717",
                                "intensity": "2702.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "105",
                                "monoisotopic_mass": "1938.4775",
                                "monoisotopic_mz": "1939.4848",
                                "intensity": "1598.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "106",
                                "monoisotopic_mass": "3617.8172",
                                "monoisotopic_mz": "1809.9159",
                                "intensity": "2825.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "107",
                                "monoisotopic_mass": "9075.0073",
                                "monoisotopic_mz": "1513.5085",
                                "intensity": "454.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "311",
                                "peak_id": "108",
                                "monoisotopic_mass": "1789.8970",
                                "monoisotopic_mz": "1790.9043",
                                "intensity": "1994.92",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "22",
                    "proteoform_id": "29",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "proteoform_mass": "10173.1302",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "21",
                        "last_residue_position": "109",
                        "annotated_seq": "A.ADAQKAADNKKPVNS(WT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQ)[+324.2585]DKQANFKDKVKGEWDKIKKDM.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "L"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "L"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "L"
                            },
                            {
                                "position": "15",
                                "acid": "P"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "D"
                            },
                            {
                                "position": "29",
                                "acid": "N"
                            },
                            {
                                "position": "30",
                                "acid": "K"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "P"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "S"
                            },
                            {
                                "position": "36",
                                "acid": "W"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "E"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "D"
                            },
                            {
                                "position": "46",
                                "acid": "E"
                            },
                            {
                                "position": "47",
                                "acid": "S"
                            },
                            {
                                "position": "48",
                                "acid": "F"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "P"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "V"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "F"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "A"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "K"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "D"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "Q"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "A"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "T"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "I"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "Q"
                            },
                            {
                                "position": "85",
                                "acid": "A"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "T"
                            },
                            {
                                "position": "88",
                                "acid": "Q"
                            },
                            {
                                "position": "89",
                                "acid": "D"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "F"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "V"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "G"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "W"
                            },
                            {
                                "position": "103",
                                "acid": "D"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "K"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "5",
                                        "ion_display_position": "5",
                                        "spec_id": "311",
                                        "peak_id": "57",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "311",
                                        "peak_id": "46",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "311",
                                        "peak_id": "48",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "311",
                                        "peak_id": "34",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "311",
                                        "peak_id": "30",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "311",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "311",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "311",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "311",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "21",
                                        "spec_id": "311",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "311",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "311",
                                            "peak_id": "44",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "18",
                                        "spec_id": "311",
                                        "peak_id": "90",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "15",
                                        "spec_id": "311",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "spec_id": "311",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "spec_id": "311",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "spec_id": "311",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "spec_id": "311",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "spec_id": "311",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "spec_id": "311",
                                        "peak_id": "37",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "36",
                            "right_position": "89",
                            "shift": "324.2584835793",
                            "anno": "+324.2585",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "119",
                "p_value": "1.42e-09",
                "e_value": "1.42e-09",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "605",
                        "ms1_scans": "884",
                        "ids": "280",
                        "scans": "887",
                        "precursor_mono_mass": "10172.9017",
                        "precursor_charge": "6",
                        "precursor_mz": "1696.4909",
                        "feature_inte": "9.1375e+06"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "280",
                                "peak_id": "0",
                                "monoisotopic_mass": "1718.9200",
                                "monoisotopic_mz": "1719.9272",
                                "intensity": "1727.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "1",
                                "monoisotopic_mass": "2435.3055",
                                "monoisotopic_mz": "2436.3128",
                                "intensity": "4336.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0060",
                                        "ppm": "2.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "2",
                                "monoisotopic_mass": "1603.8851",
                                "monoisotopic_mz": "1604.8923",
                                "intensity": "5772.87",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1603.8756",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0095",
                                        "ppm": "5.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "3",
                                "monoisotopic_mass": "1140.5949",
                                "monoisotopic_mz": "1141.6022",
                                "intensity": "6247.37",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0062",
                                        "ppm": "5.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "4",
                                "monoisotopic_mass": "1012.4983",
                                "monoisotopic_mz": "1013.5056",
                                "intensity": "2503.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1012.4938",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0046",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "5",
                                "monoisotopic_mass": "1376.7184",
                                "monoisotopic_mz": "1377.7257",
                                "intensity": "2048.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1376.7122",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0062",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "6",
                                "monoisotopic_mass": "2296.1519",
                                "monoisotopic_mz": "2297.1592",
                                "intensity": "1242.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "7",
                                "monoisotopic_mass": "1404.1349",
                                "monoisotopic_mz": "1405.1422",
                                "intensity": "1059.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "8",
                                "monoisotopic_mass": "1454.8339",
                                "monoisotopic_mz": "1455.8412",
                                "intensity": "1345.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "9",
                                "monoisotopic_mass": "1122.5825",
                                "monoisotopic_mz": "1123.5897",
                                "intensity": "1127.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "10",
                                "monoisotopic_mass": "761.4506",
                                "monoisotopic_mz": "762.4579",
                                "intensity": "4985.96",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "761.4469",
                                        "ion_position": "83",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "83",
                                        "mass_error": "0.0037",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "11",
                                "monoisotopic_mass": "1698.8339",
                                "monoisotopic_mz": "1699.8412",
                                "intensity": "1091.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "12",
                                "monoisotopic_mass": "984.5440",
                                "monoisotopic_mz": "985.5513",
                                "intensity": "491.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "13",
                                "monoisotopic_mass": "1824.9197",
                                "monoisotopic_mz": "913.4671",
                                "intensity": "785.54",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1824.9119",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0078",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "14",
                                "monoisotopic_mass": "1248.6249",
                                "monoisotopic_mz": "1249.6322",
                                "intensity": "2593.07",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1248.6173",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0077",
                                        "ppm": "6.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "15",
                                "monoisotopic_mass": "584.2942",
                                "monoisotopic_mz": "585.3015",
                                "intensity": "3686.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "584.2918",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0024",
                                        "ppm": "4.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "16",
                                "monoisotopic_mass": "728.3536",
                                "monoisotopic_mz": "729.3608",
                                "intensity": "871.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "17",
                                "monoisotopic_mass": "3342.5141",
                                "monoisotopic_mz": "1672.2644",
                                "intensity": "1495.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "18",
                                "monoisotopic_mass": "884.4031",
                                "monoisotopic_mz": "885.4103",
                                "intensity": "663.42",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "884.3988",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0043",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "19",
                                "monoisotopic_mass": "2435.3126",
                                "monoisotopic_mz": "1218.6636",
                                "intensity": "1432.23",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0131",
                                        "ppm": "5.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "20",
                                "monoisotopic_mass": "3695.8654",
                                "monoisotopic_mz": "1848.9400",
                                "intensity": "2784.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "21",
                                "monoisotopic_mass": "5453.7978",
                                "monoisotopic_mz": "1364.4567",
                                "intensity": "2980.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "22",
                                "monoisotopic_mass": "520.2700",
                                "monoisotopic_mz": "521.2773",
                                "intensity": "1620.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "520.2679",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "85",
                                        "mass_error": "0.0021",
                                        "ppm": "4.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "23",
                                "monoisotopic_mass": "2636.2111",
                                "monoisotopic_mz": "1319.1128",
                                "intensity": "2219.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "24",
                                "monoisotopic_mass": "1083.6147",
                                "monoisotopic_mz": "1084.6219",
                                "intensity": "978.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "25",
                                "monoisotopic_mass": "1336.7138",
                                "monoisotopic_mz": "1337.7211",
                                "intensity": "796.79",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.7099",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0039",
                                        "ppm": "2.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "26",
                                "monoisotopic_mass": "1475.7880",
                                "monoisotopic_mz": "1476.7953",
                                "intensity": "1048.57",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1475.7806",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0074",
                                        "ppm": "5.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "27",
                                "monoisotopic_mass": "655.3323",
                                "monoisotopic_mz": "656.3395",
                                "intensity": "1996.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "655.3289",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0033",
                                        "ppm": "5.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "28",
                                "monoisotopic_mass": "1187.5983",
                                "monoisotopic_mz": "1188.6056",
                                "intensity": "740.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "29",
                                "monoisotopic_mass": "2850.3160",
                                "monoisotopic_mz": "1426.1653",
                                "intensity": "580.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "30",
                                "monoisotopic_mass": "3967.0145",
                                "monoisotopic_mz": "1984.5145",
                                "intensity": "2113.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "31",
                                "monoisotopic_mass": "3097.7028",
                                "monoisotopic_mz": "1033.5749",
                                "intensity": "808.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "32",
                                "monoisotopic_mass": "556.2857",
                                "monoisotopic_mz": "557.2930",
                                "intensity": "540.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "33",
                                "monoisotopic_mass": "3576.7913",
                                "monoisotopic_mz": "1789.4029",
                                "intensity": "2443.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "34",
                                "monoisotopic_mass": "3894.9774",
                                "monoisotopic_mz": "1948.4960",
                                "intensity": "1161.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "35",
                                "monoisotopic_mass": "957.5034",
                                "monoisotopic_mz": "958.5106",
                                "intensity": "459.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "36",
                                "monoisotopic_mass": "7690.9427",
                                "monoisotopic_mz": "1539.1958",
                                "intensity": "967.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "37",
                                "monoisotopic_mass": "784.4295",
                                "monoisotopic_mz": "785.4368",
                                "intensity": "417.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "38",
                                "monoisotopic_mass": "4309.1414",
                                "monoisotopic_mz": "2155.5780",
                                "intensity": "1544.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "39",
                                "monoisotopic_mass": "5493.7510",
                                "monoisotopic_mz": "1374.4450",
                                "intensity": "1463.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "40",
                                "monoisotopic_mass": "2506.4118",
                                "monoisotopic_mz": "1254.2132",
                                "intensity": "560.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "41",
                                "monoisotopic_mass": "1747.3874",
                                "monoisotopic_mz": "1748.3947",
                                "intensity": "1383.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "42",
                                "monoisotopic_mass": "3324.3529",
                                "monoisotopic_mz": "1663.1837",
                                "intensity": "963.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "43",
                                "monoisotopic_mass": "3593.8142",
                                "monoisotopic_mz": "1797.9144",
                                "intensity": "4433.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "44",
                                "monoisotopic_mass": "1282.5871",
                                "monoisotopic_mz": "1283.5944",
                                "intensity": "784.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "45",
                                "monoisotopic_mass": "483.2166",
                                "monoisotopic_mz": "484.2239",
                                "intensity": "1014.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "46",
                                "monoisotopic_mass": "3766.8709",
                                "monoisotopic_mz": "1884.4427",
                                "intensity": "1980.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "47",
                                "monoisotopic_mass": "2758.3665",
                                "monoisotopic_mz": "1380.1905",
                                "intensity": "2211.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "48",
                                "monoisotopic_mass": "3816.9909",
                                "monoisotopic_mz": "1909.5027",
                                "intensity": "696.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "49",
                                "monoisotopic_mass": "1488.6741",
                                "monoisotopic_mz": "1489.6814",
                                "intensity": "328.83",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "22",
                    "proteoform_id": "29",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "proteoform_mass": "10173.1017",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "21",
                        "last_residue_position": "109",
                        "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+324.2300]KQANFKDKVKGEWDKIKKDM.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "L"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "L"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "L"
                            },
                            {
                                "position": "15",
                                "acid": "P"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "D"
                            },
                            {
                                "position": "29",
                                "acid": "N"
                            },
                            {
                                "position": "30",
                                "acid": "K"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "P"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "S"
                            },
                            {
                                "position": "36",
                                "acid": "W"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "E"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "D"
                            },
                            {
                                "position": "46",
                                "acid": "E"
                            },
                            {
                                "position": "47",
                                "acid": "S"
                            },
                            {
                                "position": "48",
                                "acid": "F"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "P"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "V"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "F"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "A"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "K"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "D"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "Q"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "A"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "T"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "I"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "Q"
                            },
                            {
                                "position": "85",
                                "acid": "A"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "T"
                            },
                            {
                                "position": "88",
                                "acid": "Q"
                            },
                            {
                                "position": "89",
                                "acid": "D"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "F"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "V"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "G"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "W"
                            },
                            {
                                "position": "103",
                                "acid": "D"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "K"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "280",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "280",
                                        "peak_id": "27",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "280",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "280",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "280",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "280",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "280",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "280",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "280",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "spec_id": "280",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "spec_id": "280",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "spec_id": "280",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "spec_id": "280",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "6",
                                        "spec_id": "280",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "spec_id": "280",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "38",
                            "right_position": "90",
                            "shift": "324.2299835793",
                            "anno": "+324.2300",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "164",
                "p_value": "4.44e-09",
                "e_value": "4.44e-09",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "627",
                        "ms1_scans": "972",
                        "ids": "345",
                        "scans": "974",
                        "precursor_mono_mass": "10172.9302",
                        "precursor_charge": "8",
                        "precursor_mz": "1272.6236",
                        "feature_inte": "5.4904e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "345",
                                "peak_id": "0",
                                "monoisotopic_mass": "1603.8843",
                                "monoisotopic_mz": "1604.8916",
                                "intensity": "3125.33",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1603.8756",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0087",
                                        "ppm": "5.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "1",
                                "monoisotopic_mass": "1140.5950",
                                "monoisotopic_mz": "1141.6023",
                                "intensity": "2731.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0063",
                                        "ppm": "5.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "2",
                                "monoisotopic_mass": "770.3595",
                                "monoisotopic_mz": "771.3668",
                                "intensity": "4209.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "770.3559",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0036",
                                        "ppm": "4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "3",
                                "monoisotopic_mass": "1336.7137",
                                "monoisotopic_mz": "1337.7209",
                                "intensity": "946.24",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1336.7099",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0038",
                                        "ppm": "2.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "4",
                                "monoisotopic_mass": "2435.2999",
                                "monoisotopic_mz": "2436.3072",
                                "intensity": "1441.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0004",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "5",
                                "monoisotopic_mass": "2297.1561",
                                "monoisotopic_mz": "1149.5853",
                                "intensity": "1155.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "6",
                                "monoisotopic_mass": "1524.9084",
                                "monoisotopic_mz": "763.4615",
                                "intensity": "1799.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "7",
                                "monoisotopic_mass": "1376.7200",
                                "monoisotopic_mz": "1377.7273",
                                "intensity": "1799.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1376.7122",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0078",
                                        "ppm": "5.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "8",
                                "monoisotopic_mass": "1248.6219",
                                "monoisotopic_mz": "1249.6291",
                                "intensity": "2139.04",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1248.6173",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0046",
                                        "ppm": "3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "9",
                                "monoisotopic_mass": "728.3531",
                                "monoisotopic_mz": "729.3604",
                                "intensity": "1028.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "10",
                                "monoisotopic_mass": "584.2946",
                                "monoisotopic_mz": "585.3019",
                                "intensity": "2037.34",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "584.2918",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0028",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "11",
                                "monoisotopic_mass": "520.2703",
                                "monoisotopic_mz": "521.2776",
                                "intensity": "2340.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "520.2679",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "85",
                                        "mass_error": "0.0024",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "12",
                                "monoisotopic_mass": "655.3318",
                                "monoisotopic_mz": "656.3390",
                                "intensity": "1216.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "655.3289",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0028",
                                        "ppm": "4.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "13",
                                "monoisotopic_mass": "1797.9089",
                                "monoisotopic_mz": "1798.9162",
                                "intensity": "1587.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "14",
                                "monoisotopic_mass": "1084.6664",
                                "monoisotopic_mz": "1085.6737",
                                "intensity": "543.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "15",
                                "monoisotopic_mass": "2435.3148",
                                "monoisotopic_mz": "1218.6647",
                                "intensity": "2055.75",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0153",
                                        "ppm": "6.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "16",
                                "monoisotopic_mass": "876.4779",
                                "monoisotopic_mz": "877.4852",
                                "intensity": "496.85",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "876.4739",
                                        "ion_position": "82",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "82",
                                        "mass_error": "0.0041",
                                        "ppm": "4.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "17",
                                "monoisotopic_mass": "2510.5685",
                                "monoisotopic_mz": "1256.2915",
                                "intensity": "546.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "18",
                                "monoisotopic_mass": "1324.6825",
                                "monoisotopic_mz": "1325.6898",
                                "intensity": "594.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "19",
                                "monoisotopic_mass": "412.1609",
                                "monoisotopic_mz": "413.1682",
                                "intensity": "1316.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "20",
                                "monoisotopic_mass": "1292.6885",
                                "monoisotopic_mz": "1293.6958",
                                "intensity": "730.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "21",
                                "monoisotopic_mass": "1012.4992",
                                "monoisotopic_mz": "1013.5065",
                                "intensity": "2006.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1012.4938",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0055",
                                        "ppm": "5.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "22",
                                "monoisotopic_mass": "1477.6468",
                                "monoisotopic_mz": "739.8307",
                                "intensity": "1410.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "23",
                                "monoisotopic_mass": "6595.4180",
                                "monoisotopic_mz": "1100.2436",
                                "intensity": "573.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "24",
                                "monoisotopic_mass": "4293.0991",
                                "monoisotopic_mz": "1074.2821",
                                "intensity": "501.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "25",
                                "monoisotopic_mass": "479.2585",
                                "monoisotopic_mz": "480.2658",
                                "intensity": "728.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "26",
                                "monoisotopic_mass": "2578.2856",
                                "monoisotopic_mz": "1290.1501",
                                "intensity": "1412.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "27",
                                "monoisotopic_mass": "5620.9253",
                                "monoisotopic_mz": "1125.1923",
                                "intensity": "440.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "28",
                                "monoisotopic_mass": "7319.6502",
                                "monoisotopic_mz": "915.9635",
                                "intensity": "425.57",
                                "charge": "8"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "29",
                                "monoisotopic_mass": "4343.9647",
                                "monoisotopic_mz": "1086.9985",
                                "intensity": "1388.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "30",
                                "monoisotopic_mass": "4462.3652",
                                "monoisotopic_mz": "1116.5986",
                                "intensity": "1534.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "31",
                                "monoisotopic_mass": "838.4134",
                                "monoisotopic_mz": "839.4207",
                                "intensity": "594.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "32",
                                "monoisotopic_mass": "1028.5768",
                                "monoisotopic_mz": "1029.5841",
                                "intensity": "700.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "33",
                                "monoisotopic_mass": "984.5437",
                                "monoisotopic_mz": "985.5510",
                                "intensity": "757.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "34",
                                "monoisotopic_mass": "6600.1532",
                                "monoisotopic_mz": "1321.0379",
                                "intensity": "1119.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "35",
                                "monoisotopic_mass": "6062.7259",
                                "monoisotopic_mz": "1011.4616",
                                "intensity": "1127.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "36",
                                "monoisotopic_mass": "926.4344",
                                "monoisotopic_mz": "927.4417",
                                "intensity": "434.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "37",
                                "monoisotopic_mass": "4857.8687",
                                "monoisotopic_mz": "972.5810",
                                "intensity": "1181.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "38",
                                "monoisotopic_mass": "1062.5599",
                                "monoisotopic_mz": "1063.5671",
                                "intensity": "655.24",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1062.5532",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0067",
                                        "ppm": "6.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "39",
                                "monoisotopic_mass": "1201.6014",
                                "monoisotopic_mz": "1202.6086",
                                "intensity": "807.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "40",
                                "monoisotopic_mass": "3288.0421",
                                "monoisotopic_mz": "1097.0213",
                                "intensity": "749.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "41",
                                "monoisotopic_mass": "4572.4205",
                                "monoisotopic_mz": "1144.1124",
                                "intensity": "798.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "42",
                                "monoisotopic_mass": "4184.8999",
                                "monoisotopic_mz": "1047.2322",
                                "intensity": "532.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "43",
                                "monoisotopic_mass": "2374.2036",
                                "monoisotopic_mz": "1188.1091",
                                "intensity": "1536.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "44",
                                "monoisotopic_mass": "1985.8967",
                                "monoisotopic_mz": "993.9556",
                                "intensity": "803.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "45",
                                "monoisotopic_mass": "6496.0074",
                                "monoisotopic_mz": "1083.6752",
                                "intensity": "1114.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "46",
                                "monoisotopic_mass": "1270.6951",
                                "monoisotopic_mz": "1271.7024",
                                "intensity": "723.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "47",
                                "monoisotopic_mass": "1218.7529",
                                "monoisotopic_mz": "1219.7601",
                                "intensity": "359.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "48",
                                "monoisotopic_mass": "3494.7661",
                                "monoisotopic_mz": "1748.3903",
                                "intensity": "548.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "345",
                                "peak_id": "49",
                                "monoisotopic_mass": "7998.8053",
                                "monoisotopic_mz": "1143.6937",
                                "intensity": "1252.86",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "22",
                    "proteoform_id": "29",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "proteoform_mass": "10173.1302",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "21",
                        "last_residue_position": "109",
                        "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+324.2585]KQANFKDKVKGEWDKIKKDM.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "L"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "L"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "L"
                            },
                            {
                                "position": "15",
                                "acid": "P"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "D"
                            },
                            {
                                "position": "29",
                                "acid": "N"
                            },
                            {
                                "position": "30",
                                "acid": "K"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "P"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "S"
                            },
                            {
                                "position": "36",
                                "acid": "W"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "E"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "D"
                            },
                            {
                                "position": "46",
                                "acid": "E"
                            },
                            {
                                "position": "47",
                                "acid": "S"
                            },
                            {
                                "position": "48",
                                "acid": "F"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "P"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "V"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "F"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "A"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "K"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "D"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "Q"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "A"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "T"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "I"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "Q"
                            },
                            {
                                "position": "85",
                                "acid": "A"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "T"
                            },
                            {
                                "position": "88",
                                "acid": "Q"
                            },
                            {
                                "position": "89",
                                "acid": "D"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "F"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "V"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "G"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "W"
                            },
                            {
                                "position": "103",
                                "acid": "D"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "K"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "345",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "345",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "345",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "345",
                                        "peak_id": "21",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "345",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "345",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "345",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "345",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "spec_id": "345",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "spec_id": "345",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "spec_id": "345",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "spec_id": "345",
                                        "peak_id": "38",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "82",
                                        "ion_display_position": "7",
                                        "spec_id": "345",
                                        "peak_id": "16",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "spec_id": "345",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "34",
                            "right_position": "90",
                            "shift": "324.2584935793",
                            "anno": "+324.2585",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "141",
                "p_value": "7.42e-09",
                "e_value": "7.42e-09",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "616",
                        "ms1_scans": "928",
                        "ids": "312",
                        "scans": "930",
                        "precursor_mono_mass": "10172.9302",
                        "precursor_charge": "8",
                        "precursor_mz": "1272.6236",
                        "feature_inte": "5.4904e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "312",
                                "peak_id": "0",
                                "monoisotopic_mass": "1718.9141",
                                "monoisotopic_mz": "1719.9214",
                                "intensity": "1773.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1718.9025",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0116",
                                        "ppm": "6.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "1",
                                "monoisotopic_mass": "1083.6150",
                                "monoisotopic_mz": "1084.6223",
                                "intensity": "1290.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "2",
                                "monoisotopic_mass": "2435.3087",
                                "monoisotopic_mz": "2436.3160",
                                "intensity": "2729.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0092",
                                        "ppm": "3.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "3",
                                "monoisotopic_mass": "1012.4977",
                                "monoisotopic_mz": "1013.5050",
                                "intensity": "2068.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1012.4938",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0040",
                                        "ppm": "3.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "4",
                                "monoisotopic_mass": "1603.8826",
                                "monoisotopic_mz": "1604.8899",
                                "intensity": "4336.00",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1603.8756",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0070",
                                        "ppm": "4.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "5",
                                "monoisotopic_mass": "770.3598",
                                "monoisotopic_mz": "771.3671",
                                "intensity": "5269.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "770.3559",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0039",
                                        "ppm": "5.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "6",
                                "monoisotopic_mass": "1223.6197",
                                "monoisotopic_mz": "1224.6270",
                                "intensity": "1406.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "7",
                                "monoisotopic_mass": "1427.7132",
                                "monoisotopic_mz": "1428.7205",
                                "intensity": "883.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "8",
                                "monoisotopic_mass": "843.4167",
                                "monoisotopic_mz": "844.4240",
                                "intensity": "1721.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "9",
                                "monoisotopic_mass": "1376.7203",
                                "monoisotopic_mz": "1377.7275",
                                "intensity": "2309.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1376.7122",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0080",
                                        "ppm": "5.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "10",
                                "monoisotopic_mass": "1248.6239",
                                "monoisotopic_mz": "1249.6312",
                                "intensity": "3109.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1248.6173",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0067",
                                        "ppm": "5.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "11",
                                "monoisotopic_mass": "1454.8337",
                                "monoisotopic_mz": "1455.8409",
                                "intensity": "1204.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "12",
                                "monoisotopic_mass": "1294.6524",
                                "monoisotopic_mz": "1295.6597",
                                "intensity": "996.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "13",
                                "monoisotopic_mass": "1140.5980",
                                "monoisotopic_mz": "1141.6052",
                                "intensity": "3493.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0092",
                                        "ppm": "8.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "14",
                                "monoisotopic_mass": "584.2942",
                                "monoisotopic_mz": "585.3015",
                                "intensity": "3752.23",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "584.2918",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0024",
                                        "ppm": "4.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "15",
                                "monoisotopic_mass": "3594.8283",
                                "monoisotopic_mz": "1798.4214",
                                "intensity": "3764.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "16",
                                "monoisotopic_mass": "884.4032",
                                "monoisotopic_mz": "885.4105",
                                "intensity": "668.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "884.3988",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0044",
                                        "ppm": "4.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "17",
                                "monoisotopic_mass": "643.3359",
                                "monoisotopic_mz": "644.3432",
                                "intensity": "945.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "18",
                                "monoisotopic_mass": "728.3531",
                                "monoisotopic_mz": "729.3604",
                                "intensity": "1527.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "19",
                                "monoisotopic_mass": "627.3370",
                                "monoisotopic_mz": "628.3442",
                                "intensity": "1307.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "20",
                                "monoisotopic_mass": "520.2703",
                                "monoisotopic_mz": "521.2775",
                                "intensity": "4097.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "520.2679",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "Y00004",
                                        "ion_left_position": "85",
                                        "mass_error": "0.0023",
                                        "ppm": "4.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "21",
                                "monoisotopic_mass": "1338.6452",
                                "monoisotopic_mz": "1339.6525",
                                "intensity": "911.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "22",
                                "monoisotopic_mass": "2506.4022",
                                "monoisotopic_mz": "1254.2084",
                                "intensity": "2128.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "23",
                                "monoisotopic_mass": "435.2136",
                                "monoisotopic_mz": "436.2209",
                                "intensity": "938.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "24",
                                "monoisotopic_mass": "2435.3190",
                                "monoisotopic_mz": "1218.6668",
                                "intensity": "2551.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2435.2995",
                                        "ion_position": "69",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0195",
                                        "ppm": "8.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "25",
                                "monoisotopic_mass": "1475.7868",
                                "monoisotopic_mz": "1476.7941",
                                "intensity": "1670.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1475.7806",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0062",
                                        "ppm": "4.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "26",
                                "monoisotopic_mass": "1140.5936",
                                "monoisotopic_mz": "571.3041",
                                "intensity": "699.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1140.5887",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0049",
                                        "ppm": "4.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "27",
                                "monoisotopic_mass": "1197.6104",
                                "monoisotopic_mz": "1198.6177",
                                "intensity": "1167.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "28",
                                "monoisotopic_mass": "479.2398",
                                "monoisotopic_mz": "480.2471",
                                "intensity": "1085.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "29",
                                "monoisotopic_mass": "1492.9195",
                                "monoisotopic_mz": "747.4670",
                                "intensity": "330.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "30",
                                "monoisotopic_mass": "1062.5595",
                                "monoisotopic_mz": "1063.5668",
                                "intensity": "1599.59",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1062.5532",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0063",
                                        "ppm": "5.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "31",
                                "monoisotopic_mass": "3086.5113",
                                "monoisotopic_mz": "1544.2629",
                                "intensity": "1452.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "32",
                                "monoisotopic_mass": "2295.1456",
                                "monoisotopic_mz": "1148.5801",
                                "intensity": "1754.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "33",
                                "monoisotopic_mass": "3197.5484",
                                "monoisotopic_mz": "1599.7815",
                                "intensity": "1215.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "34",
                                "monoisotopic_mass": "3493.7701",
                                "monoisotopic_mz": "1747.8923",
                                "intensity": "1624.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "35",
                                "monoisotopic_mass": "4571.5122",
                                "monoisotopic_mz": "1143.8853",
                                "intensity": "929.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "36",
                                "monoisotopic_mass": "2452.0884",
                                "monoisotopic_mz": "1227.0515",
                                "intensity": "2015.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "37",
                                "monoisotopic_mass": "2808.2572",
                                "monoisotopic_mz": "937.0930",
                                "intensity": "1134.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "38",
                                "monoisotopic_mass": "4306.9101",
                                "monoisotopic_mz": "1077.7348",
                                "intensity": "915.91",
                                "charge": "4"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "39",
                                "monoisotopic_mass": "1823.9200",
                                "monoisotopic_mz": "912.9673",
                                "intensity": "1232.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "40",
                                "monoisotopic_mass": "6235.3123",
                                "monoisotopic_mz": "1040.2260",
                                "intensity": "641.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "41",
                                "monoisotopic_mass": "5145.1473",
                                "monoisotopic_mz": "1030.0367",
                                "intensity": "553.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "312",
                                "peak_id": "42",
                                "monoisotopic_mass": "3765.8649",
                                "monoisotopic_mz": "1256.2956",
                                "intensity": "722.59",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "22",
                    "proteoform_id": "29",
                    "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                    "proteoform_mass": "10173.1302",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "110",
                        "first_residue_position": "21",
                        "last_residue_position": "109",
                        "annotated_seq": "A.ADAQKAADNKK(PVNSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+324.2585]KQANFKDKVKGEWDKIKKDM.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "K"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "V"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "I"
                            },
                            {
                                "position": "8",
                                "acid": "L"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "L"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "L"
                            },
                            {
                                "position": "15",
                                "acid": "P"
                            },
                            {
                                "position": "16",
                                "acid": "V"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "S"
                            },
                            {
                                "position": "19",
                                "acid": "N"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "A"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "K"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "D"
                            },
                            {
                                "position": "29",
                                "acid": "N"
                            },
                            {
                                "position": "30",
                                "acid": "K"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "P"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "N"
                            },
                            {
                                "position": "35",
                                "acid": "S"
                            },
                            {
                                "position": "36",
                                "acid": "W"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "E"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "A"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "D"
                            },
                            {
                                "position": "46",
                                "acid": "E"
                            },
                            {
                                "position": "47",
                                "acid": "S"
                            },
                            {
                                "position": "48",
                                "acid": "F"
                            },
                            {
                                "position": "49",
                                "acid": "Q"
                            },
                            {
                                "position": "50",
                                "acid": "P"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "V"
                            },
                            {
                                "position": "54",
                                "acid": "G"
                            },
                            {
                                "position": "55",
                                "acid": "F"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "A"
                            },
                            {
                                "position": "59",
                                "acid": "L"
                            },
                            {
                                "position": "60",
                                "acid": "N"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "K"
                            },
                            {
                                "position": "63",
                                "acid": "D"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "D"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "Q"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "A"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "T"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "A"
                            },
                            {
                                "position": "82",
                                "acid": "I"
                            },
                            {
                                "position": "83",
                                "acid": "V"
                            },
                            {
                                "position": "84",
                                "acid": "Q"
                            },
                            {
                                "position": "85",
                                "acid": "A"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "T"
                            },
                            {
                                "position": "88",
                                "acid": "Q"
                            },
                            {
                                "position": "89",
                                "acid": "D"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "F"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "K"
                            },
                            {
                                "position": "98",
                                "acid": "V"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "G"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "W"
                            },
                            {
                                "position": "103",
                                "acid": "D"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "K"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "312",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "312",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "312",
                                        "peak_id": "16",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "312",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "312",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "11",
                                            "ion_display_position": "11",
                                            "spec_id": "312",
                                            "peak_id": "13",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "312",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "20",
                                            "spec_id": "312",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "75",
                                        "ion_display_position": "14",
                                        "spec_id": "312",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "13",
                                        "spec_id": "312",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "12",
                                        "spec_id": "312",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "11",
                                        "spec_id": "312",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "10",
                                        "spec_id": "312",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "81",
                                        "ion_display_position": "8",
                                        "spec_id": "312",
                                        "peak_id": "30",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "85",
                                        "ion_display_position": "4",
                                        "spec_id": "312",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "90",
                            "shift": "324.2584935793",
                            "anno": "+324.2585",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
