prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "13",
        "sequence_name": "sp|P0ACF8|HNS_ECOLI",
        "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
        "proteoform_id": "14",
        "prsm_number": "7",
        "prsm": [
            {
                "prsm_id": "43",
                "p_value": "4.30e-20",
                "e_value": "4.30e-20",
                "fdr": "0",
                "matched_fragment_number": "28",
                "matched_peak_number": "34",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "538",
                        "ms1_scans": "618",
                        "ids": "79",
                        "scans": "619",
                        "precursor_mono_mass": "5453.7625",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7598",
                        "feature_inte": "1.7944e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "79",
                                "peak_id": "0",
                                "monoisotopic_mass": "1395.7692",
                                "monoisotopic_mz": "1396.7765",
                                "intensity": "2047.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "1",
                                "monoisotopic_mass": "1634.8247",
                                "monoisotopic_mz": "1635.8320",
                                "intensity": "2419.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1634.8152",
                                        "ion_position": "34",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0096",
                                        "ppm": "5.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "2",
                                "monoisotopic_mass": "1941.0755",
                                "monoisotopic_mz": "1942.0828",
                                "intensity": "663.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "3",
                                "monoisotopic_mass": "1774.8731",
                                "monoisotopic_mz": "1775.8804",
                                "intensity": "1556.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "4",
                                "monoisotopic_mass": "875.4424",
                                "monoisotopic_mz": "876.4497",
                                "intensity": "2418.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "5",
                                "monoisotopic_mass": "1577.7415",
                                "monoisotopic_mz": "1578.7488",
                                "intensity": "1043.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "6",
                                "monoisotopic_mass": "1434.7415",
                                "monoisotopic_mz": "1435.7488",
                                "intensity": "2744.93",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0047",
                                        "ppm": "3.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "7",
                                "monoisotopic_mass": "1417.7148",
                                "monoisotopic_mz": "1418.7220",
                                "intensity": "2651.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "8",
                                "monoisotopic_mass": "1863.8946",
                                "monoisotopic_mz": "932.9546",
                                "intensity": "14333.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0082",
                                        "ppm": "4.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "9",
                                "monoisotopic_mass": "4691.3716",
                                "monoisotopic_mz": "1173.8502",
                                "intensity": "8808.57",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0201",
                                        "ppm": "4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "10",
                                "monoisotopic_mass": "1373.7317",
                                "monoisotopic_mz": "1374.7390",
                                "intensity": "1095.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "11",
                                "monoisotopic_mass": "3687.9449",
                                "monoisotopic_mz": "922.9935",
                                "intensity": "10953.14",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0215",
                                        "ppm": "5.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "12",
                                "monoisotopic_mass": "2119.0778",
                                "monoisotopic_mz": "1060.5462",
                                "intensity": "19400.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "13",
                                "monoisotopic_mass": "3203.6150",
                                "monoisotopic_mz": "1068.8790",
                                "intensity": "4660.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "14",
                                "monoisotopic_mass": "1497.7867",
                                "monoisotopic_mz": "749.9006",
                                "intensity": "5478.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "15",
                                "monoisotopic_mass": "1677.8310",
                                "monoisotopic_mz": "839.9228",
                                "intensity": "4614.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0087",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "16",
                                "monoisotopic_mass": "3360.7112",
                                "monoisotopic_mz": "1121.2443",
                                "intensity": "18843.24",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0149",
                                        "ppm": "4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "17",
                                "monoisotopic_mass": "4045.0369",
                                "monoisotopic_mz": "1012.2665",
                                "intensity": "2564.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "18",
                                "monoisotopic_mass": "1705.8426",
                                "monoisotopic_mz": "1706.8499",
                                "intensity": "1993.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "19",
                                "monoisotopic_mass": "1563.7866",
                                "monoisotopic_mz": "782.9006",
                                "intensity": "8795.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0072",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "20",
                                "monoisotopic_mass": "1417.7154",
                                "monoisotopic_mz": "709.8650",
                                "intensity": "3934.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "21",
                                "monoisotopic_mass": "3818.9754",
                                "monoisotopic_mz": "1273.9991",
                                "intensity": "3951.42",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0116",
                                        "ppm": "3.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "22",
                                "monoisotopic_mass": "3471.7954",
                                "monoisotopic_mz": "1158.2724",
                                "intensity": "6600.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "23",
                                "monoisotopic_mass": "1434.7433",
                                "monoisotopic_mz": "718.3789",
                                "intensity": "52536.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0065",
                                        "ppm": "4.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "24",
                                "monoisotopic_mass": "4376.2299",
                                "monoisotopic_mz": "1095.0648",
                                "intensity": "11091.38",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0215",
                                        "ppm": "4.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "25",
                                "monoisotopic_mass": "4806.4083",
                                "monoisotopic_mz": "1202.6093",
                                "intensity": "11320.24",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0299",
                                        "ppm": "6.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "26",
                                "monoisotopic_mass": "3148.5563",
                                "monoisotopic_mz": "1050.5261",
                                "intensity": "8733.63",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0125",
                                        "ppm": "3.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "27",
                                "monoisotopic_mass": "1291.7209",
                                "monoisotopic_mz": "646.8677",
                                "intensity": "4276.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "28",
                                "monoisotopic_mass": "3616.9095",
                                "monoisotopic_mz": "905.2346",
                                "intensity": "4299.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0232",
                                        "ppm": "6.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "29",
                                "monoisotopic_mass": "3488.8077",
                                "monoisotopic_mz": "1163.9432",
                                "intensity": "22671.56",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0165",
                                        "ppm": "4.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "30",
                                "monoisotopic_mass": "3219.6346",
                                "monoisotopic_mz": "1074.2188",
                                "intensity": "13864.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "31",
                                "monoisotopic_mass": "1136.6228",
                                "monoisotopic_mz": "1137.6301",
                                "intensity": "3327.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "32",
                                "monoisotopic_mass": "2194.0854",
                                "monoisotopic_mz": "732.3691",
                                "intensity": "3285.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0087",
                                        "ppm": "3.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "33",
                                "monoisotopic_mass": "3247.6292",
                                "monoisotopic_mz": "1083.5503",
                                "intensity": "24472.92",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0169",
                                        "ppm": "5.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "34",
                                "monoisotopic_mass": "1534.7709",
                                "monoisotopic_mz": "768.3927",
                                "intensity": "1029.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "35",
                                "monoisotopic_mass": "1319.7158",
                                "monoisotopic_mz": "660.8652",
                                "intensity": "4454.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0059",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "36",
                                "monoisotopic_mass": "5162.6288",
                                "monoisotopic_mz": "1291.6645",
                                "intensity": "4362.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "37",
                                "monoisotopic_mass": "5179.6358",
                                "monoisotopic_mz": "1295.9162",
                                "intensity": "9901.45",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0208",
                                        "ppm": "4.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "38",
                                "monoisotopic_mass": "1274.6922",
                                "monoisotopic_mz": "638.3534",
                                "intensity": "1596.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "39",
                                "monoisotopic_mass": "5066.5572",
                                "monoisotopic_mz": "1267.6466",
                                "intensity": "20643.64",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0263",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "40",
                                "monoisotopic_mass": "3616.9046",
                                "monoisotopic_mz": "1206.6422",
                                "intensity": "11299.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0184",
                                        "ppm": "5.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "41",
                                "monoisotopic_mass": "1734.8507",
                                "monoisotopic_mz": "868.4326",
                                "intensity": "2936.34",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0069",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "42",
                                "monoisotopic_mass": "1497.7843",
                                "monoisotopic_mz": "1498.7916",
                                "intensity": "3022.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "43",
                                "monoisotopic_mass": "4953.4683",
                                "monoisotopic_mz": "1239.3744",
                                "intensity": "15959.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0215",
                                        "ppm": "4.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "44",
                                "monoisotopic_mass": "2176.0770",
                                "monoisotopic_mz": "726.3663",
                                "intensity": "3462.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "45",
                                "monoisotopic_mass": "2093.0399",
                                "monoisotopic_mz": "1047.5272",
                                "intensity": "8914.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0109",
                                        "ppm": "5.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "46",
                                "monoisotopic_mass": "3598.8823",
                                "monoisotopic_mz": "1200.6347",
                                "intensity": "5037.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "47",
                                "monoisotopic_mass": "3120.5716",
                                "monoisotopic_mz": "1041.1978",
                                "intensity": "3935.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "48",
                                "monoisotopic_mass": "4788.3775",
                                "monoisotopic_mz": "1198.1017",
                                "intensity": "8872.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "49",
                                "monoisotopic_mass": "3148.5549",
                                "monoisotopic_mz": "788.1460",
                                "intensity": "3104.18",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0111",
                                        "ppm": "3.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "50",
                                "monoisotopic_mass": "3247.6234",
                                "monoisotopic_mz": "812.9131",
                                "intensity": "2983.73",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0112",
                                        "ppm": "3.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "51",
                                "monoisotopic_mass": "4935.4473",
                                "monoisotopic_mz": "1234.8691",
                                "intensity": "9232.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "52",
                                "monoisotopic_mass": "1946.9282",
                                "monoisotopic_mz": "974.4714",
                                "intensity": "4724.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "53",
                                "monoisotopic_mass": "4231.1136",
                                "monoisotopic_mz": "1411.3785",
                                "intensity": "2706.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "54",
                                "monoisotopic_mass": "1600.7840",
                                "monoisotopic_mz": "1601.7913",
                                "intensity": "1331.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "55",
                                "monoisotopic_mass": "1192.6516",
                                "monoisotopic_mz": "597.3331",
                                "intensity": "3067.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "56",
                                "monoisotopic_mass": "4213.1045",
                                "monoisotopic_mz": "1054.2834",
                                "intensity": "1190.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "57",
                                "monoisotopic_mass": "3598.8894",
                                "monoisotopic_mz": "900.7296",
                                "intensity": "5860.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "58",
                                "monoisotopic_mass": "4358.1997",
                                "monoisotopic_mz": "1090.5572",
                                "intensity": "5914.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "59",
                                "monoisotopic_mass": "2879.4191",
                                "monoisotopic_mz": "960.8136",
                                "intensity": "5305.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0128",
                                        "ppm": "4.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "60",
                                "monoisotopic_mass": "1220.6474",
                                "monoisotopic_mz": "611.3310",
                                "intensity": "2880.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0060",
                                        "ppm": "4.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "61",
                                "monoisotopic_mass": "3064.5543",
                                "monoisotopic_mz": "1533.2844",
                                "intensity": "5210.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "62",
                                "monoisotopic_mass": "559.2301",
                                "monoisotopic_mz": "560.2374",
                                "intensity": "1583.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "63",
                                "monoisotopic_mass": "3916.9951",
                                "monoisotopic_mz": "1306.6723",
                                "intensity": "5260.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "64",
                                "monoisotopic_mass": "3934.0041",
                                "monoisotopic_mz": "1312.3420",
                                "intensity": "13325.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0133",
                                        "ppm": "3.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "65",
                                "monoisotopic_mass": "4191.1137",
                                "monoisotopic_mz": "1048.7857",
                                "intensity": "8562.79",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0218",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "66",
                                "monoisotopic_mass": "603.2920",
                                "monoisotopic_mz": "604.2993",
                                "intensity": "1048.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "67",
                                "monoisotopic_mass": "690.3253",
                                "monoisotopic_mz": "691.3326",
                                "intensity": "1405.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "68",
                                "monoisotopic_mass": "3377.7342",
                                "monoisotopic_mz": "1126.9187",
                                "intensity": "4778.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "69",
                                "monoisotopic_mass": "1336.7435",
                                "monoisotopic_mz": "669.3790",
                                "intensity": "1976.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "70",
                                "monoisotopic_mass": "3332.7180",
                                "monoisotopic_mz": "1111.9133",
                                "intensity": "9083.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "71",
                                "monoisotopic_mass": "490.2083",
                                "monoisotopic_mz": "491.2155",
                                "intensity": "1766.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "72",
                                "monoisotopic_mass": "4174.0887",
                                "monoisotopic_mz": "1392.3702",
                                "intensity": "1933.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "73",
                                "monoisotopic_mass": "4953.4295",
                                "monoisotopic_mz": "991.6932",
                                "intensity": "2437.35",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0173",
                                        "ppm": "-3.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "74",
                                "monoisotopic_mass": "853.4273",
                                "monoisotopic_mz": "854.4346",
                                "intensity": "950.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "75",
                                "monoisotopic_mass": "1916.9840",
                                "monoisotopic_mz": "959.4993",
                                "intensity": "1504.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "76",
                                "monoisotopic_mass": "662.3641",
                                "monoisotopic_mz": "663.3713",
                                "intensity": "1322.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "77",
                                "monoisotopic_mass": "4230.1167",
                                "monoisotopic_mz": "1058.5364",
                                "intensity": "3462.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "78",
                                "monoisotopic_mass": "577.2410",
                                "monoisotopic_mz": "578.2483",
                                "intensity": "1339.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "79",
                                "monoisotopic_mass": "1237.7453",
                                "monoisotopic_mz": "619.8799",
                                "intensity": "891.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "80",
                                "monoisotopic_mass": "387.2494",
                                "monoisotopic_mz": "388.2567",
                                "intensity": "4159.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0012",
                                        "ppm": "3.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "81",
                                "monoisotopic_mass": "3344.6997",
                                "monoisotopic_mz": "1115.9072",
                                "intensity": "3206.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "82",
                                "monoisotopic_mass": "4063.0565",
                                "monoisotopic_mz": "1355.3594",
                                "intensity": "5022.76",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0231",
                                        "ppm": "5.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "83",
                                "monoisotopic_mass": "2076.0166",
                                "monoisotopic_mz": "1039.0156",
                                "intensity": "2262.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "84",
                                "monoisotopic_mass": "4427.2384",
                                "monoisotopic_mz": "1107.8169",
                                "intensity": "5297.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "85",
                                "monoisotopic_mass": "2434.2247",
                                "monoisotopic_mz": "1218.1196",
                                "intensity": "2552.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "86",
                                "monoisotopic_mass": "2131.0457",
                                "monoisotopic_mz": "711.3558",
                                "intensity": "2523.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "87",
                                "monoisotopic_mass": "4191.1156",
                                "monoisotopic_mz": "1398.0458",
                                "intensity": "4042.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0237",
                                        "ppm": "5.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "88",
                                "monoisotopic_mass": "4636.3755",
                                "monoisotopic_mz": "1160.1012",
                                "intensity": "1462.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "79",
                                "peak_id": "89",
                                "monoisotopic_mass": "4558.3225",
                                "monoisotopic_mz": "1140.5879",
                                "intensity": "4316.12",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "79",
                                        "peak_id": "60",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "79",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "79",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "79",
                                            "peak_id": "23",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "79",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "79",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "79",
                                        "peak_id": "41",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "79",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "79",
                                        "peak_id": "45",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "79",
                                        "peak_id": "32",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "79",
                                        "peak_id": "59",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "79",
                                            "peak_id": "49",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "79",
                                            "peak_id": "26",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "79",
                                            "peak_id": "50",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "79",
                                            "peak_id": "33",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "79",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "79",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "79",
                                            "peak_id": "40",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "79",
                                            "peak_id": "28",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "79",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "14",
                                            "spec_id": "79",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "79",
                                            "peak_id": "21",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "79",
                                        "peak_id": "64",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "79",
                                        "peak_id": "82",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "79",
                                            "peak_id": "65",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "79",
                                            "peak_id": "87",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "79",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "79",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "79",
                                        "peak_id": "25",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "79",
                                            "peak_id": "73",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "44",
                                            "ion_display_position": "44",
                                            "spec_id": "79",
                                            "peak_id": "43",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "3",
                                            "spec_id": "79",
                                            "peak_id": "80",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "79",
                                            "peak_id": "39",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "79",
                                        "peak_id": "37",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "127",
                "p_value": "6.70e-18",
                "e_value": "6.70e-18",
                "fdr": "0",
                "matched_fragment_number": "23",
                "matched_peak_number": "24",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "609",
                        "ms1_scans": "900",
                        "ids": "290",
                        "scans": "901",
                        "precursor_mono_mass": "5453.8037",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7680",
                        "feature_inte": "2.3043e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "290",
                                "peak_id": "0",
                                "monoisotopic_mass": "1145.6258",
                                "monoisotopic_mz": "1146.6331",
                                "intensity": "4118.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "1",
                                "monoisotopic_mass": "1488.8041",
                                "monoisotopic_mz": "1489.8114",
                                "intensity": "1981.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "2",
                                "monoisotopic_mass": "1863.8936",
                                "monoisotopic_mz": "932.9541",
                                "intensity": "7654.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0072",
                                        "ppm": "3.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "3",
                                "monoisotopic_mass": "4691.3721",
                                "monoisotopic_mz": "1173.8503",
                                "intensity": "3506.31",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4691.3514",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0207",
                                        "ppm": "4.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "4",
                                "monoisotopic_mass": "5066.5596",
                                "monoisotopic_mz": "1267.6472",
                                "intensity": "10692.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0288",
                                        "ppm": "5.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "5",
                                "monoisotopic_mass": "3488.8107",
                                "monoisotopic_mz": "1163.9442",
                                "intensity": "12353.51",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0194",
                                            "ppm": "5.56"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0343",
                                            "ppm": "-9.83"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "6",
                                "monoisotopic_mass": "1387.7527",
                                "monoisotopic_mz": "1388.7600",
                                "intensity": "2098.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "7",
                                "monoisotopic_mass": "1434.7444",
                                "monoisotopic_mz": "718.3795",
                                "intensity": "23876.93",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0076",
                                        "ppm": "5.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "8",
                                "monoisotopic_mass": "3247.6289",
                                "monoisotopic_mz": "1083.5502",
                                "intensity": "11536.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0166",
                                        "ppm": "5.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "9",
                                "monoisotopic_mass": "3332.7118",
                                "monoisotopic_mz": "1111.9112",
                                "intensity": "5485.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "10",
                                "monoisotopic_mass": "1563.7867",
                                "monoisotopic_mz": "782.9006",
                                "intensity": "3484.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0073",
                                        "ppm": "4.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "11",
                                "monoisotopic_mass": "5048.5425",
                                "monoisotopic_mz": "1263.1429",
                                "intensity": "5584.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "12",
                                "monoisotopic_mass": "3687.9497",
                                "monoisotopic_mz": "922.9947",
                                "intensity": "5980.33",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0264",
                                        "ppm": "7.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "13",
                                "monoisotopic_mass": "3934.0063",
                                "monoisotopic_mz": "1312.3427",
                                "intensity": "5984.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0155",
                                        "ppm": "3.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "14",
                                "monoisotopic_mass": "3219.6349",
                                "monoisotopic_mz": "1074.2189",
                                "intensity": "6918.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "15",
                                "monoisotopic_mass": "1434.7437",
                                "monoisotopic_mz": "1435.7510",
                                "intensity": "1661.02",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0069",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "16",
                                "monoisotopic_mass": "1220.6479",
                                "monoisotopic_mz": "611.3312",
                                "intensity": "1359.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0065",
                                        "ppm": "5.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "17",
                                "monoisotopic_mass": "1464.9097",
                                "monoisotopic_mz": "1465.9170",
                                "intensity": "2209.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "18",
                                "monoisotopic_mass": "2093.0416",
                                "monoisotopic_mz": "1047.5281",
                                "intensity": "5426.41",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0126",
                                        "ppm": "6.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "19",
                                "monoisotopic_mass": "1291.7223",
                                "monoisotopic_mz": "646.8684",
                                "intensity": "2093.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "20",
                                "monoisotopic_mass": "3616.9039",
                                "monoisotopic_mz": "1206.6419",
                                "intensity": "5303.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0176",
                                        "ppm": "4.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "21",
                                "monoisotopic_mass": "3916.9900",
                                "monoisotopic_mz": "1306.6706",
                                "intensity": "2728.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "22",
                                "monoisotopic_mass": "3616.9065",
                                "monoisotopic_mz": "905.2339",
                                "intensity": "3186.17",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0203",
                                        "ppm": "5.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "23",
                                "monoisotopic_mass": "2505.4057",
                                "monoisotopic_mz": "1253.7101",
                                "intensity": "4424.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "24",
                                "monoisotopic_mass": "1319.7162",
                                "monoisotopic_mz": "660.8654",
                                "intensity": "1805.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0063",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "25",
                                "monoisotopic_mass": "1032.5407",
                                "monoisotopic_mz": "1033.5480",
                                "intensity": "3596.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "26",
                                "monoisotopic_mass": "4788.4024",
                                "monoisotopic_mz": "1198.1079",
                                "intensity": "3908.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "27",
                                "monoisotopic_mass": "3148.5600",
                                "monoisotopic_mz": "1050.5273",
                                "intensity": "3651.11",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0161",
                                        "ppm": "5.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "28",
                                "monoisotopic_mass": "3360.7178",
                                "monoisotopic_mz": "1121.2465",
                                "intensity": "7718.64",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.6963",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "B00030",
                                            "ion_left_position": "30",
                                            "mass_error": "0.0215",
                                            "ppm": "6.39"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.7500",
                                            "ion_position": "18",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "Y00030",
                                            "ion_left_position": "18",
                                            "mass_error": "-0.0322",
                                            "ppm": "-9.58"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "29",
                                "monoisotopic_mass": "805.4128",
                                "monoisotopic_mz": "806.4200",
                                "intensity": "1816.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "30",
                                "monoisotopic_mass": "2487.3864",
                                "monoisotopic_mz": "1244.7005",
                                "intensity": "561.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "31",
                                "monoisotopic_mass": "692.3277",
                                "monoisotopic_mz": "693.3350",
                                "intensity": "1585.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "32",
                                "monoisotopic_mass": "3471.7973",
                                "monoisotopic_mz": "1158.2730",
                                "intensity": "2911.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "33",
                                "monoisotopic_mass": "2879.4178",
                                "monoisotopic_mz": "960.8132",
                                "intensity": "2780.60",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0115",
                                        "ppm": "4.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "34",
                                "monoisotopic_mass": "2128.1303",
                                "monoisotopic_mz": "1065.0724",
                                "intensity": "1870.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "35",
                                "monoisotopic_mass": "1998.0313",
                                "monoisotopic_mz": "1000.0229",
                                "intensity": "906.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "36",
                                "monoisotopic_mass": "1670.9062",
                                "monoisotopic_mz": "836.4604",
                                "intensity": "1788.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "37",
                                "monoisotopic_mass": "1417.7176",
                                "monoisotopic_mz": "709.8661",
                                "intensity": "2134.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "38",
                                "monoisotopic_mass": "2194.0861",
                                "monoisotopic_mz": "732.3693",
                                "intensity": "1583.59",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0094",
                                        "ppm": "4.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "39",
                                "monoisotopic_mass": "4953.4718",
                                "monoisotopic_mz": "1239.3752",
                                "intensity": "7189.52",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0250",
                                        "ppm": "5.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "40",
                                "monoisotopic_mass": "4265.1679",
                                "monoisotopic_mz": "1422.7299",
                                "intensity": "2359.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "41",
                                "monoisotopic_mass": "3671.8207",
                                "monoisotopic_mz": "918.9625",
                                "intensity": "809.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "42",
                                "monoisotopic_mass": "1258.7128",
                                "monoisotopic_mz": "1259.7201",
                                "intensity": "2676.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "43",
                                "monoisotopic_mass": "4175.1005",
                                "monoisotopic_mz": "1044.7824",
                                "intensity": "1839.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "44",
                                "monoisotopic_mass": "4372.3574",
                                "monoisotopic_mz": "875.4788",
                                "intensity": "563.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "45",
                                "monoisotopic_mass": "2176.0772",
                                "monoisotopic_mz": "726.3663",
                                "intensity": "857.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "46",
                                "monoisotopic_mass": "1085.6039",
                                "monoisotopic_mz": "543.8092",
                                "intensity": "438.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "47",
                                "monoisotopic_mass": "4806.4107",
                                "monoisotopic_mz": "1202.6100",
                                "intensity": "5282.53",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0323",
                                        "ppm": "6.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "48",
                                "monoisotopic_mass": "757.4671",
                                "monoisotopic_mz": "758.4744",
                                "intensity": "658.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "49",
                                "monoisotopic_mass": "2604.4747",
                                "monoisotopic_mz": "1303.2446",
                                "intensity": "2927.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "50",
                                "monoisotopic_mass": "4190.0953",
                                "monoisotopic_mz": "1397.7057",
                                "intensity": "2435.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "51",
                                "monoisotopic_mass": "2130.0871",
                                "monoisotopic_mz": "711.0363",
                                "intensity": "1130.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "52",
                                "monoisotopic_mass": "2031.0255",
                                "monoisotopic_mz": "1016.5200",
                                "intensity": "2928.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "53",
                                "monoisotopic_mass": "807.4862",
                                "monoisotopic_mz": "404.7504",
                                "intensity": "618.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "807.4828",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0035",
                                        "ppm": "4.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "54",
                                "monoisotopic_mass": "1946.9346",
                                "monoisotopic_mz": "974.4746",
                                "intensity": "1988.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "55",
                                "monoisotopic_mass": "596.3256",
                                "monoisotopic_mz": "597.3329",
                                "intensity": "792.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "56",
                                "monoisotopic_mass": "1835.9585",
                                "monoisotopic_mz": "918.9865",
                                "intensity": "1601.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "57",
                                "monoisotopic_mass": "856.8656",
                                "monoisotopic_mz": "857.8729",
                                "intensity": "725.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "58",
                                "monoisotopic_mass": "3934.0149",
                                "monoisotopic_mz": "984.5110",
                                "intensity": "4857.34",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0241",
                                        "ppm": "6.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "59",
                                "monoisotopic_mass": "3201.6210",
                                "monoisotopic_mz": "1068.2143",
                                "intensity": "2366.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "60",
                                "monoisotopic_mass": "1295.6620",
                                "monoisotopic_mz": "1296.6693",
                                "intensity": "2170.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "61",
                                "monoisotopic_mass": "4267.1625",
                                "monoisotopic_mz": "1067.7979",
                                "intensity": "1755.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "62",
                                "monoisotopic_mass": "2180.1749",
                                "monoisotopic_mz": "1091.0947",
                                "intensity": "2688.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "63",
                                "monoisotopic_mass": "908.6837",
                                "monoisotopic_mz": "909.6910",
                                "intensity": "619.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "64",
                                "monoisotopic_mass": "1410.7017",
                                "monoisotopic_mz": "1411.7090",
                                "intensity": "1148.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "65",
                                "monoisotopic_mass": "4247.1320",
                                "monoisotopic_mz": "1416.7179",
                                "intensity": "2282.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "66",
                                "monoisotopic_mass": "1275.6963",
                                "monoisotopic_mz": "638.8554",
                                "intensity": "476.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "67",
                                "monoisotopic_mass": "3120.5665",
                                "monoisotopic_mz": "1041.1961",
                                "intensity": "1772.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "68",
                                "monoisotopic_mass": "5021.5478",
                                "monoisotopic_mz": "1256.3942",
                                "intensity": "2201.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "69",
                                "monoisotopic_mass": "2581.3258",
                                "monoisotopic_mz": "1291.6702",
                                "intensity": "2075.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "70",
                                "monoisotopic_mass": "679.3907",
                                "monoisotopic_mz": "680.3980",
                                "intensity": "724.71",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "679.3878",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0029",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "71",
                                "monoisotopic_mass": "4425.2614",
                                "monoisotopic_mz": "1107.3226",
                                "intensity": "3644.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "72",
                                "monoisotopic_mass": "4400.2501",
                                "monoisotopic_mz": "1101.0698",
                                "intensity": "1256.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "73",
                                "monoisotopic_mass": "484.2746",
                                "monoisotopic_mz": "485.2819",
                                "intensity": "612.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "74",
                                "monoisotopic_mass": "3354.6596",
                                "monoisotopic_mz": "839.6722",
                                "intensity": "2844.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "75",
                                "monoisotopic_mass": "3598.8892",
                                "monoisotopic_mz": "1200.6370",
                                "intensity": "2430.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "76",
                                "monoisotopic_mass": "1739.0766",
                                "monoisotopic_mz": "870.5456",
                                "intensity": "859.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "77",
                                "monoisotopic_mass": "4925.4820",
                                "monoisotopic_mz": "986.1037",
                                "intensity": "1821.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "78",
                                "monoisotopic_mass": "3845.9424",
                                "monoisotopic_mz": "1282.9881",
                                "intensity": "2120.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "79",
                                "monoisotopic_mass": "1876.1532",
                                "monoisotopic_mz": "939.0839",
                                "intensity": "640.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "80",
                                "monoisotopic_mass": "2769.7648",
                                "monoisotopic_mz": "924.2622",
                                "intensity": "645.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "81",
                                "monoisotopic_mass": "3830.2988",
                                "monoisotopic_mz": "958.5820",
                                "intensity": "615.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "82",
                                "monoisotopic_mass": "4918.4494",
                                "monoisotopic_mz": "1230.6196",
                                "intensity": "1855.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "83",
                                "monoisotopic_mass": "4934.4616",
                                "monoisotopic_mz": "1234.6227",
                                "intensity": "4248.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "84",
                                "monoisotopic_mass": "4375.2320",
                                "monoisotopic_mz": "1094.8153",
                                "intensity": "4806.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "85",
                                "monoisotopic_mass": "4804.4045",
                                "monoisotopic_mz": "961.8882",
                                "intensity": "1645.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "86",
                                "monoisotopic_mass": "2289.1818",
                                "monoisotopic_mz": "1145.5982",
                                "intensity": "2429.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "87",
                                "monoisotopic_mass": "2014.0442",
                                "monoisotopic_mz": "1008.0294",
                                "intensity": "3713.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "88",
                                "monoisotopic_mass": "4247.1339",
                                "monoisotopic_mz": "1062.7907",
                                "intensity": "3301.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "290",
                                "peak_id": "89",
                                "monoisotopic_mass": "4665.3463",
                                "monoisotopic_mz": "934.0765",
                                "intensity": "1427.58",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "290",
                                        "peak_id": "70",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "290",
                                        "peak_id": "53",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "290",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "290",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "290",
                                            "peak_id": "15",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "290",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "290",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "290",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "31",
                                        "spec_id": "290",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "290",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "18",
                                            "ion_display_position": "30",
                                            "spec_id": "290",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "290",
                                        "peak_id": "38",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "290",
                                        "peak_id": "33",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "290",
                                        "peak_id": "27",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "290",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "290",
                                        "peak_id": "28",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "290",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "290",
                                            "peak_id": "20",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "290",
                                            "peak_id": "22",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "290",
                                        "peak_id": "12",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "290",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "290",
                                            "peak_id": "58",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "290",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "290",
                                        "peak_id": "47",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "290",
                                        "peak_id": "39",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "290",
                                        "peak_id": "4",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "83",
                "p_value": "9.90e-15",
                "e_value": "9.90e-15",
                "fdr": "0",
                "matched_fragment_number": "23",
                "matched_peak_number": "25",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "584",
                        "ms1_scans": "801",
                        "ids": "217",
                        "scans": "803",
                        "precursor_mono_mass": "5453.8121",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7697",
                        "feature_inte": "8.9788e+06"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "217",
                                "peak_id": "0",
                                "monoisotopic_mass": "2241.2152",
                                "monoisotopic_mz": "1121.6149",
                                "intensity": "3429.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "1",
                                "monoisotopic_mass": "1417.7205",
                                "monoisotopic_mz": "1418.7278",
                                "intensity": "1949.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "2",
                                "monoisotopic_mass": "1715.9318",
                                "monoisotopic_mz": "1716.9391",
                                "intensity": "2243.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "3",
                                "monoisotopic_mass": "1258.7103",
                                "monoisotopic_mz": "1259.7175",
                                "intensity": "7963.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "4",
                                "monoisotopic_mass": "2015.0474",
                                "monoisotopic_mz": "1008.5310",
                                "intensity": "8291.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "5",
                                "monoisotopic_mass": "1387.7507",
                                "monoisotopic_mz": "1388.7579",
                                "intensity": "5826.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "6",
                                "monoisotopic_mass": "3332.7133",
                                "monoisotopic_mz": "1111.9117",
                                "intensity": "8777.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "7",
                                "monoisotopic_mass": "1145.6259",
                                "monoisotopic_mz": "1146.6332",
                                "intensity": "10723.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "8",
                                "monoisotopic_mass": "1100.5584",
                                "monoisotopic_mz": "1101.5657",
                                "intensity": "2621.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "9",
                                "monoisotopic_mass": "5714.9382",
                                "monoisotopic_mz": "382.0032",
                                "intensity": "1409.77",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "10",
                                "monoisotopic_mass": "1488.8034",
                                "monoisotopic_mz": "1489.8107",
                                "intensity": "6313.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "11",
                                "monoisotopic_mass": "1585.8205",
                                "monoisotopic_mz": "1586.8278",
                                "intensity": "3996.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "12",
                                "monoisotopic_mass": "1434.7472",
                                "monoisotopic_mz": "1435.7545",
                                "intensity": "2820.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0104",
                                        "ppm": "7.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "13",
                                "monoisotopic_mass": "3488.8107",
                                "monoisotopic_mz": "1163.9442",
                                "intensity": "20532.76",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0194",
                                            "ppm": "5.56"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0343",
                                            "ppm": "-9.83"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "14",
                                "monoisotopic_mass": "1780.8225",
                                "monoisotopic_mz": "1781.8298",
                                "intensity": "5415.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "15",
                                "monoisotopic_mass": "1241.6836",
                                "monoisotopic_mz": "1242.6909",
                                "intensity": "3257.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "16",
                                "monoisotopic_mass": "1602.8467",
                                "monoisotopic_mz": "1603.8540",
                                "intensity": "5628.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "17",
                                "monoisotopic_mass": "1032.5412",
                                "monoisotopic_mz": "1033.5485",
                                "intensity": "10858.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "18",
                                "monoisotopic_mass": "805.4134",
                                "monoisotopic_mz": "806.4207",
                                "intensity": "5635.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "19",
                                "monoisotopic_mass": "1434.7442",
                                "monoisotopic_mz": "718.3794",
                                "intensity": "39309.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0074",
                                        "ppm": "5.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "20",
                                "monoisotopic_mass": "5066.5508",
                                "monoisotopic_mz": "1267.6450",
                                "intensity": "15265.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0200",
                                        "ppm": "3.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "21",
                                "monoisotopic_mass": "4576.3502",
                                "monoisotopic_mz": "1145.0948",
                                "intensity": "4430.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4576.3245",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0257",
                                        "ppm": "5.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "22",
                                "monoisotopic_mass": "1670.9122",
                                "monoisotopic_mz": "836.4634",
                                "intensity": "7394.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "23",
                                "monoisotopic_mass": "3360.7116",
                                "monoisotopic_mz": "1121.2445",
                                "intensity": "14855.50",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0152",
                                        "ppm": "4.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "24",
                                "monoisotopic_mass": "3934.0048",
                                "monoisotopic_mz": "1312.3422",
                                "intensity": "10183.75",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0140",
                                        "ppm": "3.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "25",
                                "monoisotopic_mass": "4231.1172",
                                "monoisotopic_mz": "1411.3797",
                                "intensity": "3075.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "26",
                                "monoisotopic_mass": "3247.6310",
                                "monoisotopic_mz": "1083.5510",
                                "intensity": "17804.66",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0188",
                                        "ppm": "5.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "27",
                                "monoisotopic_mass": "5179.6420",
                                "monoisotopic_mz": "1295.9178",
                                "intensity": "5871.49",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0271",
                                        "ppm": "5.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "28",
                                "monoisotopic_mass": "4377.2329",
                                "monoisotopic_mz": "1095.3155",
                                "intensity": "6671.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "29",
                                "monoisotopic_mass": "4806.4267",
                                "monoisotopic_mz": "1202.6140",
                                "intensity": "8820.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "30",
                                "monoisotopic_mass": "7693.3882",
                                "monoisotopic_mz": "700.4062",
                                "intensity": "580.27",
                                "charge": "11"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "31",
                                "monoisotopic_mass": "3377.7411",
                                "monoisotopic_mz": "1126.9210",
                                "intensity": "5643.27",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "32",
                                "monoisotopic_mass": "4690.3697",
                                "monoisotopic_mz": "1173.5997",
                                "intensity": "5939.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "33",
                                "monoisotopic_mass": "1319.7163",
                                "monoisotopic_mz": "660.8654",
                                "intensity": "3462.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0064",
                                        "ppm": "4.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "34",
                                "monoisotopic_mass": "3616.9035",
                                "monoisotopic_mz": "1206.6418",
                                "intensity": "9430.80",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0173",
                                        "ppm": "4.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "35",
                                "monoisotopic_mass": "3148.5604",
                                "monoisotopic_mz": "1050.5274",
                                "intensity": "7372.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0165",
                                        "ppm": "5.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "36",
                                "monoisotopic_mass": "1370.7216",
                                "monoisotopic_mz": "1371.7289",
                                "intensity": "1888.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "37",
                                "monoisotopic_mass": "970.5104",
                                "monoisotopic_mz": "971.5176",
                                "intensity": "1749.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "38",
                                "monoisotopic_mass": "888.4063",
                                "monoisotopic_mz": "889.4136",
                                "intensity": "4402.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "39",
                                "monoisotopic_mass": "1291.7216",
                                "monoisotopic_mz": "646.8681",
                                "intensity": "2834.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "40",
                                "monoisotopic_mass": "4191.1149",
                                "monoisotopic_mz": "1398.0456",
                                "intensity": "4065.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0229",
                                        "ppm": "5.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "41",
                                "monoisotopic_mass": "4953.4669",
                                "monoisotopic_mz": "1239.3740",
                                "intensity": "12622.23",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0201",
                                        "ppm": "4.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "42",
                                "monoisotopic_mass": "1557.8271",
                                "monoisotopic_mz": "779.9208",
                                "intensity": "5108.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "43",
                                "monoisotopic_mass": "2675.6548",
                                "monoisotopic_mz": "892.8922",
                                "intensity": "2505.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "44",
                                "monoisotopic_mass": "3219.6342",
                                "monoisotopic_mz": "1074.2187",
                                "intensity": "9583.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "45",
                                "monoisotopic_mass": "2128.1320",
                                "monoisotopic_mz": "1065.0733",
                                "intensity": "7126.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "46",
                                "monoisotopic_mass": "1504.9287",
                                "monoisotopic_mz": "753.4716",
                                "intensity": "1316.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "47",
                                "monoisotopic_mass": "4045.0367",
                                "monoisotopic_mz": "1349.3528",
                                "intensity": "2731.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "48",
                                "monoisotopic_mass": "692.3278",
                                "monoisotopic_mz": "693.3350",
                                "intensity": "4182.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "49",
                                "monoisotopic_mass": "1193.6539",
                                "monoisotopic_mz": "597.8342",
                                "intensity": "1267.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "50",
                                "monoisotopic_mass": "5021.5434",
                                "monoisotopic_mz": "1256.3931",
                                "intensity": "5413.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "51",
                                "monoisotopic_mass": "2994.6354",
                                "monoisotopic_mz": "1498.3250",
                                "intensity": "4325.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "52",
                                "monoisotopic_mass": "1997.0285",
                                "monoisotopic_mz": "999.5215",
                                "intensity": "4137.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "53",
                                "monoisotopic_mass": "11061.6362",
                                "monoisotopic_mz": "851.9024",
                                "intensity": "2911.20",
                                "charge": "13"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "54",
                                "monoisotopic_mass": "2866.5699",
                                "monoisotopic_mz": "1434.2922",
                                "intensity": "2461.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "55",
                                "monoisotopic_mass": "5161.6231",
                                "monoisotopic_mz": "1291.4130",
                                "intensity": "3183.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "56",
                                "monoisotopic_mass": "514.2774",
                                "monoisotopic_mz": "515.2847",
                                "intensity": "2357.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "57",
                                "monoisotopic_mass": "1220.6467",
                                "monoisotopic_mz": "611.3306",
                                "intensity": "1973.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1220.6414",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0053",
                                        "ppm": "4.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "58",
                                "monoisotopic_mass": "387.2496",
                                "monoisotopic_mz": "388.2569",
                                "intensity": "2746.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "387.2482",
                                        "ion_position": "45",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "Y00003",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0015",
                                        "ppm": "3.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "59",
                                "monoisotopic_mass": "1330.6712",
                                "monoisotopic_mz": "1331.6785",
                                "intensity": "998.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "60",
                                "monoisotopic_mass": "2380.4650",
                                "monoisotopic_mz": "794.4956",
                                "intensity": "1504.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "61",
                                "monoisotopic_mass": "10056.4467",
                                "monoisotopic_mz": "915.2297",
                                "intensity": "1301.42",
                                "charge": "11"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "62",
                                "monoisotopic_mass": "4248.1398",
                                "monoisotopic_mz": "1417.0539",
                                "intensity": "3873.28",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4248.1134",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0264",
                                        "ppm": "6.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "63",
                                "monoisotopic_mass": "1001.4906",
                                "monoisotopic_mz": "1002.4979",
                                "intensity": "4726.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "64",
                                "monoisotopic_mass": "3202.6131",
                                "monoisotopic_mz": "1068.5450",
                                "intensity": "2856.07",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "65",
                                "monoisotopic_mass": "577.2408",
                                "monoisotopic_mz": "578.2480",
                                "intensity": "1128.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "66",
                                "monoisotopic_mass": "2799.3475",
                                "monoisotopic_mz": "934.1231",
                                "intensity": "2649.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "67",
                                "monoisotopic_mass": "11231.3140",
                                "monoisotopic_mz": "803.2440",
                                "intensity": "785.44",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "68",
                                "monoisotopic_mass": "3687.9473",
                                "monoisotopic_mz": "922.9941",
                                "intensity": "9567.98",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0239",
                                        "ppm": "6.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "69",
                                "monoisotopic_mass": "675.3012",
                                "monoisotopic_mz": "676.3085",
                                "intensity": "1298.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "70",
                                "monoisotopic_mass": "3472.7967",
                                "monoisotopic_mz": "1158.6062",
                                "intensity": "4573.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "71",
                                "monoisotopic_mass": "1964.9424",
                                "monoisotopic_mz": "983.4785",
                                "intensity": "3048.33",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0083",
                                        "ppm": "4.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "72",
                                "monoisotopic_mass": "3316.6955",
                                "monoisotopic_mz": "1106.5725",
                                "intensity": "1813.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "73",
                                "monoisotopic_mass": "5949.1945",
                                "monoisotopic_mz": "425.9497",
                                "intensity": "920.74",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "74",
                                "monoisotopic_mass": "2452.5068",
                                "monoisotopic_mz": "614.1340",
                                "intensity": "1030.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "75",
                                "monoisotopic_mass": "5049.5416",
                                "monoisotopic_mz": "1263.3927",
                                "intensity": "8046.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "76",
                                "monoisotopic_mass": "2546.5807",
                                "monoisotopic_mz": "637.6525",
                                "intensity": "1708.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "77",
                                "monoisotopic_mass": "4927.4751",
                                "monoisotopic_mz": "986.5023",
                                "intensity": "2872.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "78",
                                "monoisotopic_mass": "3247.6311",
                                "monoisotopic_mz": "812.9150",
                                "intensity": "2541.58",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0188",
                                        "ppm": "5.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "79",
                                "monoisotopic_mass": "9755.0760",
                                "monoisotopic_mz": "813.9303",
                                "intensity": "2161.55",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "80",
                                "monoisotopic_mass": "4190.1084",
                                "monoisotopic_mz": "1048.5344",
                                "intensity": "8064.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "81",
                                "monoisotopic_mass": "2108.2988",
                                "monoisotopic_mz": "703.7736",
                                "intensity": "1658.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "82",
                                "monoisotopic_mass": "5326.2759",
                                "monoisotopic_mz": "761.9038",
                                "intensity": "2086.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "83",
                                "monoisotopic_mass": "1734.8489",
                                "monoisotopic_mz": "868.4317",
                                "intensity": "2420.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0051",
                                        "ppm": "2.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "84",
                                "monoisotopic_mass": "9354.8414",
                                "monoisotopic_mz": "936.4914",
                                "intensity": "905.76",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "85",
                                "monoisotopic_mass": "4935.4576",
                                "monoisotopic_mz": "1234.8717",
                                "intensity": "7212.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "86",
                                "monoisotopic_mass": "3945.4468",
                                "monoisotopic_mz": "790.0966",
                                "intensity": "638.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "87",
                                "monoisotopic_mass": "4899.7725",
                                "monoisotopic_mz": "700.9748",
                                "intensity": "1966.58",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "88",
                                "monoisotopic_mass": "3709.9092",
                                "monoisotopic_mz": "928.4846",
                                "intensity": "3758.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "89",
                                "monoisotopic_mass": "3066.1998",
                                "monoisotopic_mz": "1023.0739",
                                "intensity": "1565.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "90",
                                "monoisotopic_mass": "3364.0738",
                                "monoisotopic_mz": "842.0257",
                                "intensity": "1904.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "91",
                                "monoisotopic_mass": "3598.8960",
                                "monoisotopic_mz": "900.7313",
                                "intensity": "2574.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "92",
                                "monoisotopic_mass": "2994.6034",
                                "monoisotopic_mz": "999.2084",
                                "intensity": "1859.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "93",
                                "monoisotopic_mass": "10477.5171",
                                "monoisotopic_mz": "749.4014",
                                "intensity": "1503.63",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "94",
                                "monoisotopic_mass": "8516.6679",
                                "monoisotopic_mz": "947.3037",
                                "intensity": "1797.33",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "95",
                                "monoisotopic_mass": "4063.0476",
                                "monoisotopic_mz": "1355.3565",
                                "intensity": "3690.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0143",
                                        "ppm": "3.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "96",
                                "monoisotopic_mass": "4452.7502",
                                "monoisotopic_mz": "743.1323",
                                "intensity": "1616.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "97",
                                "monoisotopic_mass": "3818.9876",
                                "monoisotopic_mz": "955.7542",
                                "intensity": "3554.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3818.9639",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0237",
                                        "ppm": "6.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "98",
                                "monoisotopic_mass": "7345.5045",
                                "monoisotopic_mz": "919.1953",
                                "intensity": "4072.66",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "99",
                                "monoisotopic_mass": "2194.0916",
                                "monoisotopic_mz": "732.3711",
                                "intensity": "2539.77",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0149",
                                        "ppm": "6.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "100",
                                "monoisotopic_mass": "3414.5203",
                                "monoisotopic_mz": "854.6374",
                                "intensity": "703.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "101",
                                "monoisotopic_mass": "7988.5250",
                                "monoisotopic_mz": "888.6212",
                                "intensity": "1235.81",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "102",
                                "monoisotopic_mass": "7129.4078",
                                "monoisotopic_mz": "713.9481",
                                "intensity": "2391.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "103",
                                "monoisotopic_mass": "2979.4703",
                                "monoisotopic_mz": "994.1641",
                                "intensity": "2648.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "104",
                                "monoisotopic_mass": "4061.0550",
                                "monoisotopic_mz": "1016.2710",
                                "intensity": "9573.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "105",
                                "monoisotopic_mass": "1981.9745",
                                "monoisotopic_mz": "991.9945",
                                "intensity": "2063.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "106",
                                "monoisotopic_mass": "1600.9923",
                                "monoisotopic_mz": "801.5034",
                                "intensity": "2004.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "107",
                                "monoisotopic_mass": "1925.1861",
                                "monoisotopic_mz": "963.6003",
                                "intensity": "1245.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "108",
                                "monoisotopic_mass": "3669.9292",
                                "monoisotopic_mz": "918.4896",
                                "intensity": "5497.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "109",
                                "monoisotopic_mass": "3934.0068",
                                "monoisotopic_mz": "984.5090",
                                "intensity": "5438.55",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0160",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "110",
                                "monoisotopic_mass": "5477.2681",
                                "monoisotopic_mz": "783.4741",
                                "intensity": "679.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "111",
                                "monoisotopic_mass": "2111.1100",
                                "monoisotopic_mz": "1056.5623",
                                "intensity": "2525.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "112",
                                "monoisotopic_mass": "3742.0274",
                                "monoisotopic_mz": "936.5141",
                                "intensity": "2250.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "113",
                                "monoisotopic_mass": "1542.9537",
                                "monoisotopic_mz": "772.4841",
                                "intensity": "1881.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "114",
                                "monoisotopic_mass": "6368.7874",
                                "monoisotopic_mz": "1062.4718",
                                "intensity": "1614.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "115",
                                "monoisotopic_mass": "1697.0505",
                                "monoisotopic_mz": "849.5325",
                                "intensity": "1633.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "116",
                                "monoisotopic_mass": "7495.6144",
                                "monoisotopic_mz": "937.9591",
                                "intensity": "5102.59",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "117",
                                "monoisotopic_mass": "3120.5734",
                                "monoisotopic_mz": "1041.1984",
                                "intensity": "2998.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "118",
                                "monoisotopic_mass": "5438.8611",
                                "monoisotopic_mz": "907.4841",
                                "intensity": "1957.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "119",
                                "monoisotopic_mass": "3503.1669",
                                "monoisotopic_mz": "876.7990",
                                "intensity": "1345.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "120",
                                "monoisotopic_mass": "2589.5879",
                                "monoisotopic_mz": "864.2032",
                                "intensity": "1522.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "121",
                                "monoisotopic_mass": "2832.3786",
                                "monoisotopic_mz": "945.1335",
                                "intensity": "1525.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "122",
                                "monoisotopic_mass": "6376.0238",
                                "monoisotopic_mz": "798.0103",
                                "intensity": "1563.03",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "123",
                                "monoisotopic_mass": "6030.7465",
                                "monoisotopic_mz": "862.5425",
                                "intensity": "2045.31",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "124",
                                "monoisotopic_mass": "5826.1991",
                                "monoisotopic_mz": "972.0405",
                                "intensity": "938.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "125",
                                "monoisotopic_mass": "5341.3574",
                                "monoisotopic_mz": "1069.2788",
                                "intensity": "4294.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "126",
                                "monoisotopic_mass": "8359.1732",
                                "monoisotopic_mz": "836.9246",
                                "intensity": "2352.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "127",
                                "monoisotopic_mass": "2812.7275",
                                "monoisotopic_mz": "704.1892",
                                "intensity": "1078.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "128",
                                "monoisotopic_mass": "3016.8551",
                                "monoisotopic_mz": "755.2211",
                                "intensity": "2437.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "129",
                                "monoisotopic_mass": "7646.4624",
                                "monoisotopic_mz": "850.6142",
                                "intensity": "791.64",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "130",
                                "monoisotopic_mass": "2069.7311",
                                "monoisotopic_mz": "1035.8728",
                                "intensity": "1370.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "131",
                                "monoisotopic_mass": "12950.7886",
                                "monoisotopic_mz": "864.3932",
                                "intensity": "987.92",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "132",
                                "monoisotopic_mass": "3900.0246",
                                "monoisotopic_mz": "781.0122",
                                "intensity": "2102.95",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "133",
                                "monoisotopic_mass": "1941.2005",
                                "monoisotopic_mz": "648.0741",
                                "intensity": "2265.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "134",
                                "monoisotopic_mass": "6544.0522",
                                "monoisotopic_mz": "819.0138",
                                "intensity": "2306.74",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "135",
                                "monoisotopic_mass": "7052.2141",
                                "monoisotopic_mz": "882.5340",
                                "intensity": "1071.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "136",
                                "monoisotopic_mass": "4295.7371",
                                "monoisotopic_mz": "716.9635",
                                "intensity": "1064.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "137",
                                "monoisotopic_mass": "5230.2422",
                                "monoisotopic_mz": "872.7143",
                                "intensity": "3861.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "138",
                                "monoisotopic_mass": "9914.1868",
                                "monoisotopic_mz": "661.9531",
                                "intensity": "558.76",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "139",
                                "monoisotopic_mass": "11039.8239",
                                "monoisotopic_mz": "920.9926",
                                "intensity": "854.23",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "140",
                                "monoisotopic_mass": "2631.9261",
                                "monoisotopic_mz": "878.3160",
                                "intensity": "766.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "141",
                                "monoisotopic_mass": "2159.0709",
                                "monoisotopic_mz": "720.6976",
                                "intensity": "724.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "142",
                                "monoisotopic_mass": "5189.2094",
                                "monoisotopic_mz": "865.8755",
                                "intensity": "3656.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "143",
                                "monoisotopic_mass": "1947.2012",
                                "monoisotopic_mz": "974.6079",
                                "intensity": "2043.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "144",
                                "monoisotopic_mass": "10558.7586",
                                "monoisotopic_mz": "813.2195",
                                "intensity": "588.55",
                                "charge": "13"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "145",
                                "monoisotopic_mass": "3164.5656",
                                "monoisotopic_mz": "1055.8625",
                                "intensity": "1331.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "146",
                                "monoisotopic_mass": "5260.3557",
                                "monoisotopic_mz": "1053.0784",
                                "intensity": "2829.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "147",
                                "monoisotopic_mass": "10164.2526",
                                "monoisotopic_mz": "925.0302",
                                "intensity": "3314.84",
                                "charge": "11"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "148",
                                "monoisotopic_mass": "3615.9076",
                                "monoisotopic_mz": "904.9842",
                                "intensity": "3591.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "149",
                                "monoisotopic_mass": "4192.2106",
                                "monoisotopic_mz": "839.4494",
                                "intensity": "734.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "150",
                                "monoisotopic_mass": "2647.6336",
                                "monoisotopic_mz": "883.5518",
                                "intensity": "459.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "151",
                                "monoisotopic_mass": "3147.5389",
                                "monoisotopic_mz": "787.8920",
                                "intensity": "2746.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "152",
                                "monoisotopic_mass": "5350.4008",
                                "monoisotopic_mz": "765.3502",
                                "intensity": "1377.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "153",
                                "monoisotopic_mass": "6383.4352",
                                "monoisotopic_mz": "912.9266",
                                "intensity": "2028.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "154",
                                "monoisotopic_mass": "3028.8685",
                                "monoisotopic_mz": "758.2244",
                                "intensity": "2017.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "155",
                                "monoisotopic_mass": "5356.3198",
                                "monoisotopic_mz": "893.7272",
                                "intensity": "2785.68",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "156",
                                "monoisotopic_mass": "6561.0399",
                                "monoisotopic_mz": "821.1373",
                                "intensity": "1916.79",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "157",
                                "monoisotopic_mass": "5857.7901",
                                "monoisotopic_mz": "837.8344",
                                "intensity": "1850.81",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "158",
                                "monoisotopic_mass": "3265.0017",
                                "monoisotopic_mz": "817.2577",
                                "intensity": "1480.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "159",
                                "monoisotopic_mass": "3170.9588",
                                "monoisotopic_mz": "793.7470",
                                "intensity": "895.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "160",
                                "monoisotopic_mass": "2845.4731",
                                "monoisotopic_mz": "949.4983",
                                "intensity": "1612.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "161",
                                "monoisotopic_mass": "5300.8033",
                                "monoisotopic_mz": "884.4745",
                                "intensity": "3070.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "162",
                                "monoisotopic_mass": "3060.6675",
                                "monoisotopic_mz": "766.1741",
                                "intensity": "1409.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "163",
                                "monoisotopic_mass": "11097.0429",
                                "monoisotopic_mz": "740.8101",
                                "intensity": "978.90",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "164",
                                "monoisotopic_mass": "5370.2068",
                                "monoisotopic_mz": "672.2831",
                                "intensity": "806.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "165",
                                "monoisotopic_mass": "2406.9964",
                                "monoisotopic_mz": "803.3394",
                                "intensity": "689.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "166",
                                "monoisotopic_mass": "2092.0394",
                                "monoisotopic_mz": "698.3537",
                                "intensity": "667.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "167",
                                "monoisotopic_mass": "4227.7148",
                                "monoisotopic_mz": "846.5502",
                                "intensity": "1962.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "168",
                                "monoisotopic_mass": "4788.8981",
                                "monoisotopic_mz": "799.1570",
                                "intensity": "2064.68",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "169",
                                "monoisotopic_mass": "8049.8703",
                                "monoisotopic_mz": "805.9943",
                                "intensity": "875.45",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "170",
                                "monoisotopic_mass": "2601.6011",
                                "monoisotopic_mz": "868.2076",
                                "intensity": "2193.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "171",
                                "monoisotopic_mass": "15754.2472",
                                "monoisotopic_mz": "1051.2904",
                                "intensity": "1118.60",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "172",
                                "monoisotopic_mass": "4175.0897",
                                "monoisotopic_mz": "1044.7797",
                                "intensity": "2757.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "173",
                                "monoisotopic_mass": "7998.9493",
                                "monoisotopic_mz": "800.9022",
                                "intensity": "714.37",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "174",
                                "monoisotopic_mass": "6335.9281",
                                "monoisotopic_mz": "1056.9953",
                                "intensity": "2340.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "175",
                                "monoisotopic_mass": "12171.4961",
                                "monoisotopic_mz": "812.4403",
                                "intensity": "765.34",
                                "charge": "15"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "176",
                                "monoisotopic_mass": "4118.5383",
                                "monoisotopic_mz": "687.4303",
                                "intensity": "1583.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "177",
                                "monoisotopic_mass": "1816.1242",
                                "monoisotopic_mz": "909.0694",
                                "intensity": "1351.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "178",
                                "monoisotopic_mass": "10645.5863",
                                "monoisotopic_mz": "761.4063",
                                "intensity": "2076.06",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "179",
                                "monoisotopic_mass": "6855.9080",
                                "monoisotopic_mz": "857.9958",
                                "intensity": "1798.40",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "180",
                                "monoisotopic_mass": "3915.9953",
                                "monoisotopic_mz": "980.0061",
                                "intensity": "1982.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "181",
                                "monoisotopic_mass": "1639.0130",
                                "monoisotopic_mz": "820.5138",
                                "intensity": "1439.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "182",
                                "monoisotopic_mass": "4627.7841",
                                "monoisotopic_mz": "926.5641",
                                "intensity": "2030.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "183",
                                "monoisotopic_mass": "4120.5281",
                                "monoisotopic_mz": "825.1129",
                                "intensity": "783.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "184",
                                "monoisotopic_mass": "4362.7532",
                                "monoisotopic_mz": "873.5579",
                                "intensity": "2746.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "185",
                                "monoisotopic_mass": "1904.1830",
                                "monoisotopic_mz": "953.0988",
                                "intensity": "2544.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "186",
                                "monoisotopic_mass": "6789.2529",
                                "monoisotopic_mz": "970.9005",
                                "intensity": "2451.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "187",
                                "monoisotopic_mass": "6288.5489",
                                "monoisotopic_mz": "899.3714",
                                "intensity": "1218.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "188",
                                "monoisotopic_mass": "6201.8347",
                                "monoisotopic_mz": "886.9837",
                                "intensity": "2069.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "189",
                                "monoisotopic_mass": "10744.5961",
                                "monoisotopic_mz": "896.3903",
                                "intensity": "2716.19",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "190",
                                "monoisotopic_mass": "1620.0112",
                                "monoisotopic_mz": "811.0129",
                                "intensity": "1030.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "191",
                                "monoisotopic_mass": "4252.0838",
                                "monoisotopic_mz": "851.4240",
                                "intensity": "1812.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "192",
                                "monoisotopic_mass": "1652.7915",
                                "monoisotopic_mz": "827.4030",
                                "intensity": "1184.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "193",
                                "monoisotopic_mass": "5282.0475",
                                "monoisotopic_mz": "881.3485",
                                "intensity": "862.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "194",
                                "monoisotopic_mass": "9049.1836",
                                "monoisotopic_mz": "823.6603",
                                "intensity": "1760.84",
                                "charge": "11"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "195",
                                "monoisotopic_mass": "4517.4893",
                                "monoisotopic_mz": "753.9222",
                                "intensity": "866.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "196",
                                "monoisotopic_mass": "9903.9551",
                                "monoisotopic_mz": "991.4028",
                                "intensity": "2433.10",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "197",
                                "monoisotopic_mass": "3654.6419",
                                "monoisotopic_mz": "914.6677",
                                "intensity": "1378.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "198",
                                "monoisotopic_mass": "2700.6756",
                                "monoisotopic_mz": "901.2325",
                                "intensity": "1801.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "199",
                                "monoisotopic_mass": "7604.6525",
                                "monoisotopic_mz": "845.9687",
                                "intensity": "858.31",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "200",
                                "monoisotopic_mass": "5492.6256",
                                "monoisotopic_mz": "916.4449",
                                "intensity": "2628.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "201",
                                "monoisotopic_mass": "3700.2913",
                                "monoisotopic_mz": "741.0655",
                                "intensity": "2205.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "202",
                                "monoisotopic_mass": "4791.4014",
                                "monoisotopic_mz": "959.2876",
                                "intensity": "1615.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "203",
                                "monoisotopic_mass": "2878.4256",
                                "monoisotopic_mz": "960.4825",
                                "intensity": "4403.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "204",
                                "monoisotopic_mass": "4435.0953",
                                "monoisotopic_mz": "888.0263",
                                "intensity": "1882.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "205",
                                "monoisotopic_mass": "7371.2221",
                                "monoisotopic_mz": "922.4100",
                                "intensity": "1596.38",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "206",
                                "monoisotopic_mass": "3794.3440",
                                "monoisotopic_mz": "759.8761",
                                "intensity": "2167.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "207",
                                "monoisotopic_mass": "5144.0211",
                                "monoisotopic_mz": "858.3441",
                                "intensity": "559.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "208",
                                "monoisotopic_mass": "6902.2270",
                                "monoisotopic_mz": "987.0397",
                                "intensity": "1366.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "209",
                                "monoisotopic_mass": "8267.8900",
                                "monoisotopic_mz": "827.7963",
                                "intensity": "1156.73",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "210",
                                "monoisotopic_mass": "12301.4755",
                                "monoisotopic_mz": "879.6841",
                                "intensity": "1005.00",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "211",
                                "monoisotopic_mass": "5461.3690",
                                "monoisotopic_mz": "781.2029",
                                "intensity": "2554.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "212",
                                "monoisotopic_mass": "10483.6847",
                                "monoisotopic_mz": "874.6477",
                                "intensity": "2710.39",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "213",
                                "monoisotopic_mass": "6620.3079",
                                "monoisotopic_mz": "946.7655",
                                "intensity": "2437.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "214",
                                "monoisotopic_mass": "6691.4580",
                                "monoisotopic_mz": "956.9298",
                                "intensity": "2260.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "215",
                                "monoisotopic_mass": "7830.9186",
                                "monoisotopic_mz": "784.0991",
                                "intensity": "1329.97",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "216",
                                "monoisotopic_mass": "4894.7320",
                                "monoisotopic_mz": "979.9537",
                                "intensity": "2371.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "217",
                                "monoisotopic_mass": "5620.9822",
                                "monoisotopic_mz": "937.8376",
                                "intensity": "1580.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "218",
                                "monoisotopic_mass": "4523.8101",
                                "monoisotopic_mz": "905.7693",
                                "intensity": "796.85",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "219",
                                "monoisotopic_mass": "10151.0599",
                                "monoisotopic_mz": "846.9289",
                                "intensity": "1688.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "220",
                                "monoisotopic_mass": "8194.4034",
                                "monoisotopic_mz": "820.4476",
                                "intensity": "1096.98",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "221",
                                "monoisotopic_mass": "5846.7136",
                                "monoisotopic_mz": "731.8465",
                                "intensity": "672.24",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "222",
                                "monoisotopic_mass": "4979.4910",
                                "monoisotopic_mz": "830.9224",
                                "intensity": "876.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "223",
                                "monoisotopic_mass": "4036.5011",
                                "monoisotopic_mz": "808.3075",
                                "intensity": "853.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "224",
                                "monoisotopic_mass": "5400.9964",
                                "monoisotopic_mz": "901.1733",
                                "intensity": "930.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "225",
                                "monoisotopic_mass": "11386.0223",
                                "monoisotopic_mz": "949.8425",
                                "intensity": "1027.82",
                                "charge": "12"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "226",
                                "monoisotopic_mass": "6261.0592",
                                "monoisotopic_mz": "1044.5171",
                                "intensity": "3291.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "227",
                                "monoisotopic_mass": "8466.0756",
                                "monoisotopic_mz": "1059.2667",
                                "intensity": "1856.82",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "228",
                                "monoisotopic_mass": "7408.4412",
                                "monoisotopic_mz": "1059.3560",
                                "intensity": "948.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "229",
                                "monoisotopic_mass": "11306.8921",
                                "monoisotopic_mz": "808.6424",
                                "intensity": "619.75",
                                "charge": "14"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "230",
                                "monoisotopic_mass": "2308.9216",
                                "monoisotopic_mz": "770.6478",
                                "intensity": "638.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "231",
                                "monoisotopic_mass": "6723.7266",
                                "monoisotopic_mz": "961.5396",
                                "intensity": "813.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "232",
                                "monoisotopic_mass": "8734.8759",
                                "monoisotopic_mz": "874.4949",
                                "intensity": "584.16",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "233",
                                "monoisotopic_mass": "4847.9646",
                                "monoisotopic_mz": "809.0014",
                                "intensity": "908.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "234",
                                "monoisotopic_mass": "9329.8145",
                                "monoisotopic_mz": "933.9887",
                                "intensity": "1297.80",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "235",
                                "monoisotopic_mass": "4691.8960",
                                "monoisotopic_mz": "939.3865",
                                "intensity": "1235.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "236",
                                "monoisotopic_mass": "4279.1600",
                                "monoisotopic_mz": "856.8393",
                                "intensity": "1694.68",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "237",
                                "monoisotopic_mass": "3291.7208",
                                "monoisotopic_mz": "823.9375",
                                "intensity": "927.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "238",
                                "monoisotopic_mass": "4358.2105",
                                "monoisotopic_mz": "1090.5599",
                                "intensity": "3223.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "239",
                                "monoisotopic_mass": "1862.8940",
                                "monoisotopic_mz": "932.4543",
                                "intensity": "9990.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "240",
                                "monoisotopic_mass": "2394.6920",
                                "monoisotopic_mz": "1198.3533",
                                "intensity": "2419.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "241",
                                "monoisotopic_mass": "4821.5857",
                                "monoisotopic_mz": "804.6049",
                                "intensity": "986.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "242",
                                "monoisotopic_mass": "7325.5246",
                                "monoisotopic_mz": "814.9545",
                                "intensity": "816.52",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "243",
                                "monoisotopic_mass": "4906.4543",
                                "monoisotopic_mz": "1227.6208",
                                "intensity": "3762.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "244",
                                "monoisotopic_mass": "3198.6539",
                                "monoisotopic_mz": "800.6707",
                                "intensity": "1282.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "245",
                                "monoisotopic_mass": "4804.7330",
                                "monoisotopic_mz": "961.9539",
                                "intensity": "1627.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "246",
                                "monoisotopic_mass": "8347.1401",
                                "monoisotopic_mz": "928.4673",
                                "intensity": "927.01",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "247",
                                "monoisotopic_mass": "9413.3551",
                                "monoisotopic_mz": "856.7668",
                                "intensity": "880.72",
                                "charge": "11"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "248",
                                "monoisotopic_mass": "4186.5868",
                                "monoisotopic_mz": "698.7717",
                                "intensity": "1333.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "249",
                                "monoisotopic_mass": "1885.0008",
                                "monoisotopic_mz": "943.5077",
                                "intensity": "4026.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "250",
                                "monoisotopic_mass": "4406.9551",
                                "monoisotopic_mz": "882.3983",
                                "intensity": "1646.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "251",
                                "monoisotopic_mass": "2570.5782",
                                "monoisotopic_mz": "643.6518",
                                "intensity": "1436.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "252",
                                "monoisotopic_mass": "1835.9951",
                                "monoisotopic_mz": "919.0048",
                                "intensity": "3477.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "253",
                                "monoisotopic_mass": "4744.7415",
                                "monoisotopic_mz": "791.7975",
                                "intensity": "790.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "254",
                                "monoisotopic_mass": "3968.2867",
                                "monoisotopic_mz": "794.6646",
                                "intensity": "718.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "255",
                                "monoisotopic_mass": "5042.1171",
                                "monoisotopic_mz": "841.3601",
                                "intensity": "1309.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "256",
                                "monoisotopic_mass": "1797.1081",
                                "monoisotopic_mz": "899.5613",
                                "intensity": "1786.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "257",
                                "monoisotopic_mass": "4108.1108",
                                "monoisotopic_mz": "822.6294",
                                "intensity": "865.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "258",
                                "monoisotopic_mass": "7416.5825",
                                "monoisotopic_mz": "825.0720",
                                "intensity": "779.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "259",
                                "monoisotopic_mass": "2176.0689",
                                "monoisotopic_mz": "726.3636",
                                "intensity": "4542.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "260",
                                "monoisotopic_mass": "1783.9506",
                                "monoisotopic_mz": "892.9826",
                                "intensity": "6023.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "261",
                                "monoisotopic_mass": "4330.7792",
                                "monoisotopic_mz": "867.1631",
                                "intensity": "1042.34",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "262",
                                "monoisotopic_mass": "6096.6916",
                                "monoisotopic_mz": "871.9632",
                                "intensity": "1599.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "263",
                                "monoisotopic_mass": "6481.5951",
                                "monoisotopic_mz": "811.2067",
                                "intensity": "812.02",
                                "charge": "8"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "264",
                                "monoisotopic_mass": "10788.7394",
                                "monoisotopic_mz": "830.9103",
                                "intensity": "1657.07",
                                "charge": "13"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "265",
                                "monoisotopic_mass": "7277.1566",
                                "monoisotopic_mz": "728.7229",
                                "intensity": "917.70",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "266",
                                "monoisotopic_mass": "4315.0598",
                                "monoisotopic_mz": "864.0192",
                                "intensity": "856.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "267",
                                "monoisotopic_mass": "3122.9232",
                                "monoisotopic_mz": "781.7381",
                                "intensity": "2139.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "268",
                                "monoisotopic_mass": "3783.3344",
                                "monoisotopic_mz": "946.8409",
                                "intensity": "1997.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "269",
                                "monoisotopic_mass": "5884.6177",
                                "monoisotopic_mz": "841.6670",
                                "intensity": "1478.60",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "270",
                                "monoisotopic_mass": "9474.2990",
                                "monoisotopic_mz": "948.4372",
                                "intensity": "739.25",
                                "charge": "10"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "271",
                                "monoisotopic_mass": "4899.5857",
                                "monoisotopic_mz": "817.6049",
                                "intensity": "523.63",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "217",
                                        "peak_id": "57",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "217",
                                        "peak_id": "33",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "217",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "217",
                                            "peak_id": "12",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "217",
                                        "peak_id": "83",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "217",
                                            "peak_id": "71",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "spec_id": "217",
                                            "peak_id": "13",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "217",
                                        "peak_id": "99",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "217",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "217",
                                            "peak_id": "26",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "217",
                                            "peak_id": "78",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "217",
                                        "peak_id": "23",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "217",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "217",
                                        "peak_id": "34",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "217",
                                        "peak_id": "68",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "217",
                                        "peak_id": "97",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "217",
                                            "peak_id": "24",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "217",
                                            "peak_id": "109",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "217",
                                        "peak_id": "95",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "217",
                                        "peak_id": "40",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "217",
                                        "peak_id": "62",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "217",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "217",
                                        "peak_id": "41",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "3",
                                            "spec_id": "217",
                                            "peak_id": "58",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "217",
                                            "peak_id": "20",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "217",
                                        "peak_id": "27",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "110",
                "p_value": "3.21e-13",
                "e_value": "3.21e-13",
                "fdr": "0",
                "matched_fragment_number": "21",
                "matched_peak_number": "21",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "598",
                        "ms1_scans": "857",
                        "ids": "260",
                        "scans": "860",
                        "precursor_mono_mass": "5453.8037",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7680",
                        "feature_inte": "2.3043e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "260",
                                "peak_id": "0",
                                "monoisotopic_mass": "1698.9122",
                                "monoisotopic_mz": "1699.9194",
                                "intensity": "2155.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "1",
                                "monoisotopic_mass": "1602.8448",
                                "monoisotopic_mz": "1603.8520",
                                "intensity": "9687.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "2",
                                "monoisotopic_mass": "1642.9188",
                                "monoisotopic_mz": "1643.9260",
                                "intensity": "1828.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "3",
                                "monoisotopic_mass": "1585.8166",
                                "monoisotopic_mz": "1586.8239",
                                "intensity": "7064.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "4",
                                "monoisotopic_mass": "1715.9297",
                                "monoisotopic_mz": "1716.9370",
                                "intensity": "3686.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "5",
                                "monoisotopic_mass": "1411.7726",
                                "monoisotopic_mz": "1412.7799",
                                "intensity": "3027.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "6",
                                "monoisotopic_mass": "1387.7538",
                                "monoisotopic_mz": "1388.7611",
                                "intensity": "9615.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "7",
                                "monoisotopic_mass": "1488.8014",
                                "monoisotopic_mz": "1489.8087",
                                "intensity": "12373.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "8",
                                "monoisotopic_mass": "1258.7096",
                                "monoisotopic_mz": "1259.7169",
                                "intensity": "14630.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "9",
                                "monoisotopic_mass": "2015.0476",
                                "monoisotopic_mz": "1008.5311",
                                "intensity": "15310.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "10",
                                "monoisotopic_mass": "1428.7856",
                                "monoisotopic_mz": "1429.7928",
                                "intensity": "3818.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "11",
                                "monoisotopic_mass": "1784.9552",
                                "monoisotopic_mz": "893.4849",
                                "intensity": "9401.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "12",
                                "monoisotopic_mass": "805.4125",
                                "monoisotopic_mz": "806.4197",
                                "intensity": "9278.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "13",
                                "monoisotopic_mass": "2128.1320",
                                "monoisotopic_mz": "1065.0733",
                                "intensity": "11865.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "14",
                                "monoisotopic_mass": "1557.8233",
                                "monoisotopic_mz": "1558.8306",
                                "intensity": "4073.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "15",
                                "monoisotopic_mass": "1670.9091",
                                "monoisotopic_mz": "836.4619",
                                "intensity": "11922.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "16",
                                "monoisotopic_mass": "918.4976",
                                "monoisotopic_mz": "919.5048",
                                "intensity": "6983.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "17",
                                "monoisotopic_mass": "1145.6248",
                                "monoisotopic_mz": "1146.6321",
                                "intensity": "18761.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "18",
                                "monoisotopic_mass": "1032.5406",
                                "monoisotopic_mz": "1033.5479",
                                "intensity": "21329.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "19",
                                "monoisotopic_mass": "1670.9148",
                                "monoisotopic_mz": "1671.9221",
                                "intensity": "3598.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "20",
                                "monoisotopic_mass": "1863.8977",
                                "monoisotopic_mz": "932.9561",
                                "intensity": "8973.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0114",
                                        "ppm": "6.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "21",
                                "monoisotopic_mass": "1128.5986",
                                "monoisotopic_mz": "1129.6058",
                                "intensity": "7706.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "22",
                                "monoisotopic_mass": "1557.8257",
                                "monoisotopic_mz": "779.9201",
                                "intensity": "10688.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "23",
                                "monoisotopic_mass": "1780.8268",
                                "monoisotopic_mz": "1781.8340",
                                "intensity": "2087.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "24",
                                "monoisotopic_mass": "1370.7254",
                                "monoisotopic_mz": "1371.7327",
                                "intensity": "5219.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "25",
                                "monoisotopic_mass": "1434.7441",
                                "monoisotopic_mz": "718.3793",
                                "intensity": "30493.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0073",
                                        "ppm": "5.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "26",
                                "monoisotopic_mass": "1539.8147",
                                "monoisotopic_mz": "770.9146",
                                "intensity": "1657.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "27",
                                "monoisotopic_mass": "5066.5606",
                                "monoisotopic_mz": "1267.6474",
                                "intensity": "16830.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0297",
                                        "ppm": "5.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "28",
                                "monoisotopic_mass": "2866.5724",
                                "monoisotopic_mz": "1434.2935",
                                "intensity": "5342.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "29",
                                "monoisotopic_mass": "1886.0034",
                                "monoisotopic_mz": "944.0090",
                                "intensity": "6125.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "30",
                                "monoisotopic_mass": "3488.8034",
                                "monoisotopic_mz": "1163.9417",
                                "intensity": "14753.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0121",
                                        "ppm": "3.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "31",
                                "monoisotopic_mass": "1997.0288",
                                "monoisotopic_mz": "999.5217",
                                "intensity": "5987.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "32",
                                "monoisotopic_mass": "4376.2295",
                                "monoisotopic_mz": "1095.0646",
                                "intensity": "5176.41",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0211",
                                        "ppm": "4.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "33",
                                "monoisotopic_mass": "4806.4161",
                                "monoisotopic_mz": "1202.6113",
                                "intensity": "6702.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0377",
                                        "ppm": "7.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "34",
                                "monoisotopic_mass": "692.3274",
                                "monoisotopic_mz": "693.3347",
                                "intensity": "8324.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "35",
                                "monoisotopic_mass": "2798.4621",
                                "monoisotopic_mz": "1400.2383",
                                "intensity": "3285.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "36",
                                "monoisotopic_mass": "2194.0880",
                                "monoisotopic_mz": "732.3699",
                                "intensity": "2938.19",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0113",
                                        "ppm": "5.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "37",
                                "monoisotopic_mass": "2241.2140",
                                "monoisotopic_mz": "1121.6143",
                                "intensity": "5873.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "38",
                                "monoisotopic_mass": "1642.9166",
                                "monoisotopic_mz": "822.4656",
                                "intensity": "5414.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "39",
                                "monoisotopic_mass": "1241.6836",
                                "monoisotopic_mz": "1242.6909",
                                "intensity": "5385.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "40",
                                "monoisotopic_mass": "3014.6173",
                                "monoisotopic_mz": "1508.3159",
                                "intensity": "5673.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "41",
                                "monoisotopic_mass": "3247.6256",
                                "monoisotopic_mz": "1083.5491",
                                "intensity": "12545.26",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0133",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "42",
                                "monoisotopic_mass": "3687.9434",
                                "monoisotopic_mz": "922.9931",
                                "intensity": "6279.33",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0200",
                                        "ppm": "5.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "43",
                                "monoisotopic_mass": "3616.9010",
                                "monoisotopic_mz": "1206.6409",
                                "intensity": "6726.75",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0147",
                                        "ppm": "4.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "44",
                                "monoisotopic_mass": "1771.8889",
                                "monoisotopic_mz": "886.9517",
                                "intensity": "1251.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "45",
                                "monoisotopic_mass": "2505.4034",
                                "monoisotopic_mz": "1253.7090",
                                "intensity": "2960.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "46",
                                "monoisotopic_mass": "675.3005",
                                "monoisotopic_mz": "676.3077",
                                "intensity": "3100.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "47",
                                "monoisotopic_mass": "2110.1100",
                                "monoisotopic_mz": "1056.0623",
                                "intensity": "4078.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "48",
                                "monoisotopic_mass": "2093.0390",
                                "monoisotopic_mz": "1047.5268",
                                "intensity": "4938.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0099",
                                        "ppm": "4.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "49",
                                "monoisotopic_mass": "1319.7152",
                                "monoisotopic_mz": "660.8649",
                                "intensity": "2305.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0053",
                                        "ppm": "4.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "50",
                                "monoisotopic_mass": "4953.4654",
                                "monoisotopic_mz": "1239.3736",
                                "intensity": "10982.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0186",
                                        "ppm": "3.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "51",
                                "monoisotopic_mass": "3332.7118",
                                "monoisotopic_mz": "1111.9112",
                                "intensity": "7623.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "52",
                                "monoisotopic_mass": "3598.8951",
                                "monoisotopic_mz": "900.7310",
                                "intensity": "4317.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "53",
                                "monoisotopic_mass": "3377.7499",
                                "monoisotopic_mz": "1126.9239",
                                "intensity": "3226.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "54",
                                "monoisotopic_mass": "1015.5143",
                                "monoisotopic_mz": "1016.5216",
                                "intensity": "8744.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "55",
                                "monoisotopic_mass": "4191.1162",
                                "monoisotopic_mz": "1048.7863",
                                "intensity": "4984.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0242",
                                        "ppm": "5.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "56",
                                "monoisotopic_mass": "5049.5390",
                                "monoisotopic_mz": "1263.3920",
                                "intensity": "8503.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "57",
                                "monoisotopic_mass": "1164.6482",
                                "monoisotopic_mz": "583.3314",
                                "intensity": "1273.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "58",
                                "monoisotopic_mass": "2355.2650",
                                "monoisotopic_mz": "1178.6398",
                                "intensity": "5002.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "59",
                                "monoisotopic_mass": "1326.6864",
                                "monoisotopic_mz": "1327.6937",
                                "intensity": "1011.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "60",
                                "monoisotopic_mass": "1099.5551",
                                "monoisotopic_mz": "1100.5624",
                                "intensity": "2035.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "61",
                                "monoisotopic_mass": "3204.6068",
                                "monoisotopic_mz": "1069.2095",
                                "intensity": "1787.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "62",
                                "monoisotopic_mass": "788.3860",
                                "monoisotopic_mz": "789.3932",
                                "intensity": "2789.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "63",
                                "monoisotopic_mass": "3219.6375",
                                "monoisotopic_mz": "1074.2198",
                                "intensity": "7610.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "64",
                                "monoisotopic_mass": "1271.7444",
                                "monoisotopic_mz": "636.8795",
                                "intensity": "1495.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "65",
                                "monoisotopic_mass": "3915.9979",
                                "monoisotopic_mz": "1306.3399",
                                "intensity": "3280.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "66",
                                "monoisotopic_mass": "1299.7390",
                                "monoisotopic_mz": "650.8768",
                                "intensity": "2651.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "67",
                                "monoisotopic_mass": "1946.9311",
                                "monoisotopic_mz": "974.4728",
                                "intensity": "2723.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "68",
                                "monoisotopic_mass": "2538.2724",
                                "monoisotopic_mz": "847.0981",
                                "intensity": "742.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "69",
                                "monoisotopic_mass": "3576.9170",
                                "monoisotopic_mz": "895.2365",
                                "intensity": "1235.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "70",
                                "monoisotopic_mass": "1463.7767",
                                "monoisotopic_mz": "1464.7839",
                                "intensity": "1674.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "71",
                                "monoisotopic_mass": "3360.7141",
                                "monoisotopic_mz": "1121.2453",
                                "intensity": "12684.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0178",
                                        "ppm": "5.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "72",
                                "monoisotopic_mass": "2866.5760",
                                "monoisotopic_mz": "956.5326",
                                "intensity": "1794.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "73",
                                "monoisotopic_mass": "3599.8890",
                                "monoisotopic_mz": "1200.9703",
                                "intensity": "2622.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "74",
                                "monoisotopic_mass": "4063.0653",
                                "monoisotopic_mz": "1355.3624",
                                "intensity": "3268.46",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4063.0334",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0319",
                                        "ppm": "7.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "75",
                                "monoisotopic_mass": "3471.7906",
                                "monoisotopic_mz": "1158.2708",
                                "intensity": "4092.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "76",
                                "monoisotopic_mass": "587.3129",
                                "monoisotopic_mz": "588.3201",
                                "intensity": "1266.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "77",
                                "monoisotopic_mass": "2976.6148",
                                "monoisotopic_mz": "993.2122",
                                "intensity": "2070.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "78",
                                "monoisotopic_mass": "2879.4142",
                                "monoisotopic_mz": "960.8120",
                                "intensity": "3010.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0079",
                                        "ppm": "2.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "79",
                                "monoisotopic_mass": "3934.0089",
                                "monoisotopic_mz": "1312.3436",
                                "intensity": "6971.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0181",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "80",
                                "monoisotopic_mass": "2994.6348",
                                "monoisotopic_mz": "999.2189",
                                "intensity": "1793.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "81",
                                "monoisotopic_mass": "2467.3397",
                                "monoisotopic_mz": "1234.6771",
                                "intensity": "4523.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "82",
                                "monoisotopic_mass": "1964.9452",
                                "monoisotopic_mz": "983.4799",
                                "intensity": "2628.97",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1964.9341",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0112",
                                        "ppm": "5.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "83",
                                "monoisotopic_mass": "4935.4522",
                                "monoisotopic_mz": "1234.8703",
                                "intensity": "4972.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "84",
                                "monoisotopic_mass": "3148.5523",
                                "monoisotopic_mz": "1050.5247",
                                "intensity": "5741.09",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0084",
                                        "ppm": "2.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "85",
                                "monoisotopic_mass": "5179.6348",
                                "monoisotopic_mz": "1295.9160",
                                "intensity": "5720.91",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0199",
                                        "ppm": "3.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "86",
                                "monoisotopic_mass": "5161.6182",
                                "monoisotopic_mz": "1291.4118",
                                "intensity": "4593.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "87",
                                "monoisotopic_mass": "2629.0912",
                                "monoisotopic_mz": "877.3710",
                                "intensity": "1864.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "88",
                                "monoisotopic_mass": "3315.7104",
                                "monoisotopic_mz": "1106.2441",
                                "intensity": "1618.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "260",
                                "peak_id": "89",
                                "monoisotopic_mass": "4788.4000",
                                "monoisotopic_mz": "1198.1073",
                                "intensity": "4450.94",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "260",
                                        "peak_id": "49",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "260",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "260",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "260",
                                        "peak_id": "82",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "260",
                                        "peak_id": "48",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "260",
                                        "peak_id": "36",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "260",
                                        "peak_id": "78",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "260",
                                        "peak_id": "84",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "260",
                                        "peak_id": "41",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "260",
                                        "peak_id": "71",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "260",
                                        "peak_id": "30",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "260",
                                        "peak_id": "43",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "260",
                                        "peak_id": "42",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "260",
                                        "peak_id": "79",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "260",
                                        "peak_id": "74",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "260",
                                        "peak_id": "55",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "260",
                                        "peak_id": "32",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "260",
                                        "peak_id": "33",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "260",
                                        "peak_id": "50",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "260",
                                        "peak_id": "27",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "260",
                                        "peak_id": "85",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "63",
                "p_value": "1.05e-11",
                "e_value": "1.05e-11",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "573",
                        "ms1_scans": "757",
                        "ids": "185",
                        "scans": "760",
                        "precursor_mono_mass": "5452.8015",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.5676",
                        "feature_inte": "6.3321e+06"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "185",
                                "peak_id": "0",
                                "monoisotopic_mass": "5066.5488",
                                "monoisotopic_mz": "1267.6445",
                                "intensity": "18872.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0179",
                                        "ppm": "3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "1",
                                "monoisotopic_mass": "860.5332",
                                "monoisotopic_mz": "861.5405",
                                "intensity": "6198.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "2",
                                "monoisotopic_mass": "1434.7446",
                                "monoisotopic_mz": "718.3796",
                                "intensity": "41305.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0078",
                                        "ppm": "5.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "3",
                                "monoisotopic_mass": "3488.8063",
                                "monoisotopic_mz": "1163.9427",
                                "intensity": "15702.80",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3488.7913",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0150",
                                        "ppm": "4.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "4",
                                "monoisotopic_mass": "3933.9986",
                                "monoisotopic_mz": "1312.3401",
                                "intensity": "8380.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3933.9908",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0078",
                                        "ppm": "1.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "5",
                                "monoisotopic_mass": "4935.4420",
                                "monoisotopic_mz": "1234.8678",
                                "intensity": "7441.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "6",
                                "monoisotopic_mass": "3247.6197",
                                "monoisotopic_mz": "1083.5472",
                                "intensity": "13745.87",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0074",
                                        "ppm": "2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "7",
                                "monoisotopic_mass": "1519.9300",
                                "monoisotopic_mz": "507.6506",
                                "intensity": "1653.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "8",
                                "monoisotopic_mass": "955.5914",
                                "monoisotopic_mz": "956.5986",
                                "intensity": "5007.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "9",
                                "monoisotopic_mass": "1678.0372",
                                "monoisotopic_mz": "840.0259",
                                "intensity": "6974.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "10",
                                "monoisotopic_mass": "5179.6231",
                                "monoisotopic_mz": "1295.9130",
                                "intensity": "7848.63",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5179.6149",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0081",
                                        "ppm": "1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "11",
                                "monoisotopic_mass": "4953.4644",
                                "monoisotopic_mz": "1239.3734",
                                "intensity": "9163.37",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4953.4468",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0176",
                                        "ppm": "3.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "12",
                                "monoisotopic_mass": "1096.6786",
                                "monoisotopic_mz": "1097.6859",
                                "intensity": "4669.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "13",
                                "monoisotopic_mass": "789.4874",
                                "monoisotopic_mz": "790.4947",
                                "intensity": "5137.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "14",
                                "monoisotopic_mass": "2093.0333",
                                "monoisotopic_mz": "1047.5239",
                                "intensity": "7059.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0043",
                                        "ppm": "2.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "15",
                                "monoisotopic_mass": "3616.8966",
                                "monoisotopic_mz": "1206.6395",
                                "intensity": "8419.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0104",
                                        "ppm": "2.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "16",
                                "monoisotopic_mass": "1113.6853",
                                "monoisotopic_mz": "1114.6926",
                                "intensity": "2658.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "17",
                                "monoisotopic_mass": "1341.8258",
                                "monoisotopic_mz": "671.9202",
                                "intensity": "2761.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "18",
                                "monoisotopic_mass": "511.3003",
                                "monoisotopic_mz": "512.3076",
                                "intensity": "1447.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "511.2979",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "ion_sort_name": "B00004",
                                        "ion_left_position": "4",
                                        "mass_error": "0.0024",
                                        "ppm": "4.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "19",
                                "monoisotopic_mass": "1297.7903",
                                "monoisotopic_mz": "433.6040",
                                "intensity": "3051.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "20",
                                "monoisotopic_mass": "1514.9375",
                                "monoisotopic_mz": "758.4760",
                                "intensity": "3732.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "21",
                                "monoisotopic_mass": "1409.8628",
                                "monoisotopic_mz": "470.9615",
                                "intensity": "2050.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "22",
                                "monoisotopic_mass": "1546.9630",
                                "monoisotopic_mz": "774.4888",
                                "intensity": "5005.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "23",
                                "monoisotopic_mass": "1435.8771",
                                "monoisotopic_mz": "479.6330",
                                "intensity": "2537.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "24",
                                "monoisotopic_mass": "786.4719",
                                "monoisotopic_mz": "394.2432",
                                "intensity": "2200.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "25",
                                "monoisotopic_mass": "807.4867",
                                "monoisotopic_mz": "404.7506",
                                "intensity": "1454.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "807.4828",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0039",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "26",
                                "monoisotopic_mass": "2519.5503",
                                "monoisotopic_mz": "630.8948",
                                "intensity": "3972.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "27",
                                "monoisotopic_mass": "1305.6617",
                                "monoisotopic_mz": "1306.6689",
                                "intensity": "2426.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "28",
                                "monoisotopic_mass": "2453.5099",
                                "monoisotopic_mz": "614.3848",
                                "intensity": "2788.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "29",
                                "monoisotopic_mass": "2670.6448",
                                "monoisotopic_mz": "891.2222",
                                "intensity": "8915.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "30",
                                "monoisotopic_mass": "1128.7004",
                                "monoisotopic_mz": "1129.7076",
                                "intensity": "3612.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "31",
                                "monoisotopic_mass": "1319.7165",
                                "monoisotopic_mz": "660.8655",
                                "intensity": "2986.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0067",
                                        "ppm": "5.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "32",
                                "monoisotopic_mass": "1434.7447",
                                "monoisotopic_mz": "1435.7520",
                                "intensity": "1286.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0079",
                                        "ppm": "5.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "33",
                                "monoisotopic_mass": "1617.0033",
                                "monoisotopic_mz": "809.5089",
                                "intensity": "6006.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "34",
                                "monoisotopic_mass": "5049.5269",
                                "monoisotopic_mz": "1263.3890",
                                "intensity": "10566.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "35",
                                "monoisotopic_mass": "3332.7225",
                                "monoisotopic_mz": "1111.9148",
                                "intensity": "6820.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "36",
                                "monoisotopic_mass": "876.5447",
                                "monoisotopic_mz": "877.5519",
                                "intensity": "6911.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "37",
                                "monoisotopic_mass": "1452.8977",
                                "monoisotopic_mz": "727.4561",
                                "intensity": "4484.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "38",
                                "monoisotopic_mass": "2265.4057",
                                "monoisotopic_mz": "1133.7101",
                                "intensity": "3545.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "39",
                                "monoisotopic_mass": "2454.5079",
                                "monoisotopic_mz": "819.1766",
                                "intensity": "4794.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "40",
                                "monoisotopic_mass": "891.5549",
                                "monoisotopic_mz": "892.5621",
                                "intensity": "6826.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "41",
                                "monoisotopic_mass": "3219.6269",
                                "monoisotopic_mz": "1074.2162",
                                "intensity": "10604.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "42",
                                "monoisotopic_mass": "1918.1824",
                                "monoisotopic_mz": "960.0985",
                                "intensity": "4366.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "43",
                                "monoisotopic_mass": "1350.8227",
                                "monoisotopic_mz": "451.2815",
                                "intensity": "700.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "44",
                                "monoisotopic_mass": "1486.9184",
                                "monoisotopic_mz": "744.4665",
                                "intensity": "3684.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "45",
                                "monoisotopic_mass": "607.3743",
                                "monoisotopic_mz": "608.3816",
                                "intensity": "1217.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "46",
                                "monoisotopic_mass": "2253.3932",
                                "monoisotopic_mz": "752.1384",
                                "intensity": "4781.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "47",
                                "monoisotopic_mass": "3317.7139",
                                "monoisotopic_mz": "830.4357",
                                "intensity": "2447.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "48",
                                "monoisotopic_mass": "1021.6318",
                                "monoisotopic_mz": "1022.6391",
                                "intensity": "2889.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "49",
                                "monoisotopic_mass": "2859.7791",
                                "monoisotopic_mz": "954.2670",
                                "intensity": "5187.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "50",
                                "monoisotopic_mass": "1464.9045",
                                "monoisotopic_mz": "733.4595",
                                "intensity": "2794.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "51",
                                "monoisotopic_mass": "2589.6166",
                                "monoisotopic_mz": "648.4114",
                                "intensity": "2662.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "52",
                                "monoisotopic_mass": "2708.6726",
                                "monoisotopic_mz": "678.1754",
                                "intensity": "3044.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "53",
                                "monoisotopic_mass": "4806.3980",
                                "monoisotopic_mz": "1202.6068",
                                "intensity": "7858.81",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4806.3784",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0196",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "54",
                                "monoisotopic_mass": "3212.9887",
                                "monoisotopic_mz": "804.2545",
                                "intensity": "5608.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "55",
                                "monoisotopic_mass": "2547.5659",
                                "monoisotopic_mz": "850.1959",
                                "intensity": "6954.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "56",
                                "monoisotopic_mass": "1990.2179",
                                "monoisotopic_mz": "996.1162",
                                "intensity": "4278.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "57",
                                "monoisotopic_mass": "4999.5168",
                                "monoisotopic_mz": "1000.9106",
                                "intensity": "4437.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "58",
                                "monoisotopic_mass": "2571.5784",
                                "monoisotopic_mz": "643.9019",
                                "intensity": "3778.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "59",
                                "monoisotopic_mass": "2879.4206",
                                "monoisotopic_mz": "960.8141",
                                "intensity": "5282.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2879.4063",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0143",
                                        "ppm": "4.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "60",
                                "monoisotopic_mass": "1771.0969",
                                "monoisotopic_mz": "886.5557",
                                "intensity": "5770.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "61",
                                "monoisotopic_mass": "4265.1573",
                                "monoisotopic_mz": "1422.7264",
                                "intensity": "4304.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "62",
                                "monoisotopic_mass": "2238.3805",
                                "monoisotopic_mz": "1120.1975",
                                "intensity": "3905.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "63",
                                "monoisotopic_mass": "3195.9583",
                                "monoisotopic_mz": "1066.3267",
                                "intensity": "6516.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "64",
                                "monoisotopic_mass": "3117.9319",
                                "monoisotopic_mz": "1040.3179",
                                "intensity": "7739.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "65",
                                "monoisotopic_mass": "1730.0689",
                                "monoisotopic_mz": "866.0417",
                                "intensity": "5551.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "66",
                                "monoisotopic_mass": "2212.3716",
                                "monoisotopic_mz": "554.1002",
                                "intensity": "1405.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "67",
                                "monoisotopic_mass": "3546.1815",
                                "monoisotopic_mz": "710.2436",
                                "intensity": "6360.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "68",
                                "monoisotopic_mass": "2035.2467",
                                "monoisotopic_mz": "679.4228",
                                "intensity": "3349.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "69",
                                "monoisotopic_mass": "4062.0364",
                                "monoisotopic_mz": "1016.5164",
                                "intensity": "7151.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "70",
                                "monoisotopic_mass": "4031.4917",
                                "monoisotopic_mz": "807.3056",
                                "intensity": "5421.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "71",
                                "monoisotopic_mass": "2788.7241",
                                "monoisotopic_mz": "930.5820",
                                "intensity": "7361.27",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "72",
                                "monoisotopic_mass": "1745.0824",
                                "monoisotopic_mz": "873.5485",
                                "intensity": "4916.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "73",
                                "monoisotopic_mass": "3818.3623",
                                "monoisotopic_mz": "955.5979",
                                "intensity": "7300.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "74",
                                "monoisotopic_mass": "2123.3128",
                                "monoisotopic_mz": "1062.6637",
                                "intensity": "5909.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "75",
                                "monoisotopic_mass": "1564.9644",
                                "monoisotopic_mz": "783.4895",
                                "intensity": "3274.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "76",
                                "monoisotopic_mass": "2948.8507",
                                "monoisotopic_mz": "983.9575",
                                "intensity": "4480.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "77",
                                "monoisotopic_mass": "3183.9738",
                                "monoisotopic_mz": "797.0007",
                                "intensity": "6479.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "78",
                                "monoisotopic_mass": "2071.2792",
                                "monoisotopic_mz": "1036.6469",
                                "intensity": "4644.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "79",
                                "monoisotopic_mass": "3135.9457",
                                "monoisotopic_mz": "784.9937",
                                "intensity": "4695.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "80",
                                "monoisotopic_mass": "1850.1394",
                                "monoisotopic_mz": "926.0770",
                                "intensity": "6384.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "81",
                                "monoisotopic_mass": "3633.2273",
                                "monoisotopic_mz": "909.3141",
                                "intensity": "8034.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "82",
                                "monoisotopic_mass": "4270.6349",
                                "monoisotopic_mz": "855.1343",
                                "intensity": "4339.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "83",
                                "monoisotopic_mass": "3880.3897",
                                "monoisotopic_mz": "777.0852",
                                "intensity": "8715.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "84",
                                "monoisotopic_mass": "3820.3618",
                                "monoisotopic_mz": "765.0796",
                                "intensity": "2844.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "85",
                                "monoisotopic_mass": "3359.7114",
                                "monoisotopic_mz": "1120.9111",
                                "intensity": "15899.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "86",
                                "monoisotopic_mass": "3900.4236",
                                "monoisotopic_mz": "976.1132",
                                "intensity": "8947.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "87",
                                "monoisotopic_mass": "2323.4359",
                                "monoisotopic_mz": "775.4859",
                                "intensity": "1896.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "88",
                                "monoisotopic_mass": "2059.2694",
                                "monoisotopic_mz": "687.4304",
                                "intensity": "4445.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "185",
                                "peak_id": "89",
                                "monoisotopic_mass": "2207.3603",
                                "monoisotopic_mz": "736.7941",
                                "intensity": "3087.33",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "4",
                                        "ion_display_position": "4",
                                        "spec_id": "185",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "185",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "185",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "185",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "185",
                                            "peak_id": "32",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "185",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "185",
                                        "peak_id": "59",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "185",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "185",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "185",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "185",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "185",
                                        "peak_id": "53",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "185",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "185",
                                        "peak_id": "0",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "185",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "3.17e-10",
                "e_value": "3.17e-10",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "536",
                        "ms1_scans": "610",
                        "ids": "73",
                        "scans": "611",
                        "precursor_mono_mass": "5453.8023",
                        "precursor_charge": "6",
                        "precursor_mz": "909.9743",
                        "feature_inte": "1.5997e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "73",
                                "peak_id": "0",
                                "monoisotopic_mass": "1267.6739",
                                "monoisotopic_mz": "1268.6812",
                                "intensity": "1305.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "1",
                                "monoisotopic_mass": "2711.3746",
                                "monoisotopic_mz": "904.7988",
                                "intensity": "4775.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "2",
                                "monoisotopic_mass": "1863.8949",
                                "monoisotopic_mz": "932.9547",
                                "intensity": "10955.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1863.8864",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0086",
                                        "ppm": "4.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "3",
                                "monoisotopic_mass": "1378.7785",
                                "monoisotopic_mz": "1379.7858",
                                "intensity": "3107.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "4",
                                "monoisotopic_mass": "3200.6326",
                                "monoisotopic_mz": "1067.8848",
                                "intensity": "1189.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "5",
                                "monoisotopic_mass": "1644.9644",
                                "monoisotopic_mz": "823.4895",
                                "intensity": "1422.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "6",
                                "monoisotopic_mass": "1588.7805",
                                "monoisotopic_mz": "795.3975",
                                "intensity": "1012.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "7",
                                "monoisotopic_mass": "1354.7433",
                                "monoisotopic_mz": "1355.7506",
                                "intensity": "1561.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "8",
                                "monoisotopic_mass": "1563.7868",
                                "monoisotopic_mz": "782.9007",
                                "intensity": "3948.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1563.7794",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0075",
                                        "ppm": "4.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "9",
                                "monoisotopic_mass": "1416.7192",
                                "monoisotopic_mz": "1417.7264",
                                "intensity": "966.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "10",
                                "monoisotopic_mass": "1434.7435",
                                "monoisotopic_mz": "718.3790",
                                "intensity": "19014.22",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0067",
                                        "ppm": "4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "11",
                                "monoisotopic_mass": "1456.6452",
                                "monoisotopic_mz": "1457.6525",
                                "intensity": "2435.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "12",
                                "monoisotopic_mass": "1835.9010",
                                "monoisotopic_mz": "918.9578",
                                "intensity": "3601.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "13",
                                "monoisotopic_mass": "1417.7165",
                                "monoisotopic_mz": "709.8655",
                                "intensity": "2627.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "14",
                                "monoisotopic_mass": "1117.5353",
                                "monoisotopic_mz": "1118.5426",
                                "intensity": "2448.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "15",
                                "monoisotopic_mass": "2567.3263",
                                "monoisotopic_mz": "1284.6704",
                                "intensity": "3368.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "16",
                                "monoisotopic_mass": "1479.8490",
                                "monoisotopic_mz": "740.9318",
                                "intensity": "743.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "17",
                                "monoisotopic_mass": "2539.3334",
                                "monoisotopic_mz": "1270.6740",
                                "intensity": "7930.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "18",
                                "monoisotopic_mass": "1374.6767",
                                "monoisotopic_mz": "688.3456",
                                "intensity": "1031.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "19",
                                "monoisotopic_mass": "2540.3278",
                                "monoisotopic_mz": "847.7832",
                                "intensity": "1025.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "20",
                                "monoisotopic_mass": "1089.5390",
                                "monoisotopic_mz": "1090.5463",
                                "intensity": "1528.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "21",
                                "monoisotopic_mass": "2404.2625",
                                "monoisotopic_mz": "802.4281",
                                "intensity": "1357.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "22",
                                "monoisotopic_mass": "1319.7151",
                                "monoisotopic_mz": "660.8648",
                                "intensity": "1954.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1319.7099",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "0.0052",
                                        "ppm": "3.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "23",
                                "monoisotopic_mass": "2093.0377",
                                "monoisotopic_mz": "1047.5261",
                                "intensity": "2627.68",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2093.0290",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0087",
                                        "ppm": "4.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "24",
                                "monoisotopic_mass": "1734.8518",
                                "monoisotopic_mz": "868.4332",
                                "intensity": "3715.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1734.8438",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0080",
                                        "ppm": "4.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "25",
                                "monoisotopic_mass": "3360.7119",
                                "monoisotopic_mz": "1121.2446",
                                "intensity": "5063.32",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3360.6963",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0156",
                                        "ppm": "4.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "26",
                                "monoisotopic_mass": "1395.7686",
                                "monoisotopic_mz": "1396.7759",
                                "intensity": "1356.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "27",
                                "monoisotopic_mass": "907.4736",
                                "monoisotopic_mz": "908.4808",
                                "intensity": "16289.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "28",
                                "monoisotopic_mass": "1004.4512",
                                "monoisotopic_mz": "1005.4584",
                                "intensity": "597.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "29",
                                "monoisotopic_mass": "2880.4198",
                                "monoisotopic_mz": "961.1472",
                                "intensity": "958.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "30",
                                "monoisotopic_mass": "1660.8285",
                                "monoisotopic_mz": "831.4215",
                                "intensity": "1097.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "31",
                                "monoisotopic_mass": "2266.2378",
                                "monoisotopic_mz": "1134.1262",
                                "intensity": "1928.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "32",
                                "monoisotopic_mass": "3687.9345",
                                "monoisotopic_mz": "922.9909",
                                "intensity": "2301.75",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3687.9234",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0111",
                                        "ppm": "3.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "33",
                                "monoisotopic_mass": "2291.2862",
                                "monoisotopic_mz": "1146.6504",
                                "intensity": "4972.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "34",
                                "monoisotopic_mass": "1920.9220",
                                "monoisotopic_mz": "961.4683",
                                "intensity": "1357.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "35",
                                "monoisotopic_mass": "3488.8173",
                                "monoisotopic_mz": "1163.9464",
                                "intensity": "4196.08",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.7913",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "B00031",
                                            "ion_left_position": "31",
                                            "mass_error": "0.0260",
                                            "ppm": "7.44"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3488.8450",
                                            "ion_position": "17",
                                            "ion_display_position": "31",
                                            "ion_sort_name": "Y00031",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0277",
                                            "ppm": "-7.94"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "36",
                                "monoisotopic_mass": "1192.6510",
                                "monoisotopic_mz": "597.3328",
                                "intensity": "1874.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "37",
                                "monoisotopic_mass": "1024.5733",
                                "monoisotopic_mz": "1025.5806",
                                "intensity": "1129.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "38",
                                "monoisotopic_mass": "1677.8298",
                                "monoisotopic_mz": "839.9222",
                                "intensity": "2499.26",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1677.8223",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0075",
                                        "ppm": "4.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "39",
                                "monoisotopic_mass": "1291.7195",
                                "monoisotopic_mz": "646.8670",
                                "intensity": "1879.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "40",
                                "monoisotopic_mass": "756.3345",
                                "monoisotopic_mz": "757.3418",
                                "intensity": "1430.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "41",
                                "monoisotopic_mass": "1039.5716",
                                "monoisotopic_mz": "520.7931",
                                "intensity": "539.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "42",
                                "monoisotopic_mass": "1341.6185",
                                "monoisotopic_mz": "1342.6257",
                                "intensity": "1062.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "43",
                                "monoisotopic_mass": "1307.6490",
                                "monoisotopic_mz": "654.8318",
                                "intensity": "635.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "44",
                                "monoisotopic_mass": "585.3989",
                                "monoisotopic_mz": "586.4061",
                                "intensity": "557.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "45",
                                "monoisotopic_mass": "1241.6574",
                                "monoisotopic_mz": "1242.6647",
                                "intensity": "3950.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "46",
                                "monoisotopic_mass": "375.1805",
                                "monoisotopic_mz": "376.1878",
                                "intensity": "852.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "47",
                                "monoisotopic_mass": "2046.0939",
                                "monoisotopic_mz": "1024.0542",
                                "intensity": "728.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "48",
                                "monoisotopic_mass": "3247.6321",
                                "monoisotopic_mz": "1083.5513",
                                "intensity": "5272.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3247.6123",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0199",
                                        "ppm": "6.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "49",
                                "monoisotopic_mass": "2714.3666",
                                "monoisotopic_mz": "1358.1906",
                                "intensity": "476.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "50",
                                "monoisotopic_mass": "3148.5412",
                                "monoisotopic_mz": "788.1426",
                                "intensity": "1262.20",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3148.5439",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0026",
                                        "ppm": "-0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "51",
                                "monoisotopic_mass": "4191.1206",
                                "monoisotopic_mz": "1048.7874",
                                "intensity": "1294.43",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4191.0920",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0286",
                                        "ppm": "6.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "52",
                                "monoisotopic_mass": "1801.9294",
                                "monoisotopic_mz": "901.9720",
                                "intensity": "1023.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "53",
                                "monoisotopic_mass": "3332.7159",
                                "monoisotopic_mz": "1111.9126",
                                "intensity": "2081.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "54",
                                "monoisotopic_mass": "2404.2657",
                                "monoisotopic_mz": "1203.1401",
                                "intensity": "2520.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "55",
                                "monoisotopic_mass": "2973.5206",
                                "monoisotopic_mz": "1487.7676",
                                "intensity": "1294.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "56",
                                "monoisotopic_mass": "3218.6308",
                                "monoisotopic_mz": "1073.8842",
                                "intensity": "3735.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "57",
                                "monoisotopic_mass": "2351.2260",
                                "monoisotopic_mz": "1176.6203",
                                "intensity": "504.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "58",
                                "monoisotopic_mass": "1958.9872",
                                "monoisotopic_mz": "980.5009",
                                "intensity": "472.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "59",
                                "monoisotopic_mass": "2728.4032",
                                "monoisotopic_mz": "910.4750",
                                "intensity": "6648.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "60",
                                "monoisotopic_mass": "2077.0187",
                                "monoisotopic_mz": "1039.5166",
                                "intensity": "711.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "61",
                                "monoisotopic_mass": "3147.5565",
                                "monoisotopic_mz": "1050.1928",
                                "intensity": "3375.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "62",
                                "monoisotopic_mass": "2165.1888",
                                "monoisotopic_mz": "1083.6017",
                                "intensity": "1862.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "63",
                                "monoisotopic_mass": "2222.1447",
                                "monoisotopic_mz": "1112.0796",
                                "intensity": "971.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "64",
                                "monoisotopic_mass": "4410.2155",
                                "monoisotopic_mz": "1103.5612",
                                "intensity": "533.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "65",
                                "monoisotopic_mass": "2194.0881",
                                "monoisotopic_mz": "732.3700",
                                "intensity": "1973.16",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2194.0767",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0114",
                                        "ppm": "5.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "66",
                                "monoisotopic_mass": "2239.1502",
                                "monoisotopic_mz": "1120.5824",
                                "intensity": "1477.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "67",
                                "monoisotopic_mass": "3634.8756",
                                "monoisotopic_mz": "909.7262",
                                "intensity": "2660.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "68",
                                "monoisotopic_mass": "2478.4199",
                                "monoisotopic_mz": "1240.2172",
                                "intensity": "796.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "69",
                                "monoisotopic_mass": "4247.1363",
                                "monoisotopic_mz": "1062.7913",
                                "intensity": "1600.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "70",
                                "monoisotopic_mass": "3619.0437",
                                "monoisotopic_mz": "905.7682",
                                "intensity": "511.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "71",
                                "monoisotopic_mass": "2375.2627",
                                "monoisotopic_mz": "1188.6386",
                                "intensity": "1578.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "72",
                                "monoisotopic_mass": "1935.9453",
                                "monoisotopic_mz": "968.9799",
                                "intensity": "2781.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "73",
                                "peak_id": "73",
                                "monoisotopic_mass": "2022.0347",
                                "monoisotopic_mz": "1012.0246",
                                "intensity": "642.05",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "73",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "73",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "73",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "73",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "73",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "73",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "31",
                                        "spec_id": "73",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "73",
                                        "peak_id": "23",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "73",
                                        "peak_id": "65",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "73",
                                        "peak_id": "50",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "73",
                                        "peak_id": "48",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "73",
                                        "peak_id": "25",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "73",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "73",
                                        "peak_id": "32",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "73",
                                        "peak_id": "51",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "22",
                "p_value": "5.98e-06",
                "e_value": "5.98e-06",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "527",
                        "ms1_scans": "576",
                        "ids": "50",
                        "scans": "579",
                        "precursor_mono_mass": "5453.8023",
                        "precursor_charge": "5",
                        "precursor_mz": "1091.7677",
                        "feature_inte": "1.5997e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "50",
                                "peak_id": "0",
                                "monoisotopic_mass": "3233.6736",
                                "monoisotopic_mz": "1078.8985",
                                "intensity": "3207.72",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "1",
                                "monoisotopic_mass": "1783.0124",
                                "monoisotopic_mz": "892.5135",
                                "intensity": "460.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "2",
                                "monoisotopic_mass": "1434.7446",
                                "monoisotopic_mz": "718.3796",
                                "intensity": "6062.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1434.7368",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0078",
                                        "ppm": "5.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "3",
                                "monoisotopic_mass": "1006.6345",
                                "monoisotopic_mz": "1007.6418",
                                "intensity": "1062.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "4",
                                "monoisotopic_mass": "1020.5234",
                                "monoisotopic_mz": "1021.5307",
                                "intensity": "605.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "5",
                                "monoisotopic_mass": "1702.9011",
                                "monoisotopic_mz": "852.4578",
                                "intensity": "1710.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "6",
                                "monoisotopic_mass": "3250.6819",
                                "monoisotopic_mz": "1084.5679",
                                "intensity": "10031.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "7",
                                "monoisotopic_mass": "669.4206",
                                "monoisotopic_mz": "670.4279",
                                "intensity": "1420.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "8",
                                "monoisotopic_mass": "706.3794",
                                "monoisotopic_mz": "707.3867",
                                "intensity": "1268.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "9",
                                "monoisotopic_mass": "621.3628",
                                "monoisotopic_mz": "622.3701",
                                "intensity": "826.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "10",
                                "monoisotopic_mass": "5065.5445",
                                "monoisotopic_mz": "1267.3934",
                                "intensity": "2848.54",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5066.5309",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0160",
                                        "ppm": "3.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "11",
                                "monoisotopic_mass": "3208.6614",
                                "monoisotopic_mz": "1070.5611",
                                "intensity": "2228.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "12",
                                "monoisotopic_mass": "577.2344",
                                "monoisotopic_mz": "578.2417",
                                "intensity": "1477.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "13",
                                "monoisotopic_mass": "837.4212",
                                "monoisotopic_mz": "838.4285",
                                "intensity": "1097.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "14",
                                "monoisotopic_mass": "1301.7282",
                                "monoisotopic_mz": "651.8714",
                                "intensity": "548.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "15",
                                "monoisotopic_mass": "3616.9032",
                                "monoisotopic_mz": "1206.6417",
                                "intensity": "1573.76",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3616.8863",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0169",
                                        "ppm": "4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "16",
                                "monoisotopic_mass": "1129.5773",
                                "monoisotopic_mz": "1130.5846",
                                "intensity": "487.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "17",
                                "monoisotopic_mass": "2631.4493",
                                "monoisotopic_mz": "878.1570",
                                "intensity": "1577.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "18",
                                "monoisotopic_mass": "1922.0309",
                                "monoisotopic_mz": "962.0227",
                                "intensity": "464.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "19",
                                "monoisotopic_mass": "4376.2314",
                                "monoisotopic_mz": "1095.0651",
                                "intensity": "1646.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4376.2084",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0230",
                                        "ppm": "5.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "20",
                                "monoisotopic_mass": "2162.0880",
                                "monoisotopic_mz": "1082.0513",
                                "intensity": "2635.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "21",
                                "monoisotopic_mass": "3268.7006",
                                "monoisotopic_mz": "1090.5741",
                                "intensity": "10653.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "22",
                                "monoisotopic_mass": "1297.6672",
                                "monoisotopic_mz": "1298.6744",
                                "intensity": "287.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "23",
                                "monoisotopic_mass": "978.6385",
                                "monoisotopic_mz": "979.6458",
                                "intensity": "764.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "24",
                                "monoisotopic_mass": "1255.7573",
                                "monoisotopic_mz": "628.8859",
                                "intensity": "267.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "25",
                                "monoisotopic_mass": "1803.7700",
                                "monoisotopic_mz": "902.8923",
                                "intensity": "436.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "26",
                                "monoisotopic_mass": "2467.7255",
                                "monoisotopic_mz": "1234.8700",
                                "intensity": "1155.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "27",
                                "monoisotopic_mass": "902.3851",
                                "monoisotopic_mz": "903.3924",
                                "intensity": "328.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "28",
                                "monoisotopic_mass": "2080.0435",
                                "monoisotopic_mz": "1041.0290",
                                "intensity": "812.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "29",
                                "monoisotopic_mass": "3360.7196",
                                "monoisotopic_mz": "1121.2471",
                                "intensity": "1608.43",
                                "charge": "3",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.6963",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "B00030",
                                            "ion_left_position": "30",
                                            "mass_error": "0.0233",
                                            "ppm": "6.92"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "3360.7500",
                                            "ion_position": "18",
                                            "ion_display_position": "30",
                                            "ion_sort_name": "Y00030",
                                            "ion_left_position": "18",
                                            "mass_error": "-0.0304",
                                            "ppm": "-9.05"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "30",
                                "monoisotopic_mass": "3686.9479",
                                "monoisotopic_mz": "922.7442",
                                "intensity": "1615.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "31",
                                "monoisotopic_mass": "1981.8964",
                                "monoisotopic_mz": "991.9555",
                                "intensity": "529.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "32",
                                "monoisotopic_mass": "3487.8039",
                                "monoisotopic_mz": "1163.6086",
                                "intensity": "2565.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "33",
                                "monoisotopic_mass": "1054.5395",
                                "monoisotopic_mz": "1055.5468",
                                "intensity": "737.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "34",
                                "monoisotopic_mass": "4360.2003",
                                "monoisotopic_mz": "1091.0573",
                                "intensity": "6280.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "35",
                                "monoisotopic_mass": "1262.6949",
                                "monoisotopic_mz": "1263.7021",
                                "intensity": "293.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1262.6871",
                                        "ion_position": "37",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0078",
                                        "ppm": "6.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "36",
                                "monoisotopic_mass": "1862.8953",
                                "monoisotopic_mz": "932.4549",
                                "intensity": "1648.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "37",
                                "monoisotopic_mass": "1073.2122",
                                "monoisotopic_mz": "1074.2195",
                                "intensity": "312.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "38",
                                "monoisotopic_mass": "1238.6227",
                                "monoisotopic_mz": "1239.6300",
                                "intensity": "818.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "39",
                                "monoisotopic_mass": "1090.0539",
                                "monoisotopic_mz": "1091.0612",
                                "intensity": "7148.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "50",
                                "peak_id": "40",
                                "monoisotopic_mass": "960.5143",
                                "monoisotopic_mz": "961.5215",
                                "intensity": "239.92",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "13",
                    "proteoform_id": "14",
                    "sequence_name": "sp|P0ACF8|HNS_ECOLI",
                    "sequence_description": "DNA-binding protein H-NS OS=Escherichia coli (strain K12) OX=83333 GN=hns PE=1 SV=2",
                    "proteoform_mass": "5453.7790",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "137",
                        "first_residue_position": "89",
                        "last_residue_position": "136",
                        "annotated_seq": "K.RAQRPAKYSYVDENGETKTWTGQGRTPAVIKKAMDEQGKSLDDFLIKQ.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "E"
                            },
                            {
                                "position": "3",
                                "acid": "A"
                            },
                            {
                                "position": "4",
                                "acid": "L"
                            },
                            {
                                "position": "5",
                                "acid": "K"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "N"
                            },
                            {
                                "position": "9",
                                "acid": "N"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "R"
                            },
                            {
                                "position": "12",
                                "acid": "T"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "R"
                            },
                            {
                                "position": "15",
                                "acid": "A"
                            },
                            {
                                "position": "16",
                                "acid": "Q"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "E"
                            },
                            {
                                "position": "20",
                                "acid": "C"
                            },
                            {
                                "position": "21",
                                "acid": "T"
                            },
                            {
                                "position": "22",
                                "acid": "L"
                            },
                            {
                                "position": "23",
                                "acid": "E"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "L"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "M"
                            },
                            {
                                "position": "29",
                                "acid": "L"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "K"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "V"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "N"
                            },
                            {
                                "position": "38",
                                "acid": "E"
                            },
                            {
                                "position": "39",
                                "acid": "R"
                            },
                            {
                                "position": "40",
                                "acid": "R"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "E"
                            },
                            {
                                "position": "43",
                                "acid": "E"
                            },
                            {
                                "position": "44",
                                "acid": "S"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "E"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "R"
                            },
                            {
                                "position": "54",
                                "acid": "T"
                            },
                            {
                                "position": "55",
                                "acid": "R"
                            },
                            {
                                "position": "56",
                                "acid": "K"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "Q"
                            },
                            {
                                "position": "59",
                                "acid": "Q"
                            },
                            {
                                "position": "60",
                                "acid": "Y"
                            },
                            {
                                "position": "61",
                                "acid": "R"
                            },
                            {
                                "position": "62",
                                "acid": "E"
                            },
                            {
                                "position": "63",
                                "acid": "M"
                            },
                            {
                                "position": "64",
                                "acid": "L"
                            },
                            {
                                "position": "65",
                                "acid": "I"
                            },
                            {
                                "position": "66",
                                "acid": "A"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "G"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "P"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "L"
                            },
                            {
                                "position": "75",
                                "acid": "L"
                            },
                            {
                                "position": "76",
                                "acid": "N"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "A"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "V"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "S"
                            },
                            {
                                "position": "84",
                                "acid": "G"
                            },
                            {
                                "position": "85",
                                "acid": "T"
                            },
                            {
                                "position": "86",
                                "acid": "K"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "R"
                            },
                            {
                                "position": "90",
                                "acid": "A"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "R"
                            },
                            {
                                "position": "93",
                                "acid": "P"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "Y"
                            },
                            {
                                "position": "97",
                                "acid": "S"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "V"
                            },
                            {
                                "position": "100",
                                "acid": "D"
                            },
                            {
                                "position": "101",
                                "acid": "E"
                            },
                            {
                                "position": "102",
                                "acid": "N"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "E"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "K"
                            },
                            {
                                "position": "107",
                                "acid": "T"
                            },
                            {
                                "position": "108",
                                "acid": "W"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "Q"
                            },
                            {
                                "position": "112",
                                "acid": "G"
                            },
                            {
                                "position": "113",
                                "acid": "R"
                            },
                            {
                                "position": "114",
                                "acid": "T"
                            },
                            {
                                "position": "115",
                                "acid": "P"
                            },
                            {
                                "position": "116",
                                "acid": "A"
                            },
                            {
                                "position": "117",
                                "acid": "V"
                            },
                            {
                                "position": "118",
                                "acid": "I"
                            },
                            {
                                "position": "119",
                                "acid": "K"
                            },
                            {
                                "position": "120",
                                "acid": "K"
                            },
                            {
                                "position": "121",
                                "acid": "A"
                            },
                            {
                                "position": "122",
                                "acid": "M"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "E"
                            },
                            {
                                "position": "125",
                                "acid": "Q"
                            },
                            {
                                "position": "126",
                                "acid": "G"
                            },
                            {
                                "position": "127",
                                "acid": "K"
                            },
                            {
                                "position": "128",
                                "acid": "S"
                            },
                            {
                                "position": "129",
                                "acid": "L"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "F"
                            },
                            {
                                "position": "133",
                                "acid": "L"
                            },
                            {
                                "position": "134",
                                "acid": "I"
                            },
                            {
                                "position": "135",
                                "acid": "K"
                            },
                            {
                                "position": "136",
                                "acid": "Q"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "50",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "18",
                                        "ion_display_position": "30",
                                        "spec_id": "50",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "50",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "50",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "11",
                                        "spec_id": "50",
                                        "peak_id": "35",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "50",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "50",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
