prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "11",
        "sequence_name": "sp|P37903|USPF_ECOLI",
        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
        "proteoform_id": "12",
        "prsm_number": "4",
        "prsm": [
            {
                "prsm_id": "134",
                "p_value": "2.29e-23",
                "e_value": "2.29e-23",
                "fdr": "0",
                "matched_fragment_number": "35",
                "matched_peak_number": "37",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "613",
                        "ms1_scans": "916",
                        "ids": "302",
                        "scans": "917",
                        "precursor_mono_mass": "16311.5248",
                        "precursor_charge": "8",
                        "precursor_mz": "2039.9479",
                        "feature_inte": "4.0888e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "302",
                                "peak_id": "0",
                                "monoisotopic_mass": "1152.6386",
                                "monoisotopic_mz": "1153.6459",
                                "intensity": "21596.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.6325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0061",
                                        "ppm": "5.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "1",
                                "monoisotopic_mass": "1416.6541",
                                "monoisotopic_mz": "1417.6614",
                                "intensity": "2108.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "2",
                                "monoisotopic_mass": "1467.7842",
                                "monoisotopic_mz": "1468.7915",
                                "intensity": "18127.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1467.7756",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0087",
                                        "ppm": "5.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "3",
                                "monoisotopic_mass": "3646.8715",
                                "monoisotopic_mz": "1824.4430",
                                "intensity": "14290.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3646.8512",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0203",
                                        "ppm": "5.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "4",
                                "monoisotopic_mass": "827.4729",
                                "monoisotopic_mz": "828.4802",
                                "intensity": "4414.04",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "827.4687",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0041",
                                        "ppm": "5.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "5",
                                "monoisotopic_mass": "3531.8349",
                                "monoisotopic_mz": "1766.9247",
                                "intensity": "11968.90",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3531.8243",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0106",
                                        "ppm": "3.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "6",
                                "monoisotopic_mass": "4426.2701",
                                "monoisotopic_mz": "1476.4306",
                                "intensity": "7149.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "7",
                                "monoisotopic_mass": "3846.9525",
                                "monoisotopic_mz": "1924.4836",
                                "intensity": "4160.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3846.9309",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0216",
                                        "ppm": "5.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "8",
                                "monoisotopic_mass": "4203.1548",
                                "monoisotopic_mz": "1402.0589",
                                "intensity": "2508.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "9",
                                "monoisotopic_mass": "5320.9467",
                                "monoisotopic_mz": "1331.2439",
                                "intensity": "3178.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "10",
                                "monoisotopic_mass": "3158.6065",
                                "monoisotopic_mz": "1580.3105",
                                "intensity": "4824.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "11",
                                "monoisotopic_mass": "4525.3408",
                                "monoisotopic_mz": "1509.4542",
                                "intensity": "6106.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "12",
                                "monoisotopic_mass": "4083.0739",
                                "monoisotopic_mz": "1362.0319",
                                "intensity": "3925.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4083.0583",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0156",
                                        "ppm": "3.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "13",
                                "monoisotopic_mass": "5449.9946",
                                "monoisotopic_mz": "1363.5059",
                                "intensity": "11682.82",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "5449.0030",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "97",
                                        "mass_error": "-0.0108",
                                        "ppm": "-1.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "14",
                                "monoisotopic_mass": "4230.1416",
                                "monoisotopic_mz": "1411.0545",
                                "intensity": "4777.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4230.1267",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0150",
                                        "ppm": "3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "15",
                                "monoisotopic_mass": "4543.3561",
                                "monoisotopic_mz": "1515.4593",
                                "intensity": "8522.94",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4543.3268",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0293",
                                        "ppm": "6.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "16",
                                "monoisotopic_mass": "935.4789",
                                "monoisotopic_mz": "936.4861",
                                "intensity": "730.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "17",
                                "monoisotopic_mass": "970.4471",
                                "monoisotopic_mz": "971.4544",
                                "intensity": "921.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "18",
                                "monoisotopic_mass": "2717.4782",
                                "monoisotopic_mz": "1359.7464",
                                "intensity": "3149.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2717.4534",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "0.0247",
                                        "ppm": "9.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "19",
                                "monoisotopic_mass": "950.4709",
                                "monoisotopic_mz": "951.4781",
                                "intensity": "632.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "20",
                                "monoisotopic_mass": "2846.5131",
                                "monoisotopic_mz": "1424.2638",
                                "intensity": "4347.74",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2846.4960",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0171",
                                        "ppm": "5.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "21",
                                "monoisotopic_mass": "770.3650",
                                "monoisotopic_mz": "771.3723",
                                "intensity": "1336.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "22",
                                "monoisotopic_mass": "8817.8625",
                                "monoisotopic_mz": "1764.5798",
                                "intensity": "3528.57",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "8816.8282",
                                        "ion_position": "68",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "Y00076",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0319",
                                        "ppm": "3.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "23",
                                "monoisotopic_mass": "2946.5184",
                                "monoisotopic_mz": "1474.2665",
                                "intensity": "9391.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "24",
                                "monoisotopic_mass": "671.4355",
                                "monoisotopic_mz": "672.4428",
                                "intensity": "834.76",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "671.4330",
                                        "ion_position": "138",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "138",
                                        "mass_error": "0.0025",
                                        "ppm": "3.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "25",
                                "monoisotopic_mass": "2063.0585",
                                "monoisotopic_mz": "2064.0658",
                                "intensity": "1587.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "26",
                                "monoisotopic_mass": "696.3629",
                                "monoisotopic_mz": "697.3702",
                                "intensity": "832.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "27",
                                "monoisotopic_mass": "2673.4210",
                                "monoisotopic_mz": "1337.7178",
                                "intensity": "3924.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "28",
                                "monoisotopic_mass": "4499.3318",
                                "monoisotopic_mz": "1500.7845",
                                "intensity": "2102.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "29",
                                "monoisotopic_mass": "529.1862",
                                "monoisotopic_mz": "530.1935",
                                "intensity": "937.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "30",
                                "monoisotopic_mass": "2030.4871",
                                "monoisotopic_mz": "2031.4943",
                                "intensity": "1710.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "31",
                                "monoisotopic_mass": "494.2185",
                                "monoisotopic_mz": "495.2257",
                                "intensity": "1283.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "32",
                                "monoisotopic_mass": "5176.9068",
                                "monoisotopic_mz": "1295.2340",
                                "intensity": "4962.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "33",
                                "monoisotopic_mass": "5934.2137",
                                "monoisotopic_mz": "1484.5607",
                                "intensity": "4996.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "5933.2312",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "92",
                                        "mass_error": "-0.0198",
                                        "ppm": "-3.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "34",
                                "monoisotopic_mass": "728.4039",
                                "monoisotopic_mz": "729.4112",
                                "intensity": "1593.52",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "728.4003",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0036",
                                        "ppm": "4.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "35",
                                "monoisotopic_mass": "2975.5624",
                                "monoisotopic_mz": "1488.7885",
                                "intensity": "2563.83",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2975.5386",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0238",
                                        "ppm": "7.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "36",
                                "monoisotopic_mass": "3515.8269",
                                "monoisotopic_mz": "1758.9207",
                                "intensity": "1811.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "37",
                                "monoisotopic_mass": "4444.2759",
                                "monoisotopic_mz": "1482.4326",
                                "intensity": "3933.63",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4444.2584",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0175",
                                        "ppm": "3.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "38",
                                "monoisotopic_mass": "3829.9450",
                                "monoisotopic_mz": "1915.9798",
                                "intensity": "1520.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "39",
                                "monoisotopic_mass": "1935.8395",
                                "monoisotopic_mz": "1936.8467",
                                "intensity": "1505.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "40",
                                "monoisotopic_mass": "2783.5158",
                                "monoisotopic_mz": "1392.7652",
                                "intensity": "1061.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "41",
                                "monoisotopic_mass": "1230.5888",
                                "monoisotopic_mz": "1231.5961",
                                "intensity": "632.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "42",
                                "monoisotopic_mass": "1697.4188",
                                "monoisotopic_mz": "1698.4260",
                                "intensity": "1029.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "43",
                                "monoisotopic_mass": "1714.6325",
                                "monoisotopic_mz": "1715.6398",
                                "intensity": "1403.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "44",
                                "monoisotopic_mass": "878.4696",
                                "monoisotopic_mz": "879.4769",
                                "intensity": "740.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "45",
                                "monoisotopic_mass": "423.1811",
                                "monoisotopic_mz": "424.1883",
                                "intensity": "1981.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "46",
                                "monoisotopic_mass": "2006.8735",
                                "monoisotopic_mz": "2007.8808",
                                "intensity": "1054.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "47",
                                "monoisotopic_mass": "2817.4689",
                                "monoisotopic_mz": "1409.7417",
                                "intensity": "2944.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "48",
                                "monoisotopic_mass": "6901.7307",
                                "monoisotopic_mz": "1726.4400",
                                "intensity": "4868.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "49",
                                "monoisotopic_mass": "710.4146",
                                "monoisotopic_mz": "711.4219",
                                "intensity": "664.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "50",
                                "monoisotopic_mass": "3304.7276",
                                "monoisotopic_mz": "1653.3711",
                                "intensity": "2513.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "51",
                                "monoisotopic_mass": "1251.7360",
                                "monoisotopic_mz": "1252.7433",
                                "intensity": "1397.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "52",
                                "monoisotopic_mass": "4656.4091",
                                "monoisotopic_mz": "1553.1436",
                                "intensity": "8335.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "53",
                                "monoisotopic_mass": "1859.0109",
                                "monoisotopic_mz": "1860.0182",
                                "intensity": "1214.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "54",
                                "monoisotopic_mass": "3881.7150",
                                "monoisotopic_mz": "1941.8648",
                                "intensity": "2232.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "55",
                                "monoisotopic_mass": "4628.4420",
                                "monoisotopic_mz": "1543.8213",
                                "intensity": "2092.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "56",
                                "monoisotopic_mass": "4938.6807",
                                "monoisotopic_mz": "1647.2342",
                                "intensity": "3919.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "57",
                                "monoisotopic_mass": "2394.3021",
                                "monoisotopic_mz": "1198.1583",
                                "intensity": "2032.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2394.2941",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0081",
                                        "ppm": "3.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "58",
                                "monoisotopic_mass": "1009.5663",
                                "monoisotopic_mz": "1010.5735",
                                "intensity": "1258.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "59",
                                "monoisotopic_mass": "3175.6332",
                                "monoisotopic_mz": "1588.8239",
                                "intensity": "1957.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3175.6183",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0149",
                                        "ppm": "4.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "60",
                                "monoisotopic_mass": "1384.9459",
                                "monoisotopic_mz": "1385.9531",
                                "intensity": "958.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "61",
                                "monoisotopic_mass": "6063.2454",
                                "monoisotopic_mz": "1516.8186",
                                "intensity": "2638.64",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "6062.2738",
                                        "ion_position": "91",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "91",
                                        "mass_error": "-0.0307",
                                        "ppm": "-5.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "62",
                                "monoisotopic_mass": "4384.2707",
                                "monoisotopic_mz": "1462.4308",
                                "intensity": "3231.80",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "4384.2960",
                                        "ion_position": "106",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "106",
                                        "mass_error": "-0.0253",
                                        "ppm": "-5.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "63",
                                "monoisotopic_mass": "1124.5923",
                                "monoisotopic_mz": "1125.5996",
                                "intensity": "826.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "64",
                                "monoisotopic_mass": "2831.0653",
                                "monoisotopic_mz": "1416.5399",
                                "intensity": "2151.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "65",
                                "monoisotopic_mass": "6646.6340",
                                "monoisotopic_mz": "1662.6658",
                                "intensity": "4979.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "66",
                                "monoisotopic_mass": "1079.5163",
                                "monoisotopic_mz": "1080.5236",
                                "intensity": "1547.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "67",
                                "monoisotopic_mass": "4926.5809",
                                "monoisotopic_mz": "2464.2977",
                                "intensity": "3264.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "68",
                                "monoisotopic_mass": "2885.5048",
                                "monoisotopic_mz": "1443.7597",
                                "intensity": "3490.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "69",
                                "monoisotopic_mass": "5917.1981",
                                "monoisotopic_mz": "1480.3068",
                                "intensity": "1553.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "70",
                                "monoisotopic_mass": "9823.2830",
                                "monoisotopic_mz": "1965.6639",
                                "intensity": "6117.59",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "71",
                                "monoisotopic_mass": "2938.5634",
                                "monoisotopic_mz": "2939.5707",
                                "intensity": "825.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "72",
                                "monoisotopic_mass": "9585.2343",
                                "monoisotopic_mz": "1918.0541",
                                "intensity": "7394.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "73",
                                "monoisotopic_mass": "3946.0096",
                                "monoisotopic_mz": "1316.3438",
                                "intensity": "709.85",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3945.9994",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0102",
                                        "ppm": "2.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "74",
                                "monoisotopic_mass": "9427.1314",
                                "monoisotopic_mz": "1886.4336",
                                "intensity": "4507.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "75",
                                "monoisotopic_mass": "9329.1218",
                                "monoisotopic_mz": "1866.8316",
                                "intensity": "8326.91",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "9329.1241",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "63",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "76",
                                "monoisotopic_mass": "6918.7435",
                                "monoisotopic_mz": "1384.7560",
                                "intensity": "3529.02",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "6918.7405",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "84",
                                        "mass_error": "0.0030",
                                        "ppm": "0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "77",
                                "monoisotopic_mass": "1683.8611",
                                "monoisotopic_mz": "1684.8684",
                                "intensity": "1465.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1683.8502",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0110",
                                        "ppm": "6.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "78",
                                "monoisotopic_mass": "9671.2355",
                                "monoisotopic_mz": "1935.2544",
                                "intensity": "4803.93",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "79",
                                "monoisotopic_mass": "9445.1524",
                                "monoisotopic_mz": "1890.0378",
                                "intensity": "4916.29",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "9444.1510",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "Y00082",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "80",
                                "monoisotopic_mass": "1283.3189",
                                "monoisotopic_mz": "1284.3262",
                                "intensity": "621.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "81",
                                "monoisotopic_mass": "1778.3755",
                                "monoisotopic_mz": "1779.3828",
                                "intensity": "2772.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "82",
                                "monoisotopic_mass": "9313.1190",
                                "monoisotopic_mz": "1863.6311",
                                "intensity": "7001.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "83",
                                "monoisotopic_mass": "3628.8568",
                                "monoisotopic_mz": "1815.4357",
                                "intensity": "2609.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "84",
                                "monoisotopic_mass": "5432.9757",
                                "monoisotopic_mz": "1811.9992",
                                "intensity": "3125.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "85",
                                "monoisotopic_mass": "4628.4287",
                                "monoisotopic_mz": "2315.2216",
                                "intensity": "6276.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "86",
                                "monoisotopic_mass": "5823.5751",
                                "monoisotopic_mz": "1942.1990",
                                "intensity": "769.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "87",
                                "monoisotopic_mass": "1818.0003",
                                "monoisotopic_mz": "1819.0076",
                                "intensity": "3324.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "88",
                                "monoisotopic_mass": "4343.2389",
                                "monoisotopic_mz": "1448.7536",
                                "intensity": "4890.75",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4343.2108",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0282",
                                        "ppm": "6.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "89",
                                "monoisotopic_mass": "10388.5145",
                                "monoisotopic_mz": "2078.7102",
                                "intensity": "2155.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "90",
                                "monoisotopic_mass": "9569.2080",
                                "monoisotopic_mz": "1914.8489",
                                "intensity": "7090.59",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "91",
                                "monoisotopic_mass": "8059.3962",
                                "monoisotopic_mz": "2015.8563",
                                "intensity": "746.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "92",
                                "monoisotopic_mass": "8687.7567",
                                "monoisotopic_mz": "1738.5586",
                                "intensity": "2961.94",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "8688.7333",
                                        "ion_position": "69",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "Y00075",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0258",
                                        "ppm": "2.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "93",
                                "monoisotopic_mass": "9729.2815",
                                "monoisotopic_mz": "1946.8636",
                                "intensity": "5875.89",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "94",
                                "monoisotopic_mass": "4409.2347",
                                "monoisotopic_mz": "1470.7522",
                                "intensity": "2435.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "95",
                                "monoisotopic_mass": "9858.3124",
                                "monoisotopic_mz": "1972.6698",
                                "intensity": "14118.18",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "9858.3083",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "ion_sort_name": "Y00086",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0041",
                                        "ppm": "0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "96",
                                "monoisotopic_mass": "9172.0335",
                                "monoisotopic_mz": "1835.4140",
                                "intensity": "2808.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "97",
                                "monoisotopic_mass": "1911.8278",
                                "monoisotopic_mz": "1912.8351",
                                "intensity": "1146.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "98",
                                "monoisotopic_mass": "4055.0815",
                                "monoisotopic_mz": "1352.7011",
                                "intensity": "1766.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "99",
                                "monoisotopic_mass": "4369.2441",
                                "monoisotopic_mz": "2185.6293",
                                "intensity": "1171.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "100",
                                "monoisotopic_mass": "5109.9373",
                                "monoisotopic_mz": "1704.3197",
                                "intensity": "1721.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "101",
                                "monoisotopic_mass": "3317.8059",
                                "monoisotopic_mz": "1659.9102",
                                "intensity": "1123.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "102",
                                "monoisotopic_mass": "2179.0809",
                                "monoisotopic_mz": "2180.0882",
                                "intensity": "1617.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "103",
                                "monoisotopic_mass": "1844.0098",
                                "monoisotopic_mz": "1845.0171",
                                "intensity": "1510.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "104",
                                "monoisotopic_mass": "13157.2149",
                                "monoisotopic_mz": "1645.6591",
                                "intensity": "694.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "105",
                                "monoisotopic_mass": "8613.7820",
                                "monoisotopic_mz": "1723.7637",
                                "intensity": "943.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "106",
                                "monoisotopic_mass": "1991.8732",
                                "monoisotopic_mz": "1992.8804",
                                "intensity": "1924.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "107",
                                "monoisotopic_mass": "6919.7341",
                                "monoisotopic_mz": "1730.9408",
                                "intensity": "4862.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "6918.7405",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "84",
                                        "mass_error": "-0.0087",
                                        "ppm": "-1.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "108",
                                "monoisotopic_mass": "4075.1348",
                                "monoisotopic_mz": "2038.5747",
                                "intensity": "1726.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "109",
                                "monoisotopic_mass": "4656.4048",
                                "monoisotopic_mz": "2329.2097",
                                "intensity": "9157.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0061",
                                        "ppm": "-1.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "110",
                                "monoisotopic_mass": "11365.0815",
                                "monoisotopic_mz": "2274.0236",
                                "intensity": "4684.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "111",
                                "monoisotopic_mass": "9862.3412",
                                "monoisotopic_mz": "1644.7308",
                                "intensity": "2768.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "112",
                                "monoisotopic_mass": "4315.2329",
                                "monoisotopic_mz": "1439.4182",
                                "intensity": "1130.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "113",
                                "monoisotopic_mass": "4525.3139",
                                "monoisotopic_mz": "2263.6642",
                                "intensity": "2317.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "114",
                                "monoisotopic_mass": "9686.2708",
                                "monoisotopic_mz": "1938.2614",
                                "intensity": "1715.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "115",
                                "monoisotopic_mass": "9951.4209",
                                "monoisotopic_mz": "1991.2915",
                                "intensity": "2377.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "116",
                                "monoisotopic_mass": "3947.2448",
                                "monoisotopic_mz": "1974.6297",
                                "intensity": "1415.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "117",
                                "monoisotopic_mass": "9840.2946",
                                "monoisotopic_mz": "1969.0662",
                                "intensity": "12886.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "118",
                                "monoisotopic_mass": "7749.2435",
                                "monoisotopic_mz": "1550.8560",
                                "intensity": "1568.49",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "7748.2103",
                                        "ion_position": "77",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "Y00067",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0309",
                                        "ppm": "3.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "119",
                                "monoisotopic_mass": "9907.3740",
                                "monoisotopic_mz": "1982.4821",
                                "intensity": "1098.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "120",
                                "monoisotopic_mass": "9525.1765",
                                "monoisotopic_mz": "1906.0426",
                                "intensity": "2904.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "121",
                                "monoisotopic_mass": "3991.3174",
                                "monoisotopic_mz": "1996.6660",
                                "intensity": "433.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "122",
                                "monoisotopic_mass": "11638.0154",
                                "monoisotopic_mz": "1940.6765",
                                "intensity": "2346.21",
                                "charge": "6"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "123",
                                "monoisotopic_mass": "9072.8819",
                                "monoisotopic_mz": "1815.5837",
                                "intensity": "1840.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "124",
                                "monoisotopic_mass": "9970.3806",
                                "monoisotopic_mz": "1995.0834",
                                "intensity": "6591.16",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "9971.3924",
                                        "ion_position": "57",
                                        "ion_display_position": "87",
                                        "ion_sort_name": "Y00087",
                                        "ion_left_position": "57",
                                        "mass_error": "-0.0095",
                                        "ppm": "-0.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "125",
                                "monoisotopic_mass": "4106.2343",
                                "monoisotopic_mz": "2054.1245",
                                "intensity": "1251.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "126",
                                "monoisotopic_mass": "10848.6287",
                                "monoisotopic_mz": "1550.8114",
                                "intensity": "1547.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "127",
                                "monoisotopic_mass": "10149.4766",
                                "monoisotopic_mz": "2030.9026",
                                "intensity": "1953.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "128",
                                "monoisotopic_mass": "9760.2598",
                                "monoisotopic_mz": "1953.0592",
                                "intensity": "2155.65",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "9761.2556",
                                        "ion_position": "59",
                                        "ion_display_position": "85",
                                        "ion_sort_name": "Y00085",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0066",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "129",
                                "monoisotopic_mass": "12406.8069",
                                "monoisotopic_mz": "2068.8084",
                                "intensity": "779.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "130",
                                "monoisotopic_mass": "8232.5321",
                                "monoisotopic_mz": "1647.5137",
                                "intensity": "480.75",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "247.0868063914",
                                        "theoretical_mass": "8231.5160",
                                        "ion_position": "73",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "Y00071",
                                        "ion_left_position": "73",
                                        "mass_error": "0.0137",
                                        "ppm": "1.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "131",
                                "monoisotopic_mass": "4542.3687",
                                "monoisotopic_mz": "2272.1917",
                                "intensity": "4327.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "302",
                                "peak_id": "132",
                                "monoisotopic_mass": "1972.8623",
                                "monoisotopic_mz": "1973.8696",
                                "intensity": "2327.94",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "11",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P37903|USPF_ECOLI",
                    "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                    "proteoform_mass": "16310.6225",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "144",
                        "first_residue_position": "0",
                        "last_residue_position": "143",
                        "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKI(PAHMIIIASHRPDITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation])[+247.0868]SVLVVR.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "P"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "D"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "Q"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "I"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "H"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "I"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "I"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "P"
                            },
                            {
                                "position": "45",
                                "acid": "Y"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "S"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "G"
                            },
                            {
                                "position": "51",
                                "acid": "L"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "Y"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "P"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "M"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "D"
                            },
                            {
                                "position": "63",
                                "acid": "L"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "S"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "E"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "I"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "K"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "P"
                            },
                            {
                                "position": "82",
                                "acid": "T"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "R"
                            },
                            {
                                "position": "85",
                                "acid": "V"
                            },
                            {
                                "position": "86",
                                "acid": "H"
                            },
                            {
                                "position": "87",
                                "acid": "V"
                            },
                            {
                                "position": "88",
                                "acid": "H"
                            },
                            {
                                "position": "89",
                                "acid": "V"
                            },
                            {
                                "position": "90",
                                "acid": "E"
                            },
                            {
                                "position": "91",
                                "acid": "E"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "S"
                            },
                            {
                                "position": "94",
                                "acid": "P"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "R"
                            },
                            {
                                "position": "98",
                                "acid": "I"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "E"
                            },
                            {
                                "position": "101",
                                "acid": "L"
                            },
                            {
                                "position": "102",
                                "acid": "A"
                            },
                            {
                                "position": "103",
                                "acid": "K"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "A"
                            },
                            {
                                "position": "108",
                                "acid": "H"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            },
                            {
                                "position": "110",
                                "acid": "I"
                            },
                            {
                                "position": "111",
                                "acid": "I"
                            },
                            {
                                "position": "112",
                                "acid": "I"
                            },
                            {
                                "position": "113",
                                "acid": "A"
                            },
                            {
                                "position": "114",
                                "acid": "S"
                            },
                            {
                                "position": "115",
                                "acid": "H"
                            },
                            {
                                "position": "116",
                                "acid": "R"
                            },
                            {
                                "position": "117",
                                "acid": "P"
                            },
                            {
                                "position": "118",
                                "acid": "D"
                            },
                            {
                                "position": "119",
                                "acid": "I"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "T"
                            },
                            {
                                "position": "122",
                                "acid": "Y"
                            },
                            {
                                "position": "123",
                                "acid": "L"
                            },
                            {
                                "position": "124",
                                "acid": "L"
                            },
                            {
                                "position": "125",
                                "acid": "G"
                            },
                            {
                                "position": "126",
                                "acid": "S"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "A"
                            },
                            {
                                "position": "129",
                                "acid": "A"
                            },
                            {
                                "position": "130",
                                "acid": "A"
                            },
                            {
                                "position": "131",
                                "acid": "V"
                            },
                            {
                                "position": "132",
                                "acid": "V"
                            },
                            {
                                "position": "133",
                                "acid": "R"
                            },
                            {
                                "position": "134",
                                "acid": "H"
                            },
                            {
                                "position": "135",
                                "acid": "A"
                            },
                            {
                                "position": "136",
                                "acid": "E"
                            },
                            {
                                "position": "137",
                                "acid": "C"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "V"
                            },
                            {
                                "position": "140",
                                "acid": "L"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "302",
                                        "peak_id": "34",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "302",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "302",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "302",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "302",
                                        "peak_id": "77",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "302",
                                        "peak_id": "57",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "302",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "302",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "302",
                                        "peak_id": "35",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "302",
                                        "peak_id": "59",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "302",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "302",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "302",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "302",
                                        "peak_id": "73",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "302",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "302",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "302",
                                        "peak_id": "88",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "302",
                                        "peak_id": "37",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "302",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "302",
                                            "peak_id": "109",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "302",
                                            "peak_id": "52",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "57",
                                        "ion_display_position": "87",
                                        "spec_id": "302",
                                        "peak_id": "124",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "spec_id": "302",
                                        "peak_id": "95",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "85",
                                        "spec_id": "302",
                                        "peak_id": "128",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "spec_id": "302",
                                        "peak_id": "79",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "spec_id": "302",
                                        "peak_id": "75",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "76",
                                        "spec_id": "302",
                                        "peak_id": "22",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "75",
                                        "spec_id": "302",
                                        "peak_id": "92",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "71",
                                        "spec_id": "302",
                                        "peak_id": "130",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "67",
                                        "spec_id": "302",
                                        "peak_id": "118",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "60",
                                            "spec_id": "302",
                                            "peak_id": "107",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "60",
                                            "spec_id": "302",
                                            "peak_id": "76",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "91",
                                        "ion_display_position": "53",
                                        "spec_id": "302",
                                        "peak_id": "61",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "spec_id": "302",
                                        "peak_id": "33",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "spec_id": "302",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "106",
                                        "ion_display_position": "38",
                                        "spec_id": "302",
                                        "peak_id": "62",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "6",
                                        "spec_id": "302",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "137",
                                "right_pos": "138",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "106",
                            "right_position": "138",
                            "shift": "247.0868063914",
                            "anno": "+247.0868",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "156",
                "p_value": "2.19e-17",
                "e_value": "2.19e-17",
                "fdr": "0",
                "matched_fragment_number": "27",
                "matched_peak_number": "30",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "624",
                        "ms1_scans": "960",
                        "ids": "335",
                        "scans": "961",
                        "precursor_mono_mass": "16311.5248",
                        "precursor_charge": "8",
                        "precursor_mz": "2039.9479",
                        "feature_inte": "4.0888e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "335",
                                "peak_id": "0",
                                "monoisotopic_mass": "3303.7169",
                                "monoisotopic_mz": "1652.8657",
                                "intensity": "3574.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3303.7133",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0036",
                                        "ppm": "1.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "1",
                                "monoisotopic_mass": "2192.6224",
                                "monoisotopic_mz": "2193.6297",
                                "intensity": "1400.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "2",
                                "monoisotopic_mass": "3158.5995",
                                "monoisotopic_mz": "1580.3070",
                                "intensity": "4071.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "3158.6277",
                                        "ion_position": "117",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "117",
                                        "mass_error": "-0.0282",
                                        "ppm": "-8.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "3",
                                "monoisotopic_mass": "5661.1254",
                                "monoisotopic_mz": "1416.2886",
                                "intensity": "3020.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "4",
                                "monoisotopic_mass": "3646.8657",
                                "monoisotopic_mz": "1824.4401",
                                "intensity": "13138.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3646.8512",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0144",
                                        "ppm": "3.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "5",
                                "monoisotopic_mass": "2033.4929",
                                "monoisotopic_mz": "2034.5002",
                                "intensity": "2110.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "6",
                                "monoisotopic_mass": "1467.7843",
                                "monoisotopic_mz": "1468.7916",
                                "intensity": "17557.81",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1467.7756",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0088",
                                        "ppm": "6.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "7",
                                "monoisotopic_mass": "3846.9472",
                                "monoisotopic_mz": "1924.4809",
                                "intensity": "5890.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3846.9309",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0162",
                                        "ppm": "4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "8",
                                "monoisotopic_mass": "1553.8052",
                                "monoisotopic_mz": "1554.8125",
                                "intensity": "2078.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "9",
                                "monoisotopic_mass": "1152.6383",
                                "monoisotopic_mz": "1153.6456",
                                "intensity": "21372.21",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.6325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0058",
                                        "ppm": "5.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "10",
                                "monoisotopic_mass": "5431.9828",
                                "monoisotopic_mz": "1811.6682",
                                "intensity": "2716.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "11",
                                "monoisotopic_mass": "1416.6545",
                                "monoisotopic_mz": "1417.6617",
                                "intensity": "1667.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "12",
                                "monoisotopic_mass": "827.4725",
                                "monoisotopic_mz": "828.4798",
                                "intensity": "3703.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "827.4687",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0038",
                                        "ppm": "4.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "13",
                                "monoisotopic_mass": "3531.8405",
                                "monoisotopic_mz": "1766.9275",
                                "intensity": "10415.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3531.8243",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0162",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "14",
                                "monoisotopic_mass": "1079.5164",
                                "monoisotopic_mz": "1080.5237",
                                "intensity": "1879.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "15",
                                "monoisotopic_mass": "4426.2683",
                                "monoisotopic_mz": "1476.4300",
                                "intensity": "8658.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "16",
                                "monoisotopic_mass": "5449.9956",
                                "monoisotopic_mz": "1363.5062",
                                "intensity": "10925.28",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "5450.0053",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "97",
                                        "mass_error": "-0.0098",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "17",
                                "monoisotopic_mass": "1814.9193",
                                "monoisotopic_mz": "1815.9266",
                                "intensity": "2681.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "18",
                                "monoisotopic_mass": "2259.1417",
                                "monoisotopic_mz": "1130.5782",
                                "intensity": "1363.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "19",
                                "monoisotopic_mass": "1945.8553",
                                "monoisotopic_mz": "1946.8626",
                                "intensity": "3632.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "20",
                                "monoisotopic_mass": "2946.5226",
                                "monoisotopic_mz": "1474.2686",
                                "intensity": "9498.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "2946.5480",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "119",
                                        "mass_error": "-0.0254",
                                        "ppm": "-8.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "21",
                                "monoisotopic_mass": "970.4474",
                                "monoisotopic_mz": "971.4547",
                                "intensity": "960.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "22",
                                "monoisotopic_mass": "1904.0516",
                                "monoisotopic_mz": "1905.0589",
                                "intensity": "1492.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "23",
                                "monoisotopic_mass": "5934.2313",
                                "monoisotopic_mz": "1484.5651",
                                "intensity": "6628.51",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "5934.2335",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "92",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "24",
                                "monoisotopic_mass": "2846.5084",
                                "monoisotopic_mz": "1424.2615",
                                "intensity": "3509.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2846.4960",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0124",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "25",
                                "monoisotopic_mass": "1140.5905",
                                "monoisotopic_mz": "1141.5978",
                                "intensity": "1860.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "26",
                                "monoisotopic_mass": "5176.8916",
                                "monoisotopic_mz": "1295.2302",
                                "intensity": "5885.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "27",
                                "monoisotopic_mass": "4525.3473",
                                "monoisotopic_mz": "1509.4564",
                                "intensity": "5856.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "28",
                                "monoisotopic_mass": "2673.4308",
                                "monoisotopic_mz": "1337.7227",
                                "intensity": "4103.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "29",
                                "monoisotopic_mass": "4083.0725",
                                "monoisotopic_mz": "1362.0314",
                                "intensity": "4720.73",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4083.0583",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0142",
                                        "ppm": "3.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "30",
                                "monoisotopic_mass": "1009.5635",
                                "monoisotopic_mz": "1010.5707",
                                "intensity": "1045.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "31",
                                "monoisotopic_mass": "529.1868",
                                "monoisotopic_mz": "530.1941",
                                "intensity": "2187.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "32",
                                "monoisotopic_mass": "4543.3514",
                                "monoisotopic_mz": "1515.4577",
                                "intensity": "6213.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4543.3268",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0245",
                                        "ppm": "5.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "33",
                                "monoisotopic_mass": "1695.9184",
                                "monoisotopic_mz": "1696.9257",
                                "intensity": "1495.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "34",
                                "monoisotopic_mass": "2503.4686",
                                "monoisotopic_mz": "1252.7416",
                                "intensity": "1872.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "35",
                                "monoisotopic_mass": "9330.1335",
                                "monoisotopic_mz": "1867.0340",
                                "intensity": "6896.60",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "9330.1264",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "63",
                                        "mass_error": "0.0070",
                                        "ppm": "0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "36",
                                "monoisotopic_mass": "6919.7653",
                                "monoisotopic_mz": "1730.9486",
                                "intensity": "5638.98",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "6919.7429",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "84",
                                        "mass_error": "0.0224",
                                        "ppm": "3.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "37",
                                "monoisotopic_mass": "494.2188",
                                "monoisotopic_mz": "495.2260",
                                "intensity": "1569.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "38",
                                "monoisotopic_mass": "4655.4313",
                                "monoisotopic_mz": "1552.8177",
                                "intensity": "8017.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "39",
                                "monoisotopic_mass": "1248.6222",
                                "monoisotopic_mz": "1249.6295",
                                "intensity": "767.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "40",
                                "monoisotopic_mass": "728.4032",
                                "monoisotopic_mz": "729.4105",
                                "intensity": "1068.82",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "728.4003",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0029",
                                        "ppm": "4.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "41",
                                "monoisotopic_mass": "2063.0534",
                                "monoisotopic_mz": "2064.0607",
                                "intensity": "1617.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "42",
                                "monoisotopic_mass": "1438.7507",
                                "monoisotopic_mz": "1439.7579",
                                "intensity": "1692.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "43",
                                "monoisotopic_mass": "4444.2844",
                                "monoisotopic_mz": "1482.4354",
                                "intensity": "3645.16",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4444.2584",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0260",
                                        "ppm": "5.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "44",
                                "monoisotopic_mass": "2204.1557",
                                "monoisotopic_mz": "2205.1630",
                                "intensity": "1703.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "45",
                                "monoisotopic_mass": "6339.2695",
                                "monoisotopic_mz": "2114.0971",
                                "intensity": "3083.19",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6339.2301",
                                        "ion_position": "57",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "B00057",
                                        "ion_left_position": "57",
                                        "mass_error": "0.0395",
                                        "ppm": "6.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "46",
                                "monoisotopic_mass": "878.4685",
                                "monoisotopic_mz": "879.4758",
                                "intensity": "662.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "47",
                                "monoisotopic_mass": "4230.1482",
                                "monoisotopic_mz": "1411.0567",
                                "intensity": "4519.57",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4230.1267",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0215",
                                        "ppm": "5.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "48",
                                "monoisotopic_mass": "423.1808",
                                "monoisotopic_mz": "424.1881",
                                "intensity": "1526.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "49",
                                "monoisotopic_mass": "4343.2459",
                                "monoisotopic_mz": "1448.7559",
                                "intensity": "4805.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4343.2108",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0352",
                                        "ppm": "8.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "50",
                                "monoisotopic_mass": "6630.6398",
                                "monoisotopic_mz": "1658.6672",
                                "intensity": "2598.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "51",
                                "monoisotopic_mass": "6063.2474",
                                "monoisotopic_mz": "1516.8191",
                                "intensity": "2024.07",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "6063.2761",
                                        "ion_position": "91",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "Y00053",
                                        "ion_left_position": "91",
                                        "mass_error": "-0.0287",
                                        "ppm": "-4.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "52",
                                "monoisotopic_mass": "2816.4787",
                                "monoisotopic_mz": "1409.2466",
                                "intensity": "2265.14",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "53",
                                "monoisotopic_mass": "4515.3256",
                                "monoisotopic_mz": "2258.6701",
                                "intensity": "3058.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "54",
                                "monoisotopic_mass": "401.1857",
                                "monoisotopic_mz": "402.1930",
                                "intensity": "1083.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "401.1845",
                                        "ion_position": "3",
                                        "ion_display_position": "3",
                                        "ion_sort_name": "B00003",
                                        "ion_left_position": "3",
                                        "mass_error": "0.0012",
                                        "ppm": "2.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "55",
                                "monoisotopic_mass": "9859.3166",
                                "monoisotopic_mz": "1644.2267",
                                "intensity": "3633.83",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "9859.3107",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "ion_sort_name": "Y00086",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0059",
                                        "ppm": "0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "56",
                                "monoisotopic_mass": "9567.1811",
                                "monoisotopic_mz": "1914.4435",
                                "intensity": "5489.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "57",
                                "monoisotopic_mass": "2320.1909",
                                "monoisotopic_mz": "2321.1982",
                                "intensity": "2773.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "58",
                                "monoisotopic_mass": "9313.1155",
                                "monoisotopic_mz": "1863.6304",
                                "intensity": "5250.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "59",
                                "monoisotopic_mass": "9445.1748",
                                "monoisotopic_mz": "1890.0422",
                                "intensity": "10702.00",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "9445.1534",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "Y00082",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0214",
                                        "ppm": "2.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "60",
                                "monoisotopic_mass": "4408.2507",
                                "monoisotopic_mz": "1470.4242",
                                "intensity": "2136.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "61",
                                "monoisotopic_mass": "4637.4166",
                                "monoisotopic_mz": "1546.8128",
                                "intensity": "2216.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "62",
                                "monoisotopic_mass": "1488.7740",
                                "monoisotopic_mz": "1489.7813",
                                "intensity": "653.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "63",
                                "monoisotopic_mass": "5431.9698",
                                "monoisotopic_mz": "1358.9997",
                                "intensity": "3593.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "64",
                                "monoisotopic_mass": "5322.9458",
                                "monoisotopic_mz": "1331.7437",
                                "intensity": "788.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "65",
                                "monoisotopic_mass": "9586.1961",
                                "monoisotopic_mz": "1918.2465",
                                "intensity": "8836.17",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "66",
                                "monoisotopic_mass": "4384.2736",
                                "monoisotopic_mz": "1462.4318",
                                "intensity": "2294.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "67",
                                "monoisotopic_mass": "8687.7477",
                                "monoisotopic_mz": "1738.5568",
                                "intensity": "3941.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "68",
                                "monoisotopic_mass": "4542.3149",
                                "monoisotopic_mz": "2272.1647",
                                "intensity": "4917.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "69",
                                "monoisotopic_mass": "6498.5558",
                                "monoisotopic_mz": "2167.1925",
                                "intensity": "882.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "70",
                                "monoisotopic_mass": "6454.3319",
                                "monoisotopic_mz": "2152.4513",
                                "intensity": "1478.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "71",
                                "monoisotopic_mass": "9841.3030",
                                "monoisotopic_mz": "1969.2679",
                                "intensity": "13697.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "72",
                                "monoisotopic_mass": "6648.6375",
                                "monoisotopic_mz": "1663.1667",
                                "intensity": "3964.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "73",
                                "monoisotopic_mass": "2292.2487",
                                "monoisotopic_mz": "2293.2560",
                                "intensity": "1206.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "74",
                                "monoisotopic_mass": "4055.0785",
                                "monoisotopic_mz": "1352.7001",
                                "intensity": "2606.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "75",
                                "monoisotopic_mass": "4343.2410",
                                "monoisotopic_mz": "2172.6278",
                                "intensity": "1977.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4343.2108",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0302",
                                        "ppm": "6.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "76",
                                "monoisotopic_mass": "4628.4185",
                                "monoisotopic_mz": "2315.2165",
                                "intensity": "5570.84",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "77",
                                "monoisotopic_mass": "1722.1778",
                                "monoisotopic_mz": "1723.1851",
                                "intensity": "1122.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "78",
                                "monoisotopic_mass": "9427.1504",
                                "monoisotopic_mz": "1886.4373",
                                "intensity": "5795.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "79",
                                "monoisotopic_mass": "1960.4528",
                                "monoisotopic_mz": "1961.4601",
                                "intensity": "2122.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "80",
                                "monoisotopic_mass": "9763.1994",
                                "monoisotopic_mz": "1953.6472",
                                "intensity": "3549.25",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "9762.2579",
                                        "ion_position": "59",
                                        "ion_display_position": "85",
                                        "ion_sort_name": "Y00085",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0609",
                                        "ppm": "-6.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "81",
                                "monoisotopic_mass": "8743.8316",
                                "monoisotopic_mz": "1749.7736",
                                "intensity": "3088.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "82",
                                "monoisotopic_mass": "2021.0932",
                                "monoisotopic_mz": "2022.1005",
                                "intensity": "1380.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "83",
                                "monoisotopic_mass": "4656.4121",
                                "monoisotopic_mz": "2329.2133",
                                "intensity": "8594.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0012",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "84",
                                "monoisotopic_mass": "9954.3759",
                                "monoisotopic_mz": "1991.8825",
                                "intensity": "3707.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "85",
                                "monoisotopic_mass": "11321.9981",
                                "monoisotopic_mz": "2265.4069",
                                "intensity": "3148.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "86",
                                "monoisotopic_mass": "11296.9371",
                                "monoisotopic_mz": "2260.3947",
                                "intensity": "2702.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "87",
                                "monoisotopic_mass": "4325.2382",
                                "monoisotopic_mz": "1442.7533",
                                "intensity": "2487.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "88",
                                "monoisotopic_mass": "3995.1724",
                                "monoisotopic_mz": "1998.5935",
                                "intensity": "1919.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "89",
                                "monoisotopic_mass": "4083.0760",
                                "monoisotopic_mz": "2042.5453",
                                "intensity": "1835.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4083.0583",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0177",
                                        "ppm": "4.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "90",
                                "monoisotopic_mass": "3174.6330",
                                "monoisotopic_mz": "1588.3238",
                                "intensity": "2080.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "91",
                                "monoisotopic_mass": "1739.1556",
                                "monoisotopic_mz": "1740.1629",
                                "intensity": "1238.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "92",
                                "monoisotopic_mass": "6579.6488",
                                "monoisotopic_mz": "1645.9195",
                                "intensity": "1461.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "93",
                                "monoisotopic_mass": "1992.0759",
                                "monoisotopic_mz": "1993.0832",
                                "intensity": "1068.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "94",
                                "monoisotopic_mass": "4577.9972",
                                "monoisotopic_mz": "2290.0059",
                                "intensity": "1569.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "95",
                                "monoisotopic_mass": "2393.3030",
                                "monoisotopic_mz": "1197.6588",
                                "intensity": "2120.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "96",
                                "monoisotopic_mass": "4062.5616",
                                "monoisotopic_mz": "2032.2881",
                                "intensity": "1931.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "97",
                                "monoisotopic_mass": "9689.2149",
                                "monoisotopic_mz": "1938.8503",
                                "intensity": "1301.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "98",
                                "monoisotopic_mass": "9182.0515",
                                "monoisotopic_mz": "1837.4176",
                                "intensity": "1297.95",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "99",
                                "monoisotopic_mass": "9858.3188",
                                "monoisotopic_mz": "1972.6710",
                                "intensity": "13966.98",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0891563914",
                                        "theoretical_mass": "9859.3107",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "ion_sort_name": "Y00086",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0105",
                                        "ppm": "1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "100",
                                "monoisotopic_mass": "9781.2479",
                                "monoisotopic_mz": "1957.2569",
                                "intensity": "1523.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "101",
                                "monoisotopic_mass": "4611.4122",
                                "monoisotopic_mz": "2306.7134",
                                "intensity": "2496.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "102",
                                "monoisotopic_mass": "6884.6555",
                                "monoisotopic_mz": "1722.1712",
                                "intensity": "1689.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "103",
                                "monoisotopic_mass": "11408.9732",
                                "monoisotopic_mz": "1902.5028",
                                "intensity": "1237.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "104",
                                "monoisotopic_mass": "10241.4999",
                                "monoisotopic_mz": "2049.3073",
                                "intensity": "2781.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "105",
                                "monoisotopic_mass": "12478.8919",
                                "monoisotopic_mz": "2080.8226",
                                "intensity": "935.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "106",
                                "monoisotopic_mass": "10404.4982",
                                "monoisotopic_mz": "2081.9069",
                                "intensity": "903.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "335",
                                "peak_id": "107",
                                "monoisotopic_mass": "4166.3013",
                                "monoisotopic_mz": "2084.1579",
                                "intensity": "1265.93",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "11",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P37903|USPF_ECOLI",
                    "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                    "proteoform_mass": "16311.6248",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "144",
                        "first_residue_position": "0",
                        "last_residue_position": "143",
                        "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0892].",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "P"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "D"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "Q"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "I"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "H"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "I"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "I"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "P"
                            },
                            {
                                "position": "45",
                                "acid": "Y"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "S"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "G"
                            },
                            {
                                "position": "51",
                                "acid": "L"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "Y"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "P"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "M"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "D"
                            },
                            {
                                "position": "63",
                                "acid": "L"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "S"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "E"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "I"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "K"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "P"
                            },
                            {
                                "position": "82",
                                "acid": "T"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "R"
                            },
                            {
                                "position": "85",
                                "acid": "V"
                            },
                            {
                                "position": "86",
                                "acid": "H"
                            },
                            {
                                "position": "87",
                                "acid": "V"
                            },
                            {
                                "position": "88",
                                "acid": "H"
                            },
                            {
                                "position": "89",
                                "acid": "V"
                            },
                            {
                                "position": "90",
                                "acid": "E"
                            },
                            {
                                "position": "91",
                                "acid": "E"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "S"
                            },
                            {
                                "position": "94",
                                "acid": "P"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "R"
                            },
                            {
                                "position": "98",
                                "acid": "I"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "E"
                            },
                            {
                                "position": "101",
                                "acid": "L"
                            },
                            {
                                "position": "102",
                                "acid": "A"
                            },
                            {
                                "position": "103",
                                "acid": "K"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "A"
                            },
                            {
                                "position": "108",
                                "acid": "H"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            },
                            {
                                "position": "110",
                                "acid": "I"
                            },
                            {
                                "position": "111",
                                "acid": "I"
                            },
                            {
                                "position": "112",
                                "acid": "I"
                            },
                            {
                                "position": "113",
                                "acid": "A"
                            },
                            {
                                "position": "114",
                                "acid": "S"
                            },
                            {
                                "position": "115",
                                "acid": "H"
                            },
                            {
                                "position": "116",
                                "acid": "R"
                            },
                            {
                                "position": "117",
                                "acid": "P"
                            },
                            {
                                "position": "118",
                                "acid": "D"
                            },
                            {
                                "position": "119",
                                "acid": "I"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "T"
                            },
                            {
                                "position": "122",
                                "acid": "Y"
                            },
                            {
                                "position": "123",
                                "acid": "L"
                            },
                            {
                                "position": "124",
                                "acid": "L"
                            },
                            {
                                "position": "125",
                                "acid": "G"
                            },
                            {
                                "position": "126",
                                "acid": "S"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "A"
                            },
                            {
                                "position": "129",
                                "acid": "A"
                            },
                            {
                                "position": "130",
                                "acid": "A"
                            },
                            {
                                "position": "131",
                                "acid": "V"
                            },
                            {
                                "position": "132",
                                "acid": "V"
                            },
                            {
                                "position": "133",
                                "acid": "R"
                            },
                            {
                                "position": "134",
                                "acid": "H"
                            },
                            {
                                "position": "135",
                                "acid": "A"
                            },
                            {
                                "position": "136",
                                "acid": "E"
                            },
                            {
                                "position": "137",
                                "acid": "C"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "V"
                            },
                            {
                                "position": "140",
                                "acid": "L"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "3",
                                        "ion_display_position": "3",
                                        "spec_id": "335",
                                        "peak_id": "54",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "335",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "335",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "335",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "335",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "335",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "335",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "335",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "335",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "335",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "335",
                                            "peak_id": "29",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "335",
                                            "peak_id": "89",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "335",
                                        "peak_id": "47",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "38",
                                            "ion_display_position": "38",
                                            "spec_id": "335",
                                            "peak_id": "75",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "38",
                                            "ion_display_position": "38",
                                            "spec_id": "335",
                                            "peak_id": "49",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "335",
                                        "peak_id": "43",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "335",
                                        "peak_id": "32",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "335",
                                        "peak_id": "83",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "57",
                                        "ion_display_position": "57",
                                        "spec_id": "335",
                                        "peak_id": "45",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "58",
                                            "ion_display_position": "86",
                                            "spec_id": "335",
                                            "peak_id": "55",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "58",
                                            "ion_display_position": "86",
                                            "spec_id": "335",
                                            "peak_id": "99",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "85",
                                        "spec_id": "335",
                                        "peak_id": "80",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "spec_id": "335",
                                        "peak_id": "59",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "spec_id": "335",
                                        "peak_id": "35",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "spec_id": "335",
                                        "peak_id": "36",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "91",
                                        "ion_display_position": "53",
                                        "spec_id": "335",
                                        "peak_id": "51",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "spec_id": "335",
                                        "peak_id": "23",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "spec_id": "335",
                                        "peak_id": "16",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "117",
                                        "ion_display_position": "27",
                                        "spec_id": "335",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "spec_id": "335",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "137",
                                "right_pos": "138",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "119",
                            "right_position": "144",
                            "shift": "248.0891563914",
                            "anno": "+248.0892",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "114",
                "p_value": "2.50e-15",
                "e_value": "2.50e-15",
                "fdr": "0",
                "matched_fragment_number": "25",
                "matched_peak_number": "27",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "602",
                        "ms1_scans": "872",
                        "ids": "271",
                        "scans": "875",
                        "precursor_mono_mass": "16311.5248",
                        "precursor_charge": "8",
                        "precursor_mz": "2039.9479",
                        "feature_inte": "4.0888e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "271",
                                "peak_id": "0",
                                "monoisotopic_mass": "2494.2284",
                                "monoisotopic_mz": "2495.2356",
                                "intensity": "1830.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "1",
                                "monoisotopic_mass": "3531.8508",
                                "monoisotopic_mz": "1766.9327",
                                "intensity": "10624.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3531.8243",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0265",
                                        "ppm": "7.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "2",
                                "monoisotopic_mass": "1152.6381",
                                "monoisotopic_mz": "1153.6454",
                                "intensity": "17656.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.6325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0056",
                                        "ppm": "4.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "3",
                                "monoisotopic_mass": "3158.5897",
                                "monoisotopic_mz": "1580.3021",
                                "intensity": "3607.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "3158.6127",
                                        "ion_position": "117",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "117",
                                        "mass_error": "-0.0230",
                                        "ppm": "-7.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "4",
                                "monoisotopic_mass": "1467.7839",
                                "monoisotopic_mz": "1468.7911",
                                "intensity": "14113.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1467.7756",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0083",
                                        "ppm": "5.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "5",
                                "monoisotopic_mass": "3629.8613",
                                "monoisotopic_mz": "1815.9379",
                                "intensity": "3371.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "6",
                                "monoisotopic_mass": "827.4731",
                                "monoisotopic_mz": "828.4803",
                                "intensity": "3366.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "827.4687",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0043",
                                        "ppm": "5.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "7",
                                "monoisotopic_mass": "3646.8671",
                                "monoisotopic_mz": "1824.4408",
                                "intensity": "12747.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3646.8512",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0159",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "8",
                                "monoisotopic_mass": "3303.7277",
                                "monoisotopic_mz": "1652.8711",
                                "intensity": "2977.46",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3303.7133",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0144",
                                        "ppm": "4.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "9",
                                "monoisotopic_mass": "3846.9440",
                                "monoisotopic_mz": "1924.4793",
                                "intensity": "4288.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3846.9309",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0131",
                                        "ppm": "3.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "10",
                                "monoisotopic_mass": "2281.1937",
                                "monoisotopic_mz": "1141.6041",
                                "intensity": "1661.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2281.2100",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0164",
                                        "ppm": "-7.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "11",
                                "monoisotopic_mass": "2846.5148",
                                "monoisotopic_mz": "1424.2647",
                                "intensity": "2605.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2846.4960",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0188",
                                        "ppm": "6.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "12",
                                "monoisotopic_mass": "799.4767",
                                "monoisotopic_mz": "800.4839",
                                "intensity": "985.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "13",
                                "monoisotopic_mass": "2269.0155",
                                "monoisotopic_mz": "2270.0227",
                                "intensity": "1586.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "14",
                                "monoisotopic_mass": "935.4802",
                                "monoisotopic_mz": "936.4875",
                                "intensity": "888.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "15",
                                "monoisotopic_mass": "2394.2990",
                                "monoisotopic_mz": "1198.1568",
                                "intensity": "874.12",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2394.2941",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0049",
                                        "ppm": "2.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "16",
                                "monoisotopic_mass": "4525.3496",
                                "monoisotopic_mz": "1509.4571",
                                "intensity": "4264.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "17",
                                "monoisotopic_mass": "1009.5648",
                                "monoisotopic_mz": "1010.5721",
                                "intensity": "1362.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "18",
                                "monoisotopic_mass": "4203.1589",
                                "monoisotopic_mz": "1402.0602",
                                "intensity": "1366.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "19",
                                "monoisotopic_mass": "6919.7301",
                                "monoisotopic_mz": "1730.9398",
                                "intensity": "3526.26",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "6919.7279",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "Y00060",
                                        "ion_left_position": "84",
                                        "mass_error": "0.0022",
                                        "ppm": "0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "20",
                                "monoisotopic_mass": "529.1867",
                                "monoisotopic_mz": "530.1940",
                                "intensity": "1344.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "21",
                                "monoisotopic_mass": "2673.4252",
                                "monoisotopic_mz": "1337.7199",
                                "intensity": "2785.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "22",
                                "monoisotopic_mass": "2817.4764",
                                "monoisotopic_mz": "1409.7455",
                                "intensity": "2474.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "23",
                                "monoisotopic_mass": "4656.4219",
                                "monoisotopic_mz": "1553.1479",
                                "intensity": "6811.26",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0110",
                                        "ppm": "2.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "24",
                                "monoisotopic_mass": "1124.5916",
                                "monoisotopic_mz": "1125.5989",
                                "intensity": "731.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "25",
                                "monoisotopic_mass": "4230.1479",
                                "monoisotopic_mz": "1411.0566",
                                "intensity": "4502.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4230.1267",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0212",
                                        "ppm": "5.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "26",
                                "monoisotopic_mass": "5449.9936",
                                "monoisotopic_mz": "1363.5057",
                                "intensity": "7826.29",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "5449.9903",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "97",
                                        "mass_error": "0.0033",
                                        "ppm": "0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "27",
                                "monoisotopic_mass": "2946.5165",
                                "monoisotopic_mz": "1474.2655",
                                "intensity": "6712.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "2946.5330",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "119",
                                        "mass_error": "-0.0165",
                                        "ppm": "-5.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "28",
                                "monoisotopic_mass": "4083.0717",
                                "monoisotopic_mz": "1362.0312",
                                "intensity": "3410.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4083.0583",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0134",
                                        "ppm": "3.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "29",
                                "monoisotopic_mass": "4426.2690",
                                "monoisotopic_mz": "1476.4303",
                                "intensity": "7078.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "30",
                                "monoisotopic_mass": "1939.2597",
                                "monoisotopic_mz": "1940.2670",
                                "intensity": "1527.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "31",
                                "monoisotopic_mass": "1776.7804",
                                "monoisotopic_mz": "1777.7877",
                                "intensity": "929.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "32",
                                "monoisotopic_mass": "4443.2864",
                                "monoisotopic_mz": "1482.1027",
                                "intensity": "4039.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "33",
                                "monoisotopic_mass": "3176.6405",
                                "monoisotopic_mz": "1589.3275",
                                "intensity": "1724.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "34",
                                "monoisotopic_mass": "2716.4694",
                                "monoisotopic_mz": "1359.2420",
                                "intensity": "1828.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "35",
                                "monoisotopic_mass": "1442.7480",
                                "monoisotopic_mz": "1443.7552",
                                "intensity": "1568.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "36",
                                "monoisotopic_mass": "494.2187",
                                "monoisotopic_mz": "495.2260",
                                "intensity": "1465.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "37",
                                "monoisotopic_mass": "1080.6823",
                                "monoisotopic_mz": "1081.6896",
                                "intensity": "1835.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "38",
                                "monoisotopic_mass": "4925.5951",
                                "monoisotopic_mz": "2463.8048",
                                "intensity": "3226.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "39",
                                "monoisotopic_mass": "1416.6558",
                                "monoisotopic_mz": "1417.6631",
                                "intensity": "1671.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "40",
                                "monoisotopic_mass": "4542.3647",
                                "monoisotopic_mz": "2272.1896",
                                "intensity": "3359.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "41",
                                "monoisotopic_mass": "3548.3070",
                                "monoisotopic_mz": "1775.1608",
                                "intensity": "1226.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "42",
                                "monoisotopic_mass": "4055.0775",
                                "monoisotopic_mz": "1352.6998",
                                "intensity": "2076.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "43",
                                "monoisotopic_mass": "1657.6497",
                                "monoisotopic_mz": "1658.6570",
                                "intensity": "1117.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "44",
                                "monoisotopic_mass": "4499.3878",
                                "monoisotopic_mz": "1500.8032",
                                "intensity": "694.07",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "45",
                                "monoisotopic_mass": "1366.7008",
                                "monoisotopic_mz": "1367.7081",
                                "intensity": "466.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "46",
                                "monoisotopic_mass": "2018.4910",
                                "monoisotopic_mz": "2019.4982",
                                "intensity": "1012.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "47",
                                "monoisotopic_mass": "9089.9680",
                                "monoisotopic_mz": "1819.0009",
                                "intensity": "6155.91",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "9088.9324",
                                        "ion_position": "65",
                                        "ion_display_position": "79",
                                        "ion_sort_name": "Y00079",
                                        "ion_left_position": "65",
                                        "mass_error": "0.0332",
                                        "ppm": "3.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "48",
                                "monoisotopic_mass": "2968.1153",
                                "monoisotopic_mz": "1485.0649",
                                "intensity": "2080.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "49",
                                "monoisotopic_mass": "4385.2730",
                                "monoisotopic_mz": "1462.7649",
                                "intensity": "2111.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "4385.2833",
                                        "ion_position": "106",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "Y00038",
                                        "ion_left_position": "106",
                                        "mass_error": "-0.0104",
                                        "ppm": "-2.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "50",
                                "monoisotopic_mass": "5176.8937",
                                "monoisotopic_mz": "1295.2307",
                                "intensity": "3004.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "51",
                                "monoisotopic_mass": "6792.6983",
                                "monoisotopic_mz": "1699.1819",
                                "intensity": "757.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "52",
                                "monoisotopic_mass": "3993.9847",
                                "monoisotopic_mz": "1997.9996",
                                "intensity": "1831.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "53",
                                "monoisotopic_mass": "5789.1370",
                                "monoisotopic_mz": "1930.7196",
                                "intensity": "1409.18",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "5790.1650",
                                        "ion_position": "94",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "Y00050",
                                        "ion_left_position": "94",
                                        "mass_error": "-0.0257",
                                        "ppm": "-4.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "54",
                                "monoisotopic_mass": "5704.9337",
                                "monoisotopic_mz": "1902.6519",
                                "intensity": "1765.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5704.9339",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "55",
                                "monoisotopic_mass": "8891.8743",
                                "monoisotopic_mz": "1779.3821",
                                "intensity": "3670.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "56",
                                "monoisotopic_mass": "9252.5895",
                                "monoisotopic_mz": "1851.5252",
                                "intensity": "2685.41",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "57",
                                "monoisotopic_mass": "9712.1954",
                                "monoisotopic_mz": "1943.4463",
                                "intensity": "3352.73",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "58",
                                "monoisotopic_mass": "5661.1215",
                                "monoisotopic_mz": "1416.2876",
                                "intensity": "951.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "59",
                                "monoisotopic_mass": "1279.5950",
                                "monoisotopic_mz": "1280.6023",
                                "intensity": "425.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "60",
                                "monoisotopic_mass": "9218.0881",
                                "monoisotopic_mz": "1844.6249",
                                "intensity": "1855.87",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "9217.0274",
                                        "ion_position": "64",
                                        "ion_display_position": "80",
                                        "ion_sort_name": "Y00080",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0583",
                                        "ppm": "6.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "61",
                                "monoisotopic_mass": "1252.2352",
                                "monoisotopic_mz": "1253.2424",
                                "intensity": "915.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "62",
                                "monoisotopic_mass": "1907.0443",
                                "monoisotopic_mz": "1908.0516",
                                "intensity": "1203.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "63",
                                "monoisotopic_mass": "5145.9249",
                                "monoisotopic_mz": "1716.3156",
                                "intensity": "2028.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "64",
                                "monoisotopic_mass": "9586.2333",
                                "monoisotopic_mz": "1918.2539",
                                "intensity": "7693.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "65",
                                "monoisotopic_mass": "9172.0317",
                                "monoisotopic_mz": "1835.4136",
                                "intensity": "3510.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "66",
                                "monoisotopic_mass": "5319.9405",
                                "monoisotopic_mz": "1330.9924",
                                "intensity": "2032.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "67",
                                "monoisotopic_mass": "9158.7382",
                                "monoisotopic_mz": "1832.7549",
                                "intensity": "2730.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "68",
                                "monoisotopic_mass": "1315.6733",
                                "monoisotopic_mz": "1316.6805",
                                "intensity": "794.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "69",
                                "monoisotopic_mass": "2040.5240",
                                "monoisotopic_mz": "2041.5313",
                                "intensity": "1048.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "70",
                                "monoisotopic_mass": "3513.8162",
                                "monoisotopic_mz": "1757.9154",
                                "intensity": "1512.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "71",
                                "monoisotopic_mass": "9507.2541",
                                "monoisotopic_mz": "1902.4581",
                                "intensity": "750.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "72",
                                "monoisotopic_mass": "8689.7356",
                                "monoisotopic_mz": "1738.9544",
                                "intensity": "3056.09",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "8689.7206",
                                        "ion_position": "69",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "Y00075",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0150",
                                        "ppm": "1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "73",
                                "monoisotopic_mass": "3686.0571",
                                "monoisotopic_mz": "1844.0358",
                                "intensity": "2420.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "74",
                                "monoisotopic_mass": "4628.4190",
                                "monoisotopic_mz": "2315.2168",
                                "intensity": "4845.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "75",
                                "monoisotopic_mass": "9567.2294",
                                "monoisotopic_mz": "1914.4531",
                                "intensity": "3737.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "76",
                                "monoisotopic_mass": "3796.0545",
                                "monoisotopic_mz": "1899.0345",
                                "intensity": "1384.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "77",
                                "monoisotopic_mass": "5431.9927",
                                "monoisotopic_mz": "1811.6715",
                                "intensity": "1662.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "78",
                                "monoisotopic_mass": "9673.1715",
                                "monoisotopic_mz": "1935.6416",
                                "intensity": "1097.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "79",
                                "monoisotopic_mass": "9427.1328",
                                "monoisotopic_mz": "1886.4338",
                                "intensity": "3609.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "80",
                                "monoisotopic_mass": "10230.4980",
                                "monoisotopic_mz": "2047.1069",
                                "intensity": "1422.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "81",
                                "monoisotopic_mass": "8821.4339",
                                "monoisotopic_mz": "1765.2941",
                                "intensity": "799.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "82",
                                "monoisotopic_mass": "4409.2629",
                                "monoisotopic_mz": "1470.7616",
                                "intensity": "1461.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "83",
                                "monoisotopic_mass": "9809.2353",
                                "monoisotopic_mz": "1962.8543",
                                "intensity": "2445.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "84",
                                "monoisotopic_mass": "5176.8734",
                                "monoisotopic_mz": "1726.6317",
                                "intensity": "2520.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "85",
                                "monoisotopic_mass": "9859.2960",
                                "monoisotopic_mz": "1972.8665",
                                "intensity": "13942.06",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "9859.2957",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "ion_sort_name": "Y00086",
                                        "ion_left_position": "58",
                                        "mass_error": "0.0003",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "86",
                                "monoisotopic_mass": "4342.2355",
                                "monoisotopic_mz": "1448.4191",
                                "intensity": "3970.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "87",
                                "monoisotopic_mass": "1923.0516",
                                "monoisotopic_mz": "1924.0588",
                                "intensity": "1436.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "88",
                                "monoisotopic_mass": "5892.0814",
                                "monoisotopic_mz": "1965.0344",
                                "intensity": "1637.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "89",
                                "monoisotopic_mass": "4516.3666",
                                "monoisotopic_mz": "2259.1906",
                                "intensity": "1618.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "90",
                                "monoisotopic_mass": "2093.9135",
                                "monoisotopic_mz": "2094.9208",
                                "intensity": "1692.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "91",
                                "monoisotopic_mass": "1684.8570",
                                "monoisotopic_mz": "1685.8643",
                                "intensity": "1049.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "92",
                                "monoisotopic_mass": "9824.2991",
                                "monoisotopic_mz": "1965.8671",
                                "intensity": "5493.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "93",
                                "monoisotopic_mass": "10374.5413",
                                "monoisotopic_mz": "2075.9155",
                                "intensity": "1155.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "94",
                                "monoisotopic_mass": "5622.9138",
                                "monoisotopic_mz": "1875.3119",
                                "intensity": "614.41",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "95",
                                "monoisotopic_mass": "1764.1707",
                                "monoisotopic_mz": "1765.1780",
                                "intensity": "1828.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "96",
                                "monoisotopic_mass": "5968.7334",
                                "monoisotopic_mz": "1990.5851",
                                "intensity": "1946.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "97",
                                "monoisotopic_mass": "3879.6871",
                                "monoisotopic_mz": "1940.8508",
                                "intensity": "1433.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "98",
                                "monoisotopic_mass": "9730.2781",
                                "monoisotopic_mz": "1947.0629",
                                "intensity": "5652.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "99",
                                "monoisotopic_mass": "10420.5825",
                                "monoisotopic_mz": "2085.1238",
                                "intensity": "1610.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "100",
                                "monoisotopic_mass": "4656.4141",
                                "monoisotopic_mz": "2329.2143",
                                "intensity": "7694.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0031",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "101",
                                "monoisotopic_mass": "7943.9103",
                                "monoisotopic_mz": "1986.9849",
                                "intensity": "1217.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "102",
                                "monoisotopic_mass": "9403.8233",
                                "monoisotopic_mz": "1881.7719",
                                "intensity": "664.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "103",
                                "monoisotopic_mass": "9841.2851",
                                "monoisotopic_mz": "1969.2643",
                                "intensity": "10853.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "104",
                                "monoisotopic_mass": "10112.4211",
                                "monoisotopic_mz": "2023.4915",
                                "intensity": "2838.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "105",
                                "monoisotopic_mass": "4078.1606",
                                "monoisotopic_mz": "2040.0876",
                                "intensity": "1024.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "106",
                                "monoisotopic_mass": "10407.5782",
                                "monoisotopic_mz": "2082.5229",
                                "intensity": "571.91",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "107",
                                "monoisotopic_mass": "12844.0851",
                                "monoisotopic_mz": "1835.8766",
                                "intensity": "2187.29",
                                "charge": "7"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "108",
                                "monoisotopic_mass": "1483.8089",
                                "monoisotopic_mz": "1484.8162",
                                "intensity": "2021.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "109",
                                "monoisotopic_mass": "3610.8278",
                                "monoisotopic_mz": "1806.4212",
                                "intensity": "631.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "110",
                                "monoisotopic_mass": "5791.1653",
                                "monoisotopic_mz": "1448.7986",
                                "intensity": "1416.01",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "5790.1650",
                                        "ion_position": "94",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "Y00050",
                                        "ion_left_position": "94",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "111",
                                "monoisotopic_mass": "9973.3865",
                                "monoisotopic_mz": "1663.2384",
                                "intensity": "1174.55",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0741563914",
                                        "theoretical_mass": "9972.3797",
                                        "ion_position": "57",
                                        "ion_display_position": "87",
                                        "ion_sort_name": "Y00087",
                                        "ion_left_position": "57",
                                        "mass_error": "0.0044",
                                        "ppm": "0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "112",
                                "monoisotopic_mass": "13806.4749",
                                "monoisotopic_mz": "1726.8166",
                                "intensity": "1158.82",
                                "charge": "8"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "113",
                                "monoisotopic_mass": "2997.2427",
                                "monoisotopic_mz": "1499.6286",
                                "intensity": "812.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "114",
                                "monoisotopic_mass": "11974.9089",
                                "monoisotopic_mz": "1996.8254",
                                "intensity": "667.91",
                                "charge": "6"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "115",
                                "monoisotopic_mass": "11333.0281",
                                "monoisotopic_mz": "2267.6129",
                                "intensity": "1099.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "116",
                                "monoisotopic_mass": "3718.4355",
                                "monoisotopic_mz": "1860.2250",
                                "intensity": "585.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "117",
                                "monoisotopic_mass": "1859.6244",
                                "monoisotopic_mz": "1860.6317",
                                "intensity": "719.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "118",
                                "monoisotopic_mass": "10427.4825",
                                "monoisotopic_mz": "1738.9210",
                                "intensity": "634.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "119",
                                "monoisotopic_mass": "1841.9277",
                                "monoisotopic_mz": "1842.9349",
                                "intensity": "1589.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "120",
                                "monoisotopic_mass": "3450.8587",
                                "monoisotopic_mz": "1726.4366",
                                "intensity": "1695.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "121",
                                "monoisotopic_mass": "2328.0309",
                                "monoisotopic_mz": "2329.0381",
                                "intensity": "2776.88",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "11",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P37903|USPF_ECOLI",
                    "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                    "proteoform_mass": "16311.6098",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "144",
                        "first_residue_position": "0",
                        "last_residue_position": "143",
                        "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0742].",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "P"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "D"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "Q"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "I"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "H"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "I"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "I"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "P"
                            },
                            {
                                "position": "45",
                                "acid": "Y"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "S"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "G"
                            },
                            {
                                "position": "51",
                                "acid": "L"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "Y"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "P"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "M"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "D"
                            },
                            {
                                "position": "63",
                                "acid": "L"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "S"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "E"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "I"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "K"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "P"
                            },
                            {
                                "position": "82",
                                "acid": "T"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "R"
                            },
                            {
                                "position": "85",
                                "acid": "V"
                            },
                            {
                                "position": "86",
                                "acid": "H"
                            },
                            {
                                "position": "87",
                                "acid": "V"
                            },
                            {
                                "position": "88",
                                "acid": "H"
                            },
                            {
                                "position": "89",
                                "acid": "V"
                            },
                            {
                                "position": "90",
                                "acid": "E"
                            },
                            {
                                "position": "91",
                                "acid": "E"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "S"
                            },
                            {
                                "position": "94",
                                "acid": "P"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "R"
                            },
                            {
                                "position": "98",
                                "acid": "I"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "E"
                            },
                            {
                                "position": "101",
                                "acid": "L"
                            },
                            {
                                "position": "102",
                                "acid": "A"
                            },
                            {
                                "position": "103",
                                "acid": "K"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "A"
                            },
                            {
                                "position": "108",
                                "acid": "H"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            },
                            {
                                "position": "110",
                                "acid": "I"
                            },
                            {
                                "position": "111",
                                "acid": "I"
                            },
                            {
                                "position": "112",
                                "acid": "I"
                            },
                            {
                                "position": "113",
                                "acid": "A"
                            },
                            {
                                "position": "114",
                                "acid": "S"
                            },
                            {
                                "position": "115",
                                "acid": "H"
                            },
                            {
                                "position": "116",
                                "acid": "R"
                            },
                            {
                                "position": "117",
                                "acid": "P"
                            },
                            {
                                "position": "118",
                                "acid": "D"
                            },
                            {
                                "position": "119",
                                "acid": "I"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "T"
                            },
                            {
                                "position": "122",
                                "acid": "Y"
                            },
                            {
                                "position": "123",
                                "acid": "L"
                            },
                            {
                                "position": "124",
                                "acid": "L"
                            },
                            {
                                "position": "125",
                                "acid": "G"
                            },
                            {
                                "position": "126",
                                "acid": "S"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "A"
                            },
                            {
                                "position": "129",
                                "acid": "A"
                            },
                            {
                                "position": "130",
                                "acid": "A"
                            },
                            {
                                "position": "131",
                                "acid": "V"
                            },
                            {
                                "position": "132",
                                "acid": "V"
                            },
                            {
                                "position": "133",
                                "acid": "R"
                            },
                            {
                                "position": "134",
                                "acid": "H"
                            },
                            {
                                "position": "135",
                                "acid": "A"
                            },
                            {
                                "position": "136",
                                "acid": "E"
                            },
                            {
                                "position": "137",
                                "acid": "C"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "V"
                            },
                            {
                                "position": "140",
                                "acid": "L"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "271",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "271",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "271",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "271",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "271",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "271",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "271",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "271",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "271",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "271",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "271",
                                        "peak_id": "28",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "271",
                                        "peak_id": "25",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "271",
                                            "peak_id": "100",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "271",
                                            "peak_id": "23",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "271",
                                        "peak_id": "54",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "57",
                                        "ion_display_position": "87",
                                        "spec_id": "271",
                                        "peak_id": "111",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "86",
                                        "spec_id": "271",
                                        "peak_id": "85",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "64",
                                        "ion_display_position": "80",
                                        "spec_id": "271",
                                        "peak_id": "60",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "79",
                                        "spec_id": "271",
                                        "peak_id": "47",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "75",
                                        "spec_id": "271",
                                        "peak_id": "72",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "84",
                                        "ion_display_position": "60",
                                        "spec_id": "271",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "94",
                                            "ion_display_position": "50",
                                            "spec_id": "271",
                                            "peak_id": "53",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "94",
                                            "ion_display_position": "50",
                                            "spec_id": "271",
                                            "peak_id": "110",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "spec_id": "271",
                                        "peak_id": "26",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "106",
                                        "ion_display_position": "38",
                                        "spec_id": "271",
                                        "peak_id": "49",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "117",
                                        "ion_display_position": "27",
                                        "spec_id": "271",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "spec_id": "271",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "137",
                                "right_pos": "138",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "119",
                            "right_position": "144",
                            "shift": "248.0741563914",
                            "anno": "+248.0742",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "159",
                "p_value": "1.12e-12",
                "e_value": "1.12e-12",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "625",
                        "ms1_scans": "964",
                        "ids": "339",
                        "scans": "966",
                        "precursor_mono_mass": "16310.4818",
                        "precursor_charge": "7",
                        "precursor_mz": "2331.0761",
                        "feature_inte": "1.9519e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "339",
                                "peak_id": "0",
                                "monoisotopic_mass": "3646.8718",
                                "monoisotopic_mz": "1824.4432",
                                "intensity": "15487.29",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3646.8512",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0205",
                                        "ppm": "5.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "1",
                                "monoisotopic_mass": "2064.0594",
                                "monoisotopic_mz": "2065.0667",
                                "intensity": "2128.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "2",
                                "monoisotopic_mass": "1467.7839",
                                "monoisotopic_mz": "1468.7911",
                                "intensity": "18129.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1467.7756",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0083",
                                        "ppm": "5.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "3",
                                "monoisotopic_mass": "1864.0261",
                                "monoisotopic_mz": "1865.0334",
                                "intensity": "1281.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "4",
                                "monoisotopic_mass": "1152.6385",
                                "monoisotopic_mz": "1153.6458",
                                "intensity": "19704.59",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1152.6325",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "B00010",
                                        "ion_left_position": "10",
                                        "mass_error": "0.0060",
                                        "ppm": "5.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "5",
                                "monoisotopic_mass": "3531.8447",
                                "monoisotopic_mz": "1766.9296",
                                "intensity": "12839.09",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3531.8243",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0204",
                                        "ppm": "5.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "6",
                                "monoisotopic_mass": "1416.6545",
                                "monoisotopic_mz": "1417.6617",
                                "intensity": "1376.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "7",
                                "monoisotopic_mass": "3628.8571",
                                "monoisotopic_mz": "1815.4358",
                                "intensity": "3404.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "8",
                                "monoisotopic_mass": "2493.2177",
                                "monoisotopic_mz": "2494.2250",
                                "intensity": "1632.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "9",
                                "monoisotopic_mass": "827.4730",
                                "monoisotopic_mz": "828.4803",
                                "intensity": "2172.43",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "827.4687",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "B00007",
                                        "ion_left_position": "7",
                                        "mass_error": "0.0043",
                                        "ppm": "5.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "10",
                                "monoisotopic_mass": "799.4778",
                                "monoisotopic_mz": "800.4850",
                                "intensity": "635.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "11",
                                "monoisotopic_mass": "728.4033",
                                "monoisotopic_mz": "729.4106",
                                "intensity": "886.24",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "728.4003",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "B00006",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0030",
                                        "ppm": "4.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "12",
                                "monoisotopic_mass": "4543.3415",
                                "monoisotopic_mz": "1515.4544",
                                "intensity": "3544.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4543.3268",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0146",
                                        "ppm": "3.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "13",
                                "monoisotopic_mass": "715.3169",
                                "monoisotopic_mz": "716.3242",
                                "intensity": "1213.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "14",
                                "monoisotopic_mass": "2946.5233",
                                "monoisotopic_mz": "1474.2689",
                                "intensity": "5402.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "2946.5323",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "Y00025",
                                        "ion_left_position": "119",
                                        "mass_error": "-0.0090",
                                        "ppm": "-3.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "15",
                                "monoisotopic_mass": "5449.9877",
                                "monoisotopic_mz": "1363.5042",
                                "intensity": "6063.21",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "5449.9896",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "97",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "16",
                                "monoisotopic_mass": "4525.3364",
                                "monoisotopic_mz": "1509.4527",
                                "intensity": "3137.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "17",
                                "monoisotopic_mass": "9330.1188",
                                "monoisotopic_mz": "1867.0310",
                                "intensity": "4548.34",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "9330.1107",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "Y00081",
                                        "ion_left_position": "63",
                                        "mass_error": "0.0081",
                                        "ppm": "0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "18",
                                "monoisotopic_mass": "4426.2770",
                                "monoisotopic_mz": "1476.4330",
                                "intensity": "2495.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "19",
                                "monoisotopic_mass": "4628.4257",
                                "monoisotopic_mz": "2315.2201",
                                "intensity": "2319.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "20",
                                "monoisotopic_mass": "5110.9290",
                                "monoisotopic_mz": "1704.6503",
                                "intensity": "2077.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "21",
                                "monoisotopic_mass": "2673.4230",
                                "monoisotopic_mz": "1337.7188",
                                "intensity": "2369.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "22",
                                "monoisotopic_mass": "2846.5150",
                                "monoisotopic_mz": "1424.2648",
                                "intensity": "2786.09",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2846.4960",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0190",
                                        "ppm": "6.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "23",
                                "monoisotopic_mass": "3514.8209",
                                "monoisotopic_mz": "1758.4177",
                                "intensity": "1567.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "24",
                                "monoisotopic_mass": "1130.0771",
                                "monoisotopic_mz": "1131.0843",
                                "intensity": "626.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "25",
                                "monoisotopic_mass": "2817.4826",
                                "monoisotopic_mz": "1409.7486",
                                "intensity": "1801.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "26",
                                "monoisotopic_mass": "1009.5642",
                                "monoisotopic_mz": "1010.5715",
                                "intensity": "893.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "27",
                                "monoisotopic_mass": "878.4690",
                                "monoisotopic_mz": "879.4763",
                                "intensity": "1001.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "28",
                                "monoisotopic_mass": "9427.1287",
                                "monoisotopic_mz": "1886.4330",
                                "intensity": "2444.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "29",
                                "monoisotopic_mass": "2884.4926",
                                "monoisotopic_mz": "1443.2536",
                                "intensity": "1324.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "30",
                                "monoisotopic_mass": "3847.9544",
                                "monoisotopic_mz": "1924.9845",
                                "intensity": "2687.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "31",
                                "monoisotopic_mass": "4082.0741",
                                "monoisotopic_mz": "1361.6986",
                                "intensity": "2289.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "32",
                                "monoisotopic_mass": "5431.9823",
                                "monoisotopic_mz": "1359.0028",
                                "intensity": "2714.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "33",
                                "monoisotopic_mass": "4656.4318",
                                "monoisotopic_mz": "1553.1512",
                                "intensity": "4499.63",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4656.4109",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0209",
                                        "ppm": "4.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "34",
                                "monoisotopic_mass": "2379.2995",
                                "monoisotopic_mz": "2380.3068",
                                "intensity": "1247.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "35",
                                "monoisotopic_mass": "1915.0467",
                                "monoisotopic_mz": "1916.0540",
                                "intensity": "790.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "36",
                                "monoisotopic_mass": "5935.2210",
                                "monoisotopic_mz": "1484.8125",
                                "intensity": "4052.98",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "5934.2178",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "92",
                                        "mass_error": "0.0008",
                                        "ppm": "0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "37",
                                "monoisotopic_mass": "3451.8768",
                                "monoisotopic_mz": "1726.9457",
                                "intensity": "1688.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "38",
                                "monoisotopic_mass": "4580.5371",
                                "monoisotopic_mz": "2291.2758",
                                "intensity": "692.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "39",
                                "monoisotopic_mass": "9445.1388",
                                "monoisotopic_mz": "1890.0350",
                                "intensity": "2566.64",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "9445.1376",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "ion_sort_name": "Y00082",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0011",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "40",
                                "monoisotopic_mass": "4230.1475",
                                "monoisotopic_mz": "1411.0564",
                                "intensity": "631.21",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4230.1267",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "ion_sort_name": "B00037",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0208",
                                        "ppm": "4.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "41",
                                "monoisotopic_mass": "4937.6359",
                                "monoisotopic_mz": "1646.8859",
                                "intensity": "538.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "42",
                                "monoisotopic_mass": "5450.9914",
                                "monoisotopic_mz": "1818.0044",
                                "intensity": "2719.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "248.0734363914",
                                        "theoretical_mass": "5449.9896",
                                        "ion_position": "97",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "97",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "43",
                                "monoisotopic_mass": "6615.6622",
                                "monoisotopic_mz": "1654.9228",
                                "intensity": "746.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "44",
                                "monoisotopic_mass": "4610.4442",
                                "monoisotopic_mz": "2306.2294",
                                "intensity": "1249.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "45",
                                "monoisotopic_mass": "4559.1694",
                                "monoisotopic_mz": "2280.5920",
                                "intensity": "1357.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "46",
                                "monoisotopic_mass": "9026.9501",
                                "monoisotopic_mz": "2257.7448",
                                "intensity": "1403.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "47",
                                "monoisotopic_mass": "16019.5048",
                                "monoisotopic_mz": "2289.5080",
                                "intensity": "7135.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "48",
                                "monoisotopic_mass": "9907.2529",
                                "monoisotopic_mz": "1652.2161",
                                "intensity": "495.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "49",
                                "monoisotopic_mass": "1552.3002",
                                "monoisotopic_mz": "1553.3075",
                                "intensity": "1491.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "50",
                                "monoisotopic_mass": "4543.9960",
                                "monoisotopic_mz": "2273.0053",
                                "intensity": "1123.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "51",
                                "monoisotopic_mass": "16278.5496",
                                "monoisotopic_mz": "2326.5144",
                                "intensity": "2685.56",
                                "charge": "7"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "52",
                                "monoisotopic_mass": "4503.4737",
                                "monoisotopic_mz": "2252.7441",
                                "intensity": "685.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "53",
                                "monoisotopic_mass": "16003.5224",
                                "monoisotopic_mz": "2287.2248",
                                "intensity": "5336.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "54",
                                "monoisotopic_mass": "2285.7782",
                                "monoisotopic_mz": "2286.7854",
                                "intensity": "2194.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "339",
                                "peak_id": "55",
                                "monoisotopic_mass": "2326.5164",
                                "monoisotopic_mz": "2327.5237",
                                "intensity": "2817.30",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "11",
                    "proteoform_id": "12",
                    "sequence_name": "sp|P37903|USPF_ECOLI",
                    "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                    "proteoform_mass": "16311.6091",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "144",
                        "first_residue_position": "0",
                        "last_residue_position": "143",
                        "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0734].",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "R"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "I"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "P"
                            },
                            {
                                "position": "8",
                                "acid": "I"
                            },
                            {
                                "position": "9",
                                "acid": "D"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "S"
                            },
                            {
                                "position": "12",
                                "acid": "D"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "T"
                            },
                            {
                                "position": "17",
                                "acid": "Q"
                            },
                            {
                                "position": "18",
                                "acid": "R"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "I"
                            },
                            {
                                "position": "21",
                                "acid": "S"
                            },
                            {
                                "position": "22",
                                "acid": "H"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "E"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "E"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "I"
                            },
                            {
                                "position": "30",
                                "acid": "D"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "A"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "H"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "T"
                            },
                            {
                                "position": "39",
                                "acid": "V"
                            },
                            {
                                "position": "40",
                                "acid": "I"
                            },
                            {
                                "position": "41",
                                "acid": "P"
                            },
                            {
                                "position": "42",
                                "acid": "S"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "P"
                            },
                            {
                                "position": "45",
                                "acid": "Y"
                            },
                            {
                                "position": "46",
                                "acid": "Y"
                            },
                            {
                                "position": "47",
                                "acid": "A"
                            },
                            {
                                "position": "48",
                                "acid": "S"
                            },
                            {
                                "position": "49",
                                "acid": "L"
                            },
                            {
                                "position": "50",
                                "acid": "G"
                            },
                            {
                                "position": "51",
                                "acid": "L"
                            },
                            {
                                "position": "52",
                                "acid": "A"
                            },
                            {
                                "position": "53",
                                "acid": "Y"
                            },
                            {
                                "position": "54",
                                "acid": "S"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "P"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "M"
                            },
                            {
                                "position": "61",
                                "acid": "D"
                            },
                            {
                                "position": "62",
                                "acid": "D"
                            },
                            {
                                "position": "63",
                                "acid": "L"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "E"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "S"
                            },
                            {
                                "position": "70",
                                "acid": "Q"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "E"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "I"
                            },
                            {
                                "position": "75",
                                "acid": "I"
                            },
                            {
                                "position": "76",
                                "acid": "K"
                            },
                            {
                                "position": "77",
                                "acid": "K"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "K"
                            },
                            {
                                "position": "80",
                                "acid": "L"
                            },
                            {
                                "position": "81",
                                "acid": "P"
                            },
                            {
                                "position": "82",
                                "acid": "T"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "R"
                            },
                            {
                                "position": "85",
                                "acid": "V"
                            },
                            {
                                "position": "86",
                                "acid": "H"
                            },
                            {
                                "position": "87",
                                "acid": "V"
                            },
                            {
                                "position": "88",
                                "acid": "H"
                            },
                            {
                                "position": "89",
                                "acid": "V"
                            },
                            {
                                "position": "90",
                                "acid": "E"
                            },
                            {
                                "position": "91",
                                "acid": "E"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "S"
                            },
                            {
                                "position": "94",
                                "acid": "P"
                            },
                            {
                                "position": "95",
                                "acid": "K"
                            },
                            {
                                "position": "96",
                                "acid": "D"
                            },
                            {
                                "position": "97",
                                "acid": "R"
                            },
                            {
                                "position": "98",
                                "acid": "I"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "E"
                            },
                            {
                                "position": "101",
                                "acid": "L"
                            },
                            {
                                "position": "102",
                                "acid": "A"
                            },
                            {
                                "position": "103",
                                "acid": "K"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "I"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "A"
                            },
                            {
                                "position": "108",
                                "acid": "H"
                            },
                            {
                                "position": "109",
                                "acid": "M"
                            },
                            {
                                "position": "110",
                                "acid": "I"
                            },
                            {
                                "position": "111",
                                "acid": "I"
                            },
                            {
                                "position": "112",
                                "acid": "I"
                            },
                            {
                                "position": "113",
                                "acid": "A"
                            },
                            {
                                "position": "114",
                                "acid": "S"
                            },
                            {
                                "position": "115",
                                "acid": "H"
                            },
                            {
                                "position": "116",
                                "acid": "R"
                            },
                            {
                                "position": "117",
                                "acid": "P"
                            },
                            {
                                "position": "118",
                                "acid": "D"
                            },
                            {
                                "position": "119",
                                "acid": "I"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "T"
                            },
                            {
                                "position": "122",
                                "acid": "Y"
                            },
                            {
                                "position": "123",
                                "acid": "L"
                            },
                            {
                                "position": "124",
                                "acid": "L"
                            },
                            {
                                "position": "125",
                                "acid": "G"
                            },
                            {
                                "position": "126",
                                "acid": "S"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "A"
                            },
                            {
                                "position": "129",
                                "acid": "A"
                            },
                            {
                                "position": "130",
                                "acid": "A"
                            },
                            {
                                "position": "131",
                                "acid": "V"
                            },
                            {
                                "position": "132",
                                "acid": "V"
                            },
                            {
                                "position": "133",
                                "acid": "R"
                            },
                            {
                                "position": "134",
                                "acid": "H"
                            },
                            {
                                "position": "135",
                                "acid": "A"
                            },
                            {
                                "position": "136",
                                "acid": "E"
                            },
                            {
                                "position": "137",
                                "acid": "C"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "V"
                            },
                            {
                                "position": "140",
                                "acid": "L"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "R"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "6",
                                        "ion_display_position": "6",
                                        "spec_id": "339",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "7",
                                        "ion_display_position": "7",
                                        "spec_id": "339",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "10",
                                        "ion_display_position": "10",
                                        "spec_id": "339",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "339",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "339",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "339",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "339",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "37",
                                        "ion_display_position": "37",
                                        "spec_id": "339",
                                        "peak_id": "40",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "339",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "339",
                                        "peak_id": "33",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "62",
                                        "ion_display_position": "82",
                                        "spec_id": "339",
                                        "peak_id": "39",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "63",
                                        "ion_display_position": "81",
                                        "spec_id": "339",
                                        "peak_id": "17",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "92",
                                        "ion_display_position": "52",
                                        "spec_id": "339",
                                        "peak_id": "36",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "97",
                                            "ion_display_position": "47",
                                            "spec_id": "339",
                                            "peak_id": "15",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "97",
                                            "ion_display_position": "47",
                                            "spec_id": "339",
                                            "peak_id": "42",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "119",
                                        "ion_display_position": "25",
                                        "spec_id": "339",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": {
                                "left_pos": "137",
                                "right_pos": "138",
                                "anno": "C"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "119",
                            "right_position": "144",
                            "shift": "248.0734363914",
                            "anno": "+248.0734",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        ]
    }
}
