prsm_data =
{
    "protein": {
        "sequence_id": "37",
        "sequence_name": "sp|P39172|ZNUA_ECOLI",
        "sequence_description": "High-affinity zinc uptake system protein ZnuA OS=Escherichia coli (strain K12) OX=83333 GN=znuA PE=1 SV=4",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "37",
            "sequence_name": "sp|P39172|ZNUA_ECOLI",
            "sequence_description": "High-affinity zinc uptake system protein ZnuA OS=Escherichia coli (strain K12) OX=83333 GN=znuA PE=1 SV=4",
            "proteoform_id": "19",
            "prsm_number": "1",
            "prsm": {
                "prsm_id": "112",
                "p_value": "0.67",
                "e_value": "1.01",
                "fdr": "5.71e-03",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                        "ms1_ids": "599",
                        "ms1_scans": "861",
                        "ids": "263",
                        "scans": "864",
                        "precursor_mono_mass": "8592.5331",
                        "precursor_charge": "7",
                        "precursor_mz": "1228.5120",
                        "feature_inte": "1.7743e+07"
                    }
                },
                "annotated_protein": {
                    "sequence_id": "37",
                    "proteoform_id": "19",
                    "sequence_name": "sp|P39172|ZNUA_ECOLI",
                    "sequence_description": "High-affinity zinc uptake system protein ZnuA OS=Escherichia coli (strain K12) OX=83333 GN=znuA PE=1 SV=4",
                    "proteoform_mass": "8593.5504",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "310",
                        "first_residue_position": "233",
                        "last_residue_position": "309",
                        "annotated_seq": "P.GAQRLHEIRTQLVEQKAT(C)[Carbamidomethylation]VFAEPQFRPAVVESVARGTSVRMGTLDPLGTNIKLGKTSYSEFLSQL(ANQYAS(C)[Carbamidomethylation])[+71.1814]LKGD.",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "L"
                            },
                            {
                                "position": "2",
                                "acid": "H"
                            },
                            {
                                "position": "3",
                                "acid": "K"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "T"
                            },
                            {
                                "position": "6",
                                "acid": "L"
                            },
                            {
                                "position": "7",
                                "acid": "L"
                            },
                            {
                                "position": "8",
                                "acid": "F"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "L"
                            },
                            {
                                "position": "12",
                                "acid": "S"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "W"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "Q"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "A"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "V"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "L"
                            },
                            {
                                "position": "32",
                                "acid": "K"
                            },
                            {
                                "position": "33",
                                "acid": "P"
                            },
                            {
                                "position": "34",
                                "acid": "V"
                            },
                            {
                                "position": "35",
                                "acid": "G"
                            },
                            {
                                "position": "36",
                                "acid": "F"
                            },
                            {
                                "position": "37",
                                "acid": "I"
                            },
                            {
                                "position": "38",
                                "acid": "A"
                            },
                            {
                                "position": "39",
                                "acid": "S"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "I"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "G"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "T"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "V"
                            },
                            {
                                "position": "51",
                                "acid": "L"
                            },
                            {
                                "position": "52",
                                "acid": "L"
                            },
                            {
                                "position": "53",
                                "acid": "P"
                            },
                            {
                                "position": "54",
                                "acid": "D"
                            },
                            {
                                "position": "55",
                                "acid": "G"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "S"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "H"
                            },
                            {
                                "position": "60",
                                "acid": "D"
                            },
                            {
                                "position": "61",
                                "acid": "Y"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "L"
                            },
                            {
                                "position": "64",
                                "acid": "R"
                            },
                            {
                                "position": "65",
                                "acid": "P"
                            },
                            {
                                "position": "66",
                                "acid": "S"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "V"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "R"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "Q"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "V"
                            },
                            {
                                "position": "78",
                                "acid": "V"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "V"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "P"
                            },
                            {
                                "position": "83",
                                "acid": "E"
                            },
                            {
                                "position": "84",
                                "acid": "M"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "A"
                            },
                            {
                                "position": "87",
                                "acid": "F"
                            },
                            {
                                "position": "88",
                                "acid": "M"
                            },
                            {
                                "position": "89",
                                "acid": "Q"
                            },
                            {
                                "position": "90",
                                "acid": "K"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "V"
                            },
                            {
                                "position": "93",
                                "acid": "S"
                            },
                            {
                                "position": "94",
                                "acid": "K"
                            },
                            {
                                "position": "95",
                                "acid": "L"
                            },
                            {
                                "position": "96",
                                "acid": "P"
                            },
                            {
                                "position": "97",
                                "acid": "G"
                            },
                            {
                                "position": "98",
                                "acid": "A"
                            },
                            {
                                "position": "99",
                                "acid": "K"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "V"
                            },
                            {
                                "position": "102",
                                "acid": "T"
                            },
                            {
                                "position": "103",
                                "acid": "I"
                            },
                            {
                                "position": "104",
                                "acid": "A"
                            },
                            {
                                "position": "105",
                                "acid": "Q"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "E"
                            },
                            {
                                "position": "108",
                                "acid": "D"
                            },
                            {
                                "position": "109",
                                "acid": "V"
                            },
                            {
                                "position": "110",
                                "acid": "K"
                            },
                            {
                                "position": "111",
                                "acid": "P"
                            },
                            {
                                "position": "112",
                                "acid": "L"
                            },
                            {
                                "position": "113",
                                "acid": "L"
                            },
                            {
                                "position": "114",
                                "acid": "M"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "S"
                            },
                            {
                                "position": "117",
                                "acid": "I"
                            },
                            {
                                "position": "118",
                                "acid": "H"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "D"
                            },
                            {
                                "position": "121",
                                "acid": "D"
                            },
                            {
                                "position": "122",
                                "acid": "D"
                            },
                            {
                                "position": "123",
                                "acid": "D"
                            },
                            {
                                "position": "124",
                                "acid": "H"
                            },
                            {
                                "position": "125",
                                "acid": "D"
                            },
                            {
                                "position": "126",
                                "acid": "H"
                            },
                            {
                                "position": "127",
                                "acid": "A"
                            },
                            {
                                "position": "128",
                                "acid": "E"
                            },
                            {
                                "position": "129",
                                "acid": "K"
                            },
                            {
                                "position": "130",
                                "acid": "S"
                            },
                            {
                                "position": "131",
                                "acid": "D"
                            },
                            {
                                "position": "132",
                                "acid": "E"
                            },
                            {
                                "position": "133",
                                "acid": "D"
                            },
                            {
                                "position": "134",
                                "acid": "H"
                            },
                            {
                                "position": "135",
                                "acid": "H"
                            },
                            {
                                "position": "136",
                                "acid": "H"
                            },
                            {
                                "position": "137",
                                "acid": "G"
                            },
                            {
                                "position": "138",
                                "acid": "D"
                            },
                            {
                                "position": "139",
                                "acid": "F"
                            },
                            {
                                "position": "140",
                                "acid": "N"
                            },
                            {
                                "position": "141",
                                "acid": "M"
                            },
                            {
                                "position": "142",
                                "acid": "H"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "W"
                            },
                            {
                                "position": "145",
                                "acid": "L"
                            },
                            {
                                "position": "146",
                                "acid": "S"
                            },
                            {
                                "position": "147",
                                "acid": "P"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            },
                            {
                                "position": "149",
                                "acid": "I"
                            },
                            {
                                "position": "150",
                                "acid": "A"
                            },
                            {
                                "position": "151",
                                "acid": "R"
                            },
                            {
                                "position": "152",
                                "acid": "A"
                            },
                            {
                                "position": "153",
                                "acid": "T"
                            },
                            {
                                "position": "154",
                                "acid": "A"
                            },
                            {
                                "position": "155",
                                "acid": "V"
                            },
                            {
                                "position": "156",
                                "acid": "A"
                            },
                            {
                                "position": "157",
                                "acid": "I"
                            },
                            {
                                "position": "158",
                                "acid": "H"
                            },
                            {
                                "position": "159",
                                "acid": "G"
                            },
                            {
                                "position": "160",
                                "acid": "K"
                            },
                            {
                                "position": "161",
                                "acid": "L"
                            },
                            {
                                "position": "162",
                                "acid": "V"
                            },
                            {
                                "position": "163",
                                "acid": "E"
                            },
                            {
                                "position": "164",
                                "acid": "L"
                            },
                            {
                                "position": "165",
                                "acid": "M"
                            },
                            {
                                "position": "166",
                                "acid": "P"
                            },
                            {
                                "position": "167",
                                "acid": "Q"
                            },
                            {
                                "position": "168",
                                "acid": "S"
                            },
                            {
                                "position": "169",
                                "acid": "R"
                            },
                            {
                                "position": "170",
                                "acid": "A"
                            },
                            {
                                "position": "171",
                                "acid": "K"
                            },
                            {
                                "position": "172",
                                "acid": "L"
                            },
                            {
                                "position": "173",
                                "acid": "D"
                            },
                            {
                                "position": "174",
                                "acid": "A"
                            },
                            {
                                "position": "175",
                                "acid": "N"
                            },
                            {
                                "position": "176",
                                "acid": "L"
                            },
                            {
                                "position": "177",
                                "acid": "K"
                            },
                            {
                                "position": "178",
                                "acid": "D"
                            },
                            {
                                "position": "179",
                                "acid": "F"
                            },
                            {
                                "position": "180",
                                "acid": "E"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "Q"
                            },
                            {
                                "position": "183",
                                "acid": "L"
                            },
                            {
                                "position": "184",
                                "acid": "A"
                            },
                            {
                                "position": "185",
                                "acid": "S"
                            },
                            {
                                "position": "186",
                                "acid": "T"
                            },
                            {
                                "position": "187",
                                "acid": "E"
                            },
                            {
                                "position": "188",
                                "acid": "T"
                            },
                            {
                                "position": "189",
                                "acid": "Q"
                            },
                            {
                                "position": "190",
                                "acid": "V"
                            },
                            {
                                "position": "191",
                                "acid": "G"
                            },
                            {
                                "position": "192",
                                "acid": "N"
                            },
                            {
                                "position": "193",
                                "acid": "E"
                            },
                            {
                                "position": "194",
                                "acid": "L"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "P"
                            },
                            {
                                "position": "197",
                                "acid": "L"
                            },
                            {
                                "position": "198",
                                "acid": "K"
                            },
                            {
                                "position": "199",
                                "acid": "G"
                            },
                            {
                                "position": "200",
                                "acid": "K"
                            },
                            {
                                "position": "201",
                                "acid": "G"
                            },
                            {
                                "position": "202",
                                "acid": "Y"
                            },
                            {
                                "position": "203",
                                "acid": "F"
                            },
                            {
                                "position": "204",
                                "acid": "V"
                            },
                            {
                                "position": "205",
                                "acid": "F"
                            },
                            {
                                "position": "206",
                                "acid": "H"
                            },
                            {
                                "position": "207",
                                "acid": "D"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            },
                            {
                                "position": "209",
                                "acid": "Y"
                            },
                            {
                                "position": "210",
                                "acid": "G"
                            },
                            {
                                "position": "211",
                                "acid": "Y"
                            },
                            {
                                "position": "212",
                                "acid": "F"
                            },
                            {
                                "position": "213",
                                "acid": "E"
                            },
                            {
                                "position": "214",
                                "acid": "K"
                            },
                            {
                                "position": "215",
                                "acid": "Q"
                            },
                            {
                                "position": "216",
                                "acid": "F"
                            },
                            {
                                "position": "217",
                                "acid": "G"
                            },
                            {
                                "position": "218",
                                "acid": "L"
                            },
                            {
                                "position": "219",
                                "acid": "T"
                            },
                            {
                                "position": "220",
                                "acid": "P"
                            },
                            {
                                "position": "221",
                                "acid": "L"
                            },
                            {
                                "position": "222",
                                "acid": "G"
                            },
                            {
                                "position": "223",
                                "acid": "H"
                            },
                            {
                                "position": "224",
                                "acid": "F"
                            },
                            {
                                "position": "225",
                                "acid": "T"
                            },
                            {
                                "position": "226",
                                "acid": "V"
                            },
                            {
                                "position": "227",
                                "acid": "N"
                            },
                            {
                                "position": "228",
                                "acid": "P"
                            },
                            {
                                "position": "229",
                                "acid": "E"
                            },
                            {
                                "position": "230",
                                "acid": "I"
                            },
                            {
                                "position": "231",
                                "acid": "Q"
                            },
                            {
                                "position": "232",
                                "acid": "P"
                            },
                            {
                                "position": "233",
                                "acid": "G"
                            },
                            {
                                "position": "234",
                                "acid": "A"
                            },
                            {
                                "position": "235",
                                "acid": "Q"
                            },
                            {
                                "position": "236",
                                "acid": "R"
                            },
                            {
                                "position": "237",
                                "acid": "L"
                            },
                            {
                                "position": "238",
                                "acid": "H"
                            },
                            {
                                "position": "239",
                                "acid": "E"
                            },
                            {
                                "position": "240",
                                "acid": "I"
                            },
                            {
                                "position": "241",
                                "acid": "R"
                            },
                            {
                                "position": "242",
                                "acid": "T"
                            },
                            {
                                "position": "243",
                                "acid": "Q"
                            },
                            {
                                "position": "244",
                                "acid": "L"
                            },
                            {
                                "position": "245",
                                "acid": "V"
                            },
                            {
                                "position": "246",
                                "acid": "E"
                            },
                            {
                                "position": "247",
                                "acid": "Q"
                            },
                            {
                                "position": "248",
                                "acid": "K"
                            },
                            {
                                "position": "249",
                                "acid": "A"
                            },
                            {
                                "position": "250",
                                "acid": "T"
                            },
                            {
                                "position": "251",
                                "acid": "C"
                            },
                            {
                                "position": "252",
                                "acid": "V"
                            },
                            {
                                "position": "253",
                                "acid": "F"
                            },
                            {
                                "position": "254",
                                "acid": "A"
                            },
                            {
                                "position": "255",
                                "acid": "E"
                            },
                            {
                                "position": "256",
                                "acid": "P"
                            },
                            {
                                "position": "257",
                                "acid": "Q"
                            },
                            {
                                "position": "258",
                                "acid": "F"
                            },
                            {
                                "position": "259",
                                "acid": "R"
                            },
                            {
                                "position": "260",
                                "acid": "P"
                            },
                            {
                                "position": "261",
                                "acid": "A"
                            },
                            {
                                "position": "262",
                                "acid": "V"
                            },
                            {
                                "position": "263",
                                "acid": "V"
                            },
                            {
                                "position": "264",
                                "acid": "E"
                            },
                            {
                                "position": "265",
                                "acid": "S"
                            },
                            {
                                "position": "266",
                                "acid": "V"
                            },
                            {
                                "position": "267",
                                "acid": "A"
                            },
                            {
                                "position": "268",
                                "acid": "R"
                            },
                            {
                                "position": "269",
                                "acid": "G"
                            },
                            {
                                "position": "270",
                                "acid": "T"
                            },
                            {
                                "position": "271",
                                "acid": "S"
                            },
                            {
                                "position": "272",
                                "acid": "V"
                            },
                            {
                                "position": "273",
                                "acid": "R"
                            },
                            {
                                "position": "274",
                                "acid": "M"
                            },
                            {
                                "position": "275",
                                "acid": "G"
                            },
                            {
                                "position": "276",
                                "acid": "T"
                            },
                            {
                                "position": "277",
                                "acid": "L"
                            },
                            {
                                "position": "278",
                                "acid": "D"
                            },
                            {
                                "position": "279",
                                "acid": "P"
                            },
                            {
                                "position": "280",
                                "acid": "L"
                            },
                            {
                                "position": "281",
                                "acid": "G"
                            },
                            {
                                "position": "282",
                                "acid": "T"
                            },
                            {
                                "position": "283",
                                "acid": "N"
                            },
                            {
                                "position": "284",
                                "acid": "I"
                            },
                            {
                                "position": "285",
                                "acid": "K"
                            },
                            {
                                "position": "286",
                                "acid": "L"
                            },
                            {
                                "position": "287",
                                "acid": "G"
                            },
                            {
                                "position": "288",
                                "acid": "K"
                            },
                            {
                                "position": "289",
                                "acid": "T"
                            },
                            {
                                "position": "290",
                                "acid": "S"
                            },
                            {
                                "position": "291",
                                "acid": "Y"
                            },
                            {
                                "position": "292",
                                "acid": "S"
                            },
                            {
                                "position": "293",
                                "acid": "E"
                            },
                            {
                                "position": "294",
                                "acid": "F"
                            },
                            {
                                "position": "295",
                                "acid": "L"
                            },
                            {
                                "position": "296",
                                "acid": "S"
                            },
                            {
                                "position": "297",
                                "acid": "Q"
                            },
                            {
                                "position": "298",
                                "acid": "L"
                            },
                            {
                                "position": "299",
                                "acid": "A"
                            },
                            {
                                "position": "300",
                                "acid": "N"
                            },
                            {
                                "position": "301",
                                "acid": "Q"
                            },
                            {
                                "position": "302",
                                "acid": "Y"
                            },
                            {
                                "position": "303",
                                "acid": "A"
                            },
                            {
                                "position": "304",
                                "acid": "S"
                            },
                            {
                                "position": "305",
                                "acid": "C"
                            },
                            {
                                "position": "306",
                                "acid": "L"
                            },
                            {
                                "position": "307",
                                "acid": "K"
                            },
                            {
                                "position": "308",
                                "acid": "G"
                            },
                            {
                                "position": "309",
                                "acid": "D"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "210",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "211",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "212",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "213",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "214",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "215",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "216",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "217",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "218",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "219",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "220",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "221",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "222",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "223",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "224",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "225",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "226",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "227",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "228",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "229",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "230",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "231",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "232",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "233",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "234",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "235",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "236",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "237",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "73",
                                        "spec_id": "263",
                                        "peak_id": "49",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "238",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "239",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "240",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "241",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "242",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "243",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "67",
                                        "spec_id": "263",
                                        "peak_id": "72",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "244",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "245",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "12",
                                        "ion_display_position": "65",
                                        "spec_id": "263",
                                        "peak_id": "59",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "246",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "247",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "248",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "15",
                                        "ion_display_position": "62",
                                        "spec_id": "263",
                                        "peak_id": "26",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "249",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "250",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "251",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "252",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "253",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "254",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "255",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "256",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "257",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "258",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "259",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "260",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "261",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "262",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "263",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "264",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "31",
                                        "ion_display_position": "46",
                                        "spec_id": "263",
                                        "peak_id": "83",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "265",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "266",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "267",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "268",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "269",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "270",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "271",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "272",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "273",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "274",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "275",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "276",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "277",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "278",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "263",
                                        "peak_id": "28",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "279",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "280",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "263",
                                        "peak_id": "61",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "281",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "282",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "283",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "284",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "285",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "286",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "287",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "288",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "289",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "290",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "291",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "292",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "293",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "294",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "295",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "296",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "297",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "298",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "299",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "263",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "300",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "301",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "302",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "303",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "304",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "305",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "306",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "263",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "307",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "308",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "309",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "310",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "251",
                                    "right_pos": "252",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "305",
                                    "right_pos": "306",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "299",
                            "right_position": "306",
                            "shift": "71.1814382258",
                            "anno": "+71.1814",
                            "shift_type": "unexpected"
                        }
                    }
                }
            }
        }
    }
}
