prsm_data =
{
    "protein": {
        "sequence_id": "22",
        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
        "compatible_proteoform_number": "10",
        "compatible_proteoform": [
            {
                "sequence_id": "22",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_id": "28",
                "prsm_number": "16",
                "prsm": [
                    {
                        "prsm_id": "175",
                        "p_value": "2.40e-12",
                        "e_value": "2.40e-12",
                        "fdr": "0",
                        "matched_fragment_number": "24",
                        "matched_peak_number": "29",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "633",
                                "ms1_scans": "996",
                                "ids": "362",
                                "scans": "997",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "9",
                                "precursor_mz": "1150.4502",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEAL)[+496.3199]NNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "362",
                                                "peak_id": "80",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "362",
                                                "peak_id": "71",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "362",
                                                "peak_id": "39",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "362",
                                                    "peak_id": "81",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "362",
                                                    "peak_id": "31",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "362",
                                                "peak_id": "61",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "362",
                                                "peak_id": "56",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "362",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "362",
                                                "peak_id": "37",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "362",
                                                "peak_id": "140",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "39",
                                                "ion_display_position": "50",
                                                "spec_id": "362",
                                                "peak_id": "158",
                                                "peak_charge": "6"
                                            }
                                        }
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "362",
                                                "peak_id": "100",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "362",
                                                    "peak_id": "6",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "362",
                                                    "peak_id": "59",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "362",
                                                "peak_id": "78",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "362",
                                                "peak_id": "42",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "362",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "73",
                                                    "ion_display_position": "16",
                                                    "spec_id": "362",
                                                    "peak_id": "38",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "73",
                                                    "ion_display_position": "16",
                                                    "spec_id": "362",
                                                    "peak_id": "167",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "362",
                                                "peak_id": "28",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "362",
                                                "peak_id": "29",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "362",
                                                    "peak_id": "13",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "362",
                                                    "peak_id": "109",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "362",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "78",
                                                    "ion_display_position": "11",
                                                    "spec_id": "362",
                                                    "peak_id": "33",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "78",
                                                    "ion_display_position": "11",
                                                    "spec_id": "362",
                                                    "peak_id": "70",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "362",
                                                "peak_id": "47",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "362",
                                                "peak_id": "62",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "6",
                                                "spec_id": "362",
                                                "peak_id": "60",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "60",
                                    "shift": "496.3198835793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "151",
                        "p_value": "2.73e-12",
                        "e_value": "2.73e-12",
                        "fdr": "0",
                        "matched_fragment_number": "24",
                        "matched_peak_number": "27",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "622",
                                "ms1_scans": "952",
                                "ids": "329",
                                "scans": "953",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "9",
                                "precursor_mz": "1150.4502",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "329",
                                                "peak_id": "71",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "329",
                                                "peak_id": "69",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "329",
                                                "peak_id": "66",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "329",
                                                "peak_id": "55",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "329",
                                                    "peak_id": "78",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "329",
                                                    "peak_id": "33",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "329",
                                                "peak_id": "60",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "329",
                                                "peak_id": "37",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "329",
                                                "peak_id": "115",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "329",
                                                "peak_id": "106",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "329",
                                                "peak_id": "108",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "329",
                                                    "peak_id": "13",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "329",
                                                    "peak_id": "43",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "329",
                                                "peak_id": "63",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "329",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "329",
                                                "peak_id": "4",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "16",
                                                "spec_id": "329",
                                                "peak_id": "2",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "329",
                                                "peak_id": "68",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "329",
                                                "peak_id": "17",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "329",
                                                    "peak_id": "21",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "329",
                                                    "peak_id": "103",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "329",
                                                "peak_id": "20",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "329",
                                                "peak_id": "24",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "329",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "329",
                                                "peak_id": "41",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "6",
                                                "spec_id": "329",
                                                "peak_id": "49",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "329",
                                                "peak_id": "86",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3198835793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "169",
                        "p_value": "5.01e-12",
                        "e_value": "5.01e-12",
                        "fdr": "0",
                        "matched_fragment_number": "23",
                        "matched_peak_number": "27",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "629",
                                "ms1_scans": "980",
                                "ids": "352",
                                "scans": "983",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "10",
                                "precursor_mz": "1035.5059",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "352",
                                                "peak_id": "72",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "352",
                                                "peak_id": "35",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "352",
                                                "peak_id": "42",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "352",
                                                "peak_id": "33",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "352",
                                                "peak_id": "64",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "352",
                                                "peak_id": "74",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "15",
                                                    "ion_display_position": "15",
                                                    "spec_id": "352",
                                                    "peak_id": "3",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "15",
                                                    "ion_display_position": "15",
                                                    "spec_id": "352",
                                                    "peak_id": "60",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "352",
                                                "peak_id": "53",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "352",
                                                "peak_id": "143",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "352",
                                                "peak_id": "86",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "352",
                                                "peak_id": "90",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "352",
                                                    "peak_id": "10",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "352",
                                                    "peak_id": "58",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "352",
                                                "peak_id": "98",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "352",
                                                "peak_id": "21",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "72",
                                                    "ion_display_position": "17",
                                                    "spec_id": "352",
                                                    "peak_id": "5",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "72",
                                                    "ion_display_position": "17",
                                                    "spec_id": "352",
                                                    "peak_id": "156",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "16",
                                                "spec_id": "352",
                                                "peak_id": "62",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "352",
                                                "peak_id": "108",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "352",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "352",
                                                    "peak_id": "23",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "352",
                                                    "peak_id": "100",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "352",
                                                "peak_id": "17",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "352",
                                                "peak_id": "27",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "352",
                                                "peak_id": "40",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "352",
                                                "peak_id": "52",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3199435793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "125",
                        "p_value": "5.70e-12",
                        "e_value": "5.70e-12",
                        "fdr": "0",
                        "matched_fragment_number": "17",
                        "matched_peak_number": "18",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "607",
                                "ms1_scans": "892",
                                "ids": "286",
                                "scans": "895",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "6",
                                "precursor_mz": "1725.1717",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+496.3199]KQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "286",
                                                "peak_id": "23",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "286",
                                                "peak_id": "19",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "286",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "286",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "286",
                                                "peak_id": "13",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "286",
                                                "peak_id": "14",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "286",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "286",
                                                "peak_id": "2",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "286",
                                                    "peak_id": "9",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "286",
                                                    "peak_id": "20",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "286",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "286",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "286",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "286",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "286",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "286",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "286",
                                                "peak_id": "29",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "286",
                                                "peak_id": "37",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "90",
                                    "shift": "496.3199035793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "154",
                        "p_value": "1.39e-11",
                        "e_value": "1.39e-11",
                        "fdr": "0",
                        "matched_fragment_number": "23",
                        "matched_peak_number": "28",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "623",
                                "ms1_scans": "956",
                                "ids": "332",
                                "scans": "957",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "10",
                                "precursor_mz": "1035.5059",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "332",
                                                "peak_id": "67",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "332",
                                                "peak_id": "32",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "332",
                                                "peak_id": "40",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "332",
                                                "peak_id": "78",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "332",
                                                    "peak_id": "72",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "332",
                                                    "peak_id": "39",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "332",
                                                "peak_id": "64",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "332",
                                                "peak_id": "58",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "332",
                                                "peak_id": "37",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "332",
                                                "peak_id": "135",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "332",
                                                "peak_id": "100",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "332",
                                                "peak_id": "92",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "332",
                                                    "peak_id": "6",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "332",
                                                    "peak_id": "89",
                                                    "peak_charge": "3"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "332",
                                                    "peak_id": "59",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "332",
                                                "peak_id": "70",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "71",
                                                    "ion_display_position": "18",
                                                    "spec_id": "332",
                                                    "peak_id": "2",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "71",
                                                    "ion_display_position": "18",
                                                    "spec_id": "332",
                                                    "peak_id": "60",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "332",
                                                "peak_id": "96",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "16",
                                                "spec_id": "332",
                                                "peak_id": "113",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "332",
                                                "peak_id": "95",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "332",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "332",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "332",
                                                "peak_id": "35",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "78",
                                                    "ion_display_position": "11",
                                                    "spec_id": "332",
                                                    "peak_id": "25",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "78",
                                                    "ion_display_position": "11",
                                                    "spec_id": "332",
                                                    "peak_id": "55",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "332",
                                                "peak_id": "36",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "332",
                                                "peak_id": "44",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3199435793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "161",
                        "p_value": "2.76e-11",
                        "e_value": "2.76e-11",
                        "fdr": "0",
                        "matched_fragment_number": "22",
                        "matched_peak_number": "25",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "626",
                                "ms1_scans": "968",
                                "ids": "342",
                                "scans": "970",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "11",
                                "precursor_mz": "941.4606",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "342",
                                                "peak_id": "59",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "342",
                                                "peak_id": "20",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "342",
                                                "peak_id": "22",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "342",
                                                "peak_id": "44",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "342",
                                                "peak_id": "52",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "342",
                                                "peak_id": "39",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "342",
                                                "peak_id": "33",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "17",
                                                    "ion_display_position": "17",
                                                    "spec_id": "342",
                                                    "peak_id": "49",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "17",
                                                    "ion_display_position": "17",
                                                    "spec_id": "342",
                                                    "peak_id": "99",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "342",
                                                "peak_id": "74",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "342",
                                                    "peak_id": "27",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "342",
                                                    "peak_id": "37",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "342",
                                                "peak_id": "56",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "342",
                                                "peak_id": "9",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "342",
                                                "peak_id": "138",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "74",
                                                    "ion_display_position": "15",
                                                    "spec_id": "342",
                                                    "peak_id": "18",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "74",
                                                    "ion_display_position": "15",
                                                    "spec_id": "342",
                                                    "peak_id": "63",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "342",
                                                "peak_id": "8",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "342",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "342",
                                                "peak_id": "14",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "342",
                                                "peak_id": "25",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "342",
                                                "peak_id": "23",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "342",
                                                "peak_id": "41",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "82",
                                                "ion_display_position": "7",
                                                "spec_id": "342",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "84",
                                                "ion_display_position": "5",
                                                "spec_id": "342",
                                                "peak_id": "28",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3199135793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "146",
                        "p_value": "7.26e-11",
                        "e_value": "7.26e-11",
                        "fdr": "0",
                        "matched_fragment_number": "22",
                        "matched_peak_number": "24",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "618",
                                "ms1_scans": "936",
                                "ids": "317",
                                "scans": "937",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "6",
                                "precursor_mz": "1725.1717",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIA)[+496.3199]TVTPAIVQA(C)[Carbamidomethylation]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "317",
                                                "peak_id": "75",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "317",
                                                "peak_id": "58",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "317",
                                                "peak_id": "48",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "317",
                                                "peak_id": "19",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "317",
                                                    "peak_id": "67",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "317",
                                                    "peak_id": "29",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "317",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "317",
                                                "peak_id": "69",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "317",
                                                "peak_id": "27",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "317",
                                                "peak_id": "41",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "317",
                                                "peak_id": "121",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "56",
                                                "ion_display_position": "33",
                                                "spec_id": "317",
                                                "peak_id": "63",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "317",
                                                    "peak_id": "11",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "317",
                                                    "peak_id": "74",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "317",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "16",
                                                "spec_id": "317",
                                                "peak_id": "98",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "317",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "317",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "317",
                                                "peak_id": "13",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "317",
                                                "peak_id": "8",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "317",
                                                "peak_id": "22",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "317",
                                                "peak_id": "25",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "317",
                                                "peak_id": "28",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "6",
                                                "spec_id": "317",
                                                "peak_id": "45",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "77",
                                    "shift": "496.3199035793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "128",
                        "p_value": "8.68e-11",
                        "e_value": "8.68e-11",
                        "fdr": "0",
                        "matched_fragment_number": "17",
                        "matched_peak_number": "19",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "610",
                                "ms1_scans": "904",
                                "ids": "295",
                                "scans": "907",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "8",
                                "precursor_mz": "1294.1306",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+496.3199]KQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "295",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "295",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "295",
                                                "peak_id": "9",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "295",
                                                "peak_id": "24",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "295",
                                                "peak_id": "19",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "295",
                                                    "peak_id": "21",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "295",
                                                    "peak_id": "6",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "13",
                                                    "ion_display_position": "13",
                                                    "spec_id": "295",
                                                    "peak_id": "8",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "13",
                                                    "ion_display_position": "13",
                                                    "spec_id": "295",
                                                    "peak_id": "14",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "295",
                                                "peak_id": "12",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "295",
                                                "peak_id": "25",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "69",
                                                "ion_display_position": "20",
                                                "spec_id": "295",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "74",
                                                "ion_display_position": "74",
                                                "spec_id": "295",
                                                "peak_id": "45",
                                                "peak_charge": "8"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "295",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "295",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "295",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "295",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "295",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "295",
                                                "peak_id": "28",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "90",
                                    "shift": "496.3198935793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "173",
                        "p_value": "1.36e-10",
                        "e_value": "1.36e-10",
                        "fdr": "0",
                        "matched_fragment_number": "22",
                        "matched_peak_number": "24",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "632",
                                "ms1_scans": "992",
                                "ids": "359",
                                "scans": "993",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "8",
                                "precursor_mz": "1294.1306",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "359",
                                                "peak_id": "76",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "359",
                                                "peak_id": "63",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "359",
                                                "peak_id": "46",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "359",
                                                "peak_id": "52",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "359",
                                                "peak_id": "34",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "359",
                                                "peak_id": "57",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "359",
                                                "peak_id": "71",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "359",
                                                "peak_id": "120",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "359",
                                                "peak_id": "107",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "359",
                                                    "peak_id": "10",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "359",
                                                    "peak_id": "54",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "359",
                                                "peak_id": "19",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "359",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "359",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "73",
                                                    "ion_display_position": "16",
                                                    "spec_id": "359",
                                                    "peak_id": "41",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "73",
                                                    "ion_display_position": "16",
                                                    "spec_id": "359",
                                                    "peak_id": "62",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "359",
                                                "peak_id": "81",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "359",
                                                "peak_id": "30",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "359",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "359",
                                                "peak_id": "27",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "359",
                                                "peak_id": "35",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "359",
                                                "peak_id": "48",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "359",
                                                "peak_id": "44",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "6",
                                                "spec_id": "359",
                                                "peak_id": "59",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3198935793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "136",
                        "p_value": "9.12e-10",
                        "e_value": "9.12e-10",
                        "fdr": "0",
                        "matched_fragment_number": "16",
                        "matched_peak_number": "17",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "614",
                                "ms1_scans": "920",
                                "ids": "306",
                                "scans": "922",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "7",
                                "precursor_mz": "1478.8625",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPV(NSWT(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "306",
                                                "peak_id": "24",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "306",
                                                "peak_id": "21",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "306",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "306",
                                                "peak_id": "34",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "306",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "306",
                                                "peak_id": "14",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "13",
                                                "ion_display_position": "13",
                                                "spec_id": "306",
                                                "peak_id": "1",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "306",
                                                "peak_id": "57",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "306",
                                                    "peak_id": "23",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "306",
                                                    "peak_id": "3",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "306",
                                                "peak_id": "20",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "306",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "306",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "306",
                                                "peak_id": "7",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "306",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "306",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "85",
                                                "ion_display_position": "4",
                                                "spec_id": "306",
                                                "peak_id": "32",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "34",
                                    "right_position": "87",
                                    "shift": "496.3199335793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "168",
                        "p_value": "3.66e-09",
                        "e_value": "3.66e-09",
                        "fdr": "0",
                        "matched_fragment_number": "21",
                        "matched_peak_number": "23",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "629",
                                "ms1_scans": "980",
                                "ids": "350",
                                "scans": "981",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "6",
                                "precursor_mz": "1725.1717",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "350",
                                                "peak_id": "81",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "350",
                                                "peak_id": "64",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "350",
                                                "peak_id": "49",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "350",
                                                "peak_id": "45",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "350",
                                                "peak_id": "12",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "350",
                                                "peak_id": "35",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "15",
                                                    "ion_display_position": "15",
                                                    "spec_id": "350",
                                                    "peak_id": "55",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "15",
                                                    "ion_display_position": "15",
                                                    "spec_id": "350",
                                                    "peak_id": "44",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "350",
                                                "peak_id": "34",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "350",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "350",
                                                "peak_id": "17",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "350",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "350",
                                                    "peak_id": "8",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "350",
                                                    "peak_id": "74",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "350",
                                                "peak_id": "28",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "71",
                                                "ion_display_position": "18",
                                                "spec_id": "350",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "350",
                                                "peak_id": "13",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "350",
                                                "peak_id": "22",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "76",
                                                "ion_display_position": "13",
                                                "spec_id": "350",
                                                "peak_id": "9",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "350",
                                                "peak_id": "23",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "350",
                                                "peak_id": "21",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "350",
                                                "peak_id": "58",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "350",
                                                "peak_id": "36",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3199035793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "158",
                        "p_value": "7.44e-09",
                        "e_value": "7.44e-09",
                        "fdr": "0",
                        "matched_fragment_number": "20",
                        "matched_peak_number": "23",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "625",
                                "ms1_scans": "964",
                                "ids": "338",
                                "scans": "965",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "7",
                                "precursor_mz": "1478.8625",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation]TQD)[+496.3199]KQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "338",
                                                "peak_id": "87",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "338",
                                                "peak_id": "76",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "338",
                                                "peak_id": "61",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "9",
                                                "ion_display_position": "9",
                                                "spec_id": "338",
                                                "peak_id": "55",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "338",
                                                "peak_id": "30",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "338",
                                                "peak_id": "39",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "338",
                                                "peak_id": "0",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "338",
                                                "peak_id": "48",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "17",
                                                    "ion_display_position": "17",
                                                    "spec_id": "338",
                                                    "peak_id": "3",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "17",
                                                    "ion_display_position": "17",
                                                    "spec_id": "338",
                                                    "peak_id": "132",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "338",
                                                    "peak_id": "9",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "338",
                                                    "peak_id": "54",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "338",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "72",
                                                "ion_display_position": "17",
                                                "spec_id": "338",
                                                "peak_id": "6",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "16",
                                                "spec_id": "338",
                                                "peak_id": "16",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "15",
                                                "spec_id": "338",
                                                "peak_id": "115",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "338",
                                                "peak_id": "8",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "338",
                                                    "peak_id": "11",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "338",
                                                    "peak_id": "74",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "338",
                                                "peak_id": "15",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "338",
                                                "peak_id": "41",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "338",
                                                "peak_id": "35",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "338",
                                                "peak_id": "40",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "90",
                                    "shift": "496.3199335793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "150",
                        "p_value": "4.13e-08",
                        "e_value": "4.13e-08",
                        "fdr": "0",
                        "matched_fragment_number": "19",
                        "matched_peak_number": "21",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "621",
                                "ms1_scans": "948",
                                "ids": "326",
                                "scans": "949",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "8",
                                "precursor_mz": "1294.1306",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSWT((C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "326",
                                                "peak_id": "72",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "326",
                                                "peak_id": "68",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "326",
                                                "peak_id": "30",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "10",
                                                "ion_display_position": "10",
                                                "spec_id": "326",
                                                "peak_id": "36",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "11",
                                                "ion_display_position": "11",
                                                "spec_id": "326",
                                                "peak_id": "27",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "15",
                                                "ion_display_position": "15",
                                                "spec_id": "326",
                                                "peak_id": "53",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "326",
                                                "peak_id": "49",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "17",
                                                "ion_display_position": "17",
                                                "spec_id": "326",
                                                "peak_id": "120",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "85",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "86",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "87",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "66",
                                                "ion_display_position": "23",
                                                "spec_id": "326",
                                                "peak_id": "130",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "88",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "89",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "68",
                                                "ion_display_position": "21",
                                                "spec_id": "326",
                                                "peak_id": "116",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "90",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "326",
                                                    "peak_id": "8",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "69",
                                                    "ion_display_position": "20",
                                                    "spec_id": "326",
                                                    "peak_id": "48",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "91",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "70",
                                                "ion_display_position": "19",
                                                "spec_id": "326",
                                                "peak_id": "3",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "92",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "93",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "94",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "95",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "96",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "75",
                                                "ion_display_position": "14",
                                                "spec_id": "326",
                                                "peak_id": "18",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "97",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "326",
                                                    "peak_id": "10",
                                                    "peak_charge": "1"
                                                },
                                                {
                                                    "ion_type": "Y",
                                                    "ion_position": "76",
                                                    "ion_display_position": "13",
                                                    "spec_id": "326",
                                                    "peak_id": "89",
                                                    "peak_charge": "2"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "98",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "77",
                                                "ion_display_position": "12",
                                                "spec_id": "326",
                                                "peak_id": "38",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "99",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "78",
                                                "ion_display_position": "11",
                                                "spec_id": "326",
                                                "peak_id": "22",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "100",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "10",
                                                "spec_id": "326",
                                                "peak_id": "33",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "101",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "102",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "8",
                                                "spec_id": "326",
                                                "peak_id": "44",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "103",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "1",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "Y",
                                                "ion_position": "82",
                                                "ion_display_position": "7",
                                                "spec_id": "326",
                                                "peak_id": "41",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "104",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "105",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "106",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "107",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "108",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "109",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "110",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    }
                                ],
                                "ptm": {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": [
                                        {
                                            "left_pos": "38",
                                            "right_pos": "39",
                                            "anno": "C"
                                        },
                                        {
                                            "left_pos": "86",
                                            "right_pos": "87",
                                            "anno": "C"
                                        }
                                    ]
                                },
                                "mass_shift": {
                                    "id": "0",
                                    "left_position": "38",
                                    "right_position": "87",
                                    "shift": "496.3198935793",
                                    "anno": "+496.3199",
                                    "shift_type": "unexpected"
                                }
                            }
                        }
                    },
                    {
                        "prsm_id": "133",
                        "p_value": "1.42e-07",
                        "e_value": "1.42e-07",
                        "fdr": "0",
                        "matched_fragment_number": "16",
                        "matched_peak_number": "19",
                        "ms": {
                            "ms_header": {
                                "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                                "ms1_ids": "612",
                                "ms1_scans": "912",
                                "ids": "301",
                                "scans": "915",
                                "precursor_mono_mass": "10344.9866",
                                "precursor_charge": "10",
                                "precursor_mz": "1035.5059",
                                "feature_inte": "1.8578e+09"
                            }
                        },
                        "annotated_protein": {
                            "sequence_id": "22",
                            "proteoform_id": "28",
                            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                            "proteoform_mass": "10345.1916",
                            "n_acetylation": "0",
                            "unexpected_shift_number": "1",
                            "annotation": {
                                "protein_length": "110",
                                "first_residue_position": "21",
                                "last_residue_position": "109",
                                "annotated_seq": "A.ADAQKAADNKKPVNSW(T(C)[Carbamidomethylation]EDFLAVDESFQPTAVGFAEALNNKDKPEDAVLDVQGIATVTPAIVQA(C)[Carbamidomethylation])[+496.3199]TQDKQANFKDKVKGEWDKIKKDM.",
                                "residue": [
                                    {
                                        "position": "0",
                                        "acid": "M"
                                    },
                                    {
                                        "position": "1",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "2",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "3",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "4",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "5",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "6",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "7",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "8",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "9",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "10",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "11",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "12",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "13",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "14",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "15",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "16",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "17",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "18",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "19",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "20",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "21",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "22",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "23",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "24",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "25",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "26",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "27",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "28",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "29",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "30",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "31",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "32",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "33",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "34",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "35",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "36",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "37",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "38",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "39",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "40",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "41",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "42",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "43",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "44",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "45",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "46",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "47",
                                        "acid": "S"
                                    },
                                    {
                                        "position": "48",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "49",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "50",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "51",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "52",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "53",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "54",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "55",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "56",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "57",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "58",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "59",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "60",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "61",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "62",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "63",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "64",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "65",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "66",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "67",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "68",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "69",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "70",
                                        "acid": "L"
                                    },
                                    {
                                        "position": "71",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "72",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "73",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "74",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "75",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "76",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "77",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "78",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "79",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "80",
                                        "acid": "P"
                                    },
                                    {
                                        "position": "81",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "82",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "83",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "84",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "85",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "86",
                                        "acid": "C"
                                    },
                                    {
                                        "position": "87",
                                        "acid": "T"
                                    },
                                    {
                                        "position": "88",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "89",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "90",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "91",
                                        "acid": "Q"
                                    },
                                    {
                                        "position": "92",
                                        "acid": "A"
                                    },
                                    {
                                        "position": "93",
                                        "acid": "N"
                                    },
                                    {
                                        "position": "94",
                                        "acid": "F"
                                    },
                                    {
                                        "position": "95",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "96",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "97",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "98",
                                        "acid": "V"
                                    },
                                    {
                                        "position": "99",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "100",
                                        "acid": "G"
                                    },
                                    {
                                        "position": "101",
                                        "acid": "E"
                                    },
                                    {
                                        "position": "102",
                                        "acid": "W"
                                    },
                                    {
                                        "position": "103",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "104",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "105",
                                        "acid": "I"
                                    },
                                    {
                                        "position": "106",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "107",
                                        "acid": "K"
                                    },
                                    {
                                        "position": "108",
                                        "acid": "D"
                                    },
                                    {
                                        "position": "109",
                                        "acid": "M"
                                    }
                                ],
                                "cleavage": [
                                    {
                                        "position": "0",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "1",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "2",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "3",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "4",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "5",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "6",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "7",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "8",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "9",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "10",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "11",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "12",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "13",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "14",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "15",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "16",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "17",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "18",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "19",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "20",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "21",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "22",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "23",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "24",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "25",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "26",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "27",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "6",
                                                "ion_display_position": "6",
                                                "spec_id": "301",
                                                "peak_id": "33",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "28",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "7",
                                                "ion_display_position": "7",
                                                "spec_id": "301",
                                                "peak_id": "30",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "29",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "8",
                                                "ion_display_position": "8",
                                                "spec_id": "301",
                                                "peak_id": "23",
                                                "peak_charge": "1"
                                            }
                                        }
                                    },
                                    {
                                        "position": "30",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "31",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "32",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": [
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "301",
                                                    "peak_id": "40",
                                                    "peak_charge": "2"
                                                },
                                                {
                                                    "ion_type": "B",
                                                    "ion_position": "11",
                                                    "ion_display_position": "11",
                                                    "spec_id": "301",
                                                    "peak_id": "8",
                                                    "peak_charge": "1"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "position": "33",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "34",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "35",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "14",
                                                "ion_display_position": "14",
                                                "spec_id": "301",
                                                "peak_id": "32",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "36",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "37",
                                        "exist_n_ion": "1",
                                        "exist_c_ion": "0",
                                        "matched_peaks": {
                                            "matched_peak": {
                                                "ion_type": "B",
                                                "ion_position": "16",
                                                "ion_display_position": "16",
                                                "spec_id": "301",
                                                "peak_id": "24",
                                                "peak_charge": "2"
                                            }
                                        }
                                    },
                                    {
                                        "position": "38",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "39",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "40",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "41",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "42",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "43",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "44",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "45",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "46",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "47",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "48",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "49",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "50",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "51",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "52",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "53",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "54",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "55",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "56",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "57",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "58",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "59",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "60",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "61",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "62",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "63",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "64",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "65",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "66",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "67",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "68",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "69",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "70",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "71",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "72",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "73",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "74",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "75",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "76",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "77",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "78",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "79",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "80",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "81",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "82",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "83",
                                        "exist_n_ion": "0",
                                        "exist_c_ion": "0",
                                        "matched_peaks": null
                                    },
                                    {
                                        "position": "84",
                  