prsm_data =
{
    "protein": {
        "sequence_id": "12",
        "sequence_name": "sp|P0A8P3|FETP_ECOLI",
        "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "12",
            "sequence_name": "sp|P0A8P3|FETP_ECOLI",
            "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
            "proteoform_id": "13",
            "prsm_number": "2",
            "prsm": [
                {
                    "prsm_id": "79",
                    "p_value": "4.09e-22",
                    "e_value": "4.09e-22",
                    "fdr": "0",
                    "matched_fragment_number": "54",
                    "matched_peak_number": "55",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "582",
                            "ms1_scans": "793",
                            "ids": "210",
                            "scans": "794",
                            "precursor_mono_mass": "10814.3734",
                            "precursor_charge": "6",
                            "precursor_mz": "1803.4028",
                            "feature_inte": "5.8629e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "12",
                        "proteoform_id": "13",
                        "sequence_name": "sp|P0A8P3|FETP_ECOLI",
                        "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
                        "proteoform_mass": "10814.4084",
                        "n_acetylation": "1",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "91",
                            "first_residue_position": "0",
                            "last_residue_position": "90",
                            "annotated_seq": ".[Acetyl]-MSRTIF(C)[Carbamidomethylation](TFLQREAE)[-230.0503]GQDFQLYPGELGKRIYNEISKEAWAQWQHKQTMLINEKKLNMMNAEHRKLLEQEMVNFLFEGKEVHIEGYTPEDKK.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "F"
                                },
                                {
                                    "position": "6",
                                    "acid": "C"
                                },
                                {
                                    "position": "7",
                                    "acid": "T"
                                },
                                {
                                    "position": "8",
                                    "acid": "F"
                                },
                                {
                                    "position": "9",
                                    "acid": "L"
                                },
                                {
                                    "position": "10",
                                    "acid": "Q"
                                },
                                {
                                    "position": "11",
                                    "acid": "R"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "A"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "Q"
                                },
                                {
                                    "position": "17",
                                    "acid": "D"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "Q"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "Y"
                                },
                                {
                                    "position": "22",
                                    "acid": "P"
                                },
                                {
                                    "position": "23",
                                    "acid": "G"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "L"
                                },
                                {
                                    "position": "26",
                                    "acid": "G"
                                },
                                {
                                    "position": "27",
                                    "acid": "K"
                                },
                                {
                                    "position": "28",
                                    "acid": "R"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "Y"
                                },
                                {
                                    "position": "31",
                                    "acid": "N"
                                },
                                {
                                    "position": "32",
                                    "acid": "E"
                                },
                                {
                                    "position": "33",
                                    "acid": "I"
                                },
                                {
                                    "position": "34",
                                    "acid": "S"
                                },
                                {
                                    "position": "35",
                                    "acid": "K"
                                },
                                {
                                    "position": "36",
                                    "acid": "E"
                                },
                                {
                                    "position": "37",
                                    "acid": "A"
                                },
                                {
                                    "position": "38",
                                    "acid": "W"
                                },
                                {
                                    "position": "39",
                                    "acid": "A"
                                },
                                {
                                    "position": "40",
                                    "acid": "Q"
                                },
                                {
                                    "position": "41",
                                    "acid": "W"
                                },
                                {
                                    "position": "42",
                                    "acid": "Q"
                                },
                                {
                                    "position": "43",
                                    "acid": "H"
                                },
                                {
                                    "position": "44",
                                    "acid": "K"
                                },
                                {
                                    "position": "45",
                                    "acid": "Q"
                                },
                                {
                                    "position": "46",
                                    "acid": "T"
                                },
                                {
                                    "position": "47",
                                    "acid": "M"
                                },
                                {
                                    "position": "48",
                                    "acid": "L"
                                },
                                {
                                    "position": "49",
                                    "acid": "I"
                                },
                                {
                                    "position": "50",
                                    "acid": "N"
                                },
                                {
                                    "position": "51",
                                    "acid": "E"
                                },
                                {
                                    "position": "52",
                                    "acid": "K"
                                },
                                {
                                    "position": "53",
                                    "acid": "K"
                                },
                                {
                                    "position": "54",
                                    "acid": "L"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "M"
                                },
                                {
                                    "position": "58",
                                    "acid": "N"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "H"
                                },
                                {
                                    "position": "62",
                                    "acid": "R"
                                },
                                {
                                    "position": "63",
                                    "acid": "K"
                                },
                                {
                                    "position": "64",
                                    "acid": "L"
                                },
                                {
                                    "position": "65",
                                    "acid": "L"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "Q"
                                },
                                {
                                    "position": "68",
                                    "acid": "E"
                                },
                                {
                                    "position": "69",
                                    "acid": "M"
                                },
                                {
                                    "position": "70",
                                    "acid": "V"
                                },
                                {
                                    "position": "71",
                                    "acid": "N"
                                },
                                {
                                    "position": "72",
                                    "acid": "F"
                                },
                                {
                                    "position": "73",
                                    "acid": "L"
                                },
                                {
                                    "position": "74",
                                    "acid": "F"
                                },
                                {
                                    "position": "75",
                                    "acid": "E"
                                },
                                {
                                    "position": "76",
                                    "acid": "G"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "E"
                                },
                                {
                                    "position": "79",
                                    "acid": "V"
                                },
                                {
                                    "position": "80",
                                    "acid": "H"
                                },
                                {
                                    "position": "81",
                                    "acid": "I"
                                },
                                {
                                    "position": "82",
                                    "acid": "E"
                                },
                                {
                                    "position": "83",
                                    "acid": "G"
                                },
                                {
                                    "position": "84",
                                    "acid": "Y"
                                },
                                {
                                    "position": "85",
                                    "acid": "T"
                                },
                                {
                                    "position": "86",
                                    "acid": "P"
                                },
                                {
                                    "position": "87",
                                    "acid": "E"
                                },
                                {
                                    "position": "88",
                                    "acid": "D"
                                },
                                {
                                    "position": "89",
                                    "acid": "K"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "84",
                                            "spec_id": "210",
                                            "peak_id": "174",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "210",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "17",
                                            "ion_display_position": "17",
                                            "spec_id": "210",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "210",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "210",
                                            "peak_id": "177",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "210",
                                            "peak_id": "16",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "210",
                                            "peak_id": "51",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "210",
                                            "peak_id": "63",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "210",
                                            "peak_id": "26",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "210",
                                            "peak_id": "25",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "210",
                                            "peak_id": "41",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "210",
                                            "peak_id": "78",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "210",
                                            "peak_id": "87",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "40",
                                                "ion_display_position": "40",
                                                "spec_id": "210",
                                                "peak_id": "58",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "40",
                                                "ion_display_position": "51",
                                                "spec_id": "210",
                                                "peak_id": "53",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "50",
                                            "spec_id": "210",
                                            "peak_id": "80",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "42",
                                            "ion_display_position": "42",
                                            "spec_id": "210",
                                            "peak_id": "99",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "43",
                                                "ion_display_position": "43",
                                                "spec_id": "210",
                                                "peak_id": "133",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "43",
                                                "ion_display_position": "43",
                                                "spec_id": "210",
                                                "peak_id": "85",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "44",
                                                "ion_display_position": "44",
                                                "spec_id": "210",
                                                "peak_id": "146",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "44",
                                                "ion_display_position": "44",
                                                "spec_id": "210",
                                                "peak_id": "62",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "210",
                                                "peak_id": "24",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "210",
                                                "peak_id": "89",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "46",
                                            "ion_display_position": "46",
                                            "spec_id": "210",
                                            "peak_id": "130",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "47",
                                            "ion_display_position": "47",
                                            "spec_id": "210",
                                            "peak_id": "33",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "210",
                                            "peak_id": "166",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "49",
                                                "ion_display_position": "42",
                                                "spec_id": "210",
                                                "peak_id": "160",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "49",
                                                "ion_display_position": "49",
                                                "spec_id": "210",
                                                "peak_id": "83",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "50",
                                                "ion_display_position": "41",
                                                "spec_id": "210",
                                                "peak_id": "117",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "50",
                                                "ion_display_position": "50",
                                                "spec_id": "210",
                                                "peak_id": "47",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "210",
                                            "peak_id": "95",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "52",
                                                "ion_display_position": "39",
                                                "spec_id": "210",
                                                "peak_id": "56",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "52",
                                                "ion_display_position": "39",
                                                "spec_id": "210",
                                                "peak_id": "104",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "52",
                                                "ion_display_position": "52",
                                                "spec_id": "210",
                                                "peak_id": "80",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "53",
                                            "ion_display_position": "53",
                                            "spec_id": "210",
                                            "peak_id": "53",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "54",
                                            "ion_display_position": "54",
                                            "spec_id": "210",
                                            "peak_id": "94",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "61",
                                            "ion_display_position": "30",
                                            "spec_id": "210",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "71",
                                            "ion_display_position": "20",
                                            "spec_id": "210",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "72",
                                            "ion_display_position": "19",
                                            "spec_id": "210",
                                            "peak_id": "1",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "73",
                                                "ion_display_position": "18",
                                                "spec_id": "210",
                                                "peak_id": "9",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "73",
                                                "ion_display_position": "73",
                                                "spec_id": "210",
                                                "peak_id": "110",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "74",
                                                "ion_display_position": "17",
                                                "spec_id": "210",
                                                "peak_id": "4",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "74",
                                                "ion_display_position": "74",
                                                "spec_id": "210",
                                                "peak_id": "123",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "15",
                                            "spec_id": "210",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "78",
                                            "ion_display_position": "13",
                                            "spec_id": "210",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "79",
                                                "ion_display_position": "12",
                                                "spec_id": "210",
                                                "peak_id": "37",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "79",
                                                "ion_display_position": "79",
                                                "spec_id": "210",
                                                "peak_id": "61",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "11",
                                            "spec_id": "210",
                                            "peak_id": "48",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "10",
                                            "spec_id": "210",
                                            "peak_id": "13",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "82",
                                                "ion_display_position": "9",
                                                "spec_id": "210",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "82",
                                                "ion_display_position": "82",
                                                "spec_id": "210",
                                                "peak_id": "157",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "8",
                                                "spec_id": "210",
                                                "peak_id": "11",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "83",
                                                "ion_display_position": "83",
                                                "spec_id": "210",
                                                "peak_id": "174",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "7",
                                            "spec_id": "210",
                                            "peak_id": "35",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "85",
                                            "ion_display_position": "6",
                                            "spec_id": "210",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "86",
                                            "ion_display_position": "5",
                                            "spec_id": "210",
                                            "peak_id": "34",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "89",
                                            "ion_display_position": "89",
                                            "spec_id": "210",
                                            "peak_id": "136",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "90",
                                            "ion_display_position": "90",
                                            "spec_id": "210",
                                            "peak_id": "171",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": [
                                {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "6",
                                        "right_pos": "7",
                                        "anno": "C"
                                    }
                                },
                                {
                                    "ptm_type": "Protein variable",
                                    "ptm": {
                                        "abbreviation": "Acetyl",
                                        "unimod": "1",
                                        "mono_mass": "42.0105650000"
                                    },
                                    "occurence": {
                                        "left_pos": "0",
                                        "right_pos": "1",
                                        "anno": "M"
                                    }
                                }
                            ],
                            "mass_shift": {
                                "id": "0",
                                "left_position": "7",
                                "right_position": "15",
                                "shift": "-230.0502995237",
                                "anno": "-230.0503",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "59",
                    "p_value": "2.53e-21",
                    "e_value": "2.53e-21",
                    "fdr": "0",
                    "matched_fragment_number": "46",
                    "matched_peak_number": "47",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "571",
                            "ms1_scans": "749",
                            "ids": "179",
                            "scans": "752",
                            "precursor_mono_mass": "10815.3692",
                            "precursor_charge": "6",
                            "precursor_mz": "1803.5688",
                            "feature_inte": "3.5171e+06"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "12",
                        "proteoform_id": "13",
                        "sequence_name": "sp|P0A8P3|FETP_ECOLI",
                        "sequence_description": "Probable Fe(2+)-trafficking protein OS=Escherichia coli (strain K12) OX=83333 GN=yggX PE=1 SV=2",
                        "proteoform_mass": "10814.4018",
                        "n_acetylation": "1",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "91",
                            "first_residue_position": "0",
                            "last_residue_position": "90",
                            "annotated_seq": ".[Acetyl]-MSRTIF(C)[Carbamidomethylation](TFLQR)[-230.0569]EAEGQDFQLYPGELGKRIYNEISKEAWAQWQHKQTMLINEKKLNMMNAEHRKLLEQEMVNFLFEGKEVHIEGYTPEDKK.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "S"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "F"
                                },
                                {
                                    "position": "6",
                                    "acid": "C"
                                },
                                {
                                    "position": "7",
                                    "acid": "T"
                                },
                                {
                                    "position": "8",
                                    "acid": "F"
                                },
                                {
                                    "position": "9",
                                    "acid": "L"
                                },
                                {
                                    "position": "10",
                                    "acid": "Q"
                                },
                                {
                                    "position": "11",
                                    "acid": "R"
                                },
                                {
                                    "position": "12",
                                    "acid": "E"
                                },
                                {
                                    "position": "13",
                                    "acid": "A"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "G"
                                },
                                {
                                    "position": "16",
                                    "acid": "Q"
                                },
                                {
                                    "position": "17",
                                    "acid": "D"
                                },
                                {
                                    "position": "18",
                                    "acid": "F"
                                },
                                {
                                    "position": "19",
                                    "acid": "Q"
                                },
                                {
                                    "position": "20",
                                    "acid": "L"
                                },
                                {
                                    "position": "21",
                                    "acid": "Y"
                                },
                                {
                                    "position": "22",
                                    "acid": "P"
                                },
                                {
                                    "position": "23",
                                    "acid": "G"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "L"
                                },
                                {
                                    "position": "26",
                                    "acid": "G"
                                },
                                {
                                    "position": "27",
                                    "acid": "K"
                                },
                                {
                                    "position": "28",
                                    "acid": "R"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "Y"
                                },
                                {
                                    "position": "31",
                                    "acid": "N"
                                },
                                {
                                    "position": "32",
                                    "acid": "E"
                                },
                                {
                                    "position": "33",
                                    "acid": "I"
                                },
                                {
                                    "position": "34",
                                    "acid": "S"
                                },
                                {
                                    "position": "35",
                                    "acid": "K"
                                },
                                {
                                    "position": "36",
                                    "acid": "E"
                                },
                                {
                                    "position": "37",
                                    "acid": "A"
                                },
                                {
                                    "position": "38",
                                    "acid": "W"
                                },
                                {
                                    "position": "39",
                                    "acid": "A"
                                },
                                {
                                    "position": "40",
                                    "acid": "Q"
                                },
                                {
                                    "position": "41",
                                    "acid": "W"
                                },
                                {
                                    "position": "42",
                                    "acid": "Q"
                                },
                                {
                                    "position": "43",
                                    "acid": "H"
                                },
                                {
                                    "position": "44",
                                    "acid": "K"
                                },
                                {
                                    "position": "45",
                                    "acid": "Q"
                                },
                                {
                                    "position": "46",
                                    "acid": "T"
                                },
                                {
                                    "position": "47",
                                    "acid": "M"
                                },
                                {
                                    "position": "48",
                                    "acid": "L"
                                },
                                {
                                    "position": "49",
                                    "acid": "I"
                                },
                                {
                                    "position": "50",
                                    "acid": "N"
                                },
                                {
                                    "position": "51",
                                    "acid": "E"
                                },
                                {
                                    "position": "52",
                                    "acid": "K"
                                },
                                {
                                    "position": "53",
                                    "acid": "K"
                                },
                                {
                                    "position": "54",
                                    "acid": "L"
                                },
                                {
                                    "position": "55",
                                    "acid": "N"
                                },
                                {
                                    "position": "56",
                                    "acid": "M"
                                },
                                {
                                    "position": "57",
                                    "acid": "M"
                                },
                                {
                                    "position": "58",
                                    "acid": "N"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "E"
                                },
                                {
                                    "position": "61",
                                    "acid": "H"
                                },
                                {
                                    "position": "62",
                                    "acid": "R"
                                },
                                {
                                    "position": "63",
                                    "acid": "K"
                                },
                                {
                                    "position": "64",
                                    "acid": "L"
                                },
                                {
                                    "position": "65",
                                    "acid": "L"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "Q"
                                },
                                {
                                    "position": "68",
                                    "acid": "E"
                                },
                                {
                                    "position": "69",
                                    "acid": "M"
                                },
                                {
                                    "position": "70",
                                    "acid": "V"
                                },
                                {
                                    "position": "71",
                                    "acid": "N"
                                },
                                {
                                    "position": "72",
                                    "acid": "F"
                                },
                                {
                                    "position": "73",
                                    "acid": "L"
                                },
                                {
                                    "position": "74",
                                    "acid": "F"
                                },
                                {
                                    "position": "75",
                                    "acid": "E"
                                },
                                {
                                    "position": "76",
                                    "acid": "G"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "E"
                                },
                                {
                                    "position": "79",
                                    "acid": "V"
                                },
                                {
                                    "position": "80",
                                    "acid": "H"
                                },
                                {
                                    "position": "81",
                                    "acid": "I"
                                },
                                {
                                    "position": "82",
                                    "acid": "E"
                                },
                                {
                                    "position": "83",
                                    "acid": "G"
                                },
                                {
                                    "position": "84",
                                    "acid": "Y"
                                },
                                {
                                    "position": "85",
                                    "acid": "T"
                                },
                                {
                                    "position": "86",
                                    "acid": "P"
                                },
                                {
                                    "position": "87",
                                    "acid": "E"
                                },
                                {
                                    "position": "88",
                                    "acid": "D"
                                },
                                {
                                    "position": "89",
                                    "acid": "K"
                                },
                                {
                                    "position": "90",
                                    "acid": "K"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "7",
                                            "ion_display_position": "84",
                                            "spec_id": "179",
                                            "peak_id": "131",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "179",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "179",
                                            "peak_id": "33",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "179",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "18",
                                            "ion_display_position": "18",
                                            "spec_id": "179",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "179",
                                            "peak_id": "19",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "179",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "22",
                                            "ion_display_position": "22",
                                            "spec_id": "179",
                                            "peak_id": "30",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "179",
                                            "peak_id": "34",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "179",
                                            "peak_id": "62",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "33",
                                            "ion_display_position": "33",
                                            "spec_id": "179",
                                            "peak_id": "44",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "179",
                                            "peak_id": "66",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "179",
                                            "peak_id": "94",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "179",
                                            "peak_id": "87",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "179",
                                            "peak_id": "45",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "179",
                                                "peak_id": "39",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "41",
                                                "ion_display_position": "50",
                                                "spec_id": "179",
                                                "peak_id": "112",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "42",
                                            "ion_display_position": "42",
                                            "spec_id": "179",
                                            "peak_id": "47",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "43",
                                                "ion_display_position": "43",
                                                "spec_id": "179",
                                                "peak_id": "69",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "43",
                                                "ion_display_position": "43",
                                                "spec_id": "179",
                                                "peak_id": "52",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "44",
                                                "ion_display_position": "44",
                                                "spec_id": "179",
                                                "peak_id": "22",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "44",
                                                "ion_display_position": "44",
                                                "spec_id": "179",
                                                "peak_id": "93",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "179",
                                                "peak_id": "43",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "45",
                                                "ion_display_position": "45",
                                                "spec_id": "179",
                                                "peak_id": "24",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "48",
                                            "ion_display_position": "43",
                                            "spec_id": "179",
                                            "peak_id": "162",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "179",
                                            "peak_id": "56",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "50",
                                                "ion_display_position": "41",
                                                "spec_id": "179",
                                                "peak_id": "118",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "50",
                                                "ion_display_position": "50",
                                                "spec_id": "179",
                                                "peak_id": "35",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "179",
                                            "peak_id": "159",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "52",
                                            "ion_display_position": "52",
                                            "spec_id": "179",
                                            "peak_id": "112",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "53",
                                                "ion_display_position": "38",
                                                "spec_id": "179",
                                                "peak_id": "139",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "53",
                                                "ion_display_position": "53",
                                                "spec_id": "179",
                                                "peak_id": "147",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "54",
                                            "ion_display_position": "54",
                                            "spec_id": "179",
                                            "peak_id": "101",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "71",
                                            "ion_display_position": "20",
                                            "spec_id": "179",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "72",
                                            "ion_display_position": "72",
                                            "spec_id": "179",
                                            "peak_id": "141",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "73",
                                            "ion_display_position": "73",
                                            "spec_id": "179",
                                            "peak_id": "80",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "74",
                                            "ion_display_position": "17",
                                            "spec_id": "179",
                                            "peak_id": "3",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "75",
                                            "ion_display_position": "16",
                                            "spec_id": "179",
                                            "peak_id": "86",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "15",
                                            "spec_id": "179",
                                            "peak_id": "12",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "78",
                                            "ion_display_position": "13",
                                            "spec_id": "179",
                                            "peak_id": "110",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "79",
                                            "ion_display_position": "12",
                                            "spec_id": "179",
                                            "peak_id": "23",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "81",
                                                "ion_display_position": "10",
                                                "spec_id": "179",
                                                "peak_id": "5",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "81",
                                                "ion_display_position": "81",
                                                "spec_id": "179",
                                                "peak_id": "102",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "82",
                                            "ion_display_position": "9",
                                            "spec_id": "179",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "83",
                                                "ion_display_position": "8",
                                                "spec_id": "179",
                                                "peak_id": "10",
                                                "peak_charge": "1"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "83",
                                                "ion_display_position": "83",
                                                "spec_id": "179",
                                                "peak_id": "131",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "85",
                                            "ion_display_position": "6",
                                            "spec_id": "179",
                                            "peak_id": "17",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "86",
                                            "ion_display_position": "5",
                                            "spec_id": "179",
                                            "peak_id": "16",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "89",
                                            "ion_display_position": "89",
                                            "spec_id": "179",
                                            "peak_id": "132",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": [
                                {
                                    "ptm_type": "Fixed",
                                    "ptm": {
                                        "abbreviation": "Carbamidomethylation",
                                        "unimod": "-1",
                                        "mono_mass": "57.0214640000"
                                    },
                                    "occurence": {
                                        "left_pos": "6",
                                        "right_pos": "7",
                                        "anno": "C"
                                    }
                                },
                                {
                                    "ptm_type": "Protein variable",
                                    "ptm": {
                                        "abbreviation": "Acetyl",
                                        "unimod": "1",
                                        "mono_mass": "42.0105650000"
                                    },
                                    "occurence": {
                                        "left_pos": "0",
                                        "right_pos": "1",
                                        "anno": "M"
                                    }
                                }
                            ],
                            "mass_shift": {
                                "id": "0",
                                "left_position": "7",
                                "right_position": "12",
                                "shift": "-230.0568895237",
                                "anno": "-230.0569",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            ]
        }
    }
}
