prsm_data =
{
    "protein": {
        "sequence_id": "11",
        "sequence_name": "sp|P37903|USPF_ECOLI",
        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
        "compatible_proteoform_number": "1",
        "compatible_proteoform": {
            "sequence_id": "11",
            "sequence_name": "sp|P37903|USPF_ECOLI",
            "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
            "proteoform_id": "12",
            "prsm_number": "4",
            "prsm": [
                {
                    "prsm_id": "134",
                    "p_value": "2.29e-23",
                    "e_value": "2.29e-23",
                    "fdr": "0",
                    "matched_fragment_number": "35",
                    "matched_peak_number": "37",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "613",
                            "ms1_scans": "916",
                            "ids": "302",
                            "scans": "917",
                            "precursor_mono_mass": "16311.5248",
                            "precursor_charge": "8",
                            "precursor_mz": "2039.9479",
                            "feature_inte": "4.0888e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "12",
                        "sequence_name": "sp|P37903|USPF_ECOLI",
                        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                        "proteoform_mass": "16310.6225",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "144",
                            "first_residue_position": "0",
                            "last_residue_position": "143",
                            "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKI(PAHMIIIASHRPDITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation])[+247.0868]SVLVVR.",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "P"
                                },
                                {
                                    "position": "8",
                                    "acid": "I"
                                },
                                {
                                    "position": "9",
                                    "acid": "D"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "S"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "T"
                                },
                                {
                                    "position": "17",
                                    "acid": "Q"
                                },
                                {
                                    "position": "18",
                                    "acid": "R"
                                },
                                {
                                    "position": "19",
                                    "acid": "V"
                                },
                                {
                                    "position": "20",
                                    "acid": "I"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "H"
                                },
                                {
                                    "position": "23",
                                    "acid": "V"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "E"
                                },
                                {
                                    "position": "26",
                                    "acid": "E"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "K"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "D"
                                },
                                {
                                    "position": "31",
                                    "acid": "D"
                                },
                                {
                                    "position": "32",
                                    "acid": "A"
                                },
                                {
                                    "position": "33",
                                    "acid": "E"
                                },
                                {
                                    "position": "34",
                                    "acid": "V"
                                },
                                {
                                    "position": "35",
                                    "acid": "H"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "L"
                                },
                                {
                                    "position": "38",
                                    "acid": "T"
                                },
                                {
                                    "position": "39",
                                    "acid": "V"
                                },
                                {
                                    "position": "40",
                                    "acid": "I"
                                },
                                {
                                    "position": "41",
                                    "acid": "P"
                                },
                                {
                                    "position": "42",
                                    "acid": "S"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "P"
                                },
                                {
                                    "position": "45",
                                    "acid": "Y"
                                },
                                {
                                    "position": "46",
                                    "acid": "Y"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "S"
                                },
                                {
                                    "position": "49",
                                    "acid": "L"
                                },
                                {
                                    "position": "50",
                                    "acid": "G"
                                },
                                {
                                    "position": "51",
                                    "acid": "L"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "Y"
                                },
                                {
                                    "position": "54",
                                    "acid": "S"
                                },
                                {
                                    "position": "55",
                                    "acid": "A"
                                },
                                {
                                    "position": "56",
                                    "acid": "E"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "P"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "M"
                                },
                                {
                                    "position": "61",
                                    "acid": "D"
                                },
                                {
                                    "position": "62",
                                    "acid": "D"
                                },
                                {
                                    "position": "63",
                                    "acid": "L"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "A"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "K"
                                },
                                {
                                    "position": "69",
                                    "acid": "S"
                                },
                                {
                                    "position": "70",
                                    "acid": "Q"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "E"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "I"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "K"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "F"
                                },
                                {
                                    "position": "79",
                                    "acid": "K"
                                },
                                {
                                    "position": "80",
                                    "acid": "L"
                                },
                                {
                                    "position": "81",
                                    "acid": "P"
                                },
                                {
                                    "position": "82",
                                    "acid": "T"
                                },
                                {
                                    "position": "83",
                                    "acid": "D"
                                },
                                {
                                    "position": "84",
                                    "acid": "R"
                                },
                                {
                                    "position": "85",
                                    "acid": "V"
                                },
                                {
                                    "position": "86",
                                    "acid": "H"
                                },
                                {
                                    "position": "87",
                                    "acid": "V"
                                },
                                {
                                    "position": "88",
                                    "acid": "H"
                                },
                                {
                                    "position": "89",
                                    "acid": "V"
                                },
                                {
                                    "position": "90",
                                    "acid": "E"
                                },
                                {
                                    "position": "91",
                                    "acid": "E"
                                },
                                {
                                    "position": "92",
                                    "acid": "G"
                                },
                                {
                                    "position": "93",
                                    "acid": "S"
                                },
                                {
                                    "position": "94",
                                    "acid": "P"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "R"
                                },
                                {
                                    "position": "98",
                                    "acid": "I"
                                },
                                {
                                    "position": "99",
                                    "acid": "L"
                                },
                                {
                                    "position": "100",
                                    "acid": "E"
                                },
                                {
                                    "position": "101",
                                    "acid": "L"
                                },
                                {
                                    "position": "102",
                                    "acid": "A"
                                },
                                {
                                    "position": "103",
                                    "acid": "K"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "A"
                                },
                                {
                                    "position": "108",
                                    "acid": "H"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                },
                                {
                                    "position": "110",
                                    "acid": "I"
                                },
                                {
                                    "position": "111",
                                    "acid": "I"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "A"
                                },
                                {
                                    "position": "114",
                                    "acid": "S"
                                },
                                {
                                    "position": "115",
                                    "acid": "H"
                                },
                                {
                                    "position": "116",
                                    "acid": "R"
                                },
                                {
                                    "position": "117",
                                    "acid": "P"
                                },
                                {
                                    "position": "118",
                                    "acid": "D"
                                },
                                {
                                    "position": "119",
                                    "acid": "I"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "T"
                                },
                                {
                                    "position": "122",
                                    "acid": "Y"
                                },
                                {
                                    "position": "123",
                                    "acid": "L"
                                },
                                {
                                    "position": "124",
                                    "acid": "L"
                                },
                                {
                                    "position": "125",
                                    "acid": "G"
                                },
                                {
                                    "position": "126",
                                    "acid": "S"
                                },
                                {
                                    "position": "127",
                                    "acid": "N"
                                },
                                {
                                    "position": "128",
                                    "acid": "A"
                                },
                                {
                                    "position": "129",
                                    "acid": "A"
                                },
                                {
                                    "position": "130",
                                    "acid": "A"
                                },
                                {
                                    "position": "131",
                                    "acid": "V"
                                },
                                {
                                    "position": "132",
                                    "acid": "V"
                                },
                                {
                                    "position": "133",
                                    "acid": "R"
                                },
                                {
                                    "position": "134",
                                    "acid": "H"
                                },
                                {
                                    "position": "135",
                                    "acid": "A"
                                },
                                {
                                    "position": "136",
                                    "acid": "E"
                                },
                                {
                                    "position": "137",
                                    "acid": "C"
                                },
                                {
                                    "position": "138",
                                    "acid": "S"
                                },
                                {
                                    "position": "139",
                                    "acid": "V"
                                },
                                {
                                    "position": "140",
                                    "acid": "L"
                                },
                                {
                                    "position": "141",
                                    "acid": "V"
                                },
                                {
                                    "position": "142",
                                    "acid": "V"
                                },
                                {
                                    "position": "143",
                                    "acid": "R"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "302",
                                            "peak_id": "34",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "302",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "302",
                                            "peak_id": "0",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "302",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "302",
                                            "peak_id": "77",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "302",
                                            "peak_id": "57",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "24",
                                            "ion_display_position": "24",
                                            "spec_id": "302",
                                            "peak_id": "18",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "302",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "302",
                                            "peak_id": "35",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "302",
                                            "peak_id": "59",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "302",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "302",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "302",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "35",
                                            "ion_display_position": "35",
                                            "spec_id": "302",
                                            "peak_id": "73",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "302",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "302",
                                            "peak_id": "14",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "38",
                                            "ion_display_position": "38",
                                            "spec_id": "302",
                                            "peak_id": "88",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "302",
                                            "peak_id": "37",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "302",
                                            "peak_id": "15",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "302",
                                                "peak_id": "109",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "302",
                                                "peak_id": "52",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "57",
                                            "ion_display_position": "87",
                                            "spec_id": "302",
                                            "peak_id": "124",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "58",
                                            "ion_display_position": "86",
                                            "spec_id": "302",
                                            "peak_id": "95",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "59",
                                            "ion_display_position": "85",
                                            "spec_id": "302",
                                            "peak_id": "128",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "62",
                                            "ion_display_position": "82",
                                            "spec_id": "302",
                                            "peak_id": "79",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "63",
                                            "ion_display_position": "81",
                                            "spec_id": "302",
                                            "peak_id": "75",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "68",
                                            "ion_display_position": "76",
                                            "spec_id": "302",
                                            "peak_id": "22",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "75",
                                            "spec_id": "302",
                                            "peak_id": "92",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "73",
                                            "ion_display_position": "71",
                                            "spec_id": "302",
                                            "peak_id": "130",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "77",
                                            "ion_display_position": "67",
                                            "spec_id": "302",
                                            "peak_id": "118",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "84",
                                                "ion_display_position": "60",
                                                "spec_id": "302",
                                                "peak_id": "107",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "84",
                                                "ion_display_position": "60",
                                                "spec_id": "302",
                                                "peak_id": "76",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "91",
                                            "ion_display_position": "53",
                                            "spec_id": "302",
                                            "peak_id": "61",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "92",
                                            "ion_display_position": "52",
                                            "spec_id": "302",
                                            "peak_id": "33",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "97",
                                            "ion_display_position": "47",
                                            "spec_id": "302",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "106",
                                            "ion_display_position": "38",
                                            "spec_id": "302",
                                            "peak_id": "62",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "127",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "128",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "129",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "130",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "131",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "132",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "133",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "134",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "135",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "136",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "137",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "138",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "138",
                                            "ion_display_position": "6",
                                            "spec_id": "302",
                                            "peak_id": "24",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "139",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "140",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "141",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "142",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "143",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "144",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "137",
                                    "right_pos": "138",
                                    "anno": "C"
                                }
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "106",
                                "right_position": "138",
                                "shift": "247.0868063914",
                                "anno": "+247.0868",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "156",
                    "p_value": "2.19e-17",
                    "e_value": "2.19e-17",
                    "fdr": "0",
                    "matched_fragment_number": "27",
                    "matched_peak_number": "30",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "624",
                            "ms1_scans": "960",
                            "ids": "335",
                            "scans": "961",
                            "precursor_mono_mass": "16311.5248",
                            "precursor_charge": "8",
                            "precursor_mz": "2039.9479",
                            "feature_inte": "4.0888e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "12",
                        "sequence_name": "sp|P37903|USPF_ECOLI",
                        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                        "proteoform_mass": "16311.6248",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "144",
                            "first_residue_position": "0",
                            "last_residue_position": "143",
                            "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0892].",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "P"
                                },
                                {
                                    "position": "8",
                                    "acid": "I"
                                },
                                {
                                    "position": "9",
                                    "acid": "D"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "S"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "T"
                                },
                                {
                                    "position": "17",
                                    "acid": "Q"
                                },
                                {
                                    "position": "18",
                                    "acid": "R"
                                },
                                {
                                    "position": "19",
                                    "acid": "V"
                                },
                                {
                                    "position": "20",
                                    "acid": "I"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "H"
                                },
                                {
                                    "position": "23",
                                    "acid": "V"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "E"
                                },
                                {
                                    "position": "26",
                                    "acid": "E"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "K"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "D"
                                },
                                {
                                    "position": "31",
                                    "acid": "D"
                                },
                                {
                                    "position": "32",
                                    "acid": "A"
                                },
                                {
                                    "position": "33",
                                    "acid": "E"
                                },
                                {
                                    "position": "34",
                                    "acid": "V"
                                },
                                {
                                    "position": "35",
                                    "acid": "H"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "L"
                                },
                                {
                                    "position": "38",
                                    "acid": "T"
                                },
                                {
                                    "position": "39",
                                    "acid": "V"
                                },
                                {
                                    "position": "40",
                                    "acid": "I"
                                },
                                {
                                    "position": "41",
                                    "acid": "P"
                                },
                                {
                                    "position": "42",
                                    "acid": "S"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "P"
                                },
                                {
                                    "position": "45",
                                    "acid": "Y"
                                },
                                {
                                    "position": "46",
                                    "acid": "Y"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "S"
                                },
                                {
                                    "position": "49",
                                    "acid": "L"
                                },
                                {
                                    "position": "50",
                                    "acid": "G"
                                },
                                {
                                    "position": "51",
                                    "acid": "L"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "Y"
                                },
                                {
                                    "position": "54",
                                    "acid": "S"
                                },
                                {
                                    "position": "55",
                                    "acid": "A"
                                },
                                {
                                    "position": "56",
                                    "acid": "E"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "P"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "M"
                                },
                                {
                                    "position": "61",
                                    "acid": "D"
                                },
                                {
                                    "position": "62",
                                    "acid": "D"
                                },
                                {
                                    "position": "63",
                                    "acid": "L"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "A"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "K"
                                },
                                {
                                    "position": "69",
                                    "acid": "S"
                                },
                                {
                                    "position": "70",
                                    "acid": "Q"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "E"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "I"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "K"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "F"
                                },
                                {
                                    "position": "79",
                                    "acid": "K"
                                },
                                {
                                    "position": "80",
                                    "acid": "L"
                                },
                                {
                                    "position": "81",
                                    "acid": "P"
                                },
                                {
                                    "position": "82",
                                    "acid": "T"
                                },
                                {
                                    "position": "83",
                                    "acid": "D"
                                },
                                {
                                    "position": "84",
                                    "acid": "R"
                                },
                                {
                                    "position": "85",
                                    "acid": "V"
                                },
                                {
                                    "position": "86",
                                    "acid": "H"
                                },
                                {
                                    "position": "87",
                                    "acid": "V"
                                },
                                {
                                    "position": "88",
                                    "acid": "H"
                                },
                                {
                                    "position": "89",
                                    "acid": "V"
                                },
                                {
                                    "position": "90",
                                    "acid": "E"
                                },
                                {
                                    "position": "91",
                                    "acid": "E"
                                },
                                {
                                    "position": "92",
                                    "acid": "G"
                                },
                                {
                                    "position": "93",
                                    "acid": "S"
                                },
                                {
                                    "position": "94",
                                    "acid": "P"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "R"
                                },
                                {
                                    "position": "98",
                                    "acid": "I"
                                },
                                {
                                    "position": "99",
                                    "acid": "L"
                                },
                                {
                                    "position": "100",
                                    "acid": "E"
                                },
                                {
                                    "position": "101",
                                    "acid": "L"
                                },
                                {
                                    "position": "102",
                                    "acid": "A"
                                },
                                {
                                    "position": "103",
                                    "acid": "K"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "A"
                                },
                                {
                                    "position": "108",
                                    "acid": "H"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                },
                                {
                                    "position": "110",
                                    "acid": "I"
                                },
                                {
                                    "position": "111",
                                    "acid": "I"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "A"
                                },
                                {
                                    "position": "114",
                                    "acid": "S"
                                },
                                {
                                    "position": "115",
                                    "acid": "H"
                                },
                                {
                                    "position": "116",
                                    "acid": "R"
                                },
                                {
                                    "position": "117",
                                    "acid": "P"
                                },
                                {
                                    "position": "118",
                                    "acid": "D"
                                },
                                {
                                    "position": "119",
                                    "acid": "I"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "T"
                                },
                                {
                                    "position": "122",
                                    "acid": "Y"
                                },
                                {
                                    "position": "123",
                                    "acid": "L"
                                },
                                {
                                    "position": "124",
                                    "acid": "L"
                                },
                                {
                                    "position": "125",
                                    "acid": "G"
                                },
                                {
                                    "position": "126",
                                    "acid": "S"
                                },
                                {
                                    "position": "127",
                                    "acid": "N"
                                },
                                {
                                    "position": "128",
                                    "acid": "A"
                                },
                                {
                                    "position": "129",
                                    "acid": "A"
                                },
                                {
                                    "position": "130",
                                    "acid": "A"
                                },
                                {
                                    "position": "131",
                                    "acid": "V"
                                },
                                {
                                    "position": "132",
                                    "acid": "V"
                                },
                                {
                                    "position": "133",
                                    "acid": "R"
                                },
                                {
                                    "position": "134",
                                    "acid": "H"
                                },
                                {
                                    "position": "135",
                                    "acid": "A"
                                },
                                {
                                    "position": "136",
                                    "acid": "E"
                                },
                                {
                                    "position": "137",
                                    "acid": "C"
                                },
                                {
                                    "position": "138",
                                    "acid": "S"
                                },
                                {
                                    "position": "139",
                                    "acid": "V"
                                },
                                {
                                    "position": "140",
                                    "acid": "L"
                                },
                                {
                                    "position": "141",
                                    "acid": "V"
                                },
                                {
                                    "position": "142",
                                    "acid": "V"
                                },
                                {
                                    "position": "143",
                                    "acid": "R"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "3",
                                            "ion_display_position": "3",
                                            "spec_id": "335",
                                            "peak_id": "54",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "335",
                                            "peak_id": "40",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "335",
                                            "peak_id": "12",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "335",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "335",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "335",
                                            "peak_id": "24",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "335",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "335",
                                            "peak_id": "13",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "335",
                                            "peak_id": "4",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "335",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "36",
                                                "ion_display_position": "36",
                                                "spec_id": "335",
                                                "peak_id": "29",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "36",
                                                "ion_display_position": "36",
                                                "spec_id": "335",
                                                "peak_id": "89",
                                                "peak_charge": "2"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "335",
                                            "peak_id": "47",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "38",
                                                "ion_display_position": "38",
                                                "spec_id": "335",
                                                "peak_id": "75",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "38",
                                                "ion_display_position": "38",
                                                "spec_id": "335",
                                                "peak_id": "49",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "335",
                                            "peak_id": "43",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "335",
                                            "peak_id": "32",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "335",
                                            "peak_id": "83",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "57",
                                            "ion_display_position": "57",
                                            "spec_id": "335",
                                            "peak_id": "45",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "58",
                                                "ion_display_position": "86",
                                                "spec_id": "335",
                                                "peak_id": "55",
                                                "peak_charge": "6"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "58",
                                                "ion_display_position": "86",
                                                "spec_id": "335",
                                                "peak_id": "99",
                                                "peak_charge": "5"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "59",
                                            "ion_display_position": "85",
                                            "spec_id": "335",
                                            "peak_id": "80",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "62",
                                            "ion_display_position": "82",
                                            "spec_id": "335",
                                            "peak_id": "59",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "63",
                                            "ion_display_position": "81",
                                            "spec_id": "335",
                                            "peak_id": "35",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "60",
                                            "spec_id": "335",
                                            "peak_id": "36",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "91",
                                            "ion_display_position": "53",
                                            "spec_id": "335",
                                            "peak_id": "51",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "92",
                                            "ion_display_position": "52",
                                            "spec_id": "335",
                                            "peak_id": "23",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "97",
                                            "ion_display_position": "47",
                                            "spec_id": "335",
                                            "peak_id": "16",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "117",
                                            "ion_display_position": "27",
                                            "spec_id": "335",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "119",
                                            "ion_display_position": "25",
                                            "spec_id": "335",
                                            "peak_id": "20",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "127",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "128",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "129",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "130",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "131",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "132",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "133",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "134",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "135",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "136",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "137",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "138",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "139",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "140",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "141",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "142",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "143",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "144",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "137",
                                    "right_pos": "138",
                                    "anno": "C"
                                }
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "119",
                                "right_position": "144",
                                "shift": "248.0891563914",
                                "anno": "+248.0892",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "114",
                    "p_value": "2.50e-15",
                    "e_value": "2.50e-15",
                    "fdr": "0",
                    "matched_fragment_number": "25",
                    "matched_peak_number": "27",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "602",
                            "ms1_scans": "872",
                            "ids": "271",
                            "scans": "875",
                            "precursor_mono_mass": "16311.5248",
                            "precursor_charge": "8",
                            "precursor_mz": "2039.9479",
                            "feature_inte": "4.0888e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "12",
                        "sequence_name": "sp|P37903|USPF_ECOLI",
                        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                        "proteoform_mass": "16311.6098",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "144",
                            "first_residue_position": "0",
                            "last_residue_position": "143",
                            "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0742].",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "P"
                                },
                                {
                                    "position": "8",
                                    "acid": "I"
                                },
                                {
                                    "position": "9",
                                    "acid": "D"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "S"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "T"
                                },
                                {
                                    "position": "17",
                                    "acid": "Q"
                                },
                                {
                                    "position": "18",
                                    "acid": "R"
                                },
                                {
                                    "position": "19",
                                    "acid": "V"
                                },
                                {
                                    "position": "20",
                                    "acid": "I"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "H"
                                },
                                {
                                    "position": "23",
                                    "acid": "V"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "E"
                                },
                                {
                                    "position": "26",
                                    "acid": "E"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "K"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "D"
                                },
                                {
                                    "position": "31",
                                    "acid": "D"
                                },
                                {
                                    "position": "32",
                                    "acid": "A"
                                },
                                {
                                    "position": "33",
                                    "acid": "E"
                                },
                                {
                                    "position": "34",
                                    "acid": "V"
                                },
                                {
                                    "position": "35",
                                    "acid": "H"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "L"
                                },
                                {
                                    "position": "38",
                                    "acid": "T"
                                },
                                {
                                    "position": "39",
                                    "acid": "V"
                                },
                                {
                                    "position": "40",
                                    "acid": "I"
                                },
                                {
                                    "position": "41",
                                    "acid": "P"
                                },
                                {
                                    "position": "42",
                                    "acid": "S"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "P"
                                },
                                {
                                    "position": "45",
                                    "acid": "Y"
                                },
                                {
                                    "position": "46",
                                    "acid": "Y"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "S"
                                },
                                {
                                    "position": "49",
                                    "acid": "L"
                                },
                                {
                                    "position": "50",
                                    "acid": "G"
                                },
                                {
                                    "position": "51",
                                    "acid": "L"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "Y"
                                },
                                {
                                    "position": "54",
                                    "acid": "S"
                                },
                                {
                                    "position": "55",
                                    "acid": "A"
                                },
                                {
                                    "position": "56",
                                    "acid": "E"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "P"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "M"
                                },
                                {
                                    "position": "61",
                                    "acid": "D"
                                },
                                {
                                    "position": "62",
                                    "acid": "D"
                                },
                                {
                                    "position": "63",
                                    "acid": "L"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "A"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "K"
                                },
                                {
                                    "position": "69",
                                    "acid": "S"
                                },
                                {
                                    "position": "70",
                                    "acid": "Q"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "E"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "I"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "K"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "F"
                                },
                                {
                                    "position": "79",
                                    "acid": "K"
                                },
                                {
                                    "position": "80",
                                    "acid": "L"
                                },
                                {
                                    "position": "81",
                                    "acid": "P"
                                },
                                {
                                    "position": "82",
                                    "acid": "T"
                                },
                                {
                                    "position": "83",
                                    "acid": "D"
                                },
                                {
                                    "position": "84",
                                    "acid": "R"
                                },
                                {
                                    "position": "85",
                                    "acid": "V"
                                },
                                {
                                    "position": "86",
                                    "acid": "H"
                                },
                                {
                                    "position": "87",
                                    "acid": "V"
                                },
                                {
                                    "position": "88",
                                    "acid": "H"
                                },
                                {
                                    "position": "89",
                                    "acid": "V"
                                },
                                {
                                    "position": "90",
                                    "acid": "E"
                                },
                                {
                                    "position": "91",
                                    "acid": "E"
                                },
                                {
                                    "position": "92",
                                    "acid": "G"
                                },
                                {
                                    "position": "93",
                                    "acid": "S"
                                },
                                {
                                    "position": "94",
                                    "acid": "P"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "R"
                                },
                                {
                                    "position": "98",
                                    "acid": "I"
                                },
                                {
                                    "position": "99",
                                    "acid": "L"
                                },
                                {
                                    "position": "100",
                                    "acid": "E"
                                },
                                {
                                    "position": "101",
                                    "acid": "L"
                                },
                                {
                                    "position": "102",
                                    "acid": "A"
                                },
                                {
                                    "position": "103",
                                    "acid": "K"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "A"
                                },
                                {
                                    "position": "108",
                                    "acid": "H"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                },
                                {
                                    "position": "110",
                                    "acid": "I"
                                },
                                {
                                    "position": "111",
                                    "acid": "I"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "A"
                                },
                                {
                                    "position": "114",
                                    "acid": "S"
                                },
                                {
                                    "position": "115",
                                    "acid": "H"
                                },
                                {
                                    "position": "116",
                                    "acid": "R"
                                },
                                {
                                    "position": "117",
                                    "acid": "P"
                                },
                                {
                                    "position": "118",
                                    "acid": "D"
                                },
                                {
                                    "position": "119",
                                    "acid": "I"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "T"
                                },
                                {
                                    "position": "122",
                                    "acid": "Y"
                                },
                                {
                                    "position": "123",
                                    "acid": "L"
                                },
                                {
                                    "position": "124",
                                    "acid": "L"
                                },
                                {
                                    "position": "125",
                                    "acid": "G"
                                },
                                {
                                    "position": "126",
                                    "acid": "S"
                                },
                                {
                                    "position": "127",
                                    "acid": "N"
                                },
                                {
                                    "position": "128",
                                    "acid": "A"
                                },
                                {
                                    "position": "129",
                                    "acid": "A"
                                },
                                {
                                    "position": "130",
                                    "acid": "A"
                                },
                                {
                                    "position": "131",
                                    "acid": "V"
                                },
                                {
                                    "position": "132",
                                    "acid": "V"
                                },
                                {
                                    "position": "133",
                                    "acid": "R"
                                },
                                {
                                    "position": "134",
                                    "acid": "H"
                                },
                                {
                                    "position": "135",
                                    "acid": "A"
                                },
                                {
                                    "position": "136",
                                    "acid": "E"
                                },
                                {
                                    "position": "137",
                                    "acid": "C"
                                },
                                {
                                    "position": "138",
                                    "acid": "S"
                                },
                                {
                                    "position": "139",
                                    "acid": "V"
                                },
                                {
                                    "position": "140",
                                    "acid": "L"
                                },
                                {
                                    "position": "141",
                                    "acid": "V"
                                },
                                {
                                    "position": "142",
                                    "acid": "V"
                                },
                                {
                                    "position": "143",
                                    "acid": "R"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "271",
                                            "peak_id": "6",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "271",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "271",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "271",
                                            "peak_id": "10",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "21",
                                            "ion_display_position": "21",
                                            "spec_id": "271",
                                            "peak_id": "15",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "271",
                                            "peak_id": "11",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "29",
                                            "ion_display_position": "29",
                                            "spec_id": "271",
                                            "peak_id": "8",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "271",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "271",
                                            "peak_id": "7",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "271",
                                            "peak_id": "9",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "36",
                                            "ion_display_position": "36",
                                            "spec_id": "271",
                                            "peak_id": "28",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "271",
                                            "peak_id": "25",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "271",
                                                "peak_id": "100",
                                                "peak_charge": "2"
                                            },
                                            {
                                                "ion_type": "B",
                                                "ion_position": "41",
                                                "ion_display_position": "41",
                                                "spec_id": "271",
                                                "peak_id": "23",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "51",
                                            "ion_display_position": "51",
                                            "spec_id": "271",
                                            "peak_id": "54",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "57",
                                            "ion_display_position": "87",
                                            "spec_id": "271",
                                            "peak_id": "111",
                                            "peak_charge": "6"
                                        }
                                    }
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "58",
                                            "ion_display_position": "86",
                                            "spec_id": "271",
                                            "peak_id": "85",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "64",
                                            "ion_display_position": "80",
                                            "spec_id": "271",
                                            "peak_id": "60",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "65",
                                            "ion_display_position": "79",
                                            "spec_id": "271",
                                            "peak_id": "47",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "69",
                                            "ion_display_position": "75",
                                            "spec_id": "271",
                                            "peak_id": "72",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "84",
                                            "ion_display_position": "60",
                                            "spec_id": "271",
                                            "peak_id": "19",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "94",
                                                "ion_display_position": "50",
                                                "spec_id": "271",
                                                "peak_id": "53",
                                                "peak_charge": "3"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "94",
                                                "ion_display_position": "50",
                                                "spec_id": "271",
                                                "peak_id": "110",
                                                "peak_charge": "4"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "97",
                                            "ion_display_position": "47",
                                            "spec_id": "271",
                                            "peak_id": "26",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "106",
                                            "ion_display_position": "38",
                                            "spec_id": "271",
                                            "peak_id": "49",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "117",
                                            "ion_display_position": "27",
                                            "spec_id": "271",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "119",
                                            "ion_display_position": "25",
                                            "spec_id": "271",
                                            "peak_id": "27",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "127",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "128",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "129",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "130",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "131",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "132",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "133",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "134",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "135",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "136",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "137",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "138",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "139",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "140",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "141",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "142",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "143",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "144",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "137",
                                    "right_pos": "138",
                                    "anno": "C"
                                }
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "119",
                                "right_position": "144",
                                "shift": "248.0741563914",
                                "anno": "+248.0742",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                },
                {
                    "prsm_id": "159",
                    "p_value": "1.12e-12",
                    "e_value": "1.12e-12",
                    "fdr": "0",
                    "matched_fragment_number": "15",
                    "matched_peak_number": "16",
                    "ms": {
                        "ms_header": {
                            "spectrum_file_name": "C:/toppic_tutorial/tutorial_3/ecoli_1_ms2.msalign",
                            "ms1_ids": "625",
                            "ms1_scans": "964",
                            "ids": "339",
                            "scans": "966",
                            "precursor_mono_mass": "16310.4818",
                            "precursor_charge": "7",
                            "precursor_mz": "2331.0761",
                            "feature_inte": "1.9519e+07"
                        }
                    },
                    "annotated_protein": {
                        "sequence_id": "11",
                        "proteoform_id": "12",
                        "sequence_name": "sp|P37903|USPF_ECOLI",
                        "sequence_description": "Universal stress protein F OS=Escherichia coli (strain K12) OX=83333 GN=uspF PE=1 SV=2",
                        "proteoform_mass": "16311.6091",
                        "n_acetylation": "0",
                        "unexpected_shift_number": "1",
                        "annotation": {
                            "protein_length": "144",
                            "first_residue_position": "0",
                            "last_residue_position": "143",
                            "annotated_seq": ".MNRTILVPIDISDSELTQRVISHVEEEAKIDDAEVHFLTVIPSLPYYASLGLAYSAELPAMDDLKAEAKSQLEEIIKKFKLPTDRVHVHVEEGSPKDRILELAKKIPAHMIIIASHRPD(ITTYLLGSNAAAVVRHAE(C)[Carbamidomethylation]SVLVVR)[+248.0734].",
                            "residue": [
                                {
                                    "position": "0",
                                    "acid": "M"
                                },
                                {
                                    "position": "1",
                                    "acid": "N"
                                },
                                {
                                    "position": "2",
                                    "acid": "R"
                                },
                                {
                                    "position": "3",
                                    "acid": "T"
                                },
                                {
                                    "position": "4",
                                    "acid": "I"
                                },
                                {
                                    "position": "5",
                                    "acid": "L"
                                },
                                {
                                    "position": "6",
                                    "acid": "V"
                                },
                                {
                                    "position": "7",
                                    "acid": "P"
                                },
                                {
                                    "position": "8",
                                    "acid": "I"
                                },
                                {
                                    "position": "9",
                                    "acid": "D"
                                },
                                {
                                    "position": "10",
                                    "acid": "I"
                                },
                                {
                                    "position": "11",
                                    "acid": "S"
                                },
                                {
                                    "position": "12",
                                    "acid": "D"
                                },
                                {
                                    "position": "13",
                                    "acid": "S"
                                },
                                {
                                    "position": "14",
                                    "acid": "E"
                                },
                                {
                                    "position": "15",
                                    "acid": "L"
                                },
                                {
                                    "position": "16",
                                    "acid": "T"
                                },
                                {
                                    "position": "17",
                                    "acid": "Q"
                                },
                                {
                                    "position": "18",
                                    "acid": "R"
                                },
                                {
                                    "position": "19",
                                    "acid": "V"
                                },
                                {
                                    "position": "20",
                                    "acid": "I"
                                },
                                {
                                    "position": "21",
                                    "acid": "S"
                                },
                                {
                                    "position": "22",
                                    "acid": "H"
                                },
                                {
                                    "position": "23",
                                    "acid": "V"
                                },
                                {
                                    "position": "24",
                                    "acid": "E"
                                },
                                {
                                    "position": "25",
                                    "acid": "E"
                                },
                                {
                                    "position": "26",
                                    "acid": "E"
                                },
                                {
                                    "position": "27",
                                    "acid": "A"
                                },
                                {
                                    "position": "28",
                                    "acid": "K"
                                },
                                {
                                    "position": "29",
                                    "acid": "I"
                                },
                                {
                                    "position": "30",
                                    "acid": "D"
                                },
                                {
                                    "position": "31",
                                    "acid": "D"
                                },
                                {
                                    "position": "32",
                                    "acid": "A"
                                },
                                {
                                    "position": "33",
                                    "acid": "E"
                                },
                                {
                                    "position": "34",
                                    "acid": "V"
                                },
                                {
                                    "position": "35",
                                    "acid": "H"
                                },
                                {
                                    "position": "36",
                                    "acid": "F"
                                },
                                {
                                    "position": "37",
                                    "acid": "L"
                                },
                                {
                                    "position": "38",
                                    "acid": "T"
                                },
                                {
                                    "position": "39",
                                    "acid": "V"
                                },
                                {
                                    "position": "40",
                                    "acid": "I"
                                },
                                {
                                    "position": "41",
                                    "acid": "P"
                                },
                                {
                                    "position": "42",
                                    "acid": "S"
                                },
                                {
                                    "position": "43",
                                    "acid": "L"
                                },
                                {
                                    "position": "44",
                                    "acid": "P"
                                },
                                {
                                    "position": "45",
                                    "acid": "Y"
                                },
                                {
                                    "position": "46",
                                    "acid": "Y"
                                },
                                {
                                    "position": "47",
                                    "acid": "A"
                                },
                                {
                                    "position": "48",
                                    "acid": "S"
                                },
                                {
                                    "position": "49",
                                    "acid": "L"
                                },
                                {
                                    "position": "50",
                                    "acid": "G"
                                },
                                {
                                    "position": "51",
                                    "acid": "L"
                                },
                                {
                                    "position": "52",
                                    "acid": "A"
                                },
                                {
                                    "position": "53",
                                    "acid": "Y"
                                },
                                {
                                    "position": "54",
                                    "acid": "S"
                                },
                                {
                                    "position": "55",
                                    "acid": "A"
                                },
                                {
                                    "position": "56",
                                    "acid": "E"
                                },
                                {
                                    "position": "57",
                                    "acid": "L"
                                },
                                {
                                    "position": "58",
                                    "acid": "P"
                                },
                                {
                                    "position": "59",
                                    "acid": "A"
                                },
                                {
                                    "position": "60",
                                    "acid": "M"
                                },
                                {
                                    "position": "61",
                                    "acid": "D"
                                },
                                {
                                    "position": "62",
                                    "acid": "D"
                                },
                                {
                                    "position": "63",
                                    "acid": "L"
                                },
                                {
                                    "position": "64",
                                    "acid": "K"
                                },
                                {
                                    "position": "65",
                                    "acid": "A"
                                },
                                {
                                    "position": "66",
                                    "acid": "E"
                                },
                                {
                                    "position": "67",
                                    "acid": "A"
                                },
                                {
                                    "position": "68",
                                    "acid": "K"
                                },
                                {
                                    "position": "69",
                                    "acid": "S"
                                },
                                {
                                    "position": "70",
                                    "acid": "Q"
                                },
                                {
                                    "position": "71",
                                    "acid": "L"
                                },
                                {
                                    "position": "72",
                                    "acid": "E"
                                },
                                {
                                    "position": "73",
                                    "acid": "E"
                                },
                                {
                                    "position": "74",
                                    "acid": "I"
                                },
                                {
                                    "position": "75",
                                    "acid": "I"
                                },
                                {
                                    "position": "76",
                                    "acid": "K"
                                },
                                {
                                    "position": "77",
                                    "acid": "K"
                                },
                                {
                                    "position": "78",
                                    "acid": "F"
                                },
                                {
                                    "position": "79",
                                    "acid": "K"
                                },
                                {
                                    "position": "80",
                                    "acid": "L"
                                },
                                {
                                    "position": "81",
                                    "acid": "P"
                                },
                                {
                                    "position": "82",
                                    "acid": "T"
                                },
                                {
                                    "position": "83",
                                    "acid": "D"
                                },
                                {
                                    "position": "84",
                                    "acid": "R"
                                },
                                {
                                    "position": "85",
                                    "acid": "V"
                                },
                                {
                                    "position": "86",
                                    "acid": "H"
                                },
                                {
                                    "position": "87",
                                    "acid": "V"
                                },
                                {
                                    "position": "88",
                                    "acid": "H"
                                },
                                {
                                    "position": "89",
                                    "acid": "V"
                                },
                                {
                                    "position": "90",
                                    "acid": "E"
                                },
                                {
                                    "position": "91",
                                    "acid": "E"
                                },
                                {
                                    "position": "92",
                                    "acid": "G"
                                },
                                {
                                    "position": "93",
                                    "acid": "S"
                                },
                                {
                                    "position": "94",
                                    "acid": "P"
                                },
                                {
                                    "position": "95",
                                    "acid": "K"
                                },
                                {
                                    "position": "96",
                                    "acid": "D"
                                },
                                {
                                    "position": "97",
                                    "acid": "R"
                                },
                                {
                                    "position": "98",
                                    "acid": "I"
                                },
                                {
                                    "position": "99",
                                    "acid": "L"
                                },
                                {
                                    "position": "100",
                                    "acid": "E"
                                },
                                {
                                    "position": "101",
                                    "acid": "L"
                                },
                                {
                                    "position": "102",
                                    "acid": "A"
                                },
                                {
                                    "position": "103",
                                    "acid": "K"
                                },
                                {
                                    "position": "104",
                                    "acid": "K"
                                },
                                {
                                    "position": "105",
                                    "acid": "I"
                                },
                                {
                                    "position": "106",
                                    "acid": "P"
                                },
                                {
                                    "position": "107",
                                    "acid": "A"
                                },
                                {
                                    "position": "108",
                                    "acid": "H"
                                },
                                {
                                    "position": "109",
                                    "acid": "M"
                                },
                                {
                                    "position": "110",
                                    "acid": "I"
                                },
                                {
                                    "position": "111",
                                    "acid": "I"
                                },
                                {
                                    "position": "112",
                                    "acid": "I"
                                },
                                {
                                    "position": "113",
                                    "acid": "A"
                                },
                                {
                                    "position": "114",
                                    "acid": "S"
                                },
                                {
                                    "position": "115",
                                    "acid": "H"
                                },
                                {
                                    "position": "116",
                                    "acid": "R"
                                },
                                {
                                    "position": "117",
                                    "acid": "P"
                                },
                                {
                                    "position": "118",
                                    "acid": "D"
                                },
                                {
                                    "position": "119",
                                    "acid": "I"
                                },
                                {
                                    "position": "120",
                                    "acid": "T"
                                },
                                {
                                    "position": "121",
                                    "acid": "T"
                                },
                                {
                                    "position": "122",
                                    "acid": "Y"
                                },
                                {
                                    "position": "123",
                                    "acid": "L"
                                },
                                {
                                    "position": "124",
                                    "acid": "L"
                                },
                                {
                                    "position": "125",
                                    "acid": "G"
                                },
                                {
                                    "position": "126",
                                    "acid": "S"
                                },
                                {
                                    "position": "127",
                                    "acid": "N"
                                },
                                {
                                    "position": "128",
                                    "acid": "A"
                                },
                                {
                                    "position": "129",
                                    "acid": "A"
                                },
                                {
                                    "position": "130",
                                    "acid": "A"
                                },
                                {
                                    "position": "131",
                                    "acid": "V"
                                },
                                {
                                    "position": "132",
                                    "acid": "V"
                                },
                                {
                                    "position": "133",
                                    "acid": "R"
                                },
                                {
                                    "position": "134",
                                    "acid": "H"
                                },
                                {
                                    "position": "135",
                                    "acid": "A"
                                },
                                {
                                    "position": "136",
                                    "acid": "E"
                                },
                                {
                                    "position": "137",
                                    "acid": "C"
                                },
                                {
                                    "position": "138",
                                    "acid": "S"
                                },
                                {
                                    "position": "139",
                                    "acid": "V"
                                },
                                {
                                    "position": "140",
                                    "acid": "L"
                                },
                                {
                                    "position": "141",
                                    "acid": "V"
                                },
                                {
                                    "position": "142",
                                    "acid": "V"
                                },
                                {
                                    "position": "143",
                                    "acid": "R"
                                }
                            ],
                            "cleavage": [
                                {
                                    "position": "0",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "1",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "2",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "3",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "4",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "5",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "6",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "6",
                                            "ion_display_position": "6",
                                            "spec_id": "339",
                                            "peak_id": "11",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "7",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "7",
                                            "ion_display_position": "7",
                                            "spec_id": "339",
                                            "peak_id": "9",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "8",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "9",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "10",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "10",
                                            "ion_display_position": "10",
                                            "spec_id": "339",
                                            "peak_id": "4",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "11",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "12",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "13",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "13",
                                            "ion_display_position": "13",
                                            "spec_id": "339",
                                            "peak_id": "2",
                                            "peak_charge": "1"
                                        }
                                    }
                                },
                                {
                                    "position": "14",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "15",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "16",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "17",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "18",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "19",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "20",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "21",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "22",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "23",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "24",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "25",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "25",
                                            "ion_display_position": "25",
                                            "spec_id": "339",
                                            "peak_id": "22",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "26",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "27",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "28",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "29",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "30",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "31",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "31",
                                            "ion_display_position": "31",
                                            "spec_id": "339",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "32",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "32",
                                            "ion_display_position": "32",
                                            "spec_id": "339",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "33",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "34",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "35",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "36",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "37",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "37",
                                            "ion_display_position": "37",
                                            "spec_id": "339",
                                            "peak_id": "40",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "38",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "39",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "40",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "40",
                                            "ion_display_position": "40",
                                            "spec_id": "339",
                                            "peak_id": "12",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "41",
                                    "exist_n_ion": "1",
                                    "exist_c_ion": "0",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "339",
                                            "peak_id": "33",
                                            "peak_charge": "3"
                                        }
                                    }
                                },
                                {
                                    "position": "42",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "43",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "44",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "45",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "46",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "47",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "48",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "49",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "50",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "51",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "52",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "53",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "54",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "55",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "56",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "57",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "58",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "59",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "60",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "61",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "62",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "62",
                                            "ion_display_position": "82",
                                            "spec_id": "339",
                                            "peak_id": "39",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "63",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "63",
                                            "ion_display_position": "81",
                                            "spec_id": "339",
                                            "peak_id": "17",
                                            "peak_charge": "5"
                                        }
                                    }
                                },
                                {
                                    "position": "64",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "65",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "66",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "67",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "68",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "69",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "70",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "71",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "72",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "73",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "74",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "75",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "76",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "77",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "78",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "79",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "80",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "81",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "82",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "83",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "84",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "85",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "86",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "87",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "88",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "89",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "90",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "91",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "92",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "92",
                                            "ion_display_position": "52",
                                            "spec_id": "339",
                                            "peak_id": "36",
                                            "peak_charge": "4"
                                        }
                                    }
                                },
                                {
                                    "position": "93",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "94",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "95",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "96",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "97",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": [
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "97",
                                                "ion_display_position": "47",
                                                "spec_id": "339",
                                                "peak_id": "15",
                                                "peak_charge": "4"
                                            },
                                            {
                                                "ion_type": "Y",
                                                "ion_position": "97",
                                                "ion_display_position": "47",
                                                "spec_id": "339",
                                                "peak_id": "42",
                                                "peak_charge": "3"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "position": "98",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "99",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "100",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "101",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "102",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "103",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "104",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "105",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "106",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "107",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "108",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "109",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "110",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "111",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "112",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "113",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "114",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "115",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "116",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "117",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "118",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "119",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "1",
                                    "matched_peaks": {
                                        "matched_peak": {
                                            "ion_type": "Y",
                                            "ion_position": "119",
                                            "ion_display_position": "25",
                                            "spec_id": "339",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    }
                                },
                                {
                                    "position": "120",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "121",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "122",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "123",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "124",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "125",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "126",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "127",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "128",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "129",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "130",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "131",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "132",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "133",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "134",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "135",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "136",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "137",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "138",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "139",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "140",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "141",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "142",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "143",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                },
                                {
                                    "position": "144",
                                    "exist_n_ion": "0",
                                    "exist_c_ion": "0",
                                    "matched_peaks": null
                                }
                            ],
                            "ptm": {
                                "ptm_type": "Fixed",
                                "ptm": {
                                    "abbreviation": "Carbamidomethylation",
                                    "unimod": "-1",
                                    "mono_mass": "57.0214640000"
                                },
                                "occurence": {
                                    "left_pos": "137",
                                    "right_pos": "138",
                                    "anno": "C"
                                }
                            },
                            "mass_shift": {
                                "id": "0",
                                "left_position": "119",
                                "right_position": "144",
                                "shift": "248.0734363914",
                                "anno": "+248.0734",
                                "shift_type": "unexpected"
                            }
                        }
                    }
                }
            ]
        }
    }
}
